<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\FrontendCMS\Entities\DynamicPage;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $content = $this->content();
        $page = DynamicPage::where('slug','privacy-policy')->first();

        if($page)
        {
            $page->update([
                "description" => ["en" => $this->content()],
            ]);
        }else{
            DynamicPage::create([
                "title" => ['en' => "Privacy & Policy"],
                "description" => ["en" => $this->content()],
                "status" => 1,
                "is_static" => 0,
                "is_page_builder" => 0
            ]);
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        $page = DynamicPage::where('slug','privacy-policy')->first();
        if($page)
        {
            $page->update([
                "title" => ['en' => "Privacy & Policy"],
                "description" => ["en" => "Initial Content"],
            ]);
        }
    }

    public function content()
    {
        return "<span id='docs-internal-guid-55b548f3-7fff-268c-7997-53b8975985b9'><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:2pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>PRIVACY POLICY</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>&nbsp;</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>INTRODUCTION</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>This privacy policy explains how Amazcart use and protect the information we hold, whether it relates to the e-commerce . This privacy policy does not require any physical, electronic or digital signature. We are committed to maintaining the privacy of our users of our website/application.</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>This privacy policy governs your use of the application </span><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>Amazcart</span><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>. By entering to this Website or downloading the app via Play Store /App Store you agree to be bound by the terms and conditions of this Privacy Policy. If you do not agree, please do not use or access our website/application. By mere use of the website/application, you expressly consent to our use and disclosure of your personal information in accordance with this Privacy Policy. It is incorporated into and subject to the Terms and Conditions.</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:2pt;'><b style='font-weight:normal;' id='docs-internal-guid-c7b37078-7fff-7706-ccb2-88a26124fb7d'><br></b></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>Please read this privacy policy (‘Policy’) carefully before using the Application, Website and our services along with the Terms and Conditions (‘TaC’) provided on the Application and the Website. Your use of the Website, Application, or&nbsp; services in connection with the Application or Website (‘Services’), or registrations with us through any modes or usage of any products shall signify your acceptance of this Policy and your agreement to be legally bound by the same.&nbsp;</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:2pt;'><b style='font-weight:normal;'><br></b></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>We may change this Privacy Policy from time to time. If we make changes, we will notify you by revising the date at the top of this policy, and in some cases, we may provide you with additional notice (such as adding a statement to the homepages of our websites/applications or sending you an email notification). We encourage you to review the Privacy Policy whenever you interact with us to stay informed about our information practices and the ways you can help protect your privacy.</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>&nbsp;</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>DEFINITION OF NEEDED INFORMATION</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>Needed information means information about an customer or identifiable individual or information that permits an individual to be identified.&nbsp;</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>&nbsp;</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>COLLECTION OF INFORMATION</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>Amazcart is a smart software service, it takes responsibility for maintaining and protecting the personal information under our control.&nbsp;</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:2pt;'><b style='font-weight:normal;'><br></b></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>USER PROVIDED INFORMATION</span><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>&nbsp;</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>The Application/Website/Services obtains the information you provide when you download and register for the Application or Services. When the customer&nbsp; register with us, generally has to provide (a) Name , (b) Email, (c) Password and&nbsp; (d) Refer and also provide the (e) Addres for delivery while check order.</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>&nbsp;</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>AUTOMATICALLY COLLECTED INFORMATION</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>In addition, the Application/products/Services may collect certain information automatically, including, but not limited to, the type of mobile device you use, your mobile devices unique device ID, the IP address of your mobile device, your mobile operating system, the type of mobile Internet browsers you use, and information about the way you use the Application/Services. As is true of most Mobile applications, we also collect other relevant information as per the permissions that you provide.</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>&nbsp;</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>PROVIDE SERVICE</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>To personalize user experience we may use information. We continually strive to improve our website/Application offerings based on the information and feedback we receive from you.&nbsp; The User can completely customize our service web or application.</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:2pt;'><b style='font-weight:normal;'><br></b></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>CONTACTING AND CUSTOMER SERVICE</span><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>&nbsp;</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>You will be contacted as necessary to enforce our User Agreement, applicable national laws, and any agreement we may have with you. It will help us contact you to notify you regarding your account, to troubleshoot problems with your account, to resolve a dispute, as otherwise necessary to provide you customer service.&nbsp;</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>For these purposes we may contact you via email, telephone, text messages, WhatsApp messages and postal mail. When contacting you via telephone, to ensure efficiency, we may use autodialer or pre-recorded calls and text messages.</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:2pt;'><b style='font-weight:normal;'><br><br></b></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>PREVENT FRAUDULENT AND ILLEGAL ACTIVITIES</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>We preserve your personal information as long as it is necessary and relevant for our operations. In addition, we may retain personal information from closed accounts to comply with national laws, prevent fraud, collect any fees owed, resolve disputes, troubleshoot problems, assist with any investigation, enforce our User Agreement and take other actions permitted or required by applicable national laws. After it is no longer necessary for us to retain your personal information, we dispose of it in a secure manner according to our data retention and deletion policies.</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>It will help us prevent, detect, mitigate, and investigate fraud, security breaches, potentially prohibited or illegal activities. It will also be used to enforce our Privacy Notice, our User Agreement or other policies.</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:2pt;'><b style='font-weight:normal;'><br><br></b></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>&nbsp;</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>SECURITY</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>We are concerned about safeguarding the confidentiality of your Information. We take all precautions to protect the Personal Information both online and offline. We provide physical, electronic, and procedural safeguards to protect Information we process and maintain. We protect the information using technical and administrative security measures to reduce the risks of loss, misuse, unauthorized access, disclosure and alteration. If you believe your account has been abused, please contact us</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:2pt;'><b style='font-weight:normal;'><br></b></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>We do not sell or rent your personal information to third parties for their marketing purposes without your explicit consent and we only use your information as described in the Privacy Policy. We view protection of your privacy as a very important community principle. We understand clearly that you and Your Information is one of our most important assets.&nbsp;</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:2pt;'><b style='font-weight:normal;'><br></b></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>Under no circumstances do we rent, trade or share the institutional/personal information that we have collected with any other company for their marketing purposes without your consent. We reserve the right to communicate your personal information to any third party that makes a legally-compliant request for its disclosure.</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:2pt;'><b style='font-weight:normal;'><br></b></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>&nbsp;</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>THE GENERAL DATA PROTECTION REGULATION(GDPR)</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>If you are a resident of the European Economic Area (EEA), you have certain data protection rights. Amazcart to take reasonable steps to allow you to correct, amend, delete, or limit the use of your Personal Data.</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>If you wish to be informed what Personal Data we hold about you and if you want it to be removed from our systems, please contact us.</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>In certain circumstances, you have the following data protection rights:</span></p><ol style='margin-top:0;margin-bottom:0;padding-inline-start:48px;'><li dir='ltr' style='list-style-type:decimal;font-size:12pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;' aria-level='1'><p dir='ltr' style='line-height:1.38;margin-top:12pt;margin-bottom:0pt;' role='presentation'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>The right to access, update or to delete the information we have on you.</span><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'> Whenever made possible, you can access, update or request deletion of your Personal Data directly within your account settings section. If you are unable to perform these actions yourself, please contact us to assist you.</span></p></li><li dir='ltr' style='list-style-type:decimal;font-size:12pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;' aria-level='1'><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;' role='presentation'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>The right of rectification. </span><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>You have the right to have your information rectified if that information is inaccurate or incomplete.</span></p></li><li dir='ltr' style='list-style-type:decimal;font-size:12pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;' aria-level='1'><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;' role='presentation'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>The right to object. </span><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>You have the right to object to our processing of your Personal Data.</span></p></li><li dir='ltr' style='list-style-type:decimal;font-size:12pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;' aria-level='1'><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;' role='presentation'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>The right of restriction.</span><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'> You have the right to request that we restrict the processing of your personal information.</span></p></li><li dir='ltr' style='list-style-type:decimal;font-size:12pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;' aria-level='1'><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;' role='presentation'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>The right to data portability.</span><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'> You have the right to be provided with a copy of the information we have on you in a structured, machine-readable and commonly used format.</span></p></li><li dir='ltr' style='list-style-type:decimal;font-size:12pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;' aria-level='1'><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:12pt;' role='presentation'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>The right to withdraw consent</span><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>. You also have the right to withdraw your consent at any time where Digital Marketer Labs, LLC relied on your consent to process your personal information.</span></p></li></ol><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>Please note that we may ask you to verify your identity before responding to such requests.</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>You have the right to complain to a Data Protection Authority about our collection and use of your Personal Data. For more information, please contact your local data protection authority in the European Economic Area (EEA).</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:2pt;'><b style='font-weight:normal;'><br></b></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>&nbsp;</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>CONSENT</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>We believe that, every user of our Application/Services/Website must be in a position to provide an informed consent prior to providing any Information required for the use of them Application/Services/Website.&nbsp;</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>By registering with us , you are expressly consenting to our collection, processing, storing, disclosing and handling of your information as set forth in this Policy now and as amended by us. Processing, your information in any way, including, but not limited to, collecting, storing, deleting, using, combining, sharing, transferring and disclosing information, all of which activities will take place in Bangladesh. If you reside outside Bangladesh your information will be transferred, processed and stored in accordance with the applicable data protection laws of Bangladesh.</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:2pt;'><b style='font-weight:normal;'><br></b></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>&nbsp;</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>CHANGES TO THIS STATEMENT</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>As the Company evolves, our privacy policy will need to evolve as well to cover new situations.&nbsp; You are advised to review this Policy regularly for any changes, as continued use is deemed approval of all changes.</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:0pt;'><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>We may at any time modify the Terms of our Website without any prior notification to you. Should you wish to terminate your account due to a modification to the Terms or the Privacy Policy, you may do so email us at </span><span style='font-size:12pt;font-family:Nunito,sans-serif;color:#d2910f;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;'>support@spondonit.com</span></p><p dir='ltr' style='line-height:1.38;margin-top:0pt;margin-bottom:2pt;'><br></p></span>";
    }
};
