/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@popperjs/core/lib/createPopper.js":
/*!*********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/createPopper.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createPopper": () => (/* binding */ createPopper),
/* harmony export */   "detectOverflow": () => (/* reexport safe */ _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_13__["default"]),
/* harmony export */   "popperGenerator": () => (/* binding */ popperGenerator)
/* harmony export */ });
/* harmony import */ var _dom_utils_getCompositeRect_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./dom-utils/getCompositeRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getCompositeRect.js");
/* harmony import */ var _dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./dom-utils/getLayoutRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js");
/* harmony import */ var _dom_utils_listScrollParents_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./dom-utils/listScrollParents.js */ "./node_modules/@popperjs/core/lib/dom-utils/listScrollParents.js");
/* harmony import */ var _dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./dom-utils/getOffsetParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _dom_utils_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./dom-utils/getComputedStyle.js */ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");
/* harmony import */ var _utils_orderModifiers_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils/orderModifiers.js */ "./node_modules/@popperjs/core/lib/utils/orderModifiers.js");
/* harmony import */ var _utils_debounce_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./utils/debounce.js */ "./node_modules/@popperjs/core/lib/utils/debounce.js");
/* harmony import */ var _utils_validateModifiers_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./utils/validateModifiers.js */ "./node_modules/@popperjs/core/lib/utils/validateModifiers.js");
/* harmony import */ var _utils_uniqueBy_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils/uniqueBy.js */ "./node_modules/@popperjs/core/lib/utils/uniqueBy.js");
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./utils/getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _utils_mergeByName_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils/mergeByName.js */ "./node_modules/@popperjs/core/lib/utils/mergeByName.js");
/* harmony import */ var _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./utils/detectOverflow.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./dom-utils/instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./enums.js */ "./node_modules/@popperjs/core/lib/enums.js");














var INVALID_ELEMENT_ERROR = 'Popper: Invalid reference or popper argument provided. They must be either a DOM element or virtual element.';
var INFINITE_LOOP_ERROR = 'Popper: An infinite loop in the modifiers cycle has been detected! The cycle has been interrupted to prevent a browser crash.';
var DEFAULT_OPTIONS = {
  placement: 'bottom',
  modifiers: [],
  strategy: 'absolute'
};

function areValidElements() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  return !args.some(function (element) {
    return !(element && typeof element.getBoundingClientRect === 'function');
  });
}

function popperGenerator(generatorOptions) {
  if (generatorOptions === void 0) {
    generatorOptions = {};
  }

  var _generatorOptions = generatorOptions,
      _generatorOptions$def = _generatorOptions.defaultModifiers,
      defaultModifiers = _generatorOptions$def === void 0 ? [] : _generatorOptions$def,
      _generatorOptions$def2 = _generatorOptions.defaultOptions,
      defaultOptions = _generatorOptions$def2 === void 0 ? DEFAULT_OPTIONS : _generatorOptions$def2;
  return function createPopper(reference, popper, options) {
    if (options === void 0) {
      options = defaultOptions;
    }

    var state = {
      placement: 'bottom',
      orderedModifiers: [],
      options: Object.assign({}, DEFAULT_OPTIONS, defaultOptions),
      modifiersData: {},
      elements: {
        reference: reference,
        popper: popper
      },
      attributes: {},
      styles: {}
    };
    var effectCleanupFns = [];
    var isDestroyed = false;
    var instance = {
      state: state,
      setOptions: function setOptions(setOptionsAction) {
        var options = typeof setOptionsAction === 'function' ? setOptionsAction(state.options) : setOptionsAction;
        cleanupModifierEffects();
        state.options = Object.assign({}, defaultOptions, state.options, options);
        state.scrollParents = {
          reference: (0,_dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isElement)(reference) ? (0,_dom_utils_listScrollParents_js__WEBPACK_IMPORTED_MODULE_1__["default"])(reference) : reference.contextElement ? (0,_dom_utils_listScrollParents_js__WEBPACK_IMPORTED_MODULE_1__["default"])(reference.contextElement) : [],
          popper: (0,_dom_utils_listScrollParents_js__WEBPACK_IMPORTED_MODULE_1__["default"])(popper)
        }; // Orders the modifiers based on their dependencies and `phase`
        // properties

        var orderedModifiers = (0,_utils_orderModifiers_js__WEBPACK_IMPORTED_MODULE_2__["default"])((0,_utils_mergeByName_js__WEBPACK_IMPORTED_MODULE_3__["default"])([].concat(defaultModifiers, state.options.modifiers))); // Strip out disabled modifiers

        state.orderedModifiers = orderedModifiers.filter(function (m) {
          return m.enabled;
        }); // Validate the provided modifiers so that the consumer will get warned
        // if one of the modifiers is invalid for any reason

        if (true) {
          var modifiers = (0,_utils_uniqueBy_js__WEBPACK_IMPORTED_MODULE_4__["default"])([].concat(orderedModifiers, state.options.modifiers), function (_ref) {
            var name = _ref.name;
            return name;
          });
          (0,_utils_validateModifiers_js__WEBPACK_IMPORTED_MODULE_5__["default"])(modifiers);

          if ((0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_6__["default"])(state.options.placement) === _enums_js__WEBPACK_IMPORTED_MODULE_7__.auto) {
            var flipModifier = state.orderedModifiers.find(function (_ref2) {
              var name = _ref2.name;
              return name === 'flip';
            });

            if (!flipModifier) {
              console.error(['Popper: "auto" placements require the "flip" modifier be', 'present and enabled to work.'].join(' '));
            }
          }

          var _getComputedStyle = (0,_dom_utils_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_8__["default"])(popper),
              marginTop = _getComputedStyle.marginTop,
              marginRight = _getComputedStyle.marginRight,
              marginBottom = _getComputedStyle.marginBottom,
              marginLeft = _getComputedStyle.marginLeft; // We no longer take into account `margins` on the popper, and it can
          // cause bugs with positioning, so we'll warn the consumer


          if ([marginTop, marginRight, marginBottom, marginLeft].some(function (margin) {
            return parseFloat(margin);
          })) {
            console.warn(['Popper: CSS "margin" styles cannot be used to apply padding', 'between the popper and its reference element or boundary.', 'To replicate margin, use the `offset` modifier, as well as', 'the `padding` option in the `preventOverflow` and `flip`', 'modifiers.'].join(' '));
          }
        }

        runModifierEffects();
        return instance.update();
      },
      // Sync update – it will always be executed, even if not necessary. This
      // is useful for low frequency updates where sync behavior simplifies the
      // logic.
      // For high frequency updates (e.g. `resize` and `scroll` events), always
      // prefer the async Popper#update method
      forceUpdate: function forceUpdate() {
        if (isDestroyed) {
          return;
        }

        var _state$elements = state.elements,
            reference = _state$elements.reference,
            popper = _state$elements.popper; // Don't proceed if `reference` or `popper` are not valid elements
        // anymore

        if (!areValidElements(reference, popper)) {
          if (true) {
            console.error(INVALID_ELEMENT_ERROR);
          }

          return;
        } // Store the reference and popper rects to be read by modifiers


        state.rects = {
          reference: (0,_dom_utils_getCompositeRect_js__WEBPACK_IMPORTED_MODULE_9__["default"])(reference, (0,_dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_10__["default"])(popper), state.options.strategy === 'fixed'),
          popper: (0,_dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_11__["default"])(popper)
        }; // Modifiers have the ability to reset the current update cycle. The
        // most common use case for this is the `flip` modifier changing the
        // placement, which then needs to re-run all the modifiers, because the
        // logic was previously ran for the previous placement and is therefore
        // stale/incorrect

        state.reset = false;
        state.placement = state.options.placement; // On each update cycle, the `modifiersData` property for each modifier
        // is filled with the initial data specified by the modifier. This means
        // it doesn't persist and is fresh on each update.
        // To ensure persistent data, use `${name}#persistent`

        state.orderedModifiers.forEach(function (modifier) {
          return state.modifiersData[modifier.name] = Object.assign({}, modifier.data);
        });
        var __debug_loops__ = 0;

        for (var index = 0; index < state.orderedModifiers.length; index++) {
          if (true) {
            __debug_loops__ += 1;

            if (__debug_loops__ > 100) {
              console.error(INFINITE_LOOP_ERROR);
              break;
            }
          }

          if (state.reset === true) {
            state.reset = false;
            index = -1;
            continue;
          }

          var _state$orderedModifie = state.orderedModifiers[index],
              fn = _state$orderedModifie.fn,
              _state$orderedModifie2 = _state$orderedModifie.options,
              _options = _state$orderedModifie2 === void 0 ? {} : _state$orderedModifie2,
              name = _state$orderedModifie.name;

          if (typeof fn === 'function') {
            state = fn({
              state: state,
              options: _options,
              name: name,
              instance: instance
            }) || state;
          }
        }
      },
      // Async and optimistically optimized update – it will not be executed if
      // not necessary (debounced to run at most once-per-tick)
      update: (0,_utils_debounce_js__WEBPACK_IMPORTED_MODULE_12__["default"])(function () {
        return new Promise(function (resolve) {
          instance.forceUpdate();
          resolve(state);
        });
      }),
      destroy: function destroy() {
        cleanupModifierEffects();
        isDestroyed = true;
      }
    };

    if (!areValidElements(reference, popper)) {
      if (true) {
        console.error(INVALID_ELEMENT_ERROR);
      }

      return instance;
    }

    instance.setOptions(options).then(function (state) {
      if (!isDestroyed && options.onFirstUpdate) {
        options.onFirstUpdate(state);
      }
    }); // Modifiers have the ability to execute arbitrary code before the first
    // update cycle runs. They will be executed in the same order as the update
    // cycle. This is useful when a modifier adds some persistent data that
    // other modifiers need to use, but the modifier is run after the dependent
    // one.

    function runModifierEffects() {
      state.orderedModifiers.forEach(function (_ref3) {
        var name = _ref3.name,
            _ref3$options = _ref3.options,
            options = _ref3$options === void 0 ? {} : _ref3$options,
            effect = _ref3.effect;

        if (typeof effect === 'function') {
          var cleanupFn = effect({
            state: state,
            name: name,
            instance: instance,
            options: options
          });

          var noopFn = function noopFn() {};

          effectCleanupFns.push(cleanupFn || noopFn);
        }
      });
    }

    function cleanupModifierEffects() {
      effectCleanupFns.forEach(function (fn) {
        return fn();
      });
      effectCleanupFns = [];
    }

    return instance;
  };
}
var createPopper = /*#__PURE__*/popperGenerator(); // eslint-disable-next-line import/no-unused-modules



/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/contains.js":
/*!***************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/contains.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ contains)
/* harmony export */ });
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");

function contains(parent, child) {
  var rootNode = child.getRootNode && child.getRootNode(); // First, attempt with faster native method

  if (parent.contains(child)) {
    return true;
  } // then fallback to custom implementation with Shadow DOM support
  else if (rootNode && (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isShadowRoot)(rootNode)) {
      var next = child;

      do {
        if (next && parent.isSameNode(next)) {
          return true;
        } // $FlowFixMe[prop-missing]: need a better way to handle this...


        next = next.parentNode || next.host;
      } while (next);
    } // Give up, the result is false


  return false;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getBoundingClientRect)
/* harmony export */ });
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");


function getBoundingClientRect(element, includeScale) {
  if (includeScale === void 0) {
    includeScale = false;
  }

  var rect = element.getBoundingClientRect();
  var scaleX = 1;
  var scaleY = 1;

  if ((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element) && includeScale) {
    var offsetHeight = element.offsetHeight;
    var offsetWidth = element.offsetWidth; // Do not attempt to divide by 0, otherwise we get `Infinity` as scale
    // Fallback to 1 in case both values are `0`

    if (offsetWidth > 0) {
      scaleX = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_1__.round)(rect.width) / offsetWidth || 1;
    }

    if (offsetHeight > 0) {
      scaleY = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_1__.round)(rect.height) / offsetHeight || 1;
    }
  }

  return {
    width: rect.width / scaleX,
    height: rect.height / scaleY,
    top: rect.top / scaleY,
    right: rect.right / scaleX,
    bottom: rect.bottom / scaleY,
    left: rect.left / scaleX,
    x: rect.left / scaleX,
    y: rect.top / scaleY
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getClippingRect.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getClippingRect.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getClippingRect)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _getViewportRect_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getViewportRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getViewportRect.js");
/* harmony import */ var _getDocumentRect_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./getDocumentRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentRect.js");
/* harmony import */ var _listScrollParents_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./listScrollParents.js */ "./node_modules/@popperjs/core/lib/dom-utils/listScrollParents.js");
/* harmony import */ var _getOffsetParent_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./getOffsetParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _getComputedStyle_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./getComputedStyle.js */ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getBoundingClientRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
/* harmony import */ var _getParentNode_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./getParentNode.js */ "./node_modules/@popperjs/core/lib/dom-utils/getParentNode.js");
/* harmony import */ var _contains_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./contains.js */ "./node_modules/@popperjs/core/lib/dom-utils/contains.js");
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _utils_rectToClientRect_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/rectToClientRect.js */ "./node_modules/@popperjs/core/lib/utils/rectToClientRect.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../utils/math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");















function getInnerBoundingClientRect(element) {
  var rect = (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element);
  rect.top = rect.top + element.clientTop;
  rect.left = rect.left + element.clientLeft;
  rect.bottom = rect.top + element.clientHeight;
  rect.right = rect.left + element.clientWidth;
  rect.width = element.clientWidth;
  rect.height = element.clientHeight;
  rect.x = rect.left;
  rect.y = rect.top;
  return rect;
}

function getClientRectFromMixedType(element, clippingParent) {
  return clippingParent === _enums_js__WEBPACK_IMPORTED_MODULE_1__.viewport ? (0,_utils_rectToClientRect_js__WEBPACK_IMPORTED_MODULE_2__["default"])((0,_getViewportRect_js__WEBPACK_IMPORTED_MODULE_3__["default"])(element)) : (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_4__.isElement)(clippingParent) ? getInnerBoundingClientRect(clippingParent) : (0,_utils_rectToClientRect_js__WEBPACK_IMPORTED_MODULE_2__["default"])((0,_getDocumentRect_js__WEBPACK_IMPORTED_MODULE_5__["default"])((0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_6__["default"])(element)));
} // A "clipping parent" is an overflowable container with the characteristic of
// clipping (or hiding) overflowing elements with a position different from
// `initial`


function getClippingParents(element) {
  var clippingParents = (0,_listScrollParents_js__WEBPACK_IMPORTED_MODULE_7__["default"])((0,_getParentNode_js__WEBPACK_IMPORTED_MODULE_8__["default"])(element));
  var canEscapeClipping = ['absolute', 'fixed'].indexOf((0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_9__["default"])(element).position) >= 0;
  var clipperElement = canEscapeClipping && (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_4__.isHTMLElement)(element) ? (0,_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_10__["default"])(element) : element;

  if (!(0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_4__.isElement)(clipperElement)) {
    return [];
  } // $FlowFixMe[incompatible-return]: https://github.com/facebook/flow/issues/1414


  return clippingParents.filter(function (clippingParent) {
    return (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_4__.isElement)(clippingParent) && (0,_contains_js__WEBPACK_IMPORTED_MODULE_11__["default"])(clippingParent, clipperElement) && (0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_12__["default"])(clippingParent) !== 'body';
  });
} // Gets the maximum area that the element is visible in due to any number of
// clipping parents


function getClippingRect(element, boundary, rootBoundary) {
  var mainClippingParents = boundary === 'clippingParents' ? getClippingParents(element) : [].concat(boundary);
  var clippingParents = [].concat(mainClippingParents, [rootBoundary]);
  var firstClippingParent = clippingParents[0];
  var clippingRect = clippingParents.reduce(function (accRect, clippingParent) {
    var rect = getClientRectFromMixedType(element, clippingParent);
    accRect.top = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_13__.max)(rect.top, accRect.top);
    accRect.right = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_13__.min)(rect.right, accRect.right);
    accRect.bottom = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_13__.min)(rect.bottom, accRect.bottom);
    accRect.left = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_13__.max)(rect.left, accRect.left);
    return accRect;
  }, getClientRectFromMixedType(element, firstClippingParent));
  clippingRect.width = clippingRect.right - clippingRect.left;
  clippingRect.height = clippingRect.bottom - clippingRect.top;
  clippingRect.x = clippingRect.left;
  clippingRect.y = clippingRect.top;
  return clippingRect;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getCompositeRect.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getCompositeRect.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getCompositeRect)
/* harmony export */ });
/* harmony import */ var _getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getBoundingClientRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
/* harmony import */ var _getNodeScroll_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./getNodeScroll.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeScroll.js");
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./getWindowScrollBarX.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _isScrollParent_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./isScrollParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");









function isElementScaled(element) {
  var rect = element.getBoundingClientRect();
  var scaleX = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_0__.round)(rect.width) / element.offsetWidth || 1;
  var scaleY = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_0__.round)(rect.height) / element.offsetHeight || 1;
  return scaleX !== 1 || scaleY !== 1;
} // Returns the composite rect of an element relative to its offsetParent.
// Composite means it takes into account transforms as well as layout.


function getCompositeRect(elementOrVirtualElement, offsetParent, isFixed) {
  if (isFixed === void 0) {
    isFixed = false;
  }

  var isOffsetParentAnElement = (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isHTMLElement)(offsetParent);
  var offsetParentIsScaled = (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isHTMLElement)(offsetParent) && isElementScaled(offsetParent);
  var documentElement = (0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(offsetParent);
  var rect = (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_3__["default"])(elementOrVirtualElement, offsetParentIsScaled);
  var scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  var offsets = {
    x: 0,
    y: 0
  };

  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if ((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_4__["default"])(offsetParent) !== 'body' || // https://github.com/popperjs/popper-core/issues/1078
    (0,_isScrollParent_js__WEBPACK_IMPORTED_MODULE_5__["default"])(documentElement)) {
      scroll = (0,_getNodeScroll_js__WEBPACK_IMPORTED_MODULE_6__["default"])(offsetParent);
    }

    if ((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isHTMLElement)(offsetParent)) {
      offsets = (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_3__["default"])(offsetParent, true);
      offsets.x += offsetParent.clientLeft;
      offsets.y += offsetParent.clientTop;
    } else if (documentElement) {
      offsets.x = (0,_getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_7__["default"])(documentElement);
    }
  }

  return {
    x: rect.left + scroll.scrollLeft - offsets.x,
    y: rect.top + scroll.scrollTop - offsets.y,
    width: rect.width,
    height: rect.height
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getComputedStyle)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");

function getComputedStyle(element) {
  return (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element).getComputedStyle(element);
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getDocumentElement)
/* harmony export */ });
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");

function getDocumentElement(element) {
  // $FlowFixMe[incompatible-return]: assume body is always available
  return (((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isElement)(element) ? element.ownerDocument : // $FlowFixMe[prop-missing]
  element.document) || window.document).documentElement;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentRect.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getDocumentRect.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getDocumentRect)
/* harmony export */ });
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _getComputedStyle_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getComputedStyle.js */ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");
/* harmony import */ var _getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getWindowScrollBarX.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js");
/* harmony import */ var _getWindowScroll_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getWindowScroll.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");




 // Gets the entire size of the scrollable document area, even extending outside
// of the `<html>` and `<body>` rect bounds if horizontally scrollable

function getDocumentRect(element) {
  var _element$ownerDocumen;

  var html = (0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element);
  var winScroll = (0,_getWindowScroll_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element);
  var body = (_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body;
  var width = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_2__.max)(html.scrollWidth, html.clientWidth, body ? body.scrollWidth : 0, body ? body.clientWidth : 0);
  var height = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_2__.max)(html.scrollHeight, html.clientHeight, body ? body.scrollHeight : 0, body ? body.clientHeight : 0);
  var x = -winScroll.scrollLeft + (0,_getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_3__["default"])(element);
  var y = -winScroll.scrollTop;

  if ((0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_4__["default"])(body || html).direction === 'rtl') {
    x += (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_2__.max)(html.clientWidth, body ? body.clientWidth : 0) - width;
  }

  return {
    width: width,
    height: height,
    x: x,
    y: y
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getHTMLElementScroll.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getHTMLElementScroll.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getHTMLElementScroll)
/* harmony export */ });
function getHTMLElementScroll(element) {
  return {
    scrollLeft: element.scrollLeft,
    scrollTop: element.scrollTop
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js":
/*!********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getLayoutRect)
/* harmony export */ });
/* harmony import */ var _getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getBoundingClientRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
 // Returns the layout rect of an element relative to its offsetParent. Layout
// means it doesn't take into account transforms.

function getLayoutRect(element) {
  var clientRect = (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element); // Use the clientRect sizes if it's not been transformed.
  // Fixes https://github.com/popperjs/popper-core/issues/1223

  var width = element.offsetWidth;
  var height = element.offsetHeight;

  if (Math.abs(clientRect.width - width) <= 1) {
    width = clientRect.width;
  }

  if (Math.abs(clientRect.height - height) <= 1) {
    height = clientRect.height;
  }

  return {
    x: element.offsetLeft,
    y: element.offsetTop,
    width: width,
    height: height
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js":
/*!******************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getNodeName)
/* harmony export */ });
function getNodeName(element) {
  return element ? (element.nodeName || '').toLowerCase() : null;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getNodeScroll.js":
/*!********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getNodeScroll.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getNodeScroll)
/* harmony export */ });
/* harmony import */ var _getWindowScroll_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getWindowScroll.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js");
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _getHTMLElementScroll_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getHTMLElementScroll.js */ "./node_modules/@popperjs/core/lib/dom-utils/getHTMLElementScroll.js");




function getNodeScroll(node) {
  if (node === (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node) || !(0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isHTMLElement)(node)) {
    return (0,_getWindowScroll_js__WEBPACK_IMPORTED_MODULE_2__["default"])(node);
  } else {
    return (0,_getHTMLElementScroll_js__WEBPACK_IMPORTED_MODULE_3__["default"])(node);
  }
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getOffsetParent)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getComputedStyle.js */ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _isTableElement_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./isTableElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/isTableElement.js");
/* harmony import */ var _getParentNode_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getParentNode.js */ "./node_modules/@popperjs/core/lib/dom-utils/getParentNode.js");







function getTrueOffsetParent(element) {
  if (!(0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element) || // https://github.com/popperjs/popper-core/issues/837
  (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element).position === 'fixed') {
    return null;
  }

  return element.offsetParent;
} // `.offsetParent` reports `null` for fixed elements, while absolute elements
// return the containing block


function getContainingBlock(element) {
  var isFirefox = navigator.userAgent.toLowerCase().indexOf('firefox') !== -1;
  var isIE = navigator.userAgent.indexOf('Trident') !== -1;

  if (isIE && (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element)) {
    // In IE 9, 10 and 11 fixed elements containing block is always established by the viewport
    var elementCss = (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element);

    if (elementCss.position === 'fixed') {
      return null;
    }
  }

  var currentNode = (0,_getParentNode_js__WEBPACK_IMPORTED_MODULE_2__["default"])(element);

  if ((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isShadowRoot)(currentNode)) {
    currentNode = currentNode.host;
  }

  while ((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(currentNode) && ['html', 'body'].indexOf((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_3__["default"])(currentNode)) < 0) {
    var css = (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__["default"])(currentNode); // This is non-exhaustive but covers the most common CSS properties that
    // create a containing block.
    // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block

    if (css.transform !== 'none' || css.perspective !== 'none' || css.contain === 'paint' || ['transform', 'perspective'].indexOf(css.willChange) !== -1 || isFirefox && css.willChange === 'filter' || isFirefox && css.filter && css.filter !== 'none') {
      return currentNode;
    } else {
      currentNode = currentNode.parentNode;
    }
  }

  return null;
} // Gets the closest ancestor positioned element. Handles some edge cases,
// such as table ancestors and cross browser bugs.


function getOffsetParent(element) {
  var window = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_4__["default"])(element);
  var offsetParent = getTrueOffsetParent(element);

  while (offsetParent && (0,_isTableElement_js__WEBPACK_IMPORTED_MODULE_5__["default"])(offsetParent) && (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__["default"])(offsetParent).position === 'static') {
    offsetParent = getTrueOffsetParent(offsetParent);
  }

  if (offsetParent && ((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_3__["default"])(offsetParent) === 'html' || (0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_3__["default"])(offsetParent) === 'body' && (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__["default"])(offsetParent).position === 'static')) {
    return window;
  }

  return offsetParent || getContainingBlock(element) || window;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getParentNode.js":
/*!********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getParentNode.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getParentNode)
/* harmony export */ });
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");



function getParentNode(element) {
  if ((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element) === 'html') {
    return element;
  }

  return (// this is a quicker (but less type safe) way to save quite some bytes from the bundle
    // $FlowFixMe[incompatible-return]
    // $FlowFixMe[prop-missing]
    element.assignedSlot || // step into the shadow DOM of the parent of a slotted node
    element.parentNode || ( // DOM Element detected
    (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isShadowRoot)(element) ? element.host : null) || // ShadowRoot detected
    // $FlowFixMe[incompatible-call]: HTMLElement is a Node
    (0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(element) // fallback

  );
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getScrollParent.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getScrollParent.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getScrollParent)
/* harmony export */ });
/* harmony import */ var _getParentNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getParentNode.js */ "./node_modules/@popperjs/core/lib/dom-utils/getParentNode.js");
/* harmony import */ var _isScrollParent_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./isScrollParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js");
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");




function getScrollParent(node) {
  if (['html', 'body', '#document'].indexOf((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node)) >= 0) {
    // $FlowFixMe[incompatible-return]: assume body is always available
    return node.ownerDocument.body;
  }

  if ((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isHTMLElement)(node) && (0,_isScrollParent_js__WEBPACK_IMPORTED_MODULE_2__["default"])(node)) {
    return node;
  }

  return getScrollParent((0,_getParentNode_js__WEBPACK_IMPORTED_MODULE_3__["default"])(node));
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getViewportRect.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getViewportRect.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getViewportRect)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getWindowScrollBarX.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js");



function getViewportRect(element) {
  var win = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element);
  var html = (0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element);
  var visualViewport = win.visualViewport;
  var width = html.clientWidth;
  var height = html.clientHeight;
  var x = 0;
  var y = 0; // NB: This isn't supported on iOS <= 12. If the keyboard is open, the popper
  // can be obscured underneath it.
  // Also, `html.clientHeight` adds the bottom bar height in Safari iOS, even
  // if it isn't open, so if this isn't available, the popper will be detected
  // to overflow the bottom of the screen too early.

  if (visualViewport) {
    width = visualViewport.width;
    height = visualViewport.height; // Uses Layout Viewport (like Chrome; Safari does not currently)
    // In Chrome, it returns a value very close to 0 (+/-) but contains rounding
    // errors due to floating point numbers, so we need to check precision.
    // Safari returns a number <= 0, usually < -1 when pinch-zoomed
    // Feature detection fails in mobile emulation mode in Chrome.
    // Math.abs(win.innerWidth / visualViewport.scale - visualViewport.width) <
    // 0.001
    // Fallback here: "Not Safari" userAgent

    if (!/^((?!chrome|android).)*safari/i.test(navigator.userAgent)) {
      x = visualViewport.offsetLeft;
      y = visualViewport.offsetTop;
    }
  }

  return {
    width: width,
    height: height,
    x: x + (0,_getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_2__["default"])(element),
    y: y
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js":
/*!****************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getWindow.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getWindow)
/* harmony export */ });
function getWindow(node) {
  if (node == null) {
    return window;
  }

  if (node.toString() !== '[object Window]') {
    var ownerDocument = node.ownerDocument;
    return ownerDocument ? ownerDocument.defaultView || window : window;
  }

  return node;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getWindowScroll)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");

function getWindowScroll(node) {
  var win = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node);
  var scrollLeft = win.pageXOffset;
  var scrollTop = win.pageYOffset;
  return {
    scrollLeft: scrollLeft,
    scrollTop: scrollTop
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getWindowScrollBarX)
/* harmony export */ });
/* harmony import */ var _getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getBoundingClientRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _getWindowScroll_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getWindowScroll.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js");



function getWindowScrollBarX(element) {
  // If <html> has a CSS width greater than the viewport, then this will be
  // incorrect for RTL.
  // Popper 1 is broken in this case and never had a bug report so let's assume
  // it's not an issue. I don't think anyone ever specifies width on <html>
  // anyway.
  // Browsers where the left scrollbar doesn't cause an issue report `0` for
  // this (e.g. Edge 2019, IE11, Safari)
  return (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element)).left + (0,_getWindowScroll_js__WEBPACK_IMPORTED_MODULE_2__["default"])(element).scrollLeft;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "isElement": () => (/* binding */ isElement),
/* harmony export */   "isHTMLElement": () => (/* binding */ isHTMLElement),
/* harmony export */   "isShadowRoot": () => (/* binding */ isShadowRoot)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");


function isElement(node) {
  var OwnElement = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node).Element;
  return node instanceof OwnElement || node instanceof Element;
}

function isHTMLElement(node) {
  var OwnElement = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node).HTMLElement;
  return node instanceof OwnElement || node instanceof HTMLElement;
}

function isShadowRoot(node) {
  // IE 11 has no ShadowRoot
  if (typeof ShadowRoot === 'undefined') {
    return false;
  }

  var OwnElement = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node).ShadowRoot;
  return node instanceof OwnElement || node instanceof ShadowRoot;
}



/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isScrollParent)
/* harmony export */ });
/* harmony import */ var _getComputedStyle_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getComputedStyle.js */ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");

function isScrollParent(element) {
  // Firefox wants us to check `-x` and `-y` variations as well
  var _getComputedStyle = (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element),
      overflow = _getComputedStyle.overflow,
      overflowX = _getComputedStyle.overflowX,
      overflowY = _getComputedStyle.overflowY;

  return /auto|scroll|overlay|hidden/.test(overflow + overflowY + overflowX);
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/isTableElement.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/isTableElement.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isTableElement)
/* harmony export */ });
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");

function isTableElement(element) {
  return ['table', 'td', 'th'].indexOf((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element)) >= 0;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/listScrollParents.js":
/*!************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/listScrollParents.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ listScrollParents)
/* harmony export */ });
/* harmony import */ var _getScrollParent_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getScrollParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/getScrollParent.js");
/* harmony import */ var _getParentNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getParentNode.js */ "./node_modules/@popperjs/core/lib/dom-utils/getParentNode.js");
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _isScrollParent_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./isScrollParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js");




/*
given a DOM element, return the list of all scroll parents, up the list of ancesors
until we get to the top window object. This list is what we attach scroll listeners
to, because if any of these parent elements scroll, we'll need to re-calculate the
reference element's position.
*/

function listScrollParents(element, list) {
  var _element$ownerDocumen;

  if (list === void 0) {
    list = [];
  }

  var scrollParent = (0,_getScrollParent_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element);
  var isBody = scrollParent === ((_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body);
  var win = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_1__["default"])(scrollParent);
  var target = isBody ? [win].concat(win.visualViewport || [], (0,_isScrollParent_js__WEBPACK_IMPORTED_MODULE_2__["default"])(scrollParent) ? scrollParent : []) : scrollParent;
  var updatedList = list.concat(target);
  return isBody ? updatedList : // $FlowFixMe[incompatible-call]: isBody tells us target will be an HTMLElement here
  updatedList.concat(listScrollParents((0,_getParentNode_js__WEBPACK_IMPORTED_MODULE_3__["default"])(target)));
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/enums.js":
/*!**************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/enums.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "afterMain": () => (/* binding */ afterMain),
/* harmony export */   "afterRead": () => (/* binding */ afterRead),
/* harmony export */   "afterWrite": () => (/* binding */ afterWrite),
/* harmony export */   "auto": () => (/* binding */ auto),
/* harmony export */   "basePlacements": () => (/* binding */ basePlacements),
/* harmony export */   "beforeMain": () => (/* binding */ beforeMain),
/* harmony export */   "beforeRead": () => (/* binding */ beforeRead),
/* harmony export */   "beforeWrite": () => (/* binding */ beforeWrite),
/* harmony export */   "bottom": () => (/* binding */ bottom),
/* harmony export */   "clippingParents": () => (/* binding */ clippingParents),
/* harmony export */   "end": () => (/* binding */ end),
/* harmony export */   "left": () => (/* binding */ left),
/* harmony export */   "main": () => (/* binding */ main),
/* harmony export */   "modifierPhases": () => (/* binding */ modifierPhases),
/* harmony export */   "placements": () => (/* binding */ placements),
/* harmony export */   "popper": () => (/* binding */ popper),
/* harmony export */   "read": () => (/* binding */ read),
/* harmony export */   "reference": () => (/* binding */ reference),
/* harmony export */   "right": () => (/* binding */ right),
/* harmony export */   "start": () => (/* binding */ start),
/* harmony export */   "top": () => (/* binding */ top),
/* harmony export */   "variationPlacements": () => (/* binding */ variationPlacements),
/* harmony export */   "viewport": () => (/* binding */ viewport),
/* harmony export */   "write": () => (/* binding */ write)
/* harmony export */ });
var top = 'top';
var bottom = 'bottom';
var right = 'right';
var left = 'left';
var auto = 'auto';
var basePlacements = [top, bottom, right, left];
var start = 'start';
var end = 'end';
var clippingParents = 'clippingParents';
var viewport = 'viewport';
var popper = 'popper';
var reference = 'reference';
var variationPlacements = /*#__PURE__*/basePlacements.reduce(function (acc, placement) {
  return acc.concat([placement + "-" + start, placement + "-" + end]);
}, []);
var placements = /*#__PURE__*/[].concat(basePlacements, [auto]).reduce(function (acc, placement) {
  return acc.concat([placement, placement + "-" + start, placement + "-" + end]);
}, []); // modifiers that need to read the DOM

var beforeRead = 'beforeRead';
var read = 'read';
var afterRead = 'afterRead'; // pure-logic modifiers

var beforeMain = 'beforeMain';
var main = 'main';
var afterMain = 'afterMain'; // modifier with the purpose to write to the DOM (or write into a framework state)

var beforeWrite = 'beforeWrite';
var write = 'write';
var afterWrite = 'afterWrite';
var modifierPhases = [beforeRead, read, afterRead, beforeMain, main, afterMain, beforeWrite, write, afterWrite];

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/index.js":
/*!**************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "afterMain": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.afterMain),
/* harmony export */   "afterRead": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.afterRead),
/* harmony export */   "afterWrite": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.afterWrite),
/* harmony export */   "applyStyles": () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__.applyStyles),
/* harmony export */   "arrow": () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__.arrow),
/* harmony export */   "auto": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.auto),
/* harmony export */   "basePlacements": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.basePlacements),
/* harmony export */   "beforeMain": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.beforeMain),
/* harmony export */   "beforeRead": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.beforeRead),
/* harmony export */   "beforeWrite": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.beforeWrite),
/* harmony export */   "bottom": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.bottom),
/* harmony export */   "clippingParents": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.clippingParents),
/* harmony export */   "computeStyles": () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__.computeStyles),
/* harmony export */   "createPopper": () => (/* reexport safe */ _popper_js__WEBPACK_IMPORTED_MODULE_4__.createPopper),
/* harmony export */   "createPopperBase": () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_2__.createPopper),
/* harmony export */   "createPopperLite": () => (/* reexport safe */ _popper_lite_js__WEBPACK_IMPORTED_MODULE_5__.createPopper),
/* harmony export */   "detectOverflow": () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   "end": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.end),
/* harmony export */   "eventListeners": () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__.eventListeners),
/* harmony export */   "flip": () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__.flip),
/* harmony export */   "hide": () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__.hide),
/* harmony export */   "left": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.left),
/* harmony export */   "main": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.main),
/* harmony export */   "modifierPhases": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.modifierPhases),
/* harmony export */   "offset": () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__.offset),
/* harmony export */   "placements": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.placements),
/* harmony export */   "popper": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.popper),
/* harmony export */   "popperGenerator": () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_2__.popperGenerator),
/* harmony export */   "popperOffsets": () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__.popperOffsets),
/* harmony export */   "preventOverflow": () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__.preventOverflow),
/* harmony export */   "read": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.read),
/* harmony export */   "reference": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.reference),
/* harmony export */   "right": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.right),
/* harmony export */   "start": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.start),
/* harmony export */   "top": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.top),
/* harmony export */   "variationPlacements": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.variationPlacements),
/* harmony export */   "viewport": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.viewport),
/* harmony export */   "write": () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.write)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./modifiers/index.js */ "./node_modules/@popperjs/core/lib/modifiers/index.js");
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./createPopper.js */ "./node_modules/@popperjs/core/lib/createPopper.js");
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./createPopper.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _popper_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./popper.js */ "./node_modules/@popperjs/core/lib/popper.js");
/* harmony import */ var _popper_lite_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./popper-lite.js */ "./node_modules/@popperjs/core/lib/popper-lite.js");

 // eslint-disable-next-line import/no-unused-modules

 // eslint-disable-next-line import/no-unused-modules

 // eslint-disable-next-line import/no-unused-modules



/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/applyStyles.js":
/*!******************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/applyStyles.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _dom_utils_getNodeName_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../dom-utils/getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../dom-utils/instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");

 // This modifier takes the styles prepared by the `computeStyles` modifier
// and applies them to the HTMLElements such as popper and arrow

function applyStyles(_ref) {
  var state = _ref.state;
  Object.keys(state.elements).forEach(function (name) {
    var style = state.styles[name] || {};
    var attributes = state.attributes[name] || {};
    var element = state.elements[name]; // arrow is optional + virtual elements

    if (!(0,_dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element) || !(0,_dom_utils_getNodeName_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element)) {
      return;
    } // Flow doesn't support to extend this property, but it's the most
    // effective way to apply styles to an HTMLElement
    // $FlowFixMe[cannot-write]


    Object.assign(element.style, style);
    Object.keys(attributes).forEach(function (name) {
      var value = attributes[name];

      if (value === false) {
        element.removeAttribute(name);
      } else {
        element.setAttribute(name, value === true ? '' : value);
      }
    });
  });
}

function effect(_ref2) {
  var state = _ref2.state;
  var initialStyles = {
    popper: {
      position: state.options.strategy,
      left: '0',
      top: '0',
      margin: '0'
    },
    arrow: {
      position: 'absolute'
    },
    reference: {}
  };
  Object.assign(state.elements.popper.style, initialStyles.popper);
  state.styles = initialStyles;

  if (state.elements.arrow) {
    Object.assign(state.elements.arrow.style, initialStyles.arrow);
  }

  return function () {
    Object.keys(state.elements).forEach(function (name) {
      var element = state.elements[name];
      var attributes = state.attributes[name] || {};
      var styleProperties = Object.keys(state.styles.hasOwnProperty(name) ? state.styles[name] : initialStyles[name]); // Set all values to an empty string to unset them

      var style = styleProperties.reduce(function (style, property) {
        style[property] = '';
        return style;
      }, {}); // arrow is optional + virtual elements

      if (!(0,_dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element) || !(0,_dom_utils_getNodeName_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element)) {
        return;
      }

      Object.assign(element.style, style);
      Object.keys(attributes).forEach(function (attribute) {
        element.removeAttribute(attribute);
      });
    });
  };
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'applyStyles',
  enabled: true,
  phase: 'write',
  fn: applyStyles,
  effect: effect,
  requires: ['computeStyles']
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/arrow.js":
/*!************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/arrow.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../dom-utils/getLayoutRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js");
/* harmony import */ var _dom_utils_contains_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../dom-utils/contains.js */ "./node_modules/@popperjs/core/lib/dom-utils/contains.js");
/* harmony import */ var _dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../dom-utils/getOffsetParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _utils_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/getMainAxisFromPlacement.js */ "./node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js");
/* harmony import */ var _utils_within_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/within.js */ "./node_modules/@popperjs/core/lib/utils/within.js");
/* harmony import */ var _utils_mergePaddingObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/mergePaddingObject.js */ "./node_modules/@popperjs/core/lib/utils/mergePaddingObject.js");
/* harmony import */ var _utils_expandToHashMap_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/expandToHashMap.js */ "./node_modules/@popperjs/core/lib/utils/expandToHashMap.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../dom-utils/instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");









 // eslint-disable-next-line import/no-unused-modules

var toPaddingObject = function toPaddingObject(padding, state) {
  padding = typeof padding === 'function' ? padding(Object.assign({}, state.rects, {
    placement: state.placement
  })) : padding;
  return (0,_utils_mergePaddingObject_js__WEBPACK_IMPORTED_MODULE_0__["default"])(typeof padding !== 'number' ? padding : (0,_utils_expandToHashMap_js__WEBPACK_IMPORTED_MODULE_1__["default"])(padding, _enums_js__WEBPACK_IMPORTED_MODULE_2__.basePlacements));
};

function arrow(_ref) {
  var _state$modifiersData$;

  var state = _ref.state,
      name = _ref.name,
      options = _ref.options;
  var arrowElement = state.elements.arrow;
  var popperOffsets = state.modifiersData.popperOffsets;
  var basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(state.placement);
  var axis = (0,_utils_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_4__["default"])(basePlacement);
  var isVertical = [_enums_js__WEBPACK_IMPORTED_MODULE_2__.left, _enums_js__WEBPACK_IMPORTED_MODULE_2__.right].indexOf(basePlacement) >= 0;
  var len = isVertical ? 'height' : 'width';

  if (!arrowElement || !popperOffsets) {
    return;
  }

  var paddingObject = toPaddingObject(options.padding, state);
  var arrowRect = (0,_dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_5__["default"])(arrowElement);
  var minProp = axis === 'y' ? _enums_js__WEBPACK_IMPORTED_MODULE_2__.top : _enums_js__WEBPACK_IMPORTED_MODULE_2__.left;
  var maxProp = axis === 'y' ? _enums_js__WEBPACK_IMPORTED_MODULE_2__.bottom : _enums_js__WEBPACK_IMPORTED_MODULE_2__.right;
  var endDiff = state.rects.reference[len] + state.rects.reference[axis] - popperOffsets[axis] - state.rects.popper[len];
  var startDiff = popperOffsets[axis] - state.rects.reference[axis];
  var arrowOffsetParent = (0,_dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_6__["default"])(arrowElement);
  var clientSize = arrowOffsetParent ? axis === 'y' ? arrowOffsetParent.clientHeight || 0 : arrowOffsetParent.clientWidth || 0 : 0;
  var centerToReference = endDiff / 2 - startDiff / 2; // Make sure the arrow doesn't overflow the popper if the center point is
  // outside of the popper bounds

  var min = paddingObject[minProp];
  var max = clientSize - arrowRect[len] - paddingObject[maxProp];
  var center = clientSize / 2 - arrowRect[len] / 2 + centerToReference;
  var offset = (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_7__.within)(min, center, max); // Prevents breaking syntax highlighting...

  var axisProp = axis;
  state.modifiersData[name] = (_state$modifiersData$ = {}, _state$modifiersData$[axisProp] = offset, _state$modifiersData$.centerOffset = offset - center, _state$modifiersData$);
}

function effect(_ref2) {
  var state = _ref2.state,
      options = _ref2.options;
  var _options$element = options.element,
      arrowElement = _options$element === void 0 ? '[data-popper-arrow]' : _options$element;

  if (arrowElement == null) {
    return;
  } // CSS selector


  if (typeof arrowElement === 'string') {
    arrowElement = state.elements.popper.querySelector(arrowElement);

    if (!arrowElement) {
      return;
    }
  }

  if (true) {
    if (!(0,_dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_8__.isHTMLElement)(arrowElement)) {
      console.error(['Popper: "arrow" element must be an HTMLElement (not an SVGElement).', 'To use an SVG arrow, wrap it in an HTMLElement that will be used as', 'the arrow.'].join(' '));
    }
  }

  if (!(0,_dom_utils_contains_js__WEBPACK_IMPORTED_MODULE_9__["default"])(state.elements.popper, arrowElement)) {
    if (true) {
      console.error(['Popper: "arrow" modifier\'s `element` must be a child of the popper', 'element.'].join(' '));
    }

    return;
  }

  state.elements.arrow = arrowElement;
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'arrow',
  enabled: true,
  phase: 'main',
  fn: arrow,
  effect: effect,
  requires: ['popperOffsets'],
  requiresIfExists: ['preventOverflow']
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/computeStyles.js":
/*!********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/computeStyles.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "mapToStyles": () => (/* binding */ mapToStyles)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../dom-utils/getOffsetParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _dom_utils_getWindow_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../dom-utils/getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _dom_utils_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../dom-utils/getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _dom_utils_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../dom-utils/getComputedStyle.js */ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _utils_getVariation_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/getVariation.js */ "./node_modules/@popperjs/core/lib/utils/getVariation.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");







 // eslint-disable-next-line import/no-unused-modules

var unsetSides = {
  top: 'auto',
  right: 'auto',
  bottom: 'auto',
  left: 'auto'
}; // Round the offsets to the nearest suitable subpixel based on the DPR.
// Zooming can change the DPR, but it seems to report a value that will
// cleanly divide the values into the appropriate subpixels.

function roundOffsetsByDPR(_ref) {
  var x = _ref.x,
      y = _ref.y;
  var win = window;
  var dpr = win.devicePixelRatio || 1;
  return {
    x: (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_0__.round)(x * dpr) / dpr || 0,
    y: (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_0__.round)(y * dpr) / dpr || 0
  };
}

function mapToStyles(_ref2) {
  var _Object$assign2;

  var popper = _ref2.popper,
      popperRect = _ref2.popperRect,
      placement = _ref2.placement,
      variation = _ref2.variation,
      offsets = _ref2.offsets,
      position = _ref2.position,
      gpuAcceleration = _ref2.gpuAcceleration,
      adaptive = _ref2.adaptive,
      roundOffsets = _ref2.roundOffsets,
      isFixed = _ref2.isFixed;
  var _offsets$x = offsets.x,
      x = _offsets$x === void 0 ? 0 : _offsets$x,
      _offsets$y = offsets.y,
      y = _offsets$y === void 0 ? 0 : _offsets$y;

  var _ref3 = typeof roundOffsets === 'function' ? roundOffsets({
    x: x,
    y: y
  }) : {
    x: x,
    y: y
  };

  x = _ref3.x;
  y = _ref3.y;
  var hasX = offsets.hasOwnProperty('x');
  var hasY = offsets.hasOwnProperty('y');
  var sideX = _enums_js__WEBPACK_IMPORTED_MODULE_1__.left;
  var sideY = _enums_js__WEBPACK_IMPORTED_MODULE_1__.top;
  var win = window;

  if (adaptive) {
    var offsetParent = (0,_dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_2__["default"])(popper);
    var heightProp = 'clientHeight';
    var widthProp = 'clientWidth';

    if (offsetParent === (0,_dom_utils_getWindow_js__WEBPACK_IMPORTED_MODULE_3__["default"])(popper)) {
      offsetParent = (0,_dom_utils_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_4__["default"])(popper);

      if ((0,_dom_utils_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_5__["default"])(offsetParent).position !== 'static' && position === 'absolute') {
        heightProp = 'scrollHeight';
        widthProp = 'scrollWidth';
      }
    } // $FlowFixMe[incompatible-cast]: force type refinement, we compare offsetParent with window above, but Flow doesn't detect it


    offsetParent = offsetParent;

    if (placement === _enums_js__WEBPACK_IMPORTED_MODULE_1__.top || (placement === _enums_js__WEBPACK_IMPORTED_MODULE_1__.left || placement === _enums_js__WEBPACK_IMPORTED_MODULE_1__.right) && variation === _enums_js__WEBPACK_IMPORTED_MODULE_1__.end) {
      sideY = _enums_js__WEBPACK_IMPORTED_MODULE_1__.bottom;
      var offsetY = isFixed && offsetParent === win && win.visualViewport ? win.visualViewport.height : // $FlowFixMe[prop-missing]
      offsetParent[heightProp];
      y -= offsetY - popperRect.height;
      y *= gpuAcceleration ? 1 : -1;
    }

    if (placement === _enums_js__WEBPACK_IMPORTED_MODULE_1__.left || (placement === _enums_js__WEBPACK_IMPORTED_MODULE_1__.top || placement === _enums_js__WEBPACK_IMPORTED_MODULE_1__.bottom) && variation === _enums_js__WEBPACK_IMPORTED_MODULE_1__.end) {
      sideX = _enums_js__WEBPACK_IMPORTED_MODULE_1__.right;
      var offsetX = isFixed && offsetParent === win && win.visualViewport ? win.visualViewport.width : // $FlowFixMe[prop-missing]
      offsetParent[widthProp];
      x -= offsetX - popperRect.width;
      x *= gpuAcceleration ? 1 : -1;
    }
  }

  var commonStyles = Object.assign({
    position: position
  }, adaptive && unsetSides);

  var _ref4 = roundOffsets === true ? roundOffsetsByDPR({
    x: x,
    y: y
  }) : {
    x: x,
    y: y
  };

  x = _ref4.x;
  y = _ref4.y;

  if (gpuAcceleration) {
    var _Object$assign;

    return Object.assign({}, commonStyles, (_Object$assign = {}, _Object$assign[sideY] = hasY ? '0' : '', _Object$assign[sideX] = hasX ? '0' : '', _Object$assign.transform = (win.devicePixelRatio || 1) <= 1 ? "translate(" + x + "px, " + y + "px)" : "translate3d(" + x + "px, " + y + "px, 0)", _Object$assign));
  }

  return Object.assign({}, commonStyles, (_Object$assign2 = {}, _Object$assign2[sideY] = hasY ? y + "px" : '', _Object$assign2[sideX] = hasX ? x + "px" : '', _Object$assign2.transform = '', _Object$assign2));
}

function computeStyles(_ref5) {
  var state = _ref5.state,
      options = _ref5.options;
  var _options$gpuAccelerat = options.gpuAcceleration,
      gpuAcceleration = _options$gpuAccelerat === void 0 ? true : _options$gpuAccelerat,
      _options$adaptive = options.adaptive,
      adaptive = _options$adaptive === void 0 ? true : _options$adaptive,
      _options$roundOffsets = options.roundOffsets,
      roundOffsets = _options$roundOffsets === void 0 ? true : _options$roundOffsets;

  if (true) {
    var transitionProperty = (0,_dom_utils_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_5__["default"])(state.elements.popper).transitionProperty || '';

    if (adaptive && ['transform', 'top', 'right', 'bottom', 'left'].some(function (property) {
      return transitionProperty.indexOf(property) >= 0;
    })) {
      console.warn(['Popper: Detected CSS transitions on at least one of the following', 'CSS properties: "transform", "top", "right", "bottom", "left".', '\n\n', 'Disable the "computeStyles" modifier\'s `adaptive` option to allow', 'for smooth transitions, or remove these properties from the CSS', 'transition declaration on the popper element if only transitioning', 'opacity or background-color for example.', '\n\n', 'We recommend using the popper element as a wrapper around an inner', 'element that can have any CSS property transitioned for animations.'].join(' '));
    }
  }

  var commonStyles = {
    placement: (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_6__["default"])(state.placement),
    variation: (0,_utils_getVariation_js__WEBPACK_IMPORTED_MODULE_7__["default"])(state.placement),
    popper: state.elements.popper,
    popperRect: state.rects.popper,
    gpuAcceleration: gpuAcceleration,
    isFixed: state.options.strategy === 'fixed'
  };

  if (state.modifiersData.popperOffsets != null) {
    state.styles.popper = Object.assign({}, state.styles.popper, mapToStyles(Object.assign({}, commonStyles, {
      offsets: state.modifiersData.popperOffsets,
      position: state.options.strategy,
      adaptive: adaptive,
      roundOffsets: roundOffsets
    })));
  }

  if (state.modifiersData.arrow != null) {
    state.styles.arrow = Object.assign({}, state.styles.arrow, mapToStyles(Object.assign({}, commonStyles, {
      offsets: state.modifiersData.arrow,
      position: 'absolute',
      adaptive: false,
      roundOffsets: roundOffsets
    })));
  }

  state.attributes.popper = Object.assign({}, state.attributes.popper, {
    'data-popper-placement': state.placement
  });
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'computeStyles',
  enabled: true,
  phase: 'beforeWrite',
  fn: computeStyles,
  data: {}
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/eventListeners.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/eventListeners.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _dom_utils_getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../dom-utils/getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
 // eslint-disable-next-line import/no-unused-modules

var passive = {
  passive: true
};

function effect(_ref) {
  var state = _ref.state,
      instance = _ref.instance,
      options = _ref.options;
  var _options$scroll = options.scroll,
      scroll = _options$scroll === void 0 ? true : _options$scroll,
      _options$resize = options.resize,
      resize = _options$resize === void 0 ? true : _options$resize;
  var window = (0,_dom_utils_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(state.elements.popper);
  var scrollParents = [].concat(state.scrollParents.reference, state.scrollParents.popper);

  if (scroll) {
    scrollParents.forEach(function (scrollParent) {
      scrollParent.addEventListener('scroll', instance.update, passive);
    });
  }

  if (resize) {
    window.addEventListener('resize', instance.update, passive);
  }

  return function () {
    if (scroll) {
      scrollParents.forEach(function (scrollParent) {
        scrollParent.removeEventListener('scroll', instance.update, passive);
      });
    }

    if (resize) {
      window.removeEventListener('resize', instance.update, passive);
    }
  };
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'eventListeners',
  enabled: true,
  phase: 'write',
  fn: function fn() {},
  effect: effect,
  data: {}
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/flip.js":
/*!***********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/flip.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/getOppositePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getOppositePlacement.js");
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _utils_getOppositeVariationPlacement_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/getOppositeVariationPlacement.js */ "./node_modules/@popperjs/core/lib/utils/getOppositeVariationPlacement.js");
/* harmony import */ var _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/detectOverflow.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _utils_computeAutoPlacement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/computeAutoPlacement.js */ "./node_modules/@popperjs/core/lib/utils/computeAutoPlacement.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _utils_getVariation_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/getVariation.js */ "./node_modules/@popperjs/core/lib/utils/getVariation.js");






 // eslint-disable-next-line import/no-unused-modules

function getExpandedFallbackPlacements(placement) {
  if ((0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement) === _enums_js__WEBPACK_IMPORTED_MODULE_1__.auto) {
    return [];
  }

  var oppositePlacement = (0,_utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(placement);
  return [(0,_utils_getOppositeVariationPlacement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(placement), oppositePlacement, (0,_utils_getOppositeVariationPlacement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(oppositePlacement)];
}

function flip(_ref) {
  var state = _ref.state,
      options = _ref.options,
      name = _ref.name;

  if (state.modifiersData[name]._skip) {
    return;
  }

  var _options$mainAxis = options.mainAxis,
      checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
      _options$altAxis = options.altAxis,
      checkAltAxis = _options$altAxis === void 0 ? true : _options$altAxis,
      specifiedFallbackPlacements = options.fallbackPlacements,
      padding = options.padding,
      boundary = options.boundary,
      rootBoundary = options.rootBoundary,
      altBoundary = options.altBoundary,
      _options$flipVariatio = options.flipVariations,
      flipVariations = _options$flipVariatio === void 0 ? true : _options$flipVariatio,
      allowedAutoPlacements = options.allowedAutoPlacements;
  var preferredPlacement = state.options.placement;
  var basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(preferredPlacement);
  var isBasePlacement = basePlacement === preferredPlacement;
  var fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipVariations ? [(0,_utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(preferredPlacement)] : getExpandedFallbackPlacements(preferredPlacement));
  var placements = [preferredPlacement].concat(fallbackPlacements).reduce(function (acc, placement) {
    return acc.concat((0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement) === _enums_js__WEBPACK_IMPORTED_MODULE_1__.auto ? (0,_utils_computeAutoPlacement_js__WEBPACK_IMPORTED_MODULE_4__["default"])(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      padding: padding,
      flipVariations: flipVariations,
      allowedAutoPlacements: allowedAutoPlacements
    }) : placement);
  }, []);
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var checksMap = new Map();
  var makeFallbackChecks = true;
  var firstFittingPlacement = placements[0];

  for (var i = 0; i < placements.length; i++) {
    var placement = placements[i];

    var _basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement);

    var isStartVariation = (0,_utils_getVariation_js__WEBPACK_IMPORTED_MODULE_5__["default"])(placement) === _enums_js__WEBPACK_IMPORTED_MODULE_1__.start;
    var isVertical = [_enums_js__WEBPACK_IMPORTED_MODULE_1__.top, _enums_js__WEBPACK_IMPORTED_MODULE_1__.bottom].indexOf(_basePlacement) >= 0;
    var len = isVertical ? 'width' : 'height';
    var overflow = (0,_utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_6__["default"])(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      altBoundary: altBoundary,
      padding: padding
    });
    var mainVariationSide = isVertical ? isStartVariation ? _enums_js__WEBPACK_IMPORTED_MODULE_1__.right : _enums_js__WEBPACK_IMPORTED_MODULE_1__.left : isStartVariation ? _enums_js__WEBPACK_IMPORTED_MODULE_1__.bottom : _enums_js__WEBPACK_IMPORTED_MODULE_1__.top;

    if (referenceRect[len] > popperRect[len]) {
      mainVariationSide = (0,_utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(mainVariationSide);
    }

    var altVariationSide = (0,_utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(mainVariationSide);
    var checks = [];

    if (checkMainAxis) {
      checks.push(overflow[_basePlacement] <= 0);
    }

    if (checkAltAxis) {
      checks.push(overflow[mainVariationSide] <= 0, overflow[altVariationSide] <= 0);
    }

    if (checks.every(function (check) {
      return check;
    })) {
      firstFittingPlacement = placement;
      makeFallbackChecks = false;
      break;
    }

    checksMap.set(placement, checks);
  }

  if (makeFallbackChecks) {
    // `2` may be desired in some cases – research later
    var numberOfChecks = flipVariations ? 3 : 1;

    var _loop = function _loop(_i) {
      var fittingPlacement = placements.find(function (placement) {
        var checks = checksMap.get(placement);

        if (checks) {
          return checks.slice(0, _i).every(function (check) {
            return check;
          });
        }
      });

      if (fittingPlacement) {
        firstFittingPlacement = fittingPlacement;
        return "break";
      }
    };

    for (var _i = numberOfChecks; _i > 0; _i--) {
      var _ret = _loop(_i);

      if (_ret === "break") break;
    }
  }

  if (state.placement !== firstFittingPlacement) {
    state.modifiersData[name]._skip = true;
    state.placement = firstFittingPlacement;
    state.reset = true;
  }
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'flip',
  enabled: true,
  phase: 'main',
  fn: flip,
  requiresIfExists: ['offset'],
  data: {
    _skip: false
  }
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/hide.js":
/*!***********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/hide.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/detectOverflow.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");



function getSideOffsets(overflow, rect, preventedOffsets) {
  if (preventedOffsets === void 0) {
    preventedOffsets = {
      x: 0,
      y: 0
    };
  }

  return {
    top: overflow.top - rect.height - preventedOffsets.y,
    right: overflow.right - rect.width + preventedOffsets.x,
    bottom: overflow.bottom - rect.height + preventedOffsets.y,
    left: overflow.left - rect.width - preventedOffsets.x
  };
}

function isAnySideFullyClipped(overflow) {
  return [_enums_js__WEBPACK_IMPORTED_MODULE_0__.top, _enums_js__WEBPACK_IMPORTED_MODULE_0__.right, _enums_js__WEBPACK_IMPORTED_MODULE_0__.bottom, _enums_js__WEBPACK_IMPORTED_MODULE_0__.left].some(function (side) {
    return overflow[side] >= 0;
  });
}

function hide(_ref) {
  var state = _ref.state,
      name = _ref.name;
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var preventedOffsets = state.modifiersData.preventOverflow;
  var referenceOverflow = (0,_utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_1__["default"])(state, {
    elementContext: 'reference'
  });
  var popperAltOverflow = (0,_utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_1__["default"])(state, {
    altBoundary: true
  });
  var referenceClippingOffsets = getSideOffsets(referenceOverflow, referenceRect);
  var popperEscapeOffsets = getSideOffsets(popperAltOverflow, popperRect, preventedOffsets);
  var isReferenceHidden = isAnySideFullyClipped(referenceClippingOffsets);
  var hasPopperEscaped = isAnySideFullyClipped(popperEscapeOffsets);
  state.modifiersData[name] = {
    referenceClippingOffsets: referenceClippingOffsets,
    popperEscapeOffsets: popperEscapeOffsets,
    isReferenceHidden: isReferenceHidden,
    hasPopperEscaped: hasPopperEscaped
  };
  state.attributes.popper = Object.assign({}, state.attributes.popper, {
    'data-popper-reference-hidden': isReferenceHidden,
    'data-popper-escaped': hasPopperEscaped
  });
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'hide',
  enabled: true,
  phase: 'main',
  requiresIfExists: ['preventOverflow'],
  fn: hide
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/index.js":
/*!************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/index.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "applyStyles": () => (/* reexport safe */ _applyStyles_js__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   "arrow": () => (/* reexport safe */ _arrow_js__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   "computeStyles": () => (/* reexport safe */ _computeStyles_js__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   "eventListeners": () => (/* reexport safe */ _eventListeners_js__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   "flip": () => (/* reexport safe */ _flip_js__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   "hide": () => (/* reexport safe */ _hide_js__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   "offset": () => (/* reexport safe */ _offset_js__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   "popperOffsets": () => (/* reexport safe */ _popperOffsets_js__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   "preventOverflow": () => (/* reexport safe */ _preventOverflow_js__WEBPACK_IMPORTED_MODULE_8__["default"])
/* harmony export */ });
/* harmony import */ var _applyStyles_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./applyStyles.js */ "./node_modules/@popperjs/core/lib/modifiers/applyStyles.js");
/* harmony import */ var _arrow_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./arrow.js */ "./node_modules/@popperjs/core/lib/modifiers/arrow.js");
/* harmony import */ var _computeStyles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./computeStyles.js */ "./node_modules/@popperjs/core/lib/modifiers/computeStyles.js");
/* harmony import */ var _eventListeners_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./eventListeners.js */ "./node_modules/@popperjs/core/lib/modifiers/eventListeners.js");
/* harmony import */ var _flip_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./flip.js */ "./node_modules/@popperjs/core/lib/modifiers/flip.js");
/* harmony import */ var _hide_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./hide.js */ "./node_modules/@popperjs/core/lib/modifiers/hide.js");
/* harmony import */ var _offset_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./offset.js */ "./node_modules/@popperjs/core/lib/modifiers/offset.js");
/* harmony import */ var _popperOffsets_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./popperOffsets.js */ "./node_modules/@popperjs/core/lib/modifiers/popperOffsets.js");
/* harmony import */ var _preventOverflow_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./preventOverflow.js */ "./node_modules/@popperjs/core/lib/modifiers/preventOverflow.js");










/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/offset.js":
/*!*************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/offset.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "distanceAndSkiddingToXY": () => (/* binding */ distanceAndSkiddingToXY)
/* harmony export */ });
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");

 // eslint-disable-next-line import/no-unused-modules

function distanceAndSkiddingToXY(placement, rects, offset) {
  var basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement);
  var invertDistance = [_enums_js__WEBPACK_IMPORTED_MODULE_1__.left, _enums_js__WEBPACK_IMPORTED_MODULE_1__.top].indexOf(basePlacement) >= 0 ? -1 : 1;

  var _ref = typeof offset === 'function' ? offset(Object.assign({}, rects, {
    placement: placement
  })) : offset,
      skidding = _ref[0],
      distance = _ref[1];

  skidding = skidding || 0;
  distance = (distance || 0) * invertDistance;
  return [_enums_js__WEBPACK_IMPORTED_MODULE_1__.left, _enums_js__WEBPACK_IMPORTED_MODULE_1__.right].indexOf(basePlacement) >= 0 ? {
    x: distance,
    y: skidding
  } : {
    x: skidding,
    y: distance
  };
}

function offset(_ref2) {
  var state = _ref2.state,
      options = _ref2.options,
      name = _ref2.name;
  var _options$offset = options.offset,
      offset = _options$offset === void 0 ? [0, 0] : _options$offset;
  var data = _enums_js__WEBPACK_IMPORTED_MODULE_1__.placements.reduce(function (acc, placement) {
    acc[placement] = distanceAndSkiddingToXY(placement, state.rects, offset);
    return acc;
  }, {});
  var _data$state$placement = data[state.placement],
      x = _data$state$placement.x,
      y = _data$state$placement.y;

  if (state.modifiersData.popperOffsets != null) {
    state.modifiersData.popperOffsets.x += x;
    state.modifiersData.popperOffsets.y += y;
  }

  state.modifiersData[name] = data;
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'offset',
  enabled: true,
  phase: 'main',
  requires: ['popperOffsets'],
  fn: offset
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/popperOffsets.js":
/*!********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/popperOffsets.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_computeOffsets_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/computeOffsets.js */ "./node_modules/@popperjs/core/lib/utils/computeOffsets.js");


function popperOffsets(_ref) {
  var state = _ref.state,
      name = _ref.name;
  // Offsets are the actual position the popper needs to have to be
  // properly positioned near its reference element
  // This is the most basic placement, and will be adjusted by
  // the modifiers in the next step
  state.modifiersData[name] = (0,_utils_computeOffsets_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    reference: state.rects.reference,
    element: state.rects.popper,
    strategy: 'absolute',
    placement: state.placement
  });
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'popperOffsets',
  enabled: true,
  phase: 'read',
  fn: popperOffsets,
  data: {}
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/preventOverflow.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/preventOverflow.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _utils_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/getMainAxisFromPlacement.js */ "./node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js");
/* harmony import */ var _utils_getAltAxis_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/getAltAxis.js */ "./node_modules/@popperjs/core/lib/utils/getAltAxis.js");
/* harmony import */ var _utils_within_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/within.js */ "./node_modules/@popperjs/core/lib/utils/within.js");
/* harmony import */ var _dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../dom-utils/getLayoutRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js");
/* harmony import */ var _dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../dom-utils/getOffsetParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/detectOverflow.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _utils_getVariation_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/getVariation.js */ "./node_modules/@popperjs/core/lib/utils/getVariation.js");
/* harmony import */ var _utils_getFreshSideObject_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/getFreshSideObject.js */ "./node_modules/@popperjs/core/lib/utils/getFreshSideObject.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");












function preventOverflow(_ref) {
  var state = _ref.state,
      options = _ref.options,
      name = _ref.name;
  var _options$mainAxis = options.mainAxis,
      checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
      _options$altAxis = options.altAxis,
      checkAltAxis = _options$altAxis === void 0 ? false : _options$altAxis,
      boundary = options.boundary,
      rootBoundary = options.rootBoundary,
      altBoundary = options.altBoundary,
      padding = options.padding,
      _options$tether = options.tether,
      tether = _options$tether === void 0 ? true : _options$tether,
      _options$tetherOffset = options.tetherOffset,
      tetherOffset = _options$tetherOffset === void 0 ? 0 : _options$tetherOffset;
  var overflow = (0,_utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(state, {
    boundary: boundary,
    rootBoundary: rootBoundary,
    padding: padding,
    altBoundary: altBoundary
  });
  var basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_1__["default"])(state.placement);
  var variation = (0,_utils_getVariation_js__WEBPACK_IMPORTED_MODULE_2__["default"])(state.placement);
  var isBasePlacement = !variation;
  var mainAxis = (0,_utils_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(basePlacement);
  var altAxis = (0,_utils_getAltAxis_js__WEBPACK_IMPORTED_MODULE_4__["default"])(mainAxis);
  var popperOffsets = state.modifiersData.popperOffsets;
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var tetherOffsetValue = typeof tetherOffset === 'function' ? tetherOffset(Object.assign({}, state.rects, {
    placement: state.placement
  })) : tetherOffset;
  var normalizedTetherOffsetValue = typeof tetherOffsetValue === 'number' ? {
    mainAxis: tetherOffsetValue,
    altAxis: tetherOffsetValue
  } : Object.assign({
    mainAxis: 0,
    altAxis: 0
  }, tetherOffsetValue);
  var offsetModifierState = state.modifiersData.offset ? state.modifiersData.offset[state.placement] : null;
  var data = {
    x: 0,
    y: 0
  };

  if (!popperOffsets) {
    return;
  }

  if (checkMainAxis) {
    var _offsetModifierState$;

    var mainSide = mainAxis === 'y' ? _enums_js__WEBPACK_IMPORTED_MODULE_5__.top : _enums_js__WEBPACK_IMPORTED_MODULE_5__.left;
    var altSide = mainAxis === 'y' ? _enums_js__WEBPACK_IMPORTED_MODULE_5__.bottom : _enums_js__WEBPACK_IMPORTED_MODULE_5__.right;
    var len = mainAxis === 'y' ? 'height' : 'width';
    var offset = popperOffsets[mainAxis];
    var min = offset + overflow[mainSide];
    var max = offset - overflow[altSide];
    var additive = tether ? -popperRect[len] / 2 : 0;
    var minLen = variation === _enums_js__WEBPACK_IMPORTED_MODULE_5__.start ? referenceRect[len] : popperRect[len];
    var maxLen = variation === _enums_js__WEBPACK_IMPORTED_MODULE_5__.start ? -popperRect[len] : -referenceRect[len]; // We need to include the arrow in the calculation so the arrow doesn't go
    // outside the reference bounds

    var arrowElement = state.elements.arrow;
    var arrowRect = tether && arrowElement ? (0,_dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_6__["default"])(arrowElement) : {
      width: 0,
      height: 0
    };
    var arrowPaddingObject = state.modifiersData['arrow#persistent'] ? state.modifiersData['arrow#persistent'].padding : (0,_utils_getFreshSideObject_js__WEBPACK_IMPORTED_MODULE_7__["default"])();
    var arrowPaddingMin = arrowPaddingObject[mainSide];
    var arrowPaddingMax = arrowPaddingObject[altSide]; // If the reference length is smaller than the arrow length, we don't want
    // to include its full size in the calculation. If the reference is small
    // and near the edge of a boundary, the popper can overflow even if the
    // reference is not overflowing as well (e.g. virtual elements with no
    // width or height)

    var arrowLen = (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_8__.within)(0, referenceRect[len], arrowRect[len]);
    var minOffset = isBasePlacement ? referenceRect[len] / 2 - additive - arrowLen - arrowPaddingMin - normalizedTetherOffsetValue.mainAxis : minLen - arrowLen - arrowPaddingMin - normalizedTetherOffsetValue.mainAxis;
    var maxOffset = isBasePlacement ? -referenceRect[len] / 2 + additive + arrowLen + arrowPaddingMax + normalizedTetherOffsetValue.mainAxis : maxLen + arrowLen + arrowPaddingMax + normalizedTetherOffsetValue.mainAxis;
    var arrowOffsetParent = state.elements.arrow && (0,_dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_9__["default"])(state.elements.arrow);
    var clientOffset = arrowOffsetParent ? mainAxis === 'y' ? arrowOffsetParent.clientTop || 0 : arrowOffsetParent.clientLeft || 0 : 0;
    var offsetModifierValue = (_offsetModifierState$ = offsetModifierState == null ? void 0 : offsetModifierState[mainAxis]) != null ? _offsetModifierState$ : 0;
    var tetherMin = offset + minOffset - offsetModifierValue - clientOffset;
    var tetherMax = offset + maxOffset - offsetModifierValue;
    var preventedOffset = (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_8__.within)(tether ? (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_10__.min)(min, tetherMin) : min, offset, tether ? (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_10__.max)(max, tetherMax) : max);
    popperOffsets[mainAxis] = preventedOffset;
    data[mainAxis] = preventedOffset - offset;
  }

  if (checkAltAxis) {
    var _offsetModifierState$2;

    var _mainSide = mainAxis === 'x' ? _enums_js__WEBPACK_IMPORTED_MODULE_5__.top : _enums_js__WEBPACK_IMPORTED_MODULE_5__.left;

    var _altSide = mainAxis === 'x' ? _enums_js__WEBPACK_IMPORTED_MODULE_5__.bottom : _enums_js__WEBPACK_IMPORTED_MODULE_5__.right;

    var _offset = popperOffsets[altAxis];

    var _len = altAxis === 'y' ? 'height' : 'width';

    var _min = _offset + overflow[_mainSide];

    var _max = _offset - overflow[_altSide];

    var isOriginSide = [_enums_js__WEBPACK_IMPORTED_MODULE_5__.top, _enums_js__WEBPACK_IMPORTED_MODULE_5__.left].indexOf(basePlacement) !== -1;

    var _offsetModifierValue = (_offsetModifierState$2 = offsetModifierState == null ? void 0 : offsetModifierState[altAxis]) != null ? _offsetModifierState$2 : 0;

    var _tetherMin = isOriginSide ? _min : _offset - referenceRect[_len] - popperRect[_len] - _offsetModifierValue + normalizedTetherOffsetValue.altAxis;

    var _tetherMax = isOriginSide ? _offset + referenceRect[_len] + popperRect[_len] - _offsetModifierValue - normalizedTetherOffsetValue.altAxis : _max;

    var _preventedOffset = tether && isOriginSide ? (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_8__.withinMaxClamp)(_tetherMin, _offset, _tetherMax) : (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_8__.within)(tether ? _tetherMin : _min, _offset, tether ? _tetherMax : _max);

    popperOffsets[altAxis] = _preventedOffset;
    data[altAxis] = _preventedOffset - _offset;
  }

  state.modifiersData[name] = data;
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'preventOverflow',
  enabled: true,
  phase: 'main',
  fn: preventOverflow,
  requiresIfExists: ['offset']
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/popper-lite.js":
/*!********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/popper-lite.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createPopper": () => (/* binding */ createPopper),
/* harmony export */   "defaultModifiers": () => (/* binding */ defaultModifiers),
/* harmony export */   "detectOverflow": () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   "popperGenerator": () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_4__.popperGenerator)
/* harmony export */ });
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./createPopper.js */ "./node_modules/@popperjs/core/lib/createPopper.js");
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./createPopper.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _modifiers_eventListeners_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./modifiers/eventListeners.js */ "./node_modules/@popperjs/core/lib/modifiers/eventListeners.js");
/* harmony import */ var _modifiers_popperOffsets_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./modifiers/popperOffsets.js */ "./node_modules/@popperjs/core/lib/modifiers/popperOffsets.js");
/* harmony import */ var _modifiers_computeStyles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./modifiers/computeStyles.js */ "./node_modules/@popperjs/core/lib/modifiers/computeStyles.js");
/* harmony import */ var _modifiers_applyStyles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./modifiers/applyStyles.js */ "./node_modules/@popperjs/core/lib/modifiers/applyStyles.js");





var defaultModifiers = [_modifiers_eventListeners_js__WEBPACK_IMPORTED_MODULE_0__["default"], _modifiers_popperOffsets_js__WEBPACK_IMPORTED_MODULE_1__["default"], _modifiers_computeStyles_js__WEBPACK_IMPORTED_MODULE_2__["default"], _modifiers_applyStyles_js__WEBPACK_IMPORTED_MODULE_3__["default"]];
var createPopper = /*#__PURE__*/(0,_createPopper_js__WEBPACK_IMPORTED_MODULE_4__.popperGenerator)({
  defaultModifiers: defaultModifiers
}); // eslint-disable-next-line import/no-unused-modules



/***/ }),

/***/ "./node_modules/@popperjs/core/lib/popper.js":
/*!***************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/popper.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "applyStyles": () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.applyStyles),
/* harmony export */   "arrow": () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.arrow),
/* harmony export */   "computeStyles": () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.computeStyles),
/* harmony export */   "createPopper": () => (/* binding */ createPopper),
/* harmony export */   "createPopperLite": () => (/* reexport safe */ _popper_lite_js__WEBPACK_IMPORTED_MODULE_11__.createPopper),
/* harmony export */   "defaultModifiers": () => (/* binding */ defaultModifiers),
/* harmony export */   "detectOverflow": () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   "eventListeners": () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.eventListeners),
/* harmony export */   "flip": () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.flip),
/* harmony export */   "hide": () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.hide),
/* harmony export */   "offset": () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.offset),
/* harmony export */   "popperGenerator": () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_9__.popperGenerator),
/* harmony export */   "popperOffsets": () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.popperOffsets),
/* harmony export */   "preventOverflow": () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.preventOverflow)
/* harmony export */ });
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./createPopper.js */ "./node_modules/@popperjs/core/lib/createPopper.js");
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./createPopper.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _modifiers_eventListeners_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./modifiers/eventListeners.js */ "./node_modules/@popperjs/core/lib/modifiers/eventListeners.js");
/* harmony import */ var _modifiers_popperOffsets_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./modifiers/popperOffsets.js */ "./node_modules/@popperjs/core/lib/modifiers/popperOffsets.js");
/* harmony import */ var _modifiers_computeStyles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./modifiers/computeStyles.js */ "./node_modules/@popperjs/core/lib/modifiers/computeStyles.js");
/* harmony import */ var _modifiers_applyStyles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./modifiers/applyStyles.js */ "./node_modules/@popperjs/core/lib/modifiers/applyStyles.js");
/* harmony import */ var _modifiers_offset_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./modifiers/offset.js */ "./node_modules/@popperjs/core/lib/modifiers/offset.js");
/* harmony import */ var _modifiers_flip_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./modifiers/flip.js */ "./node_modules/@popperjs/core/lib/modifiers/flip.js");
/* harmony import */ var _modifiers_preventOverflow_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./modifiers/preventOverflow.js */ "./node_modules/@popperjs/core/lib/modifiers/preventOverflow.js");
/* harmony import */ var _modifiers_arrow_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./modifiers/arrow.js */ "./node_modules/@popperjs/core/lib/modifiers/arrow.js");
/* harmony import */ var _modifiers_hide_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./modifiers/hide.js */ "./node_modules/@popperjs/core/lib/modifiers/hide.js");
/* harmony import */ var _popper_lite_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./popper-lite.js */ "./node_modules/@popperjs/core/lib/popper-lite.js");
/* harmony import */ var _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./modifiers/index.js */ "./node_modules/@popperjs/core/lib/modifiers/index.js");










var defaultModifiers = [_modifiers_eventListeners_js__WEBPACK_IMPORTED_MODULE_0__["default"], _modifiers_popperOffsets_js__WEBPACK_IMPORTED_MODULE_1__["default"], _modifiers_computeStyles_js__WEBPACK_IMPORTED_MODULE_2__["default"], _modifiers_applyStyles_js__WEBPACK_IMPORTED_MODULE_3__["default"], _modifiers_offset_js__WEBPACK_IMPORTED_MODULE_4__["default"], _modifiers_flip_js__WEBPACK_IMPORTED_MODULE_5__["default"], _modifiers_preventOverflow_js__WEBPACK_IMPORTED_MODULE_6__["default"], _modifiers_arrow_js__WEBPACK_IMPORTED_MODULE_7__["default"], _modifiers_hide_js__WEBPACK_IMPORTED_MODULE_8__["default"]];
var createPopper = /*#__PURE__*/(0,_createPopper_js__WEBPACK_IMPORTED_MODULE_9__.popperGenerator)({
  defaultModifiers: defaultModifiers
}); // eslint-disable-next-line import/no-unused-modules

 // eslint-disable-next-line import/no-unused-modules

 // eslint-disable-next-line import/no-unused-modules



/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/computeAutoPlacement.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/computeAutoPlacement.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ computeAutoPlacement)
/* harmony export */ });
/* harmony import */ var _getVariation_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getVariation.js */ "./node_modules/@popperjs/core/lib/utils/getVariation.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _detectOverflow_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./detectOverflow.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _getBasePlacement_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");




function computeAutoPlacement(state, options) {
  if (options === void 0) {
    options = {};
  }

  var _options = options,
      placement = _options.placement,
      boundary = _options.boundary,
      rootBoundary = _options.rootBoundary,
      padding = _options.padding,
      flipVariations = _options.flipVariations,
      _options$allowedAutoP = _options.allowedAutoPlacements,
      allowedAutoPlacements = _options$allowedAutoP === void 0 ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.placements : _options$allowedAutoP;
  var variation = (0,_getVariation_js__WEBPACK_IMPORTED_MODULE_1__["default"])(placement);
  var placements = variation ? flipVariations ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.variationPlacements : _enums_js__WEBPACK_IMPORTED_MODULE_0__.variationPlacements.filter(function (placement) {
    return (0,_getVariation_js__WEBPACK_IMPORTED_MODULE_1__["default"])(placement) === variation;
  }) : _enums_js__WEBPACK_IMPORTED_MODULE_0__.basePlacements;
  var allowedPlacements = placements.filter(function (placement) {
    return allowedAutoPlacements.indexOf(placement) >= 0;
  });

  if (allowedPlacements.length === 0) {
    allowedPlacements = placements;

    if (true) {
      console.error(['Popper: The `allowedAutoPlacements` option did not allow any', 'placements. Ensure the `placement` option matches the variation', 'of the allowed placements.', 'For example, "auto" cannot be used to allow "bottom-start".', 'Use "auto-start" instead.'].join(' '));
    }
  } // $FlowFixMe[incompatible-type]: Flow seems to have problems with two array unions...


  var overflows = allowedPlacements.reduce(function (acc, placement) {
    acc[placement] = (0,_detectOverflow_js__WEBPACK_IMPORTED_MODULE_2__["default"])(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      padding: padding
    })[(0,_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(placement)];
    return acc;
  }, {});
  return Object.keys(overflows).sort(function (a, b) {
    return overflows[a] - overflows[b];
  });
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/computeOffsets.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/computeOffsets.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ computeOffsets)
/* harmony export */ });
/* harmony import */ var _getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _getVariation_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getVariation.js */ "./node_modules/@popperjs/core/lib/utils/getVariation.js");
/* harmony import */ var _getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getMainAxisFromPlacement.js */ "./node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");




function computeOffsets(_ref) {
  var reference = _ref.reference,
      element = _ref.element,
      placement = _ref.placement;
  var basePlacement = placement ? (0,_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement) : null;
  var variation = placement ? (0,_getVariation_js__WEBPACK_IMPORTED_MODULE_1__["default"])(placement) : null;
  var commonX = reference.x + reference.width / 2 - element.width / 2;
  var commonY = reference.y + reference.height / 2 - element.height / 2;
  var offsets;

  switch (basePlacement) {
    case _enums_js__WEBPACK_IMPORTED_MODULE_2__.top:
      offsets = {
        x: commonX,
        y: reference.y - element.height
      };
      break;

    case _enums_js__WEBPACK_IMPORTED_MODULE_2__.bottom:
      offsets = {
        x: commonX,
        y: reference.y + reference.height
      };
      break;

    case _enums_js__WEBPACK_IMPORTED_MODULE_2__.right:
      offsets = {
        x: reference.x + reference.width,
        y: commonY
      };
      break;

    case _enums_js__WEBPACK_IMPORTED_MODULE_2__.left:
      offsets = {
        x: reference.x - element.width,
        y: commonY
      };
      break;

    default:
      offsets = {
        x: reference.x,
        y: reference.y
      };
  }

  var mainAxis = basePlacement ? (0,_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(basePlacement) : null;

  if (mainAxis != null) {
    var len = mainAxis === 'y' ? 'height' : 'width';

    switch (variation) {
      case _enums_js__WEBPACK_IMPORTED_MODULE_2__.start:
        offsets[mainAxis] = offsets[mainAxis] - (reference[len] / 2 - element[len] / 2);
        break;

      case _enums_js__WEBPACK_IMPORTED_MODULE_2__.end:
        offsets[mainAxis] = offsets[mainAxis] + (reference[len] / 2 - element[len] / 2);
        break;

      default:
    }
  }

  return offsets;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/debounce.js":
/*!***********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/debounce.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ debounce)
/* harmony export */ });
function debounce(fn) {
  var pending;
  return function () {
    if (!pending) {
      pending = new Promise(function (resolve) {
        Promise.resolve().then(function () {
          pending = undefined;
          resolve(fn());
        });
      });
    }

    return pending;
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/detectOverflow.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ detectOverflow)
/* harmony export */ });
/* harmony import */ var _dom_utils_getClippingRect_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../dom-utils/getClippingRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getClippingRect.js");
/* harmony import */ var _dom_utils_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../dom-utils/getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _dom_utils_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../dom-utils/getBoundingClientRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
/* harmony import */ var _computeOffsets_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./computeOffsets.js */ "./node_modules/@popperjs/core/lib/utils/computeOffsets.js");
/* harmony import */ var _rectToClientRect_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./rectToClientRect.js */ "./node_modules/@popperjs/core/lib/utils/rectToClientRect.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../dom-utils/instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _mergePaddingObject_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./mergePaddingObject.js */ "./node_modules/@popperjs/core/lib/utils/mergePaddingObject.js");
/* harmony import */ var _expandToHashMap_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./expandToHashMap.js */ "./node_modules/@popperjs/core/lib/utils/expandToHashMap.js");








 // eslint-disable-next-line import/no-unused-modules

function detectOverflow(state, options) {
  if (options === void 0) {
    options = {};
  }

  var _options = options,
      _options$placement = _options.placement,
      placement = _options$placement === void 0 ? state.placement : _options$placement,
      _options$boundary = _options.boundary,
      boundary = _options$boundary === void 0 ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.clippingParents : _options$boundary,
      _options$rootBoundary = _options.rootBoundary,
      rootBoundary = _options$rootBoundary === void 0 ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.viewport : _options$rootBoundary,
      _options$elementConte = _options.elementContext,
      elementContext = _options$elementConte === void 0 ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.popper : _options$elementConte,
      _options$altBoundary = _options.altBoundary,
      altBoundary = _options$altBoundary === void 0 ? false : _options$altBoundary,
      _options$padding = _options.padding,
      padding = _options$padding === void 0 ? 0 : _options$padding;
  var paddingObject = (0,_mergePaddingObject_js__WEBPACK_IMPORTED_MODULE_1__["default"])(typeof padding !== 'number' ? padding : (0,_expandToHashMap_js__WEBPACK_IMPORTED_MODULE_2__["default"])(padding, _enums_js__WEBPACK_IMPORTED_MODULE_0__.basePlacements));
  var altContext = elementContext === _enums_js__WEBPACK_IMPORTED_MODULE_0__.popper ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.reference : _enums_js__WEBPACK_IMPORTED_MODULE_0__.popper;
  var popperRect = state.rects.popper;
  var element = state.elements[altBoundary ? altContext : elementContext];
  var clippingClientRect = (0,_dom_utils_getClippingRect_js__WEBPACK_IMPORTED_MODULE_3__["default"])((0,_dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_4__.isElement)(element) ? element : element.contextElement || (0,_dom_utils_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_5__["default"])(state.elements.popper), boundary, rootBoundary);
  var referenceClientRect = (0,_dom_utils_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_6__["default"])(state.elements.reference);
  var popperOffsets = (0,_computeOffsets_js__WEBPACK_IMPORTED_MODULE_7__["default"])({
    reference: referenceClientRect,
    element: popperRect,
    strategy: 'absolute',
    placement: placement
  });
  var popperClientRect = (0,_rectToClientRect_js__WEBPACK_IMPORTED_MODULE_8__["default"])(Object.assign({}, popperRect, popperOffsets));
  var elementClientRect = elementContext === _enums_js__WEBPACK_IMPORTED_MODULE_0__.popper ? popperClientRect : referenceClientRect; // positive = overflowing the clipping rect
  // 0 or negative = within the clipping rect

  var overflowOffsets = {
    top: clippingClientRect.top - elementClientRect.top + paddingObject.top,
    bottom: elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom,
    left: clippingClientRect.left - elementClientRect.left + paddingObject.left,
    right: elementClientRect.right - clippingClientRect.right + paddingObject.right
  };
  var offsetData = state.modifiersData.offset; // Offsets can be applied only to the popper element

  if (elementContext === _enums_js__WEBPACK_IMPORTED_MODULE_0__.popper && offsetData) {
    var offset = offsetData[placement];
    Object.keys(overflowOffsets).forEach(function (key) {
      var multiply = [_enums_js__WEBPACK_IMPORTED_MODULE_0__.right, _enums_js__WEBPACK_IMPORTED_MODULE_0__.bottom].indexOf(key) >= 0 ? 1 : -1;
      var axis = [_enums_js__WEBPACK_IMPORTED_MODULE_0__.top, _enums_js__WEBPACK_IMPORTED_MODULE_0__.bottom].indexOf(key) >= 0 ? 'y' : 'x';
      overflowOffsets[key] += offset[axis] * multiply;
    });
  }

  return overflowOffsets;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/expandToHashMap.js":
/*!******************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/expandToHashMap.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ expandToHashMap)
/* harmony export */ });
function expandToHashMap(value, keys) {
  return keys.reduce(function (hashMap, key) {
    hashMap[key] = value;
    return hashMap;
  }, {});
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/format.js":
/*!*********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/format.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ format)
/* harmony export */ });
function format(str) {
  for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    args[_key - 1] = arguments[_key];
  }

  return [].concat(args).reduce(function (p, c) {
    return p.replace(/%s/, c);
  }, str);
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getAltAxis.js":
/*!*************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getAltAxis.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getAltAxis)
/* harmony export */ });
function getAltAxis(axis) {
  return axis === 'x' ? 'y' : 'x';
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getBasePlacement.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getBasePlacement)
/* harmony export */ });

function getBasePlacement(placement) {
  return placement.split('-')[0];
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getFreshSideObject.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getFreshSideObject.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getFreshSideObject)
/* harmony export */ });
function getFreshSideObject() {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getMainAxisFromPlacement)
/* harmony export */ });
function getMainAxisFromPlacement(placement) {
  return ['top', 'bottom'].indexOf(placement) >= 0 ? 'x' : 'y';
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getOppositePlacement.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getOppositePlacement.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getOppositePlacement)
/* harmony export */ });
var hash = {
  left: 'right',
  right: 'left',
  bottom: 'top',
  top: 'bottom'
};
function getOppositePlacement(placement) {
  return placement.replace(/left|right|bottom|top/g, function (matched) {
    return hash[matched];
  });
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getOppositeVariationPlacement.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getOppositeVariationPlacement.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getOppositeVariationPlacement)
/* harmony export */ });
var hash = {
  start: 'end',
  end: 'start'
};
function getOppositeVariationPlacement(placement) {
  return placement.replace(/start|end/g, function (matched) {
    return hash[matched];
  });
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getVariation.js":
/*!***************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getVariation.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getVariation)
/* harmony export */ });
function getVariation(placement) {
  return placement.split('-')[1];
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/math.js":
/*!*******************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/math.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "max": () => (/* binding */ max),
/* harmony export */   "min": () => (/* binding */ min),
/* harmony export */   "round": () => (/* binding */ round)
/* harmony export */ });
var max = Math.max;
var min = Math.min;
var round = Math.round;

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/mergeByName.js":
/*!**************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/mergeByName.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ mergeByName)
/* harmony export */ });
function mergeByName(modifiers) {
  var merged = modifiers.reduce(function (merged, current) {
    var existing = merged[current.name];
    merged[current.name] = existing ? Object.assign({}, existing, current, {
      options: Object.assign({}, existing.options, current.options),
      data: Object.assign({}, existing.data, current.data)
    }) : current;
    return merged;
  }, {}); // IE11 does not support Object.values

  return Object.keys(merged).map(function (key) {
    return merged[key];
  });
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/mergePaddingObject.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/mergePaddingObject.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ mergePaddingObject)
/* harmony export */ });
/* harmony import */ var _getFreshSideObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getFreshSideObject.js */ "./node_modules/@popperjs/core/lib/utils/getFreshSideObject.js");

function mergePaddingObject(paddingObject) {
  return Object.assign({}, (0,_getFreshSideObject_js__WEBPACK_IMPORTED_MODULE_0__["default"])(), paddingObject);
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/orderModifiers.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/orderModifiers.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ orderModifiers)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
 // source: https://stackoverflow.com/questions/49875255

function order(modifiers) {
  var map = new Map();
  var visited = new Set();
  var result = [];
  modifiers.forEach(function (modifier) {
    map.set(modifier.name, modifier);
  }); // On visiting object, check for its dependencies and visit them recursively

  function sort(modifier) {
    visited.add(modifier.name);
    var requires = [].concat(modifier.requires || [], modifier.requiresIfExists || []);
    requires.forEach(function (dep) {
      if (!visited.has(dep)) {
        var depModifier = map.get(dep);

        if (depModifier) {
          sort(depModifier);
        }
      }
    });
    result.push(modifier);
  }

  modifiers.forEach(function (modifier) {
    if (!visited.has(modifier.name)) {
      // check for visited object
      sort(modifier);
    }
  });
  return result;
}

function orderModifiers(modifiers) {
  // order based on dependencies
  var orderedModifiers = order(modifiers); // order based on phase

  return _enums_js__WEBPACK_IMPORTED_MODULE_0__.modifierPhases.reduce(function (acc, phase) {
    return acc.concat(orderedModifiers.filter(function (modifier) {
      return modifier.phase === phase;
    }));
  }, []);
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/rectToClientRect.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/rectToClientRect.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ rectToClientRect)
/* harmony export */ });
function rectToClientRect(rect) {
  return Object.assign({}, rect, {
    left: rect.x,
    top: rect.y,
    right: rect.x + rect.width,
    bottom: rect.y + rect.height
  });
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/uniqueBy.js":
/*!***********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/uniqueBy.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ uniqueBy)
/* harmony export */ });
function uniqueBy(arr, fn) {
  var identifiers = new Set();
  return arr.filter(function (item) {
    var identifier = fn(item);

    if (!identifiers.has(identifier)) {
      identifiers.add(identifier);
      return true;
    }
  });
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/validateModifiers.js":
/*!********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/validateModifiers.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ validateModifiers)
/* harmony export */ });
/* harmony import */ var _format_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./format.js */ "./node_modules/@popperjs/core/lib/utils/format.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");


var INVALID_MODIFIER_ERROR = 'Popper: modifier "%s" provided an invalid %s property, expected %s but got %s';
var MISSING_DEPENDENCY_ERROR = 'Popper: modifier "%s" requires "%s", but "%s" modifier is not available';
var VALID_PROPERTIES = ['name', 'enabled', 'phase', 'fn', 'effect', 'requires', 'options'];
function validateModifiers(modifiers) {
  modifiers.forEach(function (modifier) {
    [].concat(Object.keys(modifier), VALID_PROPERTIES) // IE11-compatible replacement for `new Set(iterable)`
    .filter(function (value, index, self) {
      return self.indexOf(value) === index;
    }).forEach(function (key) {
      switch (key) {
        case 'name':
          if (typeof modifier.name !== 'string') {
            console.error((0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(INVALID_MODIFIER_ERROR, String(modifier.name), '"name"', '"string"', "\"" + String(modifier.name) + "\""));
          }

          break;

        case 'enabled':
          if (typeof modifier.enabled !== 'boolean') {
            console.error((0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(INVALID_MODIFIER_ERROR, modifier.name, '"enabled"', '"boolean"', "\"" + String(modifier.enabled) + "\""));
          }

          break;

        case 'phase':
          if (_enums_js__WEBPACK_IMPORTED_MODULE_1__.modifierPhases.indexOf(modifier.phase) < 0) {
            console.error((0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(INVALID_MODIFIER_ERROR, modifier.name, '"phase"', "either " + _enums_js__WEBPACK_IMPORTED_MODULE_1__.modifierPhases.join(', '), "\"" + String(modifier.phase) + "\""));
          }

          break;

        case 'fn':
          if (typeof modifier.fn !== 'function') {
            console.error((0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(INVALID_MODIFIER_ERROR, modifier.name, '"fn"', '"function"', "\"" + String(modifier.fn) + "\""));
          }

          break;

        case 'effect':
          if (modifier.effect != null && typeof modifier.effect !== 'function') {
            console.error((0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(INVALID_MODIFIER_ERROR, modifier.name, '"effect"', '"function"', "\"" + String(modifier.fn) + "\""));
          }

          break;

        case 'requires':
          if (modifier.requires != null && !Array.isArray(modifier.requires)) {
            console.error((0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(INVALID_MODIFIER_ERROR, modifier.name, '"requires"', '"array"', "\"" + String(modifier.requires) + "\""));
          }

          break;

        case 'requiresIfExists':
          if (!Array.isArray(modifier.requiresIfExists)) {
            console.error((0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(INVALID_MODIFIER_ERROR, modifier.name, '"requiresIfExists"', '"array"', "\"" + String(modifier.requiresIfExists) + "\""));
          }

          break;

        case 'options':
        case 'data':
          break;

        default:
          console.error("PopperJS: an invalid property has been provided to the \"" + modifier.name + "\" modifier, valid properties are " + VALID_PROPERTIES.map(function (s) {
            return "\"" + s + "\"";
          }).join(', ') + "; but \"" + key + "\" was provided.");
      }

      modifier.requires && modifier.requires.forEach(function (requirement) {
        if (modifiers.find(function (mod) {
          return mod.name === requirement;
        }) == null) {
          console.error((0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(MISSING_DEPENDENCY_ERROR, String(modifier.name), requirement, requirement));
        }
      });
    });
  });
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/within.js":
/*!*********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/within.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "within": () => (/* binding */ within),
/* harmony export */   "withinMaxClamp": () => (/* binding */ withinMaxClamp)
/* harmony export */ });
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");

function within(min, value, max) {
  return (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.max)(min, (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.min)(value, max));
}
function withinMaxClamp(min, value, max) {
  var v = within(min, value, max);
  return v > max ? max : v;
}

/***/ }),

/***/ "./public/backend/js/loadah.min.js":
/*!*****************************************!*\
  !*** ./public/backend/js/loadah.min.js ***!
  \*****************************************/
/***/ (function(module, exports, __webpack_require__) {

/* module decorator */ module = __webpack_require__.nmd(module);
var __WEBPACK_AMD_DEFINE_RESULT__;function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
/**
 * @license
 * Lodash <https://lodash.com/>
 * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */
(function () {
  function n(n, t, r) {
    switch (r.length) {
      case 0:
        return n.call(t);
      case 1:
        return n.call(t, r[0]);
      case 2:
        return n.call(t, r[0], r[1]);
      case 3:
        return n.call(t, r[0], r[1], r[2]);
    }
    return n.apply(t, r);
  }
  function t(n, t, r, e) {
    for (var u = -1, i = null == n ? 0 : n.length; ++u < i;) {
      var o = n[u];
      t(e, o, r(o), n);
    }
    return e;
  }
  function r(n, t) {
    for (var r = -1, e = null == n ? 0 : n.length; ++r < e && t(n[r], r, n) !== !1;) {
      ;
    }
    return n;
  }
  function e(n, t) {
    for (var r = null == n ? 0 : n.length; r-- && t(n[r], r, n) !== !1;) {
      ;
    }
    return n;
  }
  function u(n, t) {
    for (var r = -1, e = null == n ? 0 : n.length; ++r < e;) {
      if (!t(n[r], r, n)) return !1;
    }
    return !0;
  }
  function i(n, t) {
    for (var r = -1, e = null == n ? 0 : n.length, u = 0, i = []; ++r < e;) {
      var o = n[r];
      t(o, r, n) && (i[u++] = o);
    }
    return i;
  }
  function o(n, t) {
    return !!(null == n ? 0 : n.length) && y(n, t, 0) > -1;
  }
  function f(n, t, r) {
    for (var e = -1, u = null == n ? 0 : n.length; ++e < u;) {
      if (r(t, n[e])) return !0;
    }
    return !1;
  }
  function c(n, t) {
    for (var r = -1, e = null == n ? 0 : n.length, u = Array(e); ++r < e;) {
      u[r] = t(n[r], r, n);
    }
    return u;
  }
  function a(n, t) {
    for (var r = -1, e = t.length, u = n.length; ++r < e;) {
      n[u + r] = t[r];
    }
    return n;
  }
  function l(n, t, r, e) {
    var u = -1,
      i = null == n ? 0 : n.length;
    for (e && i && (r = n[++u]); ++u < i;) {
      r = t(r, n[u], u, n);
    }
    return r;
  }
  function s(n, t, r, e) {
    var u = null == n ? 0 : n.length;
    for (e && u && (r = n[--u]); u--;) {
      r = t(r, n[u], u, n);
    }
    return r;
  }
  function h(n, t) {
    for (var r = -1, e = null == n ? 0 : n.length; ++r < e;) {
      if (t(n[r], r, n)) return !0;
    }
    return !1;
  }
  function p(n) {
    return n.split("");
  }
  function _(n) {
    return n.match($t) || [];
  }
  function v(n, t, r) {
    var e;
    return r(n, function (n, r, u) {
      if (t(n, r, u)) return e = r, !1;
    }), e;
  }
  function g(n, t, r, e) {
    for (var u = n.length, i = r + (e ? 1 : -1); e ? i-- : ++i < u;) {
      if (t(n[i], i, n)) return i;
    }
    return -1;
  }
  function y(n, t, r) {
    return t === t ? Z(n, t, r) : g(n, b, r);
  }
  function d(n, t, r, e) {
    for (var u = r - 1, i = n.length; ++u < i;) {
      if (e(n[u], t)) return u;
    }
    return -1;
  }
  function b(n) {
    return n !== n;
  }
  function w(n, t) {
    var r = null == n ? 0 : n.length;
    return r ? k(n, t) / r : Cn;
  }
  function m(n) {
    return function (t) {
      return null == t ? X : t[n];
    };
  }
  function x(n) {
    return function (t) {
      return null == n ? X : n[t];
    };
  }
  function j(n, t, r, e, u) {
    return u(n, function (n, u, i) {
      r = e ? (e = !1, n) : t(r, n, u, i);
    }), r;
  }
  function A(n, t) {
    var r = n.length;
    for (n.sort(t); r--;) {
      n[r] = n[r].value;
    }
    return n;
  }
  function k(n, t) {
    for (var r, e = -1, u = n.length; ++e < u;) {
      var i = t(n[e]);
      i !== X && (r = r === X ? i : r + i);
    }
    return r;
  }
  function O(n, t) {
    for (var r = -1, e = Array(n); ++r < n;) {
      e[r] = t(r);
    }
    return e;
  }
  function I(n, t) {
    return c(t, function (t) {
      return [t, n[t]];
    });
  }
  function R(n) {
    return n ? n.slice(0, H(n) + 1).replace(Lt, "") : n;
  }
  function z(n) {
    return function (t) {
      return n(t);
    };
  }
  function E(n, t) {
    return c(t, function (t) {
      return n[t];
    });
  }
  function S(n, t) {
    return n.has(t);
  }
  function W(n, t) {
    for (var r = -1, e = n.length; ++r < e && y(t, n[r], 0) > -1;) {
      ;
    }
    return r;
  }
  function L(n, t) {
    for (var r = n.length; r-- && y(t, n[r], 0) > -1;) {
      ;
    }
    return r;
  }
  function C(n, t) {
    for (var r = n.length, e = 0; r--;) {
      n[r] === t && ++e;
    }
    return e;
  }
  function U(n) {
    return "\\" + Yr[n];
  }
  function B(n, t) {
    return null == n ? X : n[t];
  }
  function T(n) {
    return Nr.test(n);
  }
  function $(n) {
    return Pr.test(n);
  }
  function D(n) {
    for (var t, r = []; !(t = n.next()).done;) {
      r.push(t.value);
    }
    return r;
  }
  function M(n) {
    var t = -1,
      r = Array(n.size);
    return n.forEach(function (n, e) {
      r[++t] = [e, n];
    }), r;
  }
  function F(n, t) {
    return function (r) {
      return n(t(r));
    };
  }
  function N(n, t) {
    for (var r = -1, e = n.length, u = 0, i = []; ++r < e;) {
      var o = n[r];
      o !== t && o !== cn || (n[r] = cn, i[u++] = r);
    }
    return i;
  }
  function P(n) {
    var t = -1,
      r = Array(n.size);
    return n.forEach(function (n) {
      r[++t] = n;
    }), r;
  }
  function q(n) {
    var t = -1,
      r = Array(n.size);
    return n.forEach(function (n) {
      r[++t] = [n, n];
    }), r;
  }
  function Z(n, t, r) {
    for (var e = r - 1, u = n.length; ++e < u;) {
      if (n[e] === t) return e;
    }
    return -1;
  }
  function K(n, t, r) {
    for (var e = r + 1; e--;) {
      if (n[e] === t) return e;
    }
    return e;
  }
  function V(n) {
    return T(n) ? J(n) : _e(n);
  }
  function G(n) {
    return T(n) ? Y(n) : p(n);
  }
  function H(n) {
    for (var t = n.length; t-- && Ct.test(n.charAt(t));) {
      ;
    }
    return t;
  }
  function J(n) {
    for (var t = Mr.lastIndex = 0; Mr.test(n);) {
      ++t;
    }
    return t;
  }
  function Y(n) {
    return n.match(Mr) || [];
  }
  function Q(n) {
    return n.match(Fr) || [];
  }
  var X,
    nn = "4.17.21",
    tn = 200,
    rn = "Unsupported core-js use. Try https://npms.io/search?q=ponyfill.",
    en = "Expected a function",
    un = "Invalid `variable` option passed into `_.template`",
    on = "__lodash_hash_undefined__",
    fn = 500,
    cn = "__lodash_placeholder__",
    an = 1,
    ln = 2,
    sn = 4,
    hn = 1,
    pn = 2,
    _n = 1,
    vn = 2,
    gn = 4,
    yn = 8,
    dn = 16,
    bn = 32,
    wn = 64,
    mn = 128,
    xn = 256,
    jn = 512,
    An = 30,
    kn = "...",
    On = 800,
    In = 16,
    Rn = 1,
    zn = 2,
    En = 3,
    Sn = 1 / 0,
    Wn = 9007199254740991,
    Ln = 1.7976931348623157e308,
    Cn = NaN,
    Un = 4294967295,
    Bn = Un - 1,
    Tn = Un >>> 1,
    $n = [["ary", mn], ["bind", _n], ["bindKey", vn], ["curry", yn], ["curryRight", dn], ["flip", jn], ["partial", bn], ["partialRight", wn], ["rearg", xn]],
    Dn = "[object Arguments]",
    Mn = "[object Array]",
    Fn = "[object AsyncFunction]",
    Nn = "[object Boolean]",
    Pn = "[object Date]",
    qn = "[object DOMException]",
    Zn = "[object Error]",
    Kn = "[object Function]",
    Vn = "[object GeneratorFunction]",
    Gn = "[object Map]",
    Hn = "[object Number]",
    Jn = "[object Null]",
    Yn = "[object Object]",
    Qn = "[object Promise]",
    Xn = "[object Proxy]",
    nt = "[object RegExp]",
    tt = "[object Set]",
    rt = "[object String]",
    et = "[object Symbol]",
    ut = "[object Undefined]",
    it = "[object WeakMap]",
    ot = "[object WeakSet]",
    ft = "[object ArrayBuffer]",
    ct = "[object DataView]",
    at = "[object Float32Array]",
    lt = "[object Float64Array]",
    st = "[object Int8Array]",
    ht = "[object Int16Array]",
    pt = "[object Int32Array]",
    _t = "[object Uint8Array]",
    vt = "[object Uint8ClampedArray]",
    gt = "[object Uint16Array]",
    yt = "[object Uint32Array]",
    dt = /\b__p \+= '';/g,
    bt = /\b(__p \+=) '' \+/g,
    wt = /(__e\(.*?\)|\b__t\)) \+\n'';/g,
    mt = /&(?:amp|lt|gt|quot|#39);/g,
    xt = /[&<>"']/g,
    jt = RegExp(mt.source),
    At = RegExp(xt.source),
    kt = /<%-([\s\S]+?)%>/g,
    Ot = /<%([\s\S]+?)%>/g,
    It = /<%=([\s\S]+?)%>/g,
    Rt = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
    zt = /^\w*$/,
    Et = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,
    St = /[\\^$.*+?()[\]{}|]/g,
    Wt = RegExp(St.source),
    Lt = /^\s+/,
    Ct = /\s/,
    Ut = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,
    Bt = /\{\n\/\* \[wrapped with (.+)\] \*/,
    Tt = /,? & /,
    $t = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g,
    Dt = /[()=,{}\[\]\/\s]/,
    Mt = /\\(\\)?/g,
    Ft = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g,
    Nt = /\w*$/,
    Pt = /^[-+]0x[0-9a-f]+$/i,
    qt = /^0b[01]+$/i,
    Zt = /^\[object .+?Constructor\]$/,
    Kt = /^0o[0-7]+$/i,
    Vt = /^(?:0|[1-9]\d*)$/,
    Gt = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g,
    Ht = /($^)/,
    Jt = /['\n\r\u2028\u2029\\]/g,
    Yt = "\\ud800-\\udfff",
    Qt = "\\u0300-\\u036f",
    Xt = "\\ufe20-\\ufe2f",
    nr = "\\u20d0-\\u20ff",
    tr = Qt + Xt + nr,
    rr = "\\u2700-\\u27bf",
    er = "a-z\\xdf-\\xf6\\xf8-\\xff",
    ur = "\\xac\\xb1\\xd7\\xf7",
    ir = "\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf",
    or = "\\u2000-\\u206f",
    fr = " \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000",
    cr = "A-Z\\xc0-\\xd6\\xd8-\\xde",
    ar = "\\ufe0e\\ufe0f",
    lr = ur + ir + or + fr,
    sr = "['\u2019]",
    hr = "[" + Yt + "]",
    pr = "[" + lr + "]",
    _r = "[" + tr + "]",
    vr = "\\d+",
    gr = "[" + rr + "]",
    yr = "[" + er + "]",
    dr = "[^" + Yt + lr + vr + rr + er + cr + "]",
    br = "\\ud83c[\\udffb-\\udfff]",
    wr = "(?:" + _r + "|" + br + ")",
    mr = "[^" + Yt + "]",
    xr = "(?:\\ud83c[\\udde6-\\uddff]){2}",
    jr = "[\\ud800-\\udbff][\\udc00-\\udfff]",
    Ar = "[" + cr + "]",
    kr = "\\u200d",
    Or = "(?:" + yr + "|" + dr + ")",
    Ir = "(?:" + Ar + "|" + dr + ")",
    Rr = "(?:" + sr + "(?:d|ll|m|re|s|t|ve))?",
    zr = "(?:" + sr + "(?:D|LL|M|RE|S|T|VE))?",
    Er = wr + "?",
    Sr = "[" + ar + "]?",
    Wr = "(?:" + kr + "(?:" + [mr, xr, jr].join("|") + ")" + Sr + Er + ")*",
    Lr = "\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])",
    Cr = "\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])",
    Ur = Sr + Er + Wr,
    Br = "(?:" + [gr, xr, jr].join("|") + ")" + Ur,
    Tr = "(?:" + [mr + _r + "?", _r, xr, jr, hr].join("|") + ")",
    $r = RegExp(sr, "g"),
    Dr = RegExp(_r, "g"),
    Mr = RegExp(br + "(?=" + br + ")|" + Tr + Ur, "g"),
    Fr = RegExp([Ar + "?" + yr + "+" + Rr + "(?=" + [pr, Ar, "$"].join("|") + ")", Ir + "+" + zr + "(?=" + [pr, Ar + Or, "$"].join("|") + ")", Ar + "?" + Or + "+" + Rr, Ar + "+" + zr, Cr, Lr, vr, Br].join("|"), "g"),
    Nr = RegExp("[" + kr + Yt + tr + ar + "]"),
    Pr = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/,
    qr = ["Array", "Buffer", "DataView", "Date", "Error", "Float32Array", "Float64Array", "Function", "Int8Array", "Int16Array", "Int32Array", "Map", "Math", "Object", "Promise", "RegExp", "Set", "String", "Symbol", "TypeError", "Uint8Array", "Uint8ClampedArray", "Uint16Array", "Uint32Array", "WeakMap", "_", "clearTimeout", "isFinite", "parseInt", "setTimeout"],
    Zr = -1,
    Kr = {};
  Kr[at] = Kr[lt] = Kr[st] = Kr[ht] = Kr[pt] = Kr[_t] = Kr[vt] = Kr[gt] = Kr[yt] = !0, Kr[Dn] = Kr[Mn] = Kr[ft] = Kr[Nn] = Kr[ct] = Kr[Pn] = Kr[Zn] = Kr[Kn] = Kr[Gn] = Kr[Hn] = Kr[Yn] = Kr[nt] = Kr[tt] = Kr[rt] = Kr[it] = !1;
  var Vr = {};
  Vr[Dn] = Vr[Mn] = Vr[ft] = Vr[ct] = Vr[Nn] = Vr[Pn] = Vr[at] = Vr[lt] = Vr[st] = Vr[ht] = Vr[pt] = Vr[Gn] = Vr[Hn] = Vr[Yn] = Vr[nt] = Vr[tt] = Vr[rt] = Vr[et] = Vr[_t] = Vr[vt] = Vr[gt] = Vr[yt] = !0, Vr[Zn] = Vr[Kn] = Vr[it] = !1;
  var Gr = {
      "\xc0": "A",
      "\xc1": "A",
      "\xc2": "A",
      "\xc3": "A",
      "\xc4": "A",
      "\xc5": "A",
      "\xe0": "a",
      "\xe1": "a",
      "\xe2": "a",
      "\xe3": "a",
      "\xe4": "a",
      "\xe5": "a",
      "\xc7": "C",
      "\xe7": "c",
      "\xd0": "D",
      "\xf0": "d",
      "\xc8": "E",
      "\xc9": "E",
      "\xca": "E",
      "\xcb": "E",
      "\xe8": "e",
      "\xe9": "e",
      "\xea": "e",
      "\xeb": "e",
      "\xcc": "I",
      "\xcd": "I",
      "\xce": "I",
      "\xcf": "I",
      "\xec": "i",
      "\xed": "i",
      "\xee": "i",
      "\xef": "i",
      "\xd1": "N",
      "\xf1": "n",
      "\xd2": "O",
      "\xd3": "O",
      "\xd4": "O",
      "\xd5": "O",
      "\xd6": "O",
      "\xd8": "O",
      "\xf2": "o",
      "\xf3": "o",
      "\xf4": "o",
      "\xf5": "o",
      "\xf6": "o",
      "\xf8": "o",
      "\xd9": "U",
      "\xda": "U",
      "\xdb": "U",
      "\xdc": "U",
      "\xf9": "u",
      "\xfa": "u",
      "\xfb": "u",
      "\xfc": "u",
      "\xdd": "Y",
      "\xfd": "y",
      "\xff": "y",
      "\xc6": "Ae",
      "\xe6": "ae",
      "\xde": "Th",
      "\xfe": "th",
      "\xdf": "ss",
      "\u0100": "A",
      "\u0102": "A",
      "\u0104": "A",
      "\u0101": "a",
      "\u0103": "a",
      "\u0105": "a",
      "\u0106": "C",
      "\u0108": "C",
      "\u010A": "C",
      "\u010C": "C",
      "\u0107": "c",
      "\u0109": "c",
      "\u010B": "c",
      "\u010D": "c",
      "\u010E": "D",
      "\u0110": "D",
      "\u010F": "d",
      "\u0111": "d",
      "\u0112": "E",
      "\u0114": "E",
      "\u0116": "E",
      "\u0118": "E",
      "\u011A": "E",
      "\u0113": "e",
      "\u0115": "e",
      "\u0117": "e",
      "\u0119": "e",
      "\u011B": "e",
      "\u011C": "G",
      "\u011E": "G",
      "\u0120": "G",
      "\u0122": "G",
      "\u011D": "g",
      "\u011F": "g",
      "\u0121": "g",
      "\u0123": "g",
      "\u0124": "H",
      "\u0126": "H",
      "\u0125": "h",
      "\u0127": "h",
      "\u0128": "I",
      "\u012A": "I",
      "\u012C": "I",
      "\u012E": "I",
      "\u0130": "I",
      "\u0129": "i",
      "\u012B": "i",
      "\u012D": "i",
      "\u012F": "i",
      "\u0131": "i",
      "\u0134": "J",
      "\u0135": "j",
      "\u0136": "K",
      "\u0137": "k",
      "\u0138": "k",
      "\u0139": "L",
      "\u013B": "L",
      "\u013D": "L",
      "\u013F": "L",
      "\u0141": "L",
      "\u013A": "l",
      "\u013C": "l",
      "\u013E": "l",
      "\u0140": "l",
      "\u0142": "l",
      "\u0143": "N",
      "\u0145": "N",
      "\u0147": "N",
      "\u014A": "N",
      "\u0144": "n",
      "\u0146": "n",
      "\u0148": "n",
      "\u014B": "n",
      "\u014C": "O",
      "\u014E": "O",
      "\u0150": "O",
      "\u014D": "o",
      "\u014F": "o",
      "\u0151": "o",
      "\u0154": "R",
      "\u0156": "R",
      "\u0158": "R",
      "\u0155": "r",
      "\u0157": "r",
      "\u0159": "r",
      "\u015A": "S",
      "\u015C": "S",
      "\u015E": "S",
      "\u0160": "S",
      "\u015B": "s",
      "\u015D": "s",
      "\u015F": "s",
      "\u0161": "s",
      "\u0162": "T",
      "\u0164": "T",
      "\u0166": "T",
      "\u0163": "t",
      "\u0165": "t",
      "\u0167": "t",
      "\u0168": "U",
      "\u016A": "U",
      "\u016C": "U",
      "\u016E": "U",
      "\u0170": "U",
      "\u0172": "U",
      "\u0169": "u",
      "\u016B": "u",
      "\u016D": "u",
      "\u016F": "u",
      "\u0171": "u",
      "\u0173": "u",
      "\u0174": "W",
      "\u0175": "w",
      "\u0176": "Y",
      "\u0177": "y",
      "\u0178": "Y",
      "\u0179": "Z",
      "\u017B": "Z",
      "\u017D": "Z",
      "\u017A": "z",
      "\u017C": "z",
      "\u017E": "z",
      "\u0132": "IJ",
      "\u0133": "ij",
      "\u0152": "Oe",
      "\u0153": "oe",
      "\u0149": "'n",
      "\u017F": "s"
    },
    Hr = {
      "&": "&amp;",
      "<": "&lt;",
      ">": "&gt;",
      '"': "&quot;",
      "'": "&#39;"
    },
    Jr = {
      "&amp;": "&",
      "&lt;": "<",
      "&gt;": ">",
      "&quot;": '"',
      "&#39;": "'"
    },
    Yr = {
      "\\": "\\",
      "'": "'",
      "\n": "n",
      "\r": "r",
      "\u2028": "u2028",
      "\u2029": "u2029"
    },
    Qr = parseFloat,
    Xr = parseInt,
    ne = "object" == (typeof __webpack_require__.g === "undefined" ? "undefined" : _typeof(__webpack_require__.g)) && __webpack_require__.g && __webpack_require__.g.Object === Object && __webpack_require__.g,
    te = "object" == (typeof self === "undefined" ? "undefined" : _typeof(self)) && self && self.Object === Object && self,
    re = ne || te || Function("return this")(),
    ee = "object" == ( false ? 0 : _typeof(exports)) && exports && !exports.nodeType && exports,
    ue = ee && "object" == ( false ? 0 : _typeof(module)) && module && !module.nodeType && module,
    ie = ue && ue.exports === ee,
    oe = ie && ne.process,
    fe = function () {
      try {
        var n = ue && ue.require && ue.require("util").types;
        return n ? n : oe && oe.binding && oe.binding("util");
      } catch (n) {}
    }(),
    ce = fe && fe.isArrayBuffer,
    ae = fe && fe.isDate,
    le = fe && fe.isMap,
    se = fe && fe.isRegExp,
    he = fe && fe.isSet,
    pe = fe && fe.isTypedArray,
    _e = m("length"),
    ve = x(Gr),
    ge = x(Hr),
    ye = x(Jr),
    de = function p(x) {
      function Z(n) {
        if (cc(n) && !bh(n) && !(n instanceof Ct)) {
          if (n instanceof Y) return n;
          if (bl.call(n, "__wrapped__")) return eo(n);
        }
        return new Y(n);
      }
      function J() {}
      function Y(n, t) {
        this.__wrapped__ = n, this.__actions__ = [], this.__chain__ = !!t, this.__index__ = 0, this.__values__ = X;
      }
      function Ct(n) {
        this.__wrapped__ = n, this.__actions__ = [], this.__dir__ = 1, this.__filtered__ = !1, this.__iteratees__ = [], this.__takeCount__ = Un, this.__views__ = [];
      }
      function $t() {
        var n = new Ct(this.__wrapped__);
        return n.__actions__ = Tu(this.__actions__), n.__dir__ = this.__dir__, n.__filtered__ = this.__filtered__, n.__iteratees__ = Tu(this.__iteratees__), n.__takeCount__ = this.__takeCount__, n.__views__ = Tu(this.__views__), n;
      }
      function Yt() {
        if (this.__filtered__) {
          var n = new Ct(this);
          n.__dir__ = -1, n.__filtered__ = !0;
        } else n = this.clone(), n.__dir__ *= -1;
        return n;
      }
      function Qt() {
        var n = this.__wrapped__.value(),
          t = this.__dir__,
          r = bh(n),
          e = t < 0,
          u = r ? n.length : 0,
          i = Oi(0, u, this.__views__),
          o = i.start,
          f = i.end,
          c = f - o,
          a = e ? f : o - 1,
          l = this.__iteratees__,
          s = l.length,
          h = 0,
          p = Hl(c, this.__takeCount__);
        if (!r || !e && u == c && p == c) return wu(n, this.__actions__);
        var _ = [];
        n: for (; c-- && h < p;) {
          a += t;
          for (var v = -1, g = n[a]; ++v < s;) {
            var y = l[v],
              d = y.iteratee,
              b = y.type,
              w = d(g);
            if (b == zn) g = w;else if (!w) {
              if (b == Rn) continue n;
              break n;
            }
          }
          _[h++] = g;
        }
        return _;
      }
      function Xt(n) {
        var t = -1,
          r = null == n ? 0 : n.length;
        for (this.clear(); ++t < r;) {
          var e = n[t];
          this.set(e[0], e[1]);
        }
      }
      function nr() {
        this.__data__ = is ? is(null) : {}, this.size = 0;
      }
      function tr(n) {
        var t = this.has(n) && delete this.__data__[n];
        return this.size -= t ? 1 : 0, t;
      }
      function rr(n) {
        var t = this.__data__;
        if (is) {
          var r = t[n];
          return r === on ? X : r;
        }
        return bl.call(t, n) ? t[n] : X;
      }
      function er(n) {
        var t = this.__data__;
        return is ? t[n] !== X : bl.call(t, n);
      }
      function ur(n, t) {
        var r = this.__data__;
        return this.size += this.has(n) ? 0 : 1, r[n] = is && t === X ? on : t, this;
      }
      function ir(n) {
        var t = -1,
          r = null == n ? 0 : n.length;
        for (this.clear(); ++t < r;) {
          var e = n[t];
          this.set(e[0], e[1]);
        }
      }
      function or() {
        this.__data__ = [], this.size = 0;
      }
      function fr(n) {
        var t = this.__data__,
          r = Wr(t, n);
        return !(r < 0) && (r == t.length - 1 ? t.pop() : Ll.call(t, r, 1), --this.size, !0);
      }
      function cr(n) {
        var t = this.__data__,
          r = Wr(t, n);
        return r < 0 ? X : t[r][1];
      }
      function ar(n) {
        return Wr(this.__data__, n) > -1;
      }
      function lr(n, t) {
        var r = this.__data__,
          e = Wr(r, n);
        return e < 0 ? (++this.size, r.push([n, t])) : r[e][1] = t, this;
      }
      function sr(n) {
        var t = -1,
          r = null == n ? 0 : n.length;
        for (this.clear(); ++t < r;) {
          var e = n[t];
          this.set(e[0], e[1]);
        }
      }
      function hr() {
        this.size = 0, this.__data__ = {
          hash: new Xt(),
          map: new (ts || ir)(),
          string: new Xt()
        };
      }
      function pr(n) {
        var t = xi(this, n)["delete"](n);
        return this.size -= t ? 1 : 0, t;
      }
      function _r(n) {
        return xi(this, n).get(n);
      }
      function vr(n) {
        return xi(this, n).has(n);
      }
      function gr(n, t) {
        var r = xi(this, n),
          e = r.size;
        return r.set(n, t), this.size += r.size == e ? 0 : 1, this;
      }
      function yr(n) {
        var t = -1,
          r = null == n ? 0 : n.length;
        for (this.__data__ = new sr(); ++t < r;) {
          this.add(n[t]);
        }
      }
      function dr(n) {
        return this.__data__.set(n, on), this;
      }
      function br(n) {
        return this.__data__.has(n);
      }
      function wr(n) {
        this.size = (this.__data__ = new ir(n)).size;
      }
      function mr() {
        this.__data__ = new ir(), this.size = 0;
      }
      function xr(n) {
        var t = this.__data__,
          r = t["delete"](n);
        return this.size = t.size, r;
      }
      function jr(n) {
        return this.__data__.get(n);
      }
      function Ar(n) {
        return this.__data__.has(n);
      }
      function kr(n, t) {
        var r = this.__data__;
        if (r instanceof ir) {
          var e = r.__data__;
          if (!ts || e.length < tn - 1) return e.push([n, t]), this.size = ++r.size, this;
          r = this.__data__ = new sr(e);
        }
        return r.set(n, t), this.size = r.size, this;
      }
      function Or(n, t) {
        var r = bh(n),
          e = !r && dh(n),
          u = !r && !e && mh(n),
          i = !r && !e && !u && Oh(n),
          o = r || e || u || i,
          f = o ? O(n.length, hl) : [],
          c = f.length;
        for (var a in n) {
          !t && !bl.call(n, a) || o && ("length" == a || u && ("offset" == a || "parent" == a) || i && ("buffer" == a || "byteLength" == a || "byteOffset" == a) || Ci(a, c)) || f.push(a);
        }
        return f;
      }
      function Ir(n) {
        var t = n.length;
        return t ? n[tu(0, t - 1)] : X;
      }
      function Rr(n, t) {
        return Xi(Tu(n), Mr(t, 0, n.length));
      }
      function zr(n) {
        return Xi(Tu(n));
      }
      function Er(n, t, r) {
        (r === X || Gf(n[t], r)) && (r !== X || t in n) || Br(n, t, r);
      }
      function Sr(n, t, r) {
        var e = n[t];
        bl.call(n, t) && Gf(e, r) && (r !== X || t in n) || Br(n, t, r);
      }
      function Wr(n, t) {
        for (var r = n.length; r--;) {
          if (Gf(n[r][0], t)) return r;
        }
        return -1;
      }
      function Lr(n, t, r, e) {
        return ys(n, function (n, u, i) {
          t(e, n, r(n), i);
        }), e;
      }
      function Cr(n, t) {
        return n && $u(t, Pc(t), n);
      }
      function Ur(n, t) {
        return n && $u(t, qc(t), n);
      }
      function Br(n, t, r) {
        "__proto__" == t && Tl ? Tl(n, t, {
          configurable: !0,
          enumerable: !0,
          value: r,
          writable: !0
        }) : n[t] = r;
      }
      function Tr(n, t) {
        for (var r = -1, e = t.length, u = il(e), i = null == n; ++r < e;) {
          u[r] = i ? X : Mc(n, t[r]);
        }
        return u;
      }
      function Mr(n, t, r) {
        return n === n && (r !== X && (n = n <= r ? n : r), t !== X && (n = n >= t ? n : t)), n;
      }
      function Fr(n, t, e, u, i, o) {
        var f,
          c = t & an,
          a = t & ln,
          l = t & sn;
        if (e && (f = i ? e(n, u, i, o) : e(n)), f !== X) return f;
        if (!fc(n)) return n;
        var s = bh(n);
        if (s) {
          if (f = zi(n), !c) return Tu(n, f);
        } else {
          var h = zs(n),
            p = h == Kn || h == Vn;
          if (mh(n)) return Iu(n, c);
          if (h == Yn || h == Dn || p && !i) {
            if (f = a || p ? {} : Ei(n), !c) return a ? Mu(n, Ur(f, n)) : Du(n, Cr(f, n));
          } else {
            if (!Vr[h]) return i ? n : {};
            f = Si(n, h, c);
          }
        }
        o || (o = new wr());
        var _ = o.get(n);
        if (_) return _;
        o.set(n, f), kh(n) ? n.forEach(function (r) {
          f.add(Fr(r, t, e, r, n, o));
        }) : jh(n) && n.forEach(function (r, u) {
          f.set(u, Fr(r, t, e, u, n, o));
        });
        var v = l ? a ? di : yi : a ? qc : Pc,
          g = s ? X : v(n);
        return r(g || n, function (r, u) {
          g && (u = r, r = n[u]), Sr(f, u, Fr(r, t, e, u, n, o));
        }), f;
      }
      function Nr(n) {
        var t = Pc(n);
        return function (r) {
          return Pr(r, n, t);
        };
      }
      function Pr(n, t, r) {
        var e = r.length;
        if (null == n) return !e;
        for (n = ll(n); e--;) {
          var u = r[e],
            i = t[u],
            o = n[u];
          if (o === X && !(u in n) || !i(o)) return !1;
        }
        return !0;
      }
      function Gr(n, t, r) {
        if ("function" != typeof n) throw new pl(en);
        return Ws(function () {
          n.apply(X, r);
        }, t);
      }
      function Hr(n, t, r, e) {
        var u = -1,
          i = o,
          a = !0,
          l = n.length,
          s = [],
          h = t.length;
        if (!l) return s;
        r && (t = c(t, z(r))), e ? (i = f, a = !1) : t.length >= tn && (i = S, a = !1, t = new yr(t));
        n: for (; ++u < l;) {
          var p = n[u],
            _ = null == r ? p : r(p);
          if (p = e || 0 !== p ? p : 0, a && _ === _) {
            for (var v = h; v--;) {
              if (t[v] === _) continue n;
            }
            s.push(p);
          } else i(t, _, e) || s.push(p);
        }
        return s;
      }
      function Jr(n, t) {
        var r = !0;
        return ys(n, function (n, e, u) {
          return r = !!t(n, e, u);
        }), r;
      }
      function Yr(n, t, r) {
        for (var e = -1, u = n.length; ++e < u;) {
          var i = n[e],
            o = t(i);
          if (null != o && (f === X ? o === o && !bc(o) : r(o, f))) var f = o,
            c = i;
        }
        return c;
      }
      function ne(n, t, r, e) {
        var u = n.length;
        for (r = kc(r), r < 0 && (r = -r > u ? 0 : u + r), e = e === X || e > u ? u : kc(e), e < 0 && (e += u), e = r > e ? 0 : Oc(e); r < e;) {
          n[r++] = t;
        }
        return n;
      }
      function te(n, t) {
        var r = [];
        return ys(n, function (n, e, u) {
          t(n, e, u) && r.push(n);
        }), r;
      }
      function ee(n, t, r, e, u) {
        var i = -1,
          o = n.length;
        for (r || (r = Li), u || (u = []); ++i < o;) {
          var f = n[i];
          t > 0 && r(f) ? t > 1 ? ee(f, t - 1, r, e, u) : a(u, f) : e || (u[u.length] = f);
        }
        return u;
      }
      function ue(n, t) {
        return n && bs(n, t, Pc);
      }
      function oe(n, t) {
        return n && ws(n, t, Pc);
      }
      function fe(n, t) {
        return i(t, function (t) {
          return uc(n[t]);
        });
      }
      function _e(n, t) {
        t = ku(t, n);
        for (var r = 0, e = t.length; null != n && r < e;) {
          n = n[no(t[r++])];
        }
        return r && r == e ? n : X;
      }
      function de(n, t, r) {
        var e = t(n);
        return bh(n) ? e : a(e, r(n));
      }
      function we(n) {
        return null == n ? n === X ? ut : Jn : Bl && Bl in ll(n) ? ki(n) : Ki(n);
      }
      function me(n, t) {
        return n > t;
      }
      function xe(n, t) {
        return null != n && bl.call(n, t);
      }
      function je(n, t) {
        return null != n && t in ll(n);
      }
      function Ae(n, t, r) {
        return n >= Hl(t, r) && n < Gl(t, r);
      }
      function ke(n, t, r) {
        for (var e = r ? f : o, u = n[0].length, i = n.length, a = i, l = il(i), s = 1 / 0, h = []; a--;) {
          var p = n[a];
          a && t && (p = c(p, z(t))), s = Hl(p.length, s), l[a] = !r && (t || u >= 120 && p.length >= 120) ? new yr(a && p) : X;
        }
        p = n[0];
        var _ = -1,
          v = l[0];
        n: for (; ++_ < u && h.length < s;) {
          var g = p[_],
            y = t ? t(g) : g;
          if (g = r || 0 !== g ? g : 0, !(v ? S(v, y) : e(h, y, r))) {
            for (a = i; --a;) {
              var d = l[a];
              if (!(d ? S(d, y) : e(n[a], y, r))) continue n;
            }
            v && v.push(y), h.push(g);
          }
        }
        return h;
      }
      function Oe(n, t, r, e) {
        return ue(n, function (n, u, i) {
          t(e, r(n), u, i);
        }), e;
      }
      function Ie(t, r, e) {
        r = ku(r, t), t = Gi(t, r);
        var u = null == t ? t : t[no(jo(r))];
        return null == u ? X : n(u, t, e);
      }
      function Re(n) {
        return cc(n) && we(n) == Dn;
      }
      function ze(n) {
        return cc(n) && we(n) == ft;
      }
      function Ee(n) {
        return cc(n) && we(n) == Pn;
      }
      function Se(n, t, r, e, u) {
        return n === t || (null == n || null == t || !cc(n) && !cc(t) ? n !== n && t !== t : We(n, t, r, e, Se, u));
      }
      function We(n, t, r, e, u, i) {
        var o = bh(n),
          f = bh(t),
          c = o ? Mn : zs(n),
          a = f ? Mn : zs(t);
        c = c == Dn ? Yn : c, a = a == Dn ? Yn : a;
        var l = c == Yn,
          s = a == Yn,
          h = c == a;
        if (h && mh(n)) {
          if (!mh(t)) return !1;
          o = !0, l = !1;
        }
        if (h && !l) return i || (i = new wr()), o || Oh(n) ? pi(n, t, r, e, u, i) : _i(n, t, c, r, e, u, i);
        if (!(r & hn)) {
          var p = l && bl.call(n, "__wrapped__"),
            _ = s && bl.call(t, "__wrapped__");
          if (p || _) {
            var v = p ? n.value() : n,
              g = _ ? t.value() : t;
            return i || (i = new wr()), u(v, g, r, e, i);
          }
        }
        return !!h && (i || (i = new wr()), vi(n, t, r, e, u, i));
      }
      function Le(n) {
        return cc(n) && zs(n) == Gn;
      }
      function Ce(n, t, r, e) {
        var u = r.length,
          i = u,
          o = !e;
        if (null == n) return !i;
        for (n = ll(n); u--;) {
          var f = r[u];
          if (o && f[2] ? f[1] !== n[f[0]] : !(f[0] in n)) return !1;
        }
        for (; ++u < i;) {
          f = r[u];
          var c = f[0],
            a = n[c],
            l = f[1];
          if (o && f[2]) {
            if (a === X && !(c in n)) return !1;
          } else {
            var s = new wr();
            if (e) var h = e(a, l, c, n, t, s);
            if (!(h === X ? Se(l, a, hn | pn, e, s) : h)) return !1;
          }
        }
        return !0;
      }
      function Ue(n) {
        return !(!fc(n) || Di(n)) && (uc(n) ? kl : Zt).test(to(n));
      }
      function Be(n) {
        return cc(n) && we(n) == nt;
      }
      function Te(n) {
        return cc(n) && zs(n) == tt;
      }
      function $e(n) {
        return cc(n) && oc(n.length) && !!Kr[we(n)];
      }
      function De(n) {
        return "function" == typeof n ? n : null == n ? La : "object" == _typeof(n) ? bh(n) ? Ze(n[0], n[1]) : qe(n) : Fa(n);
      }
      function Me(n) {
        if (!Mi(n)) return Vl(n);
        var t = [];
        for (var r in ll(n)) {
          bl.call(n, r) && "constructor" != r && t.push(r);
        }
        return t;
      }
      function Fe(n) {
        if (!fc(n)) return Zi(n);
        var t = Mi(n),
          r = [];
        for (var e in n) {
          ("constructor" != e || !t && bl.call(n, e)) && r.push(e);
        }
        return r;
      }
      function Ne(n, t) {
        return n < t;
      }
      function Pe(n, t) {
        var r = -1,
          e = Hf(n) ? il(n.length) : [];
        return ys(n, function (n, u, i) {
          e[++r] = t(n, u, i);
        }), e;
      }
      function qe(n) {
        var t = ji(n);
        return 1 == t.length && t[0][2] ? Ni(t[0][0], t[0][1]) : function (r) {
          return r === n || Ce(r, n, t);
        };
      }
      function Ze(n, t) {
        return Bi(n) && Fi(t) ? Ni(no(n), t) : function (r) {
          var e = Mc(r, n);
          return e === X && e === t ? Nc(r, n) : Se(t, e, hn | pn);
        };
      }
      function Ke(n, t, r, e, u) {
        n !== t && bs(t, function (i, o) {
          if (u || (u = new wr()), fc(i)) Ve(n, t, o, r, Ke, e, u);else {
            var f = e ? e(Ji(n, o), i, o + "", n, t, u) : X;
            f === X && (f = i), Er(n, o, f);
          }
        }, qc);
      }
      function Ve(n, t, r, e, u, i, o) {
        var f = Ji(n, r),
          c = Ji(t, r),
          a = o.get(c);
        if (a) return Er(n, r, a), X;
        var l = i ? i(f, c, r + "", n, t, o) : X,
          s = l === X;
        if (s) {
          var h = bh(c),
            p = !h && mh(c),
            _ = !h && !p && Oh(c);
          l = c, h || p || _ ? bh(f) ? l = f : Jf(f) ? l = Tu(f) : p ? (s = !1, l = Iu(c, !0)) : _ ? (s = !1, l = Wu(c, !0)) : l = [] : gc(c) || dh(c) ? (l = f, dh(f) ? l = Rc(f) : fc(f) && !uc(f) || (l = Ei(c))) : s = !1;
        }
        s && (o.set(c, l), u(l, c, e, i, o), o["delete"](c)), Er(n, r, l);
      }
      function Ge(n, t) {
        var r = n.length;
        if (r) return t += t < 0 ? r : 0, Ci(t, r) ? n[t] : X;
      }
      function He(n, t, r) {
        t = t.length ? c(t, function (n) {
          return bh(n) ? function (t) {
            return _e(t, 1 === n.length ? n[0] : n);
          } : n;
        }) : [La];
        var e = -1;
        return t = c(t, z(mi())), A(Pe(n, function (n, r, u) {
          return {
            criteria: c(t, function (t) {
              return t(n);
            }),
            index: ++e,
            value: n
          };
        }), function (n, t) {
          return Cu(n, t, r);
        });
      }
      function Je(n, t) {
        return Ye(n, t, function (t, r) {
          return Nc(n, r);
        });
      }
      function Ye(n, t, r) {
        for (var e = -1, u = t.length, i = {}; ++e < u;) {
          var o = t[e],
            f = _e(n, o);
          r(f, o) && fu(i, ku(o, n), f);
        }
        return i;
      }
      function Qe(n) {
        return function (t) {
          return _e(t, n);
        };
      }
      function Xe(n, t, r, e) {
        var u = e ? d : y,
          i = -1,
          o = t.length,
          f = n;
        for (n === t && (t = Tu(t)), r && (f = c(n, z(r))); ++i < o;) {
          for (var a = 0, l = t[i], s = r ? r(l) : l; (a = u(f, s, a, e)) > -1;) {
            f !== n && Ll.call(f, a, 1), Ll.call(n, a, 1);
          }
        }
        return n;
      }
      function nu(n, t) {
        for (var r = n ? t.length : 0, e = r - 1; r--;) {
          var u = t[r];
          if (r == e || u !== i) {
            var i = u;
            Ci(u) ? Ll.call(n, u, 1) : yu(n, u);
          }
        }
        return n;
      }
      function tu(n, t) {
        return n + Nl(Ql() * (t - n + 1));
      }
      function ru(n, t, r, e) {
        for (var u = -1, i = Gl(Fl((t - n) / (r || 1)), 0), o = il(i); i--;) {
          o[e ? i : ++u] = n, n += r;
        }
        return o;
      }
      function eu(n, t) {
        var r = "";
        if (!n || t < 1 || t > Wn) return r;
        do {
          t % 2 && (r += n), t = Nl(t / 2), t && (n += n);
        } while (t);
        return r;
      }
      function uu(n, t) {
        return Ls(Vi(n, t, La), n + "");
      }
      function iu(n) {
        return Ir(ra(n));
      }
      function ou(n, t) {
        var r = ra(n);
        return Xi(r, Mr(t, 0, r.length));
      }
      function fu(n, t, r, e) {
        if (!fc(n)) return n;
        t = ku(t, n);
        for (var u = -1, i = t.length, o = i - 1, f = n; null != f && ++u < i;) {
          var c = no(t[u]),
            a = r;
          if ("__proto__" === c || "constructor" === c || "prototype" === c) return n;
          if (u != o) {
            var l = f[c];
            a = e ? e(l, c, f) : X, a === X && (a = fc(l) ? l : Ci(t[u + 1]) ? [] : {});
          }
          Sr(f, c, a), f = f[c];
        }
        return n;
      }
      function cu(n) {
        return Xi(ra(n));
      }
      function au(n, t, r) {
        var e = -1,
          u = n.length;
        t < 0 && (t = -t > u ? 0 : u + t), r = r > u ? u : r, r < 0 && (r += u), u = t > r ? 0 : r - t >>> 0, t >>>= 0;
        for (var i = il(u); ++e < u;) {
          i[e] = n[e + t];
        }
        return i;
      }
      function lu(n, t) {
        var r;
        return ys(n, function (n, e, u) {
          return r = t(n, e, u), !r;
        }), !!r;
      }
      function su(n, t, r) {
        var e = 0,
          u = null == n ? e : n.length;
        if ("number" == typeof t && t === t && u <= Tn) {
          for (; e < u;) {
            var i = e + u >>> 1,
              o = n[i];
            null !== o && !bc(o) && (r ? o <= t : o < t) ? e = i + 1 : u = i;
          }
          return u;
        }
        return hu(n, t, La, r);
      }
      function hu(n, t, r, e) {
        var u = 0,
          i = null == n ? 0 : n.length;
        if (0 === i) return 0;
        t = r(t);
        for (var o = t !== t, f = null === t, c = bc(t), a = t === X; u < i;) {
          var l = Nl((u + i) / 2),
            s = r(n[l]),
            h = s !== X,
            p = null === s,
            _ = s === s,
            v = bc(s);
          if (o) var g = e || _;else g = a ? _ && (e || h) : f ? _ && h && (e || !p) : c ? _ && h && !p && (e || !v) : !p && !v && (e ? s <= t : s < t);
          g ? u = l + 1 : i = l;
        }
        return Hl(i, Bn);
      }
      function pu(n, t) {
        for (var r = -1, e = n.length, u = 0, i = []; ++r < e;) {
          var o = n[r],
            f = t ? t(o) : o;
          if (!r || !Gf(f, c)) {
            var c = f;
            i[u++] = 0 === o ? 0 : o;
          }
        }
        return i;
      }
      function _u(n) {
        return "number" == typeof n ? n : bc(n) ? Cn : +n;
      }
      function vu(n) {
        if ("string" == typeof n) return n;
        if (bh(n)) return c(n, vu) + "";
        if (bc(n)) return vs ? vs.call(n) : "";
        var t = n + "";
        return "0" == t && 1 / n == -Sn ? "-0" : t;
      }
      function gu(n, t, r) {
        var e = -1,
          u = o,
          i = n.length,
          c = !0,
          a = [],
          l = a;
        if (r) c = !1, u = f;else if (i >= tn) {
          var s = t ? null : ks(n);
          if (s) return P(s);
          c = !1, u = S, l = new yr();
        } else l = t ? [] : a;
        n: for (; ++e < i;) {
          var h = n[e],
            p = t ? t(h) : h;
          if (h = r || 0 !== h ? h : 0, c && p === p) {
            for (var _ = l.length; _--;) {
              if (l[_] === p) continue n;
            }
            t && l.push(p), a.push(h);
          } else u(l, p, r) || (l !== a && l.push(p), a.push(h));
        }
        return a;
      }
      function yu(n, t) {
        return t = ku(t, n), n = Gi(n, t), null == n || delete n[no(jo(t))];
      }
      function du(n, t, r, e) {
        return fu(n, t, r(_e(n, t)), e);
      }
      function bu(n, t, r, e) {
        for (var u = n.length, i = e ? u : -1; (e ? i-- : ++i < u) && t(n[i], i, n);) {
          ;
        }
        return r ? au(n, e ? 0 : i, e ? i + 1 : u) : au(n, e ? i + 1 : 0, e ? u : i);
      }
      function wu(n, t) {
        var r = n;
        return r instanceof Ct && (r = r.value()), l(t, function (n, t) {
          return t.func.apply(t.thisArg, a([n], t.args));
        }, r);
      }
      function mu(n, t, r) {
        var e = n.length;
        if (e < 2) return e ? gu(n[0]) : [];
        for (var u = -1, i = il(e); ++u < e;) {
          for (var o = n[u], f = -1; ++f < e;) {
            f != u && (i[u] = Hr(i[u] || o, n[f], t, r));
          }
        }
        return gu(ee(i, 1), t, r);
      }
      function xu(n, t, r) {
        for (var e = -1, u = n.length, i = t.length, o = {}; ++e < u;) {
          r(o, n[e], e < i ? t[e] : X);
        }
        return o;
      }
      function ju(n) {
        return Jf(n) ? n : [];
      }
      function Au(n) {
        return "function" == typeof n ? n : La;
      }
      function ku(n, t) {
        return bh(n) ? n : Bi(n, t) ? [n] : Cs(Ec(n));
      }
      function Ou(n, t, r) {
        var e = n.length;
        return r = r === X ? e : r, !t && r >= e ? n : au(n, t, r);
      }
      function Iu(n, t) {
        if (t) return n.slice();
        var r = n.length,
          e = zl ? zl(r) : new n.constructor(r);
        return n.copy(e), e;
      }
      function Ru(n) {
        var t = new n.constructor(n.byteLength);
        return new Rl(t).set(new Rl(n)), t;
      }
      function zu(n, t) {
        return new n.constructor(t ? Ru(n.buffer) : n.buffer, n.byteOffset, n.byteLength);
      }
      function Eu(n) {
        var t = new n.constructor(n.source, Nt.exec(n));
        return t.lastIndex = n.lastIndex, t;
      }
      function Su(n) {
        return _s ? ll(_s.call(n)) : {};
      }
      function Wu(n, t) {
        return new n.constructor(t ? Ru(n.buffer) : n.buffer, n.byteOffset, n.length);
      }
      function Lu(n, t) {
        if (n !== t) {
          var r = n !== X,
            e = null === n,
            u = n === n,
            i = bc(n),
            o = t !== X,
            f = null === t,
            c = t === t,
            a = bc(t);
          if (!f && !a && !i && n > t || i && o && c && !f && !a || e && o && c || !r && c || !u) return 1;
          if (!e && !i && !a && n < t || a && r && u && !e && !i || f && r && u || !o && u || !c) return -1;
        }
        return 0;
      }
      function Cu(n, t, r) {
        for (var e = -1, u = n.criteria, i = t.criteria, o = u.length, f = r.length; ++e < o;) {
          var c = Lu(u[e], i[e]);
          if (c) {
            if (e >= f) return c;
            return c * ("desc" == r[e] ? -1 : 1);
          }
        }
        return n.index - t.index;
      }
      function Uu(n, t, r, e) {
        for (var u = -1, i = n.length, o = r.length, f = -1, c = t.length, a = Gl(i - o, 0), l = il(c + a), s = !e; ++f < c;) {
          l[f] = t[f];
        }
        for (; ++u < o;) {
          (s || u < i) && (l[r[u]] = n[u]);
        }
        for (; a--;) {
          l[f++] = n[u++];
        }
        return l;
      }
      function Bu(n, t, r, e) {
        for (var u = -1, i = n.length, o = -1, f = r.length, c = -1, a = t.length, l = Gl(i - f, 0), s = il(l + a), h = !e; ++u < l;) {
          s[u] = n[u];
        }
        for (var p = u; ++c < a;) {
          s[p + c] = t[c];
        }
        for (; ++o < f;) {
          (h || u < i) && (s[p + r[o]] = n[u++]);
        }
        return s;
      }
      function Tu(n, t) {
        var r = -1,
          e = n.length;
        for (t || (t = il(e)); ++r < e;) {
          t[r] = n[r];
        }
        return t;
      }
      function $u(n, t, r, e) {
        var u = !r;
        r || (r = {});
        for (var i = -1, o = t.length; ++i < o;) {
          var f = t[i],
            c = e ? e(r[f], n[f], f, r, n) : X;
          c === X && (c = n[f]), u ? Br(r, f, c) : Sr(r, f, c);
        }
        return r;
      }
      function Du(n, t) {
        return $u(n, Is(n), t);
      }
      function Mu(n, t) {
        return $u(n, Rs(n), t);
      }
      function Fu(n, r) {
        return function (e, u) {
          var i = bh(e) ? t : Lr,
            o = r ? r() : {};
          return i(e, n, mi(u, 2), o);
        };
      }
      function Nu(n) {
        return uu(function (t, r) {
          var e = -1,
            u = r.length,
            i = u > 1 ? r[u - 1] : X,
            o = u > 2 ? r[2] : X;
          for (i = n.length > 3 && "function" == typeof i ? (u--, i) : X, o && Ui(r[0], r[1], o) && (i = u < 3 ? X : i, u = 1), t = ll(t); ++e < u;) {
            var f = r[e];
            f && n(t, f, e, i);
          }
          return t;
        });
      }
      function Pu(n, t) {
        return function (r, e) {
          if (null == r) return r;
          if (!Hf(r)) return n(r, e);
          for (var u = r.length, i = t ? u : -1, o = ll(r); (t ? i-- : ++i < u) && e(o[i], i, o) !== !1;) {
            ;
          }
          return r;
        };
      }
      function qu(n) {
        return function (t, r, e) {
          for (var u = -1, i = ll(t), o = e(t), f = o.length; f--;) {
            var c = o[n ? f : ++u];
            if (r(i[c], c, i) === !1) break;
          }
          return t;
        };
      }
      function Zu(n, t, r) {
        function e() {
          return (this && this !== re && this instanceof e ? i : n).apply(u ? r : this, arguments);
        }
        var u = t & _n,
          i = Gu(n);
        return e;
      }
      function Ku(n) {
        return function (t) {
          t = Ec(t);
          var r = T(t) ? G(t) : X,
            e = r ? r[0] : t.charAt(0),
            u = r ? Ou(r, 1).join("") : t.slice(1);
          return e[n]() + u;
        };
      }
      function Vu(n) {
        return function (t) {
          return l(Ra(ca(t).replace($r, "")), n, "");
        };
      }
      function Gu(n) {
        return function () {
          var t = arguments;
          switch (t.length) {
            case 0:
              return new n();
            case 1:
              return new n(t[0]);
            case 2:
              return new n(t[0], t[1]);
            case 3:
              return new n(t[0], t[1], t[2]);
            case 4:
              return new n(t[0], t[1], t[2], t[3]);
            case 5:
              return new n(t[0], t[1], t[2], t[3], t[4]);
            case 6:
              return new n(t[0], t[1], t[2], t[3], t[4], t[5]);
            case 7:
              return new n(t[0], t[1], t[2], t[3], t[4], t[5], t[6]);
          }
          var r = gs(n.prototype),
            e = n.apply(r, t);
          return fc(e) ? e : r;
        };
      }
      function Hu(t, r, e) {
        function u() {
          for (var o = arguments.length, f = il(o), c = o, a = wi(u); c--;) {
            f[c] = arguments[c];
          }
          var l = o < 3 && f[0] !== a && f[o - 1] !== a ? [] : N(f, a);
          return o -= l.length, o < e ? oi(t, r, Qu, u.placeholder, X, f, l, X, X, e - o) : n(this && this !== re && this instanceof u ? i : t, this, f);
        }
        var i = Gu(t);
        return u;
      }
      function Ju(n) {
        return function (t, r, e) {
          var u = ll(t);
          if (!Hf(t)) {
            var i = mi(r, 3);
            t = Pc(t), r = function r(n) {
              return i(u[n], n, u);
            };
          }
          var o = n(t, r, e);
          return o > -1 ? u[i ? t[o] : o] : X;
        };
      }
      function Yu(n) {
        return gi(function (t) {
          var r = t.length,
            e = r,
            u = Y.prototype.thru;
          for (n && t.reverse(); e--;) {
            var i = t[e];
            if ("function" != typeof i) throw new pl(en);
            if (u && !o && "wrapper" == bi(i)) var o = new Y([], !0);
          }
          for (e = o ? e : r; ++e < r;) {
            i = t[e];
            var f = bi(i),
              c = "wrapper" == f ? Os(i) : X;
            o = c && $i(c[0]) && c[1] == (mn | yn | bn | xn) && !c[4].length && 1 == c[9] ? o[bi(c[0])].apply(o, c[3]) : 1 == i.length && $i(i) ? o[f]() : o.thru(i);
          }
          return function () {
            var n = arguments,
              e = n[0];
            if (o && 1 == n.length && bh(e)) return o.plant(e).value();
            for (var u = 0, i = r ? t[u].apply(this, n) : e; ++u < r;) {
              i = t[u].call(this, i);
            }
            return i;
          };
        });
      }
      function Qu(n, t, r, e, u, i, o, f, c, a) {
        function l() {
          for (var y = arguments.length, d = il(y), b = y; b--;) {
            d[b] = arguments[b];
          }
          if (_) var w = wi(l),
            m = C(d, w);
          if (e && (d = Uu(d, e, u, _)), i && (d = Bu(d, i, o, _)), y -= m, _ && y < a) {
            return oi(n, t, Qu, l.placeholder, r, d, N(d, w), f, c, a - y);
          }
          var x = h ? r : this,
            j = p ? x[n] : n;
          return y = d.length, f ? d = Hi(d, f) : v && y > 1 && d.reverse(), s && c < y && (d.length = c), this && this !== re && this instanceof l && (j = g || Gu(j)), j.apply(x, d);
        }
        var s = t & mn,
          h = t & _n,
          p = t & vn,
          _ = t & (yn | dn),
          v = t & jn,
          g = p ? X : Gu(n);
        return l;
      }
      function Xu(n, t) {
        return function (r, e) {
          return Oe(r, n, t(e), {});
        };
      }
      function ni(n, t) {
        return function (r, e) {
          var u;
          if (r === X && e === X) return t;
          if (r !== X && (u = r), e !== X) {
            if (u === X) return e;
            "string" == typeof r || "string" == typeof e ? (r = vu(r), e = vu(e)) : (r = _u(r), e = _u(e)), u = n(r, e);
          }
          return u;
        };
      }
      function ti(t) {
        return gi(function (r) {
          return r = c(r, z(mi())), uu(function (e) {
            var u = this;
            return t(r, function (t) {
              return n(t, u, e);
            });
          });
        });
      }
      function ri(n, t) {
        t = t === X ? " " : vu(t);
        var r = t.length;
        if (r < 2) return r ? eu(t, n) : t;
        var e = eu(t, Fl(n / V(t)));
        return T(t) ? Ou(G(e), 0, n).join("") : e.slice(0, n);
      }
      function ei(t, r, e, u) {
        function i() {
          for (var r = -1, c = arguments.length, a = -1, l = u.length, s = il(l + c), h = this && this !== re && this instanceof i ? f : t; ++a < l;) {
            s[a] = u[a];
          }
          for (; c--;) {
            s[a++] = arguments[++r];
          }
          return n(h, o ? e : this, s);
        }
        var o = r & _n,
          f = Gu(t);
        return i;
      }
      function ui(n) {
        return function (t, r, e) {
          return e && "number" != typeof e && Ui(t, r, e) && (r = e = X), t = Ac(t), r === X ? (r = t, t = 0) : r = Ac(r), e = e === X ? t < r ? 1 : -1 : Ac(e), ru(t, r, e, n);
        };
      }
      function ii(n) {
        return function (t, r) {
          return "string" == typeof t && "string" == typeof r || (t = Ic(t), r = Ic(r)), n(t, r);
        };
      }
      function oi(n, t, r, e, u, i, o, f, c, a) {
        var l = t & yn,
          s = l ? o : X,
          h = l ? X : o,
          p = l ? i : X,
          _ = l ? X : i;
        t |= l ? bn : wn, t &= ~(l ? wn : bn), t & gn || (t &= ~(_n | vn));
        var v = [n, t, u, p, s, _, h, f, c, a],
          g = r.apply(X, v);
        return $i(n) && Ss(g, v), g.placeholder = e, Yi(g, n, t);
      }
      function fi(n) {
        var t = al[n];
        return function (n, r) {
          if (n = Ic(n), r = null == r ? 0 : Hl(kc(r), 292), r && Zl(n)) {
            var e = (Ec(n) + "e").split("e");
            return e = (Ec(t(e[0] + "e" + (+e[1] + r))) + "e").split("e"), +(e[0] + "e" + (+e[1] - r));
          }
          return t(n);
        };
      }
      function ci(n) {
        return function (t) {
          var r = zs(t);
          return r == Gn ? M(t) : r == tt ? q(t) : I(t, n(t));
        };
      }
      function ai(n, t, r, e, u, i, o, f) {
        var c = t & vn;
        if (!c && "function" != typeof n) throw new pl(en);
        var a = e ? e.length : 0;
        if (a || (t &= ~(bn | wn), e = u = X), o = o === X ? o : Gl(kc(o), 0), f = f === X ? f : kc(f), a -= u ? u.length : 0, t & wn) {
          var l = e,
            s = u;
          e = u = X;
        }
        var h = c ? X : Os(n),
          p = [n, t, r, e, u, l, s, i, o, f];
        if (h && qi(p, h), n = p[0], t = p[1], r = p[2], e = p[3], u = p[4], f = p[9] = p[9] === X ? c ? 0 : n.length : Gl(p[9] - a, 0), !f && t & (yn | dn) && (t &= ~(yn | dn)), t && t != _n) _ = t == yn || t == dn ? Hu(n, t, f) : t != bn && t != (_n | bn) || u.length ? Qu.apply(X, p) : ei(n, t, r, e);else var _ = Zu(n, t, r);
        return Yi((h ? ms : Ss)(_, p), n, t);
      }
      function li(n, t, r, e) {
        return n === X || Gf(n, gl[r]) && !bl.call(e, r) ? t : n;
      }
      function si(n, t, r, e, u, i) {
        return fc(n) && fc(t) && (i.set(t, n), Ke(n, t, X, si, i), i["delete"](t)), n;
      }
      function hi(n) {
        return gc(n) ? X : n;
      }
      function pi(n, t, r, e, u, i) {
        var o = r & hn,
          f = n.length,
          c = t.length;
        if (f != c && !(o && c > f)) return !1;
        var a = i.get(n),
          l = i.get(t);
        if (a && l) return a == t && l == n;
        var s = -1,
          p = !0,
          _ = r & pn ? new yr() : X;
        for (i.set(n, t), i.set(t, n); ++s < f;) {
          var v = n[s],
            g = t[s];
          if (e) var y = o ? e(g, v, s, t, n, i) : e(v, g, s, n, t, i);
          if (y !== X) {
            if (y) continue;
            p = !1;
            break;
          }
          if (_) {
            if (!h(t, function (n, t) {
              if (!S(_, t) && (v === n || u(v, n, r, e, i))) return _.push(t);
            })) {
              p = !1;
              break;
            }
          } else if (v !== g && !u(v, g, r, e, i)) {
            p = !1;
            break;
          }
        }
        return i["delete"](n), i["delete"](t), p;
      }
      function _i(n, t, r, e, u, i, o) {
        switch (r) {
          case ct:
            if (n.byteLength != t.byteLength || n.byteOffset != t.byteOffset) return !1;
            n = n.buffer, t = t.buffer;
          case ft:
            return !(n.byteLength != t.byteLength || !i(new Rl(n), new Rl(t)));
          case Nn:
          case Pn:
          case Hn:
            return Gf(+n, +t);
          case Zn:
            return n.name == t.name && n.message == t.message;
          case nt:
          case rt:
            return n == t + "";
          case Gn:
            var f = M;
          case tt:
            var c = e & hn;
            if (f || (f = P), n.size != t.size && !c) return !1;
            var a = o.get(n);
            if (a) return a == t;
            e |= pn, o.set(n, t);
            var l = pi(f(n), f(t), e, u, i, o);
            return o["delete"](n), l;
          case et:
            if (_s) return _s.call(n) == _s.call(t);
        }
        return !1;
      }
      function vi(n, t, r, e, u, i) {
        var o = r & hn,
          f = yi(n),
          c = f.length;
        if (c != yi(t).length && !o) return !1;
        for (var a = c; a--;) {
          var l = f[a];
          if (!(o ? l in t : bl.call(t, l))) return !1;
        }
        var s = i.get(n),
          h = i.get(t);
        if (s && h) return s == t && h == n;
        var p = !0;
        i.set(n, t), i.set(t, n);
        for (var _ = o; ++a < c;) {
          l = f[a];
          var v = n[l],
            g = t[l];
          if (e) var y = o ? e(g, v, l, t, n, i) : e(v, g, l, n, t, i);
          if (!(y === X ? v === g || u(v, g, r, e, i) : y)) {
            p = !1;
            break;
          }
          _ || (_ = "constructor" == l);
        }
        if (p && !_) {
          var d = n.constructor,
            b = t.constructor;
          d != b && "constructor" in n && "constructor" in t && !("function" == typeof d && d instanceof d && "function" == typeof b && b instanceof b) && (p = !1);
        }
        return i["delete"](n), i["delete"](t), p;
      }
      function gi(n) {
        return Ls(Vi(n, X, _o), n + "");
      }
      function yi(n) {
        return de(n, Pc, Is);
      }
      function di(n) {
        return de(n, qc, Rs);
      }
      function bi(n) {
        for (var t = n.name + "", r = fs[t], e = bl.call(fs, t) ? r.length : 0; e--;) {
          var u = r[e],
            i = u.func;
          if (null == i || i == n) return u.name;
        }
        return t;
      }
      function wi(n) {
        return (bl.call(Z, "placeholder") ? Z : n).placeholder;
      }
      function mi() {
        var n = Z.iteratee || Ca;
        return n = n === Ca ? De : n, arguments.length ? n(arguments[0], arguments[1]) : n;
      }
      function xi(n, t) {
        var r = n.__data__;
        return Ti(t) ? r["string" == typeof t ? "string" : "hash"] : r.map;
      }
      function ji(n) {
        for (var t = Pc(n), r = t.length; r--;) {
          var e = t[r],
            u = n[e];
          t[r] = [e, u, Fi(u)];
        }
        return t;
      }
      function Ai(n, t) {
        var r = B(n, t);
        return Ue(r) ? r : X;
      }
      function ki(n) {
        var t = bl.call(n, Bl),
          r = n[Bl];
        try {
          n[Bl] = X;
          var e = !0;
        } catch (n) {}
        var u = xl.call(n);
        return e && (t ? n[Bl] = r : delete n[Bl]), u;
      }
      function Oi(n, t, r) {
        for (var e = -1, u = r.length; ++e < u;) {
          var i = r[e],
            o = i.size;
          switch (i.type) {
            case "drop":
              n += o;
              break;
            case "dropRight":
              t -= o;
              break;
            case "take":
              t = Hl(t, n + o);
              break;
            case "takeRight":
              n = Gl(n, t - o);
          }
        }
        return {
          start: n,
          end: t
        };
      }
      function Ii(n) {
        var t = n.match(Bt);
        return t ? t[1].split(Tt) : [];
      }
      function Ri(n, t, r) {
        t = ku(t, n);
        for (var e = -1, u = t.length, i = !1; ++e < u;) {
          var o = no(t[e]);
          if (!(i = null != n && r(n, o))) break;
          n = n[o];
        }
        return i || ++e != u ? i : (u = null == n ? 0 : n.length, !!u && oc(u) && Ci(o, u) && (bh(n) || dh(n)));
      }
      function zi(n) {
        var t = n.length,
          r = new n.constructor(t);
        return t && "string" == typeof n[0] && bl.call(n, "index") && (r.index = n.index, r.input = n.input), r;
      }
      function Ei(n) {
        return "function" != typeof n.constructor || Mi(n) ? {} : gs(El(n));
      }
      function Si(n, t, r) {
        var e = n.constructor;
        switch (t) {
          case ft:
            return Ru(n);
          case Nn:
          case Pn:
            return new e(+n);
          case ct:
            return zu(n, r);
          case at:
          case lt:
          case st:
          case ht:
          case pt:
          case _t:
          case vt:
          case gt:
          case yt:
            return Wu(n, r);
          case Gn:
            return new e();
          case Hn:
          case rt:
            return new e(n);
          case nt:
            return Eu(n);
          case tt:
            return new e();
          case et:
            return Su(n);
        }
      }
      function Wi(n, t) {
        var r = t.length;
        if (!r) return n;
        var e = r - 1;
        return t[e] = (r > 1 ? "& " : "") + t[e], t = t.join(r > 2 ? ", " : " "), n.replace(Ut, "{\n/* [wrapped with " + t + "] */\n");
      }
      function Li(n) {
        return bh(n) || dh(n) || !!(Cl && n && n[Cl]);
      }
      function Ci(n, t) {
        var r = _typeof(n);
        return t = null == t ? Wn : t, !!t && ("number" == r || "symbol" != r && Vt.test(n)) && n > -1 && n % 1 == 0 && n < t;
      }
      function Ui(n, t, r) {
        if (!fc(r)) return !1;
        var e = _typeof(t);
        return !!("number" == e ? Hf(r) && Ci(t, r.length) : "string" == e && t in r) && Gf(r[t], n);
      }
      function Bi(n, t) {
        if (bh(n)) return !1;
        var r = _typeof(n);
        return !("number" != r && "symbol" != r && "boolean" != r && null != n && !bc(n)) || zt.test(n) || !Rt.test(n) || null != t && n in ll(t);
      }
      function Ti(n) {
        var t = _typeof(n);
        return "string" == t || "number" == t || "symbol" == t || "boolean" == t ? "__proto__" !== n : null === n;
      }
      function $i(n) {
        var t = bi(n),
          r = Z[t];
        if ("function" != typeof r || !(t in Ct.prototype)) return !1;
        if (n === r) return !0;
        var e = Os(r);
        return !!e && n === e[0];
      }
      function Di(n) {
        return !!ml && ml in n;
      }
      function Mi(n) {
        var t = n && n.constructor;
        return n === ("function" == typeof t && t.prototype || gl);
      }
      function Fi(n) {
        return n === n && !fc(n);
      }
      function Ni(n, t) {
        return function (r) {
          return null != r && r[n] === t && (t !== X || n in ll(r));
        };
      }
      function Pi(n) {
        var t = Cf(n, function (n) {
            return r.size === fn && r.clear(), n;
          }),
          r = t.cache;
        return t;
      }
      function qi(n, t) {
        var r = n[1],
          e = t[1],
          u = r | e,
          i = u < (_n | vn | mn),
          o = e == mn && r == yn || e == mn && r == xn && n[7].length <= t[8] || e == (mn | xn) && t[7].length <= t[8] && r == yn;
        if (!i && !o) return n;
        e & _n && (n[2] = t[2], u |= r & _n ? 0 : gn);
        var f = t[3];
        if (f) {
          var c = n[3];
          n[3] = c ? Uu(c, f, t[4]) : f, n[4] = c ? N(n[3], cn) : t[4];
        }
        return f = t[5], f && (c = n[5], n[5] = c ? Bu(c, f, t[6]) : f, n[6] = c ? N(n[5], cn) : t[6]), f = t[7], f && (n[7] = f), e & mn && (n[8] = null == n[8] ? t[8] : Hl(n[8], t[8])), null == n[9] && (n[9] = t[9]), n[0] = t[0], n[1] = u, n;
      }
      function Zi(n) {
        var t = [];
        if (null != n) for (var r in ll(n)) {
          t.push(r);
        }
        return t;
      }
      function Ki(n) {
        return xl.call(n);
      }
      function Vi(t, r, e) {
        return r = Gl(r === X ? t.length - 1 : r, 0), function () {
          for (var u = arguments, i = -1, o = Gl(u.length - r, 0), f = il(o); ++i < o;) {
            f[i] = u[r + i];
          }
          i = -1;
          for (var c = il(r + 1); ++i < r;) {
            c[i] = u[i];
          }
          return c[r] = e(f), n(t, this, c);
        };
      }
      function Gi(n, t) {
        return t.length < 2 ? n : _e(n, au(t, 0, -1));
      }
      function Hi(n, t) {
        for (var r = n.length, e = Hl(t.length, r), u = Tu(n); e--;) {
          var i = t[e];
          n[e] = Ci(i, r) ? u[i] : X;
        }
        return n;
      }
      function Ji(n, t) {
        if (("constructor" !== t || "function" != typeof n[t]) && "__proto__" != t) return n[t];
      }
      function Yi(n, t, r) {
        var e = t + "";
        return Ls(n, Wi(e, ro(Ii(e), r)));
      }
      function Qi(n) {
        var t = 0,
          r = 0;
        return function () {
          var e = Jl(),
            u = In - (e - r);
          if (r = e, u > 0) {
            if (++t >= On) return arguments[0];
          } else t = 0;
          return n.apply(X, arguments);
        };
      }
      function Xi(n, t) {
        var r = -1,
          e = n.length,
          u = e - 1;
        for (t = t === X ? e : t; ++r < t;) {
          var i = tu(r, u),
            o = n[i];
          n[i] = n[r], n[r] = o;
        }
        return n.length = t, n;
      }
      function no(n) {
        if ("string" == typeof n || bc(n)) return n;
        var t = n + "";
        return "0" == t && 1 / n == -Sn ? "-0" : t;
      }
      function to(n) {
        if (null != n) {
          try {
            return dl.call(n);
          } catch (n) {}
          try {
            return n + "";
          } catch (n) {}
        }
        return "";
      }
      function ro(n, t) {
        return r($n, function (r) {
          var e = "_." + r[0];
          t & r[1] && !o(n, e) && n.push(e);
        }), n.sort();
      }
      function eo(n) {
        if (n instanceof Ct) return n.clone();
        var t = new Y(n.__wrapped__, n.__chain__);
        return t.__actions__ = Tu(n.__actions__), t.__index__ = n.__index__, t.__values__ = n.__values__, t;
      }
      function uo(n, t, r) {
        t = (r ? Ui(n, t, r) : t === X) ? 1 : Gl(kc(t), 0);
        var e = null == n ? 0 : n.length;
        if (!e || t < 1) return [];
        for (var u = 0, i = 0, o = il(Fl(e / t)); u < e;) {
          o[i++] = au(n, u, u += t);
        }
        return o;
      }
      function io(n) {
        for (var t = -1, r = null == n ? 0 : n.length, e = 0, u = []; ++t < r;) {
          var i = n[t];
          i && (u[e++] = i);
        }
        return u;
      }
      function oo() {
        var n = arguments.length;
        if (!n) return [];
        for (var t = il(n - 1), r = arguments[0], e = n; e--;) {
          t[e - 1] = arguments[e];
        }
        return a(bh(r) ? Tu(r) : [r], ee(t, 1));
      }
      function fo(n, t, r) {
        var e = null == n ? 0 : n.length;
        return e ? (t = r || t === X ? 1 : kc(t), au(n, t < 0 ? 0 : t, e)) : [];
      }
      function co(n, t, r) {
        var e = null == n ? 0 : n.length;
        return e ? (t = r || t === X ? 1 : kc(t), t = e - t, au(n, 0, t < 0 ? 0 : t)) : [];
      }
      function ao(n, t) {
        return n && n.length ? bu(n, mi(t, 3), !0, !0) : [];
      }
      function lo(n, t) {
        return n && n.length ? bu(n, mi(t, 3), !0) : [];
      }
      function so(n, t, r, e) {
        var u = null == n ? 0 : n.length;
        return u ? (r && "number" != typeof r && Ui(n, t, r) && (r = 0, e = u), ne(n, t, r, e)) : [];
      }
      function ho(n, t, r) {
        var e = null == n ? 0 : n.length;
        if (!e) return -1;
        var u = null == r ? 0 : kc(r);
        return u < 0 && (u = Gl(e + u, 0)), g(n, mi(t, 3), u);
      }
      function po(n, t, r) {
        var e = null == n ? 0 : n.length;
        if (!e) return -1;
        var u = e - 1;
        return r !== X && (u = kc(r), u = r < 0 ? Gl(e + u, 0) : Hl(u, e - 1)), g(n, mi(t, 3), u, !0);
      }
      function _o(n) {
        return (null == n ? 0 : n.length) ? ee(n, 1) : [];
      }
      function vo(n) {
        return (null == n ? 0 : n.length) ? ee(n, Sn) : [];
      }
      function go(n, t) {
        return (null == n ? 0 : n.length) ? (t = t === X ? 1 : kc(t), ee(n, t)) : [];
      }
      function yo(n) {
        for (var t = -1, r = null == n ? 0 : n.length, e = {}; ++t < r;) {
          var u = n[t];
          e[u[0]] = u[1];
        }
        return e;
      }
      function bo(n) {
        return n && n.length ? n[0] : X;
      }
      function wo(n, t, r) {
        var e = null == n ? 0 : n.length;
        if (!e) return -1;
        var u = null == r ? 0 : kc(r);
        return u < 0 && (u = Gl(e + u, 0)), y(n, t, u);
      }
      function mo(n) {
        return (null == n ? 0 : n.length) ? au(n, 0, -1) : [];
      }
      function xo(n, t) {
        return null == n ? "" : Kl.call(n, t);
      }
      function jo(n) {
        var t = null == n ? 0 : n.length;
        return t ? n[t - 1] : X;
      }
      function Ao(n, t, r) {
        var e = null == n ? 0 : n.length;
        if (!e) return -1;
        var u = e;
        return r !== X && (u = kc(r), u = u < 0 ? Gl(e + u, 0) : Hl(u, e - 1)), t === t ? K(n, t, u) : g(n, b, u, !0);
      }
      function ko(n, t) {
        return n && n.length ? Ge(n, kc(t)) : X;
      }
      function Oo(n, t) {
        return n && n.length && t && t.length ? Xe(n, t) : n;
      }
      function Io(n, t, r) {
        return n && n.length && t && t.length ? Xe(n, t, mi(r, 2)) : n;
      }
      function Ro(n, t, r) {
        return n && n.length && t && t.length ? Xe(n, t, X, r) : n;
      }
      function zo(n, t) {
        var r = [];
        if (!n || !n.length) return r;
        var e = -1,
          u = [],
          i = n.length;
        for (t = mi(t, 3); ++e < i;) {
          var o = n[e];
          t(o, e, n) && (r.push(o), u.push(e));
        }
        return nu(n, u), r;
      }
      function Eo(n) {
        return null == n ? n : Xl.call(n);
      }
      function So(n, t, r) {
        var e = null == n ? 0 : n.length;
        return e ? (r && "number" != typeof r && Ui(n, t, r) ? (t = 0, r = e) : (t = null == t ? 0 : kc(t), r = r === X ? e : kc(r)), au(n, t, r)) : [];
      }
      function Wo(n, t) {
        return su(n, t);
      }
      function Lo(n, t, r) {
        return hu(n, t, mi(r, 2));
      }
      function Co(n, t) {
        var r = null == n ? 0 : n.length;
        if (r) {
          var e = su(n, t);
          if (e < r && Gf(n[e], t)) return e;
        }
        return -1;
      }
      function Uo(n, t) {
        return su(n, t, !0);
      }
      function Bo(n, t, r) {
        return hu(n, t, mi(r, 2), !0);
      }
      function To(n, t) {
        if (null == n ? 0 : n.length) {
          var r = su(n, t, !0) - 1;
          if (Gf(n[r], t)) return r;
        }
        return -1;
      }
      function $o(n) {
        return n && n.length ? pu(n) : [];
      }
      function Do(n, t) {
        return n && n.length ? pu(n, mi(t, 2)) : [];
      }
      function Mo(n) {
        var t = null == n ? 0 : n.length;
        return t ? au(n, 1, t) : [];
      }
      function Fo(n, t, r) {
        return n && n.length ? (t = r || t === X ? 1 : kc(t), au(n, 0, t < 0 ? 0 : t)) : [];
      }
      function No(n, t, r) {
        var e = null == n ? 0 : n.length;
        return e ? (t = r || t === X ? 1 : kc(t), t = e - t, au(n, t < 0 ? 0 : t, e)) : [];
      }
      function Po(n, t) {
        return n && n.length ? bu(n, mi(t, 3), !1, !0) : [];
      }
      function qo(n, t) {
        return n && n.length ? bu(n, mi(t, 3)) : [];
      }
      function Zo(n) {
        return n && n.length ? gu(n) : [];
      }
      function Ko(n, t) {
        return n && n.length ? gu(n, mi(t, 2)) : [];
      }
      function Vo(n, t) {
        return t = "function" == typeof t ? t : X, n && n.length ? gu(n, X, t) : [];
      }
      function Go(n) {
        if (!n || !n.length) return [];
        var t = 0;
        return n = i(n, function (n) {
          if (Jf(n)) return t = Gl(n.length, t), !0;
        }), O(t, function (t) {
          return c(n, m(t));
        });
      }
      function Ho(t, r) {
        if (!t || !t.length) return [];
        var e = Go(t);
        return null == r ? e : c(e, function (t) {
          return n(r, X, t);
        });
      }
      function Jo(n, t) {
        return xu(n || [], t || [], Sr);
      }
      function Yo(n, t) {
        return xu(n || [], t || [], fu);
      }
      function Qo(n) {
        var t = Z(n);
        return t.__chain__ = !0, t;
      }
      function Xo(n, t) {
        return t(n), n;
      }
      function nf(n, t) {
        return t(n);
      }
      function tf() {
        return Qo(this);
      }
      function rf() {
        return new Y(this.value(), this.__chain__);
      }
      function ef() {
        this.__values__ === X && (this.__values__ = jc(this.value()));
        var n = this.__index__ >= this.__values__.length;
        return {
          done: n,
          value: n ? X : this.__values__[this.__index__++]
        };
      }
      function uf() {
        return this;
      }
      function of(n) {
        for (var t, r = this; r instanceof J;) {
          var e = eo(r);
          e.__index__ = 0, e.__values__ = X, t ? u.__wrapped__ = e : t = e;
          var u = e;
          r = r.__wrapped__;
        }
        return u.__wrapped__ = n, t;
      }
      function ff() {
        var n = this.__wrapped__;
        if (n instanceof Ct) {
          var t = n;
          return this.__actions__.length && (t = new Ct(this)), t = t.reverse(), t.__actions__.push({
            func: nf,
            args: [Eo],
            thisArg: X
          }), new Y(t, this.__chain__);
        }
        return this.thru(Eo);
      }
      function cf() {
        return wu(this.__wrapped__, this.__actions__);
      }
      function af(n, t, r) {
        var e = bh(n) ? u : Jr;
        return r && Ui(n, t, r) && (t = X), e(n, mi(t, 3));
      }
      function lf(n, t) {
        return (bh(n) ? i : te)(n, mi(t, 3));
      }
      function sf(n, t) {
        return ee(yf(n, t), 1);
      }
      function hf(n, t) {
        return ee(yf(n, t), Sn);
      }
      function pf(n, t, r) {
        return r = r === X ? 1 : kc(r), ee(yf(n, t), r);
      }
      function _f(n, t) {
        return (bh(n) ? r : ys)(n, mi(t, 3));
      }
      function vf(n, t) {
        return (bh(n) ? e : ds)(n, mi(t, 3));
      }
      function gf(n, t, r, e) {
        n = Hf(n) ? n : ra(n), r = r && !e ? kc(r) : 0;
        var u = n.length;
        return r < 0 && (r = Gl(u + r, 0)), dc(n) ? r <= u && n.indexOf(t, r) > -1 : !!u && y(n, t, r) > -1;
      }
      function yf(n, t) {
        return (bh(n) ? c : Pe)(n, mi(t, 3));
      }
      function df(n, t, r, e) {
        return null == n ? [] : (bh(t) || (t = null == t ? [] : [t]), r = e ? X : r, bh(r) || (r = null == r ? [] : [r]), He(n, t, r));
      }
      function bf(n, t, r) {
        var e = bh(n) ? l : j,
          u = arguments.length < 3;
        return e(n, mi(t, 4), r, u, ys);
      }
      function wf(n, t, r) {
        var e = bh(n) ? s : j,
          u = arguments.length < 3;
        return e(n, mi(t, 4), r, u, ds);
      }
      function mf(n, t) {
        return (bh(n) ? i : te)(n, Uf(mi(t, 3)));
      }
      function xf(n) {
        return (bh(n) ? Ir : iu)(n);
      }
      function jf(n, t, r) {
        return t = (r ? Ui(n, t, r) : t === X) ? 1 : kc(t), (bh(n) ? Rr : ou)(n, t);
      }
      function Af(n) {
        return (bh(n) ? zr : cu)(n);
      }
      function kf(n) {
        if (null == n) return 0;
        if (Hf(n)) return dc(n) ? V(n) : n.length;
        var t = zs(n);
        return t == Gn || t == tt ? n.size : Me(n).length;
      }
      function Of(n, t, r) {
        var e = bh(n) ? h : lu;
        return r && Ui(n, t, r) && (t = X), e(n, mi(t, 3));
      }
      function If(n, t) {
        if ("function" != typeof t) throw new pl(en);
        return n = kc(n), function () {
          if (--n < 1) return t.apply(this, arguments);
        };
      }
      function Rf(n, t, r) {
        return t = r ? X : t, t = n && null == t ? n.length : t, ai(n, mn, X, X, X, X, t);
      }
      function zf(n, t) {
        var r;
        if ("function" != typeof t) throw new pl(en);
        return n = kc(n), function () {
          return --n > 0 && (r = t.apply(this, arguments)), n <= 1 && (t = X), r;
        };
      }
      function Ef(n, t, r) {
        t = r ? X : t;
        var e = ai(n, yn, X, X, X, X, X, t);
        return e.placeholder = Ef.placeholder, e;
      }
      function Sf(n, t, r) {
        t = r ? X : t;
        var e = ai(n, dn, X, X, X, X, X, t);
        return e.placeholder = Sf.placeholder, e;
      }
      function Wf(n, t, r) {
        function e(t) {
          var r = h,
            e = p;
          return h = p = X, d = t, v = n.apply(e, r);
        }
        function u(n) {
          return d = n, g = Ws(f, t), b ? e(n) : v;
        }
        function i(n) {
          var r = n - y,
            e = n - d,
            u = t - r;
          return w ? Hl(u, _ - e) : u;
        }
        function o(n) {
          var r = n - y,
            e = n - d;
          return y === X || r >= t || r < 0 || w && e >= _;
        }
        function f() {
          var n = fh();
          return o(n) ? c(n) : (g = Ws(f, i(n)), X);
        }
        function c(n) {
          return g = X, m && h ? e(n) : (h = p = X, v);
        }
        function a() {
          g !== X && As(g), d = 0, h = y = p = g = X;
        }
        function l() {
          return g === X ? v : c(fh());
        }
        function s() {
          var n = fh(),
            r = o(n);
          if (h = arguments, p = this, y = n, r) {
            if (g === X) return u(y);
            if (w) return As(g), g = Ws(f, t), e(y);
          }
          return g === X && (g = Ws(f, t)), v;
        }
        var h,
          p,
          _,
          v,
          g,
          y,
          d = 0,
          b = !1,
          w = !1,
          m = !0;
        if ("function" != typeof n) throw new pl(en);
        return t = Ic(t) || 0, fc(r) && (b = !!r.leading, w = "maxWait" in r, _ = w ? Gl(Ic(r.maxWait) || 0, t) : _, m = "trailing" in r ? !!r.trailing : m), s.cancel = a, s.flush = l, s;
      }
      function Lf(n) {
        return ai(n, jn);
      }
      function Cf(n, t) {
        if ("function" != typeof n || null != t && "function" != typeof t) throw new pl(en);
        var r = function r() {
          var e = arguments,
            u = t ? t.apply(this, e) : e[0],
            i = r.cache;
          if (i.has(u)) return i.get(u);
          var o = n.apply(this, e);
          return r.cache = i.set(u, o) || i, o;
        };
        return r.cache = new (Cf.Cache || sr)(), r;
      }
      function Uf(n) {
        if ("function" != typeof n) throw new pl(en);
        return function () {
          var t = arguments;
          switch (t.length) {
            case 0:
              return !n.call(this);
            case 1:
              return !n.call(this, t[0]);
            case 2:
              return !n.call(this, t[0], t[1]);
            case 3:
              return !n.call(this, t[0], t[1], t[2]);
          }
          return !n.apply(this, t);
        };
      }
      function Bf(n) {
        return zf(2, n);
      }
      function Tf(n, t) {
        if ("function" != typeof n) throw new pl(en);
        return t = t === X ? t : kc(t), uu(n, t);
      }
      function $f(t, r) {
        if ("function" != typeof t) throw new pl(en);
        return r = null == r ? 0 : Gl(kc(r), 0), uu(function (e) {
          var u = e[r],
            i = Ou(e, 0, r);
          return u && a(i, u), n(t, this, i);
        });
      }
      function Df(n, t, r) {
        var e = !0,
          u = !0;
        if ("function" != typeof n) throw new pl(en);
        return fc(r) && (e = "leading" in r ? !!r.leading : e, u = "trailing" in r ? !!r.trailing : u), Wf(n, t, {
          leading: e,
          maxWait: t,
          trailing: u
        });
      }
      function Mf(n) {
        return Rf(n, 1);
      }
      function Ff(n, t) {
        return ph(Au(t), n);
      }
      function Nf() {
        if (!arguments.length) return [];
        var n = arguments[0];
        return bh(n) ? n : [n];
      }
      function Pf(n) {
        return Fr(n, sn);
      }
      function qf(n, t) {
        return t = "function" == typeof t ? t : X, Fr(n, sn, t);
      }
      function Zf(n) {
        return Fr(n, an | sn);
      }
      function Kf(n, t) {
        return t = "function" == typeof t ? t : X, Fr(n, an | sn, t);
      }
      function Vf(n, t) {
        return null == t || Pr(n, t, Pc(t));
      }
      function Gf(n, t) {
        return n === t || n !== n && t !== t;
      }
      function Hf(n) {
        return null != n && oc(n.length) && !uc(n);
      }
      function Jf(n) {
        return cc(n) && Hf(n);
      }
      function Yf(n) {
        return n === !0 || n === !1 || cc(n) && we(n) == Nn;
      }
      function Qf(n) {
        return cc(n) && 1 === n.nodeType && !gc(n);
      }
      function Xf(n) {
        if (null == n) return !0;
        if (Hf(n) && (bh(n) || "string" == typeof n || "function" == typeof n.splice || mh(n) || Oh(n) || dh(n))) return !n.length;
        var t = zs(n);
        if (t == Gn || t == tt) return !n.size;
        if (Mi(n)) return !Me(n).length;
        for (var r in n) {
          if (bl.call(n, r)) return !1;
        }
        return !0;
      }
      function nc(n, t) {
        return Se(n, t);
      }
      function tc(n, t, r) {
        r = "function" == typeof r ? r : X;
        var e = r ? r(n, t) : X;
        return e === X ? Se(n, t, X, r) : !!e;
      }
      function rc(n) {
        if (!cc(n)) return !1;
        var t = we(n);
        return t == Zn || t == qn || "string" == typeof n.message && "string" == typeof n.name && !gc(n);
      }
      function ec(n) {
        return "number" == typeof n && Zl(n);
      }
      function uc(n) {
        if (!fc(n)) return !1;
        var t = we(n);
        return t == Kn || t == Vn || t == Fn || t == Xn;
      }
      function ic(n) {
        return "number" == typeof n && n == kc(n);
      }
      function oc(n) {
        return "number" == typeof n && n > -1 && n % 1 == 0 && n <= Wn;
      }
      function fc(n) {
        var t = _typeof(n);
        return null != n && ("object" == t || "function" == t);
      }
      function cc(n) {
        return null != n && "object" == _typeof(n);
      }
      function ac(n, t) {
        return n === t || Ce(n, t, ji(t));
      }
      function lc(n, t, r) {
        return r = "function" == typeof r ? r : X, Ce(n, t, ji(t), r);
      }
      function sc(n) {
        return vc(n) && n != +n;
      }
      function hc(n) {
        if (Es(n)) throw new fl(rn);
        return Ue(n);
      }
      function pc(n) {
        return null === n;
      }
      function _c(n) {
        return null == n;
      }
      function vc(n) {
        return "number" == typeof n || cc(n) && we(n) == Hn;
      }
      function gc(n) {
        if (!cc(n) || we(n) != Yn) return !1;
        var t = El(n);
        if (null === t) return !0;
        var r = bl.call(t, "constructor") && t.constructor;
        return "function" == typeof r && r instanceof r && dl.call(r) == jl;
      }
      function yc(n) {
        return ic(n) && n >= -Wn && n <= Wn;
      }
      function dc(n) {
        return "string" == typeof n || !bh(n) && cc(n) && we(n) == rt;
      }
      function bc(n) {
        return "symbol" == _typeof(n) || cc(n) && we(n) == et;
      }
      function wc(n) {
        return n === X;
      }
      function mc(n) {
        return cc(n) && zs(n) == it;
      }
      function xc(n) {
        return cc(n) && we(n) == ot;
      }
      function jc(n) {
        if (!n) return [];
        if (Hf(n)) return dc(n) ? G(n) : Tu(n);
        if (Ul && n[Ul]) return D(n[Ul]());
        var t = zs(n);
        return (t == Gn ? M : t == tt ? P : ra)(n);
      }
      function Ac(n) {
        if (!n) return 0 === n ? n : 0;
        if (n = Ic(n), n === Sn || n === -Sn) {
          return (n < 0 ? -1 : 1) * Ln;
        }
        return n === n ? n : 0;
      }
      function kc(n) {
        var t = Ac(n),
          r = t % 1;
        return t === t ? r ? t - r : t : 0;
      }
      function Oc(n) {
        return n ? Mr(kc(n), 0, Un) : 0;
      }
      function Ic(n) {
        if ("number" == typeof n) return n;
        if (bc(n)) return Cn;
        if (fc(n)) {
          var t = "function" == typeof n.valueOf ? n.valueOf() : n;
          n = fc(t) ? t + "" : t;
        }
        if ("string" != typeof n) return 0 === n ? n : +n;
        n = R(n);
        var r = qt.test(n);
        return r || Kt.test(n) ? Xr(n.slice(2), r ? 2 : 8) : Pt.test(n) ? Cn : +n;
      }
      function Rc(n) {
        return $u(n, qc(n));
      }
      function zc(n) {
        return n ? Mr(kc(n), -Wn, Wn) : 0 === n ? n : 0;
      }
      function Ec(n) {
        return null == n ? "" : vu(n);
      }
      function Sc(n, t) {
        var r = gs(n);
        return null == t ? r : Cr(r, t);
      }
      function Wc(n, t) {
        return v(n, mi(t, 3), ue);
      }
      function Lc(n, t) {
        return v(n, mi(t, 3), oe);
      }
      function Cc(n, t) {
        return null == n ? n : bs(n, mi(t, 3), qc);
      }
      function Uc(n, t) {
        return null == n ? n : ws(n, mi(t, 3), qc);
      }
      function Bc(n, t) {
        return n && ue(n, mi(t, 3));
      }
      function Tc(n, t) {
        return n && oe(n, mi(t, 3));
      }
      function $c(n) {
        return null == n ? [] : fe(n, Pc(n));
      }
      function Dc(n) {
        return null == n ? [] : fe(n, qc(n));
      }
      function Mc(n, t, r) {
        var e = null == n ? X : _e(n, t);
        return e === X ? r : e;
      }
      function Fc(n, t) {
        return null != n && Ri(n, t, xe);
      }
      function Nc(n, t) {
        return null != n && Ri(n, t, je);
      }
      function Pc(n) {
        return Hf(n) ? Or(n) : Me(n);
      }
      function qc(n) {
        return Hf(n) ? Or(n, !0) : Fe(n);
      }
      function Zc(n, t) {
        var r = {};
        return t = mi(t, 3), ue(n, function (n, e, u) {
          Br(r, t(n, e, u), n);
        }), r;
      }
      function Kc(n, t) {
        var r = {};
        return t = mi(t, 3), ue(n, function (n, e, u) {
          Br(r, e, t(n, e, u));
        }), r;
      }
      function Vc(n, t) {
        return Gc(n, Uf(mi(t)));
      }
      function Gc(n, t) {
        if (null == n) return {};
        var r = c(di(n), function (n) {
          return [n];
        });
        return t = mi(t), Ye(n, r, function (n, r) {
          return t(n, r[0]);
        });
      }
      function Hc(n, t, r) {
        t = ku(t, n);
        var e = -1,
          u = t.length;
        for (u || (u = 1, n = X); ++e < u;) {
          var i = null == n ? X : n[no(t[e])];
          i === X && (e = u, i = r), n = uc(i) ? i.call(n) : i;
        }
        return n;
      }
      function Jc(n, t, r) {
        return null == n ? n : fu(n, t, r);
      }
      function Yc(n, t, r, e) {
        return e = "function" == typeof e ? e : X, null == n ? n : fu(n, t, r, e);
      }
      function Qc(n, t, e) {
        var u = bh(n),
          i = u || mh(n) || Oh(n);
        if (t = mi(t, 4), null == e) {
          var o = n && n.constructor;
          e = i ? u ? new o() : [] : fc(n) && uc(o) ? gs(El(n)) : {};
        }
        return (i ? r : ue)(n, function (n, r, u) {
          return t(e, n, r, u);
        }), e;
      }
      function Xc(n, t) {
        return null == n || yu(n, t);
      }
      function na(n, t, r) {
        return null == n ? n : du(n, t, Au(r));
      }
      function ta(n, t, r, e) {
        return e = "function" == typeof e ? e : X, null == n ? n : du(n, t, Au(r), e);
      }
      function ra(n) {
        return null == n ? [] : E(n, Pc(n));
      }
      function ea(n) {
        return null == n ? [] : E(n, qc(n));
      }
      function ua(n, t, r) {
        return r === X && (r = t, t = X), r !== X && (r = Ic(r), r = r === r ? r : 0), t !== X && (t = Ic(t), t = t === t ? t : 0), Mr(Ic(n), t, r);
      }
      function ia(n, t, r) {
        return t = Ac(t), r === X ? (r = t, t = 0) : r = Ac(r), n = Ic(n), Ae(n, t, r);
      }
      function oa(n, t, r) {
        if (r && "boolean" != typeof r && Ui(n, t, r) && (t = r = X), r === X && ("boolean" == typeof t ? (r = t, t = X) : "boolean" == typeof n && (r = n, n = X)), n === X && t === X ? (n = 0, t = 1) : (n = Ac(n), t === X ? (t = n, n = 0) : t = Ac(t)), n > t) {
          var e = n;
          n = t, t = e;
        }
        if (r || n % 1 || t % 1) {
          var u = Ql();
          return Hl(n + u * (t - n + Qr("1e-" + ((u + "").length - 1))), t);
        }
        return tu(n, t);
      }
      function fa(n) {
        return Qh(Ec(n).toLowerCase());
      }
      function ca(n) {
        return n = Ec(n), n && n.replace(Gt, ve).replace(Dr, "");
      }
      function aa(n, t, r) {
        n = Ec(n), t = vu(t);
        var e = n.length;
        r = r === X ? e : Mr(kc(r), 0, e);
        var u = r;
        return r -= t.length, r >= 0 && n.slice(r, u) == t;
      }
      function la(n) {
        return n = Ec(n), n && At.test(n) ? n.replace(xt, ge) : n;
      }
      function sa(n) {
        return n = Ec(n), n && Wt.test(n) ? n.replace(St, "\\$&") : n;
      }
      function ha(n, t, r) {
        n = Ec(n), t = kc(t);
        var e = t ? V(n) : 0;
        if (!t || e >= t) return n;
        var u = (t - e) / 2;
        return ri(Nl(u), r) + n + ri(Fl(u), r);
      }
      function pa(n, t, r) {
        n = Ec(n), t = kc(t);
        var e = t ? V(n) : 0;
        return t && e < t ? n + ri(t - e, r) : n;
      }
      function _a(n, t, r) {
        n = Ec(n), t = kc(t);
        var e = t ? V(n) : 0;
        return t && e < t ? ri(t - e, r) + n : n;
      }
      function va(n, t, r) {
        return r || null == t ? t = 0 : t && (t = +t), Yl(Ec(n).replace(Lt, ""), t || 0);
      }
      function ga(n, t, r) {
        return t = (r ? Ui(n, t, r) : t === X) ? 1 : kc(t), eu(Ec(n), t);
      }
      function ya() {
        var n = arguments,
          t = Ec(n[0]);
        return n.length < 3 ? t : t.replace(n[1], n[2]);
      }
      function da(n, t, r) {
        return r && "number" != typeof r && Ui(n, t, r) && (t = r = X), (r = r === X ? Un : r >>> 0) ? (n = Ec(n), n && ("string" == typeof t || null != t && !Ah(t)) && (t = vu(t), !t && T(n)) ? Ou(G(n), 0, r) : n.split(t, r)) : [];
      }
      function ba(n, t, r) {
        return n = Ec(n), r = null == r ? 0 : Mr(kc(r), 0, n.length), t = vu(t), n.slice(r, r + t.length) == t;
      }
      function wa(n, t, r) {
        var e = Z.templateSettings;
        r && Ui(n, t, r) && (t = X), n = Ec(n), t = Sh({}, t, e, li);
        var u,
          i,
          o = Sh({}, t.imports, e.imports, li),
          f = Pc(o),
          c = E(o, f),
          a = 0,
          l = t.interpolate || Ht,
          s = "__p += '",
          h = sl((t.escape || Ht).source + "|" + l.source + "|" + (l === It ? Ft : Ht).source + "|" + (t.evaluate || Ht).source + "|$", "g"),
          p = "//# sourceURL=" + (bl.call(t, "sourceURL") ? (t.sourceURL + "").replace(/\s/g, " ") : "lodash.templateSources[" + ++Zr + "]") + "\n";
        n.replace(h, function (t, r, e, o, f, c) {
          return e || (e = o), s += n.slice(a, c).replace(Jt, U), r && (u = !0, s += "' +\n__e(" + r + ") +\n'"), f && (i = !0, s += "';\n" + f + ";\n__p += '"), e && (s += "' +\n((__t = (" + e + ")) == null ? '' : __t) +\n'"), a = c + t.length, t;
        }), s += "';\n";
        var _ = bl.call(t, "variable") && t.variable;
        if (_) {
          if (Dt.test(_)) throw new fl(un);
        } else s = "with (obj) {\n" + s + "\n}\n";
        s = (i ? s.replace(dt, "") : s).replace(bt, "$1").replace(wt, "$1;"), s = "function(" + (_ || "obj") + ") {\n" + (_ ? "" : "obj || (obj = {});\n") + "var __t, __p = ''" + (u ? ", __e = _.escape" : "") + (i ? ", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n" : ";\n") + s + "return __p\n}";
        var v = Xh(function () {
          return cl(f, p + "return " + s).apply(X, c);
        });
        if (v.source = s, rc(v)) throw v;
        return v;
      }
      function ma(n) {
        return Ec(n).toLowerCase();
      }
      function xa(n) {
        return Ec(n).toUpperCase();
      }
      function ja(n, t, r) {
        if (n = Ec(n), n && (r || t === X)) return R(n);
        if (!n || !(t = vu(t))) return n;
        var e = G(n),
          u = G(t);
        return Ou(e, W(e, u), L(e, u) + 1).join("");
      }
      function Aa(n, t, r) {
        if (n = Ec(n), n && (r || t === X)) return n.slice(0, H(n) + 1);
        if (!n || !(t = vu(t))) return n;
        var e = G(n);
        return Ou(e, 0, L(e, G(t)) + 1).join("");
      }
      function ka(n, t, r) {
        if (n = Ec(n), n && (r || t === X)) return n.replace(Lt, "");
        if (!n || !(t = vu(t))) return n;
        var e = G(n);
        return Ou(e, W(e, G(t))).join("");
      }
      function Oa(n, t) {
        var r = An,
          e = kn;
        if (fc(t)) {
          var u = "separator" in t ? t.separator : u;
          r = "length" in t ? kc(t.length) : r, e = "omission" in t ? vu(t.omission) : e;
        }
        n = Ec(n);
        var i = n.length;
        if (T(n)) {
          var o = G(n);
          i = o.length;
        }
        if (r >= i) return n;
        var f = r - V(e);
        if (f < 1) return e;
        var c = o ? Ou(o, 0, f).join("") : n.slice(0, f);
        if (u === X) return c + e;
        if (o && (f += c.length - f), Ah(u)) {
          if (n.slice(f).search(u)) {
            var a,
              l = c;
            for (u.global || (u = sl(u.source, Ec(Nt.exec(u)) + "g")), u.lastIndex = 0; a = u.exec(l);) {
              var s = a.index;
            }
            c = c.slice(0, s === X ? f : s);
          }
        } else if (n.indexOf(vu(u), f) != f) {
          var h = c.lastIndexOf(u);
          h > -1 && (c = c.slice(0, h));
        }
        return c + e;
      }
      function Ia(n) {
        return n = Ec(n), n && jt.test(n) ? n.replace(mt, ye) : n;
      }
      function Ra(n, t, r) {
        return n = Ec(n), t = r ? X : t, t === X ? $(n) ? Q(n) : _(n) : n.match(t) || [];
      }
      function za(t) {
        var r = null == t ? 0 : t.length,
          e = mi();
        return t = r ? c(t, function (n) {
          if ("function" != typeof n[1]) throw new pl(en);
          return [e(n[0]), n[1]];
        }) : [], uu(function (e) {
          for (var u = -1; ++u < r;) {
            var i = t[u];
            if (n(i[0], this, e)) return n(i[1], this, e);
          }
        });
      }
      function Ea(n) {
        return Nr(Fr(n, an));
      }
      function Sa(n) {
        return function () {
          return n;
        };
      }
      function Wa(n, t) {
        return null == n || n !== n ? t : n;
      }
      function La(n) {
        return n;
      }
      function Ca(n) {
        return De("function" == typeof n ? n : Fr(n, an));
      }
      function Ua(n) {
        return qe(Fr(n, an));
      }
      function Ba(n, t) {
        return Ze(n, Fr(t, an));
      }
      function Ta(n, t, e) {
        var u = Pc(t),
          i = fe(t, u);
        null != e || fc(t) && (i.length || !u.length) || (e = t, t = n, n = this, i = fe(t, Pc(t)));
        var o = !(fc(e) && "chain" in e && !e.chain),
          f = uc(n);
        return r(i, function (r) {
          var e = t[r];
          n[r] = e, f && (n.prototype[r] = function () {
            var t = this.__chain__;
            if (o || t) {
              var r = n(this.__wrapped__);
              return (r.__actions__ = Tu(this.__actions__)).push({
                func: e,
                args: arguments,
                thisArg: n
              }), r.__chain__ = t, r;
            }
            return e.apply(n, a([this.value()], arguments));
          });
        }), n;
      }
      function $a() {
        return re._ === this && (re._ = Al), this;
      }
      function Da() {}
      function Ma(n) {
        return n = kc(n), uu(function (t) {
          return Ge(t, n);
        });
      }
      function Fa(n) {
        return Bi(n) ? m(no(n)) : Qe(n);
      }
      function Na(n) {
        return function (t) {
          return null == n ? X : _e(n, t);
        };
      }
      function Pa() {
        return [];
      }
      function qa() {
        return !1;
      }
      function Za() {
        return {};
      }
      function Ka() {
        return "";
      }
      function Va() {
        return !0;
      }
      function Ga(n, t) {
        if (n = kc(n), n < 1 || n > Wn) return [];
        var r = Un,
          e = Hl(n, Un);
        t = mi(t), n -= Un;
        for (var u = O(e, t); ++r < n;) {
          t(r);
        }
        return u;
      }
      function Ha(n) {
        return bh(n) ? c(n, no) : bc(n) ? [n] : Tu(Cs(Ec(n)));
      }
      function Ja(n) {
        var t = ++wl;
        return Ec(n) + t;
      }
      function Ya(n) {
        return n && n.length ? Yr(n, La, me) : X;
      }
      function Qa(n, t) {
        return n && n.length ? Yr(n, mi(t, 2), me) : X;
      }
      function Xa(n) {
        return w(n, La);
      }
      function nl(n, t) {
        return w(n, mi(t, 2));
      }
      function tl(n) {
        return n && n.length ? Yr(n, La, Ne) : X;
      }
      function rl(n, t) {
        return n && n.length ? Yr(n, mi(t, 2), Ne) : X;
      }
      function el(n) {
        return n && n.length ? k(n, La) : 0;
      }
      function ul(n, t) {
        return n && n.length ? k(n, mi(t, 2)) : 0;
      }
      x = null == x ? re : be.defaults(re.Object(), x, be.pick(re, qr));
      var il = x.Array,
        ol = x.Date,
        fl = x.Error,
        cl = x.Function,
        al = x.Math,
        ll = x.Object,
        sl = x.RegExp,
        hl = x.String,
        pl = x.TypeError,
        _l = il.prototype,
        vl = cl.prototype,
        gl = ll.prototype,
        yl = x["__core-js_shared__"],
        dl = vl.toString,
        bl = gl.hasOwnProperty,
        wl = 0,
        ml = function () {
          var n = /[^.]+$/.exec(yl && yl.keys && yl.keys.IE_PROTO || "");
          return n ? "Symbol(src)_1." + n : "";
        }(),
        xl = gl.toString,
        jl = dl.call(ll),
        Al = re._,
        kl = sl("^" + dl.call(bl).replace(St, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"),
        Ol = ie ? x.Buffer : X,
        Il = x.Symbol,
        Rl = x.Uint8Array,
        zl = Ol ? Ol.allocUnsafe : X,
        El = F(ll.getPrototypeOf, ll),
        Sl = ll.create,
        Wl = gl.propertyIsEnumerable,
        Ll = _l.splice,
        Cl = Il ? Il.isConcatSpreadable : X,
        Ul = Il ? Il.iterator : X,
        Bl = Il ? Il.toStringTag : X,
        Tl = function () {
          try {
            var n = Ai(ll, "defineProperty");
            return n({}, "", {}), n;
          } catch (n) {}
        }(),
        $l = x.clearTimeout !== re.clearTimeout && x.clearTimeout,
        Dl = ol && ol.now !== re.Date.now && ol.now,
        Ml = x.setTimeout !== re.setTimeout && x.setTimeout,
        Fl = al.ceil,
        Nl = al.floor,
        Pl = ll.getOwnPropertySymbols,
        ql = Ol ? Ol.isBuffer : X,
        Zl = x.isFinite,
        Kl = _l.join,
        Vl = F(ll.keys, ll),
        Gl = al.max,
        Hl = al.min,
        Jl = ol.now,
        Yl = x.parseInt,
        Ql = al.random,
        Xl = _l.reverse,
        ns = Ai(x, "DataView"),
        ts = Ai(x, "Map"),
        rs = Ai(x, "Promise"),
        es = Ai(x, "Set"),
        us = Ai(x, "WeakMap"),
        is = Ai(ll, "create"),
        os = us && new us(),
        fs = {},
        cs = to(ns),
        as = to(ts),
        ls = to(rs),
        ss = to(es),
        hs = to(us),
        ps = Il ? Il.prototype : X,
        _s = ps ? ps.valueOf : X,
        vs = ps ? ps.toString : X,
        gs = function () {
          function n() {}
          return function (t) {
            if (!fc(t)) return {};
            if (Sl) return Sl(t);
            n.prototype = t;
            var r = new n();
            return n.prototype = X, r;
          };
        }();
      Z.templateSettings = {
        escape: kt,
        evaluate: Ot,
        interpolate: It,
        variable: "",
        imports: {
          _: Z
        }
      }, Z.prototype = J.prototype, Z.prototype.constructor = Z, Y.prototype = gs(J.prototype), Y.prototype.constructor = Y, Ct.prototype = gs(J.prototype), Ct.prototype.constructor = Ct, Xt.prototype.clear = nr, Xt.prototype["delete"] = tr, Xt.prototype.get = rr, Xt.prototype.has = er, Xt.prototype.set = ur, ir.prototype.clear = or, ir.prototype["delete"] = fr, ir.prototype.get = cr, ir.prototype.has = ar, ir.prototype.set = lr, sr.prototype.clear = hr, sr.prototype["delete"] = pr, sr.prototype.get = _r, sr.prototype.has = vr, sr.prototype.set = gr, yr.prototype.add = yr.prototype.push = dr, yr.prototype.has = br, wr.prototype.clear = mr, wr.prototype["delete"] = xr, wr.prototype.get = jr, wr.prototype.has = Ar, wr.prototype.set = kr;
      var ys = Pu(ue),
        ds = Pu(oe, !0),
        bs = qu(),
        ws = qu(!0),
        ms = os ? function (n, t) {
          return os.set(n, t), n;
        } : La,
        xs = Tl ? function (n, t) {
          return Tl(n, "toString", {
            configurable: !0,
            enumerable: !1,
            value: Sa(t),
            writable: !0
          });
        } : La,
        js = uu,
        As = $l || function (n) {
          return re.clearTimeout(n);
        },
        ks = es && 1 / P(new es([, -0]))[1] == Sn ? function (n) {
          return new es(n);
        } : Da,
        Os = os ? function (n) {
          return os.get(n);
        } : Da,
        Is = Pl ? function (n) {
          return null == n ? [] : (n = ll(n), i(Pl(n), function (t) {
            return Wl.call(n, t);
          }));
        } : Pa,
        Rs = Pl ? function (n) {
          for (var t = []; n;) {
            a(t, Is(n)), n = El(n);
          }
          return t;
        } : Pa,
        zs = we;
      (ns && zs(new ns(new ArrayBuffer(1))) != ct || ts && zs(new ts()) != Gn || rs && zs(rs.resolve()) != Qn || es && zs(new es()) != tt || us && zs(new us()) != it) && (zs = function zs(n) {
        var t = we(n),
          r = t == Yn ? n.constructor : X,
          e = r ? to(r) : "";
        if (e) switch (e) {
          case cs:
            return ct;
          case as:
            return Gn;
          case ls:
            return Qn;
          case ss:
            return tt;
          case hs:
            return it;
        }
        return t;
      });
      var Es = yl ? uc : qa,
        Ss = Qi(ms),
        Ws = Ml || function (n, t) {
          return re.setTimeout(n, t);
        },
        Ls = Qi(xs),
        Cs = Pi(function (n) {
          var t = [];
          return 46 === n.charCodeAt(0) && t.push(""), n.replace(Et, function (n, r, e, u) {
            t.push(e ? u.replace(Mt, "$1") : r || n);
          }), t;
        }),
        Us = uu(function (n, t) {
          return Jf(n) ? Hr(n, ee(t, 1, Jf, !0)) : [];
        }),
        Bs = uu(function (n, t) {
          var r = jo(t);
          return Jf(r) && (r = X), Jf(n) ? Hr(n, ee(t, 1, Jf, !0), mi(r, 2)) : [];
        }),
        Ts = uu(function (n, t) {
          var r = jo(t);
          return Jf(r) && (r = X), Jf(n) ? Hr(n, ee(t, 1, Jf, !0), X, r) : [];
        }),
        $s = uu(function (n) {
          var t = c(n, ju);
          return t.length && t[0] === n[0] ? ke(t) : [];
        }),
        Ds = uu(function (n) {
          var t = jo(n),
            r = c(n, ju);
          return t === jo(r) ? t = X : r.pop(), r.length && r[0] === n[0] ? ke(r, mi(t, 2)) : [];
        }),
        Ms = uu(function (n) {
          var t = jo(n),
            r = c(n, ju);
          return t = "function" == typeof t ? t : X, t && r.pop(), r.length && r[0] === n[0] ? ke(r, X, t) : [];
        }),
        Fs = uu(Oo),
        Ns = gi(function (n, t) {
          var r = null == n ? 0 : n.length,
            e = Tr(n, t);
          return nu(n, c(t, function (n) {
            return Ci(n, r) ? +n : n;
          }).sort(Lu)), e;
        }),
        Ps = uu(function (n) {
          return gu(ee(n, 1, Jf, !0));
        }),
        qs = uu(function (n) {
          var t = jo(n);
          return Jf(t) && (t = X), gu(ee(n, 1, Jf, !0), mi(t, 2));
        }),
        Zs = uu(function (n) {
          var t = jo(n);
          return t = "function" == typeof t ? t : X, gu(ee(n, 1, Jf, !0), X, t);
        }),
        Ks = uu(function (n, t) {
          return Jf(n) ? Hr(n, t) : [];
        }),
        Vs = uu(function (n) {
          return mu(i(n, Jf));
        }),
        Gs = uu(function (n) {
          var t = jo(n);
          return Jf(t) && (t = X), mu(i(n, Jf), mi(t, 2));
        }),
        Hs = uu(function (n) {
          var t = jo(n);
          return t = "function" == typeof t ? t : X, mu(i(n, Jf), X, t);
        }),
        Js = uu(Go),
        Ys = uu(function (n) {
          var t = n.length,
            r = t > 1 ? n[t - 1] : X;
          return r = "function" == typeof r ? (n.pop(), r) : X, Ho(n, r);
        }),
        Qs = gi(function (n) {
          var t = n.length,
            r = t ? n[0] : 0,
            e = this.__wrapped__,
            u = function u(t) {
              return Tr(t, n);
            };
          return !(t > 1 || this.__actions__.length) && e instanceof Ct && Ci(r) ? (e = e.slice(r, +r + (t ? 1 : 0)), e.__actions__.push({
            func: nf,
            args: [u],
            thisArg: X
          }), new Y(e, this.__chain__).thru(function (n) {
            return t && !n.length && n.push(X), n;
          })) : this.thru(u);
        }),
        Xs = Fu(function (n, t, r) {
          bl.call(n, r) ? ++n[r] : Br(n, r, 1);
        }),
        nh = Ju(ho),
        th = Ju(po),
        rh = Fu(function (n, t, r) {
          bl.call(n, r) ? n[r].push(t) : Br(n, r, [t]);
        }),
        eh = uu(function (t, r, e) {
          var u = -1,
            i = "function" == typeof r,
            o = Hf(t) ? il(t.length) : [];
          return ys(t, function (t) {
            o[++u] = i ? n(r, t, e) : Ie(t, r, e);
          }), o;
        }),
        uh = Fu(function (n, t, r) {
          Br(n, r, t);
        }),
        ih = Fu(function (n, t, r) {
          n[r ? 0 : 1].push(t);
        }, function () {
          return [[], []];
        }),
        oh = uu(function (n, t) {
          if (null == n) return [];
          var r = t.length;
          return r > 1 && Ui(n, t[0], t[1]) ? t = [] : r > 2 && Ui(t[0], t[1], t[2]) && (t = [t[0]]), He(n, ee(t, 1), []);
        }),
        fh = Dl || function () {
          return re.Date.now();
        },
        ch = uu(function (n, t, r) {
          var e = _n;
          if (r.length) {
            var u = N(r, wi(ch));
            e |= bn;
          }
          return ai(n, e, t, r, u);
        }),
        ah = uu(function (n, t, r) {
          var e = _n | vn;
          if (r.length) {
            var u = N(r, wi(ah));
            e |= bn;
          }
          return ai(t, e, n, r, u);
        }),
        lh = uu(function (n, t) {
          return Gr(n, 1, t);
        }),
        sh = uu(function (n, t, r) {
          return Gr(n, Ic(t) || 0, r);
        });
      Cf.Cache = sr;
      var hh = js(function (t, r) {
          r = 1 == r.length && bh(r[0]) ? c(r[0], z(mi())) : c(ee(r, 1), z(mi()));
          var e = r.length;
          return uu(function (u) {
            for (var i = -1, o = Hl(u.length, e); ++i < o;) {
              u[i] = r[i].call(this, u[i]);
            }
            return n(t, this, u);
          });
        }),
        ph = uu(function (n, t) {
          return ai(n, bn, X, t, N(t, wi(ph)));
        }),
        _h = uu(function (n, t) {
          return ai(n, wn, X, t, N(t, wi(_h)));
        }),
        vh = gi(function (n, t) {
          return ai(n, xn, X, X, X, t);
        }),
        gh = ii(me),
        yh = ii(function (n, t) {
          return n >= t;
        }),
        dh = Re(function () {
          return arguments;
        }()) ? Re : function (n) {
          return cc(n) && bl.call(n, "callee") && !Wl.call(n, "callee");
        },
        bh = il.isArray,
        wh = ce ? z(ce) : ze,
        mh = ql || qa,
        xh = ae ? z(ae) : Ee,
        jh = le ? z(le) : Le,
        Ah = se ? z(se) : Be,
        kh = he ? z(he) : Te,
        Oh = pe ? z(pe) : $e,
        Ih = ii(Ne),
        Rh = ii(function (n, t) {
          return n <= t;
        }),
        zh = Nu(function (n, t) {
          if (Mi(t) || Hf(t)) return $u(t, Pc(t), n), X;
          for (var r in t) {
            bl.call(t, r) && Sr(n, r, t[r]);
          }
        }),
        Eh = Nu(function (n, t) {
          $u(t, qc(t), n);
        }),
        Sh = Nu(function (n, t, r, e) {
          $u(t, qc(t), n, e);
        }),
        Wh = Nu(function (n, t, r, e) {
          $u(t, Pc(t), n, e);
        }),
        Lh = gi(Tr),
        Ch = uu(function (n, t) {
          n = ll(n);
          var r = -1,
            e = t.length,
            u = e > 2 ? t[2] : X;
          for (u && Ui(t[0], t[1], u) && (e = 1); ++r < e;) {
            for (var i = t[r], o = qc(i), f = -1, c = o.length; ++f < c;) {
              var a = o[f],
                l = n[a];
              (l === X || Gf(l, gl[a]) && !bl.call(n, a)) && (n[a] = i[a]);
            }
          }
          return n;
        }),
        Uh = uu(function (t) {
          return t.push(X, si), n(Mh, X, t);
        }),
        Bh = Xu(function (n, t, r) {
          null != t && "function" != typeof t.toString && (t = xl.call(t)), n[t] = r;
        }, Sa(La)),
        Th = Xu(function (n, t, r) {
          null != t && "function" != typeof t.toString && (t = xl.call(t)), bl.call(n, t) ? n[t].push(r) : n[t] = [r];
        }, mi),
        $h = uu(Ie),
        Dh = Nu(function (n, t, r) {
          Ke(n, t, r);
        }),
        Mh = Nu(function (n, t, r, e) {
          Ke(n, t, r, e);
        }),
        Fh = gi(function (n, t) {
          var r = {};
          if (null == n) return r;
          var e = !1;
          t = c(t, function (t) {
            return t = ku(t, n), e || (e = t.length > 1), t;
          }), $u(n, di(n), r), e && (r = Fr(r, an | ln | sn, hi));
          for (var u = t.length; u--;) {
            yu(r, t[u]);
          }
          return r;
        }),
        Nh = gi(function (n, t) {
          return null == n ? {} : Je(n, t);
        }),
        Ph = ci(Pc),
        qh = ci(qc),
        Zh = Vu(function (n, t, r) {
          return t = t.toLowerCase(), n + (r ? fa(t) : t);
        }),
        Kh = Vu(function (n, t, r) {
          return n + (r ? "-" : "") + t.toLowerCase();
        }),
        Vh = Vu(function (n, t, r) {
          return n + (r ? " " : "") + t.toLowerCase();
        }),
        Gh = Ku("toLowerCase"),
        Hh = Vu(function (n, t, r) {
          return n + (r ? "_" : "") + t.toLowerCase();
        }),
        Jh = Vu(function (n, t, r) {
          return n + (r ? " " : "") + Qh(t);
        }),
        Yh = Vu(function (n, t, r) {
          return n + (r ? " " : "") + t.toUpperCase();
        }),
        Qh = Ku("toUpperCase"),
        Xh = uu(function (t, r) {
          try {
            return n(t, X, r);
          } catch (n) {
            return rc(n) ? n : new fl(n);
          }
        }),
        np = gi(function (n, t) {
          return r(t, function (t) {
            t = no(t), Br(n, t, ch(n[t], n));
          }), n;
        }),
        tp = Yu(),
        rp = Yu(!0),
        ep = uu(function (n, t) {
          return function (r) {
            return Ie(r, n, t);
          };
        }),
        up = uu(function (n, t) {
          return function (r) {
            return Ie(n, r, t);
          };
        }),
        ip = ti(c),
        op = ti(u),
        fp = ti(h),
        cp = ui(),
        ap = ui(!0),
        lp = ni(function (n, t) {
          return n + t;
        }, 0),
        sp = fi("ceil"),
        hp = ni(function (n, t) {
          return n / t;
        }, 1),
        pp = fi("floor"),
        _p = ni(function (n, t) {
          return n * t;
        }, 1),
        vp = fi("round"),
        gp = ni(function (n, t) {
          return n - t;
        }, 0);
      return Z.after = If, Z.ary = Rf, Z.assign = zh, Z.assignIn = Eh, Z.assignInWith = Sh, Z.assignWith = Wh, Z.at = Lh, Z.before = zf, Z.bind = ch, Z.bindAll = np, Z.bindKey = ah, Z.castArray = Nf, Z.chain = Qo, Z.chunk = uo, Z.compact = io, Z.concat = oo, Z.cond = za, Z.conforms = Ea, Z.constant = Sa, Z.countBy = Xs, Z.create = Sc, Z.curry = Ef, Z.curryRight = Sf, Z.debounce = Wf, Z.defaults = Ch, Z.defaultsDeep = Uh, Z.defer = lh, Z.delay = sh, Z.difference = Us, Z.differenceBy = Bs, Z.differenceWith = Ts, Z.drop = fo, Z.dropRight = co, Z.dropRightWhile = ao, Z.dropWhile = lo, Z.fill = so, Z.filter = lf, Z.flatMap = sf, Z.flatMapDeep = hf, Z.flatMapDepth = pf, Z.flatten = _o, Z.flattenDeep = vo, Z.flattenDepth = go, Z.flip = Lf, Z.flow = tp, Z.flowRight = rp, Z.fromPairs = yo, Z.functions = $c, Z.functionsIn = Dc, Z.groupBy = rh, Z.initial = mo, Z.intersection = $s, Z.intersectionBy = Ds, Z.intersectionWith = Ms, Z.invert = Bh, Z.invertBy = Th, Z.invokeMap = eh, Z.iteratee = Ca, Z.keyBy = uh, Z.keys = Pc, Z.keysIn = qc, Z.map = yf, Z.mapKeys = Zc, Z.mapValues = Kc, Z.matches = Ua, Z.matchesProperty = Ba, Z.memoize = Cf, Z.merge = Dh, Z.mergeWith = Mh, Z.method = ep, Z.methodOf = up, Z.mixin = Ta, Z.negate = Uf, Z.nthArg = Ma, Z.omit = Fh, Z.omitBy = Vc, Z.once = Bf, Z.orderBy = df, Z.over = ip, Z.overArgs = hh, Z.overEvery = op, Z.overSome = fp, Z.partial = ph, Z.partialRight = _h, Z.partition = ih, Z.pick = Nh, Z.pickBy = Gc, Z.property = Fa, Z.propertyOf = Na, Z.pull = Fs, Z.pullAll = Oo, Z.pullAllBy = Io, Z.pullAllWith = Ro, Z.pullAt = Ns, Z.range = cp, Z.rangeRight = ap, Z.rearg = vh, Z.reject = mf, Z.remove = zo, Z.rest = Tf, Z.reverse = Eo, Z.sampleSize = jf, Z.set = Jc, Z.setWith = Yc, Z.shuffle = Af, Z.slice = So, Z.sortBy = oh, Z.sortedUniq = $o, Z.sortedUniqBy = Do, Z.split = da, Z.spread = $f, Z.tail = Mo, Z.take = Fo, Z.takeRight = No, Z.takeRightWhile = Po, Z.takeWhile = qo, Z.tap = Xo, Z.throttle = Df, Z.thru = nf, Z.toArray = jc, Z.toPairs = Ph, Z.toPairsIn = qh, Z.toPath = Ha, Z.toPlainObject = Rc, Z.transform = Qc, Z.unary = Mf, Z.union = Ps, Z.unionBy = qs, Z.unionWith = Zs, Z.uniq = Zo, Z.uniqBy = Ko, Z.uniqWith = Vo, Z.unset = Xc, Z.unzip = Go, Z.unzipWith = Ho, Z.update = na, Z.updateWith = ta, Z.values = ra, Z.valuesIn = ea, Z.without = Ks, Z.words = Ra, Z.wrap = Ff, Z.xor = Vs, Z.xorBy = Gs, Z.xorWith = Hs, Z.zip = Js, Z.zipObject = Jo, Z.zipObjectDeep = Yo, Z.zipWith = Ys, Z.entries = Ph, Z.entriesIn = qh, Z.extend = Eh, Z.extendWith = Sh, Ta(Z, Z), Z.add = lp, Z.attempt = Xh, Z.camelCase = Zh, Z.capitalize = fa, Z.ceil = sp, Z.clamp = ua, Z.clone = Pf, Z.cloneDeep = Zf, Z.cloneDeepWith = Kf, Z.cloneWith = qf, Z.conformsTo = Vf, Z.deburr = ca, Z.defaultTo = Wa, Z.divide = hp, Z.endsWith = aa, Z.eq = Gf, Z.escape = la, Z.escapeRegExp = sa, Z.every = af, Z.find = nh, Z.findIndex = ho, Z.findKey = Wc, Z.findLast = th, Z.findLastIndex = po, Z.findLastKey = Lc, Z.floor = pp, Z.forEach = _f, Z.forEachRight = vf, Z.forIn = Cc, Z.forInRight = Uc, Z.forOwn = Bc, Z.forOwnRight = Tc, Z.get = Mc, Z.gt = gh, Z.gte = yh, Z.has = Fc, Z.hasIn = Nc, Z.head = bo, Z.identity = La, Z.includes = gf, Z.indexOf = wo, Z.inRange = ia, Z.invoke = $h, Z.isArguments = dh, Z.isArray = bh, Z.isArrayBuffer = wh, Z.isArrayLike = Hf, Z.isArrayLikeObject = Jf, Z.isBoolean = Yf, Z.isBuffer = mh, Z.isDate = xh, Z.isElement = Qf, Z.isEmpty = Xf, Z.isEqual = nc, Z.isEqualWith = tc, Z.isError = rc, Z.isFinite = ec, Z.isFunction = uc, Z.isInteger = ic, Z.isLength = oc, Z.isMap = jh, Z.isMatch = ac, Z.isMatchWith = lc, Z.isNaN = sc, Z.isNative = hc, Z.isNil = _c, Z.isNull = pc, Z.isNumber = vc, Z.isObject = fc, Z.isObjectLike = cc, Z.isPlainObject = gc, Z.isRegExp = Ah, Z.isSafeInteger = yc, Z.isSet = kh, Z.isString = dc, Z.isSymbol = bc, Z.isTypedArray = Oh, Z.isUndefined = wc, Z.isWeakMap = mc, Z.isWeakSet = xc, Z.join = xo, Z.kebabCase = Kh, Z.last = jo, Z.lastIndexOf = Ao, Z.lowerCase = Vh, Z.lowerFirst = Gh, Z.lt = Ih, Z.lte = Rh, Z.max = Ya, Z.maxBy = Qa, Z.mean = Xa, Z.meanBy = nl, Z.min = tl, Z.minBy = rl, Z.stubArray = Pa, Z.stubFalse = qa, Z.stubObject = Za, Z.stubString = Ka, Z.stubTrue = Va, Z.multiply = _p, Z.nth = ko, Z.noConflict = $a, Z.noop = Da, Z.now = fh, Z.pad = ha, Z.padEnd = pa, Z.padStart = _a, Z.parseInt = va, Z.random = oa, Z.reduce = bf, Z.reduceRight = wf, Z.repeat = ga, Z.replace = ya, Z.result = Hc, Z.round = vp, Z.runInContext = p, Z.sample = xf, Z.size = kf, Z.snakeCase = Hh, Z.some = Of, Z.sortedIndex = Wo, Z.sortedIndexBy = Lo, Z.sortedIndexOf = Co, Z.sortedLastIndex = Uo, Z.sortedLastIndexBy = Bo, Z.sortedLastIndexOf = To, Z.startCase = Jh, Z.startsWith = ba, Z.subtract = gp, Z.sum = el, Z.sumBy = ul, Z.template = wa, Z.times = Ga, Z.toFinite = Ac, Z.toInteger = kc, Z.toLength = Oc, Z.toLower = ma, Z.toNumber = Ic, Z.toSafeInteger = zc, Z.toString = Ec, Z.toUpper = xa, Z.trim = ja, Z.trimEnd = Aa, Z.trimStart = ka, Z.truncate = Oa, Z.unescape = Ia, Z.uniqueId = Ja, Z.upperCase = Yh, Z.upperFirst = Qh, Z.each = _f, Z.eachRight = vf, Z.first = bo, Ta(Z, function () {
        var n = {};
        return ue(Z, function (t, r) {
          bl.call(Z.prototype, r) || (n[r] = t);
        }), n;
      }(), {
        chain: !1
      }), Z.VERSION = nn, r(["bind", "bindKey", "curry", "curryRight", "partial", "partialRight"], function (n) {
        Z[n].placeholder = Z;
      }), r(["drop", "take"], function (n, t) {
        Ct.prototype[n] = function (r) {
          r = r === X ? 1 : Gl(kc(r), 0);
          var e = this.__filtered__ && !t ? new Ct(this) : this.clone();
          return e.__filtered__ ? e.__takeCount__ = Hl(r, e.__takeCount__) : e.__views__.push({
            size: Hl(r, Un),
            type: n + (e.__dir__ < 0 ? "Right" : "")
          }), e;
        }, Ct.prototype[n + "Right"] = function (t) {
          return this.reverse()[n](t).reverse();
        };
      }), r(["filter", "map", "takeWhile"], function (n, t) {
        var r = t + 1,
          e = r == Rn || r == En;
        Ct.prototype[n] = function (n) {
          var t = this.clone();
          return t.__iteratees__.push({
            iteratee: mi(n, 3),
            type: r
          }), t.__filtered__ = t.__filtered__ || e, t;
        };
      }), r(["head", "last"], function (n, t) {
        var r = "take" + (t ? "Right" : "");
        Ct.prototype[n] = function () {
          return this[r](1).value()[0];
        };
      }), r(["initial", "tail"], function (n, t) {
        var r = "drop" + (t ? "" : "Right");
        Ct.prototype[n] = function () {
          return this.__filtered__ ? new Ct(this) : this[r](1);
        };
      }), Ct.prototype.compact = function () {
        return this.filter(La);
      }, Ct.prototype.find = function (n) {
        return this.filter(n).head();
      }, Ct.prototype.findLast = function (n) {
        return this.reverse().find(n);
      }, Ct.prototype.invokeMap = uu(function (n, t) {
        return "function" == typeof n ? new Ct(this) : this.map(function (r) {
          return Ie(r, n, t);
        });
      }), Ct.prototype.reject = function (n) {
        return this.filter(Uf(mi(n)));
      }, Ct.prototype.slice = function (n, t) {
        n = kc(n);
        var r = this;
        return r.__filtered__ && (n > 0 || t < 0) ? new Ct(r) : (n < 0 ? r = r.takeRight(-n) : n && (r = r.drop(n)), t !== X && (t = kc(t), r = t < 0 ? r.dropRight(-t) : r.take(t - n)), r);
      }, Ct.prototype.takeRightWhile = function (n) {
        return this.reverse().takeWhile(n).reverse();
      }, Ct.prototype.toArray = function () {
        return this.take(Un);
      }, ue(Ct.prototype, function (n, t) {
        var r = /^(?:filter|find|map|reject)|While$/.test(t),
          e = /^(?:head|last)$/.test(t),
          u = Z[e ? "take" + ("last" == t ? "Right" : "") : t],
          i = e || /^find/.test(t);
        u && (Z.prototype[t] = function () {
          var t = this.__wrapped__,
            o = e ? [1] : arguments,
            f = t instanceof Ct,
            c = o[0],
            l = f || bh(t),
            s = function s(n) {
              var t = u.apply(Z, a([n], o));
              return e && h ? t[0] : t;
            };
          l && r && "function" == typeof c && 1 != c.length && (f = l = !1);
          var h = this.__chain__,
            p = !!this.__actions__.length,
            _ = i && !h,
            v = f && !p;
          if (!i && l) {
            t = v ? t : new Ct(this);
            var g = n.apply(t, o);
            return g.__actions__.push({
              func: nf,
              args: [s],
              thisArg: X
            }), new Y(g, h);
          }
          return _ && v ? n.apply(this, o) : (g = this.thru(s), _ ? e ? g.value()[0] : g.value() : g);
        });
      }), r(["pop", "push", "shift", "sort", "splice", "unshift"], function (n) {
        var t = _l[n],
          r = /^(?:push|sort|unshift)$/.test(n) ? "tap" : "thru",
          e = /^(?:pop|shift)$/.test(n);
        Z.prototype[n] = function () {
          var n = arguments;
          if (e && !this.__chain__) {
            var u = this.value();
            return t.apply(bh(u) ? u : [], n);
          }
          return this[r](function (r) {
            return t.apply(bh(r) ? r : [], n);
          });
        };
      }), ue(Ct.prototype, function (n, t) {
        var r = Z[t];
        if (r) {
          var e = r.name + "";
          bl.call(fs, e) || (fs[e] = []), fs[e].push({
            name: t,
            func: r
          });
        }
      }), fs[Qu(X, vn).name] = [{
        name: "wrapper",
        func: X
      }], Ct.prototype.clone = $t, Ct.prototype.reverse = Yt, Ct.prototype.value = Qt, Z.prototype.at = Qs, Z.prototype.chain = tf, Z.prototype.commit = rf, Z.prototype.next = ef, Z.prototype.plant = of, Z.prototype.reverse = ff, Z.prototype.toJSON = Z.prototype.valueOf = Z.prototype.value = cf, Z.prototype.first = Z.prototype.head, Ul && (Z.prototype[Ul] = uf), Z;
    },
    be = de();
   true && "object" == _typeof(__webpack_require__.amdO) && __webpack_require__.amdO ? (re._ = be, !(__WEBPACK_AMD_DEFINE_RESULT__ = (function () {
    return be;
  }).call(exports, __webpack_require__, exports, module),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__))) : ue ? ((ue.exports = be)._ = be, ee._ = be) : re._ = be;
}).call(this);

/***/ }),

/***/ "./public/backend/vendors/js/nice-select.min.js":
/*!******************************************************!*\
  !*** ./public/backend/vendors/js/nice-select.min.js ***!
  \******************************************************/
/***/ (() => {

!function (e) {
  e.fn.niceSelect = function (t) {
    if ("string" == typeof t) return "update" == t ? this.each(function () {
      var t = e(this),
        l = e(this).next(".nice-select"),
        c = l.hasClass("open");
      l.length && (l.remove(), s(t), c && t.next().trigger("click"));
    }) : "destroy" == t ? (this.each(function () {
      var t = e(this),
        s = e(this).next(".nice-select");
      s.length && (s.remove(), t.css("display", ""));
    }), 0 == e(".nice-select").length && e(document).off(".nice_select")) : console.log('Method "' + t + '" does not exist.'), this;
    function s(t) {
      t.after(e("<div></div>").addClass("nice-select").addClass(t.attr("class") || "").addClass(t.attr("disabled") ? "disabled" : "").addClass(t.attr("multiple") ? "has-multiple" : "").attr("tabindex", t.attr("disabled") ? null : "0").html(t.attr("multiple") ? '<span class="multiple-options"></span><div class="nice-select-search-box"><input type="text" class="nice-select-search" placeholder="Search..."/></div><ul class="list"></ul>' : '<span class="current"></span><div class="nice-select-search-box"><input type="text" class="nice-select-search" placeholder="Search..."/></div><ul class="list"></ul>'));
      var s = t.next(),
        l = t.find("option");
      if (t.attr("multiple")) {
        var c = t.find("option:selected"),
          a = "";
        c.each(function () {
          $selected_option = e(this), $selected_text = $selected_option.data("display") || $selected_option.text(), a += '<span class="current">' + $selected_text + "</span>";
        }), $select_placeholder = t.data("placeholder") || t.attr("placeholder"), $select_placeholder = "" == $select_placeholder ? "Select" : $select_placeholder, a = "" == a ? $select_placeholder : a, s.find(".multiple-options").html(a);
      } else {
        c = t.find("option:selected");
        s.find(".current").html(c.data("display") || c.text());
      }
      l.each(function (t) {
        var l = e(this),
          c = l.data("display");
        s.find("ul").append(e("<li></li>").attr("data-value", l.val()).attr("data-display", c || null).addClass("option" + (l.is(":selected") ? " selected" : "") + (l.is(":disabled") ? " disabled" : "")).html(l.text()));
      });
    }
    this.hide(), this.each(function () {
      var t = e(this);
      t.next().hasClass("nice-select") || s(t);
    }), e(document).off(".nice_select"), e(document).on("click.nice_select", ".nice-select", function (t) {
      var s = e(this);
      e(".nice-select").not(s).removeClass("open"), s.toggleClass("open"), s.hasClass("open") ? (s.find(".option"), s.find(".nice-select-search").val(""), s.find(".nice-select-search").focus(), s.find(".focus").removeClass("focus"), s.find(".selected").addClass("focus"), s.find("ul li").show()) : s.focus();
    }), e(document).on("click", ".nice-select-search-box", function (e) {
      return e.stopPropagation(), !1;
    }), e(document).on("keyup.nice-select-search", ".nice-select", function () {
      var t = e(this),
        s = t.find(".nice-select-search").val(),
        l = t.find("ul li");
      if ("" == s) l.show();else if (t.hasClass("open")) {
        s = s.toLowerCase();
        var c = new RegExp(s);
        0 < l.length ? l.each(function () {
          var t = e(this),
            s = t.text().toLowerCase();
          c.test(s) ? t.show() : t.hide();
        }) : l.show();
      }
      t.find(".option"), t.find(".focus").removeClass("focus"), t.find(".selected").addClass("focus");
    }), e(document).on("click.nice_select", function (t) {
      0 === e(t.target).closest(".nice-select").length && e(".nice-select").removeClass("open").find(".option");
    }), e(document).on("click.nice_select", ".nice-select .option:not(.disabled)", function (t) {
      var s = e(this),
        l = s.closest(".nice-select");
      if (l.hasClass("has-multiple")) s.hasClass("selected") ? s.removeClass("selected") : s.addClass("selected"), $selected_html = "", $selected_values = [], l.find(".selected").each(function () {
        $selected_option = e(this);
        var t = $selected_option.data("display") || $selected_option.text();
        $selected_html += '<span class="current">' + t + "</span>", $selected_values.push($selected_option.data("value"));
      }), $select_placeholder = l.prev("select").data("placeholder") || l.prev("select").attr("placeholder"), $select_placeholder = "" == $select_placeholder ? "Select" : $select_placeholder, $selected_html = "" == $selected_html ? $select_placeholder : $selected_html, l.find(".multiple-options").html($selected_html), l.prev("select").val($selected_values).trigger("change");else {
        l.find(".selected").removeClass("selected"), s.addClass("selected");
        var c = s.data("display") || s.text();
        l.find(".current").text(c), l.prev("select").val(s.data("value")).trigger("change");
      }
    }), e(document).on("keydown.nice_select", ".nice-select", function (t) {
      var s = e(this),
        l = e(s.find(".focus") || s.find(".list .option.selected"));
      if (32 == t.keyCode || 13 == t.keyCode) return s.hasClass("open") ? l.trigger("click") : s.trigger("click"), !1;
      if (40 == t.keyCode) {
        if (s.hasClass("open")) {
          var c = l.nextAll(".option:not(.disabled)").first();
          c.length > 0 && (s.find(".focus").removeClass("focus"), c.addClass("focus"));
        } else s.trigger("click");
        return !1;
      }
      if (38 == t.keyCode) {
        if (s.hasClass("open")) {
          var a = l.prevAll(".option:not(.disabled)").first();
          a.length > 0 && (s.find(".focus").removeClass("focus"), a.addClass("focus"));
        } else s.trigger("click");
        return !1;
      }
      if (27 == t.keyCode) s.hasClass("open") && s.trigger("click");else if (9 == t.keyCode && s.hasClass("open")) return !1;
    });
    var l = document.createElement("a").style;
    return l.cssText = "pointer-events:auto", "auto" !== l.pointerEvents && e("html").addClass("no-csspointerevents"), this;
  };
}(jQuery);

/***/ }),

/***/ "./public/backend/vendors/lazyload/lazyload.js":
/*!*****************************************************!*\
  !*** ./public/backend/vendors/lazyload/lazyload.js ***!
  \*****************************************************/
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
/*!
 * Lazy Load - JavaScript plugin for lazy loading images
 *
 * Copyright (c) 2007-2019 Mika Tuupola
 *
 * Licensed under the MIT license:
 *   http://www.opensource.org/licenses/mit-license.php
 *
 * Project home:
 *   https://appelsiini.net/projects/lazyload
 *
 * Version: 2.0.0-rc.2
 *
 */

(function (root, factory) {
  if (( false ? 0 : _typeof(exports)) === "object") {
    module.exports = factory(root);
  } else if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {}
})(typeof __webpack_require__.g !== "undefined" ? __webpack_require__.g : this.window || this.global, function (root) {
  "use strict";

  if (true) {
    root = window;
  }
  var defaults = {
    src: "data-src",
    srcset: "data-srcset",
    selector: ".lazyload",
    root: null,
    rootMargin: "0px",
    threshold: 0
  };

  /**
  * Merge two or more objects. Returns a new object.
  * @private
  * @param {Boolean}  deep     If true, do a deep (or recursive) merge [optional]
  * @param {Object}   objects  The objects to merge together
  * @returns {Object}          Merged values of defaults and options
  */
  var extend = function extend() {
    var extended = {};
    var deep = false;
    var i = 0;
    var length = arguments.length;

    /* Check if a deep merge */
    if (Object.prototype.toString.call(arguments[0]) === "[object Boolean]") {
      deep = arguments[0];
      i++;
    }

    /* Merge the object into the extended object */
    var merge = function merge(obj) {
      for (var prop in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, prop)) {
          /* If deep merge and property is an object, merge properties */
          if (deep && Object.prototype.toString.call(obj[prop]) === "[object Object]") {
            extended[prop] = extend(true, extended[prop], obj[prop]);
          } else {
            extended[prop] = obj[prop];
          }
        }
      }
    };

    /* Loop through each object and conduct a merge */
    for (; i < length; i++) {
      var obj = arguments[i];
      merge(obj);
    }
    return extended;
  };
  function LazyLoad(images, options) {
    this.settings = extend(defaults, options || {});
    this.images = images || document.querySelectorAll(this.settings.selector);
    this.observer = null;
    this.init();
  }
  LazyLoad.prototype = {
    init: function init() {
      /* Without observers load everything and bail out early. */
      if (!root.IntersectionObserver) {
        this.loadImages();
        return;
      }
      var self = this;
      var observerConfig = {
        root: this.settings.root,
        rootMargin: this.settings.rootMargin,
        threshold: [this.settings.threshold]
      };
      this.observer = new IntersectionObserver(function (entries) {
        Array.prototype.forEach.call(entries, function (entry) {
          if (entry.isIntersecting) {
            self.observer.unobserve(entry.target);
            var src = entry.target.getAttribute(self.settings.src);
            var srcset = entry.target.getAttribute(self.settings.srcset);
            if ("img" === entry.target.tagName.toLowerCase()) {
              if (src) {
                entry.target.src = src;
              }
              if (srcset) {
                entry.target.srcset = srcset;
              }
            } else {
              entry.target.style.backgroundImage = "url(" + src + ")";
            }
          }
        });
      }, observerConfig);
      Array.prototype.forEach.call(this.images, function (image) {
        self.observer.observe(image);
      });
    },
    loadAndDestroy: function loadAndDestroy() {
      if (!this.settings) {
        return;
      }
      this.loadImages();
      this.destroy();
    },
    loadImages: function loadImages() {
      if (!this.settings) {
        return;
      }
      var self = this;
      Array.prototype.forEach.call(this.images, function (image) {
        var src = image.getAttribute(self.settings.src);
        var srcset = image.getAttribute(self.settings.srcset);
        if ("img" === image.tagName.toLowerCase()) {
          if (src) {
            image.src = src;
          }
          if (srcset) {
            image.srcset = srcset;
          }
        } else {
          image.style.backgroundImage = "url('" + src + "')";
        }
      });
    },
    destroy: function destroy() {
      if (!this.settings) {
        return;
      }
      this.observer.disconnect();
      this.settings = null;
    }
  };
  root.lazyload = function (images, options) {
    return new LazyLoad(images, options);
  };
  if (root.jQuery) {
    var $ = root.jQuery;
    $.fn.lazyload = function (options) {
      options = options || {};
      options.attribute = options.attribute || "data-src";
      new LazyLoad($.makeArray(this), options);
      return this;
    };
  }
  return LazyLoad;
});

/***/ }),

/***/ "./public/backend/vendors/select2/js/select2.min.js":
/*!**********************************************************!*\
  !*** ./public/backend/vendors/select2/js/select2.min.js ***!
  \**********************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
!function (e) {
   true ? !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (e),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)) : 0;
}(function (e) {
  var t = function () {
      if (e && e.fn && e.fn.select2 && e.fn.select2.amd) var t = e.fn.select2.amd;
      var n, i, o, r;
      return t && t.requirejs || (t ? i = t : t = {}, function (e) {
        var t,
          _r,
          s,
          a,
          l = {},
          c = {},
          u = {},
          d = {},
          p = Object.prototype.hasOwnProperty,
          h = [].slice,
          f = /\.js$/;
        function g(e, t) {
          return p.call(e, t);
        }
        function m(e, t) {
          var n,
            i,
            o,
            r,
            s,
            a,
            l,
            c,
            d,
            p,
            h,
            g = t && t.split("/"),
            m = u.map,
            v = m && m["*"] || {};
          if (e && "." === e.charAt(0)) if (t) {
            for (s = (e = e.split("/")).length - 1, u.nodeIdCompat && f.test(e[s]) && (e[s] = e[s].replace(f, "")), e = g.slice(0, g.length - 1).concat(e), d = 0; d < e.length; d += 1) {
              if ("." === (h = e[d])) e.splice(d, 1), d -= 1;else if (".." === h) {
                if (1 === d && (".." === e[2] || ".." === e[0])) break;
                d > 0 && (e.splice(d - 1, 2), d -= 2);
              }
            }
            e = e.join("/");
          } else 0 === e.indexOf("./") && (e = e.substring(2));
          if ((g || v) && m) {
            for (d = (n = e.split("/")).length; d > 0; d -= 1) {
              if (i = n.slice(0, d).join("/"), g) for (p = g.length; p > 0; p -= 1) {
                if ((o = m[g.slice(0, p).join("/")]) && (o = o[i])) {
                  r = o, a = d;
                  break;
                }
              }
              if (r) break;
              !l && v && v[i] && (l = v[i], c = d);
            }
            !r && l && (r = l, a = c), r && (n.splice(0, a, r), e = n.join("/"));
          }
          return e;
        }
        function v(t, n) {
          return function () {
            var i = h.call(arguments, 0);
            return "string" != typeof i[0] && 1 === i.length && i.push(null), _r.apply(e, i.concat([t, n]));
          };
        }
        function y(e) {
          return function (t) {
            l[e] = t;
          };
        }
        function _(n) {
          if (g(c, n)) {
            var i = c[n];
            delete c[n], d[n] = !0, t.apply(e, i);
          }
          if (!g(l, n) && !g(d, n)) throw new Error("No " + n);
          return l[n];
        }
        function w(e) {
          var t,
            n = e ? e.indexOf("!") : -1;
          return n > -1 && (t = e.substring(0, n), e = e.substring(n + 1, e.length)), [t, e];
        }
        function $(e) {
          return function () {
            return u && u.config && u.config[e] || {};
          };
        }
        s = function s(e, t) {
          var n,
            i = w(e),
            o = i[0];
          return e = i[1], o && (n = _(o = m(o, t))), o ? e = n && n.normalize ? n.normalize(e, function (e) {
            return function (t) {
              return m(t, e);
            };
          }(t)) : m(e, t) : (o = (i = w(e = m(e, t)))[0], e = i[1], o && (n = _(o))), {
            f: o ? o + "!" + e : e,
            n: e,
            pr: o,
            p: n
          };
        }, a = {
          require: function require(e) {
            return v(e);
          },
          exports: function exports(e) {
            var t = l[e];
            return void 0 !== t ? t : l[e] = {};
          },
          module: function module(e) {
            return {
              id: e,
              uri: "",
              exports: l[e],
              config: $(e)
            };
          }
        }, t = function t(_t, n, i, o) {
          var r,
            u,
            p,
            h,
            f,
            m,
            w = [],
            $ = _typeof(i);
          if (o = o || _t, "undefined" === $ || "function" === $) {
            for (n = !n.length && i.length ? ["require", "exports", "module"] : n, f = 0; f < n.length; f += 1) {
              if ("require" === (u = (h = s(n[f], o)).f)) w[f] = a.require(_t);else if ("exports" === u) w[f] = a.exports(_t), m = !0;else if ("module" === u) r = w[f] = a.module(_t);else if (g(l, u) || g(c, u) || g(d, u)) w[f] = _(u);else {
                if (!h.p) throw new Error(_t + " missing " + u);
                h.p.load(h.n, v(o, !0), y(u), {}), w[f] = l[u];
              }
            }
            p = i ? i.apply(l[_t], w) : void 0, _t && (r && r.exports !== e && r.exports !== l[_t] ? l[_t] = r.exports : p === e && m || (l[_t] = p));
          } else _t && (l[_t] = i);
        }, n = i = _r = function r(n, i, o, l, c) {
          if ("string" == typeof n) return a[n] ? a[n](i) : _(s(n, i).f);
          if (!n.splice) {
            if ((u = n).deps && _r(u.deps, u.callback), !i) return;
            i.splice ? (n = i, i = o, o = null) : n = e;
          }
          return i = i || function () {}, "function" == typeof o && (o = l, l = c), l ? t(e, n, i, o) : setTimeout(function () {
            t(e, n, i, o);
          }, 4), _r;
        }, _r.config = function (e) {
          return _r(e);
        }, n._defined = l, (o = function o(e, t, n) {
          if ("string" != typeof e) throw new Error("See almond README: incorrect module build, no module name");
          t.splice || (n = t, t = []), g(l, e) || g(c, e) || (c[e] = [e, t, n]);
        }).amd = {
          jQuery: !0
        };
      }(), t.requirejs = n, t.require = i, t.define = o), t.define("almond", function () {}), t.define("jquery", [], function () {
        var t = e || $;
        return null == t && console && console.error && console.error("Select2: An instance of jQuery or a jQuery-compatible library was not found. Make sure that you are including jQuery before Select2 on your web page."), t;
      }), t.define("select2/utils", ["jquery"], function (e) {
        var t = {};
        function n(e) {
          var t = e.prototype,
            n = [];
          for (var i in t) {
            "function" == typeof t[i] && "constructor" !== i && n.push(i);
          }
          return n;
        }
        t.Extend = function (e, t) {
          var n = {}.hasOwnProperty;
          function i() {
            this.constructor = e;
          }
          for (var o in t) {
            n.call(t, o) && (e[o] = t[o]);
          }
          return i.prototype = t.prototype, e.prototype = new i(), e.__super__ = t.prototype, e;
        }, t.Decorate = function (e, t) {
          var i = n(t),
            o = n(e);
          function r() {
            var n = Array.prototype.unshift,
              i = t.prototype.constructor.length,
              o = e.prototype.constructor;
            i > 0 && (n.call(arguments, e.prototype.constructor), o = t.prototype.constructor), o.apply(this, arguments);
          }
          t.displayName = e.displayName, r.prototype = new function () {
            this.constructor = r;
          }();
          for (var s = 0; s < o.length; s++) {
            var a = o[s];
            r.prototype[a] = e.prototype[a];
          }
          for (var l = function l(e) {
              var n = function n() {};
              (e in r.prototype) && (n = r.prototype[e]);
              var i = t.prototype[e];
              return function () {
                return Array.prototype.unshift.call(arguments, n), i.apply(this, arguments);
              };
            }, c = 0; c < i.length; c++) {
            var u = i[c];
            r.prototype[u] = l(u);
          }
          return r;
        };
        var i = function i() {
          this.listeners = {};
        };
        return i.prototype.on = function (e, t) {
          this.listeners = this.listeners || {}, e in this.listeners ? this.listeners[e].push(t) : this.listeners[e] = [t];
        }, i.prototype.trigger = function (e) {
          var t = Array.prototype.slice,
            n = t.call(arguments, 1);
          this.listeners = this.listeners || {}, null == n && (n = []), 0 === n.length && n.push({}), n[0]._type = e, e in this.listeners && this.invoke(this.listeners[e], t.call(arguments, 1)), "*" in this.listeners && this.invoke(this.listeners["*"], arguments);
        }, i.prototype.invoke = function (e, t) {
          for (var n = 0, i = e.length; n < i; n++) {
            e[n].apply(this, t);
          }
        }, t.Observable = i, t.generateChars = function (e) {
          for (var t = "", n = 0; n < e; n++) {
            t += Math.floor(36 * Math.random()).toString(36);
          }
          return t;
        }, t.bind = function (e, t) {
          return function () {
            e.apply(t, arguments);
          };
        }, t._convertData = function (e) {
          for (var t in e) {
            var n = t.split("-"),
              i = e;
            if (1 !== n.length) {
              for (var o = 0; o < n.length; o++) {
                var r = n[o];
                (r = r.substring(0, 1).toLowerCase() + r.substring(1)) in i || (i[r] = {}), o == n.length - 1 && (i[r] = e[t]), i = i[r];
              }
              delete e[t];
            }
          }
          return e;
        }, t.hasScroll = function (t, n) {
          var i = e(n),
            o = n.style.overflowX,
            r = n.style.overflowY;
          return (o !== r || "hidden" !== r && "visible" !== r) && ("scroll" === o || "scroll" === r || i.innerHeight() < n.scrollHeight || i.innerWidth() < n.scrollWidth);
        }, t.escapeMarkup = function (e) {
          var t = {
            "\\": "&#92;",
            "&": "&amp;",
            "<": "&lt;",
            ">": "&gt;",
            '"': "&quot;",
            "'": "&#39;",
            "/": "&#47;"
          };
          return "string" != typeof e ? e : String(e).replace(/[&<>"'\/\\]/g, function (e) {
            return t[e];
          });
        }, t.appendMany = function (t, n) {
          if ("1.7" === e.fn.jquery.substr(0, 3)) {
            var i = e();
            e.map(n, function (e) {
              i = i.add(e);
            }), n = i;
          }
          t.append(n);
        }, t;
      }), t.define("select2/results", ["jquery", "./utils"], function (e, t) {
        function n(e, t, i) {
          this.$element = e, this.data = i, this.options = t, n.__super__.constructor.call(this);
        }
        return t.Extend(n, t.Observable), n.prototype.render = function () {
          var t = e('<ul class="select2-results__options" role="tree"></ul>');
          return this.options.get("multiple") && t.attr("aria-multiselectable", "true"), this.$results = t, t;
        }, n.prototype.clear = function () {
          this.$results.empty();
        }, n.prototype.displayMessage = function (t) {
          var n = this.options.get("escapeMarkup");
          this.clear(), this.hideLoading();
          var i = e('<li role="treeitem" aria-live="assertive" class="select2-results__option"></li>'),
            o = this.options.get("translations").get(t.message);
          i.append(n(o(t.args))), i[0].className += " select2-results__message", this.$results.append(i);
        }, n.prototype.hideMessages = function () {
          this.$results.find(".select2-results__message").remove();
        }, n.prototype.append = function (e) {
          this.hideLoading();
          var t = [];
          if (null != e.results && 0 !== e.results.length) {
            e.results = this.sort(e.results);
            for (var n = 0; n < e.results.length; n++) {
              var i = e.results[n],
                o = this.option(i);
              t.push(o);
            }
            this.$results.append(t);
          } else 0 === this.$results.children().length && this.trigger("results:message", {
            message: "noResults"
          });
        }, n.prototype.position = function (e, t) {
          t.find(".select2-results").append(e);
        }, n.prototype.sort = function (e) {
          return this.options.get("sorter")(e);
        }, n.prototype.highlightFirstItem = function () {
          var e = this.$results.find(".select2-results__option[aria-selected]"),
            t = e.filter("[aria-selected=true]");
          t.length > 0 ? t.first().trigger("mouseenter") : e.first().trigger("mouseenter"), this.ensureHighlightVisible();
        }, n.prototype.setClasses = function () {
          var t = this;
          this.data.current(function (n) {
            var i = e.map(n, function (e) {
              return e.id.toString();
            });
            t.$results.find(".select2-results__option[aria-selected]").each(function () {
              var t = e(this),
                n = e.data(this, "data"),
                o = "" + n.id;
              null != n.element && n.element.selected || null == n.element && e.inArray(o, i) > -1 ? t.attr("aria-selected", "true") : t.attr("aria-selected", "false");
            });
          });
        }, n.prototype.showLoading = function (e) {
          this.hideLoading();
          var t = {
              disabled: !0,
              loading: !0,
              text: this.options.get("translations").get("searching")(e)
            },
            n = this.option(t);
          n.className += " loading-results", this.$results.prepend(n);
        }, n.prototype.hideLoading = function () {
          this.$results.find(".loading-results").remove();
        }, n.prototype.option = function (t) {
          var n = document.createElement("li");
          n.className = "select2-results__option";
          var i = {
            role: "treeitem",
            "aria-selected": "false"
          };
          for (var o in t.disabled && (delete i["aria-selected"], i["aria-disabled"] = "true"), null == t.id && delete i["aria-selected"], null != t._resultId && (n.id = t._resultId), t.title && (n.title = t.title), t.children && (i.role = "group", i["aria-label"] = t.text, delete i["aria-selected"]), i) {
            var r = i[o];
            n.setAttribute(o, r);
          }
          if (t.children) {
            var s = e(n),
              a = document.createElement("strong");
            a.className = "select2-results__group";
            e(a);
            this.template(t, a);
            for (var l = [], c = 0; c < t.children.length; c++) {
              var u = t.children[c],
                d = this.option(u);
              l.push(d);
            }
            var p = e("<ul></ul>", {
              "class": "select2-results__options select2-results__options--nested"
            });
            p.append(l), s.append(a), s.append(p);
          } else this.template(t, n);
          return e.data(n, "data", t), n;
        }, n.prototype.bind = function (t, n) {
          var i = this,
            o = t.id + "-results";
          this.$results.attr("id", o), t.on("results:all", function (e) {
            i.clear(), i.append(e.data), t.isOpen() && (i.setClasses(), i.highlightFirstItem());
          }), t.on("results:append", function (e) {
            i.append(e.data), t.isOpen() && i.setClasses();
          }), t.on("query", function (e) {
            i.hideMessages(), i.showLoading(e);
          }), t.on("select", function () {
            t.isOpen() && (i.setClasses(), i.highlightFirstItem());
          }), t.on("unselect", function () {
            t.isOpen() && (i.setClasses(), i.highlightFirstItem());
          }), t.on("open", function () {
            i.$results.attr("aria-expanded", "true"), i.$results.attr("aria-hidden", "false"), i.setClasses(), i.ensureHighlightVisible();
          }), t.on("close", function () {
            i.$results.attr("aria-expanded", "false"), i.$results.attr("aria-hidden", "true"), i.$results.removeAttr("aria-activedescendant");
          }), t.on("results:toggle", function () {
            var e = i.getHighlightedResults();
            0 !== e.length && e.trigger("mouseup");
          }), t.on("results:select", function () {
            var e = i.getHighlightedResults();
            if (0 !== e.length) {
              var t = e.data("data");
              "true" == e.attr("aria-selected") ? i.trigger("close", {}) : i.trigger("select", {
                data: t
              });
            }
          }), t.on("results:previous", function () {
            var e = i.getHighlightedResults(),
              t = i.$results.find("[aria-selected]"),
              n = t.index(e);
            if (0 !== n) {
              var o = n - 1;
              0 === e.length && (o = 0);
              var r = t.eq(o);
              r.trigger("mouseenter");
              var s = i.$results.offset().top,
                a = r.offset().top,
                l = i.$results.scrollTop() + (a - s);
              0 === o ? i.$results.scrollTop(0) : a - s < 0 && i.$results.scrollTop(l);
            }
          }), t.on("results:next", function () {
            var e = i.getHighlightedResults(),
              t = i.$results.find("[aria-selected]"),
              n = t.index(e) + 1;
            if (!(n >= t.length)) {
              var o = t.eq(n);
              o.trigger("mouseenter");
              var r = i.$results.offset().top + i.$results.outerHeight(!1),
                s = o.offset().top + o.outerHeight(!1),
                a = i.$results.scrollTop() + s - r;
              0 === n ? i.$results.scrollTop(0) : s > r && i.$results.scrollTop(a);
            }
          }), t.on("results:focus", function (e) {
            e.element.addClass("select2-results__option--highlighted");
          }), t.on("results:message", function (e) {
            i.displayMessage(e);
          }), e.fn.mousewheel && this.$results.on("mousewheel", function (e) {
            var t = i.$results.scrollTop(),
              n = i.$results.get(0).scrollHeight - t + e.deltaY,
              o = e.deltaY > 0 && t - e.deltaY <= 0,
              r = e.deltaY < 0 && n <= i.$results.height();
            o ? (i.$results.scrollTop(0), e.preventDefault(), e.stopPropagation()) : r && (i.$results.scrollTop(i.$results.get(0).scrollHeight - i.$results.height()), e.preventDefault(), e.stopPropagation());
          }), this.$results.on("mouseup", ".select2-results__option[aria-selected]", function (t) {
            var n = e(this),
              o = n.data("data");
            "true" !== n.attr("aria-selected") ? i.trigger("select", {
              originalEvent: t,
              data: o
            }) : i.options.get("multiple") ? i.trigger("unselect", {
              originalEvent: t,
              data: o
            }) : i.trigger("close", {});
          }), this.$results.on("mouseenter", ".select2-results__option[aria-selected]", function (t) {
            var n = e(this).data("data");
            i.getHighlightedResults().removeClass("select2-results__option--highlighted"), i.trigger("results:focus", {
              data: n,
              element: e(this)
            });
          });
        }, n.prototype.getHighlightedResults = function () {
          return this.$results.find(".select2-results__option--highlighted");
        }, n.prototype.destroy = function () {
          this.$results.remove();
        }, n.prototype.ensureHighlightVisible = function () {
          var e = this.getHighlightedResults();
          if (0 !== e.length) {
            var t = this.$results.find("[aria-selected]").index(e),
              n = this.$results.offset().top,
              i = e.offset().top,
              o = this.$results.scrollTop() + (i - n),
              r = i - n;
            o -= 2 * e.outerHeight(!1), t <= 2 ? this.$results.scrollTop(0) : (r > this.$results.outerHeight() || r < 0) && this.$results.scrollTop(o);
          }
        }, n.prototype.template = function (t, n) {
          var i = this.options.get("templateResult"),
            o = this.options.get("escapeMarkup"),
            r = i(t, n);
          null == r ? n.style.display = "none" : "string" == typeof r ? n.innerHTML = o(r) : e(n).append(r);
        }, n;
      }), t.define("select2/keys", [], function () {
        return {
          BACKSPACE: 8,
          TAB: 9,
          ENTER: 13,
          SHIFT: 16,
          CTRL: 17,
          ALT: 18,
          ESC: 27,
          SPACE: 32,
          PAGE_UP: 33,
          PAGE_DOWN: 34,
          END: 35,
          HOME: 36,
          LEFT: 37,
          UP: 38,
          RIGHT: 39,
          DOWN: 40,
          DELETE: 46
        };
      }), t.define("select2/selection/base", ["jquery", "../utils", "../keys"], function (e, t, n) {
        function i(e, t) {
          this.$element = e, this.options = t, i.__super__.constructor.call(this);
        }
        return t.Extend(i, t.Observable), i.prototype.render = function () {
          var t = e('<span class="select2-selection" role="combobox"  aria-haspopup="true" aria-expanded="false"></span>');
          return this._tabindex = 0, null != this.$element.data("old-tabindex") ? this._tabindex = this.$element.data("old-tabindex") : null != this.$element.attr("tabindex") && (this._tabindex = this.$element.attr("tabindex")), t.attr("title", this.$element.attr("title")), t.attr("tabindex", this._tabindex), this.$selection = t, t;
        }, i.prototype.bind = function (e, t) {
          var i = this,
            o = (e.id, e.id + "-results");
          this.container = e, this.$selection.on("focus", function (e) {
            i.trigger("focus", e);
          }), this.$selection.on("blur", function (e) {
            i._handleBlur(e);
          }), this.$selection.on("keydown", function (e) {
            i.trigger("keypress", e), e.which === n.SPACE && e.preventDefault();
          }), e.on("results:focus", function (e) {
            i.$selection.attr("aria-activedescendant", e.data._resultId);
          }), e.on("selection:update", function (e) {
            i.update(e.data);
          }), e.on("open", function () {
            i.$selection.attr("aria-expanded", "true"), i.$selection.attr("aria-owns", o), i._attachCloseHandler(e);
          }), e.on("close", function () {
            i.$selection.attr("aria-expanded", "false"), i.$selection.removeAttr("aria-activedescendant"), i.$selection.removeAttr("aria-owns"), i.$selection.focus(), i._detachCloseHandler(e);
          }), e.on("enable", function () {
            i.$selection.attr("tabindex", i._tabindex);
          }), e.on("disable", function () {
            i.$selection.attr("tabindex", "-1");
          });
        }, i.prototype._handleBlur = function (t) {
          var n = this;
          window.setTimeout(function () {
            document.activeElement == n.$selection[0] || e.contains(n.$selection[0], document.activeElement) || n.trigger("blur", t);
          }, 1);
        }, i.prototype._attachCloseHandler = function (t) {
          e(document.body).on("mousedown.select2." + t.id, function (t) {
            var n = e(t.target).closest(".select2");
            e(".select2.select2-container--open").each(function () {
              var t = e(this);
              this != n[0] && t.data("element").select2("close");
            });
          });
        }, i.prototype._detachCloseHandler = function (t) {
          e(document.body).off("mousedown.select2." + t.id);
        }, i.prototype.position = function (e, t) {
          t.find(".selection").append(e);
        }, i.prototype.destroy = function () {
          this._detachCloseHandler(this.container);
        }, i.prototype.update = function (e) {
          throw new Error("The `update` method must be defined in child classes.");
        }, i;
      }), t.define("select2/selection/single", ["jquery", "./base", "../utils", "../keys"], function (e, t, n, i) {
        function o() {
          o.__super__.constructor.apply(this, arguments);
        }
        return n.Extend(o, t), o.prototype.render = function () {
          var e = o.__super__.render.call(this);
          return e.addClass("select2-selection--single"), e.html('<span class="select2-selection__rendered"></span><span class="select2-selection__arrow" role="presentation"><b role="presentation"></b></span>'), e;
        }, o.prototype.bind = function (e, t) {
          var n = this;
          o.__super__.bind.apply(this, arguments);
          var i = e.id + "-container";
          this.$selection.find(".select2-selection__rendered").attr("id", i), this.$selection.attr("aria-labelledby", i), this.$selection.on("mousedown", function (e) {
            1 === e.which && n.trigger("toggle", {
              originalEvent: e
            });
          }), this.$selection.on("focus", function (e) {}), this.$selection.on("blur", function (e) {}), e.on("focus", function (t) {
            e.isOpen() || n.$selection.focus();
          }), e.on("selection:update", function (e) {
            n.update(e.data);
          });
        }, o.prototype.clear = function () {
          this.$selection.find(".select2-selection__rendered").empty();
        }, o.prototype.display = function (e, t) {
          var n = this.options.get("templateSelection");
          return this.options.get("escapeMarkup")(n(e, t));
        }, o.prototype.selectionContainer = function () {
          return e("<span></span>");
        }, o.prototype.update = function (e) {
          if (0 !== e.length) {
            var t = e[0],
              n = this.$selection.find(".select2-selection__rendered"),
              i = this.display(t, n);
            n.empty().append(i), n.prop("title", t.title || t.text);
          } else this.clear();
        }, o;
      }), t.define("select2/selection/multiple", ["jquery", "./base", "../utils"], function (e, t, n) {
        function i(e, t) {
          i.__super__.constructor.apply(this, arguments);
        }
        return n.Extend(i, t), i.prototype.render = function () {
          var e = i.__super__.render.call(this);
          return e.addClass("select2-selection--multiple"), e.html('<ul class="select2-selection__rendered"></ul>'), e;
        }, i.prototype.bind = function (t, n) {
          var o = this;
          i.__super__.bind.apply(this, arguments), this.$selection.on("click", function (e) {
            o.trigger("toggle", {
              originalEvent: e
            });
          }), this.$selection.on("click", ".select2-selection__choice__remove", function (t) {
            if (!o.options.get("disabled")) {
              var n = e(this).parent().data("data");
              o.trigger("unselect", {
                originalEvent: t,
                data: n
              });
            }
          });
        }, i.prototype.clear = function () {
          this.$selection.find(".select2-selection__rendered").empty();
        }, i.prototype.display = function (e, t) {
          var n = this.options.get("templateSelection");
          return this.options.get("escapeMarkup")(n(e, t));
        }, i.prototype.selectionContainer = function () {
          return e('<li class="select2-selection__choice"><span class="select2-selection__choice__remove" role="presentation">&times;</span></li>');
        }, i.prototype.update = function (e) {
          if (this.clear(), 0 !== e.length) {
            for (var t = [], i = 0; i < e.length; i++) {
              var o = e[i],
                r = this.selectionContainer(),
                s = this.display(o, r);
              r.append(s), r.prop("title", o.title || o.text), r.data("data", o), t.push(r);
            }
            var a = this.$selection.find(".select2-selection__rendered");
            n.appendMany(a, t);
          }
        }, i;
      }), t.define("select2/selection/placeholder", ["../utils"], function (e) {
        function t(e, t, n) {
          this.placeholder = this.normalizePlaceholder(n.get("placeholder")), e.call(this, t, n);
        }
        return t.prototype.normalizePlaceholder = function (e, t) {
          return "string" == typeof t && (t = {
            id: "",
            text: t
          }), t;
        }, t.prototype.createPlaceholder = function (e, t) {
          var n = this.selectionContainer();
          return n.html(this.display(t)), n.addClass("select2-selection__placeholder").removeClass("select2-selection__choice"), n;
        }, t.prototype.update = function (e, t) {
          var n = 1 == t.length && t[0].id != this.placeholder.id;
          if (t.length > 1 || n) return e.call(this, t);
          this.clear();
          var i = this.createPlaceholder(this.placeholder);
          this.$selection.find(".select2-selection__rendered").append(i);
        }, t;
      }), t.define("select2/selection/allowClear", ["jquery", "../keys"], function (e, t) {
        function n() {}
        return n.prototype.bind = function (e, t, n) {
          var i = this;
          e.call(this, t, n), null == this.placeholder && this.options.get("debug") && window.console && console.error && console.error("Select2: The `allowClear` option should be used in combination with the `placeholder` option."), this.$selection.on("mousedown", ".select2-selection__clear", function (e) {
            i._handleClear(e);
          }), t.on("keypress", function (e) {
            i._handleKeyboardClear(e, t);
          });
        }, n.prototype._handleClear = function (e, t) {
          if (!this.options.get("disabled")) {
            var n = this.$selection.find(".select2-selection__clear");
            if (0 !== n.length) {
              t.stopPropagation();
              for (var i = n.data("data"), o = 0; o < i.length; o++) {
                var r = {
                  data: i[o]
                };
                if (this.trigger("unselect", r), r.prevented) return;
              }
              this.$element.val(this.placeholder.id).trigger("change"), this.trigger("toggle", {});
            }
          }
        }, n.prototype._handleKeyboardClear = function (e, n, i) {
          i.isOpen() || n.which != t.DELETE && n.which != t.BACKSPACE || this._handleClear(n);
        }, n.prototype.update = function (t, n) {
          if (t.call(this, n), !(this.$selection.find(".select2-selection__placeholder").length > 0 || 0 === n.length)) {
            var i = e('<span class="select2-selection__clear">&times;</span>');
            i.data("data", n), this.$selection.find(".select2-selection__rendered").prepend(i);
          }
        }, n;
      }), t.define("select2/selection/search", ["jquery", "../utils", "../keys"], function (e, t, n) {
        function i(e, t, n) {
          e.call(this, t, n);
        }
        return i.prototype.render = function (t) {
          var n = e('<li class="select2-search select2-search--inline"><input class="select2-search__field" type="search" tabindex="-1" autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="false" role="textbox" aria-autocomplete="list" /></li>');
          this.$searchContainer = n, this.$search = n.find("input");
          var i = t.call(this);
          return this._transferTabIndex(), i;
        }, i.prototype.bind = function (e, t, i) {
          var o = this;
          e.call(this, t, i), t.on("open", function () {
            o.$search.trigger("focus");
          }), t.on("close", function () {
            o.$search.val(""), o.$search.removeAttr("aria-activedescendant"), o.$search.trigger("focus");
          }), t.on("enable", function () {
            o.$search.prop("disabled", !1), o._transferTabIndex();
          }), t.on("disable", function () {
            o.$search.prop("disabled", !0);
          }), t.on("focus", function (e) {
            o.$search.trigger("focus");
          }), t.on("results:focus", function (e) {
            o.$search.attr("aria-activedescendant", e.id);
          }), this.$selection.on("focusin", ".select2-search--inline", function (e) {
            o.trigger("focus", e);
          }), this.$selection.on("focusout", ".select2-search--inline", function (e) {
            o._handleBlur(e);
          }), this.$selection.on("keydown", ".select2-search--inline", function (e) {
            if (e.stopPropagation(), o.trigger("keypress", e), o._keyUpPrevented = e.isDefaultPrevented(), e.which === n.BACKSPACE && "" === o.$search.val()) {
              var t = o.$searchContainer.prev(".select2-selection__choice");
              if (t.length > 0) {
                var i = t.data("data");
                o.searchRemoveChoice(i), e.preventDefault();
              }
            }
          });
          var r = document.documentMode,
            s = r && r <= 11;
          this.$selection.on("input.searchcheck", ".select2-search--inline", function (e) {
            s ? o.$selection.off("input.search input.searchcheck") : o.$selection.off("keyup.search");
          }), this.$selection.on("keyup.search input.search", ".select2-search--inline", function (e) {
            if (s && "input" === e.type) o.$selection.off("input.search input.searchcheck");else {
              var t = e.which;
              t != n.SHIFT && t != n.CTRL && t != n.ALT && t != n.TAB && o.handleSearch(e);
            }
          });
        }, i.prototype._transferTabIndex = function (e) {
          this.$search.attr("tabindex", this.$selection.attr("tabindex")), this.$selection.attr("tabindex", "-1");
        }, i.prototype.createPlaceholder = function (e, t) {
          this.$search.attr("placeholder", t.text);
        }, i.prototype.update = function (e, t) {
          var n = this.$search[0] == document.activeElement;
          this.$search.attr("placeholder", ""), e.call(this, t), this.$selection.find(".select2-selection__rendered").append(this.$searchContainer), this.resizeSearch(), n && this.$search.focus();
        }, i.prototype.handleSearch = function () {
          if (this.resizeSearch(), !this._keyUpPrevented) {
            var e = this.$search.val();
            this.trigger("query", {
              term: e
            });
          }
          this._keyUpPrevented = !1;
        }, i.prototype.searchRemoveChoice = function (e, t) {
          this.trigger("unselect", {
            data: t
          }), this.$search.val(t.text), this.handleSearch();
        }, i.prototype.resizeSearch = function () {
          this.$search.css("width", "25px");
          var e = "";
          "" !== this.$search.attr("placeholder") ? e = this.$selection.find(".select2-selection__rendered").innerWidth() : e = .75 * (this.$search.val().length + 1) + "em";
          this.$search.css("width", e);
        }, i;
      }), t.define("select2/selection/eventRelay", ["jquery"], function (e) {
        function t() {}
        return t.prototype.bind = function (t, n, i) {
          var o = this,
            r = ["open", "opening", "close", "closing", "select", "selecting", "unselect", "unselecting"],
            s = ["opening", "closing", "selecting", "unselecting"];
          t.call(this, n, i), n.on("*", function (t, n) {
            if (-1 !== e.inArray(t, r)) {
              n = n || {};
              var i = e.Event("select2:" + t, {
                params: n
              });
              o.$element.trigger(i), -1 !== e.inArray(t, s) && (n.prevented = i.isDefaultPrevented());
            }
          });
        }, t;
      }), t.define("select2/translation", ["jquery", "require"], function (e, t) {
        function n(e) {
          this.dict = e || {};
        }
        return n.prototype.all = function () {
          return this.dict;
        }, n.prototype.get = function (e) {
          return this.dict[e];
        }, n.prototype.extend = function (t) {
          this.dict = e.extend({}, t.all(), this.dict);
        }, n._cache = {}, n.loadPath = function (e) {
          if (!(e in n._cache)) {
            var i = t(e);
            n._cache[e] = i;
          }
          return new n(n._cache[e]);
        }, n;
      }), t.define("select2/diacritics", [], function () {
        return {
          "Ⓐ": "A",
          "Ａ": "A",
          "À": "A",
          "Á": "A",
          "Â": "A",
          "Ầ": "A",
          "Ấ": "A",
          "Ẫ": "A",
          "Ẩ": "A",
          "Ã": "A",
          "Ā": "A",
          "Ă": "A",
          "Ằ": "A",
          "Ắ": "A",
          "Ẵ": "A",
          "Ẳ": "A",
          "Ȧ": "A",
          "Ǡ": "A",
          "Ä": "A",
          "Ǟ": "A",
          "Ả": "A",
          "Å": "A",
          "Ǻ": "A",
          "Ǎ": "A",
          "Ȁ": "A",
          "Ȃ": "A",
          "Ạ": "A",
          "Ậ": "A",
          "Ặ": "A",
          "Ḁ": "A",
          "Ą": "A",
          "Ⱥ": "A",
          "Ɐ": "A",
          "Ꜳ": "AA",
          "Æ": "AE",
          "Ǽ": "AE",
          "Ǣ": "AE",
          "Ꜵ": "AO",
          "Ꜷ": "AU",
          "Ꜹ": "AV",
          "Ꜻ": "AV",
          "Ꜽ": "AY",
          "Ⓑ": "B",
          "Ｂ": "B",
          "Ḃ": "B",
          "Ḅ": "B",
          "Ḇ": "B",
          "Ƀ": "B",
          "Ƃ": "B",
          "Ɓ": "B",
          "Ⓒ": "C",
          "Ｃ": "C",
          "Ć": "C",
          "Ĉ": "C",
          "Ċ": "C",
          "Č": "C",
          "Ç": "C",
          "Ḉ": "C",
          "Ƈ": "C",
          "Ȼ": "C",
          "Ꜿ": "C",
          "Ⓓ": "D",
          "Ｄ": "D",
          "Ḋ": "D",
          "Ď": "D",
          "Ḍ": "D",
          "Ḑ": "D",
          "Ḓ": "D",
          "Ḏ": "D",
          "Đ": "D",
          "Ƌ": "D",
          "Ɗ": "D",
          "Ɖ": "D",
          "Ꝺ": "D",
          "Ǳ": "DZ",
          "Ǆ": "DZ",
          "ǲ": "Dz",
          "ǅ": "Dz",
          "Ⓔ": "E",
          "Ｅ": "E",
          "È": "E",
          "É": "E",
          "Ê": "E",
          "Ề": "E",
          "Ế": "E",
          "Ễ": "E",
          "Ể": "E",
          "Ẽ": "E",
          "Ē": "E",
          "Ḕ": "E",
          "Ḗ": "E",
          "Ĕ": "E",
          "Ė": "E",
          "Ë": "E",
          "Ẻ": "E",
          "Ě": "E",
          "Ȅ": "E",
          "Ȇ": "E",
          "Ẹ": "E",
          "Ệ": "E",
          "Ȩ": "E",
          "Ḝ": "E",
          "Ę": "E",
          "Ḙ": "E",
          "Ḛ": "E",
          "Ɛ": "E",
          "Ǝ": "E",
          "Ⓕ": "F",
          "Ｆ": "F",
          "Ḟ": "F",
          "Ƒ": "F",
          "Ꝼ": "F",
          "Ⓖ": "G",
          "Ｇ": "G",
          "Ǵ": "G",
          "Ĝ": "G",
          "Ḡ": "G",
          "Ğ": "G",
          "Ġ": "G",
          "Ǧ": "G",
          "Ģ": "G",
          "Ǥ": "G",
          "Ɠ": "G",
          "Ꞡ": "G",
          "Ᵹ": "G",
          "Ꝿ": "G",
          "Ⓗ": "H",
          "Ｈ": "H",
          "Ĥ": "H",
          "Ḣ": "H",
          "Ḧ": "H",
          "Ȟ": "H",
          "Ḥ": "H",
          "Ḩ": "H",
          "Ḫ": "H",
          "Ħ": "H",
          "Ⱨ": "H",
          "Ⱶ": "H",
          "Ɥ": "H",
          "Ⓘ": "I",
          "Ｉ": "I",
          "Ì": "I",
          "Í": "I",
          "Î": "I",
          "Ĩ": "I",
          "Ī": "I",
          "Ĭ": "I",
          "İ": "I",
          "Ï": "I",
          "Ḯ": "I",
          "Ỉ": "I",
          "Ǐ": "I",
          "Ȉ": "I",
          "Ȋ": "I",
          "Ị": "I",
          "Į": "I",
          "Ḭ": "I",
          "Ɨ": "I",
          "Ⓙ": "J",
          "Ｊ": "J",
          "Ĵ": "J",
          "Ɉ": "J",
          "Ⓚ": "K",
          "Ｋ": "K",
          "Ḱ": "K",
          "Ǩ": "K",
          "Ḳ": "K",
          "Ķ": "K",
          "Ḵ": "K",
          "Ƙ": "K",
          "Ⱪ": "K",
          "Ꝁ": "K",
          "Ꝃ": "K",
          "Ꝅ": "K",
          "Ꞣ": "K",
          "Ⓛ": "L",
          "Ｌ": "L",
          "Ŀ": "L",
          "Ĺ": "L",
          "Ľ": "L",
          "Ḷ": "L",
          "Ḹ": "L",
          "Ļ": "L",
          "Ḽ": "L",
          "Ḻ": "L",
          "Ł": "L",
          "Ƚ": "L",
          "Ɫ": "L",
          "Ⱡ": "L",
          "Ꝉ": "L",
          "Ꝇ": "L",
          "Ꞁ": "L",
          "Ǉ": "LJ",
          "ǈ": "Lj",
          "Ⓜ": "M",
          "Ｍ": "M",
          "Ḿ": "M",
          "Ṁ": "M",
          "Ṃ": "M",
          "Ɱ": "M",
          "Ɯ": "M",
          "Ⓝ": "N",
          "Ｎ": "N",
          "Ǹ": "N",
          "Ń": "N",
          "Ñ": "N",
          "Ṅ": "N",
          "Ň": "N",
          "Ṇ": "N",
          "Ņ": "N",
          "Ṋ": "N",
          "Ṉ": "N",
          "Ƞ": "N",
          "Ɲ": "N",
          "Ꞑ": "N",
          "Ꞥ": "N",
          "Ǌ": "NJ",
          "ǋ": "Nj",
          "Ⓞ": "O",
          "Ｏ": "O",
          "Ò": "O",
          "Ó": "O",
          "Ô": "O",
          "Ồ": "O",
          "Ố": "O",
          "Ỗ": "O",
          "Ổ": "O",
          "Õ": "O",
          "Ṍ": "O",
          "Ȭ": "O",
          "Ṏ": "O",
          "Ō": "O",
          "Ṑ": "O",
          "Ṓ": "O",
          "Ŏ": "O",
          "Ȯ": "O",
          "Ȱ": "O",
          "Ö": "O",
          "Ȫ": "O",
          "Ỏ": "O",
          "Ő": "O",
          "Ǒ": "O",
          "Ȍ": "O",
          "Ȏ": "O",
          "Ơ": "O",
          "Ờ": "O",
          "Ớ": "O",
          "Ỡ": "O",
          "Ở": "O",
          "Ợ": "O",
          "Ọ": "O",
          "Ộ": "O",
          "Ǫ": "O",
          "Ǭ": "O",
          "Ø": "O",
          "Ǿ": "O",
          "Ɔ": "O",
          "Ɵ": "O",
          "Ꝋ": "O",
          "Ꝍ": "O",
          "Ƣ": "OI",
          "Ꝏ": "OO",
          "Ȣ": "OU",
          "Ⓟ": "P",
          "Ｐ": "P",
          "Ṕ": "P",
          "Ṗ": "P",
          "Ƥ": "P",
          "Ᵽ": "P",
          "Ꝑ": "P",
          "Ꝓ": "P",
          "Ꝕ": "P",
          "Ⓠ": "Q",
          "Ｑ": "Q",
          "Ꝗ": "Q",
          "Ꝙ": "Q",
          "Ɋ": "Q",
          "Ⓡ": "R",
          "Ｒ": "R",
          "Ŕ": "R",
          "Ṙ": "R",
          "Ř": "R",
          "Ȑ": "R",
          "Ȓ": "R",
          "Ṛ": "R",
          "Ṝ": "R",
          "Ŗ": "R",
          "Ṟ": "R",
          "Ɍ": "R",
          "Ɽ": "R",
          "Ꝛ": "R",
          "Ꞧ": "R",
          "Ꞃ": "R",
          "Ⓢ": "S",
          "Ｓ": "S",
          "ẞ": "S",
          "Ś": "S",
          "Ṥ": "S",
          "Ŝ": "S",
          "Ṡ": "S",
          "Š": "S",
          "Ṧ": "S",
          "Ṣ": "S",
          "Ṩ": "S",
          "Ș": "S",
          "Ş": "S",
          "Ȿ": "S",
          "Ꞩ": "S",
          "Ꞅ": "S",
          "Ⓣ": "T",
          "Ｔ": "T",
          "Ṫ": "T",
          "Ť": "T",
          "Ṭ": "T",
          "Ț": "T",
          "Ţ": "T",
          "Ṱ": "T",
          "Ṯ": "T",
          "Ŧ": "T",
          "Ƭ": "T",
          "Ʈ": "T",
          "Ⱦ": "T",
          "Ꞇ": "T",
          "Ꜩ": "TZ",
          "Ⓤ": "U",
          "Ｕ": "U",
          "Ù": "U",
          "Ú": "U",
          "Û": "U",
          "Ũ": "U",
          "Ṹ": "U",
          "Ū": "U",
          "Ṻ": "U",
          "Ŭ": "U",
          "Ü": "U",
          "Ǜ": "U",
          "Ǘ": "U",
          "Ǖ": "U",
          "Ǚ": "U",
          "Ủ": "U",
          "Ů": "U",
          "Ű": "U",
          "Ǔ": "U",
          "Ȕ": "U",
          "Ȗ": "U",
          "Ư": "U",
          "Ừ": "U",
          "Ứ": "U",
          "Ữ": "U",
          "Ử": "U",
          "Ự": "U",
          "Ụ": "U",
          "Ṳ": "U",
          "Ų": "U",
          "Ṷ": "U",
          "Ṵ": "U",
          "Ʉ": "U",
          "Ⓥ": "V",
          "Ｖ": "V",
          "Ṽ": "V",
          "Ṿ": "V",
          "Ʋ": "V",
          "Ꝟ": "V",
          "Ʌ": "V",
          "Ꝡ": "VY",
          "Ⓦ": "W",
          "Ｗ": "W",
          "Ẁ": "W",
          "Ẃ": "W",
          "Ŵ": "W",
          "Ẇ": "W",
          "Ẅ": "W",
          "Ẉ": "W",
          "Ⱳ": "W",
          "Ⓧ": "X",
          "Ｘ": "X",
          "Ẋ": "X",
          "Ẍ": "X",
          "Ⓨ": "Y",
          "Ｙ": "Y",
          "Ỳ": "Y",
          "Ý": "Y",
          "Ŷ": "Y",
          "Ỹ": "Y",
          "Ȳ": "Y",
          "Ẏ": "Y",
          "Ÿ": "Y",
          "Ỷ": "Y",
          "Ỵ": "Y",
          "Ƴ": "Y",
          "Ɏ": "Y",
          "Ỿ": "Y",
          "Ⓩ": "Z",
          "Ｚ": "Z",
          "Ź": "Z",
          "Ẑ": "Z",
          "Ż": "Z",
          "Ž": "Z",
          "Ẓ": "Z",
          "Ẕ": "Z",
          "Ƶ": "Z",
          "Ȥ": "Z",
          "Ɀ": "Z",
          "Ⱬ": "Z",
          "Ꝣ": "Z",
          "ⓐ": "a",
          "ａ": "a",
          "ẚ": "a",
          "à": "a",
          "á": "a",
          "â": "a",
          "ầ": "a",
          "ấ": "a",
          "ẫ": "a",
          "ẩ": "a",
          "ã": "a",
          "ā": "a",
          "ă": "a",
          "ằ": "a",
          "ắ": "a",
          "ẵ": "a",
          "ẳ": "a",
          "ȧ": "a",
          "ǡ": "a",
          "ä": "a",
          "ǟ": "a",
          "ả": "a",
          "å": "a",
          "ǻ": "a",
          "ǎ": "a",
          "ȁ": "a",
          "ȃ": "a",
          "ạ": "a",
          "ậ": "a",
          "ặ": "a",
          "ḁ": "a",
          "ą": "a",
          "ⱥ": "a",
          "ɐ": "a",
          "ꜳ": "aa",
          "æ": "ae",
          "ǽ": "ae",
          "ǣ": "ae",
          "ꜵ": "ao",
          "ꜷ": "au",
          "ꜹ": "av",
          "ꜻ": "av",
          "ꜽ": "ay",
          "ⓑ": "b",
          "ｂ": "b",
          "ḃ": "b",
          "ḅ": "b",
          "ḇ": "b",
          "ƀ": "b",
          "ƃ": "b",
          "ɓ": "b",
          "ⓒ": "c",
          "ｃ": "c",
          "ć": "c",
          "ĉ": "c",
          "ċ": "c",
          "č": "c",
          "ç": "c",
          "ḉ": "c",
          "ƈ": "c",
          "ȼ": "c",
          "ꜿ": "c",
          "ↄ": "c",
          "ⓓ": "d",
          "ｄ": "d",
          "ḋ": "d",
          "ď": "d",
          "ḍ": "d",
          "ḑ": "d",
          "ḓ": "d",
          "ḏ": "d",
          "đ": "d",
          "ƌ": "d",
          "ɖ": "d",
          "ɗ": "d",
          "ꝺ": "d",
          "ǳ": "dz",
          "ǆ": "dz",
          "ⓔ": "e",
          "ｅ": "e",
          "è": "e",
          "é": "e",
          "ê": "e",
          "ề": "e",
          "ế": "e",
          "ễ": "e",
          "ể": "e",
          "ẽ": "e",
          "ē": "e",
          "ḕ": "e",
          "ḗ": "e",
          "ĕ": "e",
          "ė": "e",
          "ë": "e",
          "ẻ": "e",
          "ě": "e",
          "ȅ": "e",
          "ȇ": "e",
          "ẹ": "e",
          "ệ": "e",
          "ȩ": "e",
          "ḝ": "e",
          "ę": "e",
          "ḙ": "e",
          "ḛ": "e",
          "ɇ": "e",
          "ɛ": "e",
          "ǝ": "e",
          "ⓕ": "f",
          "ｆ": "f",
          "ḟ": "f",
          "ƒ": "f",
          "ꝼ": "f",
          "ⓖ": "g",
          "ｇ": "g",
          "ǵ": "g",
          "ĝ": "g",
          "ḡ": "g",
          "ğ": "g",
          "ġ": "g",
          "ǧ": "g",
          "ģ": "g",
          "ǥ": "g",
          "ɠ": "g",
          "ꞡ": "g",
          "ᵹ": "g",
          "ꝿ": "g",
          "ⓗ": "h",
          "ｈ": "h",
          "ĥ": "h",
          "ḣ": "h",
          "ḧ": "h",
          "ȟ": "h",
          "ḥ": "h",
          "ḩ": "h",
          "ḫ": "h",
          "ẖ": "h",
          "ħ": "h",
          "ⱨ": "h",
          "ⱶ": "h",
          "ɥ": "h",
          "ƕ": "hv",
          "ⓘ": "i",
          "ｉ": "i",
          "ì": "i",
          "í": "i",
          "î": "i",
          "ĩ": "i",
          "ī": "i",
          "ĭ": "i",
          "ï": "i",
          "ḯ": "i",
          "ỉ": "i",
          "ǐ": "i",
          "ȉ": "i",
          "ȋ": "i",
          "ị": "i",
          "į": "i",
          "ḭ": "i",
          "ɨ": "i",
          "ı": "i",
          "ⓙ": "j",
          "ｊ": "j",
          "ĵ": "j",
          "ǰ": "j",
          "ɉ": "j",
          "ⓚ": "k",
          "ｋ": "k",
          "ḱ": "k",
          "ǩ": "k",
          "ḳ": "k",
          "ķ": "k",
          "ḵ": "k",
          "ƙ": "k",
          "ⱪ": "k",
          "ꝁ": "k",
          "ꝃ": "k",
          "ꝅ": "k",
          "ꞣ": "k",
          "ⓛ": "l",
          "ｌ": "l",
          "ŀ": "l",
          "ĺ": "l",
          "ľ": "l",
          "ḷ": "l",
          "ḹ": "l",
          "ļ": "l",
          "ḽ": "l",
          "ḻ": "l",
          "ſ": "l",
          "ł": "l",
          "ƚ": "l",
          "ɫ": "l",
          "ⱡ": "l",
          "ꝉ": "l",
          "ꞁ": "l",
          "ꝇ": "l",
          "ǉ": "lj",
          "ⓜ": "m",
          "ｍ": "m",
          "ḿ": "m",
          "ṁ": "m",
          "ṃ": "m",
          "ɱ": "m",
          "ɯ": "m",
          "ⓝ": "n",
          "ｎ": "n",
          "ǹ": "n",
          "ń": "n",
          "ñ": "n",
          "ṅ": "n",
          "ň": "n",
          "ṇ": "n",
          "ņ": "n",
          "ṋ": "n",
          "ṉ": "n",
          "ƞ": "n",
          "ɲ": "n",
          "ŉ": "n",
          "ꞑ": "n",
          "ꞥ": "n",
          "ǌ": "nj",
          "ⓞ": "o",
          "ｏ": "o",
          "ò": "o",
          "ó": "o",
          "ô": "o",
          "ồ": "o",
          "ố": "o",
          "ỗ": "o",
          "ổ": "o",
          "õ": "o",
          "ṍ": "o",
          "ȭ": "o",
          "ṏ": "o",
          "ō": "o",
          "ṑ": "o",
          "ṓ": "o",
          "ŏ": "o",
          "ȯ": "o",
          "ȱ": "o",
          "ö": "o",
          "ȫ": "o",
          "ỏ": "o",
          "ő": "o",
          "ǒ": "o",
          "ȍ": "o",
          "ȏ": "o",
          "ơ": "o",
          "ờ": "o",
          "ớ": "o",
          "ỡ": "o",
          "ở": "o",
          "ợ": "o",
          "ọ": "o",
          "ộ": "o",
          "ǫ": "o",
          "ǭ": "o",
          "ø": "o",
          "ǿ": "o",
          "ɔ": "o",
          "ꝋ": "o",
          "ꝍ": "o",
          "ɵ": "o",
          "ƣ": "oi",
          "ȣ": "ou",
          "ꝏ": "oo",
          "ⓟ": "p",
          "ｐ": "p",
          "ṕ": "p",
          "ṗ": "p",
          "ƥ": "p",
          "ᵽ": "p",
          "ꝑ": "p",
          "ꝓ": "p",
          "ꝕ": "p",
          "ⓠ": "q",
          "ｑ": "q",
          "ɋ": "q",
          "ꝗ": "q",
          "ꝙ": "q",
          "ⓡ": "r",
          "ｒ": "r",
          "ŕ": "r",
          "ṙ": "r",
          "ř": "r",
          "ȑ": "r",
          "ȓ": "r",
          "ṛ": "r",
          "ṝ": "r",
          "ŗ": "r",
          "ṟ": "r",
          "ɍ": "r",
          "ɽ": "r",
          "ꝛ": "r",
          "ꞧ": "r",
          "ꞃ": "r",
          "ⓢ": "s",
          "ｓ": "s",
          "ß": "s",
          "ś": "s",
          "ṥ": "s",
          "ŝ": "s",
          "ṡ": "s",
          "š": "s",
          "ṧ": "s",
          "ṣ": "s",
          "ṩ": "s",
          "ș": "s",
          "ş": "s",
          "ȿ": "s",
          "ꞩ": "s",
          "ꞅ": "s",
          "ẛ": "s",
          "ⓣ": "t",
          "ｔ": "t",
          "ṫ": "t",
          "ẗ": "t",
          "ť": "t",
          "ṭ": "t",
          "ț": "t",
          "ţ": "t",
          "ṱ": "t",
          "ṯ": "t",
          "ŧ": "t",
          "ƭ": "t",
          "ʈ": "t",
          "ⱦ": "t",
          "ꞇ": "t",
          "ꜩ": "tz",
          "ⓤ": "u",
          "ｕ": "u",
          "ù": "u",
          "ú": "u",
          "û": "u",
          "ũ": "u",
          "ṹ": "u",
          "ū": "u",
          "ṻ": "u",
          "ŭ": "u",
          "ü": "u",
          "ǜ": "u",
          "ǘ": "u",
          "ǖ": "u",
          "ǚ": "u",
          "ủ": "u",
          "ů": "u",
          "ű": "u",
          "ǔ": "u",
          "ȕ": "u",
          "ȗ": "u",
          "ư": "u",
          "ừ": "u",
          "ứ": "u",
          "ữ": "u",
          "ử": "u",
          "ự": "u",
          "ụ": "u",
          "ṳ": "u",
          "ų": "u",
          "ṷ": "u",
          "ṵ": "u",
          "ʉ": "u",
          "ⓥ": "v",
          "ｖ": "v",
          "ṽ": "v",
          "ṿ": "v",
          "ʋ": "v",
          "ꝟ": "v",
          "ʌ": "v",
          "ꝡ": "vy",
          "ⓦ": "w",
          "ｗ": "w",
          "ẁ": "w",
          "ẃ": "w",
          "ŵ": "w",
          "ẇ": "w",
          "ẅ": "w",
          "ẘ": "w",
          "ẉ": "w",
          "ⱳ": "w",
          "ⓧ": "x",
          "ｘ": "x",
          "ẋ": "x",
          "ẍ": "x",
          "ⓨ": "y",
          "ｙ": "y",
          "ỳ": "y",
          "ý": "y",
          "ŷ": "y",
          "ỹ": "y",
          "ȳ": "y",
          "ẏ": "y",
          "ÿ": "y",
          "ỷ": "y",
          "ẙ": "y",
          "ỵ": "y",
          "ƴ": "y",
          "ɏ": "y",
          "ỿ": "y",
          "ⓩ": "z",
          "ｚ": "z",
          "ź": "z",
          "ẑ": "z",
          "ż": "z",
          "ž": "z",
          "ẓ": "z",
          "ẕ": "z",
          "ƶ": "z",
          "ȥ": "z",
          "ɀ": "z",
          "ⱬ": "z",
          "ꝣ": "z",
          "Ά": "Α",
          "Έ": "Ε",
          "Ή": "Η",
          "Ί": "Ι",
          "Ϊ": "Ι",
          "Ό": "Ο",
          "Ύ": "Υ",
          "Ϋ": "Υ",
          "Ώ": "Ω",
          "ά": "α",
          "έ": "ε",
          "ή": "η",
          "ί": "ι",
          "ϊ": "ι",
          "ΐ": "ι",
          "ό": "ο",
          "ύ": "υ",
          "ϋ": "υ",
          "ΰ": "υ",
          "ω": "ω",
          "ς": "σ"
        };
      }), t.define("select2/data/base", ["../utils"], function (e) {
        function t(e, n) {
          t.__super__.constructor.call(this);
        }
        return e.Extend(t, e.Observable), t.prototype.current = function (e) {
          throw new Error("The `current` method must be defined in child classes.");
        }, t.prototype.query = function (e, t) {
          throw new Error("The `query` method must be defined in child classes.");
        }, t.prototype.bind = function (e, t) {}, t.prototype.destroy = function () {}, t.prototype.generateResultId = function (t, n) {
          var i = t.id + "-result-";
          return i += e.generateChars(4), null != n.id ? i += "-" + n.id.toString() : i += "-" + e.generateChars(4), i;
        }, t;
      }), t.define("select2/data/select", ["./base", "../utils", "jquery"], function (e, t, n) {
        function i(e, t) {
          this.$element = e, this.options = t, i.__super__.constructor.call(this);
        }
        return t.Extend(i, e), i.prototype.current = function (e) {
          var t = [],
            i = this;
          this.$element.find(":selected").each(function () {
            var e = n(this),
              o = i.item(e);
            t.push(o);
          }), e(t);
        }, i.prototype.select = function (e) {
          var t = this;
          if (e.selected = !0, n(e.element).is("option")) return e.element.selected = !0, void this.$element.trigger("change");
          if (this.$element.prop("multiple")) this.current(function (i) {
            var o = [];
            (e = [e]).push.apply(e, i);
            for (var r = 0; r < e.length; r++) {
              var s = e[r].id;
              -1 === n.inArray(s, o) && o.push(s);
            }
            t.$element.val(o), t.$element.trigger("change");
          });else {
            var i = e.id;
            this.$element.val(i), this.$element.trigger("change");
          }
        }, i.prototype.unselect = function (e) {
          var t = this;
          if (this.$element.prop("multiple")) {
            if (e.selected = !1, n(e.element).is("option")) return e.element.selected = !1, void this.$element.trigger("change");
            this.current(function (i) {
              for (var o = [], r = 0; r < i.length; r++) {
                var s = i[r].id;
                s !== e.id && -1 === n.inArray(s, o) && o.push(s);
              }
              t.$element.val(o), t.$element.trigger("change");
            });
          }
        }, i.prototype.bind = function (e, t) {
          var n = this;
          this.container = e, e.on("select", function (e) {
            n.select(e.data);
          }), e.on("unselect", function (e) {
            n.unselect(e.data);
          });
        }, i.prototype.destroy = function () {
          this.$element.find("*").each(function () {
            n.removeData(this, "data");
          });
        }, i.prototype.query = function (e, t) {
          var i = [],
            o = this;
          this.$element.children().each(function () {
            var t = n(this);
            if (t.is("option") || t.is("optgroup")) {
              var r = o.item(t),
                s = o.matches(e, r);
              null !== s && i.push(s);
            }
          }), t({
            results: i
          });
        }, i.prototype.addOptions = function (e) {
          t.appendMany(this.$element, e);
        }, i.prototype.option = function (e) {
          var t;
          e.children ? (t = document.createElement("optgroup")).label = e.text : void 0 !== (t = document.createElement("option")).textContent ? t.textContent = e.text : t.innerText = e.text, e.id && (t.value = e.id), e.disabled && (t.disabled = !0), e.selected && (t.selected = !0), e.title && (t.title = e.title);
          var i = n(t),
            o = this._normalizeItem(e);
          return o.element = t, n.data(t, "data", o), i;
        }, i.prototype.item = function (e) {
          var t = {};
          if (null != (t = n.data(e[0], "data"))) return t;
          if (e.is("option")) t = {
            id: e.val(),
            text: e.text(),
            disabled: e.prop("disabled"),
            selected: e.prop("selected"),
            title: e.prop("title")
          };else if (e.is("optgroup")) {
            t = {
              text: e.prop("label"),
              children: [],
              title: e.prop("title")
            };
            for (var i = e.children("option"), o = [], r = 0; r < i.length; r++) {
              var s = n(i[r]),
                a = this.item(s);
              o.push(a);
            }
            t.children = o;
          }
          return (t = this._normalizeItem(t)).element = e[0], n.data(e[0], "data", t), t;
        }, i.prototype._normalizeItem = function (e) {
          n.isPlainObject(e) || (e = {
            id: e,
            text: e
          });
          return null != (e = n.extend({}, {
            text: ""
          }, e)).id && (e.id = e.id.toString()), null != e.text && (e.text = e.text.toString()), null == e._resultId && e.id && null != this.container && (e._resultId = this.generateResultId(this.container, e)), n.extend({}, {
            selected: !1,
            disabled: !1
          }, e);
        }, i.prototype.matches = function (e, t) {
          return this.options.get("matcher")(e, t);
        }, i;
      }), t.define("select2/data/array", ["./select", "../utils", "jquery"], function (e, t, n) {
        function i(e, t) {
          var n = t.get("data") || [];
          i.__super__.constructor.call(this, e, t), this.addOptions(this.convertToOptions(n));
        }
        return t.Extend(i, e), i.prototype.select = function (e) {
          var t = this.$element.find("option").filter(function (t, n) {
            return n.value == e.id.toString();
          });
          0 === t.length && (t = this.option(e), this.addOptions(t)), i.__super__.select.call(this, e);
        }, i.prototype.convertToOptions = function (e) {
          var i = this,
            o = this.$element.find("option"),
            r = o.map(function () {
              return i.item(n(this)).id;
            }).get(),
            s = [];
          function a(e) {
            return function () {
              return n(this).val() == e.id;
            };
          }
          for (var l = 0; l < e.length; l++) {
            var c = this._normalizeItem(e[l]);
            if (n.inArray(c.id, r) >= 0) {
              var u = o.filter(a(c)),
                d = this.item(u),
                p = n.extend(!0, {}, c, d),
                h = this.option(p);
              u.replaceWith(h);
            } else {
              var f = this.option(c);
              if (c.children) {
                var g = this.convertToOptions(c.children);
                t.appendMany(f, g);
              }
              s.push(f);
            }
          }
          return s;
        }, i;
      }), t.define("select2/data/ajax", ["./array", "../utils", "jquery"], function (e, t, n) {
        function i(e, t) {
          this.ajaxOptions = this._applyDefaults(t.get("ajax")), null != this.ajaxOptions.processResults && (this.processResults = this.ajaxOptions.processResults), i.__super__.constructor.call(this, e, t);
        }
        return t.Extend(i, e), i.prototype._applyDefaults = function (e) {
          var t = {
            data: function data(e) {
              return n.extend({}, e, {
                q: e.term
              });
            },
            transport: function transport(e, t, i) {
              var o = n.ajax(e);
              return o.then(t), o.fail(i), o;
            }
          };
          return n.extend({}, t, e, !0);
        }, i.prototype.processResults = function (e) {
          return e;
        }, i.prototype.query = function (e, t) {
          var i = this;
          null != this._request && (n.isFunction(this._request.abort) && this._request.abort(), this._request = null);
          var o = n.extend({
            type: "GET"
          }, this.ajaxOptions);
          function r() {
            var r = o.transport(o, function (o) {
              var r = i.processResults(o, e);
              i.options.get("debug") && window.console && console.error && (r && r.results && n.isArray(r.results) || console.error("Select2: The AJAX results did not return an array in the `results` key of the response.")), t(r);
            }, function () {
              r.status && "0" === r.status || i.trigger("results:message", {
                message: "errorLoading"
              });
            });
            i._request = r;
          }
          "function" == typeof o.url && (o.url = o.url.call(this.$element, e)), "function" == typeof o.data && (o.data = o.data.call(this.$element, e)), this.ajaxOptions.delay && null != e.term ? (this._queryTimeout && window.clearTimeout(this._queryTimeout), this._queryTimeout = window.setTimeout(r, this.ajaxOptions.delay)) : r();
        }, i;
      }), t.define("select2/data/tags", ["jquery"], function (e) {
        function t(t, n, i) {
          var o = i.get("tags"),
            r = i.get("createTag");
          void 0 !== r && (this.createTag = r);
          var s = i.get("insertTag");
          if (void 0 !== s && (this.insertTag = s), t.call(this, n, i), e.isArray(o)) for (var a = 0; a < o.length; a++) {
            var l = o[a],
              c = this._normalizeItem(l),
              u = this.option(c);
            this.$element.append(u);
          }
        }
        return t.prototype.query = function (e, t, n) {
          var i = this;
          this._removeOldTags(), null != t.term && null == t.page ? e.call(this, t, function e(o, r) {
            for (var s = o.results, a = 0; a < s.length; a++) {
              var l = s[a],
                c = null != l.children && !e({
                  results: l.children
                }, !0);
              if (l.text === t.term || c) return !r && (o.data = s, void n(o));
            }
            if (r) return !0;
            var u = i.createTag(t);
            if (null != u) {
              var d = i.option(u);
              d.attr("data-select2-tag", !0), i.addOptions([d]), i.insertTag(s, u);
            }
            o.results = s, n(o);
          }) : e.call(this, t, n);
        }, t.prototype.createTag = function (t, n) {
          var i = e.trim(n.term);
          return "" === i ? null : {
            id: i,
            text: i
          };
        }, t.prototype.insertTag = function (e, t, n) {
          t.unshift(n);
        }, t.prototype._removeOldTags = function (t) {
          this._lastTag;
          this.$element.find("option[data-select2-tag]").each(function () {
            this.selected || e(this).remove();
          });
        }, t;
      }), t.define("select2/data/tokenizer", ["jquery"], function (e) {
        function t(e, t, n) {
          var i = n.get("tokenizer");
          void 0 !== i && (this.tokenizer = i), e.call(this, t, n);
        }
        return t.prototype.bind = function (e, t, n) {
          e.call(this, t, n), this.$search = t.dropdown.$search || t.selection.$search || n.find(".select2-search__field");
        }, t.prototype.query = function (t, n, i) {
          var o = this;
          n.term = n.term || "";
          var r = this.tokenizer(n, this.options, function (t) {
            var n = o._normalizeItem(t);
            if (!o.$element.find("option").filter(function () {
              return e(this).val() === n.id;
            }).length) {
              var i = o.option(n);
              i.attr("data-select2-tag", !0), o._removeOldTags(), o.addOptions([i]);
            }
            !function (e) {
              o.trigger("select", {
                data: e
              });
            }(n);
          });
          r.term !== n.term && (this.$search.length && (this.$search.val(r.term), this.$search.focus()), n.term = r.term), t.call(this, n, i);
        }, t.prototype.tokenizer = function (t, n, i, o) {
          for (var r = i.get("tokenSeparators") || [], s = n.term, a = 0, l = this.createTag || function (e) {
              return {
                id: e.term,
                text: e.term
              };
            }; a < s.length;) {
            var c = s[a];
            if (-1 !== e.inArray(c, r)) {
              var u = s.substr(0, a),
                d = l(e.extend({}, n, {
                  term: u
                }));
              null != d ? (o(d), s = s.substr(a + 1) || "", a = 0) : a++;
            } else a++;
          }
          return {
            term: s
          };
        }, t;
      }), t.define("select2/data/minimumInputLength", [], function () {
        function e(e, t, n) {
          this.minimumInputLength = n.get("minimumInputLength"), e.call(this, t, n);
        }
        return e.prototype.query = function (e, t, n) {
          t.term = t.term || "", t.term.length < this.minimumInputLength ? this.trigger("results:message", {
            message: "inputTooShort",
            args: {
              minimum: this.minimumInputLength,
              input: t.term,
              params: t
            }
          }) : e.call(this, t, n);
        }, e;
      }), t.define("select2/data/maximumInputLength", [], function () {
        function e(e, t, n) {
          this.maximumInputLength = n.get("maximumInputLength"), e.call(this, t, n);
        }
        return e.prototype.query = function (e, t, n) {
          t.term = t.term || "", this.maximumInputLength > 0 && t.term.length > this.maximumInputLength ? this.trigger("results:message", {
            message: "inputTooLong",
            args: {
              maximum: this.maximumInputLength,
              input: t.term,
              params: t
            }
          }) : e.call(this, t, n);
        }, e;
      }), t.define("select2/data/maximumSelectionLength", [], function () {
        function e(e, t, n) {
          this.maximumSelectionLength = n.get("maximumSelectionLength"), e.call(this, t, n);
        }
        return e.prototype.query = function (e, t, n) {
          var i = this;
          this.current(function (o) {
            var r = null != o ? o.length : 0;
            i.maximumSelectionLength > 0 && r >= i.maximumSelectionLength ? i.trigger("results:message", {
              message: "maximumSelected",
              args: {
                maximum: i.maximumSelectionLength
              }
            }) : e.call(i, t, n);
          });
        }, e;
      }), t.define("select2/dropdown", ["jquery", "./utils"], function (e, t) {
        function n(e, t) {
          this.$element = e, this.options = t, n.__super__.constructor.call(this);
        }
        return t.Extend(n, t.Observable), n.prototype.render = function () {
          var t = e('<span class="select2-dropdown"><span class="select2-results"></span></span>');
          return t.attr("dir", this.options.get("dir")), this.$dropdown = t, t;
        }, n.prototype.bind = function () {}, n.prototype.position = function (e, t) {}, n.prototype.destroy = function () {
          this.$dropdown.remove();
        }, n;
      }), t.define("select2/dropdown/search", ["jquery", "../utils"], function (e, t) {
        function n() {}
        return n.prototype.render = function (t) {
          var n = t.call(this),
            i = e('<span class="select2-search select2-search--dropdown"><input class="select2-search__field" type="search" tabindex="-1" autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="false" role="textbox" /></span>');
          return this.$searchContainer = i, this.$search = i.find("input"), n.prepend(i), n;
        }, n.prototype.bind = function (t, n, i) {
          var o = this;
          t.call(this, n, i), this.$search.on("keydown", function (e) {
            o.trigger("keypress", e), o._keyUpPrevented = e.isDefaultPrevented();
          }), this.$search.on("input", function (t) {
            e(this).off("keyup");
          }), this.$search.on("keyup input", function (e) {
            o.handleSearch(e);
          }), n.on("open", function () {
            o.$search.attr("tabindex", 0), o.$search.focus(), window.setTimeout(function () {
              o.$search.focus();
            }, 0);
          }), n.on("close", function () {
            o.$search.attr("tabindex", -1), o.$search.val("");
          }), n.on("focus", function () {
            n.isOpen() && o.$search.focus();
          }), n.on("results:all", function (e) {
            null != e.query.term && "" !== e.query.term || (o.showSearch(e) ? o.$searchContainer.removeClass("select2-search--hide") : o.$searchContainer.addClass("select2-search--hide"));
          });
        }, n.prototype.handleSearch = function (e) {
          if (!this._keyUpPrevented) {
            var t = this.$search.val();
            this.trigger("query", {
              term: t
            });
          }
          this._keyUpPrevented = !1;
        }, n.prototype.showSearch = function (e, t) {
          return !0;
        }, n;
      }), t.define("select2/dropdown/hidePlaceholder", [], function () {
        function e(e, t, n, i) {
          this.placeholder = this.normalizePlaceholder(n.get("placeholder")), e.call(this, t, n, i);
        }
        return e.prototype.append = function (e, t) {
          t.results = this.removePlaceholder(t.results), e.call(this, t);
        }, e.prototype.normalizePlaceholder = function (e, t) {
          return "string" == typeof t && (t = {
            id: "",
            text: t
          }), t;
        }, e.prototype.removePlaceholder = function (e, t) {
          for (var n = t.slice(0), i = t.length - 1; i >= 0; i--) {
            var o = t[i];
            this.placeholder.id === o.id && n.splice(i, 1);
          }
          return n;
        }, e;
      }), t.define("select2/dropdown/infiniteScroll", ["jquery"], function (e) {
        function t(e, t, n, i) {
          this.lastParams = {}, e.call(this, t, n, i), this.$loadingMore = this.createLoadingMore(), this.loading = !1;
        }
        return t.prototype.append = function (e, t) {
          this.$loadingMore.remove(), this.loading = !1, e.call(this, t), this.showLoadingMore(t) && this.$results.append(this.$loadingMore);
        }, t.prototype.bind = function (t, n, i) {
          var o = this;
          t.call(this, n, i), n.on("query", function (e) {
            o.lastParams = e, o.loading = !0;
          }), n.on("query:append", function (e) {
            o.lastParams = e, o.loading = !0;
          }), this.$results.on("scroll", function () {
            var t = e.contains(document.documentElement, o.$loadingMore[0]);
            !o.loading && t && o.$results.offset().top + o.$results.outerHeight(!1) + 50 >= o.$loadingMore.offset().top + o.$loadingMore.outerHeight(!1) && o.loadMore();
          });
        }, t.prototype.loadMore = function () {
          this.loading = !0;
          var t = e.extend({}, {
            page: 1
          }, this.lastParams);
          t.page++, this.trigger("query:append", t);
        }, t.prototype.showLoadingMore = function (e, t) {
          return t.pagination && t.pagination.more;
        }, t.prototype.createLoadingMore = function () {
          var t = e('<li class="select2-results__option select2-results__option--load-more"role="treeitem" aria-disabled="true"></li>'),
            n = this.options.get("translations").get("loadingMore");
          return t.html(n(this.lastParams)), t;
        }, t;
      }), t.define("select2/dropdown/attachBody", ["jquery", "../utils"], function (e, t) {
        function n(t, n, i) {
          this.$dropdownParent = i.get("dropdownParent") || e(document.body), t.call(this, n, i);
        }
        return n.prototype.bind = function (e, t, n) {
          var i = this,
            o = !1;
          e.call(this, t, n), t.on("open", function () {
            i._showDropdown(), i._attachPositioningHandler(t), o || (o = !0, t.on("results:all", function () {
              i._positionDropdown(), i._resizeDropdown();
            }), t.on("results:append", function () {
              i._positionDropdown(), i._resizeDropdown();
            }));
          }), t.on("close", function () {
            i._hideDropdown(), i._detachPositioningHandler(t);
          }), this.$dropdownContainer.on("mousedown", function (e) {
            e.stopPropagation();
          });
        }, n.prototype.destroy = function (e) {
          e.call(this), this.$dropdownContainer.remove();
        }, n.prototype.position = function (e, t, n) {
          t.attr("class", n.attr("class")), t.removeClass("select2"), t.addClass("select2-container--open"), t.css({
            position: "absolute",
            top: -999999
          }), this.$container = n;
        }, n.prototype.render = function (t) {
          var n = e("<span></span>"),
            i = t.call(this);
          return n.append(i), this.$dropdownContainer = n, n;
        }, n.prototype._hideDropdown = function (e) {
          this.$dropdownContainer.detach();
        }, n.prototype._attachPositioningHandler = function (n, i) {
          var o = this,
            r = "scroll.select2." + i.id,
            s = "resize.select2." + i.id,
            a = "orientationchange.select2." + i.id,
            l = this.$container.parents().filter(t.hasScroll);
          l.each(function () {
            e(this).data("select2-scroll-position", {
              x: e(this).scrollLeft(),
              y: e(this).scrollTop()
            });
          }), l.on(r, function (t) {
            var n = e(this).data("select2-scroll-position");
            e(this).scrollTop(n.y);
          }), e(window).on(r + " " + s + " " + a, function (e) {
            o._positionDropdown(), o._resizeDropdown();
          });
        }, n.prototype._detachPositioningHandler = function (n, i) {
          var o = "scroll.select2." + i.id,
            r = "resize.select2." + i.id,
            s = "orientationchange.select2." + i.id;
          this.$container.parents().filter(t.hasScroll).off(o), e(window).off(o + " " + r + " " + s);
        }, n.prototype._positionDropdown = function () {
          var t = e(window),
            n = this.$dropdown.hasClass("select2-dropdown--above"),
            i = this.$dropdown.hasClass("select2-dropdown--below"),
            o = null,
            r = this.$container.offset();
          r.bottom = r.top + this.$container.outerHeight(!1);
          var s = {
            height: this.$container.outerHeight(!1)
          };
          s.top = r.top, s.bottom = r.top + s.height;
          var a = this.$dropdown.outerHeight(!1),
            l = t.scrollTop(),
            c = t.scrollTop() + t.height(),
            u = l < r.top - a,
            d = c > r.bottom + a,
            p = {
              left: r.left,
              top: s.bottom
            },
            h = this.$dropdownParent;
          "static" === h.css("position") && (h = h.offsetParent());
          var f = h.offset();
          p.top -= f.top, p.left -= f.left, n || i || (o = "below"), d || !u || n ? !u && d && n && (o = "below") : o = "above", ("above" == o || n && "below" !== o) && (p.top = s.top - f.top - a), null != o && (this.$dropdown.removeClass("select2-dropdown--below select2-dropdown--above").addClass("select2-dropdown--" + o), this.$container.removeClass("select2-container--below select2-container--above").addClass("select2-container--" + o)), this.$dropdownContainer.css(p);
        }, n.prototype._resizeDropdown = function () {
          var e = {
            width: this.$container.outerWidth(!1) + "px"
          };
          this.options.get("dropdownAutoWidth") && (e.minWidth = e.width, e.position = "relative", e.width = "auto"), this.$dropdown.css(e);
        }, n.prototype._showDropdown = function (e) {
          this.$dropdownContainer.appendTo(this.$dropdownParent), this._positionDropdown(), this._resizeDropdown();
        }, n;
      }), t.define("select2/dropdown/minimumResultsForSearch", [], function () {
        function e(e, t, n, i) {
          this.minimumResultsForSearch = n.get("minimumResultsForSearch"), this.minimumResultsForSearch < 0 && (this.minimumResultsForSearch = 1 / 0), e.call(this, t, n, i);
        }
        return e.prototype.showSearch = function (e, t) {
          return !(function e(t) {
            for (var n = 0, i = 0; i < t.length; i++) {
              var o = t[i];
              o.children ? n += e(o.children) : n++;
            }
            return n;
          }(t.data.results) < this.minimumResultsForSearch) && e.call(this, t);
        }, e;
      }), t.define("select2/dropdown/selectOnClose", [], function () {
        function e() {}
        return e.prototype.bind = function (e, t, n) {
          var i = this;
          e.call(this, t, n), t.on("close", function (e) {
            i._handleSelectOnClose(e);
          });
        }, e.prototype._handleSelectOnClose = function (e, t) {
          if (t && null != t.originalSelect2Event) {
            var n = t.originalSelect2Event;
            if ("select" === n._type || "unselect" === n._type) return;
          }
          var i = this.getHighlightedResults();
          if (!(i.length < 1)) {
            var o = i.data("data");
            null != o.element && o.element.selected || null == o.element && o.selected || this.trigger("select", {
              data: o
            });
          }
        }, e;
      }), t.define("select2/dropdown/closeOnSelect", [], function () {
        function e() {}
        return e.prototype.bind = function (e, t, n) {
          var i = this;
          e.call(this, t, n), t.on("select", function (e) {
            i._selectTriggered(e);
          }), t.on("unselect", function (e) {
            i._selectTriggered(e);
          });
        }, e.prototype._selectTriggered = function (e, t) {
          var n = t.originalEvent;
          n && n.ctrlKey || this.trigger("close", {
            originalEvent: n,
            originalSelect2Event: t
          });
        }, e;
      }), t.define("select2/i18n/en", [], function () {
        return {
          errorLoading: function errorLoading() {
            return "The results could not be loaded.";
          },
          inputTooLong: function inputTooLong(e) {
            var t = e.input.length - e.maximum,
              n = "Please delete " + t + " character";
            return 1 != t && (n += "s"), n;
          },
          inputTooShort: function inputTooShort(e) {
            return "Please enter " + (e.minimum - e.input.length) + " or more characters";
          },
          loadingMore: function loadingMore() {
            return "Loading more results…";
          },
          maximumSelected: function maximumSelected(e) {
            var t = "You can only select " + e.maximum + " item";
            return 1 != e.maximum && (t += "s"), t;
          },
          noResults: function noResults() {
            return "No results found";
          },
          searching: function searching() {
            return "Searching…";
          }
        };
      }), t.define("select2/defaults", ["jquery", "require", "./results", "./selection/single", "./selection/multiple", "./selection/placeholder", "./selection/allowClear", "./selection/search", "./selection/eventRelay", "./utils", "./translation", "./diacritics", "./data/select", "./data/array", "./data/ajax", "./data/tags", "./data/tokenizer", "./data/minimumInputLength", "./data/maximumInputLength", "./data/maximumSelectionLength", "./dropdown", "./dropdown/search", "./dropdown/hidePlaceholder", "./dropdown/infiniteScroll", "./dropdown/attachBody", "./dropdown/minimumResultsForSearch", "./dropdown/selectOnClose", "./dropdown/closeOnSelect", "./i18n/en"], function (e, t, n, i, o, r, s, a, l, c, u, d, p, h, f, g, m, v, y, _, w, $, b, x, A, C, S, O, E) {
        function D() {
          this.reset();
        }
        return D.prototype.apply = function (d) {
          if (null == (d = e.extend(!0, {}, this.defaults, d)).dataAdapter) {
            if (null != d.ajax ? d.dataAdapter = f : null != d.data ? d.dataAdapter = h : d.dataAdapter = p, d.minimumInputLength > 0 && (d.dataAdapter = c.Decorate(d.dataAdapter, v)), d.maximumInputLength > 0 && (d.dataAdapter = c.Decorate(d.dataAdapter, y)), d.maximumSelectionLength > 0 && (d.dataAdapter = c.Decorate(d.dataAdapter, _)), d.tags && (d.dataAdapter = c.Decorate(d.dataAdapter, g)), null == d.tokenSeparators && null == d.tokenizer || (d.dataAdapter = c.Decorate(d.dataAdapter, m)), null != d.query) {
              var E = t(d.amdBase + "compat/query");
              d.dataAdapter = c.Decorate(d.dataAdapter, E);
            }
            if (null != d.initSelection) {
              var D = t(d.amdBase + "compat/initSelection");
              d.dataAdapter = c.Decorate(d.dataAdapter, D);
            }
          }
          if (null == d.resultsAdapter && (d.resultsAdapter = n, null != d.ajax && (d.resultsAdapter = c.Decorate(d.resultsAdapter, x)), null != d.placeholder && (d.resultsAdapter = c.Decorate(d.resultsAdapter, b)), d.selectOnClose && (d.resultsAdapter = c.Decorate(d.resultsAdapter, S))), null == d.dropdownAdapter) {
            if (d.multiple) d.dropdownAdapter = w;else {
              var T = c.Decorate(w, $);
              d.dropdownAdapter = T;
            }
            if (0 !== d.minimumResultsForSearch && (d.dropdownAdapter = c.Decorate(d.dropdownAdapter, C)), d.closeOnSelect && (d.dropdownAdapter = c.Decorate(d.dropdownAdapter, O)), null != d.dropdownCssClass || null != d.dropdownCss || null != d.adaptDropdownCssClass) {
              var q = t(d.amdBase + "compat/dropdownCss");
              d.dropdownAdapter = c.Decorate(d.dropdownAdapter, q);
            }
            d.dropdownAdapter = c.Decorate(d.dropdownAdapter, A);
          }
          if (null == d.selectionAdapter) {
            if (d.multiple ? d.selectionAdapter = o : d.selectionAdapter = i, null != d.placeholder && (d.selectionAdapter = c.Decorate(d.selectionAdapter, r)), d.allowClear && (d.selectionAdapter = c.Decorate(d.selectionAdapter, s)), d.multiple && (d.selectionAdapter = c.Decorate(d.selectionAdapter, a)), null != d.containerCssClass || null != d.containerCss || null != d.adaptContainerCssClass) {
              var j = t(d.amdBase + "compat/containerCss");
              d.selectionAdapter = c.Decorate(d.selectionAdapter, j);
            }
            d.selectionAdapter = c.Decorate(d.selectionAdapter, l);
          }
          if ("string" == typeof d.language) if (d.language.indexOf("-") > 0) {
            var L = d.language.split("-")[0];
            d.language = [d.language, L];
          } else d.language = [d.language];
          if (e.isArray(d.language)) {
            var k = new u();
            d.language.push("en");
            for (var P = d.language, I = 0; I < P.length; I++) {
              var M = P[I],
                R = {};
              try {
                R = u.loadPath(M);
              } catch (e) {
                try {
                  M = this.defaults.amdLanguageBase + M, R = u.loadPath(M);
                } catch (e) {
                  d.debug && window.console && console.warn && console.warn('Select2: The language file for "' + M + '" could not be automatically loaded. A fallback will be used instead.');
                  continue;
                }
              }
              k.extend(R);
            }
            d.translations = k;
          } else {
            var z = u.loadPath(this.defaults.amdLanguageBase + "en"),
              H = new u(d.language);
            H.extend(z), d.translations = H;
          }
          return d;
        }, D.prototype.reset = function () {
          function t(e) {
            return e.replace(/[^\u0000-\u007E]/g, function (e) {
              return d[e] || e;
            });
          }
          this.defaults = {
            amdBase: "./",
            amdLanguageBase: "./i18n/",
            closeOnSelect: !0,
            debug: !1,
            dropdownAutoWidth: !1,
            escapeMarkup: c.escapeMarkup,
            language: E,
            matcher: function n(i, o) {
              if ("" === e.trim(i.term)) return o;
              if (o.children && o.children.length > 0) {
                for (var r = e.extend(!0, {}, o), s = o.children.length - 1; s >= 0; s--) {
                  null == n(i, o.children[s]) && r.children.splice(s, 1);
                }
                return r.children.length > 0 ? r : n(i, r);
              }
              var a = t(o.text).toUpperCase(),
                l = t(i.term).toUpperCase();
              return a.indexOf(l) > -1 ? o : null;
            },
            minimumInputLength: 0,
            maximumInputLength: 0,
            maximumSelectionLength: 0,
            minimumResultsForSearch: 0,
            selectOnClose: !1,
            sorter: function sorter(e) {
              return e;
            },
            templateResult: function templateResult(e) {
              return e.text;
            },
            templateSelection: function templateSelection(e) {
              return e.text;
            },
            theme: "default",
            width: "resolve"
          };
        }, D.prototype.set = function (t, n) {
          var i = {};
          i[e.camelCase(t)] = n;
          var o = c._convertData(i);
          e.extend(this.defaults, o);
        }, new D();
      }), t.define("select2/options", ["require", "jquery", "./defaults", "./utils"], function (e, t, n, i) {
        function o(t, o) {
          if (this.options = t, null != o && this.fromElement(o), this.options = n.apply(this.options), o && o.is("input")) {
            var r = e(this.get("amdBase") + "compat/inputData");
            this.options.dataAdapter = i.Decorate(this.options.dataAdapter, r);
          }
        }
        return o.prototype.fromElement = function (e) {
          var n = ["select2"];
          null == this.options.multiple && (this.options.multiple = e.prop("multiple")), null == this.options.disabled && (this.options.disabled = e.prop("disabled")), null == this.options.language && (e.prop("lang") ? this.options.language = e.prop("lang").toLowerCase() : e.closest("[lang]").prop("lang") && (this.options.language = e.closest("[lang]").prop("lang"))), null == this.options.dir && (e.prop("dir") ? this.options.dir = e.prop("dir") : e.closest("[dir]").prop("dir") ? this.options.dir = e.closest("[dir]").prop("dir") : this.options.dir = "ltr"), e.prop("disabled", this.options.disabled), e.prop("multiple", this.options.multiple), e.data("select2Tags") && (this.options.debug && window.console && console.warn && console.warn('Select2: The `data-select2-tags` attribute has been changed to use the `data-data` and `data-tags="true"` attributes and will be removed in future versions of Select2.'), e.data("data", e.data("select2Tags")), e.data("tags", !0)), e.data("ajaxUrl") && (this.options.debug && window.console && console.warn && console.warn("Select2: The `data-ajax-url` attribute has been changed to `data-ajax--url` and support for the old attribute will be removed in future versions of Select2."), e.attr("ajax--url", e.data("ajaxUrl")), e.data("ajax--url", e.data("ajaxUrl")));
          var o = {};
          o = t.fn.jquery && "1." == t.fn.jquery.substr(0, 2) && e[0].dataset ? t.extend(!0, {}, e[0].dataset, e.data()) : e.data();
          var r = t.extend(!0, {}, o);
          for (var s in r = i._convertData(r)) {
            t.inArray(s, n) > -1 || (t.isPlainObject(this.options[s]) ? t.extend(this.options[s], r[s]) : this.options[s] = r[s]);
          }
          return this;
        }, o.prototype.get = function (e) {
          return this.options[e];
        }, o.prototype.set = function (e, t) {
          this.options[e] = t;
        }, o;
      }), t.define("select2/core", ["jquery", "./options", "./utils", "./keys"], function (e, t, n, i) {
        var o = function o(e, n) {
          null != e.data("select2") && e.data("select2").destroy(), this.$element = e, this.id = this._generateId(e), n = n || {}, this.options = new t(n, e), o.__super__.constructor.call(this);
          var i = e.attr("tabindex") || 0;
          e.data("old-tabindex", i), e.attr("tabindex", "-1");
          var r = this.options.get("dataAdapter");
          this.dataAdapter = new r(e, this.options);
          var s = this.render();
          this._placeContainer(s);
          var a = this.options.get("selectionAdapter");
          this.selection = new a(e, this.options), this.$selection = this.selection.render(), this.selection.position(this.$selection, s);
          var l = this.options.get("dropdownAdapter");
          this.dropdown = new l(e, this.options), this.$dropdown = this.dropdown.render(), this.dropdown.position(this.$dropdown, s);
          var c = this.options.get("resultsAdapter");
          this.results = new c(e, this.options, this.dataAdapter), this.$results = this.results.render(), this.results.position(this.$results, this.$dropdown);
          var u = this;
          this._bindAdapters(), this._registerDomEvents(), this._registerDataEvents(), this._registerSelectionEvents(), this._registerDropdownEvents(), this._registerResultsEvents(), this._registerEvents(), this.dataAdapter.current(function (e) {
            u.trigger("selection:update", {
              data: e
            });
          }), e.addClass("select2-hidden-accessible"), e.attr("aria-hidden", "true"), this._syncAttributes(), e.data("select2", this);
        };
        return n.Extend(o, n.Observable), o.prototype._generateId = function (e) {
          return "select2-" + (null != e.attr("id") ? e.attr("id") : null != e.attr("name") ? e.attr("name") + "-" + n.generateChars(2) : n.generateChars(4)).replace(/(:|\.|\[|\]|,)/g, "");
        }, o.prototype._placeContainer = function (e) {
          e.insertAfter(this.$element);
          var t = this._resolveWidth(this.$element, this.options.get("width"));
          null != t && e.css("width", t);
        }, o.prototype._resolveWidth = function (e, t) {
          var n = /^width:(([-+]?([0-9]*\.)?[0-9]+)(px|em|ex|%|in|cm|mm|pt|pc))/i;
          if ("resolve" == t) {
            var i = this._resolveWidth(e, "style");
            return null != i ? i : this._resolveWidth(e, "element");
          }
          if ("element" == t) {
            var o = e.outerWidth(!1);
            return o <= 0 ? "auto" : o + "px";
          }
          if ("style" == t) {
            var r = e.attr("style");
            if ("string" != typeof r) return null;
            for (var s = r.split(";"), a = 0, l = s.length; a < l; a += 1) {
              var c = s[a].replace(/\s/g, "").match(n);
              if (null !== c && c.length >= 1) return c[1];
            }
            return null;
          }
          return t;
        }, o.prototype._bindAdapters = function () {
          this.dataAdapter.bind(this, this.$container), this.selection.bind(this, this.$container), this.dropdown.bind(this, this.$container), this.results.bind(this, this.$container);
        }, o.prototype._registerDomEvents = function () {
          var t = this;
          this.$element.on("change.select2", function () {
            t.dataAdapter.current(function (e) {
              t.trigger("selection:update", {
                data: e
              });
            });
          }), this.$element.on("focus.select2", function (e) {
            t.trigger("focus", e);
          }), this._syncA = n.bind(this._syncAttributes, this), this._syncS = n.bind(this._syncSubtree, this), this.$element[0].attachEvent && this.$element[0].attachEvent("onpropertychange", this._syncA);
          var i = window.MutationObserver || window.WebKitMutationObserver || window.MozMutationObserver;
          null != i ? (this._observer = new i(function (n) {
            e.each(n, t._syncA), e.each(n, t._syncS);
          }), this._observer.observe(this.$element[0], {
            attributes: !0,
            childList: !0,
            subtree: !1
          })) : this.$element[0].addEventListener && (this.$element[0].addEventListener("DOMAttrModified", t._syncA, !1), this.$element[0].addEventListener("DOMNodeInserted", t._syncS, !1), this.$element[0].addEventListener("DOMNodeRemoved", t._syncS, !1));
        }, o.prototype._registerDataEvents = function () {
          var e = this;
          this.dataAdapter.on("*", function (t, n) {
            e.trigger(t, n);
          });
        }, o.prototype._registerSelectionEvents = function () {
          var t = this,
            n = ["toggle", "focus"];
          this.selection.on("toggle", function () {
            t.toggleDropdown();
          }), this.selection.on("focus", function (e) {
            t.focus(e);
          }), this.selection.on("*", function (i, o) {
            -1 === e.inArray(i, n) && t.trigger(i, o);
          });
        }, o.prototype._registerDropdownEvents = function () {
          var e = this;
          this.dropdown.on("*", function (t, n) {
            e.trigger(t, n);
          });
        }, o.prototype._registerResultsEvents = function () {
          var e = this;
          this.results.on("*", function (t, n) {
            e.trigger(t, n);
          });
        }, o.prototype._registerEvents = function () {
          var e = this;
          this.on("open", function () {
            e.$container.addClass("select2-container--open");
          }), this.on("close", function () {
            e.$container.removeClass("select2-container--open");
          }), this.on("enable", function () {
            e.$container.removeClass("select2-container--disabled");
          }), this.on("disable", function () {
            e.$container.addClass("select2-container--disabled");
          }), this.on("blur", function () {
            e.$container.removeClass("select2-container--focus");
          }), this.on("query", function (t) {
            e.isOpen() || e.trigger("open", {}), this.dataAdapter.query(t, function (n) {
              e.trigger("results:all", {
                data: n,
                query: t
              });
            });
          }), this.on("query:append", function (t) {
            this.dataAdapter.query(t, function (n) {
              e.trigger("results:append", {
                data: n,
                query: t
              });
            });
          }), this.on("keypress", function (t) {
            var n = t.which;
            e.isOpen() ? n === i.ESC || n === i.TAB || n === i.UP && t.altKey ? (e.close(), t.preventDefault()) : n === i.ENTER ? (e.trigger("results:select", {}), t.preventDefault()) : n === i.SPACE && t.ctrlKey ? (e.trigger("results:toggle", {}), t.preventDefault()) : n === i.UP ? (e.trigger("results:previous", {}), t.preventDefault()) : n === i.DOWN && (e.trigger("results:next", {}), t.preventDefault()) : (n === i.ENTER || n === i.SPACE || n === i.DOWN && t.altKey) && (e.open(), t.preventDefault());
          });
        }, o.prototype._syncAttributes = function () {
          this.options.set("disabled", this.$element.prop("disabled")), this.options.get("disabled") ? (this.isOpen() && this.close(), this.trigger("disable", {})) : this.trigger("enable", {});
        }, o.prototype._syncSubtree = function (e, t) {
          var n = !1,
            i = this;
          if (!e || !e.target || "OPTION" === e.target.nodeName || "OPTGROUP" === e.target.nodeName) {
            if (t) {
              if (t.addedNodes && t.addedNodes.length > 0) for (var o = 0; o < t.addedNodes.length; o++) {
                t.addedNodes[o].selected && (n = !0);
              } else t.removedNodes && t.removedNodes.length > 0 && (n = !0);
            } else n = !0;
            n && this.dataAdapter.current(function (e) {
              i.trigger("selection:update", {
                data: e
              });
            });
          }
        }, o.prototype.trigger = function (e, t) {
          var n = o.__super__.trigger,
            i = {
              open: "opening",
              close: "closing",
              select: "selecting",
              unselect: "unselecting"
            };
          if (void 0 === t && (t = {}), e in i) {
            var r = i[e],
              s = {
                prevented: !1,
                name: e,
                args: t
              };
            if (n.call(this, r, s), s.prevented) return void (t.prevented = !0);
          }
          n.call(this, e, t);
        }, o.prototype.toggleDropdown = function () {
          this.options.get("disabled") || (this.isOpen() ? this.close() : this.open());
        }, o.prototype.open = function () {
          this.isOpen() || this.trigger("query", {});
        }, o.prototype.close = function () {
          this.isOpen() && this.trigger("close", {});
        }, o.prototype.isOpen = function () {
          return this.$container.hasClass("select2-container--open");
        }, o.prototype.hasFocus = function () {
          return this.$container.hasClass("select2-container--focus");
        }, o.prototype.focus = function (e) {
          this.hasFocus() || (this.$container.addClass("select2-container--focus"), this.trigger("focus", {}));
        }, o.prototype.enable = function (e) {
          this.options.get("debug") && window.console && console.warn && console.warn('Select2: The `select2("enable")` method has been deprecated and will be removed in later Select2 versions. Use $element.prop("disabled") instead.'), null != e && 0 !== e.length || (e = [!0]);
          var t = !e[0];
          this.$element.prop("disabled", t);
        }, o.prototype.data = function () {
          this.options.get("debug") && arguments.length > 0 && window.console && console.warn && console.warn('Select2: Data can no longer be set using `select2("data")`. You should consider setting the value instead using `$element.val()`.');
          var e = [];
          return this.dataAdapter.current(function (t) {
            e = t;
          }), e;
        }, o.prototype.val = function (t) {
          if (this.options.get("debug") && window.console && console.warn && console.warn('Select2: The `select2("val")` method has been deprecated and will be removed in later Select2 versions. Use $element.val() instead.'), null == t || 0 === t.length) return this.$element.val();
          var n = t[0];
          e.isArray(n) && (n = e.map(n, function (e) {
            return e.toString();
          })), this.$element.val(n).trigger("change");
        }, o.prototype.destroy = function () {
          this.$container.remove(), this.$element[0].detachEvent && this.$element[0].detachEvent("onpropertychange", this._syncA), null != this._observer ? (this._observer.disconnect(), this._observer = null) : this.$element[0].removeEventListener && (this.$element[0].removeEventListener("DOMAttrModified", this._syncA, !1), this.$element[0].removeEventListener("DOMNodeInserted", this._syncS, !1), this.$element[0].removeEventListener("DOMNodeRemoved", this._syncS, !1)), this._syncA = null, this._syncS = null, this.$element.off(".select2"), this.$element.attr("tabindex", this.$element.data("old-tabindex")), this.$element.removeClass("select2-hidden-accessible"), this.$element.attr("aria-hidden", "false"), this.$element.removeData("select2"), this.dataAdapter.destroy(), this.selection.destroy(), this.dropdown.destroy(), this.results.destroy(), this.dataAdapter = null, this.selection = null, this.dropdown = null, this.results = null;
        }, o.prototype.render = function () {
          var t = e('<span class="select2 select2-container"><span class="selection"></span><span class="dropdown-wrapper" aria-hidden="true"></span></span>');
          return t.attr("dir", this.options.get("dir")), this.$container = t, this.$container.addClass("select2-container--" + this.options.get("theme")), t.data("element", this.$element), t;
        }, o;
      }), t.define("select2/compat/utils", ["jquery"], function (e) {
        return {
          syncCssClasses: function syncCssClasses(t, n, i) {
            var o,
              r,
              s = [];
            (o = e.trim(t.attr("class"))) && e((o = "" + o).split(/\s+/)).each(function () {
              0 === this.indexOf("select2-") && s.push(this);
            }), (o = e.trim(n.attr("class"))) && e((o = "" + o).split(/\s+/)).each(function () {
              0 !== this.indexOf("select2-") && null != (r = i(this)) && s.push(r);
            }), t.attr("class", s.join(" "));
          }
        };
      }), t.define("select2/compat/containerCss", ["jquery", "./utils"], function (e, t) {
        function n(e) {
          return null;
        }
        function i() {}
        return i.prototype.render = function (i) {
          var o = i.call(this),
            r = this.options.get("containerCssClass") || "";
          e.isFunction(r) && (r = r(this.$element));
          var s = this.options.get("adaptContainerCssClass");
          if (s = s || n, -1 !== r.indexOf(":all:")) {
            r = r.replace(":all:", "");
            var a = s;
            s = function s(e) {
              var t = a(e);
              return null != t ? t + " " + e : e;
            };
          }
          var l = this.options.get("containerCss") || {};
          return e.isFunction(l) && (l = l(this.$element)), t.syncCssClasses(o, this.$element, s), o.css(l), o.addClass(r), o;
        }, i;
      }), t.define("select2/compat/dropdownCss", ["jquery", "./utils"], function (e, t) {
        function n(e) {
          return null;
        }
        function i() {}
        return i.prototype.render = function (i) {
          var o = i.call(this),
            r = this.options.get("dropdownCssClass") || "";
          e.isFunction(r) && (r = r(this.$element));
          var s = this.options.get("adaptDropdownCssClass");
          if (s = s || n, -1 !== r.indexOf(":all:")) {
            r = r.replace(":all:", "");
            var a = s;
            s = function s(e) {
              var t = a(e);
              return null != t ? t + " " + e : e;
            };
          }
          var l = this.options.get("dropdownCss") || {};
          return e.isFunction(l) && (l = l(this.$element)), t.syncCssClasses(o, this.$element, s), o.css(l), o.addClass(r), o;
        }, i;
      }), t.define("select2/compat/initSelection", ["jquery"], function (e) {
        function t(e, t, n) {
          n.get("debug") && window.console && console.warn && console.warn("Select2: The `initSelection` option has been deprecated in favor of a custom data adapter that overrides the `current` method. This method is now called multiple times instead of a single time when the instance is initialized. Support will be removed for the `initSelection` option in future versions of Select2"), this.initSelection = n.get("initSelection"), this._isInitialized = !1, e.call(this, t, n);
        }
        return t.prototype.current = function (t, n) {
          var i = this;
          this._isInitialized ? t.call(this, n) : this.initSelection.call(null, this.$element, function (t) {
            i._isInitialized = !0, e.isArray(t) || (t = [t]), n(t);
          });
        }, t;
      }), t.define("select2/compat/inputData", ["jquery"], function (e) {
        function t(e, t, n) {
          this._currentData = [], this._valueSeparator = n.get("valueSeparator") || ",", "hidden" === t.prop("type") && n.get("debug") && console && console.warn && console.warn("Select2: Using a hidden input with Select2 is no longer supported and may stop working in the future. It is recommended to use a `<select>` element instead."), e.call(this, t, n);
        }
        return t.prototype.current = function (t, n) {
          function i(t, n) {
            var o = [];
            return t.selected || -1 !== e.inArray(t.id, n) ? (t.selected = !0, o.push(t)) : t.selected = !1, t.children && o.push.apply(o, i(t.children, n)), o;
          }
          for (var o = [], r = 0; r < this._currentData.length; r++) {
            var s = this._currentData[r];
            o.push.apply(o, i(s, this.$element.val().split(this._valueSeparator)));
          }
          n(o);
        }, t.prototype.select = function (t, n) {
          if (this.options.get("multiple")) {
            var i = this.$element.val();
            i += this._valueSeparator + n.id, this.$element.val(i), this.$element.trigger("change");
          } else this.current(function (t) {
            e.map(t, function (e) {
              e.selected = !1;
            });
          }), this.$element.val(n.id), this.$element.trigger("change");
        }, t.prototype.unselect = function (e, t) {
          var n = this;
          t.selected = !1, this.current(function (e) {
            for (var i = [], o = 0; o < e.length; o++) {
              var r = e[o];
              t.id != r.id && i.push(r.id);
            }
            n.$element.val(i.join(n._valueSeparator)), n.$element.trigger("change");
          });
        }, t.prototype.query = function (e, t, n) {
          for (var i = [], o = 0; o < this._currentData.length; o++) {
            var r = this._currentData[o],
              s = this.matches(t, r);
            null !== s && i.push(s);
          }
          n({
            results: i
          });
        }, t.prototype.addOptions = function (t, n) {
          var i = e.map(n, function (t) {
            return e.data(t[0], "data");
          });
          this._currentData.push.apply(this._currentData, i);
        }, t;
      }), t.define("select2/compat/matcher", ["jquery"], function (e) {
        return function (t) {
          return function (n, i) {
            var o = e.extend(!0, {}, i);
            if (null == n.term || "" === e.trim(n.term)) return o;
            if (i.children) {
              for (var r = i.children.length - 1; r >= 0; r--) {
                var s = i.children[r];
                t(n.term, s.text, s) || o.children.splice(r, 1);
              }
              if (o.children.length > 0) return o;
            }
            return t(n.term, i.text, i) ? o : null;
          };
        };
      }), t.define("select2/compat/query", [], function () {
        function e(e, t, n) {
          n.get("debug") && window.console && console.warn && console.warn("Select2: The `query` option has been deprecated in favor of a custom data adapter that overrides the `query` method. Support will be removed for the `query` option in future versions of Select2."), e.call(this, t, n);
        }
        return e.prototype.query = function (e, t, n) {
          t.callback = n, this.options.get("query").call(null, t);
        }, e;
      }), t.define("select2/dropdown/attachContainer", [], function () {
        function e(e, t, n) {
          e.call(this, t, n);
        }
        return e.prototype.position = function (e, t, n) {
          n.find(".dropdown-wrapper").append(t), t.addClass("select2-dropdown--below"), n.addClass("select2-container--below");
        }, e;
      }), t.define("select2/dropdown/stopPropagation", [], function () {
        function e() {}
        return e.prototype.bind = function (e, t, n) {
          e.call(this, t, n);
          this.$dropdown.on(["blur", "change", "click", "dblclick", "focus", "focusin", "focusout", "input", "keydown", "keyup", "keypress", "mousedown", "mouseenter", "mouseleave", "mousemove", "mouseover", "mouseup", "search", "touchend", "touchstart"].join(" "), function (e) {
            e.stopPropagation();
          });
        }, e;
      }), t.define("select2/selection/stopPropagation", [], function () {
        function e() {}
        return e.prototype.bind = function (e, t, n) {
          e.call(this, t, n);
          this.$selection.on(["blur", "change", "click", "dblclick", "focus", "focusin", "focusout", "input", "keydown", "keyup", "keypress", "mousedown", "mouseenter", "mouseleave", "mousemove", "mouseover", "mouseup", "search", "touchend", "touchstart"].join(" "), function (e) {
            e.stopPropagation();
          });
        }, e;
      }), r = function r(e) {
        var t,
          n,
          i = ["wheel", "mousewheel", "DOMMouseScroll", "MozMousePixelScroll"],
          o = "onwheel" in document || document.documentMode >= 9 ? ["wheel"] : ["mousewheel", "DomMouseScroll", "MozMousePixelScroll"],
          r = Array.prototype.slice;
        if (e.event.fixHooks) for (var s = i.length; s;) {
          e.event.fixHooks[i[--s]] = e.event.mouseHooks;
        }
        var a = e.event.special.mousewheel = {
          version: "3.1.12",
          setup: function setup() {
            if (this.addEventListener) for (var t = o.length; t;) {
              this.addEventListener(o[--t], l, !1);
            } else this.onmousewheel = l;
            e.data(this, "mousewheel-line-height", a.getLineHeight(this)), e.data(this, "mousewheel-page-height", a.getPageHeight(this));
          },
          teardown: function teardown() {
            if (this.removeEventListener) for (var t = o.length; t;) {
              this.removeEventListener(o[--t], l, !1);
            } else this.onmousewheel = null;
            e.removeData(this, "mousewheel-line-height"), e.removeData(this, "mousewheel-page-height");
          },
          getLineHeight: function getLineHeight(t) {
            var n = e(t),
              i = n["offsetParent" in e.fn ? "offsetParent" : "parent"]();
            return i.length || (i = e("body")), parseInt(i.css("fontSize"), 10) || parseInt(n.css("fontSize"), 10) || 16;
          },
          getPageHeight: function getPageHeight(t) {
            return e(t).height();
          },
          settings: {
            adjustOldDeltas: !0,
            normalizeOffset: !0
          }
        };
        function l(i) {
          var o,
            s = i || window.event,
            l = r.call(arguments, 1),
            d = 0,
            p = 0,
            h = 0,
            f = 0,
            g = 0;
          if ((i = e.event.fix(s)).type = "mousewheel", "detail" in s && (h = -1 * s.detail), "wheelDelta" in s && (h = s.wheelDelta), "wheelDeltaY" in s && (h = s.wheelDeltaY), "wheelDeltaX" in s && (p = -1 * s.wheelDeltaX), "axis" in s && s.axis === s.HORIZONTAL_AXIS && (p = -1 * h, h = 0), d = 0 === h ? p : h, "deltaY" in s && (d = h = -1 * s.deltaY), "deltaX" in s && (p = s.deltaX, 0 === h && (d = -1 * p)), 0 !== h || 0 !== p) {
            if (1 === s.deltaMode) {
              var m = e.data(this, "mousewheel-line-height");
              d *= m, h *= m, p *= m;
            } else if (2 === s.deltaMode) {
              var v = e.data(this, "mousewheel-page-height");
              d *= v, h *= v, p *= v;
            }
            if (o = Math.max(Math.abs(h), Math.abs(p)), (!n || o < n) && (n = o, u(s, o) && (n /= 40)), u(s, o) && (d /= 40, p /= 40, h /= 40), d = Math[d >= 1 ? "floor" : "ceil"](d / n), p = Math[p >= 1 ? "floor" : "ceil"](p / n), h = Math[h >= 1 ? "floor" : "ceil"](h / n), a.settings.normalizeOffset && this.getBoundingClientRect) {
              var y = this.getBoundingClientRect();
              f = i.clientX - y.left, g = i.clientY - y.top;
            }
            return i.deltaX = p, i.deltaY = h, i.deltaFactor = n, i.offsetX = f, i.offsetY = g, i.deltaMode = 0, l.unshift(i, d, p, h), t && clearTimeout(t), t = setTimeout(c, 200), (e.event.dispatch || e.event.handle).apply(this, l);
          }
        }
        function c() {
          n = null;
        }
        function u(e, t) {
          return a.settings.adjustOldDeltas && "mousewheel" === e.type && t % 120 == 0;
        }
        e.fn.extend({
          mousewheel: function mousewheel(e) {
            return e ? this.bind("mousewheel", e) : this.trigger("mousewheel");
          },
          unmousewheel: function unmousewheel(e) {
            return this.unbind("mousewheel", e);
          }
        });
      }, "function" == typeof t.define && t.define.amd ? t.define("jquery-mousewheel", ["jquery"], r) : "object" == ( false ? 0 : _typeof(exports)) ? module.exports = r : r(e), t.define("jquery.select2", ["jquery", "jquery-mousewheel", "./select2/core", "./select2/defaults"], function (e, t, n, i) {
        if (null == e.fn.select2) {
          var o = ["open", "close", "destroy"];
          e.fn.select2 = function (t) {
            if ("object" == _typeof(t = t || {})) return this.each(function () {
              var i = e.extend(!0, {}, t);
              new n(e(this), i);
            }), this;
            if ("string" == typeof t) {
              var i,
                r = Array.prototype.slice.call(arguments, 1);
              return this.each(function () {
                var n = e(this).data("select2");
                null == n && window.console && console.error && console.error("The select2('" + t + "') method was called on an element that is not using Select2."), i = n[t].apply(n, r);
              }), e.inArray(t, o) > -1 ? this : i;
            }
            throw new Error("Invalid arguments for Select2: " + t);
          };
        }
        return null == e.fn.select2.defaults && (e.fn.select2.defaults = i), n;
      }), {
        define: t.define,
        require: t.require
      };
    }(),
    n = t.require("jquery.select2");
  return e.fn.select2.amd = t, n;
});

/***/ }),

/***/ "./public/frontend/default/js/custom.js":
/*!**********************************************!*\
  !*** ./public/frontend/default/js/custom.js ***!
  \**********************************************/
/***/ (() => {

(function ($) {
  "use strict";

  $(window).on('load', function () {
    setTimeout(function () {
      $(".newsletter_form_wrapper").addClass("newsletter_active").fadeIn();
    }, 1500);
  });
  $('.close_modal').on('click', function () {
    $('.newsletter_form_wrapper').removeClass('newsletter_active');
  });
  $(document).on('click', function (event) {
    if (!$(event.target).closest(".newsletter_form_inner").length) {
      $("body").find(".newsletter_form_wrapper").removeClass('newsletter_active');
    }
  });
  $(document).ready(function () {
    $(".country_list").select2({
      containerCssClass: "currance_list_search",
      dropdownCssClass: "currance_list_search"
    });
    $(".category_list").select2({
      containerCssClass: "category_list_search",
      dropdownCssClass: "category_list_items"
    });
    $(".category_list").select2({
      containerCssClass: "category_list_search",
      dropdownCssClass: "category_list_items"
    });
    //currance select jquery
    $('.select_btn').on('click', function () {
      $('.select_option').toggleClass('list_visiable');
    });
    //single page menu jquery
    $('.mega_menu_icon').on('click', function () {
      $('.single_page_menu').toggleClass('active');
    });
    // owl carousel js
    var banner_slider = $('.banner_slider');
    var dir = $('html').attr('dir');
    var dir_val = false;
    if (dir == 'rtl') {
      dir_val = true;
    }
    if (banner_slider.length) {
      banner_slider.owlCarousel({
        items: 1,
        loop: true,
        dots: true,
        autoplay: true,
        margin: 40,
        autoplayHoverPause: true,
        autoplayTimeout: 2000,
        nav: false,
        rtl: dir_val,
        smartSpeed: 1000
      });
    }
    // owl carousel js
    var product_slider_1 = $('.product_slider_1');
    if (product_slider_1.length) {
      product_slider_1.owlCarousel({
        items: 6,
        loop: true,
        dots: false,
        autoplay: false,
        margin: 20,
        autoplayHoverPause: true,
        autoplayTimeout: 5000,
        nav: true,
        rtl: dir_val,
        navText: ['<i class="ti-arrow-left"></i>', '<i class="ti-arrow-right"></i>'],
        responsive: {
          0: {
            items: 1,
            margin: 15
          },
          576: {
            items: 2,
            margin: 15
          },
          991: {
            items: 3,
            margin: 15
          },
          1200: {
            items: 6,
            margin: 12
          }
        }
      });
    }
    // owl carousel js
    var product_slider_2 = $('.product_slider_2');
    if (product_slider_2.length) {
      product_slider_2.owlCarousel({
        items: 3,
        loop: true,
        dots: false,
        autoplay: false,
        margin: 20,
        autoplayHoverPause: true,
        autoplayTimeout: 5000,
        nav: true,
        rtl: dir_val,
        navText: ['<i class="ti-arrow-left"></i>', '<i class="ti-arrow-right"></i>'],
        responsive: {
          0: {
            items: 1,
            margin: 15
          },
          576: {
            items: 2,
            margin: 15
          },
          991: {
            items: 2,
            margin: 15
          },
          1200: {
            items: 3,
            margin: 20
          }
        }
      });
    }
    // owl carousel js
    var feature_slide = $('.feature_slide');
    if (feature_slide.length) {
      feature_slide.owlCarousel({
        items: 4,
        loop: true,
        dots: false,
        autoplay: false,
        margin: 20,
        autoplayHoverPause: true,
        autoplayTimeout: 5000,
        nav: true,
        rtl: dir_val,
        navText: ['<i class="ti-arrow-left"></i>', '<i class="ti-arrow-right"></i>'],
        responsive: {
          0: {
            items: 1,
            margin: 15
          },
          576: {
            items: 2,
            margin: 15
          },
          991: {
            items: 3,
            margin: 15
          },
          1200: {
            items: 4,
            margin: 20
          }
        }
      });
    }
  });

  // $("select_btn").hover(
  //     function () {
  //       $('.select_btn').addClass('list_visiable');
  //     },
  //     function (event) {
  //         if (!$(event.target).closest(".select_option").length) {
  //             $("body").find(".select_option").removeClass("list_visiable");
  //         }
  //     }
  //   );

  //niceselect select jquery
  $(document).ready(function () {
    $('.nc_select, .select_address, #product_short_list, #paginate_by').niceSelect();
    //datepicker js
    $('#datepicker').datepicker();
  });
  $(document).on('click', function (event) {
    if (!$(event.target).closest(".select_option,.select2-container").length) {
      $("body").find(".select_option").removeClass("list_visiable");
    }
  });
  $(document).on('click', function (event) {
    if (!$(event.target).closest(".mega_menu_icon").length) {
      $("body").find(".single_page_menu").removeClass("active");
    }
  });

  //table responsive css
  $(window).on('load resize', function () {
    if ($(this).width() < 640) {
      $('table tfoot').hide();
    } else {
      $('table tfoot').show();
    }
  });
  $(document).ready(function () {
    $('.all_product').simpleLoadMore({
      item: '.single_product_item',
      count: 18,
      itemsToLoad: 6
    });
  });

  //sidebar dropdown
  $('.sub-menu ul').hide();
  $(".sub-menu a").on('click', function () {
    $(this).parent(".sub-menu").children("ul").slideToggle("100");
    $(this).find(".right").toggleClass("ti-plus ti-minus");
  });

  // accordion part js
  var acc = document.getElementsByClassName("accordion");
  var i;
  for (i = 0; i < acc.length; i++) {
    acc[i].addEventListener("click", function () {
      this.classList.toggle("active");
      var panel = this.nextElementSibling;
      if (panel.style.maxHeight) {
        panel.style.maxHeight = null;
      } else {
        panel.style.maxHeight = panel.scrollHeight + "px";
      }
    });
  }
  $('.menu-item').on('click', function () {
    $('.mega-menu').removeClass('active_megamenu');
  });

  //megamenu hover add class
  if ($(window).width() > 1200) {
    $('.dropdown').hover(function () {
      $(this).addClass('show');
    }, function () {
      $(this).removeClass('show');
    });
  }
  // for multy step form
  $('.view_collaspe_btn').on('click', function () {
    var $this = $(this);
    $this.toggleClass('view_collaspe_btn');
    if ($this.hasClass('view_collaspe_btn')) {
      $this.text('View More');
    } else {
      $this.text('See Less');
    }
  });
  $(document).ready(function () {
    var currentGfgStep, nextGfgStep, previousGfgStep;
    var opacity;
    var current = 1;
    var steps = $("fieldset").length;
    setProgressBar(current);
    $(".next-step").on('click', function () {
      currentGfgStep = $(this).parent();
      nextGfgStep = $(this).parent().next();
      $("#progressbar li").eq($("fieldset").index(nextGfgStep)).addClass("active");
      nextGfgStep.show();
      currentGfgStep.animate({
        opacity: 1
      }, {
        step: function step(now) {
          opacity = 1 - now;
          currentGfgStep.css({
            // 'display': 'none',
            'position': 'relative'
          });
          nextGfgStep.css({
            'opacity': opacity
          });
        },
        duration: 500
      });
      setProgressBar(++current);
    });
    $(".previous-step").on('click', function () {
      currentGfgStep = $(this).parent();
      previousGfgStep = $(this).parent().prev();
      $("#progressbar li").eq($("fieldset").index(currentGfgStep)).removeClass("active");
      previousGfgStep.show();
      currentGfgStep.animate({
        opacity: 1
      }, {
        step: function step(now) {
          opacity = 1 - now;
          currentGfgStep.css({
            // 'display': 'none',
            'position': 'relative'
          });
          previousGfgStep.css({
            'opacity': opacity
          });
        },
        duration: 500
      });
      setProgressBar(--current);
    });
    function setProgressBar(currentStep) {
      var percent = parseFloat(100 / steps) * current;
      percent = percent.toFixed();
      $(".progress-bar").css("width", percent + "%");
    }
    $(".submit").on('click', function () {
      return false;
    });
  });
  $(document).on('submit', 'form', function (e) {
    var summernote = $(this).find('.summernote');
    if (summernote.length) {
      if (summernote.summernote('codeview.isActivated')) {
        summernote.summernote('codeview.deactivate');
      }
    }
  });
})(jQuery);
function config(key, default_value) {
  var value = _.get(_config, key);
  if (typeof value == 'undefined') {
    return default_value;
  }
  return value;
}
function user_currency(key, default_value) {
  var value = _.get(_user_currency, key);
  if (typeof value == 'undefined') {
    return default_value;
  }
  return value;
}
function formatMoney(amount) {
  var decimalCount = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 2;
  var decimal = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : ".";
  var thousands = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : ",";
  try {
    decimalCount = Math.abs(decimalCount);
    decimalCount = isNaN(decimalCount) ? 2 : decimalCount;
    var negativeSign = amount < 0 ? "-" : "";
    var i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
    var j = i.length > 3 ? i.length % 3 : 0;
    return negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
  } catch (e) {
    console.log(e);
  }
}
window.currency_format = function (amount) {
  if (_user_currency.length !== 0) {
    var decimal = '.';
    var thousands = ',';
    if (user_currency('symbol') == "€") {
      decimal = ',';
      thousands = ' ';
    }
    var formatedMoney = formatMoney(parseFloat(amount) * parseFloat(user_currency('convert_rate')), config('decimal_limit'), decimal, thousands);
    if (config('currency_symbol_position') === 'left') {
      return user_currency('symbol') + formatedMoney;
    } else if (config('currency_symbol_position') === 'left_with_space') {
      return user_currency('symbol') + " " + formatedMoney;
    } else if (config('currency_symbol_position') === 'right') {
      return formatedMoney + user_currency('symbol');
    } else if (config('currency_symbol_position') === 'right_with_space') {
      return formatedMoney + " " + user_currency('symbol');
    }
  } else if (config('currency_symbol')) {
    var _decimal = '.';
    var _thousands = ',';
    if (config('currency_symbol') == "€") {
      _decimal = ',';
      _thousands = ' ';
    }
    var generalformatedMoney = formatMoney(parseFloat(amount), config('decimal_limit'), _decimal, _thousands);
    if (config('currency_symbol_position') === 'left') {
      return config('currency_symbol') + generalformatedMoney;
    } else if (config('currency_symbol_position') === 'left_with_space') {
      return config('currency_symbol') + " " + generalformatedMoney;
    } else if (config('currency_symbol_position') === 'right') {
      return generalformatedMoney + config('currency_symbol');
    } else if (config('currency_symbol_position') === 'right_with_space') {
      return generalformatedMoney + " " + config('currency_symbol');
    }
  } else {
    return "$ " + formatMoney(parseFloat(amount), 2);
  }
};

/***/ }),

/***/ "./public/frontend/default/js/highlight.js":
/*!*************************************************!*\
  !*** ./public/frontend/default/js/highlight.js ***!
  \*************************************************/
/***/ (() => {

/*

highlight v3  !! Modified by Jon Raasch (http://jonraasch.com) to fix IE6 bug !!

Highlights arbitrary terms.

<http://johannburkard.de/blog/programming/javascript/highlight-javascript-text-higlighting-jquery-plugin.html>

MIT license.

Johann Burkard
<http://johannburkard.de>
<mailto:jb@eaio.com>

*/

jQuery.fn.highlight = function (pat) {
  function innerHighlight(node, pat) {
    var skip = 0;
    if (node.nodeType == 3) {
      var pos = node.data.toUpperCase().indexOf(pat);
      if (pos >= 0) {
        var spannode = document.createElement('span');
        spannode.className = 'highlight';
        var middlebit = node.splitText(pos);
        var endbit = middlebit.splitText(pat.length);
        var middleclone = middlebit.cloneNode(true);
        spannode.appendChild(middleclone);
        middlebit.parentNode.replaceChild(spannode, middlebit);
        skip = 1;
      }
    } else if (node.nodeType == 1 && node.childNodes && !/(script|style)/i.test(node.tagName)) {
      for (var i = 0; i < node.childNodes.length; ++i) {
        i += innerHighlight(node.childNodes[i], pat);
      }
    }
    return skip;
  }
  return this.each(function () {
    innerHighlight(this, pat.toUpperCase());
  });
};
jQuery.fn.removeHighlight = function () {
  function newNormalize(node) {
    for (var i = 0, children = node.childNodes, nodeCount = children.length; i < nodeCount; i++) {
      var child = children[i];
      if (child.nodeType == 1) {
        newNormalize(child);
        continue;
      }
      if (child.nodeType != 3) {
        continue;
      }
      var next = child.nextSibling;
      if (next == null || next.nodeType != 3) {
        continue;
      }
      var combined_text = child.nodeValue + next.nodeValue;
      new_node = node.ownerDocument.createTextNode(combined_text);
      node.insertBefore(new_node, child);
      node.removeChild(child);
      node.removeChild(next);
      i--;
      nodeCount--;
    }
  }
  return this.find("span.highlight").each(function () {
    var thisParent = this.parentNode;
    thisParent.replaceChild(this.firstChild, this);
    newNormalize(thisParent);
  }).end();
};

/***/ }),

/***/ "./public/frontend/default/js/jquery.nicescroll.min.js":
/*!*************************************************************!*\
  !*** ./public/frontend/default/js/jquery.nicescroll.min.js ***!
  \*************************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
/* jquery.nicescroll v3.7.6 InuYaksa - MIT - https://nicescroll.areaaperta.com */
!function (e) {
   true ? !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (e),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)) : 0;
}(function (e) {
  "use strict";

  var o = !1,
    t = !1,
    r = 0,
    i = 2e3,
    s = 0,
    n = e,
    l = document,
    a = window,
    c = n(a),
    d = [],
    u = a.requestAnimationFrame || a.webkitRequestAnimationFrame || a.mozRequestAnimationFrame || !1,
    h = a.cancelAnimationFrame || a.webkitCancelAnimationFrame || a.mozCancelAnimationFrame || !1;
  if (u) a.cancelAnimationFrame || (h = function h(e) {});else {
    var p = 0;
    u = function u(e, o) {
      var t = new Date().getTime(),
        r = Math.max(0, 16 - (t - p)),
        i = a.setTimeout(function () {
          e(t + r);
        }, r);
      return p = t + r, i;
    }, h = function h(e) {
      a.clearTimeout(e);
    };
  }
  var m = a.MutationObserver || a.WebKitMutationObserver || !1,
    f = Date.now || function () {
      return new Date().getTime();
    },
    g = {
      zindex: "auto",
      cursoropacitymin: 0,
      cursoropacitymax: 1,
      cursorcolor: "#424242",
      cursorwidth: "6px",
      cursorborder: "1px solid #fff",
      cursorborderradius: "5px",
      scrollspeed: 40,
      mousescrollstep: 27,
      touchbehavior: !1,
      emulatetouch: !1,
      hwacceleration: !0,
      usetransition: !0,
      boxzoom: !1,
      dblclickzoom: !0,
      gesturezoom: !0,
      grabcursorenabled: !0,
      autohidemode: !0,
      background: "",
      iframeautoresize: !0,
      cursorminheight: 32,
      preservenativescrolling: !0,
      railoffset: !1,
      railhoffset: !1,
      bouncescroll: !0,
      spacebarenabled: !0,
      railpadding: {
        top: 0,
        right: 0,
        left: 0,
        bottom: 0
      },
      disableoutline: !0,
      horizrailenabled: !0,
      railalign: "right",
      railvalign: "bottom",
      enabletranslate3d: !0,
      enablemousewheel: !0,
      enablekeyboard: !0,
      smoothscroll: !0,
      sensitiverail: !0,
      enablemouselockapi: !0,
      cursorfixedheight: !1,
      directionlockdeadzone: 6,
      hidecursordelay: 400,
      nativeparentscrolling: !0,
      enablescrollonselection: !0,
      overflowx: !0,
      overflowy: !0,
      cursordragspeed: .3,
      rtlmode: "auto",
      cursordragontouch: !1,
      oneaxismousemode: "auto",
      scriptpath: function () {
        var e = l.currentScript || function () {
            var e = l.getElementsByTagName("script");
            return !!e.length && e[e.length - 1];
          }(),
          o = e ? e.src.split("?")[0] : "";
        return o.split("/").length > 0 ? o.split("/").slice(0, -1).join("/") + "/" : "";
      }(),
      preventmultitouchscrolling: !0,
      disablemutationobserver: !1,
      enableobserver: !0,
      scrollbarid: !1
    },
    v = !1,
    w = function w() {
      if (v) return v;
      var e = l.createElement("DIV"),
        o = e.style,
        t = navigator.userAgent,
        r = navigator.platform,
        i = {};
      return i.haspointerlock = "pointerLockElement" in l || "webkitPointerLockElement" in l || "mozPointerLockElement" in l, i.isopera = "opera" in a, i.isopera12 = i.isopera && "getUserMedia" in navigator, i.isoperamini = "[object OperaMini]" === Object.prototype.toString.call(a.operamini), i.isie = "all" in l && "attachEvent" in e && !i.isopera, i.isieold = i.isie && !("msInterpolationMode" in o), i.isie7 = i.isie && !i.isieold && (!("documentMode" in l) || 7 === l.documentMode), i.isie8 = i.isie && "documentMode" in l && 8 === l.documentMode, i.isie9 = i.isie && "performance" in a && 9 === l.documentMode, i.isie10 = i.isie && "performance" in a && 10 === l.documentMode, i.isie11 = "msRequestFullscreen" in e && l.documentMode >= 11, i.ismsedge = "msCredentials" in a, i.ismozilla = "MozAppearance" in o, i.iswebkit = !i.ismsedge && "WebkitAppearance" in o, i.ischrome = i.iswebkit && "chrome" in a, i.ischrome38 = i.ischrome && "touchAction" in o, i.ischrome22 = !i.ischrome38 && i.ischrome && i.haspointerlock, i.ischrome26 = !i.ischrome38 && i.ischrome && "transition" in o, i.cantouch = "ontouchstart" in l.documentElement || "ontouchstart" in a, i.hasw3ctouch = (a.PointerEvent || !1) && (navigator.maxTouchPoints > 0 || navigator.msMaxTouchPoints > 0), i.hasmstouch = !i.hasw3ctouch && (a.MSPointerEvent || !1), i.ismac = /^mac$/i.test(r), i.isios = i.cantouch && /iphone|ipad|ipod/i.test(r), i.isios4 = i.isios && !("seal" in Object), i.isios7 = i.isios && "webkitHidden" in l, i.isios8 = i.isios && "hidden" in l, i.isios10 = i.isios && a.Proxy, i.isandroid = /android/i.test(t), i.haseventlistener = "addEventListener" in e, i.trstyle = !1, i.hastransform = !1, i.hastranslate3d = !1, i.transitionstyle = !1, i.hastransition = !1, i.transitionend = !1, i.trstyle = "transform", i.hastransform = "transform" in o || function () {
        for (var e = ["msTransform", "webkitTransform", "MozTransform", "OTransform"], t = 0, r = e.length; t < r; t++) {
          if (void 0 !== o[e[t]]) {
            i.trstyle = e[t];
            break;
          }
        }
        i.hastransform = !!i.trstyle;
      }(), i.hastransform && (o[i.trstyle] = "translate3d(1px,2px,3px)", i.hastranslate3d = /translate3d/.test(o[i.trstyle])), i.transitionstyle = "transition", i.prefixstyle = "", i.transitionend = "transitionend", i.hastransition = "transition" in o || function () {
        i.transitionend = !1;
        for (var e = ["webkitTransition", "msTransition", "MozTransition", "OTransition", "OTransition", "KhtmlTransition"], t = ["-webkit-", "-ms-", "-moz-", "-o-", "-o", "-khtml-"], r = ["webkitTransitionEnd", "msTransitionEnd", "transitionend", "otransitionend", "oTransitionEnd", "KhtmlTransitionEnd"], s = 0, n = e.length; s < n; s++) {
          if (e[s] in o) {
            i.transitionstyle = e[s], i.prefixstyle = t[s], i.transitionend = r[s];
            break;
          }
        }
        i.ischrome26 && (i.prefixstyle = t[1]), i.hastransition = i.transitionstyle;
      }(), i.cursorgrabvalue = function () {
        var e = ["grab", "-webkit-grab", "-moz-grab"];
        (i.ischrome && !i.ischrome38 || i.isie) && (e = []);
        for (var t = 0, r = e.length; t < r; t++) {
          var s = e[t];
          if (o.cursor = s, o.cursor == s) return s;
        }
        return "url(https://cdnjs.cloudflare.com/ajax/libs/slider-pro/1.3.0/css/images/openhand.cur),n-resize";
      }(), i.hasmousecapture = "setCapture" in e, i.hasMutationObserver = !1 !== m, e = null, v = i, i;
    },
    b = function b(e, p) {
      function v() {
        var e = T.doc.css(P.trstyle);
        return !(!e || "matrix" != e.substr(0, 6)) && e.replace(/^.*\((.*)\)$/g, "$1").replace(/px/g, "").split(/, +/);
      }
      function b() {
        var e = T.win;
        if ("zIndex" in e) return e.zIndex();
        for (; e.length > 0;) {
          if (9 == e[0].nodeType) return !1;
          var o = e.css("zIndex");
          if (!isNaN(o) && 0 !== o) return parseInt(o);
          e = e.parent();
        }
        return !1;
      }
      function x(e, o, t) {
        var r = e.css(o),
          i = parseFloat(r);
        if (isNaN(i)) {
          var s = 3 == (i = I[r] || 0) ? t ? T.win.outerHeight() - T.win.innerHeight() : T.win.outerWidth() - T.win.innerWidth() : 1;
          return T.isie8 && i && (i += 1), s ? i : 0;
        }
        return i;
      }
      function S(e, o, t, r) {
        T._bind(e, o, function (r) {
          var i = {
            original: r = r || a.event,
            target: r.target || r.srcElement,
            type: "wheel",
            deltaMode: "MozMousePixelScroll" == r.type ? 0 : 1,
            deltaX: 0,
            deltaZ: 0,
            preventDefault: function preventDefault() {
              return r.preventDefault ? r.preventDefault() : r.returnValue = !1, !1;
            },
            stopImmediatePropagation: function stopImmediatePropagation() {
              r.stopImmediatePropagation ? r.stopImmediatePropagation() : r.cancelBubble = !0;
            }
          };
          return "mousewheel" == o ? (r.wheelDeltaX && (i.deltaX = -.025 * r.wheelDeltaX), r.wheelDeltaY && (i.deltaY = -.025 * r.wheelDeltaY), !i.deltaY && !i.deltaX && (i.deltaY = -.025 * r.wheelDelta)) : i.deltaY = r.detail, t.call(e, i);
        }, r);
      }
      function z(e, o, t, r) {
        T.scrollrunning || (T.newscrolly = T.getScrollTop(), T.newscrollx = T.getScrollLeft(), D = f());
        var i = f() - D;
        if (D = f(), i > 350 ? A = 1 : A += (2 - A) / 10, e = e * A | 0, o = o * A | 0, e) {
          if (r) if (e < 0) {
            if (T.getScrollLeft() >= T.page.maxw) return !0;
          } else if (T.getScrollLeft() <= 0) return !0;
          var s = e > 0 ? 1 : -1;
          X !== s && (T.scrollmom && T.scrollmom.stop(), T.newscrollx = T.getScrollLeft(), X = s), T.lastdeltax -= e;
        }
        if (o) {
          if (function () {
            var e = T.getScrollTop();
            if (o < 0) {
              if (e >= T.page.maxh) return !0;
            } else if (e <= 0) return !0;
          }()) {
            if (M.nativeparentscrolling && t && !T.ispage && !T.zoomactive) return !0;
            var n = T.view.h >> 1;
            T.newscrolly < -n ? (T.newscrolly = -n, o = -1) : T.newscrolly > T.page.maxh + n ? (T.newscrolly = T.page.maxh + n, o = 1) : o = 0;
          }
          var l = o > 0 ? 1 : -1;
          B !== l && (T.scrollmom && T.scrollmom.stop(), T.newscrolly = T.getScrollTop(), B = l), T.lastdeltay -= o;
        }
        (o || e) && T.synched("relativexy", function () {
          var e = T.lastdeltay + T.newscrolly;
          T.lastdeltay = 0;
          var o = T.lastdeltax + T.newscrollx;
          T.lastdeltax = 0, T.rail.drag || T.doScrollPos(o, e);
        });
      }
      function k(e, o, t) {
        var r, i;
        return !(t || !q) || (0 === e.deltaMode ? (r = -e.deltaX * (M.mousescrollstep / 54) | 0, i = -e.deltaY * (M.mousescrollstep / 54) | 0) : 1 === e.deltaMode && (r = -e.deltaX * M.mousescrollstep * 50 / 80 | 0, i = -e.deltaY * M.mousescrollstep * 50 / 80 | 0), o && M.oneaxismousemode && 0 === r && i && (r = i, i = 0, t && (r < 0 ? T.getScrollLeft() >= T.page.maxw : T.getScrollLeft() <= 0) && (i = r, r = 0)), T.isrtlmode && (r = -r), z(r, i, t, !0) ? void (t && (q = !0)) : (q = !1, e.stopImmediatePropagation(), e.preventDefault()));
      }
      var T = this;
      this.version = "3.7.6", this.name = "nicescroll", this.me = p;
      var E = n("body"),
        M = this.opt = {
          doc: E,
          win: !1
        };
      if (n.extend(M, g), M.snapbackspeed = 80, e) for (var L in M) {
        void 0 !== e[L] && (M[L] = e[L]);
      }
      if (M.disablemutationobserver && (m = !1), this.doc = M.doc, this.iddoc = this.doc && this.doc[0] ? this.doc[0].id || "" : "", this.ispage = /^BODY|HTML/.test(M.win ? M.win[0].nodeName : this.doc[0].nodeName), this.haswrapper = !1 !== M.win, this.win = M.win || (this.ispage ? c : this.doc), this.docscroll = this.ispage && !this.haswrapper ? c : this.win, this.body = E, this.viewport = !1, this.isfixed = !1, this.iframe = !1, this.isiframe = "IFRAME" == this.doc[0].nodeName && "IFRAME" == this.win[0].nodeName, this.istextarea = "TEXTAREA" == this.win[0].nodeName, this.forcescreen = !1, this.canshowonmouseevent = "scroll" != M.autohidemode, this.onmousedown = !1, this.onmouseup = !1, this.onmousemove = !1, this.onmousewheel = !1, this.onkeypress = !1, this.ongesturezoom = !1, this.onclick = !1, this.onscrollstart = !1, this.onscrollend = !1, this.onscrollcancel = !1, this.onzoomin = !1, this.onzoomout = !1, this.view = !1, this.page = !1, this.scroll = {
        x: 0,
        y: 0
      }, this.scrollratio = {
        x: 0,
        y: 0
      }, this.cursorheight = 20, this.scrollvaluemax = 0, "auto" == M.rtlmode) {
        var C = this.win[0] == a ? this.body : this.win,
          N = C.css("writing-mode") || C.css("-webkit-writing-mode") || C.css("-ms-writing-mode") || C.css("-moz-writing-mode");
        "horizontal-tb" == N || "lr-tb" == N || "" === N ? (this.isrtlmode = "rtl" == C.css("direction"), this.isvertical = !1) : (this.isrtlmode = "vertical-rl" == N || "tb" == N || "tb-rl" == N || "rl-tb" == N, this.isvertical = "vertical-rl" == N || "tb" == N || "tb-rl" == N);
      } else this.isrtlmode = !0 === M.rtlmode, this.isvertical = !1;
      if (this.scrollrunning = !1, this.scrollmom = !1, this.observer = !1, this.observerremover = !1, this.observerbody = !1, !1 !== M.scrollbarid) this.id = M.scrollbarid;else do {
        this.id = "ascrail" + i++;
      } while (l.getElementById(this.id));
      this.rail = !1, this.cursor = !1, this.cursorfreezed = !1, this.selectiondrag = !1, this.zoom = !1, this.zoomactive = !1, this.hasfocus = !1, this.hasmousefocus = !1, this.railslocked = !1, this.locked = !1, this.hidden = !1, this.cursoractive = !0, this.wheelprevented = !1, this.overflowx = M.overflowx, this.overflowy = M.overflowy, this.nativescrollingarea = !1, this.checkarea = 0, this.events = [], this.saved = {}, this.delaylist = {}, this.synclist = {}, this.lastdeltax = 0, this.lastdeltay = 0, this.detected = w();
      var P = n.extend({}, this.detected);
      this.canhwscroll = P.hastransform && M.hwacceleration, this.ishwscroll = this.canhwscroll && T.haswrapper, this.isrtlmode ? this.isvertical ? this.hasreversehr = !(P.iswebkit || P.isie || P.isie11) : this.hasreversehr = !(P.iswebkit || P.isie && !P.isie10 && !P.isie11) : this.hasreversehr = !1, this.istouchcapable = !1, P.cantouch || !P.hasw3ctouch && !P.hasmstouch ? !P.cantouch || P.isios || P.isandroid || !P.iswebkit && !P.ismozilla || (this.istouchcapable = !0) : this.istouchcapable = !0, M.enablemouselockapi || (P.hasmousecapture = !1, P.haspointerlock = !1), this.debounced = function (e, o, t) {
        T && (T.delaylist[e] || !1 || (T.delaylist[e] = {
          h: u(function () {
            T.delaylist[e].fn.call(T), T.delaylist[e] = !1;
          }, t)
        }, o.call(T)), T.delaylist[e].fn = o);
      }, this.synched = function (e, o) {
        T.synclist[e] ? T.synclist[e] = o : (T.synclist[e] = o, u(function () {
          T && (T.synclist[e] && T.synclist[e].call(T), T.synclist[e] = null);
        }));
      }, this.unsynched = function (e) {
        T.synclist[e] && (T.synclist[e] = !1);
      }, this.css = function (e, o) {
        for (var t in o) {
          T.saved.css.push([e, t, e.css(t)]), e.css(t, o[t]);
        }
      }, this.scrollTop = function (e) {
        return void 0 === e ? T.getScrollTop() : T.setScrollTop(e);
      }, this.scrollLeft = function (e) {
        return void 0 === e ? T.getScrollLeft() : T.setScrollLeft(e);
      };
      var R = function R(e, o, t, r, i, s, n) {
        this.st = e, this.ed = o, this.spd = t, this.p1 = r || 0, this.p2 = i || 1, this.p3 = s || 0, this.p4 = n || 1, this.ts = f(), this.df = o - e;
      };
      if (R.prototype = {
        B2: function B2(e) {
          return 3 * (1 - e) * (1 - e) * e;
        },
        B3: function B3(e) {
          return 3 * (1 - e) * e * e;
        },
        B4: function B4(e) {
          return e * e * e;
        },
        getPos: function getPos() {
          return (f() - this.ts) / this.spd;
        },
        getNow: function getNow() {
          var e = (f() - this.ts) / this.spd,
            o = this.B2(e) + this.B3(e) + this.B4(e);
          return e >= 1 ? this.ed : this.st + this.df * o | 0;
        },
        update: function update(e, o) {
          return this.st = this.getNow(), this.ed = e, this.spd = o, this.ts = f(), this.df = this.ed - this.st, this;
        }
      }, this.ishwscroll) {
        this.doc.translate = {
          x: 0,
          y: 0,
          tx: "0px",
          ty: "0px"
        }, P.hastranslate3d && P.isios && this.doc.css("-webkit-backface-visibility", "hidden"), this.getScrollTop = function (e) {
          if (!e) {
            var o = v();
            if (o) return 16 == o.length ? -o[13] : -o[5];
            if (T.timerscroll && T.timerscroll.bz) return T.timerscroll.bz.getNow();
          }
          return T.doc.translate.y;
        }, this.getScrollLeft = function (e) {
          if (!e) {
            var o = v();
            if (o) return 16 == o.length ? -o[12] : -o[4];
            if (T.timerscroll && T.timerscroll.bh) return T.timerscroll.bh.getNow();
          }
          return T.doc.translate.x;
        }, this.notifyScrollEvent = function (e) {
          var o = l.createEvent("UIEvents");
          o.initUIEvent("scroll", !1, !1, a, 1), o.niceevent = !0, e.dispatchEvent(o);
        };
        var _ = this.isrtlmode ? 1 : -1;
        P.hastranslate3d && M.enabletranslate3d ? (this.setScrollTop = function (e, o) {
          T.doc.translate.y = e, T.doc.translate.ty = -1 * e + "px", T.doc.css(P.trstyle, "translate3d(" + T.doc.translate.tx + "," + T.doc.translate.ty + ",0)"), o || T.notifyScrollEvent(T.win[0]);
        }, this.setScrollLeft = function (e, o) {
          T.doc.translate.x = e, T.doc.translate.tx = e * _ + "px", T.doc.css(P.trstyle, "translate3d(" + T.doc.translate.tx + "," + T.doc.translate.ty + ",0)"), o || T.notifyScrollEvent(T.win[0]);
        }) : (this.setScrollTop = function (e, o) {
          T.doc.translate.y = e, T.doc.translate.ty = -1 * e + "px", T.doc.css(P.trstyle, "translate(" + T.doc.translate.tx + "," + T.doc.translate.ty + ")"), o || T.notifyScrollEvent(T.win[0]);
        }, this.setScrollLeft = function (e, o) {
          T.doc.translate.x = e, T.doc.translate.tx = e * _ + "px", T.doc.css(P.trstyle, "translate(" + T.doc.translate.tx + "," + T.doc.translate.ty + ")"), o || T.notifyScrollEvent(T.win[0]);
        });
      } else this.getScrollTop = function () {
        return T.docscroll.scrollTop();
      }, this.setScrollTop = function (e) {
        T.docscroll.scrollTop(e);
      }, this.getScrollLeft = function () {
        return T.hasreversehr ? T.detected.ismozilla ? T.page.maxw - Math.abs(T.docscroll.scrollLeft()) : T.page.maxw - T.docscroll.scrollLeft() : T.docscroll.scrollLeft();
      }, this.setScrollLeft = function (e) {
        return setTimeout(function () {
          if (T) return T.hasreversehr && (e = T.detected.ismozilla ? -(T.page.maxw - e) : T.page.maxw - e), T.docscroll.scrollLeft(e);
        }, 1);
      };
      this.getTarget = function (e) {
        return !!e && (e.target ? e.target : !!e.srcElement && e.srcElement);
      }, this.hasParent = function (e, o) {
        if (!e) return !1;
        for (var t = e.target || e.srcElement || e || !1; t && t.id != o;) {
          t = t.parentNode || !1;
        }
        return !1 !== t;
      };
      var I = {
        thin: 1,
        medium: 3,
        thick: 5
      };
      this.getDocumentScrollOffset = function () {
        return {
          top: a.pageYOffset || l.documentElement.scrollTop,
          left: a.pageXOffset || l.documentElement.scrollLeft
        };
      }, this.getOffset = function () {
        if (T.isfixed) {
          var e = T.win.offset(),
            o = T.getDocumentScrollOffset();
          return e.top -= o.top, e.left -= o.left, e;
        }
        var t = T.win.offset();
        if (!T.viewport) return t;
        var r = T.viewport.offset();
        return {
          top: t.top - r.top,
          left: t.left - r.left
        };
      }, this.updateScrollBar = function (e) {
        var o, t;
        if (T.ishwscroll) T.rail.css({
          height: T.win.innerHeight() - (M.railpadding.top + M.railpadding.bottom)
        }), T.railh && T.railh.css({
          width: T.win.innerWidth() - (M.railpadding.left + M.railpadding.right)
        });else {
          var r = T.getOffset();
          if (o = {
            top: r.top,
            left: r.left - (M.railpadding.left + M.railpadding.right)
          }, o.top += x(T.win, "border-top-width", !0), o.left += T.rail.align ? T.win.outerWidth() - x(T.win, "border-right-width") - T.rail.width : x(T.win, "border-left-width"), (t = M.railoffset) && (t.top && (o.top += t.top), t.left && (o.left += t.left)), T.railslocked || T.rail.css({
            top: o.top,
            left: o.left,
            height: (e ? e.h : T.win.innerHeight()) - (M.railpadding.top + M.railpadding.bottom)
          }), T.zoom && T.zoom.css({
            top: o.top + 1,
            left: 1 == T.rail.align ? o.left - 20 : o.left + T.rail.width + 4
          }), T.railh && !T.railslocked) {
            o = {
              top: r.top,
              left: r.left
            }, (t = M.railhoffset) && (t.top && (o.top += t.top), t.left && (o.left += t.left));
            var i = T.railh.align ? o.top + x(T.win, "border-top-width", !0) + T.win.innerHeight() - T.railh.height : o.top + x(T.win, "border-top-width", !0),
              s = o.left + x(T.win, "border-left-width");
            T.railh.css({
              top: i - (M.railpadding.top + M.railpadding.bottom),
              left: s,
              width: T.railh.width
            });
          }
        }
      }, this.doRailClick = function (e, o, t) {
        var r, i, s, n;
        T.railslocked || (T.cancelEvent(e), "pageY" in e || (e.pageX = e.clientX + l.documentElement.scrollLeft, e.pageY = e.clientY + l.documentElement.scrollTop), o ? (r = t ? T.doScrollLeft : T.doScrollTop, s = t ? (e.pageX - T.railh.offset().left - T.cursorwidth / 2) * T.scrollratio.x : (e.pageY - T.rail.offset().top - T.cursorheight / 2) * T.scrollratio.y, T.unsynched("relativexy"), r(0 | s)) : (r = t ? T.doScrollLeftBy : T.doScrollBy, s = t ? T.scroll.x : T.scroll.y, n = t ? e.pageX - T.railh.offset().left : e.pageY - T.rail.offset().top, i = t ? T.view.w : T.view.h, r(s >= n ? i : -i)));
      }, T.newscrolly = T.newscrollx = 0, T.hasanimationframe = "requestAnimationFrame" in a, T.hascancelanimationframe = "cancelAnimationFrame" in a, T.hasborderbox = !1, this.init = function () {
        if (T.saved.css = [], P.isoperamini) return !0;
        if (P.isandroid && !("hidden" in l)) return !0;
        M.emulatetouch = M.emulatetouch || M.touchbehavior, T.hasborderbox = a.getComputedStyle && "border-box" === a.getComputedStyle(l.body)["box-sizing"];
        var e = {
          "overflow-y": "hidden"
        };
        if ((P.isie11 || P.isie10) && (e["-ms-overflow-style"] = "none"), T.ishwscroll && (this.doc.css(P.transitionstyle, P.prefixstyle + "transform 0ms ease-out"), P.transitionend && T.bind(T.doc, P.transitionend, T.onScrollTransitionEnd, !1)), T.zindex = "auto", T.ispage || "auto" != M.zindex ? T.zindex = M.zindex : T.zindex = b() || "auto", !T.ispage && "auto" != T.zindex && T.zindex > s && (s = T.zindex), T.isie && 0 === T.zindex && "auto" == M.zindex && (T.zindex = "auto"), !T.ispage || !P.isieold) {
          var i = T.docscroll;
          T.ispage && (i = T.haswrapper ? T.win : T.doc), T.css(i, e), T.ispage && (P.isie11 || P.isie) && T.css(n("html"), e), !P.isios || T.ispage || T.haswrapper || T.css(E, {
            "-webkit-overflow-scrolling": "touch"
          });
          var d = n(l.createElement("div"));
          d.css({
            position: "relative",
            top: 0,
            "float": "right",
            width: M.cursorwidth,
            height: 0,
            "background-color": M.cursorcolor,
            border: M.cursorborder,
            "background-clip": "padding-box",
            "-webkit-border-radius": M.cursorborderradius,
            "-moz-border-radius": M.cursorborderradius,
            "border-radius": M.cursorborderradius
          }), d.addClass("nicescroll-cursors"), T.cursor = d;
          var u = n(l.createElement("div"));
          u.attr("id", T.id), u.addClass("nicescroll-rails nicescroll-rails-vr");
          var h,
            p,
            f = ["left", "right", "top", "bottom"];
          for (var g in f) {
            p = f[g], (h = M.railpadding[p] || 0) && u.css("padding-" + p, h + "px");
          }
          u.append(d), u.width = Math.max(parseFloat(M.cursorwidth), d.outerWidth()), u.css({
            width: u.width + "px",
            zIndex: T.zindex,
            background: M.background,
            cursor: "default"
          }), u.visibility = !0, u.scrollable = !0, u.align = "left" == M.railalign ? 0 : 1, T.rail = u, T.rail.drag = !1;
          var v = !1;
          !M.boxzoom || T.ispage || P.isieold || (v = l.createElement("div"), T.bind(v, "click", T.doZoom), T.bind(v, "mouseenter", function () {
            T.zoom.css("opacity", M.cursoropacitymax);
          }), T.bind(v, "mouseleave", function () {
            T.zoom.css("opacity", M.cursoropacitymin);
          }), T.zoom = n(v), T.zoom.css({
            cursor: "pointer",
            zIndex: T.zindex,
            backgroundImage: "url(" + M.scriptpath + "zoomico.png)",
            height: 18,
            width: 18,
            backgroundPosition: "0 0"
          }), M.dblclickzoom && T.bind(T.win, "dblclick", T.doZoom), P.cantouch && M.gesturezoom && (T.ongesturezoom = function (e) {
            return e.scale > 1.5 && T.doZoomIn(e), e.scale < .8 && T.doZoomOut(e), T.cancelEvent(e);
          }, T.bind(T.win, "gestureend", T.ongesturezoom))), T.railh = !1;
          var w;
          if (M.horizrailenabled && (T.css(i, {
            overflowX: "hidden"
          }), (d = n(l.createElement("div"))).css({
            position: "absolute",
            top: 0,
            height: M.cursorwidth,
            width: 0,
            backgroundColor: M.cursorcolor,
            border: M.cursorborder,
            backgroundClip: "padding-box",
            "-webkit-border-radius": M.cursorborderradius,
            "-moz-border-radius": M.cursorborderradius,
            "border-radius": M.cursorborderradius
          }), P.isieold && d.css("overflow", "hidden"), d.addClass("nicescroll-cursors"), T.cursorh = d, (w = n(l.createElement("div"))).attr("id", T.id + "-hr"), w.addClass("nicescroll-rails nicescroll-rails-hr"), w.height = Math.max(parseFloat(M.cursorwidth), d.outerHeight()), w.css({
            height: w.height + "px",
            zIndex: T.zindex,
            background: M.background
          }), w.append(d), w.visibility = !0, w.scrollable = !0, w.align = "top" == M.railvalign ? 0 : 1, T.railh = w, T.railh.drag = !1), T.ispage) u.css({
            position: "fixed",
            top: 0,
            height: "100%"
          }), u.css(u.align ? {
            right: 0
          } : {
            left: 0
          }), T.body.append(u), T.railh && (w.css({
            position: "fixed",
            left: 0,
            width: "100%"
          }), w.css(w.align ? {
            bottom: 0
          } : {
            top: 0
          }), T.body.append(w));else {
            if (T.ishwscroll) {
              "static" == T.win.css("position") && T.css(T.win, {
                position: "relative"
              });
              var x = "HTML" == T.win[0].nodeName ? T.body : T.win;
              n(x).scrollTop(0).scrollLeft(0), T.zoom && (T.zoom.css({
                position: "absolute",
                top: 1,
                right: 0,
                "margin-right": u.width + 4
              }), x.append(T.zoom)), u.css({
                position: "absolute",
                top: 0
              }), u.css(u.align ? {
                right: 0
              } : {
                left: 0
              }), x.append(u), w && (w.css({
                position: "absolute",
                left: 0,
                bottom: 0
              }), w.css(w.align ? {
                bottom: 0
              } : {
                top: 0
              }), x.append(w));
            } else {
              T.isfixed = "fixed" == T.win.css("position");
              var S = T.isfixed ? "fixed" : "absolute";
              T.isfixed || (T.viewport = T.getViewport(T.win[0])), T.viewport && (T.body = T.viewport, /fixed|absolute/.test(T.viewport.css("position")) || T.css(T.viewport, {
                position: "relative"
              })), u.css({
                position: S
              }), T.zoom && T.zoom.css({
                position: S
              }), T.updateScrollBar(), T.body.append(u), T.zoom && T.body.append(T.zoom), T.railh && (w.css({
                position: S
              }), T.body.append(w));
            }
            P.isios && T.css(T.win, {
              "-webkit-tap-highlight-color": "rgba(0,0,0,0)",
              "-webkit-touch-callout": "none"
            }), M.disableoutline && (P.isie && T.win.attr("hideFocus", "true"), P.iswebkit && T.win.css("outline", "none"));
          }
          if (!1 === M.autohidemode ? (T.autohidedom = !1, T.rail.css({
            opacity: M.cursoropacitymax
          }), T.railh && T.railh.css({
            opacity: M.cursoropacitymax
          })) : !0 === M.autohidemode || "leave" === M.autohidemode ? (T.autohidedom = n().add(T.rail), P.isie8 && (T.autohidedom = T.autohidedom.add(T.cursor)), T.railh && (T.autohidedom = T.autohidedom.add(T.railh)), T.railh && P.isie8 && (T.autohidedom = T.autohidedom.add(T.cursorh))) : "scroll" == M.autohidemode ? (T.autohidedom = n().add(T.rail), T.railh && (T.autohidedom = T.autohidedom.add(T.railh))) : "cursor" == M.autohidemode ? (T.autohidedom = n().add(T.cursor), T.railh && (T.autohidedom = T.autohidedom.add(T.cursorh))) : "hidden" == M.autohidemode && (T.autohidedom = !1, T.hide(), T.railslocked = !1), P.cantouch || T.istouchcapable || M.emulatetouch || P.hasmstouch) {
            T.scrollmom = new y(T);
            T.ontouchstart = function (e) {
              if (T.locked) return !1;
              if (e.pointerType && ("mouse" === e.pointerType || e.pointerType === e.MSPOINTER_TYPE_MOUSE)) return !1;
              if (T.hasmoving = !1, T.scrollmom.timer && (T.triggerScrollEnd(), T.scrollmom.stop()), !T.railslocked) {
                var o = T.getTarget(e);
                if (o && /INPUT/i.test(o.nodeName) && /range/i.test(o.type)) return T.stopPropagation(e);
                var t = "mousedown" === e.type;
                if (!("clientX" in e) && "changedTouches" in e && (e.clientX = e.changedTouches[0].clientX, e.clientY = e.changedTouches[0].clientY), T.forcescreen) {
                  var r = e;
                  (e = {
                    original: e.original ? e.original : e
                  }).clientX = r.screenX, e.clientY = r.screenY;
                }
                if (T.rail.drag = {
                  x: e.clientX,
                  y: e.clientY,
                  sx: T.scroll.x,
                  sy: T.scroll.y,
                  st: T.getScrollTop(),
                  sl: T.getScrollLeft(),
                  pt: 2,
                  dl: !1,
                  tg: o
                }, T.ispage || !M.directionlockdeadzone) T.rail.drag.dl = "f";else {
                  var i = {
                      w: c.width(),
                      h: c.height()
                    },
                    s = T.getContentSize(),
                    l = s.h - i.h,
                    a = s.w - i.w;
                  T.rail.scrollable && !T.railh.scrollable ? T.rail.drag.ck = l > 0 && "v" : !T.rail.scrollable && T.railh.scrollable ? T.rail.drag.ck = a > 0 && "h" : T.rail.drag.ck = !1;
                }
                if (M.emulatetouch && T.isiframe && P.isie) {
                  var d = T.win.position();
                  T.rail.drag.x += d.left, T.rail.drag.y += d.top;
                }
                if (T.hasmoving = !1, T.lastmouseup = !1, T.scrollmom.reset(e.clientX, e.clientY), o && t) {
                  if (!/INPUT|SELECT|BUTTON|TEXTAREA/i.test(o.nodeName)) return P.hasmousecapture && o.setCapture(), M.emulatetouch ? (o.onclick && !o._onclick && (o._onclick = o.onclick, o.onclick = function (e) {
                    if (T.hasmoving) return !1;
                    o._onclick.call(this, e);
                  }), T.cancelEvent(e)) : T.stopPropagation(e);
                  /SUBMIT|CANCEL|BUTTON/i.test(n(o).attr("type")) && (T.preventclick = {
                    tg: o,
                    click: !1
                  });
                }
              }
            }, T.ontouchend = function (e) {
              if (!T.rail.drag) return !0;
              if (2 == T.rail.drag.pt) {
                if (e.pointerType && ("mouse" === e.pointerType || e.pointerType === e.MSPOINTER_TYPE_MOUSE)) return !1;
                T.rail.drag = !1;
                var o = "mouseup" === e.type;
                if (T.hasmoving && (T.scrollmom.doMomentum(), T.lastmouseup = !0, T.hideCursor(), P.hasmousecapture && l.releaseCapture(), o)) return T.cancelEvent(e);
              } else if (1 == T.rail.drag.pt) return T.onmouseup(e);
            };
            var z = M.emulatetouch && T.isiframe && !P.hasmousecapture,
              k = .3 * M.directionlockdeadzone | 0;
            T.ontouchmove = function (e, o) {
              if (!T.rail.drag) return !0;
              if (e.targetTouches && M.preventmultitouchscrolling && e.targetTouches.length > 1) return !0;
              if (e.pointerType && ("mouse" === e.pointerType || e.pointerType === e.MSPOINTER_TYPE_MOUSE)) return !0;
              if (2 == T.rail.drag.pt) {
                "changedTouches" in e && (e.clientX = e.changedTouches[0].clientX, e.clientY = e.changedTouches[0].clientY);
                var t, r;
                if (r = t = 0, z && !o) {
                  var i = T.win.position();
                  r = -i.left, t = -i.top;
                }
                var s = e.clientY + t,
                  n = s - T.rail.drag.y,
                  a = e.clientX + r,
                  c = a - T.rail.drag.x,
                  d = T.rail.drag.st - n;
                if (T.ishwscroll && M.bouncescroll) d < 0 ? d = Math.round(d / 2) : d > T.page.maxh && (d = T.page.maxh + Math.round((d - T.page.maxh) / 2));else if (d < 0 ? (d = 0, s = 0) : d > T.page.maxh && (d = T.page.maxh, s = 0), 0 === s && !T.hasmoving) return T.ispage || (T.rail.drag = !1), !0;
                var u = T.getScrollLeft();
                if (T.railh && T.railh.scrollable && (u = T.isrtlmode ? c - T.rail.drag.sl : T.rail.drag.sl - c, T.ishwscroll && M.bouncescroll ? u < 0 ? u = Math.round(u / 2) : u > T.page.maxw && (u = T.page.maxw + Math.round((u - T.page.maxw) / 2)) : (u < 0 && (u = 0, a = 0), u > T.page.maxw && (u = T.page.maxw, a = 0))), !T.hasmoving) {
                  if (T.rail.drag.y === e.clientY && T.rail.drag.x === e.clientX) return T.cancelEvent(e);
                  var h = Math.abs(n),
                    p = Math.abs(c),
                    m = M.directionlockdeadzone;
                  if (T.rail.drag.ck ? "v" == T.rail.drag.ck ? p > m && h <= k ? T.rail.drag = !1 : h > m && (T.rail.drag.dl = "v") : "h" == T.rail.drag.ck && (h > m && p <= k ? T.rail.drag = !1 : p > m && (T.rail.drag.dl = "h")) : h > m && p > m ? T.rail.drag.dl = "f" : h > m ? T.rail.drag.dl = p > k ? "f" : "v" : p > m && (T.rail.drag.dl = h > k ? "f" : "h"), !T.rail.drag.dl) return T.cancelEvent(e);
                  T.triggerScrollStart(e.clientX, e.clientY, 0, 0, 0), T.hasmoving = !0;
                }
                return T.preventclick && !T.preventclick.click && (T.preventclick.click = T.preventclick.tg.onclick || !1, T.preventclick.tg.onclick = T.onpreventclick), T.rail.drag.dl && ("v" == T.rail.drag.dl ? u = T.rail.drag.sl : "h" == T.rail.drag.dl && (d = T.rail.drag.st)), T.synched("touchmove", function () {
                  T.rail.drag && 2 == T.rail.drag.pt && (T.prepareTransition && T.resetTransition(), T.rail.scrollable && T.setScrollTop(d), T.scrollmom.update(a, s), T.railh && T.railh.scrollable ? (T.setScrollLeft(u), T.showCursor(d, u)) : T.showCursor(d), P.isie10 && l.selection.clear());
                }), T.cancelEvent(e);
              }
              return 1 == T.rail.drag.pt ? T.onmousemove(e) : void 0;
            }, T.ontouchstartCursor = function (e, o) {
              if (!T.rail.drag || 3 == T.rail.drag.pt) {
                if (T.locked) return T.cancelEvent(e);
                T.cancelScroll(), T.rail.drag = {
                  x: e.touches[0].clientX,
                  y: e.touches[0].clientY,
                  sx: T.scroll.x,
                  sy: T.scroll.y,
                  pt: 3,
                  hr: !!o
                };
                var t = T.getTarget(e);
                return !T.ispage && P.hasmousecapture && t.setCapture(), T.isiframe && !P.hasmousecapture && (T.saved.csspointerevents = T.doc.css("pointer-events"), T.css(T.doc, {
                  "pointer-events": "none"
                })), T.cancelEvent(e);
              }
            }, T.ontouchendCursor = function (e) {
              if (T.rail.drag) {
                if (P.hasmousecapture && l.releaseCapture(), T.isiframe && !P.hasmousecapture && T.doc.css("pointer-events", T.saved.csspointerevents), 3 != T.rail.drag.pt) return;
                return T.rail.drag = !1, T.cancelEvent(e);
              }
            }, T.ontouchmoveCursor = function (e) {
              if (T.rail.drag) {
                if (3 != T.rail.drag.pt) return;
                if (T.cursorfreezed = !0, T.rail.drag.hr) {
                  T.scroll.x = T.rail.drag.sx + (e.touches[0].clientX - T.rail.drag.x), T.scroll.x < 0 && (T.scroll.x = 0);
                  var o = T.scrollvaluemaxw;
                  T.scroll.x > o && (T.scroll.x = o);
                } else {
                  T.scroll.y = T.rail.drag.sy + (e.touches[0].clientY - T.rail.drag.y), T.scroll.y < 0 && (T.scroll.y = 0);
                  var t = T.scrollvaluemax;
                  T.scroll.y > t && (T.scroll.y = t);
                }
                return T.synched("touchmove", function () {
                  T.rail.drag && 3 == T.rail.drag.pt && (T.showCursor(), T.rail.drag.hr ? T.doScrollLeft(Math.round(T.scroll.x * T.scrollratio.x), M.cursordragspeed) : T.doScrollTop(Math.round(T.scroll.y * T.scrollratio.y), M.cursordragspeed));
                }), T.cancelEvent(e);
              }
            };
          }
          if (T.onmousedown = function (e, o) {
            if (!T.rail.drag || 1 == T.rail.drag.pt) {
              if (T.railslocked) return T.cancelEvent(e);
              T.cancelScroll(), T.rail.drag = {
                x: e.clientX,
                y: e.clientY,
                sx: T.scroll.x,
                sy: T.scroll.y,
                pt: 1,
                hr: o || !1
              };
              var t = T.getTarget(e);
              return P.hasmousecapture && t.setCapture(), T.isiframe && !P.hasmousecapture && (T.saved.csspointerevents = T.doc.css("pointer-events"), T.css(T.doc, {
                "pointer-events": "none"
              })), T.hasmoving = !1, T.cancelEvent(e);
            }
          }, T.onmouseup = function (e) {
            if (T.rail.drag) return 1 != T.rail.drag.pt || (P.hasmousecapture && l.releaseCapture(), T.isiframe && !P.hasmousecapture && T.doc.css("pointer-events", T.saved.csspointerevents), T.rail.drag = !1, T.cursorfreezed = !1, T.hasmoving && T.triggerScrollEnd(), T.cancelEvent(e));
          }, T.onmousemove = function (e) {
            if (T.rail.drag) {
              if (1 !== T.rail.drag.pt) return;
              if (P.ischrome && 0 === e.which) return T.onmouseup(e);
              if (T.cursorfreezed = !0, T.hasmoving || T.triggerScrollStart(e.clientX, e.clientY, 0, 0, 0), T.hasmoving = !0, T.rail.drag.hr) {
                T.scroll.x = T.rail.drag.sx + (e.clientX - T.rail.drag.x), T.scroll.x < 0 && (T.scroll.x = 0);
                var o = T.scrollvaluemaxw;
                T.scroll.x > o && (T.scroll.x = o);
              } else {
                T.scroll.y = T.rail.drag.sy + (e.clientY - T.rail.drag.y), T.scroll.y < 0 && (T.scroll.y = 0);
                var t = T.scrollvaluemax;
                T.scroll.y > t && (T.scroll.y = t);
              }
              return T.synched("mousemove", function () {
                T.cursorfreezed && (T.showCursor(), T.rail.drag.hr ? T.scrollLeft(Math.round(T.scroll.x * T.scrollratio.x)) : T.scrollTop(Math.round(T.scroll.y * T.scrollratio.y)));
              }), T.cancelEvent(e);
            }
            T.checkarea = 0;
          }, P.cantouch || M.emulatetouch) T.onpreventclick = function (e) {
            if (T.preventclick) return T.preventclick.tg.onclick = T.preventclick.click, T.preventclick = !1, T.cancelEvent(e);
          }, T.onclick = !P.isios && function (e) {
            return !T.lastmouseup || (T.lastmouseup = !1, T.cancelEvent(e));
          }, M.grabcursorenabled && P.cursorgrabvalue && (T.css(T.ispage ? T.doc : T.win, {
            cursor: P.cursorgrabvalue
          }), T.css(T.rail, {
            cursor: P.cursorgrabvalue
          }));else {
            var L = function L(e) {
              if (T.selectiondrag) {
                if (e) {
                  var o = T.win.outerHeight(),
                    t = e.pageY - T.selectiondrag.top;
                  t > 0 && t < o && (t = 0), t >= o && (t -= o), T.selectiondrag.df = t;
                }
                if (0 !== T.selectiondrag.df) {
                  var r = -2 * T.selectiondrag.df / 6 | 0;
                  T.doScrollBy(r), T.debounced("doselectionscroll", function () {
                    L();
                  }, 50);
                }
              }
            };
            T.hasTextSelected = "getSelection" in l ? function () {
              return l.getSelection().rangeCount > 0;
            } : "selection" in l ? function () {
              return "None" != l.selection.type;
            } : function () {
              return !1;
            }, T.onselectionstart = function (e) {
              T.ispage || (T.selectiondrag = T.win.offset());
            }, T.onselectionend = function (e) {
              T.selectiondrag = !1;
            }, T.onselectiondrag = function (e) {
              T.selectiondrag && T.hasTextSelected() && T.debounced("selectionscroll", function () {
                L(e);
              }, 250);
            };
          }
          if (P.hasw3ctouch ? (T.css(T.ispage ? n("html") : T.win, {
            "touch-action": "none"
          }), T.css(T.rail, {
            "touch-action": "none"
          }), T.css(T.cursor, {
            "touch-action": "none"
          }), T.bind(T.win, "pointerdown", T.ontouchstart), T.bind(l, "pointerup", T.ontouchend), T.delegate(l, "pointermove", T.ontouchmove)) : P.hasmstouch ? (T.css(T.ispage ? n("html") : T.win, {
            "-ms-touch-action": "none"
          }), T.css(T.rail, {
            "-ms-touch-action": "none"
          }), T.css(T.cursor, {
            "-ms-touch-action": "none"
          }), T.bind(T.win, "MSPointerDown", T.ontouchstart), T.bind(l, "MSPointerUp", T.ontouchend), T.delegate(l, "MSPointerMove", T.ontouchmove), T.bind(T.cursor, "MSGestureHold", function (e) {
            e.preventDefault();
          }), T.bind(T.cursor, "contextmenu", function (e) {
            e.preventDefault();
          })) : P.cantouch && (T.bind(T.win, "touchstart", T.ontouchstart, !1, !0), T.bind(l, "touchend", T.ontouchend, !1, !0), T.bind(l, "touchcancel", T.ontouchend, !1, !0), T.delegate(l, "touchmove", T.ontouchmove, !1, !0)), M.emulatetouch && (T.bind(T.win, "mousedown", T.ontouchstart, !1, !0), T.bind(l, "mouseup", T.ontouchend, !1, !0), T.bind(l, "mousemove", T.ontouchmove, !1, !0)), (M.cursordragontouch || !P.cantouch && !M.emulatetouch) && (T.rail.css({
            cursor: "default"
          }), T.railh && T.railh.css({
            cursor: "default"
          }), T.jqbind(T.rail, "mouseenter", function () {
            if (!T.ispage && !T.win.is(":visible")) return !1;
            T.canshowonmouseevent && T.showCursor(), T.rail.active = !0;
          }), T.jqbind(T.rail, "mouseleave", function () {
            T.rail.active = !1, T.rail.drag || T.hideCursor();
          }), M.sensitiverail && (T.bind(T.rail, "click", function (e) {
            T.doRailClick(e, !1, !1);
          }), T.bind(T.rail, "dblclick", function (e) {
            T.doRailClick(e, !0, !1);
          }), T.bind(T.cursor, "click", function (e) {
            T.cancelEvent(e);
          }), T.bind(T.cursor, "dblclick", function (e) {
            T.cancelEvent(e);
          })), T.railh && (T.jqbind(T.railh, "mouseenter", function () {
            if (!T.ispage && !T.win.is(":visible")) return !1;
            T.canshowonmouseevent && T.showCursor(), T.rail.active = !0;
          }), T.jqbind(T.railh, "mouseleave", function () {
            T.rail.active = !1, T.rail.drag || T.hideCursor();
          }), M.sensitiverail && (T.bind(T.railh, "click", function (e) {
            T.doRailClick(e, !1, !0);
          }), T.bind(T.railh, "dblclick", function (e) {
            T.doRailClick(e, !0, !0);
          }), T.bind(T.cursorh, "click", function (e) {
            T.cancelEvent(e);
          }), T.bind(T.cursorh, "dblclick", function (e) {
            T.cancelEvent(e);
          })))), M.cursordragontouch && (this.istouchcapable || P.cantouch) && (T.bind(T.cursor, "touchstart", T.ontouchstartCursor), T.bind(T.cursor, "touchmove", T.ontouchmoveCursor), T.bind(T.cursor, "touchend", T.ontouchendCursor), T.cursorh && T.bind(T.cursorh, "touchstart", function (e) {
            T.ontouchstartCursor(e, !0);
          }), T.cursorh && T.bind(T.cursorh, "touchmove", T.ontouchmoveCursor), T.cursorh && T.bind(T.cursorh, "touchend", T.ontouchendCursor)), M.emulatetouch || P.isandroid || P.isios ? (T.bind(P.hasmousecapture ? T.win : l, "mouseup", T.ontouchend), T.onclick && T.bind(l, "click", T.onclick), M.cursordragontouch ? (T.bind(T.cursor, "mousedown", T.onmousedown), T.bind(T.cursor, "mouseup", T.onmouseup), T.cursorh && T.bind(T.cursorh, "mousedown", function (e) {
            T.onmousedown(e, !0);
          }), T.cursorh && T.bind(T.cursorh, "mouseup", T.onmouseup)) : (T.bind(T.rail, "mousedown", function (e) {
            e.preventDefault();
          }), T.railh && T.bind(T.railh, "mousedown", function (e) {
            e.preventDefault();
          }))) : (T.bind(P.hasmousecapture ? T.win : l, "mouseup", T.onmouseup), T.bind(l, "mousemove", T.onmousemove), T.onclick && T.bind(l, "click", T.onclick), T.bind(T.cursor, "mousedown", T.onmousedown), T.bind(T.cursor, "mouseup", T.onmouseup), T.railh && (T.bind(T.cursorh, "mousedown", function (e) {
            T.onmousedown(e, !0);
          }), T.bind(T.cursorh, "mouseup", T.onmouseup)), !T.ispage && M.enablescrollonselection && (T.bind(T.win[0], "mousedown", T.onselectionstart), T.bind(l, "mouseup", T.onselectionend), T.bind(T.cursor, "mouseup", T.onselectionend), T.cursorh && T.bind(T.cursorh, "mouseup", T.onselectionend), T.bind(l, "mousemove", T.onselectiondrag)), T.zoom && (T.jqbind(T.zoom, "mouseenter", function () {
            T.canshowonmouseevent && T.showCursor(), T.rail.active = !0;
          }), T.jqbind(T.zoom, "mouseleave", function () {
            T.rail.active = !1, T.rail.drag || T.hideCursor();
          }))), M.enablemousewheel && (T.isiframe || T.mousewheel(P.isie && T.ispage ? l : T.win, T.onmousewheel), T.mousewheel(T.rail, T.onmousewheel), T.railh && T.mousewheel(T.railh, T.onmousewheelhr)), T.ispage || P.cantouch || /HTML|^BODY/.test(T.win[0].nodeName) || (T.win.attr("tabindex") || T.win.attr({
            tabindex: ++r
          }), T.bind(T.win, "focus", function (e) {
            o = T.getTarget(e).id || T.getTarget(e) || !1, T.hasfocus = !0, T.canshowonmouseevent && T.noticeCursor();
          }), T.bind(T.win, "blur", function (e) {
            o = !1, T.hasfocus = !1;
          }), T.bind(T.win, "mouseenter", function (e) {
            t = T.getTarget(e).id || T.getTarget(e) || !1, T.hasmousefocus = !0, T.canshowonmouseevent && T.noticeCursor();
          }), T.bind(T.win, "mouseleave", function (e) {
            t = !1, T.hasmousefocus = !1, T.rail.drag || T.hideCursor();
          })), T.onkeypress = function (e) {
            if (T.railslocked && 0 === T.page.maxh) return !0;
            e = e || a.event;
            var r = T.getTarget(e);
            if (r && /INPUT|TEXTAREA|SELECT|OPTION/.test(r.nodeName) && (!(r.getAttribute("type") || r.type || !1) || !/submit|button|cancel/i.tp)) return !0;
            if (n(r).attr("contenteditable")) return !0;
            if (T.hasfocus || T.hasmousefocus && !o || T.ispage && !o && !t) {
              var i = e.keyCode;
              if (T.railslocked && 27 != i) return T.cancelEvent(e);
              var s = e.ctrlKey || !1,
                l = e.shiftKey || !1,
                c = !1;
              switch (i) {
                case 38:
                case 63233:
                  T.doScrollBy(72), c = !0;
                  break;
                case 40:
                case 63235:
                  T.doScrollBy(-72), c = !0;
                  break;
                case 37:
                case 63232:
                  T.railh && (s ? T.doScrollLeft(0) : T.doScrollLeftBy(72), c = !0);
                  break;
                case 39:
                case 63234:
                  T.railh && (s ? T.doScrollLeft(T.page.maxw) : T.doScrollLeftBy(-72), c = !0);
                  break;
                case 33:
                case 63276:
                  T.doScrollBy(T.view.h), c = !0;
                  break;
                case 34:
                case 63277:
                  T.doScrollBy(-T.view.h), c = !0;
                  break;
                case 36:
                case 63273:
                  T.railh && s ? T.doScrollPos(0, 0) : T.doScrollTo(0), c = !0;
                  break;
                case 35:
                case 63275:
                  T.railh && s ? T.doScrollPos(T.page.maxw, T.page.maxh) : T.doScrollTo(T.page.maxh), c = !0;
                  break;
                case 32:
                  M.spacebarenabled && (l ? T.doScrollBy(T.view.h) : T.doScrollBy(-T.view.h), c = !0);
                  break;
                case 27:
                  T.zoomactive && (T.doZoom(), c = !0);
              }
              if (c) return T.cancelEvent(e);
            }
          }, M.enablekeyboard && T.bind(l, P.isopera && !P.isopera12 ? "keypress" : "keydown", T.onkeypress), T.bind(l, "keydown", function (e) {
            (e.ctrlKey || !1) && (T.wheelprevented = !0);
          }), T.bind(l, "keyup", function (e) {
            e.ctrlKey || !1 || (T.wheelprevented = !1);
          }), T.bind(a, "blur", function (e) {
            T.wheelprevented = !1;
          }), T.bind(a, "resize", T.onscreenresize), T.bind(a, "orientationchange", T.onscreenresize), T.bind(a, "load", T.lazyResize), P.ischrome && !T.ispage && !T.haswrapper) {
            var C = T.win.attr("style"),
              N = parseFloat(T.win.css("width")) + 1;
            T.win.css("width", N), T.synched("chromefix", function () {
              T.win.attr("style", C);
            });
          }
          if (T.onAttributeChange = function (e) {
            T.lazyResize(T.isieold ? 250 : 30);
          }, M.enableobserver && (T.isie11 || !1 === m || (T.observerbody = new m(function (e) {
            if (e.forEach(function (e) {
              if ("attributes" == e.type) return E.hasClass("modal-open") && E.hasClass("modal-dialog") && !n.contains(n(".modal-dialog")[0], T.doc[0]) ? T.hide() : T.show();
            }), T.me.clientWidth != T.page.width || T.me.clientHeight != T.page.height) return T.lazyResize(30);
          }), T.observerbody.observe(l.body, {
            childList: !0,
            subtree: !0,
            characterData: !1,
            attributes: !0,
            attributeFilter: ["class"]
          })), !T.ispage && !T.haswrapper)) {
            var R = T.win[0];
            !1 !== m ? (T.observer = new m(function (e) {
              e.forEach(T.onAttributeChange);
            }), T.observer.observe(R, {
              childList: !0,
              characterData: !1,
              attributes: !0,
              subtree: !1
            }), T.observerremover = new m(function (e) {
              e.forEach(function (e) {
                if (e.removedNodes.length > 0) for (var o in e.removedNodes) {
                  if (T && e.removedNodes[o] === R) return T.remove();
                }
              });
            }), T.observerremover.observe(R.parentNode, {
              childList: !0,
              characterData: !1,
              attributes: !1,
              subtree: !1
            })) : (T.bind(R, P.isie && !P.isie9 ? "propertychange" : "DOMAttrModified", T.onAttributeChange), P.isie9 && R.attachEvent("onpropertychange", T.onAttributeChange), T.bind(R, "DOMNodeRemoved", function (e) {
              e.target === R && T.remove();
            }));
          }
          !T.ispage && M.boxzoom && T.bind(a, "resize", T.resizeZoom), T.istextarea && (T.bind(T.win, "keydown", T.lazyResize), T.bind(T.win, "mouseup", T.lazyResize)), T.lazyResize(30);
        }
        if ("IFRAME" == this.doc[0].nodeName) {
          var _ = function _() {
            T.iframexd = !1;
            var o;
            try {
              (o = "contentDocument" in this ? this.contentDocument : this.contentWindow._doc).domain;
            } catch (e) {
              T.iframexd = !0, o = !1;
            }
            if (T.iframexd) return "console" in a && console.log("NiceScroll error: policy restriced iframe"), !0;
            if (T.forcescreen = !0, T.isiframe && (T.iframe = {
              doc: n(o),
              html: T.doc.contents().find("html")[0],
              body: T.doc.contents().find("body")[0]
            }, T.getContentSize = function () {
              return {
                w: Math.max(T.iframe.html.scrollWidth, T.iframe.body.scrollWidth),
                h: Math.max(T.iframe.html.scrollHeight, T.iframe.body.scrollHeight)
              };
            }, T.docscroll = n(T.iframe.body)), !P.isios && M.iframeautoresize && !T.isiframe) {
              T.win.scrollTop(0), T.doc.height("");
              var t = Math.max(o.getElementsByTagName("html")[0].scrollHeight, o.body.scrollHeight);
              T.doc.height(t);
            }
            T.lazyResize(30), T.css(n(T.iframe.body), e), P.isios && T.haswrapper && T.css(n(o.body), {
              "-webkit-transform": "translate3d(0,0,0)"
            }), "contentWindow" in this ? T.bind(this.contentWindow, "scroll", T.onscroll) : T.bind(o, "scroll", T.onscroll), M.enablemousewheel && T.mousewheel(o, T.onmousewheel), M.enablekeyboard && T.bind(o, P.isopera ? "keypress" : "keydown", T.onkeypress), P.cantouch ? (T.bind(o, "touchstart", T.ontouchstart), T.bind(o, "touchmove", T.ontouchmove)) : M.emulatetouch && (T.bind(o, "mousedown", T.ontouchstart), T.bind(o, "mousemove", function (e) {
              return T.ontouchmove(e, !0);
            }), M.grabcursorenabled && P.cursorgrabvalue && T.css(n(o.body), {
              cursor: P.cursorgrabvalue
            })), T.bind(o, "mouseup", T.ontouchend), T.zoom && (M.dblclickzoom && T.bind(o, "dblclick", T.doZoom), T.ongesturezoom && T.bind(o, "gestureend", T.ongesturezoom));
          };
          this.doc[0].readyState && "complete" === this.doc[0].readyState && setTimeout(function () {
            _.call(T.doc[0], !1);
          }, 500), T.bind(this.doc, "load", _);
        }
      }, this.showCursor = function (e, o) {
        if (T.cursortimeout && (clearTimeout(T.cursortimeout), T.cursortimeout = 0), T.rail) {
          if (T.autohidedom && (T.autohidedom.stop().css({
            opacity: M.cursoropacitymax
          }), T.cursoractive = !0), T.rail.drag && 1 == T.rail.drag.pt || (void 0 !== e && !1 !== e && (T.scroll.y = e / T.scrollratio.y | 0), void 0 !== o && (T.scroll.x = o / T.scrollratio.x | 0)), T.cursor.css({
            height: T.cursorheight,
            top: T.scroll.y
          }), T.cursorh) {
            var t = T.hasreversehr ? T.scrollvaluemaxw - T.scroll.x : T.scroll.x;
            T.cursorh.css({
              width: T.cursorwidth,
              left: !T.rail.align && T.rail.visibility ? t + T.rail.width : t
            }), T.cursoractive = !0;
          }
          T.zoom && T.zoom.stop().css({
            opacity: M.cursoropacitymax
          });
        }
      }, this.hideCursor = function (e) {
        T.cursortimeout || T.rail && T.autohidedom && (T.hasmousefocus && "leave" === M.autohidemode || (T.cursortimeout = setTimeout(function () {
          T.rail.active && T.showonmouseevent || (T.autohidedom.stop().animate({
            opacity: M.cursoropacitymin
          }), T.zoom && T.zoom.stop().animate({
            opacity: M.cursoropacitymin
          }), T.cursoractive = !1), T.cursortimeout = 0;
        }, e || M.hidecursordelay)));
      }, this.noticeCursor = function (e, o, t) {
        T.showCursor(o, t), T.rail.active || T.hideCursor(e);
      }, this.getContentSize = T.ispage ? function () {
        return {
          w: Math.max(l.body.scrollWidth, l.documentElement.scrollWidth),
          h: Math.max(l.body.scrollHeight, l.documentElement.scrollHeight)
        };
      } : T.haswrapper ? function () {
        return {
          w: T.doc[0].offsetWidth,
          h: T.doc[0].offsetHeight
        };
      } : function () {
        return {
          w: T.docscroll[0].scrollWidth,
          h: T.docscroll[0].scrollHeight
        };
      }, this.onResize = function (e, o) {
        if (!T || !T.win) return !1;
        var t = T.page.maxh,
          r = T.page.maxw,
          i = T.view.h,
          s = T.view.w;
        if (T.view = {
          w: T.ispage ? T.win.width() : T.win[0].clientWidth,
          h: T.ispage ? T.win.height() : T.win[0].clientHeight
        }, T.page = o || T.getContentSize(), T.page.maxh = Math.max(0, T.page.h - T.view.h), T.page.maxw = Math.max(0, T.page.w - T.view.w), T.page.maxh == t && T.page.maxw == r && T.view.w == s && T.view.h == i) {
          if (T.ispage) return T;
          var n = T.win.offset();
          if (T.lastposition) {
            var l = T.lastposition;
            if (l.top == n.top && l.left == n.left) return T;
          }
          T.lastposition = n;
        }
        return 0 === T.page.maxh ? (T.hideRail(), T.scrollvaluemax = 0, T.scroll.y = 0, T.scrollratio.y = 0, T.cursorheight = 0, T.setScrollTop(0), T.rail && (T.rail.scrollable = !1)) : (T.page.maxh -= M.railpadding.top + M.railpadding.bottom, T.rail.scrollable = !0), 0 === T.page.maxw ? (T.hideRailHr(), T.scrollvaluemaxw = 0, T.scroll.x = 0, T.scrollratio.x = 0, T.cursorwidth = 0, T.setScrollLeft(0), T.railh && (T.railh.scrollable = !1)) : (T.page.maxw -= M.railpadding.left + M.railpadding.right, T.railh && (T.railh.scrollable = M.horizrailenabled)), T.railslocked = T.locked || 0 === T.page.maxh && 0 === T.page.maxw, T.railslocked ? (T.ispage || T.updateScrollBar(T.view), !1) : (T.hidden || (T.rail.visibility || T.showRail(), T.railh && !T.railh.visibility && T.showRailHr()), T.istextarea && T.win.css("resize") && "none" != T.win.css("resize") && (T.view.h -= 20), T.cursorheight = Math.min(T.view.h, Math.round(T.view.h * (T.view.h / T.page.h))), T.cursorheight = M.cursorfixedheight ? M.cursorfixedheight : Math.max(M.cursorminheight, T.cursorheight), T.cursorwidth = Math.min(T.view.w, Math.round(T.view.w * (T.view.w / T.page.w))), T.cursorwidth = M.cursorfixedheight ? M.cursorfixedheight : Math.max(M.cursorminheight, T.cursorwidth), T.scrollvaluemax = T.view.h - T.cursorheight - (M.railpadding.top + M.railpadding.bottom), T.hasborderbox || (T.scrollvaluemax -= T.cursor[0].offsetHeight - T.cursor[0].clientHeight), T.railh && (T.railh.width = T.page.maxh > 0 ? T.view.w - T.rail.width : T.view.w, T.scrollvaluemaxw = T.railh.width - T.cursorwidth - (M.railpadding.left + M.railpadding.right)), T.ispage || T.updateScrollBar(T.view), T.scrollratio = {
          x: T.page.maxw / T.scrollvaluemaxw,
          y: T.page.maxh / T.scrollvaluemax
        }, T.getScrollTop() > T.page.maxh ? T.doScrollTop(T.page.maxh) : (T.scroll.y = T.getScrollTop() / T.scrollratio.y | 0, T.scroll.x = T.getScrollLeft() / T.scrollratio.x | 0, T.cursoractive && T.noticeCursor()), T.scroll.y && 0 === T.getScrollTop() && T.doScrollTo(T.scroll.y * T.scrollratio.y | 0), T);
      }, this.resize = T.onResize;
      var O = 0;
      this.onscreenresize = function (e) {
        clearTimeout(O);
        var o = !T.ispage && !T.haswrapper;
        o && T.hideRails(), O = setTimeout(function () {
          T && (o && T.showRails(), T.resize()), O = 0;
        }, 120);
      }, this.lazyResize = function (e) {
        return clearTimeout(O), e = isNaN(e) ? 240 : e, O = setTimeout(function () {
          T && T.resize(), O = 0;
        }, e), T;
      }, this.jqbind = function (e, o, t) {
        T.events.push({
          e: e,
          n: o,
          f: t,
          q: !0
        }), n(e).on(o, t);
      }, this.mousewheel = function (e, o, t) {
        var r = "jquery" in e ? e[0] : e;
        if ("onwheel" in l.createElement("div")) T._bind(r, "wheel", o, t || !1);else {
          var i = void 0 !== l.onmousewheel ? "mousewheel" : "DOMMouseScroll";
          S(r, i, o, t || !1), "DOMMouseScroll" == i && S(r, "MozMousePixelScroll", o, t || !1);
        }
      };
      var Y = !1;
      if (P.haseventlistener) {
        try {
          var H = Object.defineProperty({}, "passive", {
            get: function get() {
              Y = !0;
            }
          });
          a.addEventListener("test", null, H);
        } catch (e) {}
        this.stopPropagation = function (e) {
          return !!e && ((e = e.original ? e.original : e).stopPropagation(), !1);
        }, this.cancelEvent = function (e) {
          return e.cancelable && e.preventDefault(), e.stopImmediatePropagation(), e.preventManipulation && e.preventManipulation(), !1;
        };
      } else Event.prototype.preventDefault = function () {
        this.returnValue = !1;
      }, Event.prototype.stopPropagation = function () {
        this.cancelBubble = !0;
      }, a.constructor.prototype.addEventListener = l.constructor.prototype.addEventListener = Element.prototype.addEventListener = function (e, o, t) {
        this.attachEvent("on" + e, o);
      }, a.constructor.prototype.removeEventListener = l.constructor.prototype.removeEventListener = Element.prototype.removeEventListener = function (e, o, t) {
        this.detachEvent("on" + e, o);
      }, this.cancelEvent = function (e) {
        return (e = e || a.event) && (e.cancelBubble = !0, e.cancel = !0, e.returnValue = !1), !1;
      }, this.stopPropagation = function (e) {
        return (e = e || a.event) && (e.cancelBubble = !0), !1;
      };
      this.delegate = function (e, o, t, r, i) {
        var s = d[o] || !1;
        s || (s = {
          a: [],
          l: [],
          f: function f(e) {
            for (var o = s.l, t = !1, r = o.length - 1; r >= 0; r--) {
              if (!1 === (t = o[r].call(e.target, e))) return !1;
            }
            return t;
          }
        }, T.bind(e, o, s.f, r, i), d[o] = s), T.ispage ? (s.a = [T.id].concat(s.a), s.l = [t].concat(s.l)) : (s.a.push(T.id), s.l.push(t));
      }, this.undelegate = function (e, o, t, r, i) {
        var s = d[o] || !1;
        if (s && s.l) for (var n = 0, l = s.l.length; n < l; n++) {
          s.a[n] === T.id && (s.a.splice(n), s.l.splice(n), 0 === s.a.length && (T._unbind(e, o, s.l.f), d[o] = null));
        }
      }, this.bind = function (e, o, t, r, i) {
        var s = "jquery" in e ? e[0] : e;
        T._bind(s, o, t, r || !1, i || !1);
      }, this._bind = function (e, o, t, r, i) {
        T.events.push({
          e: e,
          n: o,
          f: t,
          b: r,
          q: !1
        }), Y && i ? e.addEventListener(o, t, {
          passive: !1,
          capture: r
        }) : e.addEventListener(o, t, r || !1);
      }, this._unbind = function (e, o, t, r) {
        d[o] ? T.undelegate(e, o, t, r) : e.removeEventListener(o, t, r);
      }, this.unbindAll = function () {
        for (var e = 0; e < T.events.length; e++) {
          var o = T.events[e];
          o.q ? o.e.unbind(o.n, o.f) : T._unbind(o.e, o.n, o.f, o.b);
        }
      }, this.showRails = function () {
        return T.showRail().showRailHr();
      }, this.showRail = function () {
        return 0 === T.page.maxh || !T.ispage && "none" == T.win.css("display") || (T.rail.visibility = !0, T.rail.css("display", "block")), T;
      }, this.showRailHr = function () {
        return T.railh && (0 === T.page.maxw || !T.ispage && "none" == T.win.css("display") || (T.railh.visibility = !0, T.railh.css("display", "block"))), T;
      }, this.hideRails = function () {
        return T.hideRail().hideRailHr();
      }, this.hideRail = function () {
        return T.rail.visibility = !1, T.rail.css("display", "none"), T;
      }, this.hideRailHr = function () {
        return T.railh && (T.railh.visibility = !1, T.railh.css("display", "none")), T;
      }, this.show = function () {
        return T.hidden = !1, T.railslocked = !1, T.showRails();
      }, this.hide = function () {
        return T.hidden = !0, T.railslocked = !0, T.hideRails();
      }, this.toggle = function () {
        return T.hidden ? T.show() : T.hide();
      }, this.remove = function () {
        T.stop(), T.cursortimeout && clearTimeout(T.cursortimeout);
        for (var e in T.delaylist) {
          T.delaylist[e] && h(T.delaylist[e].h);
        }
        T.doZoomOut(), T.unbindAll(), P.isie9 && T.win[0].detachEvent("onpropertychange", T.onAttributeChange), !1 !== T.observer && T.observer.disconnect(), !1 !== T.observerremover && T.observerremover.disconnect(), !1 !== T.observerbody && T.observerbody.disconnect(), T.events = null, T.cursor && T.cursor.remove(), T.cursorh && T.cursorh.remove(), T.rail && T.rail.remove(), T.railh && T.railh.remove(), T.zoom && T.zoom.remove();
        for (var o = 0; o < T.saved.css.length; o++) {
          var t = T.saved.css[o];
          t[0].css(t[1], void 0 === t[2] ? "" : t[2]);
        }
        T.saved = !1, T.me.data("__nicescroll", "");
        var r = n.nicescroll;
        r.each(function (e) {
          if (this && this.id === T.id) {
            delete r[e];
            for (var o = ++e; o < r.length; o++, e++) {
              r[e] = r[o];
            }
            --r.length && delete r[r.length];
          }
        });
        for (var i in T) {
          T[i] = null, delete T[i];
        }
        T = null;
      }, this.scrollstart = function (e) {
        return this.onscrollstart = e, T;
      }, this.scrollend = function (e) {
        return this.onscrollend = e, T;
      }, this.scrollcancel = function (e) {
        return this.onscrollcancel = e, T;
      }, this.zoomin = function (e) {
        return this.onzoomin = e, T;
      }, this.zoomout = function (e) {
        return this.onzoomout = e, T;
      }, this.isScrollable = function (e) {
        var o = e.target ? e.target : e;
        if ("OPTION" == o.nodeName) return !0;
        for (; o && 1 == o.nodeType && o !== this.me[0] && !/^BODY|HTML/.test(o.nodeName);) {
          var t = n(o),
            r = t.css("overflowY") || t.css("overflowX") || t.css("overflow") || "";
          if (/scroll|auto/.test(r)) return o.clientHeight != o.scrollHeight;
          o = !!o.parentNode && o.parentNode;
        }
        return !1;
      }, this.getViewport = function (e) {
        for (var o = !(!e || !e.parentNode) && e.parentNode; o && 1 == o.nodeType && !/^BODY|HTML/.test(o.nodeName);) {
          var t = n(o);
          if (/fixed|absolute/.test(t.css("position"))) return t;
          var r = t.css("overflowY") || t.css("overflowX") || t.css("overflow") || "";
          if (/scroll|auto/.test(r) && o.clientHeight != o.scrollHeight) return t;
          if (t.getNiceScroll().length > 0) return t;
          o = !!o.parentNode && o.parentNode;
        }
        return !1;
      }, this.triggerScrollStart = function (e, o, t, r, i) {
        if (T.onscrollstart) {
          var s = {
            type: "scrollstart",
            current: {
              x: e,
              y: o
            },
            request: {
              x: t,
              y: r
            },
            end: {
              x: T.newscrollx,
              y: T.newscrolly
            },
            speed: i
          };
          T.onscrollstart.call(T, s);
        }
      }, this.triggerScrollEnd = function () {
        if (T.onscrollend) {
          var e = T.getScrollLeft(),
            o = T.getScrollTop(),
            t = {
              type: "scrollend",
              current: {
                x: e,
                y: o
              },
              end: {
                x: e,
                y: o
              }
            };
          T.onscrollend.call(T, t);
        }
      };
      var B = 0,
        X = 0,
        D = 0,
        A = 1,
        q = !1;
      if (this.onmousewheel = function (e) {
        if (T.wheelprevented || T.locked) return !1;
        if (T.railslocked) return T.debounced("checkunlock", T.resize, 250), !1;
        if (T.rail.drag) return T.cancelEvent(e);
        if ("auto" === M.oneaxismousemode && 0 !== e.deltaX && (M.oneaxismousemode = !1), M.oneaxismousemode && 0 === e.deltaX && !T.rail.scrollable) return !T.railh || !T.railh.scrollable || T.onmousewheelhr(e);
        var o = f(),
          t = !1;
        if (M.preservenativescrolling && T.checkarea + 600 < o && (T.nativescrollingarea = T.isScrollable(e), t = !0), T.checkarea = o, T.nativescrollingarea) return !0;
        var r = k(e, !1, t);
        return r && (T.checkarea = 0), r;
      }, this.onmousewheelhr = function (e) {
        if (!T.wheelprevented) {
          if (T.railslocked || !T.railh.scrollable) return !0;
          if (T.rail.drag) return T.cancelEvent(e);
          var o = f(),
            t = !1;
          return M.preservenativescrolling && T.checkarea + 600 < o && (T.nativescrollingarea = T.isScrollable(e), t = !0), T.checkarea = o, !!T.nativescrollingarea || (T.railslocked ? T.cancelEvent(e) : k(e, !0, t));
        }
      }, this.stop = function () {
        return T.cancelScroll(), T.scrollmon && T.scrollmon.stop(), T.cursorfreezed = !1, T.scroll.y = Math.round(T.getScrollTop() * (1 / T.scrollratio.y)), T.noticeCursor(), T;
      }, this.getTransitionSpeed = function (e) {
        return 80 + e / 72 * M.scrollspeed | 0;
      }, M.smoothscroll) {
        if (T.ishwscroll && P.hastransition && M.usetransition && M.smoothscroll) {
          var j = "";
          this.resetTransition = function () {
            j = "", T.doc.css(P.prefixstyle + "transition-duration", "0ms");
          }, this.prepareTransition = function (e, o) {
            var t = o ? e : T.getTransitionSpeed(e),
              r = t + "ms";
            return j !== r && (j = r, T.doc.css(P.prefixstyle + "transition-duration", r)), t;
          }, this.doScrollLeft = function (e, o) {
            var t = T.scrollrunning ? T.newscrolly : T.getScrollTop();
            T.doScrollPos(e, t, o);
          }, this.doScrollTop = function (e, o) {
            var t = T.scrollrunning ? T.newscrollx : T.getScrollLeft();
            T.doScrollPos(t, e, o);
          }, this.cursorupdate = {
            running: !1,
            start: function start() {
              var e = this;
              if (!e.running) {
                e.running = !0;
                var o = function o() {
                  e.running && u(o), T.showCursor(T.getScrollTop(), T.getScrollLeft()), T.notifyScrollEvent(T.win[0]);
                };
                u(o);
              }
            },
            stop: function stop() {
              this.running = !1;
            }
          }, this.doScrollPos = function (e, o, t) {
            var r = T.getScrollTop(),
              i = T.getScrollLeft();
            if (((T.newscrolly - r) * (o - r) < 0 || (T.newscrollx - i) * (e - i) < 0) && T.cancelScroll(), M.bouncescroll ? (o < 0 ? o = o / 2 | 0 : o > T.page.maxh && (o = T.page.maxh + (o - T.page.maxh) / 2 | 0), e < 0 ? e = e / 2 | 0 : e > T.page.maxw && (e = T.page.maxw + (e - T.page.maxw) / 2 | 0)) : (o < 0 ? o = 0 : o > T.page.maxh && (o = T.page.maxh), e < 0 ? e = 0 : e > T.page.maxw && (e = T.page.maxw)), T.scrollrunning && e == T.newscrollx && o == T.newscrolly) return !1;
            T.newscrolly = o, T.newscrollx = e;
            var s = T.getScrollTop(),
              n = T.getScrollLeft(),
              l = {};
            l.x = e - n, l.y = o - s;
            var a = 0 | Math.sqrt(l.x * l.x + l.y * l.y),
              c = T.prepareTransition(a);
            T.scrollrunning || (T.scrollrunning = !0, T.triggerScrollStart(n, s, e, o, c), T.cursorupdate.start()), T.scrollendtrapped = !0, P.transitionend || (T.scrollendtrapped && clearTimeout(T.scrollendtrapped), T.scrollendtrapped = setTimeout(T.onScrollTransitionEnd, c)), T.setScrollTop(T.newscrolly), T.setScrollLeft(T.newscrollx);
          }, this.cancelScroll = function () {
            if (!T.scrollendtrapped) return !0;
            var e = T.getScrollTop(),
              o = T.getScrollLeft();
            return T.scrollrunning = !1, P.transitionend || clearTimeout(P.transitionend), T.scrollendtrapped = !1, T.resetTransition(), T.setScrollTop(e), T.railh && T.setScrollLeft(o), T.timerscroll && T.timerscroll.tm && clearInterval(T.timerscroll.tm), T.timerscroll = !1, T.cursorfreezed = !1, T.cursorupdate.stop(), T.showCursor(e, o), T;
          }, this.onScrollTransitionEnd = function () {
            if (T.scrollendtrapped) {
              var e = T.getScrollTop(),
                o = T.getScrollLeft();
              if (e < 0 ? e = 0 : e > T.page.maxh && (e = T.page.maxh), o < 0 ? o = 0 : o > T.page.maxw && (o = T.page.maxw), e != T.newscrolly || o != T.newscrollx) return T.doScrollPos(o, e, M.snapbackspeed);
              T.scrollrunning && T.triggerScrollEnd(), T.scrollrunning = !1, T.scrollendtrapped = !1, T.resetTransition(), T.timerscroll = !1, T.setScrollTop(e), T.railh && T.setScrollLeft(o), T.cursorupdate.stop(), T.noticeCursor(!1, e, o), T.cursorfreezed = !1;
            }
          };
        } else this.doScrollLeft = function (e, o) {
          var t = T.scrollrunning ? T.newscrolly : T.getScrollTop();
          T.doScrollPos(e, t, o);
        }, this.doScrollTop = function (e, o) {
          var t = T.scrollrunning ? T.newscrollx : T.getScrollLeft();
          T.doScrollPos(t, e, o);
        }, this.doScrollPos = function (e, o, t) {
          var r = T.getScrollTop(),
            i = T.getScrollLeft();
          ((T.newscrolly - r) * (o - r) < 0 || (T.newscrollx - i) * (e - i) < 0) && T.cancelScroll();
          var s = !1;
          if (T.bouncescroll && T.rail.visibility || (o < 0 ? (o = 0, s = !0) : o > T.page.maxh && (o = T.page.maxh, s = !0)), T.bouncescroll && T.railh.visibility || (e < 0 ? (e = 0, s = !0) : e > T.page.maxw && (e = T.page.maxw, s = !0)), T.scrollrunning && T.newscrolly === o && T.newscrollx === e) return !0;
          T.newscrolly = o, T.newscrollx = e, T.dst = {}, T.dst.x = e - i, T.dst.y = o - r, T.dst.px = i, T.dst.py = r;
          var n = 0 | Math.sqrt(T.dst.x * T.dst.x + T.dst.y * T.dst.y),
            l = T.getTransitionSpeed(n);
          T.bzscroll = {};
          var a = s ? 1 : .58;
          T.bzscroll.x = new R(i, T.newscrollx, l, 0, 0, a, 1), T.bzscroll.y = new R(r, T.newscrolly, l, 0, 0, a, 1);
          f();
          var c = function c() {
            if (T.scrollrunning) {
              var e = T.bzscroll.y.getPos();
              T.setScrollLeft(T.bzscroll.x.getNow()), T.setScrollTop(T.bzscroll.y.getNow()), e <= 1 ? T.timer = u(c) : (T.scrollrunning = !1, T.timer = 0, T.triggerScrollEnd());
            }
          };
          T.scrollrunning || (T.triggerScrollStart(i, r, e, o, l), T.scrollrunning = !0, T.timer = u(c));
        }, this.cancelScroll = function () {
          return T.timer && h(T.timer), T.timer = 0, T.bzscroll = !1, T.scrollrunning = !1, T;
        };
      } else this.doScrollLeft = function (e, o) {
        var t = T.getScrollTop();
        T.doScrollPos(e, t, o);
      }, this.doScrollTop = function (e, o) {
        var t = T.getScrollLeft();
        T.doScrollPos(t, e, o);
      }, this.doScrollPos = function (e, o, t) {
        var r = e > T.page.maxw ? T.page.maxw : e;
        r < 0 && (r = 0);
        var i = o > T.page.maxh ? T.page.maxh : o;
        i < 0 && (i = 0), T.synched("scroll", function () {
          T.setScrollTop(i), T.setScrollLeft(r);
        });
      }, this.cancelScroll = function () {};
      this.doScrollBy = function (e, o) {
        z(0, e);
      }, this.doScrollLeftBy = function (e, o) {
        z(e, 0);
      }, this.doScrollTo = function (e, o) {
        var t = o ? Math.round(e * T.scrollratio.y) : e;
        t < 0 ? t = 0 : t > T.page.maxh && (t = T.page.maxh), T.cursorfreezed = !1, T.doScrollTop(e);
      }, this.checkContentSize = function () {
        var e = T.getContentSize();
        e.h == T.page.h && e.w == T.page.w || T.resize(!1, e);
      }, T.onscroll = function (e) {
        T.rail.drag || T.cursorfreezed || T.synched("scroll", function () {
          T.scroll.y = Math.round(T.getScrollTop() / T.scrollratio.y), T.railh && (T.scroll.x = Math.round(T.getScrollLeft() / T.scrollratio.x)), T.noticeCursor();
        });
      }, T.bind(T.docscroll, "scroll", T.onscroll), this.doZoomIn = function (e) {
        if (!T.zoomactive) {
          T.zoomactive = !0, T.zoomrestore = {
            style: {}
          };
          var o = ["position", "top", "left", "zIndex", "backgroundColor", "marginTop", "marginBottom", "marginLeft", "marginRight"],
            t = T.win[0].style;
          for (var r in o) {
            var i = o[r];
            T.zoomrestore.style[i] = void 0 !== t[i] ? t[i] : "";
          }
          T.zoomrestore.style.width = T.win.css("width"), T.zoomrestore.style.height = T.win.css("height"), T.zoomrestore.padding = {
            w: T.win.outerWidth() - T.win.width(),
            h: T.win.outerHeight() - T.win.height()
          }, P.isios4 && (T.zoomrestore.scrollTop = c.scrollTop(), c.scrollTop(0)), T.win.css({
            position: P.isios4 ? "absolute" : "fixed",
            top: 0,
            left: 0,
            zIndex: s + 100,
            margin: 0
          });
          var n = T.win.css("backgroundColor");
          return ("" === n || /transparent|rgba\(0, 0, 0, 0\)|rgba\(0,0,0,0\)/.test(n)) && T.win.css("backgroundColor", "#fff"), T.rail.css({
            zIndex: s + 101
          }), T.zoom.css({
            zIndex: s + 102
          }), T.zoom.css("backgroundPosition", "0 -18px"), T.resizeZoom(), T.onzoomin && T.onzoomin.call(T), T.cancelEvent(e);
        }
      }, this.doZoomOut = function (e) {
        if (T.zoomactive) return T.zoomactive = !1, T.win.css("margin", ""), T.win.css(T.zoomrestore.style), P.isios4 && c.scrollTop(T.zoomrestore.scrollTop), T.rail.css({
          "z-index": T.zindex
        }), T.zoom.css({
          "z-index": T.zindex
        }), T.zoomrestore = !1, T.zoom.css("backgroundPosition", "0 0"), T.onResize(), T.onzoomout && T.onzoomout.call(T), T.cancelEvent(e);
      }, this.doZoom = function (e) {
        return T.zoomactive ? T.doZoomOut(e) : T.doZoomIn(e);
      }, this.resizeZoom = function () {
        if (T.zoomactive) {
          var e = T.getScrollTop();
          T.win.css({
            width: c.width() - T.zoomrestore.padding.w + "px",
            height: c.height() - T.zoomrestore.padding.h + "px"
          }), T.onResize(), T.setScrollTop(Math.min(T.page.maxh, e));
        }
      }, this.init(), n.nicescroll.push(this);
    },
    y = function y(e) {
      var o = this;
      this.nc = e, this.lastx = 0, this.lasty = 0, this.speedx = 0, this.speedy = 0, this.lasttime = 0, this.steptime = 0, this.snapx = !1, this.snapy = !1, this.demulx = 0, this.demuly = 0, this.lastscrollx = -1, this.lastscrolly = -1, this.chkx = 0, this.chky = 0, this.timer = 0, this.reset = function (e, t) {
        o.stop(), o.steptime = 0, o.lasttime = f(), o.speedx = 0, o.speedy = 0, o.lastx = e, o.lasty = t, o.lastscrollx = -1, o.lastscrolly = -1;
      }, this.update = function (e, t) {
        var r = f();
        o.steptime = r - o.lasttime, o.lasttime = r;
        var i = t - o.lasty,
          s = e - o.lastx,
          n = o.nc.getScrollTop() + i,
          l = o.nc.getScrollLeft() + s;
        o.snapx = l < 0 || l > o.nc.page.maxw, o.snapy = n < 0 || n > o.nc.page.maxh, o.speedx = s, o.speedy = i, o.lastx = e, o.lasty = t;
      }, this.stop = function () {
        o.nc.unsynched("domomentum2d"), o.timer && clearTimeout(o.timer), o.timer = 0, o.lastscrollx = -1, o.lastscrolly = -1;
      }, this.doSnapy = function (e, t) {
        var r = !1;
        t < 0 ? (t = 0, r = !0) : t > o.nc.page.maxh && (t = o.nc.page.maxh, r = !0), e < 0 ? (e = 0, r = !0) : e > o.nc.page.maxw && (e = o.nc.page.maxw, r = !0), r ? o.nc.doScrollPos(e, t, o.nc.opt.snapbackspeed) : o.nc.triggerScrollEnd();
      }, this.doMomentum = function (e) {
        var t = f(),
          r = e ? t + e : o.lasttime,
          i = o.nc.getScrollLeft(),
          s = o.nc.getScrollTop(),
          n = o.nc.page.maxh,
          l = o.nc.page.maxw;
        o.speedx = l > 0 ? Math.min(60, o.speedx) : 0, o.speedy = n > 0 ? Math.min(60, o.speedy) : 0;
        var a = r && t - r <= 60;
        (s < 0 || s > n || i < 0 || i > l) && (a = !1);
        var c = !(!o.speedy || !a) && o.speedy,
          d = !(!o.speedx || !a) && o.speedx;
        if (c || d) {
          var u = Math.max(16, o.steptime);
          if (u > 50) {
            var h = u / 50;
            o.speedx *= h, o.speedy *= h, u = 50;
          }
          o.demulxy = 0, o.lastscrollx = o.nc.getScrollLeft(), o.chkx = o.lastscrollx, o.lastscrolly = o.nc.getScrollTop(), o.chky = o.lastscrolly;
          var p = o.lastscrollx,
            m = o.lastscrolly,
            g = function g() {
              var e = f() - t > 600 ? .04 : .02;
              o.speedx && (p = Math.floor(o.lastscrollx - o.speedx * (1 - o.demulxy)), o.lastscrollx = p, (p < 0 || p > l) && (e = .1)), o.speedy && (m = Math.floor(o.lastscrolly - o.speedy * (1 - o.demulxy)), o.lastscrolly = m, (m < 0 || m > n) && (e = .1)), o.demulxy = Math.min(1, o.demulxy + e), o.nc.synched("domomentum2d", function () {
                if (o.speedx) {
                  o.nc.getScrollLeft();
                  o.chkx = p, o.nc.setScrollLeft(p);
                }
                if (o.speedy) {
                  o.nc.getScrollTop();
                  o.chky = m, o.nc.setScrollTop(m);
                }
                o.timer || (o.nc.hideCursor(), o.doSnapy(p, m));
              }), o.demulxy < 1 ? o.timer = setTimeout(g, u) : (o.stop(), o.nc.hideCursor(), o.doSnapy(p, m));
            };
          g();
        } else o.doSnapy(o.nc.getScrollLeft(), o.nc.getScrollTop());
      };
    },
    x = e.fn.scrollTop;
  e.cssHooks.pageYOffset = {
    get: function get(e, o, t) {
      var r = n.data(e, "__nicescroll") || !1;
      return r && r.ishwscroll ? r.getScrollTop() : x.call(e);
    },
    set: function set(e, o) {
      var t = n.data(e, "__nicescroll") || !1;
      return t && t.ishwscroll ? t.setScrollTop(parseInt(o)) : x.call(e, o), this;
    }
  }, e.fn.scrollTop = function (e) {
    if (void 0 === e) {
      var o = !!this[0] && (n.data(this[0], "__nicescroll") || !1);
      return o && o.ishwscroll ? o.getScrollTop() : x.call(this);
    }
    return this.each(function () {
      var o = n.data(this, "__nicescroll") || !1;
      o && o.ishwscroll ? o.setScrollTop(parseInt(e)) : x.call(n(this), e);
    });
  };
  var S = e.fn.scrollLeft;
  n.cssHooks.pageXOffset = {
    get: function get(e, o, t) {
      var r = n.data(e, "__nicescroll") || !1;
      return r && r.ishwscroll ? r.getScrollLeft() : S.call(e);
    },
    set: function set(e, o) {
      var t = n.data(e, "__nicescroll") || !1;
      return t && t.ishwscroll ? t.setScrollLeft(parseInt(o)) : S.call(e, o), this;
    }
  }, e.fn.scrollLeft = function (e) {
    if (void 0 === e) {
      var o = !!this[0] && (n.data(this[0], "__nicescroll") || !1);
      return o && o.ishwscroll ? o.getScrollLeft() : S.call(this);
    }
    return this.each(function () {
      var o = n.data(this, "__nicescroll") || !1;
      o && o.ishwscroll ? o.setScrollLeft(parseInt(e)) : S.call(n(this), e);
    });
  };
  var z = function z(e) {
    var o = this;
    if (this.length = 0, this.name = "nicescrollarray", this.each = function (e) {
      return n.each(o, e), o;
    }, this.push = function (e) {
      o[o.length] = e, o.length++;
    }, this.eq = function (e) {
      return o[e];
    }, e) for (var t = 0; t < e.length; t++) {
      var r = n.data(e[t], "__nicescroll") || !1;
      r && (this[this.length] = r, this.length++);
    }
    return this;
  };
  !function (e, o, t) {
    for (var r = 0, i = o.length; r < i; r++) {
      t(e, o[r]);
    }
  }(z.prototype, ["show", "hide", "toggle", "onResize", "resize", "remove", "stop", "doScrollPos"], function (e, o) {
    e[o] = function () {
      var e = arguments;
      return this.each(function () {
        this[o].apply(this, e);
      });
    };
  }), e.fn.getNiceScroll = function (e) {
    return void 0 === e ? new z(this) : this[e] && n.data(this[e], "__nicescroll") || !1;
  }, (e.expr.pseudos || e.expr[":"]).nicescroll = function (e) {
    return void 0 !== n.data(e, "__nicescroll");
  }, n.fn.niceScroll = function (e, o) {
    void 0 !== o || "object" != _typeof(e) || "jquery" in e || (o = e, e = !1);
    var t = new z();
    return this.each(function () {
      var r = n(this),
        i = n.extend({}, o);
      if (e) {
        var s = n(e);
        i.doc = s.length > 1 ? n(e, r) : s, i.win = r;
      }
      !("doc" in i) || "win" in i || (i.win = r);
      var l = r.data("__nicescroll") || !1;
      l || (i.doc = i.doc || r, l = new b(i, r), r.data("__nicescroll", l)), t.push(l);
    }), 1 === t.length ? t[0] : t;
  }, a.NiceScroll = {
    getjQuery: function getjQuery() {
      return e;
    }
  }, n.nicescroll || (n.nicescroll = new z(), n.nicescroll.options = g);
});

/***/ }),

/***/ "./public/frontend/default/js/jquery.scrollbar.min.js":
/*!************************************************************!*\
  !*** ./public/frontend/default/js/jquery.scrollbar.min.js ***!
  \************************************************************/
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/**
 * jQuery CSS Customizable Scrollbar
 *
 * Copyright 2015, Yuriy Khabarov
 * Dual licensed under the MIT or GPL Version 2 licenses.
 *
 * If you found bug, please contact me via email <13real008@gmail.com>
 *
 * Compressed by http://jscompress.com/
 *
 * @author Yuriy Khabarov aka Gromo
 * @version 0.2.10
 * @url https://github.com/gromo/jquery.scrollbar/
 *
 */
!function (l, e) {
   true ? !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (e),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)) : 0;
}(this, function (l) {
  "use strict";

  function e(e) {
    if (t.webkit && !e) return {
      height: 0,
      width: 0
    };
    if (!t.data.outer) {
      var o = {
        border: "none",
        "box-sizing": "content-box",
        height: "200px",
        margin: "0",
        padding: "0",
        width: "200px"
      };
      t.data.inner = l("<div>").css(l.extend({}, o)), t.data.outer = l("<div>").css(l.extend({
        left: "-1000px",
        overflow: "scroll",
        position: "absolute",
        top: "-1000px"
      }, o)).append(t.data.inner).appendTo("body");
    }
    return t.data.outer.scrollLeft(1e3).scrollTop(1e3), {
      height: Math.ceil(t.data.outer.offset().top - t.data.inner.offset().top || 0),
      width: Math.ceil(t.data.outer.offset().left - t.data.inner.offset().left || 0)
    };
  }
  function o() {
    var l = e(!0);
    return !(l.height || l.width);
  }
  function s(l) {
    var e = l.originalEvent;
    return e.axis && e.axis === e.HORIZONTAL_AXIS ? !1 : e.wheelDeltaX ? !1 : !0;
  }
  var r = !1,
    t = {
      data: {
        index: 0,
        name: "scrollbar"
      },
      macosx: /mac/i.test(navigator.platform),
      mobile: /android|webos|iphone|ipad|ipod|blackberry/i.test(navigator.userAgent),
      overlay: null,
      scroll: null,
      scrolls: [],
      webkit: /webkit/i.test(navigator.userAgent) && !/edge\/\d+/i.test(navigator.userAgent)
    };
  t.scrolls.add = function (l) {
    this.remove(l).push(l);
  }, t.scrolls.remove = function (e) {
    for (; l.inArray(e, this) >= 0;) {
      this.splice(l.inArray(e, this), 1);
    }
    return this;
  };
  var i = {
      autoScrollSize: !0,
      autoUpdate: !0,
      debug: !1,
      disableBodyScroll: !1,
      duration: 200,
      ignoreMobile: !1,
      ignoreOverlay: !1,
      scrollStep: 30,
      showArrows: !1,
      stepScrolling: !0,
      scrollx: null,
      scrolly: null,
      onDestroy: null,
      onInit: null,
      onScroll: null,
      onUpdate: null
    },
    n = function n(s) {
      t.scroll || (t.overlay = o(), t.scroll = e(), a(), l(window).resize(function () {
        var l = !1;
        if (t.scroll && (t.scroll.height || t.scroll.width)) {
          var o = e();
          (o.height !== t.scroll.height || o.width !== t.scroll.width) && (t.scroll = o, l = !0);
        }
        a(l);
      })), this.container = s, this.namespace = ".scrollbar_" + t.data.index++, this.options = l.extend({}, i, window.jQueryScrollbarOptions || {}), this.scrollTo = null, this.scrollx = {}, this.scrolly = {}, s.data(t.data.name, this), t.scrolls.add(this);
    };
  n.prototype = {
    destroy: function destroy() {
      if (this.wrapper) {
        this.container.removeData(t.data.name), t.scrolls.remove(this);
        var e = this.container.scrollLeft(),
          o = this.container.scrollTop();
        this.container.insertBefore(this.wrapper).css({
          height: "",
          margin: "",
          "max-height": ""
        }).removeClass("scroll-content scroll-scrollx_visible scroll-scrolly_visible").off(this.namespace).scrollLeft(e).scrollTop(o), this.scrollx.scroll.removeClass("scroll-scrollx_visible").find("div").andSelf().off(this.namespace), this.scrolly.scroll.removeClass("scroll-scrolly_visible").find("div").andSelf().off(this.namespace), this.wrapper.remove(), l(document).add("body").off(this.namespace), l.isFunction(this.options.onDestroy) && this.options.onDestroy.apply(this, [this.container]);
      }
    },
    init: function init(e) {
      var o = this,
        r = this.container,
        i = this.containerWrapper || r,
        n = this.namespace,
        c = l.extend(this.options, e || {}),
        a = {
          x: this.scrollx,
          y: this.scrolly
        },
        d = this.wrapper,
        h = {
          scrollLeft: r.scrollLeft(),
          scrollTop: r.scrollTop()
        };
      if (t.mobile && c.ignoreMobile || t.overlay && c.ignoreOverlay || t.macosx && !t.webkit) return !1;
      if (d) i.css({
        height: "auto",
        "margin-bottom": -1 * t.scroll.height + "px",
        "margin-right": -1 * t.scroll.width + "px",
        "max-height": ""
      });else {
        if (this.wrapper = d = l("<div>").addClass("scroll-wrapper").addClass(r.attr("class")).css("position", "absolute" == r.css("position") ? "absolute" : "relative").insertBefore(r).append(r), r.is("textarea") && (this.containerWrapper = i = l("<div>").insertBefore(r).append(r), d.addClass("scroll-textarea")), i.addClass("scroll-content").css({
          height: "auto",
          "margin-bottom": -1 * t.scroll.height + "px",
          "margin-right": -1 * t.scroll.width + "px",
          "max-height": ""
        }), r.on("scroll" + n, function (e) {
          l.isFunction(c.onScroll) && c.onScroll.call(o, {
            maxScroll: a.y.maxScrollOffset,
            scroll: r.scrollTop(),
            size: a.y.size,
            visible: a.y.visible
          }, {
            maxScroll: a.x.maxScrollOffset,
            scroll: r.scrollLeft(),
            size: a.x.size,
            visible: a.x.visible
          }), a.x.isVisible && a.x.scroll.bar.css("left", r.scrollLeft() * a.x.kx + "px"), a.y.isVisible && a.y.scroll.bar.css("top", r.scrollTop() * a.y.kx + "px");
        }), d.on("scroll" + n, function () {
          d.scrollTop(0).scrollLeft(0);
        }), c.disableBodyScroll) {
          var p = function p(l) {
            s(l) ? a.y.isVisible && a.y.mousewheel(l) : a.x.isVisible && a.x.mousewheel(l);
          };
          d.on("MozMousePixelScroll" + n, p), d.on("mousewheel" + n, p), t.mobile && d.on("touchstart" + n, function (e) {
            var o = e.originalEvent.touches && e.originalEvent.touches[0] || e,
              s = {
                pageX: o.pageX,
                pageY: o.pageY
              },
              t = {
                left: r.scrollLeft(),
                top: r.scrollTop()
              };
            l(document).on("touchmove" + n, function (l) {
              var e = l.originalEvent.targetTouches && l.originalEvent.targetTouches[0] || l;
              r.scrollLeft(t.left + s.pageX - e.pageX), r.scrollTop(t.top + s.pageY - e.pageY), l.preventDefault();
            }), l(document).on("touchend" + n, function () {
              l(document).off(n);
            });
          });
        }
        l.isFunction(c.onInit) && c.onInit.apply(this, [r]);
      }
      l.each(a, function (e, t) {
        var i = null,
          d = 1,
          h = "x" === e ? "scrollLeft" : "scrollTop",
          p = c.scrollStep,
          u = function u() {
            var l = r[h]();
            r[h](l + p), 1 == d && l + p >= f && (l = r[h]()), -1 == d && f >= l + p && (l = r[h]()), r[h]() == l && i && i();
          },
          f = 0;
        t.scroll || (t.scroll = o._getScroll(c["scroll" + e]).addClass("scroll-" + e), c.showArrows && t.scroll.addClass("scroll-element_arrows_visible"), t.mousewheel = function (l) {
          if (!t.isVisible || "x" === e && s(l)) return !0;
          if ("y" === e && !s(l)) return a.x.mousewheel(l), !0;
          var i = -1 * l.originalEvent.wheelDelta || l.originalEvent.detail,
            n = t.size - t.visible - t.offset;
          return (i > 0 && n > f || 0 > i && f > 0) && (f += i, 0 > f && (f = 0), f > n && (f = n), o.scrollTo = o.scrollTo || {}, o.scrollTo[h] = f, setTimeout(function () {
            o.scrollTo && (r.stop().animate(o.scrollTo, 240, "linear", function () {
              f = r[h]();
            }), o.scrollTo = null);
          }, 1)), l.preventDefault(), !1;
        }, t.scroll.on("MozMousePixelScroll" + n, t.mousewheel).on("mousewheel" + n, t.mousewheel).on("mouseenter" + n, function () {
          f = r[h]();
        }), t.scroll.find(".scroll-arrow, .scroll-element_track").on("mousedown" + n, function (s) {
          if (1 != s.which) return !0;
          d = 1;
          var n = {
              eventOffset: s["x" === e ? "pageX" : "pageY"],
              maxScrollValue: t.size - t.visible - t.offset,
              scrollbarOffset: t.scroll.bar.offset()["x" === e ? "left" : "top"],
              scrollbarSize: t.scroll.bar["x" === e ? "outerWidth" : "outerHeight"]()
            },
            a = 0,
            v = 0;
          return l(this).hasClass("scroll-arrow") ? (d = l(this).hasClass("scroll-arrow_more") ? 1 : -1, p = c.scrollStep * d, f = d > 0 ? n.maxScrollValue : 0) : (d = n.eventOffset > n.scrollbarOffset + n.scrollbarSize ? 1 : n.eventOffset < n.scrollbarOffset ? -1 : 0, p = Math.round(.75 * t.visible) * d, f = n.eventOffset - n.scrollbarOffset - (c.stepScrolling ? 1 == d ? n.scrollbarSize : 0 : Math.round(n.scrollbarSize / 2)), f = r[h]() + f / t.kx), o.scrollTo = o.scrollTo || {}, o.scrollTo[h] = c.stepScrolling ? r[h]() + p : f, c.stepScrolling && (i = function i() {
            f = r[h](), clearInterval(v), clearTimeout(a), a = 0, v = 0;
          }, a = setTimeout(function () {
            v = setInterval(u, 40);
          }, c.duration + 100)), setTimeout(function () {
            o.scrollTo && (r.animate(o.scrollTo, c.duration), o.scrollTo = null);
          }, 1), o._handleMouseDown(i, s);
        }), t.scroll.bar.on("mousedown" + n, function (s) {
          if (1 != s.which) return !0;
          var i = s["x" === e ? "pageX" : "pageY"],
            c = r[h]();
          return t.scroll.addClass("scroll-draggable"), l(document).on("mousemove" + n, function (l) {
            var o = parseInt((l["x" === e ? "pageX" : "pageY"] - i) / t.kx, 10);
            r[h](c + o);
          }), o._handleMouseDown(function () {
            t.scroll.removeClass("scroll-draggable"), f = r[h]();
          }, s);
        }));
      }), l.each(a, function (l, e) {
        var o = "scroll-scroll" + l + "_visible",
          s = "x" == l ? a.y : a.x;
        e.scroll.removeClass(o), s.scroll.removeClass(o), i.removeClass(o);
      }), l.each(a, function (e, o) {
        l.extend(o, "x" == e ? {
          offset: parseInt(r.css("left"), 10) || 0,
          size: r.prop("scrollWidth"),
          visible: d.width()
        } : {
          offset: parseInt(r.css("top"), 10) || 0,
          size: r.prop("scrollHeight"),
          visible: d.height()
        });
      }), this._updateScroll("x", this.scrollx), this._updateScroll("y", this.scrolly), l.isFunction(c.onUpdate) && c.onUpdate.apply(this, [r]), l.each(a, function (l, e) {
        var o = "x" === l ? "left" : "top",
          s = "x" === l ? "outerWidth" : "outerHeight",
          t = "x" === l ? "width" : "height",
          i = parseInt(r.css(o), 10) || 0,
          n = e.size,
          a = e.visible + i,
          d = e.scroll.size[s]() + (parseInt(e.scroll.size.css(o), 10) || 0);
        c.autoScrollSize && (e.scrollbarSize = parseInt(d * a / n, 10), e.scroll.bar.css(t, e.scrollbarSize + "px")), e.scrollbarSize = e.scroll.bar[s](), e.kx = (d - e.scrollbarSize) / (n - a) || 1, e.maxScrollOffset = n - a;
      }), r.scrollLeft(h.scrollLeft).scrollTop(h.scrollTop).trigger("scroll");
    },
    _getScroll: function _getScroll(e) {
      var o = {
        advanced: ['<div class="scroll-element">', '<div class="scroll-element_corner"></div>', '<div class="scroll-arrow scroll-arrow_less"></div>', '<div class="scroll-arrow scroll-arrow_more"></div>', '<div class="scroll-element_outer">', '<div class="scroll-element_size"></div>', '<div class="scroll-element_inner-wrapper">', '<div class="scroll-element_inner scroll-element_track">', '<div class="scroll-element_inner-bottom"></div>', "</div>", "</div>", '<div class="scroll-bar">', '<div class="scroll-bar_body">', '<div class="scroll-bar_body-inner"></div>', "</div>", '<div class="scroll-bar_bottom"></div>', '<div class="scroll-bar_center"></div>', "</div>", "</div>", "</div>"].join(""),
        simple: ['<div class="scroll-element">', '<div class="scroll-element_outer">', '<div class="scroll-element_size"></div>', '<div class="scroll-element_track"></div>', '<div class="scroll-bar"></div>', "</div>", "</div>"].join("")
      };
      return o[e] && (e = o[e]), e || (e = o.simple), e = "string" == typeof e ? l(e).appendTo(this.wrapper) : l(e), l.extend(e, {
        bar: e.find(".scroll-bar"),
        size: e.find(".scroll-element_size"),
        track: e.find(".scroll-element_track")
      }), e;
    },
    _handleMouseDown: function _handleMouseDown(e, o) {
      var s = this.namespace;
      return l(document).on("blur" + s, function () {
        l(document).add("body").off(s), e && e();
      }), l(document).on("dragstart" + s, function (l) {
        return l.preventDefault(), !1;
      }), l(document).on("mouseup" + s, function () {
        l(document).add("body").off(s), e && e();
      }), l("body").on("selectstart" + s, function (l) {
        return l.preventDefault(), !1;
      }), o && o.preventDefault(), !1;
    },
    _updateScroll: function _updateScroll(e, o) {
      var s = this.container,
        r = this.containerWrapper || s,
        i = "scroll-scroll" + e + "_visible",
        n = "x" === e ? this.scrolly : this.scrollx,
        c = parseInt(this.container.css("x" === e ? "left" : "top"), 10) || 0,
        a = this.wrapper,
        d = o.size,
        h = o.visible + c;
      o.isVisible = d - h > 1, o.isVisible ? (o.scroll.addClass(i), n.scroll.addClass(i), r.addClass(i)) : (o.scroll.removeClass(i), n.scroll.removeClass(i), r.removeClass(i)), "y" === e && (s.is("textarea") || h > d ? r.css({
        height: h + t.scroll.height + "px",
        "max-height": "none"
      }) : r.css({
        "max-height": h + t.scroll.height + "px"
      })), (o.size != s.prop("scrollWidth") || n.size != s.prop("scrollHeight") || o.visible != a.width() || n.visible != a.height() || o.offset != (parseInt(s.css("left"), 10) || 0) || n.offset != (parseInt(s.css("top"), 10) || 0)) && (l.extend(this.scrollx, {
        offset: parseInt(s.css("left"), 10) || 0,
        size: s.prop("scrollWidth"),
        visible: a.width()
      }), l.extend(this.scrolly, {
        offset: parseInt(s.css("top"), 10) || 0,
        size: this.container.prop("scrollHeight"),
        visible: a.height()
      }), this._updateScroll("x" === e ? "y" : "x", n));
    }
  };
  var c = n;
  l.fn.scrollbar = function (e, o) {
    return "string" != typeof e && (o = e, e = "init"), "undefined" == typeof o && (o = []), l.isArray(o) || (o = [o]), this.not("body, .scroll-wrapper").each(function () {
      var s = l(this),
        r = s.data(t.data.name);
      (r || "init" === e) && (r || (r = new c(s)), r[e] && r[e].apply(r, o));
    }), this;
  }, l.fn.scrollbar.options = i;
  var a = function () {
    var l = 0,
      e = 0;
    return function (o) {
      var s, i, n, c, d, h, p;
      for (s = 0; s < t.scrolls.length; s++) {
        c = t.scrolls[s], i = c.container, n = c.options, d = c.wrapper, h = c.scrollx, p = c.scrolly, (o || n.autoUpdate && d && d.is(":visible") && (i.prop("scrollWidth") != h.size || i.prop("scrollHeight") != p.size || d.width() != h.visible || d.height() != p.visible)) && (c.init(), n.debug && (window.console && console.log({
          scrollHeight: i.prop("scrollHeight") + ":" + c.scrolly.size,
          scrollWidth: i.prop("scrollWidth") + ":" + c.scrollx.size,
          visibleHeight: d.height() + ":" + c.scrolly.visible,
          visibleWidth: d.width() + ":" + c.scrollx.visible
        }, !0), e++));
      }
      r && e > 10 ? (window.console && console.log("Scroll updates exceed 10"), a = function a() {}) : (clearTimeout(l), l = setTimeout(a, 300));
    };
  }();
  window.angular && !function (l) {
    l.module("jQueryScrollbar", []).provider("jQueryScrollbar", function () {
      var e = i;
      return {
        setOptions: function setOptions(o) {
          l.extend(e, o);
        },
        $get: function $get() {
          return {
            options: l.copy(e)
          };
        }
      };
    }).directive("jqueryScrollbar", ["jQueryScrollbar", "$parse", function (l, e) {
      return {
        restrict: "AC",
        link: function link(o, s, r) {
          var t = e(r.jqueryScrollbar),
            i = t(o);
          s.scrollbar(i || l.options).on("$destroy", function () {
            s.scrollbar("destroy");
          });
        }
      };
    }]);
  }(window.angular);
});

/***/ }),

/***/ "./public/frontend/default/js/jquery.simpleLoadMore.js":
/*!*************************************************************!*\
  !*** ./public/frontend/default/js/jquery.simpleLoadMore.js ***!
  \*************************************************************/
/***/ (() => {

!function (o) {
  o.fn.simpleLoadMore = function (e) {
    var t = o.extend({
      count: 5,
      itemsToLoad: 5,
      btnHTML: "",
      item: ""
    }, e);
    o(this).each(function (a, i) {
      var n = o(this),
        d = n.find(t.item),
        s = t.btnHTML ? t.btnHTML : '<a href="" id="loadmore" class="load_more_btn"> <i class="ti-reload"></i> Load More</a>',
        l = o(s);
      t.itemsToLoad;
      e.itemsToLoad && !isNaN(e.itemsToLoad) || (t.itemsToLoad = t.count), n.addClass("load-more"), d.addClass("load-more__item"), !n.find(".load-more__btn").length && d.length > t.count && n.append(l);
      var m = n.find(".load-more__btn");
      m.length || (m = l), d.length > t.count && d.slice(t.count).hide(), m.on("click", function (e) {
        e.preventDefault();
        var a = o(this),
          i = d.filter(":hidden"),
          n = i;
        -1 !== t.itemsToLoad && t.itemsToLoad > 0 && (n = i.slice(0, t.itemsToLoad)), n.length > 0 && n.fadeIn(), (i.length <= t.itemsToLoad || -1 === t.itemsToLoad) && a.remove();
      });
    });
  };
}(jQuery);

/***/ }),

/***/ "./public/frontend/default/js/rangeslider.js":
/*!***************************************************!*\
  !*** ./public/frontend/default/js/rangeslider.js ***!
  \***************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
!function (t) {
   true ? !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")], __WEBPACK_AMD_DEFINE_RESULT__ = (function (i) {
    return t(i, document, window, navigator);
  }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)) : 0;
}(function (t, i, s, o, e) {
  "use strict";

  var h,
    r,
    n = 0,
    a = (h = o.userAgent, r = /msie\s\d+/i, h.search(r) > 0 && r.exec(h).toString().split(" ")[1] < 9 && (t("html").addClass("lt-ie9"), !0));
  Function.prototype.bind || (Function.prototype.bind = function (t) {
    var i = this,
      s = [].slice;
    if ("function" != typeof i) throw new TypeError();
    var o = s.call(arguments, 1),
      e = function e() {
        if (this instanceof e) {
          var h = function h() {};
          h.prototype = i.prototype;
          var r = new h(),
            n = i.apply(r, o.concat(s.call(arguments)));
          return Object(n) === n ? n : r;
        }
        return i.apply(t, o.concat(s.call(arguments)));
      };
    return e;
  }), Array.prototype.indexOf || (Array.prototype.indexOf = function (t, i) {
    var s;
    if (null == this) throw new TypeError('"this" is null or not defined');
    var o = Object(this),
      e = o.length >>> 0;
    if (0 === e) return -1;
    var h = +i || 0;
    if (Math.abs(h) === 1 / 0 && (h = 0), h >= e) return -1;
    for (s = Math.max(h >= 0 ? h : e - Math.abs(h), 0); s < e;) {
      if (s in o && o[s] === t) return s;
      s++;
    }
    return -1;
  });
  var c = function c(o, h, r) {
    this.VERSION = "2.1.7", this.input = o, this.plugin_count = r, this.current_plugin = 0, this.calc_count = 0, this.update_tm = 0, this.old_from = 0, this.old_to = 0, this.old_min_interval = null, this.raf_id = null, this.dragging = !1, this.force_redraw = !1, this.no_diapason = !1, this.is_key = !1, this.is_update = !1, this.is_start = !0, this.is_finish = !1, this.is_active = !1, this.is_resize = !1, this.is_click = !1, h = h || {}, this.$cache = {
      win: t(s),
      body: t(i.body),
      input: t(o),
      cont: null,
      rs: null,
      min: null,
      max: null,
      from: null,
      to: null,
      single: null,
      bar: null,
      line: null,
      s_single: null,
      s_from: null,
      s_to: null,
      shad_single: null,
      shad_from: null,
      shad_to: null,
      edge: null,
      grid: null,
      grid_labels: []
    }, this.coords = {
      x_gap: 0,
      x_pointer: 0,
      w_rs: 0,
      w_rs_old: 0,
      w_handle: 0,
      p_gap: 0,
      p_gap_left: 0,
      p_gap_right: 0,
      p_step: 0,
      p_pointer: 0,
      p_handle: 0,
      p_single_fake: 0,
      p_single_real: 0,
      p_from_fake: 0,
      p_from_real: 0,
      p_to_fake: 0,
      p_to_real: 0,
      p_bar_x: 0,
      p_bar_w: 0,
      grid_gap: 0,
      big_num: 0,
      big: [],
      big_w: [],
      big_p: [],
      big_x: []
    }, this.labels = {
      w_min: 0,
      w_max: 0,
      w_from: 0,
      w_to: 0,
      w_single: 0,
      p_min: 0,
      p_max: 0,
      p_from_fake: 0,
      p_from_left: 0,
      p_to_fake: 0,
      p_to_left: 0,
      p_single_fake: 0,
      p_single_left: 0
    };
    var n,
      a,
      c,
      l = this.$cache.input,
      _ = l.prop("value");
    for (c in n = {
      type: "single",
      min: 10,
      max: 100,
      from: null,
      to: null,
      step: 1,
      min_interval: 0,
      max_interval: 0,
      drag_interval: !1,
      values: [],
      p_values: [],
      from_fixed: !1,
      from_min: null,
      from_max: null,
      from_shadow: !1,
      to_fixed: !1,
      to_min: null,
      to_max: null,
      to_shadow: !1,
      prettify_enabled: !0,
      prettify_separator: " ",
      prettify: null,
      force_edges: !1,
      keyboard: !1,
      keyboard_step: 5,
      grid: !1,
      grid_margin: !0,
      grid_num: 4,
      grid_snap: !1,
      hide_min_max: !1,
      hide_from_to: !1,
      prefix: "",
      postfix: "",
      max_postfix: "",
      decorate_both: !0,
      values_separator: " â€” ",
      input_values_separator: ";",
      disable: !1,
      onStart: null,
      onChange: null,
      onFinish: null,
      onUpdate: null
    }, "INPUT" !== l[0].nodeName && console && console.warn && console.warn("Base element should be <input>!", l[0]), (a = {
      type: l.data("type"),
      min: l.data("min"),
      max: l.data("max"),
      from: l.data("from"),
      to: l.data("to"),
      step: l.data("step"),
      min_interval: l.data("minInterval"),
      max_interval: l.data("maxInterval"),
      drag_interval: l.data("dragInterval"),
      values: l.data("values"),
      from_fixed: l.data("fromFixed"),
      from_min: l.data("fromMin"),
      from_max: l.data("fromMax"),
      from_shadow: l.data("fromShadow"),
      to_fixed: l.data("toFixed"),
      to_min: l.data("toMin"),
      to_max: l.data("toMax"),
      to_shadow: l.data("toShadow"),
      prettify_enabled: l.data("prettifyEnabled"),
      prettify_separator: l.data("prettifySeparator"),
      force_edges: l.data("forceEdges"),
      keyboard: l.data("keyboard"),
      keyboard_step: l.data("keyboardStep"),
      grid: l.data("grid"),
      grid_margin: l.data("gridMargin"),
      grid_num: l.data("gridNum"),
      grid_snap: l.data("gridSnap"),
      hide_min_max: l.data("hideMinMax"),
      hide_from_to: l.data("hideFromTo"),
      prefix: l.data("prefix"),
      postfix: l.data("postfix"),
      max_postfix: l.data("maxPostfix"),
      decorate_both: l.data("decorateBoth"),
      values_separator: l.data("valuesSeparator"),
      input_values_separator: l.data("inputValuesSeparator"),
      disable: l.data("disable")
    }).values = a.values && a.values.split(","), a) {
      a.hasOwnProperty(c) && (a[c] !== e && "" !== a[c] || delete a[c]);
    }
    _ !== e && "" !== _ && ((_ = _.split(a.input_values_separator || h.input_values_separator || ";"))[0] && _[0] == +_[0] && (_[0] = +_[0]), _[1] && _[1] == +_[1] && (_[1] = +_[1]), h && h.values && h.values.length ? (n.from = _[0] && h.values.indexOf(_[0]), n.to = _[1] && h.values.indexOf(_[1])) : (n.from = _[0] && +_[0], n.to = _[1] && +_[1])), t.extend(n, h), t.extend(n, a), this.options = n, this.update_check = {}, this.validate(), this.result = {
      input: this.$cache.input,
      slider: null,
      min: this.options.min,
      max: this.options.max,
      from: this.options.from,
      from_percent: 0,
      from_value: null,
      to: this.options.to,
      to_percent: 0,
      to_value: null
    }, this.init();
  };
  c.prototype = {
    init: function init(t) {
      this.no_diapason = !1, this.coords.p_step = this.convertToPercent(this.options.step, !0), this.target = "base", this.toggleInput(), this.append(), this.setMinMax(), t ? (this.force_redraw = !0, this.calc(!0), this.callOnUpdate()) : (this.force_redraw = !0, this.calc(!0), this.callOnStart()), this.updateScene();
    },
    append: function append() {
      var t = '<span class="irs js-irs-' + this.plugin_count + '"></span>';
      this.$cache.input.before(t), this.$cache.input.prop("readonly", !0), this.$cache.cont = this.$cache.input.prev(), this.result.slider = this.$cache.cont, this.$cache.cont.html('<span class="irs"><span class="irs-line" tabindex="-1"><span class="irs-line-left"></span><span class="irs-line-mid"></span><span class="irs-line-right"></span></span><span class="irs-min">0</span><span class="irs-max">1</span><span class="irs-from">0</span><span class="irs-to">0</span><span class="irs-single">0</span></span><span class="irs-grid"></span><span class="irs-bar"></span>'), this.$cache.rs = this.$cache.cont.find(".irs"), this.$cache.min = this.$cache.cont.find(".irs-min"), this.$cache.max = this.$cache.cont.find(".irs-max"), this.$cache.from = this.$cache.cont.find(".irs-from"), this.$cache.to = this.$cache.cont.find(".irs-to"), this.$cache.single = this.$cache.cont.find(".irs-single"), this.$cache.bar = this.$cache.cont.find(".irs-bar"), this.$cache.line = this.$cache.cont.find(".irs-line"), this.$cache.grid = this.$cache.cont.find(".irs-grid"), "single" === this.options.type ? (this.$cache.cont.append('<span class="irs-bar-edge"></span><span class="irs-shadow shadow-single"></span><span class="irs-slider single"></span>'), this.$cache.edge = this.$cache.cont.find(".irs-bar-edge"), this.$cache.s_single = this.$cache.cont.find(".single"), this.$cache.from[0].style.visibility = "hidden", this.$cache.to[0].style.visibility = "hidden", this.$cache.shad_single = this.$cache.cont.find(".shadow-single")) : (this.$cache.cont.append('<span class="irs-shadow shadow-from"></span><span class="irs-shadow shadow-to"></span><span class="irs-slider from"></span><span class="irs-slider to"></span>'), this.$cache.s_from = this.$cache.cont.find(".from"), this.$cache.s_to = this.$cache.cont.find(".to"), this.$cache.shad_from = this.$cache.cont.find(".shadow-from"), this.$cache.shad_to = this.$cache.cont.find(".shadow-to"), this.setTopHandler()), this.options.hide_from_to && (this.$cache.from[0].style.display = "none", this.$cache.to[0].style.display = "none", this.$cache.single[0].style.display = "none"), this.appendGrid(), this.options.disable ? (this.appendDisableMask(), this.$cache.input[0].disabled = !0) : (this.$cache.cont.removeClass("irs-disabled"), this.$cache.input[0].disabled = !1, this.bindEvents()), this.options.drag_interval && (this.$cache.bar[0].style.cursor = "ew-resize");
    },
    setTopHandler: function setTopHandler() {
      var t = this.options.min,
        i = this.options.max,
        s = this.options.from,
        o = this.options.to;
      s > t && o === i ? this.$cache.s_from.addClass("type_last") : o < i && this.$cache.s_to.addClass("type_last");
    },
    changeLevel: function changeLevel(t) {
      switch (t) {
        case "single":
          this.coords.p_gap = this.toFixed(this.coords.p_pointer - this.coords.p_single_fake);
          break;
        case "from":
          this.coords.p_gap = this.toFixed(this.coords.p_pointer - this.coords.p_from_fake), this.$cache.s_from.addClass("state_hover"), this.$cache.s_from.addClass("type_last"), this.$cache.s_to.removeClass("type_last");
          break;
        case "to":
          this.coords.p_gap = this.toFixed(this.coords.p_pointer - this.coords.p_to_fake), this.$cache.s_to.addClass("state_hover"), this.$cache.s_to.addClass("type_last"), this.$cache.s_from.removeClass("type_last");
          break;
        case "both":
          this.coords.p_gap_left = this.toFixed(this.coords.p_pointer - this.coords.p_from_fake), this.coords.p_gap_right = this.toFixed(this.coords.p_to_fake - this.coords.p_pointer), this.$cache.s_to.removeClass("type_last"), this.$cache.s_from.removeClass("type_last");
      }
    },
    appendDisableMask: function appendDisableMask() {
      this.$cache.cont.append('<span class="irs-disable-mask"></span>'), this.$cache.cont.addClass("irs-disabled");
    },
    remove: function remove() {
      this.$cache.cont.remove(), this.$cache.cont = null, this.$cache.line.off("keydown.irs_" + this.plugin_count), this.$cache.body.off("touchmove.irs_" + this.plugin_count), this.$cache.body.off("mousemove.irs_" + this.plugin_count), this.$cache.win.off("touchend.irs_" + this.plugin_count), this.$cache.win.off("mouseup.irs_" + this.plugin_count), a && (this.$cache.body.off("mouseup.irs_" + this.plugin_count), this.$cache.body.off("mouseleave.irs_" + this.plugin_count)), this.$cache.grid_labels = [], this.coords.big = [], this.coords.big_w = [], this.coords.big_p = [], this.coords.big_x = [], cancelAnimationFrame(this.raf_id);
    },
    bindEvents: function bindEvents() {
      this.no_diapason || (this.$cache.body.on("touchmove.irs_" + this.plugin_count, this.pointerMove.bind(this)), this.$cache.body.on("mousemove.irs_" + this.plugin_count, this.pointerMove.bind(this)), this.$cache.win.on("touchend.irs_" + this.plugin_count, this.pointerUp.bind(this)), this.$cache.win.on("mouseup.irs_" + this.plugin_count, this.pointerUp.bind(this)), this.$cache.line.on("touchstart.irs_" + this.plugin_count, this.pointerClick.bind(this, "click")), this.$cache.line.on("mousedown.irs_" + this.plugin_count, this.pointerClick.bind(this, "click")), this.options.drag_interval && "double" === this.options.type ? (this.$cache.bar.on("touchstart.irs_" + this.plugin_count, this.pointerDown.bind(this, "both")), this.$cache.bar.on("mousedown.irs_" + this.plugin_count, this.pointerDown.bind(this, "both"))) : (this.$cache.bar.on("touchstart.irs_" + this.plugin_count, this.pointerClick.bind(this, "click")), this.$cache.bar.on("mousedown.irs_" + this.plugin_count, this.pointerClick.bind(this, "click"))), "single" === this.options.type ? (this.$cache.single.on("touchstart.irs_" + this.plugin_count, this.pointerDown.bind(this, "single")), this.$cache.s_single.on("touchstart.irs_" + this.plugin_count, this.pointerDown.bind(this, "single")), this.$cache.shad_single.on("touchstart.irs_" + this.plugin_count, this.pointerClick.bind(this, "click")), this.$cache.single.on("mousedown.irs_" + this.plugin_count, this.pointerDown.bind(this, "single")), this.$cache.s_single.on("mousedown.irs_" + this.plugin_count, this.pointerDown.bind(this, "single")), this.$cache.edge.on("mousedown.irs_" + this.plugin_count, this.pointerClick.bind(this, "click")), this.$cache.shad_single.on("mousedown.irs_" + this.plugin_count, this.pointerClick.bind(this, "click"))) : (this.$cache.single.on("touchstart.irs_" + this.plugin_count, this.pointerDown.bind(this, null)), this.$cache.single.on("mousedown.irs_" + this.plugin_count, this.pointerDown.bind(this, null)), this.$cache.from.on("touchstart.irs_" + this.plugin_count, this.pointerDown.bind(this, "from")), this.$cache.s_from.on("touchstart.irs_" + this.plugin_count, this.pointerDown.bind(this, "from")), this.$cache.to.on("touchstart.irs_" + this.plugin_count, this.pointerDown.bind(this, "to")), this.$cache.s_to.on("touchstart.irs_" + this.plugin_count, this.pointerDown.bind(this, "to")), this.$cache.shad_from.on("touchstart.irs_" + this.plugin_count, this.pointerClick.bind(this, "click")), this.$cache.shad_to.on("touchstart.irs_" + this.plugin_count, this.pointerClick.bind(this, "click")), this.$cache.from.on("mousedown.irs_" + this.plugin_count, this.pointerDown.bind(this, "from")), this.$cache.s_from.on("mousedown.irs_" + this.plugin_count, this.pointerDown.bind(this, "from")), this.$cache.to.on("mousedown.irs_" + this.plugin_count, this.pointerDown.bind(this, "to")), this.$cache.s_to.on("mousedown.irs_" + this.plugin_count, this.pointerDown.bind(this, "to")), this.$cache.shad_from.on("mousedown.irs_" + this.plugin_count, this.pointerClick.bind(this, "click")), this.$cache.shad_to.on("mousedown.irs_" + this.plugin_count, this.pointerClick.bind(this, "click"))), this.options.keyboard && this.$cache.line.on("keydown.irs_" + this.plugin_count, this.key.bind(this, "keyboard")), a && (this.$cache.body.on("mouseup.irs_" + this.plugin_count, this.pointerUp.bind(this)), this.$cache.body.on("mouseleave.irs_" + this.plugin_count, this.pointerUp.bind(this))));
    },
    pointerMove: function pointerMove(t) {
      if (this.dragging) {
        var i = t.pageX || t.originalEvent.touches && t.originalEvent.touches[0].pageX;
        this.coords.x_pointer = i - this.coords.x_gap, this.calc();
      }
    },
    pointerUp: function pointerUp(i) {
      this.current_plugin === this.plugin_count && this.is_active && (this.is_active = !1, this.$cache.cont.find(".state_hover").removeClass("state_hover"), this.force_redraw = !0, a && t("*").prop("unselectable", !1), this.updateScene(), this.restoreOriginalMinInterval(), (t.contains(this.$cache.cont[0], i.target) || this.dragging) && this.callOnFinish(), this.dragging = !1);
    },
    pointerDown: function pointerDown(i, s) {
      s.preventDefault();
      var o = s.pageX || s.originalEvent.touches && s.originalEvent.touches[0].pageX;
      2 !== s.button && ("both" === i && this.setTempMinInterval(), i || (i = this.target || "from"), this.current_plugin = this.plugin_count, this.target = i, this.is_active = !0, this.dragging = !0, this.coords.x_gap = this.$cache.rs.offset().left, this.coords.x_pointer = o - this.coords.x_gap, this.calcPointerPercent(), this.changeLevel(i), a && t("*").prop("unselectable", !0), this.$cache.line.trigger("focus"), this.updateScene());
    },
    pointerClick: function pointerClick(t, i) {
      i.preventDefault();
      var s = i.pageX || i.originalEvent.touches && i.originalEvent.touches[0].pageX;
      2 !== i.button && (this.current_plugin = this.plugin_count, this.target = t, this.is_click = !0, this.coords.x_gap = this.$cache.rs.offset().left, this.coords.x_pointer = +(s - this.coords.x_gap).toFixed(), this.force_redraw = !0, this.calc(), this.$cache.line.trigger("focus"));
    },
    key: function key(t, i) {
      if (!(this.current_plugin !== this.plugin_count || i.altKey || i.ctrlKey || i.shiftKey || i.metaKey)) {
        switch (i.which) {
          case 83:
          case 65:
          case 40:
          case 37:
            i.preventDefault(), this.moveByKey(!1);
            break;
          case 87:
          case 68:
          case 38:
          case 39:
            i.preventDefault(), this.moveByKey(!0);
        }
        return !0;
      }
    },
    moveByKey: function moveByKey(t) {
      var i = this.coords.p_pointer;
      t ? i += this.options.keyboard_step : i -= this.options.keyboard_step, this.coords.x_pointer = this.toFixed(this.coords.w_rs / 100 * i), this.is_key = !0, this.calc();
    },
    setMinMax: function setMinMax() {
      if (this.options) {
        if (this.options.hide_min_max) return this.$cache.min[0].style.display = "none", void (this.$cache.max[0].style.display = "none");
        this.options.values.length ? (this.$cache.min.html(this.decorate(this.options.p_values[this.options.min])), this.$cache.max.html(this.decorate(this.options.p_values[this.options.max]))) : (this.$cache.min.html(this.decorate(this._prettify(this.options.min), this.options.min)), this.$cache.max.html(this.decorate(this._prettify(this.options.max), this.options.max))), this.labels.w_min = this.$cache.min.outerWidth(!1), this.labels.w_max = this.$cache.max.outerWidth(!1);
      }
    },
    setTempMinInterval: function setTempMinInterval() {
      var t = this.result.to - this.result.from;
      null === this.old_min_interval && (this.old_min_interval = this.options.min_interval), this.options.min_interval = t;
    },
    restoreOriginalMinInterval: function restoreOriginalMinInterval() {
      null !== this.old_min_interval && (this.options.min_interval = this.old_min_interval, this.old_min_interval = null);
    },
    calc: function calc(t) {
      if (this.options && (this.calc_count++, (10 === this.calc_count || t) && (this.calc_count = 0, this.coords.w_rs = this.$cache.rs.outerWidth(!1), this.calcHandlePercent()), this.coords.w_rs)) {
        this.calcPointerPercent();
        var i = this.getHandleX();
        switch ("both" === this.target && (this.coords.p_gap = 0, i = this.getHandleX()), "click" === this.target && (this.coords.p_gap = this.coords.p_handle / 2, i = this.getHandleX(), this.options.drag_interval ? this.target = "both_one" : this.target = this.chooseHandle(i)), this.target) {
          case "base":
            var s = (this.options.max - this.options.min) / 100,
              o = (this.result.from - this.options.min) / s,
              e = (this.result.to - this.options.min) / s;
            this.coords.p_single_real = this.toFixed(o), this.coords.p_from_real = this.toFixed(o), this.coords.p_to_real = this.toFixed(e), this.coords.p_single_real = this.checkDiapason(this.coords.p_single_real, this.options.from_min, this.options.from_max), this.coords.p_from_real = this.checkDiapason(this.coords.p_from_real, this.options.from_min, this.options.from_max), this.coords.p_to_real = this.checkDiapason(this.coords.p_to_real, this.options.to_min, this.options.to_max), this.coords.p_single_fake = this.convertToFakePercent(this.coords.p_single_real), this.coords.p_from_fake = this.convertToFakePercent(this.coords.p_from_real), this.coords.p_to_fake = this.convertToFakePercent(this.coords.p_to_real), this.target = null;
            break;
          case "single":
            if (this.options.from_fixed) break;
            this.coords.p_single_real = this.convertToRealPercent(i), this.coords.p_single_real = this.calcWithStep(this.coords.p_single_real), this.coords.p_single_real = this.checkDiapason(this.coords.p_single_real, this.options.from_min, this.options.from_max), this.coords.p_single_fake = this.convertToFakePercent(this.coords.p_single_real);
            break;
          case "from":
            if (this.options.from_fixed) break;
            this.coords.p_from_real = this.convertToRealPercent(i), this.coords.p_from_real = this.calcWithStep(this.coords.p_from_real), this.coords.p_from_real > this.coords.p_to_real && (this.coords.p_from_real = this.coords.p_to_real), this.coords.p_from_real = this.checkDiapason(this.coords.p_from_real, this.options.from_min, this.options.from_max), this.coords.p_from_real = this.checkMinInterval(this.coords.p_from_real, this.coords.p_to_real, "from"), this.coords.p_from_real = this.checkMaxInterval(this.coords.p_from_real, this.coords.p_to_real, "from"), this.coords.p_from_fake = this.convertToFakePercent(this.coords.p_from_real);
            break;
          case "to":
            if (this.options.to_fixed) break;
            this.coords.p_to_real = this.convertToRealPercent(i), this.coords.p_to_real = this.calcWithStep(this.coords.p_to_real), this.coords.p_to_real < this.coords.p_from_real && (this.coords.p_to_real = this.coords.p_from_real), this.coords.p_to_real = this.checkDiapason(this.coords.p_to_real, this.options.to_min, this.options.to_max), this.coords.p_to_real = this.checkMinInterval(this.coords.p_to_real, this.coords.p_from_real, "to"), this.coords.p_to_real = this.checkMaxInterval(this.coords.p_to_real, this.coords.p_from_real, "to"), this.coords.p_to_fake = this.convertToFakePercent(this.coords.p_to_real);
            break;
          case "both":
            if (this.options.from_fixed || this.options.to_fixed) break;
            i = this.toFixed(i + .001 * this.coords.p_handle), this.coords.p_from_real = this.convertToRealPercent(i) - this.coords.p_gap_left, this.coords.p_from_real = this.calcWithStep(this.coords.p_from_real), this.coords.p_from_real = this.checkDiapason(this.coords.p_from_real, this.options.from_min, this.options.from_max), this.coords.p_from_real = this.checkMinInterval(this.coords.p_from_real, this.coords.p_to_real, "from"), this.coords.p_from_fake = this.convertToFakePercent(this.coords.p_from_real), this.coords.p_to_real = this.convertToRealPercent(i) + this.coords.p_gap_right, this.coords.p_to_real = this.calcWithStep(this.coords.p_to_real), this.coords.p_to_real = this.checkDiapason(this.coords.p_to_real, this.options.to_min, this.options.to_max), this.coords.p_to_real = this.checkMinInterval(this.coords.p_to_real, this.coords.p_from_real, "to"), this.coords.p_to_fake = this.convertToFakePercent(this.coords.p_to_real);
            break;
          case "both_one":
            if (this.options.from_fixed || this.options.to_fixed) break;
            var h = this.convertToRealPercent(i),
              r = this.result.from_percent,
              n = this.result.to_percent - r,
              a = n / 2,
              c = h - a,
              l = h + a;
            c < 0 && (l = (c = 0) + n), l > 100 && (c = (l = 100) - n), this.coords.p_from_real = this.calcWithStep(c), this.coords.p_from_real = this.checkDiapason(this.coords.p_from_real, this.options.from_min, this.options.from_max), this.coords.p_from_fake = this.convertToFakePercent(this.coords.p_from_real), this.coords.p_to_real = this.calcWithStep(l), this.coords.p_to_real = this.checkDiapason(this.coords.p_to_real, this.options.to_min, this.options.to_max), this.coords.p_to_fake = this.convertToFakePercent(this.coords.p_to_real);
        }
        "single" === this.options.type ? (this.coords.p_bar_x = this.coords.p_handle / 2, this.coords.p_bar_w = this.coords.p_single_fake, this.result.from_percent = this.coords.p_single_real, this.result.from = this.convertToValue(this.coords.p_single_real), this.options.values.length && (this.result.from_value = this.options.values[this.result.from])) : (this.coords.p_bar_x = this.toFixed(this.coords.p_from_fake + this.coords.p_handle / 2), this.coords.p_bar_w = this.toFixed(this.coords.p_to_fake - this.coords.p_from_fake), this.result.from_percent = this.coords.p_from_real, this.result.from = this.convertToValue(this.coords.p_from_real), this.result.to_percent = this.coords.p_to_real, this.result.to = this.convertToValue(this.coords.p_to_real), this.options.values.length && (this.result.from_value = this.options.values[this.result.from], this.result.to_value = this.options.values[this.result.to])), this.calcMinMax(), this.calcLabels();
      }
    },
    calcPointerPercent: function calcPointerPercent() {
      this.coords.w_rs ? (this.coords.x_pointer < 0 || isNaN(this.coords.x_pointer) ? this.coords.x_pointer = 0 : this.coords.x_pointer > this.coords.w_rs && (this.coords.x_pointer = this.coords.w_rs), this.coords.p_pointer = this.toFixed(this.coords.x_pointer / this.coords.w_rs * 100)) : this.coords.p_pointer = 0;
    },
    convertToRealPercent: function convertToRealPercent(t) {
      return t / (100 - this.coords.p_handle) * 100;
    },
    convertToFakePercent: function convertToFakePercent(t) {
      return t / 100 * (100 - this.coords.p_handle);
    },
    getHandleX: function getHandleX() {
      var t = 100 - this.coords.p_handle,
        i = this.toFixed(this.coords.p_pointer - this.coords.p_gap);
      return i < 0 ? i = 0 : i > t && (i = t), i;
    },
    calcHandlePercent: function calcHandlePercent() {
      "single" === this.options.type ? this.coords.w_handle = this.$cache.s_single.outerWidth(!1) : this.coords.w_handle = this.$cache.s_from.outerWidth(!1), this.coords.p_handle = this.toFixed(this.coords.w_handle / this.coords.w_rs * 100);
    },
    chooseHandle: function chooseHandle(t) {
      return "single" === this.options.type ? "single" : t >= this.coords.p_from_real + (this.coords.p_to_real - this.coords.p_from_real) / 2 ? this.options.to_fixed ? "from" : "to" : this.options.from_fixed ? "to" : "from";
    },
    calcMinMax: function calcMinMax() {
      this.coords.w_rs && (this.labels.p_min = this.labels.w_min / this.coords.w_rs * 100, this.labels.p_max = this.labels.w_max / this.coords.w_rs * 100);
    },
    calcLabels: function calcLabels() {
      this.coords.w_rs && !this.options.hide_from_to && ("single" === this.options.type ? (this.labels.w_single = this.$cache.single.outerWidth(!1), this.labels.p_single_fake = this.labels.w_single / this.coords.w_rs * 100, this.labels.p_single_left = this.coords.p_single_fake + this.coords.p_handle / 2 - this.labels.p_single_fake / 2, this.labels.p_single_left = this.checkEdges(this.labels.p_single_left, this.labels.p_single_fake)) : (this.labels.w_from = this.$cache.from.outerWidth(!1), this.labels.p_from_fake = this.labels.w_from / this.coords.w_rs * 100, this.labels.p_from_left = this.coords.p_from_fake + this.coords.p_handle / 2 - this.labels.p_from_fake / 2, this.labels.p_from_left = this.toFixed(this.labels.p_from_left), this.labels.p_from_left = this.checkEdges(this.labels.p_from_left, this.labels.p_from_fake), this.labels.w_to = this.$cache.to.outerWidth(!1), this.labels.p_to_fake = this.labels.w_to / this.coords.w_rs * 100, this.labels.p_to_left = this.coords.p_to_fake + this.coords.p_handle / 2 - this.labels.p_to_fake / 2, this.labels.p_to_left = this.toFixed(this.labels.p_to_left), this.labels.p_to_left = this.checkEdges(this.labels.p_to_left, this.labels.p_to_fake), this.labels.w_single = this.$cache.single.outerWidth(!1), this.labels.p_single_fake = this.labels.w_single / this.coords.w_rs * 100, this.labels.p_single_left = (this.labels.p_from_left + this.labels.p_to_left + this.labels.p_to_fake) / 2 - this.labels.p_single_fake / 2, this.labels.p_single_left = this.toFixed(this.labels.p_single_left), this.labels.p_single_left = this.checkEdges(this.labels.p_single_left, this.labels.p_single_fake)));
    },
    updateScene: function updateScene() {
      this.raf_id && (cancelAnimationFrame(this.raf_id), this.raf_id = null), clearTimeout(this.update_tm), this.update_tm = null, this.options && (this.drawHandles(), this.is_active ? this.raf_id = requestAnimationFrame(this.updateScene.bind(this)) : this.update_tm = setTimeout(this.updateScene.bind(this), 300));
    },
    drawHandles: function drawHandles() {
      this.coords.w_rs = this.$cache.rs.outerWidth(!1), this.coords.w_rs && (this.coords.w_rs !== this.coords.w_rs_old && (this.target = "base", this.is_resize = !0), (this.coords.w_rs !== this.coords.w_rs_old || this.force_redraw) && (this.setMinMax(), this.calc(!0), this.drawLabels(), this.options.grid && (this.calcGridMargin(), this.calcGridLabels()), this.force_redraw = !0, this.coords.w_rs_old = this.coords.w_rs, this.drawShadow()), this.coords.w_rs && (this.dragging || this.force_redraw || this.is_key) && ((this.old_from !== this.result.from || this.old_to !== this.result.to || this.force_redraw || this.is_key) && (this.drawLabels(), this.$cache.bar[0].style.left = this.coords.p_bar_x + "%", this.$cache.bar[0].style.width = this.coords.p_bar_w + "%", "single" === this.options.type ? (this.$cache.s_single[0].style.left = this.coords.p_single_fake + "%", this.$cache.single[0].style.left = this.labels.p_single_left + "%") : (this.$cache.s_from[0].style.left = this.coords.p_from_fake + "%", this.$cache.s_to[0].style.left = this.coords.p_to_fake + "%", (this.old_from !== this.result.from || this.force_redraw) && (this.$cache.from[0].style.left = this.labels.p_from_left + "%"), (this.old_to !== this.result.to || this.force_redraw) && (this.$cache.to[0].style.left = this.labels.p_to_left + "%"), this.$cache.single[0].style.left = this.labels.p_single_left + "%"), this.writeToInput(), this.old_from === this.result.from && this.old_to === this.result.to || this.is_start || (this.$cache.input.trigger("change"), this.$cache.input.trigger("input")), this.old_from = this.result.from, this.old_to = this.result.to, this.is_resize || this.is_update || this.is_start || this.is_finish || this.callOnChange(), (this.is_key || this.is_click) && (this.is_key = !1, this.is_click = !1, this.callOnFinish()), this.is_update = !1, this.is_resize = !1, this.is_finish = !1), this.is_start = !1, this.is_key = !1, this.is_click = !1, this.force_redraw = !1));
    },
    drawLabels: function drawLabels() {
      if (this.options) {
        var t,
          i,
          s,
          o = this.options.values.length,
          e = this.options.p_values;
        if (!this.options.hide_from_to) if ("single" === this.options.type) o ? (t = this.decorate(e[this.result.from]), this.$cache.single.html(t)) : (t = this.decorate(this._prettify(this.result.from), this.result.from), this.$cache.single.html(t)), this.calcLabels(), this.labels.p_single_left < this.labels.p_min + 1 ? this.$cache.min[0].style.visibility = "hidden" : this.$cache.min[0].style.visibility = "visible", this.labels.p_single_left + this.labels.p_single_fake > 100 - this.labels.p_max - 1 ? this.$cache.max[0].style.visibility = "hidden" : this.$cache.max[0].style.visibility = "visible";else {
          o ? (this.options.decorate_both ? (t = this.decorate(e[this.result.from]), t += this.options.values_separator, t += this.decorate(e[this.result.to])) : t = this.decorate(e[this.result.from] + this.options.values_separator + e[this.result.to]), i = this.decorate(e[this.result.from]), s = this.decorate(e[this.result.to]), this.$cache.single.html(t), this.$cache.from.html(i), this.$cache.to.html(s)) : (this.options.decorate_both ? (t = this.decorate(this._prettify(this.result.from), this.result.from), t += this.options.values_separator, t += this.decorate(this._prettify(this.result.to), this.result.to)) : t = this.decorate(this._prettify(this.result.from) + this.options.values_separator + this._prettify(this.result.to), this.result.to), i = this.decorate(this._prettify(this.result.from), this.result.from), s = this.decorate(this._prettify(this.result.to), this.result.to), this.$cache.single.html(t), this.$cache.from.html(i), this.$cache.to.html(s)), this.calcLabels();
          var h = Math.min(this.labels.p_single_left, this.labels.p_from_left),
            r = this.labels.p_single_left + this.labels.p_single_fake,
            n = this.labels.p_to_left + this.labels.p_to_fake,
            a = Math.max(r, n);
          this.labels.p_from_left + this.labels.p_from_fake >= this.labels.p_to_left ? (this.$cache.from[0].style.visibility = "hidden", this.$cache.to[0].style.visibility = "hidden", this.$cache.single[0].style.visibility = "visible", this.result.from === this.result.to ? ("from" === this.target ? this.$cache.from[0].style.visibility = "visible" : "to" === this.target ? this.$cache.to[0].style.visibility = "visible" : this.target || (this.$cache.from[0].style.visibility = "visible"), this.$cache.single[0].style.visibility = "hidden", a = n) : (this.$cache.from[0].style.visibility = "hidden", this.$cache.to[0].style.visibility = "hidden", this.$cache.single[0].style.visibility = "visible", a = Math.max(r, n))) : (this.$cache.from[0].style.visibility = "visible", this.$cache.to[0].style.visibility = "visible", this.$cache.single[0].style.visibility = "hidden"), h < this.labels.p_min + 1 ? this.$cache.min[0].style.visibility = "hidden" : this.$cache.min[0].style.visibility = "visible", a > 100 - this.labels.p_max - 1 ? this.$cache.max[0].style.visibility = "hidden" : this.$cache.max[0].style.visibility = "visible";
        }
      }
    },
    drawShadow: function drawShadow() {
      var t,
        i,
        s,
        o,
        e = this.options,
        h = this.$cache,
        r = "number" == typeof e.from_min && !isNaN(e.from_min),
        n = "number" == typeof e.from_max && !isNaN(e.from_max),
        a = "number" == typeof e.to_min && !isNaN(e.to_min),
        c = "number" == typeof e.to_max && !isNaN(e.to_max);
      "single" === e.type ? e.from_shadow && (r || n) ? (t = this.convertToPercent(r ? e.from_min : e.min), i = this.convertToPercent(n ? e.from_max : e.max) - t, t = this.toFixed(t - this.coords.p_handle / 100 * t), i = this.toFixed(i - this.coords.p_handle / 100 * i), t += this.coords.p_handle / 2, h.shad_single[0].style.display = "block", h.shad_single[0].style.left = t + "%", h.shad_single[0].style.width = i + "%") : h.shad_single[0].style.display = "none" : (e.from_shadow && (r || n) ? (t = this.convertToPercent(r ? e.from_min : e.min), i = this.convertToPercent(n ? e.from_max : e.max) - t, t = this.toFixed(t - this.coords.p_handle / 100 * t), i = this.toFixed(i - this.coords.p_handle / 100 * i), t += this.coords.p_handle / 2, h.shad_from[0].style.display = "block", h.shad_from[0].style.left = t + "%", h.shad_from[0].style.width = i + "%") : h.shad_from[0].style.display = "none", e.to_shadow && (a || c) ? (s = this.convertToPercent(a ? e.to_min : e.min), o = this.convertToPercent(c ? e.to_max : e.max) - s, s = this.toFixed(s - this.coords.p_handle / 100 * s), o = this.toFixed(o - this.coords.p_handle / 100 * o), s += this.coords.p_handle / 2, h.shad_to[0].style.display = "block", h.shad_to[0].style.left = s + "%", h.shad_to[0].style.width = o + "%") : h.shad_to[0].style.display = "none");
    },
    writeToInput: function writeToInput() {
      "single" === this.options.type ? (this.options.values.length ? this.$cache.input.prop("value", this.result.from_value) : this.$cache.input.prop("value", this.result.from), this.$cache.input.data("from", this.result.from)) : (this.options.values.length ? this.$cache.input.prop("value", this.result.from_value + this.options.input_values_separator + this.result.to_value) : this.$cache.input.prop("value", this.result.from + this.options.input_values_separator + this.result.to), this.$cache.input.data("from", this.result.from), this.$cache.input.data("to", this.result.to));
    },
    callOnStart: function callOnStart() {
      this.writeToInput(), this.options.onStart && "function" == typeof this.options.onStart && this.options.onStart(this.result);
    },
    callOnChange: function callOnChange() {
      this.writeToInput(), this.options.onChange && "function" == typeof this.options.onChange && this.options.onChange(this.result);
    },
    callOnFinish: function callOnFinish() {
      this.writeToInput(), this.options.onFinish && "function" == typeof this.options.onFinish && this.options.onFinish(this.result);
    },
    callOnUpdate: function callOnUpdate() {
      this.writeToInput(), this.options.onUpdate && "function" == typeof this.options.onUpdate && this.options.onUpdate(this.result);
    },
    toggleInput: function toggleInput() {
      this.$cache.input.toggleClass("irs-hidden-input");
    },
    convertToPercent: function convertToPercent(t, i) {
      var s,
        o = this.options.max - this.options.min,
        e = o / 100;
      return o ? (s = (i ? t : t - this.options.min) / e, this.toFixed(s)) : (this.no_diapason = !0, 0);
    },
    convertToValue: function convertToValue(t) {
      var i,
        s,
        o = this.options.min,
        e = this.options.max,
        h = o.toString().split(".")[1],
        r = e.toString().split(".")[1],
        n = 0,
        a = 0;
      if (0 === t) return this.options.min;
      if (100 === t) return this.options.max;
      h && (n = i = h.length), r && (n = s = r.length), i && s && (n = i >= s ? i : s), o < 0 && (o = +(o + (a = Math.abs(o))).toFixed(n), e = +(e + a).toFixed(n));
      var c,
        l = (e - o) / 100 * t + o,
        _ = this.options.step.toString().split(".")[1];
      return _ ? l = +l.toFixed(_.length) : (l /= this.options.step, l = +(l *= this.options.step).toFixed(0)), a && (l -= a), (c = _ ? +l.toFixed(_.length) : this.toFixed(l)) < this.options.min ? c = this.options.min : c > this.options.max && (c = this.options.max), c;
    },
    calcWithStep: function calcWithStep(t) {
      var i = Math.round(t / this.coords.p_step) * this.coords.p_step;
      return i > 100 && (i = 100), 100 === t && (i = 100), this.toFixed(i);
    },
    checkMinInterval: function checkMinInterval(t, i, s) {
      var o,
        e,
        h = this.options;
      return h.min_interval ? (o = this.convertToValue(t), e = this.convertToValue(i), "from" === s ? e - o < h.min_interval && (o = e - h.min_interval) : o - e < h.min_interval && (o = e + h.min_interval), this.convertToPercent(o)) : t;
    },
    checkMaxInterval: function checkMaxInterval(t, i, s) {
      var o,
        e,
        h = this.options;
      return h.max_interval ? (o = this.convertToValue(t), e = this.convertToValue(i), "from" === s ? e - o > h.max_interval && (o = e - h.max_interval) : o - e > h.max_interval && (o = e + h.max_interval), this.convertToPercent(o)) : t;
    },
    checkDiapason: function checkDiapason(t, i, s) {
      var o = this.convertToValue(t),
        e = this.options;
      return "number" != typeof i && (i = e.min), "number" != typeof s && (s = e.max), o < i && (o = i), o > s && (o = s), this.convertToPercent(o);
    },
    toFixed: function toFixed(t) {
      return +(t = t.toFixed(20));
    },
    _prettify: function _prettify(t) {
      return this.options.prettify_enabled ? this.options.prettify && "function" == typeof this.options.prettify ? this.options.prettify(t) : this.prettify(t) : t;
    },
    prettify: function prettify(t) {
      return t.toString().replace(/(\d{1,3}(?=(?:\d\d\d)+(?!\d)))/g, "$1" + this.options.prettify_separator);
    },
    checkEdges: function checkEdges(t, i) {
      return this.options.force_edges ? (t < 0 ? t = 0 : t > 100 - i && (t = 100 - i), this.toFixed(t)) : this.toFixed(t);
    },
    validate: function validate() {
      var t,
        i,
        s = this.options,
        o = this.result,
        e = s.values,
        h = e.length;
      if ("string" == typeof s.min && (s.min = +s.min), "string" == typeof s.max && (s.max = +s.max), "string" == typeof s.from && (s.from = +s.from), "string" == typeof s.to && (s.to = +s.to), "string" == typeof s.step && (s.step = +s.step), "string" == typeof s.from_min && (s.from_min = +s.from_min), "string" == typeof s.from_max && (s.from_max = +s.from_max), "string" == typeof s.to_min && (s.to_min = +s.to_min), "string" == typeof s.to_max && (s.to_max = +s.to_max), "string" == typeof s.keyboard_step && (s.keyboard_step = +s.keyboard_step), "string" == typeof s.grid_num && (s.grid_num = +s.grid_num), s.max < s.min && (s.max = s.min), h) for (s.p_values = [], s.min = 0, s.max = h - 1, s.step = 1, s.grid_num = s.max, s.grid_snap = !0, i = 0; i < h; i++) {
        t = +e[i], isNaN(t) ? t = e[i] : (e[i] = t, t = this._prettify(t)), s.p_values.push(t);
      }
      ("number" != typeof s.from || isNaN(s.from)) && (s.from = s.min), ("number" != typeof s.to || isNaN(s.to)) && (s.to = s.max), "single" === s.type ? (s.from < s.min && (s.from = s.min), s.from > s.max && (s.from = s.max)) : (s.from < s.min && (s.from = s.min), s.from > s.max && (s.from = s.max), s.to < s.min && (s.to = s.min), s.to > s.max && (s.to = s.max), this.update_check.from && (this.update_check.from !== s.from && s.from > s.to && (s.from = s.to), this.update_check.to !== s.to && s.to < s.from && (s.to = s.from)), s.from > s.to && (s.from = s.to), s.to < s.from && (s.to = s.from)), ("number" != typeof s.step || isNaN(s.step) || !s.step || s.step < 0) && (s.step = 1), ("number" != typeof s.keyboard_step || isNaN(s.keyboard_step) || !s.keyboard_step || s.keyboard_step < 0) && (s.keyboard_step = 5), "number" == typeof s.from_min && s.from < s.from_min && (s.from = s.from_min), "number" == typeof s.from_max && s.from > s.from_max && (s.from = s.from_max), "number" == typeof s.to_min && s.to < s.to_min && (s.to = s.to_min), "number" == typeof s.to_max && s.from > s.to_max && (s.to = s.to_max), o && (o.min !== s.min && (o.min = s.min), o.max !== s.max && (o.max = s.max), (o.from < o.min || o.from > o.max) && (o.from = s.from), (o.to < o.min || o.to > o.max) && (o.to = s.to)), ("number" != typeof s.min_interval || isNaN(s.min_interval) || !s.min_interval || s.min_interval < 0) && (s.min_interval = 0), ("number" != typeof s.max_interval || isNaN(s.max_interval) || !s.max_interval || s.max_interval < 0) && (s.max_interval = 0), s.min_interval && s.min_interval > s.max - s.min && (s.min_interval = s.max - s.min), s.max_interval && s.max_interval > s.max - s.min && (s.max_interval = s.max - s.min);
    },
    decorate: function decorate(t, i) {
      var s = "",
        o = this.options;
      return o.prefix && (s += o.prefix), s += t, o.max_postfix && (o.values.length && t === o.p_values[o.max] ? (s += o.max_postfix, o.postfix && (s += " ")) : i === o.max && (s += o.max_postfix, o.postfix && (s += " "))), o.postfix && (s += o.postfix), s;
    },
    updateFrom: function updateFrom() {
      this.result.from = this.options.from, this.result.from_percent = this.convertToPercent(this.result.from), this.options.values && (this.result.from_value = this.options.values[this.result.from]);
    },
    updateTo: function updateTo() {
      this.result.to = this.options.to, this.result.to_percent = this.convertToPercent(this.result.to), this.options.values && (this.result.to_value = this.options.values[this.result.to]);
    },
    updateResult: function updateResult() {
      this.result.min = this.options.min, this.result.max = this.options.max, this.updateFrom(), this.updateTo();
    },
    appendGrid: function appendGrid() {
      if (this.options.grid) {
        var t,
          i,
          s,
          o,
          e,
          h = this.options,
          r = h.max - h.min,
          n = h.grid_num,
          a = 0,
          c = 0,
          l = 4,
          _ = "";
        for (this.calcGridMargin(), h.grid_snap ? r > 50 ? (n = 50 / h.step, a = this.toFixed(h.step / .5)) : (n = r / h.step, a = this.toFixed(h.step / (r / 100))) : a = this.toFixed(100 / n), n > 4 && (l = 3), n > 7 && (l = 2), n > 14 && (l = 1), n > 28 && (l = 0), t = 0; t < n + 1; t++) {
          for (s = l, (c = this.toFixed(a * t)) > 100 && (c = 100, (s -= 2) < 0 && (s = 0)), this.coords.big[t] = c, o = (c - a * (t - 1)) / (s + 1), i = 1; i <= s && 0 !== c; i++) {
            _ += '<span class="irs-grid-pol small" style="left: ' + this.toFixed(c - o * i) + '%"></span>';
          }
          _ += '<span class="irs-grid-pol" style="left: ' + c + '%"></span>', e = this.convertToValue(c), _ += '<span class="irs-grid-text js-grid-text-' + t + '" style="left: ' + c + '%">' + (e = h.values.length ? h.p_values[e] : this._prettify(e)) + "</span>";
        }
        this.coords.big_num = Math.ceil(n + 1), this.$cache.cont.addClass("irs-with-grid"), this.$cache.grid.html(_), this.cacheGridLabels();
      }
    },
    cacheGridLabels: function cacheGridLabels() {
      var t,
        i,
        s = this.coords.big_num;
      for (i = 0; i < s; i++) {
        t = this.$cache.grid.find(".js-grid-text-" + i), this.$cache.grid_labels.push(t);
      }
      this.calcGridLabels();
    },
    calcGridLabels: function calcGridLabels() {
      var t,
        i,
        s = [],
        o = [],
        e = this.coords.big_num;
      for (t = 0; t < e; t++) {
        this.coords.big_w[t] = this.$cache.grid_labels[t].outerWidth(!1), this.coords.big_p[t] = this.toFixed(this.coords.big_w[t] / this.coords.w_rs * 100), this.coords.big_x[t] = this.toFixed(this.coords.big_p[t] / 2), s[t] = this.toFixed(this.coords.big[t] - this.coords.big_x[t]), o[t] = this.toFixed(s[t] + this.coords.big_p[t]);
      }
      for (this.options.force_edges && (s[0] < -this.coords.grid_gap && (s[0] = -this.coords.grid_gap, o[0] = this.toFixed(s[0] + this.coords.big_p[0]), this.coords.big_x[0] = this.coords.grid_gap), o[e - 1] > 100 + this.coords.grid_gap && (o[e - 1] = 100 + this.coords.grid_gap, s[e - 1] = this.toFixed(o[e - 1] - this.coords.big_p[e - 1]), this.coords.big_x[e - 1] = this.toFixed(this.coords.big_p[e - 1] - this.coords.grid_gap))), this.calcGridCollision(2, s, o), this.calcGridCollision(4, s, o), t = 0; t < e; t++) {
        i = this.$cache.grid_labels[t][0], this.coords.big_x[t] !== Number.POSITIVE_INFINITY && (i.style.marginLeft = -this.coords.big_x[t] + "%");
      }
    },
    calcGridCollision: function calcGridCollision(t, i, s) {
      var o,
        e,
        h,
        r = this.coords.big_num;
      for (o = 0; o < r && !((e = o + t / 2) >= r); o += t) {
        h = this.$cache.grid_labels[e][0], s[o] <= i[e] ? h.style.visibility = "visible" : h.style.visibility = "hidden";
      }
    },
    calcGridMargin: function calcGridMargin() {
      this.options.grid_margin && (this.coords.w_rs = this.$cache.rs.outerWidth(!1), this.coords.w_rs && ("single" === this.options.type ? this.coords.w_handle = this.$cache.s_single.outerWidth(!1) : this.coords.w_handle = this.$cache.s_from.outerWidth(!1), this.coords.p_handle = this.toFixed(this.coords.w_handle / this.coords.w_rs * 100), this.coords.grid_gap = this.toFixed(this.coords.p_handle / 2 - .1), this.$cache.grid[0].style.width = this.toFixed(100 - this.coords.p_handle) + "%", this.$cache.grid[0].style.left = this.coords.grid_gap + "%"));
    },
    update: function update(i) {
      this.input && (this.is_update = !0, this.options.from = this.result.from, this.options.to = this.result.to, this.update_check.from = this.result.from, this.update_check.to = this.result.to, this.options = t.extend(this.options, i), this.validate(), this.updateResult(i), this.toggleInput(), this.remove(), this.init(!0));
    },
    reset: function reset() {
      this.input && (this.updateResult(), this.update());
    },
    destroy: function destroy() {
      this.input && (this.toggleInput(), this.$cache.input.prop("readonly", !1), t.data(this.input, "ionRangeSlider", null), this.remove(), this.input = null, this.options = null);
    }
  }, t.fn.ionRangeSlider = function (i) {
    return this.each(function () {
      t.data(this, "ionRangeSlider") || t.data(this, "ionRangeSlider", new c(this, i, n++));
    });
  }, function () {
    for (var t = 0, i = ["ms", "moz", "webkit", "o"], o = 0; o < i.length && !s.requestAnimationFrame; ++o) {
      s.requestAnimationFrame = s[i[o] + "RequestAnimationFrame"], s.cancelAnimationFrame = s[i[o] + "CancelAnimationFrame"] || s[i[o] + "CancelRequestAnimationFrame"];
    }
    s.requestAnimationFrame || (s.requestAnimationFrame = function (i, o) {
      var e = new Date().getTime(),
        h = Math.max(0, 16 - (e - t)),
        r = s.setTimeout(function () {
          i(e + h);
        }, h);
      return t = e + h, r;
    }), s.cancelAnimationFrame || (s.cancelAnimationFrame = function (t) {
      clearTimeout(t);
    });
  }();
}), $(function () {
  var t,
    i = $(".js-range-slider"),
    s = $(".js-input-from"),
    o = $(".js-input-to"),
    e = 0,
    h = 0;
  function r(t) {
    e = t.from, h = t.to, s.prop("value", e), o.prop("value", h);
  }
  i.ionRangeSlider({
    type: "double",
    min: 0,
    max: 1e6,
    from: 0,
    to: 5e5,
    prefix: "$",
    onStart: r,
    onChange: r,
    step: 5e4,
    prettify_enabled: !0,
    prettify_separator: ".",
    values_separator: " - ",
    force_edges: !0
  }), t = i.data("ionRangeSlider"), s.on("input", function () {
    var i = $(this).prop("value");
    i < 0 ? i = 0 : i > h && (i = h), t.update({
      from: i
    });
  }), o.on("input", function () {
    var i = $(this).prop("value");
    i < e ? i = e : i > 1e6 && (i = 1e6), t.update({
      to: i
    });
  });
});

/***/ }),

/***/ "./public/frontend/default/vendors/gijgo/gijgo.min.js":
/*!************************************************************!*\
  !*** ./public/frontend/default/vendors/gijgo/gijgo.min.js ***!
  \************************************************************/
/***/ (() => {

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var gj = {
  widget: function widget() {
    var e = this;
    e.xhr = null, e.generateGUID = function () {
      function e() {
        return Math.floor(65536 * (1 + Math.random())).toString(16).substring(1);
      }
      return e() + e() + "-" + e() + "-" + e() + "-" + e() + "-" + e() + e() + e();
    }, e.mouseX = function (e) {
      if (e) {
        if (e.pageX) return e.pageX;
        if (e.clientX) return e.clientX + (document.documentElement.scrollLeft ? document.documentElement.scrollLeft : document.body.scrollLeft);
        if (e.touches && e.touches.length) return e.touches[0].pageX;
        if (e.changedTouches && e.changedTouches.length) return e.changedTouches[0].pageX;
        if (e.originalEvent && e.originalEvent.touches && e.originalEvent.touches.length) return e.originalEvent.touches[0].pageX;
        if (e.originalEvent && e.originalEvent.changedTouches && e.originalEvent.changedTouches.length) return e.originalEvent.touches[0].pageX;
      }
      return null;
    }, e.mouseY = function (e) {
      if (e) {
        if (e.pageY) return e.pageY;
        if (e.clientY) return e.clientY + (document.documentElement.scrollTop ? document.documentElement.scrollTop : document.body.scrollTop);
        if (e.touches && e.touches.length) return e.touches[0].pageY;
        if (e.changedTouches && e.changedTouches.length) return e.changedTouches[0].pageY;
        if (e.originalEvent && e.originalEvent.touches && e.originalEvent.touches.length) return e.originalEvent.touches[0].pageY;
        if (e.originalEvent && e.originalEvent.changedTouches && e.originalEvent.changedTouches.length) return e.originalEvent.touches[0].pageY;
      }
      return null;
    };
  }
};
gj.widget.prototype.init = function (e, t) {
  var r, a, i;
  for (r in this.attr("data-type", t), a = $.extend(!0, {}, this.getHTMLConfig() || {}), $.extend(!0, a, e || {}), i = this.getConfig(a, t), this.attr("data-guid", i.guid), this.data(i), i) {
    gj[t].events.hasOwnProperty(r) && (this.on(r, i[r]), delete i[r]);
  }
  for (plugin in gj[t].plugins) {
    gj[t].plugins.hasOwnProperty(plugin) && gj[t].plugins[plugin].configure(this, i, a);
  }
  return this;
}, gj.widget.prototype.getConfig = function (e, t) {
  var r, a, i, o;
  for (o in r = $.extend(!0, {}, gj[t].config.base), a = e.hasOwnProperty("uiLibrary") ? e.uiLibrary : r.uiLibrary, gj[t].config[a] && $.extend(!0, r, gj[t].config[a]), i = e.hasOwnProperty("iconsLibrary") ? e.iconsLibrary : r.iconsLibrary, gj[t].config[i] && $.extend(!0, r, gj[t].config[i]), gj[t].plugins) {
    gj[t].plugins.hasOwnProperty(o) && ($.extend(!0, r, gj[t].plugins[o].config.base), gj[t].plugins[o].config[a] && $.extend(!0, r, gj[t].plugins[o].config[a]), gj[t].plugins[o].config[i] && $.extend(!0, r, gj[t].plugins[o].config[i]));
  }
  return $.extend(!0, r, e), r.guid || (r.guid = this.generateGUID()), r;
}, gj.widget.prototype.getHTMLConfig = function () {
  var e = this.data(),
    t = this[0].attributes;
  return t.width && (e.width = t.width.value), t.height && (e.height = t.height.value), t.value && (e.value = t.value.value), t.align && (e.align = t.align.value), e && e.source && (e.dataSource = e.source, delete e.source), e;
}, gj.widget.prototype.createDoneHandler = function () {
  var e = this;
  return function (t) {
    "string" == typeof t && JSON && (t = JSON.parse(t)), gj[e.data("type")].methods.render(e, t);
  };
}, gj.widget.prototype.createErrorHandler = function () {
  return function (e) {
    e && e.statusText && "abort" !== e.statusText && alert(e.statusText);
  };
}, gj.widget.prototype.reload = function (e) {
  var t,
    r,
    a = this.data(),
    i = this.data("type");
  return void 0 === a.dataSource && gj[i].methods.useHtmlDataSource(this, a), $.extend(a.params, e), $.isArray(a.dataSource) ? (r = gj[i].methods.filter(this), gj[i].methods.render(this, r)) : "string" == typeof a.dataSource ? (t = {
    url: a.dataSource,
    data: a.params
  }, this.xhr && this.xhr.abort(), this.xhr = $.ajax(t).done(this.createDoneHandler()).fail(this.createErrorHandler())) : "object" == _typeof(a.dataSource) && (a.dataSource.data || (a.dataSource.data = {}), $.extend(a.dataSource.data, a.params), "json" === (t = $.extend(!0, {}, a.dataSource)).dataType && "object" == _typeof(t.data) && (t.data = JSON.stringify(t.data)), t.success || (t.success = this.createDoneHandler()), t.error || (t.error = this.createErrorHandler()), this.xhr && this.xhr.abort(), this.xhr = $.ajax(t)), this;
}, gj.documentManager = {
  events: {},
  subscribeForEvent: function subscribeForEvent(e, t, r) {
    if (gj.documentManager.events[e] && 0 !== gj.documentManager.events[e].length) {
      if (gj.documentManager.events[e][t]) throw "Event " + e + ' for widget with guid="' + t + '" is already attached.';
      gj.documentManager.events[e].push({
        widgetId: t,
        callback: r
      });
    } else gj.documentManager.events[e] = [{
      widgetId: t,
      callback: r
    }], $(document).on(e, gj.documentManager.executeCallbacks);
  },
  executeCallbacks: function executeCallbacks(e) {
    var t = gj.documentManager.events[e.type];
    if (t) for (var r = 0; r < t.length; r++) {
      t[r].callback(e);
    }
  },
  unsubscribeForEvent: function unsubscribeForEvent(e, t) {
    var r = !1,
      a = gj.documentManager.events[e];
    if (a) for (var i = 0; i < a.length; i++) {
      a[i].widgetId === t && (a.splice(i, 1), r = !0, 0 === a.length && ($(document).off(e), delete gj.documentManager.events[e]));
    }
    if (!r) throw 'The "' + e + '" for widget with guid="' + t + "\" can't be removed.";
  }
}, gj.core = {
  messages: {
    "en-us": {
      monthNames: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
      monthShortNames: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
      weekDaysMin: ["S", "M", "T", "W", "T", "F", "S"],
      weekDaysShort: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
      weekDays: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
      am: "AM",
      pm: "PM",
      ok: "Ok",
      cancel: "Cancel",
      titleFormat: "mmmm yyyy"
    }
  },
  parseDate: function parseDate(e, t, r) {
    var a,
      i,
      o,
      n,
      d = 0,
      s = 0,
      l = 1,
      c = 0,
      g = 0;
    if (e && "string" == typeof e) {
      if (/^\d+$/.test(e)) n = new Date(e);else if (e.indexOf("/Date(") > -1) n = new Date(parseInt(e.substr(6), 10));else if (e) {
        for (o = t.split(/[\s,-\.\/\/\:]+/), (i = e.split(/[\s]+/)).length != o.length && (i = e.split(/[\s,-\.\/\/\:]+/)), a = 0; a < o.length; a++) {
          ["d", "dd"].indexOf(o[a]) > -1 ? l = parseInt(i[a], 10) : ["m", "mm"].indexOf(o[a]) > -1 ? s = parseInt(i[a], 10) - 1 : "mmm" === o[a] ? s = gj.core.messages[r || "en-us"].monthShortNames.indexOf(i[a]) : "mmmm" === o[a] ? s = gj.core.messages[r || "en-us"].monthNames.indexOf(i[a]) : ["yy", "yyyy"].indexOf(o[a]) > -1 ? (d = parseInt(i[a], 10), "yy" === o[a] && (d += 2e3)) : ["h", "hh", "H", "HH"].indexOf(o[a]) > -1 ? c = parseInt(i[a], 10) : ["M", "MM"].indexOf(o[a]) > -1 && (g = parseInt(i[a], 10));
        }
        n = new Date(d, s, l, c, g);
      }
    } else "number" == typeof e ? n = new Date(e) : e instanceof Date && (n = e);
    return n;
  },
  formatDate: function formatDate(e, t, r) {
    var a,
      o,
      n = "",
      d = t.split(/[\s,-\.\/\/\:]+/),
      s = t.split(/s+|M+|H+|h+|t+|T+|d+|m+|y+/);
    for (s = s.splice(1, s.length - 2), i = 0; i < d.length; i++) {
      switch (a = s[i] || "", d[i]) {
        case "s":
          n += e.getSeconds() + a;
          break;
        case "ss":
          n += gj.core.pad(e.getSeconds()) + a;
          break;
        case "M":
          n += e.getMinutes() + a;
          break;
        case "MM":
          n += gj.core.pad(e.getMinutes()) + a;
          break;
        case "H":
          n += e.getHours() + a;
          break;
        case "HH":
          n += gj.core.pad(e.getHours()) + a;
          break;
        case "h":
          n += (o = e.getHours() > 12 ? e.getHours() % 12 : e.getHours()) + a;
          break;
        case "hh":
          o = e.getHours() > 12 ? e.getHours() % 12 : e.getHours(), n += gj.core.pad(o) + a;
          break;
        case "tt":
          n += (e.getHours() >= 12 ? "pm" : "am") + a;
          break;
        case "TT":
          n += (e.getHours() >= 12 ? "PM" : "AM") + a;
          break;
        case "d":
          n += e.getDate() + a;
          break;
        case "dd":
          n += gj.core.pad(e.getDate()) + a;
          break;
        case "ddd":
          n += gj.core.messages[r || "en-us"].weekDaysShort[e.getDay()] + a;
          break;
        case "dddd":
          n += gj.core.messages[r || "en-us"].weekDays[e.getDay()] + a;
          break;
        case "m":
          n += e.getMonth() + 1 + a;
          break;
        case "mm":
          n += gj.core.pad(e.getMonth() + 1) + a;
          break;
        case "mmm":
          n += gj.core.messages[r || "en-us"].monthShortNames[e.getMonth()] + a;
          break;
        case "mmmm":
          n += gj.core.messages[r || "en-us"].monthNames[e.getMonth()] + a;
          break;
        case "yy":
          n += e.getFullYear().toString().substr(2) + a;
          break;
        case "yyyy":
          n += e.getFullYear() + a;
      }
    }
    return n;
  },
  pad: function pad(e, t) {
    for (e = String(e), t = t || 2; e.length < t;) {
      e = "0" + e;
    }
    return e;
  },
  center: function center(e) {
    var t = $(window).width() / 2 - e.width() / 2,
      r = $(window).height() / 2 - e.height() / 2;
    e.css("position", "absolute"), e.css("left", t > 0 ? t : 0), e.css("top", r > 0 ? r : 0);
  },
  isIE: function isIE() {
    return !!navigator.userAgent.match(/Trident/g) || !!navigator.userAgent.match(/MSIE/g);
  },
  setChildPosition: function setChildPosition(e, t) {
    var r = e.getBoundingClientRect(),
      a = gj.core.height(e, !0),
      i = gj.core.height(t, !0),
      o = gj.core.width(e, !0),
      n = gj.core.width(t, !0),
      d = window.scrollY || window.pageYOffset || 0,
      s = window.scrollX || window.pageXOffset || 0;
    r.top + a + i > window.innerHeight && r.top > i ? t.style.top = Math.round(r.top + d - i - 3) + "px" : t.style.top = Math.round(r.top + d + a + 3) + "px", r.left + n > document.body.clientWidth ? t.style.left = Math.round(r.left + s + o - n) + "px" : t.style.left = Math.round(r.left + s) + "px";
  },
  height: function height(e, t) {
    var r,
      a = window.getComputedStyle(e);
    return "border-box" === a.boxSizing ? (r = parseInt(a.height, 10), gj.core.isIE() && (r += parseInt(a.paddingTop || 0, 10) + parseInt(a.paddingBottom || 0, 10), r += parseInt(a.borderTopWidth || 0, 10) + parseInt(a.borderBottomWidth || 0, 10))) : (r = parseInt(a.height, 10), r += parseInt(a.paddingTop || 0, 10) + parseInt(a.paddingBottom || 0, 10), r += parseInt(a.borderTopWidth || 0, 10) + parseInt(a.borderBottomWidth || 0, 10)), t && (r += parseInt(a.marginTop || 0, 10) + parseInt(a.marginBottom || 0, 10)), r;
  },
  width: function width(e, t) {
    var r,
      a = window.getComputedStyle(e);
    return "border-box" === a.boxSizing ? r = parseInt(a.width, 10) : (r = parseInt(a.width, 10), r += parseInt(a.paddingLeft || 0, 10) + parseInt(a.paddingRight || 0, 10), r += parseInt(a.borderLeftWidth || 0, 10) + parseInt(a.borderRightWidth || 0, 10)), t && (r += parseInt(a.marginLeft || 0, 10) + parseInt(a.marginRight || 0, 10)), r;
  },
  addClasses: function addClasses(e, t) {
    var r, a;
    if (t) for (a = t.split(" "), r = 0; r < a.length; r++) {
      e.classList.add(a[r]);
    }
  },
  position: function position(e) {
    for (var t, r, a = 0, i = 0, o = gj.core.height(e), n = gj.core.width(e); e;) {
      "BODY" == e.tagName ? (t = e.scrollLeft || document.documentElement.scrollLeft, r = e.scrollTop || document.documentElement.scrollTop, a += e.offsetLeft - t, i += e.offsetTop - r) : (a += e.offsetLeft - e.scrollLeft, i += e.offsetTop - e.scrollTop), e = e.offsetParent;
    }
    return {
      top: i,
      left: a,
      bottom: i + o,
      right: a + n
    };
  },
  setCaretAtEnd: function setCaretAtEnd(e) {
    var t;
    if (e) if (t = e.value.length, document.selection) {
      e.focus();
      var r = document.selection.createRange();
      r.moveStart("character", -t), r.moveStart("character", t), r.moveEnd("character", 0), r.select();
    } else (e.selectionStart || "0" == e.selectionStart) && (e.selectionStart = t, e.selectionEnd = t, e.focus());
  },
  getScrollParent: function getScrollParent(e) {
    return null == e ? null : e.scrollHeight > e.clientHeight ? e : gj.core.getScrollParent(e.parentNode);
  }
}, gj.picker = {
  messages: {
    "en-us": {}
  }
}, gj.picker.methods = {
  initialize: function initialize(e, t, r) {
    var a,
      i = r.createPicker(e, t),
      o = e.parent('div[role="wrapper"]');
    (a = "bootstrap" === t.uiLibrary ? $('<span class="input-group-addon">' + t.icons.rightIcon + "</span>") : "bootstrap4" === t.uiLibrary ? $('<span class="input-group-append"><button class="btn btn-outline-secondary border-left-0" type="button">' + t.icons.rightIcon + "</button></span>") : $(t.icons.rightIcon)).attr("role", "right-icon"), 0 === o.length ? (o = $('<div role="wrapper" />').addClass(t.style.wrapper), e.wrap(o)) : o.addClass(t.style.wrapper), o = e.parent('div[role="wrapper"]'), t.width && o.css("width", t.width), e.val(t.value).addClass(t.style.input).attr("role", "input"), t.fontSize && e.css("font-size", t.fontSize), "bootstrap" === t.uiLibrary || "bootstrap4" === t.uiLibrary ? "small" === t.size ? (o.addClass("input-group-sm"), e.addClass("form-control-sm")) : "large" === t.size && (o.addClass("input-group-lg"), e.addClass("form-control-lg")) : "small" === t.size ? o.addClass("small") : "large" === t.size && o.addClass("large"), a.on("click", function (t) {
      i.is(":visible") ? e.close() : e.open();
    }), o.append(a), !0 !== t.footer && (e.on("blur", function () {
      e.timeout = setTimeout(function () {
        e.close();
      }, 500);
    }), i.mousedown(function () {
      return clearTimeout(e.timeout), e.focus(), !1;
    }), i.on("click", function () {
      clearTimeout(e.timeout), e.focus();
    }));
  }
}, gj.picker.widget = function (e, t) {
  var r = gj.picker.methods;
  return this.destroy = function () {
    return r.destroy(this);
  }, e;
}, gj.picker.widget.prototype = new gj.widget(), gj.picker.widget.constructor = gj.picker.widget, gj.picker.widget.prototype.init = function (e, t, r) {
  return gj.widget.prototype.init.call(this, e, t), this.attr("data-" + t, "true"), gj.picker.methods.initialize(this, this.data(), gj[t].methods), this;
}, gj.picker.widget.prototype.open = function (e) {
  var t = this.data(),
    r = $("body").find('[role="picker"][guid="' + this.attr("data-guid") + '"]');
  return r.show(), r.closest('div[role="modal"]').show(), t.modal ? gj.core.center(r) : (gj.core.setChildPosition(this[0], r[0]), this.focus()), clearTimeout(this.timeout), gj[e].events.open(this), this;
}, gj.picker.widget.prototype.close = function (e) {
  var t = $("body").find('[role="picker"][guid="' + this.attr("data-guid") + '"]');
  return t.hide(), t.closest('div[role="modal"]').hide(), gj[e].events.close(this), this;
}, gj.picker.widget.prototype.destroy = function (e) {
  var t = this.data(),
    r = this.parent(),
    a = $("body").find('[role="picker"][guid="' + this.attr("data-guid") + '"]');
  return t && (this.off(), a.parent('[role="modal"]').length > 0 && a.unwrap(), a.remove(), this.removeData(), this.removeAttr("data-type").removeAttr("data-guid").removeAttr("data-" + e), this.removeClass(), r.children('[role="right-icon"]').remove(), this.unwrap()), this;
}, gj.dialog = {
  plugins: {},
  messages: {}
}, gj.dialog.config = {
  base: {
    autoOpen: !0,
    closeButtonInHeader: !0,
    closeOnEscape: !0,
    draggable: !0,
    height: "auto",
    locale: "en-us",
    maxHeight: void 0,
    maxWidth: void 0,
    minHeight: void 0,
    minWidth: void 0,
    modal: !1,
    resizable: !1,
    scrollable: !1,
    title: void 0,
    uiLibrary: void 0,
    width: 300,
    style: {
      modal: "gj-modal",
      content: "gj-dialog-md",
      header: "gj-dialog-md-header gj-unselectable",
      headerTitle: "gj-dialog-md-title",
      headerCloseButton: "gj-dialog-md-close",
      body: "gj-dialog-md-body",
      footer: "gj-dialog-footer gj-dialog-md-footer"
    }
  },
  bootstrap: {
    style: {
      modal: "modal",
      content: "modal-content gj-dialog-bootstrap",
      header: "modal-header",
      headerTitle: "modal-title",
      headerCloseButton: "close",
      body: "modal-body",
      footer: "gj-dialog-footer modal-footer"
    }
  },
  bootstrap4: {
    style: {
      modal: "modal",
      content: "modal-content gj-dialog-bootstrap4",
      header: "modal-header",
      headerTitle: "modal-title",
      headerCloseButton: "close",
      body: "modal-body",
      footer: "gj-dialog-footer modal-footer"
    }
  }
}, gj.dialog.events = {
  initialized: function initialized(e) {
    e.trigger("initialized");
  },
  opening: function opening(e) {
    e.trigger("opening");
  },
  opened: function opened(e) {
    e.trigger("opened");
  },
  closing: function closing(e) {
    e.trigger("closing");
  },
  closed: function closed(e) {
    e.trigger("closed");
  },
  drag: function drag(e) {
    e.trigger("drag");
  },
  dragStart: function dragStart(e) {
    e.trigger("dragStart");
  },
  dragStop: function dragStop(e) {
    e.trigger("dragStop");
  },
  resize: function resize(e) {
    e.trigger("resize");
  },
  resizeStart: function resizeStart(e) {
    e.trigger("resizeStart");
  },
  resizeStop: function resizeStop(e) {
    e.trigger("resizeStop");
  }
}, gj.dialog.methods = {
  init: function init(e) {
    return gj.widget.prototype.init.call(this, e, "dialog"), gj.dialog.methods.localization(this), gj.dialog.methods.initialize(this), gj.dialog.events.initialized(this), this;
  },
  localization: function localization(e) {
    var t = e.data();
    void 0 === t.title && (t.title = gj.dialog.messages[t.locale].DefaultTitle);
  },
  getHTMLConfig: function getHTMLConfig() {
    var e = gj.widget.prototype.getHTMLConfig.call(this),
      t = this[0].attributes;
    return t.title && (e.title = t.title.value), e;
  },
  initialize: function initialize(e) {
    var t,
      r,
      a,
      i = e.data();
    e.addClass(i.style.content), gj.dialog.methods.setSize(e), i.closeOnEscape && $(document).keyup(function (t) {
      27 === t.keyCode && e.close();
    }), 0 === (r = e.children('div[data-role="body"]')).length ? (r = $('<div data-role="body"/>').addClass(i.style.body), e.wrapInner(r)) : r.addClass(i.style.body), t = gj.dialog.methods.renderHeader(e), a = e.children('div[data-role="footer"]').addClass(i.style.footer), e.find('[data-role="close"]').on("click", function () {
      e.close();
    }), gj.draggable && (i.draggable && gj.dialog.methods.draggable(e, t), i.resizable && gj.dialog.methods.resizable(e)), i.scrollable && i.height && (e.addClass("gj-dialog-scrollable"), e.on("opened", function () {
      e.children('div[data-role="body"]').css("height", i.height - t.outerHeight() - (a.length ? a.outerHeight() : 0));
    })), gj.core.center(e), i.modal && e.wrapAll('<div data-role="modal" class="' + i.style.modal + '"/>'), i.autoOpen && e.open();
  },
  setSize: function setSize(e) {
    var t = e.data();
    t.width && e.css("width", t.width), t.height && e.css("height", t.height);
  },
  renderHeader: function renderHeader(e) {
    var t,
      r,
      a,
      i = e.data();
    return 0 === (t = e.children('div[data-role="header"]')).length && (t = $('<div data-role="header" />'), e.prepend(t)), t.addClass(i.style.header), 0 === (r = t.find('[data-role="title"]')).length && (r = $('<h4 data-role="title">' + i.title + "</h4>"), t.append(r)), r.addClass(i.style.headerTitle), 0 === (a = t.find('[data-role="close"]')).length && i.closeButtonInHeader ? ((a = $('<button type="button" data-role="close" title="' + gj.dialog.messages[i.locale].Close + '"><span>×</span></button>')).addClass(i.style.headerCloseButton), t.append(a)) : a.length > 0 && !1 === i.closeButtonInHeader ? a.hide() : a.addClass(i.style.headerCloseButton), t;
  },
  draggable: function draggable(e, t) {
    e.appendTo("body"), t.addClass("gj-draggable"), e.draggable({
      handle: t,
      start: function start() {
        e.addClass("gj-unselectable"), gj.dialog.events.dragStart(e);
      },
      stop: function stop() {
        e.removeClass("gj-unselectable"), gj.dialog.events.dragStop(e);
      }
    });
  },
  resizable: function resizable(e) {
    var t = {
      drag: gj.dialog.methods.resize,
      start: function start() {
        e.addClass("gj-unselectable"), gj.dialog.events.resizeStart(e);
      },
      stop: function stop() {
        this.removeAttribute("style"), e.removeClass("gj-unselectable"), gj.dialog.events.resizeStop(e);
      }
    };
    e.append($('<div class="gj-resizable-handle gj-resizable-n"></div>').draggable($.extend(!0, {
      horizontal: !1
    }, t))), e.append($('<div class="gj-resizable-handle gj-resizable-e"></div>').draggable($.extend(!0, {
      vertical: !1
    }, t))), e.append($('<div class="gj-resizable-handle gj-resizable-s"></div>').draggable($.extend(!0, {
      horizontal: !1
    }, t))), e.append($('<div class="gj-resizable-handle gj-resizable-w"></div>').draggable($.extend(!0, {
      vertical: !1
    }, t))), e.append($('<div class="gj-resizable-handle gj-resizable-ne"></div>').draggable($.extend(!0, {}, t))), e.append($('<div class="gj-resizable-handle gj-resizable-nw"></div>').draggable($.extend(!0, {}, t))), e.append($('<div class="gj-resizable-handle gj-resizable-sw"></div>').draggable($.extend(!0, {}, t))), e.append($('<div class="gj-resizable-handle gj-resizable-se"></div>').draggable($.extend(!0, {}, t)));
  },
  resize: function resize(e, t) {
    var r,
      a,
      i,
      o,
      n,
      d,
      s,
      l,
      c = !1;
    return a = (r = $(this)).parent(), i = gj.core.position(this), offset = {
      top: t.top - i.top,
      left: t.left - i.left
    }, o = a.data(), r.hasClass("gj-resizable-n") ? (n = a.height() - offset.top, s = a.offset().top + offset.top) : r.hasClass("gj-resizable-e") ? d = a.width() + offset.left : r.hasClass("gj-resizable-s") ? n = a.height() + offset.top : r.hasClass("gj-resizable-w") ? (d = a.width() - offset.left, l = a.offset().left + offset.left) : r.hasClass("gj-resizable-ne") ? (n = a.height() - offset.top, s = a.offset().top + offset.top, d = a.width() + offset.left) : r.hasClass("gj-resizable-nw") ? (n = a.height() - offset.top, s = a.offset().top + offset.top, d = a.width() - offset.left, l = a.offset().left + offset.left) : r.hasClass("gj-resizable-se") ? (n = a.height() + offset.top, d = a.width() + offset.left) : r.hasClass("gj-resizable-sw") && (n = a.height() + offset.top, d = a.width() - offset.left, l = a.offset().left + offset.left), n && (!o.minHeight || n >= o.minHeight) && (!o.maxHeight || n <= o.maxHeight) && (a.height(n), s && a.css("top", s), c = !0), d && (!o.minWidth || d >= o.minWidth) && (!o.maxWidth || d <= o.maxWidth) && (a.width(d), l && a.css("left", l), c = !0), c && gj.dialog.events.resize(a), c;
  },
  open: function open(e, t) {
    var r;
    return gj.dialog.events.opening(e), e.css("display", "block"), e.closest('div[data-role="modal"]').css("display", "block"), (r = e.children('div[data-role="footer"]')).length && r.outerHeight() && e.children('div[data-role="body"]').css("margin-bottom", r.outerHeight()), void 0 !== t && e.find('[data-role="title"]').html(t), gj.dialog.events.opened(e), e;
  },
  close: function close(e) {
    return e.is(":visible") && (gj.dialog.events.closing(e), e.css("display", "none"), e.closest('div[data-role="modal"]').css("display", "none"), gj.dialog.events.closed(e)), e;
  },
  isOpen: function isOpen(e) {
    return e.is(":visible");
  },
  content: function content(e, t) {
    var r = e.children('div[data-role="body"]');
    return void 0 === t ? r.html() : r.html(t);
  },
  destroy: function destroy(e, t) {
    var r = e.data();
    return r && (!1 === t ? e.remove() : (e.close(), e.off(), e.removeData(), e.removeAttr("data-type"), e.removeClass(r.style.content), e.find('[data-role="header"]').removeClass(r.style.header), e.find('[data-role="title"]').removeClass(r.style.headerTitle), e.find('[data-role="close"]').remove(), e.find('[data-role="body"]').removeClass(r.style.body), e.find('[data-role="footer"]').removeClass(r.style.footer))), e;
  }
}, gj.dialog.widget = function (e, t) {
  var r = this,
    a = gj.dialog.methods;
  return r.open = function (e) {
    return a.open(this, e);
  }, r.close = function () {
    return a.close(this);
  }, r.isOpen = function () {
    return a.isOpen(this);
  }, r.content = function (e) {
    return a.content(this, e);
  }, r.destroy = function (e) {
    return a.destroy(this, e);
  }, $.extend(e, r), "dialog" !== e.attr("data-type") && a.init.call(e, t), e;
}, gj.dialog.widget.prototype = new gj.widget(), gj.dialog.widget.constructor = gj.dialog.widget, gj.dialog.widget.prototype.getHTMLConfig = gj.dialog.methods.getHTMLConfig, jQuery.fn.dialog = function (e) {
  var t;
  if (this && this.length) {
    if ("object" != _typeof(e) && e) {
      if ((t = new gj.dialog.widget(this, null))[e]) return t[e].apply(this, Array.prototype.slice.call(arguments, 1));
      throw "Method " + e + " does not exist.";
    }
    return new gj.dialog.widget(this, e);
  }
}, gj.dialog.messages["en-us"] = {
  Close: "Close",
  DefaultTitle: "Dialog"
}, gj.draggable = {
  plugins: {}
}, gj.draggable.config = {
  base: {
    handle: void 0,
    vertical: !0,
    horizontal: !0,
    containment: void 0
  }
}, gj.draggable.methods = {
  init: function init(e) {
    var t,
      r,
      a = this;
    return gj.widget.prototype.init.call(this, e, "draggable"), r = this.data(), a.attr("data-draggable", "true"), (t = gj.draggable.methods.getHandleElement(a)).on("touchstart mousedown", function (e) {
      var i = gj.core.position(a[0]);
      a[0].style.top = i.top + "px", a[0].style.left = i.left + "px", a[0].style.position = "fixed", a.attr("draggable-dragging", !0), a.removeAttr("draggable-x").removeAttr("draggable-y"), gj.documentManager.subscribeForEvent("touchmove", a.data("guid"), gj.draggable.methods.createMoveHandler(a, t, r)), gj.documentManager.subscribeForEvent("mousemove", a.data("guid"), gj.draggable.methods.createMoveHandler(a, t, r));
    }), gj.documentManager.subscribeForEvent("mouseup", a.data("guid"), gj.draggable.methods.createUpHandler(a)), gj.documentManager.subscribeForEvent("touchend", a.data("guid"), gj.draggable.methods.createUpHandler(a)), gj.documentManager.subscribeForEvent("touchcancel", a.data("guid"), gj.draggable.methods.createUpHandler(a)), a;
  },
  getHandleElement: function getHandleElement(e) {
    var t = e.data("handle");
    return t && t.length ? t : e;
  },
  createUpHandler: function createUpHandler(e) {
    return function (t) {
      "true" === e.attr("draggable-dragging") && (e.attr("draggable-dragging", !1), gj.documentManager.unsubscribeForEvent("mousemove", e.data("guid")), gj.documentManager.unsubscribeForEvent("touchmove", e.data("guid")), gj.draggable.events.stop(e, {
        x: e.mouseX(t),
        y: e.mouseY(t)
      }));
    };
  },
  createMoveHandler: function createMoveHandler(e, t, r) {
    return function (t) {
      var a, i, o, n, d, s;
      "true" === e.attr("draggable-dragging") && (a = Math.round(e.mouseX(t)), i = Math.round(e.mouseY(t)), d = e.attr("draggable-x"), s = e.attr("draggable-y"), d && s ? (o = r.horizontal ? a - parseInt(d, 10) : 0, n = r.vertical ? i - parseInt(s, 10) : 0, gj.draggable.methods.move(e[0], r, o, n, a, i)) : gj.draggable.events.start(e, a, i), e.attr("draggable-x", a), e.attr("draggable-y", i));
    };
  },
  move: function move(e, t, r, a, i, o) {
    var n,
      d,
      s,
      l = gj.core.position(e),
      c = l.top + a,
      g = l.left + r;
    t.containment && (d = (n = gj.core.position(t.containment)).top + gj.core.height(t.containment) - gj.core.height(e), s = n.left + gj.core.width(t.containment) - gj.core.width(e), c > n.top && c < d ? (n.top >= o || n.bottom <= o) && (c = l.top) : c = c <= n.top ? n.top + 1 : d - 1, g > n.left && g < s ? (n.left >= i || n.right <= i) && (g = l.left) : g = g <= n.left ? n.left + 1 : s - 1), !1 !== gj.draggable.events.drag($(e), g, c, i, o) && (e.style.top = c + "px", e.style.left = g + "px");
  },
  destroy: function destroy(e) {
    return "true" === e.attr("data-draggable") && (gj.documentManager.unsubscribeForEvent("mouseup", e.data("guid")), e.removeData(), e.removeAttr("data-guid").removeAttr("data-type").removeAttr("data-draggable"), e.removeAttr("draggable-x").removeAttr("draggable-y").removeAttr("draggable-dragging"), e[0].style.top = "", e[0].style.left = "", e[0].style.position = "", e.off("drag").off("start").off("stop"), gj.draggable.methods.getHandleElement(e).off("mousedown")), e;
  }
}, gj.draggable.events = {
  drag: function drag(e, t, r, a, i) {
    return e.triggerHandler("drag", [{
      left: t,
      top: r
    }, {
      x: a,
      y: i
    }]);
  },
  start: function start(e, t, r) {
    e.triggerHandler("start", [{
      x: t,
      y: r
    }]);
  },
  stop: function stop(e, t) {
    e.triggerHandler("stop", [t]);
  }
}, gj.draggable.widget = function (e, t) {
  var r = gj.draggable.methods;
  return e.destroy || (this.destroy = function () {
    return r.destroy(this);
  }), $.extend(e, this), "true" !== e.attr("data-draggable") && r.init.call(e, t), e;
}, gj.draggable.widget.prototype = new gj.widget(), gj.draggable.widget.constructor = gj.draggable.widget, jQuery.fn.draggable = function (e) {
  var t;
  if (this && this.length) {
    if ("object" != _typeof(e) && e) {
      if ((t = new gj.draggable.widget(this, null))[e]) return t[e].apply(this, Array.prototype.slice.call(arguments, 1));
      throw "Method " + e + " does not exist.";
    }
    return new gj.draggable.widget(this, e);
  }
}, gj.droppable = {
  plugins: {}
}, gj.droppable.config = {
  hoverClass: void 0
}, gj.droppable.methods = {
  init: function init(e) {
    var t = this;
    return gj.widget.prototype.init.call(this, e, "droppable"), t.attr("data-droppable", "true"), gj.documentManager.subscribeForEvent("mousedown", t.data("guid"), gj.droppable.methods.createMouseDownHandler(t)), gj.documentManager.subscribeForEvent("mousemove", t.data("guid"), gj.droppable.methods.createMouseMoveHandler(t)), gj.documentManager.subscribeForEvent("mouseup", t.data("guid"), gj.droppable.methods.createMouseUpHandler(t)), t;
  },
  createMouseDownHandler: function createMouseDownHandler(e) {
    return function (t) {
      e.isDragging = !0;
    };
  },
  createMouseMoveHandler: function createMouseMoveHandler(e) {
    return function (t) {
      if (e.isDragging) {
        var r = e.data("hoverClass"),
          a = {
            x: e.mouseX(t),
            y: e.mouseY(t)
          },
          i = gj.droppable.methods.isOver(e, a);
        i != e.isOver && (i ? (r && e.addClass(r), gj.droppable.events.over(e, a)) : (r && e.removeClass(r), gj.droppable.events.out(e))), e.isOver = i;
      }
    };
  },
  createMouseUpHandler: function createMouseUpHandler(e) {
    return function (t) {
      var r = {
        left: e.mouseX(t),
        top: e.mouseY(t)
      };
      e.isDragging = !1, gj.droppable.methods.isOver(e, r) && gj.droppable.events.drop(e);
    };
  },
  isOver: function isOver(e, t) {
    var r = e.offset().top,
      a = e.offset().left;
    return t.x > a && t.x < a + e.outerWidth(!0) && t.y > r && t.y < r + e.outerHeight(!0);
  },
  destroy: function destroy(e) {
    return "true" === e.attr("data-droppable") && (gj.documentManager.unsubscribeForEvent("mousedown", e.data("guid")), gj.documentManager.unsubscribeForEvent("mousemove", e.data("guid")), gj.documentManager.unsubscribeForEvent("mouseup", e.data("guid")), e.removeData(), e.removeAttr("data-guid"), e.removeAttr("data-droppable"), e.off("drop").off("over").off("out")), e;
  }
}, gj.droppable.events = {
  drop: function drop(e, t, r) {
    e.trigger("drop", [{
      top: r,
      left: t
    }]);
  },
  over: function over(e, t) {
    e.trigger("over", [t]);
  },
  out: function out(e) {
    e.trigger("out");
  }
}, gj.droppable.widget = function (e, t) {
  var r = this,
    a = gj.droppable.methods;
  return r.isOver = !1, r.isDragging = !1, r.destroy = function () {
    return a.destroy(this);
  }, r.isOver = function (e) {
    return a.isOver(this, e);
  }, $.extend(e, r), "true" !== e.attr("data-droppable") && a.init.call(e, t), e;
}, gj.droppable.widget.prototype = new gj.widget(), gj.droppable.widget.constructor = gj.droppable.widget, jQuery.fn.droppable = function (e) {
  var t;
  if (this && this.length) {
    if ("object" != _typeof(e) && e) {
      if ((t = new gj.droppable.widget(this, null))[e]) return t[e].apply(this, Array.prototype.slice.call(arguments, 1));
      throw "Method " + e + " does not exist.";
    }
    return new gj.droppable.widget(this, e);
  }
}, gj.grid = {
  plugins: {},
  messages: {}
}, gj.grid.config = {
  base: {
    dataSource: void 0,
    columns: [],
    autoGenerateColumns: !1,
    defaultColumnSettings: {
      hidden: !1,
      width: void 0,
      sortable: !1,
      type: "text",
      title: void 0,
      field: void 0,
      align: void 0,
      cssClass: void 0,
      headerCssClass: void 0,
      tooltip: void 0,
      icon: void 0,
      events: void 0,
      format: "mm/dd/yyyy",
      decimalDigits: void 0,
      tmpl: void 0,
      stopPropagation: !1,
      renderer: void 0,
      filter: void 0
    },
    mapping: {
      dataField: "records",
      totalRecordsField: "total"
    },
    params: {},
    paramNames: {
      sortBy: "sortBy",
      direction: "direction"
    },
    uiLibrary: "materialdesign",
    iconsLibrary: "materialicons",
    selectionType: "single",
    selectionMethod: "basic",
    autoLoad: !0,
    notFoundText: void 0,
    width: void 0,
    minWidth: void 0,
    headerRowHeight: "fixed",
    bodyRowHeight: "autogrow",
    fontSize: void 0,
    primaryKey: void 0,
    locale: "en-us",
    defaultIconColumnWidth: 70,
    defaultCheckBoxColumnWidth: 70,
    style: {
      wrapper: "gj-grid-wrapper",
      table: "gj-grid gj-grid-md",
      loadingCover: "gj-grid-loading-cover",
      loadingText: "gj-grid-loading-text",
      header: {
        cell: void 0,
        sortable: "gj-cursor-pointer gj-unselectable"
      },
      content: {
        rowSelected: "gj-grid-md-select"
      }
    },
    icons: {
      asc: "▲",
      desc: "▼"
    }
  },
  bootstrap: {
    style: {
      wrapper: "gj-grid-wrapper",
      table: "gj-grid gj-grid-bootstrap gj-grid-bootstrap-3 table table-bordered table-hover",
      content: {
        rowSelected: "active"
      }
    },
    iconsLibrary: "glyphicons",
    defaultIconColumnWidth: 34,
    defaultCheckBoxColumnWidth: 36
  },
  bootstrap4: {
    style: {
      wrapper: "gj-grid-wrapper",
      table: "gj-grid gj-grid-bootstrap gj-grid-bootstrap-4 table table-bordered table-hover",
      content: {
        rowSelected: "active"
      }
    },
    defaultIconColumnWidth: 42,
    defaultCheckBoxColumnWidth: 44
  },
  materialicons: {
    icons: {
      asc: '<i class="gj-icon arrow-upward" />',
      desc: '<i class="gj-icon arrow-downward" />'
    }
  },
  fontawesome: {
    icons: {
      asc: '<i class="fa fa-sort-amount-asc" aria-hidden="true"></i>',
      desc: '<i class="fa fa-sort-amount-desc" aria-hidden="true"></i>'
    }
  },
  glyphicons: {
    icons: {
      asc: '<span class="glyphicon glyphicon-sort-by-alphabet" />',
      desc: '<span class="glyphicon glyphicon-sort-by-alphabet-alt" />'
    }
  }
}, gj.grid.events = {
  beforeEmptyRowInsert: function beforeEmptyRowInsert(e, t) {
    return e.triggerHandler("beforeEmptyRowInsert", [t]);
  },
  dataBinding: function dataBinding(e, t) {
    return e.triggerHandler("dataBinding", [t]);
  },
  dataBound: function dataBound(e, t, r) {
    return e.triggerHandler("dataBound", [t, r]);
  },
  rowDataBound: function rowDataBound(e, t, r, a) {
    return e.triggerHandler("rowDataBound", [t, r, a]);
  },
  cellDataBound: function cellDataBound(e, t, r, a, i) {
    return e.triggerHandler("cellDataBound", [t, r, a, i]);
  },
  rowSelect: function rowSelect(e, t, r, a) {
    return e.triggerHandler("rowSelect", [t, r, a]);
  },
  rowUnselect: function rowUnselect(e, t, r, a) {
    return e.triggerHandler("rowUnselect", [t, r, a]);
  },
  rowRemoving: function rowRemoving(e, t, r, a) {
    return e.triggerHandler("rowRemoving", [t, r, a]);
  },
  destroying: function destroying(e) {
    return e.triggerHandler("destroying");
  },
  columnHide: function columnHide(e, t) {
    return e.triggerHandler("columnHide", [t]);
  },
  columnShow: function columnShow(e, t) {
    return e.triggerHandler("columnShow", [t]);
  },
  initialized: function initialized(e) {
    return e.triggerHandler("initialized");
  },
  dataFiltered: function dataFiltered(e, t) {
    return e.triggerHandler("dataFiltered", [t]);
  }
}, gj.grid.methods = {
  init: function init(e) {
    return gj.widget.prototype.init.call(this, e, "grid"), gj.grid.methods.initialize(this), this.data("autoLoad") && this.reload(), this;
  },
  getConfig: function getConfig(e, t) {
    var r = gj.widget.prototype.getConfig.call(this, e, t);
    return gj.grid.methods.setDefaultColumnConfig(r.columns, r.defaultColumnSettings), r;
  },
  setDefaultColumnConfig: function setDefaultColumnConfig(e, t) {
    var r, a;
    if (e && e.length) for (a = 0; a < e.length; a++) {
      r = $.extend(!0, {}, t), $.extend(!0, r, e[a]), e[a] = r;
    }
  },
  getHTMLConfig: function getHTMLConfig() {
    var e = gj.widget.prototype.getHTMLConfig.call(this);
    return e.columns = [], this.find("thead > tr > th").each(function () {
      var t = $(this),
        r = t.text(),
        a = gj.widget.prototype.getHTMLConfig.call(t);
      a.title = r, a.field || (a.field = r), a.events && (a.events = gj.grid.methods.eventsParser(a.events)), e.columns.push(a);
    }), e;
  },
  eventsParser: function eventsParser(events) {
    var result = {},
      list,
      i,
      key,
      func,
      position;
    for (list = events.split(","), i = 0; i < list.length; i++) {
      (position = list[i].indexOf(":")) > 0 && (key = $.trim(list[i].substr(0, position)), func = $.trim(list[i].substr(position + 1, list[i].length)), result[key] = eval("window." + func));
    }
    return result;
  },
  initialize: function initialize(e) {
    var t = e.data(),
      r = e.parent('div[data-role="wrapper"]');
    gj.grid.methods.localization(t), 0 === r.length ? (r = $('<div data-role="wrapper" />').addClass(t.style.wrapper), e.wrap(r)) : r.addClass(t.style.wrapper), t.width && e.parent().css("width", t.width), t.minWidth && e.css("min-width", t.minWidth), t.fontSize && e.css("font-size", t.fontSize), "autogrow" === t.headerRowHeight && e.addClass("autogrow-header-row"), "fixed" === t.bodyRowHeight && e.addClass("fixed-body-rows"), e.addClass(t.style.table), "checkbox" === t.selectionMethod && t.columns.splice(gj.grid.methods.getColumnPositionNotInRole(e), 0, {
      title: "",
      width: t.defaultCheckBoxColumnWidth,
      align: "center",
      type: "checkbox",
      role: "selectRow",
      events: {
        click: function click(t) {
          gj.grid.methods.setSelected(e, t.data.id, $(this).closest("tr"));
        }
      },
      headerCssClass: "gj-grid-select-all",
      stopPropagation: !0
    }), 0 === e.children("tbody").length && e.append($("<tbody/>")), gj.grid.methods.renderHeader(e), gj.grid.methods.appendEmptyRow(e, "&nbsp;"), gj.grid.events.initialized(e);
  },
  localization: function localization(e) {
    e.notFoundText || (e.notFoundText = gj.grid.messages[e.locale].NoRecordsFound);
  },
  renderHeader: function renderHeader(e) {
    var t, r, a, i, o, n, d, s, l;
    for (r = (t = e.data()).columns, a = t.style.header, 0 === (i = e.children("thead")).length && (i = $("<thead />"), e.prepend(i)), o = $('<tr data-role="caption" />'), s = 0; s < r.length; s += 1) {
      n = $('<th data-field="' + (r[s].field || "") + '" />'), r[s].width ? n.attr("width", r[s].width) : "checkbox" === r[s].type && n.attr("width", t.defaultIconColumnWidth), n.addClass(a.cell), r[s].headerCssClass && n.addClass(r[s].headerCssClass), n.css("text-align", r[s].align || "left"), "checkbox" === t.selectionMethod && "multiple" === t.selectionType && "checkbox" === r[s].type && "selectRow" === r[s].role ? (0 === (l = n.find('input[data-role="selectAll"]')).length && (l = $('<input type="checkbox" data-role="selectAll" />'), n.append(l), l.checkbox({
        uiLibrary: t.uiLibrary
      })), l.off("click").on("click", function () {
        this.checked ? e.selectAll() : e.unSelectAll();
      })) : (d = $('<div data-role="title"/>').html(void 0 === r[s].title ? r[s].field : r[s].title), n.append(d), r[s].sortable && (d.addClass(a.sortable), d.on("click", gj.grid.methods.createSortHandler(e, r[s])))), r[s].hidden && n.hide(), o.append(n);
    }
    i.empty().append(o);
  },
  createSortHandler: function createSortHandler(e, t) {
    return function () {
      var r,
        a = {};
      e.count() > 0 && (a[(r = e.data()).paramNames.sortBy] = t.field, t.direction = "asc" === t.direction ? "desc" : "asc", a[r.paramNames.direction] = t.direction, e.reload(a));
    };
  },
  updateHeader: function updateHeader(e) {
    var t,
      r,
      a = e.data(),
      i = a.params[a.paramNames.sortBy],
      o = a.params[a.paramNames.direction];
    e.find('thead tr th [data-role="sorticon"]').remove(), i && (position = gj.grid.methods.getColumnPosition(e.data("columns"), i), position > -1 && (r = e.find("thead tr th:eq(" + position + ') div[data-role="title"]'), t = $('<div data-role="sorticon" class="gj-unselectable" />').append("desc" === o ? a.icons.desc : a.icons.asc), r.after(t)));
  },
  useHtmlDataSource: function useHtmlDataSource(e, t) {
    var r,
      a,
      i,
      o,
      n = [],
      d = e.find('tbody tr[data-role != "empty"]');
    for (r = 0; r < d.length; r++) {
      for (i = $(d[r]).find("td"), o = {}, a = 0; a < i.length; a++) {
        o[t.columns[a].field] = $(i[a]).html();
      }
      n.push(o);
    }
    t.dataSource = n;
  },
  startLoading: function startLoading(e) {
    var t, r, a, i, o, n, d;
    gj.grid.methods.stopLoading(e), d = e.data(), 0 !== e.outerHeight() && (i = (t = e.children("tbody")).outerWidth(!1), o = t.outerHeight(!1), n = Math.abs(e.parent().offset().top - t.offset().top), r = $('<div data-role="loading-cover" />').addClass(d.style.loadingCover).css({
      width: i,
      height: o,
      top: n
    }), (a = $('<div data-role="loading-text">' + gj.grid.messages[d.locale].Loading + "</div>").addClass(d.style.loadingText)).insertAfter(e), r.insertAfter(e), a.css({
      top: n + o / 2 - a.outerHeight(!1) / 2,
      left: i / 2 - a.outerWidth(!1) / 2
    }));
  },
  stopLoading: function stopLoading(e) {
    e.parent().find('div[data-role="loading-cover"]').remove(), e.parent().find('div[data-role="loading-text"]').remove();
  },
  appendEmptyRow: function appendEmptyRow(e, t) {
    var r, a, i, o;
    r = e.data(), a = $('<tr data-role="empty"/>'), (i = $("<td/>").css({
      width: "100%",
      "text-align": "center"
    })).attr("colspan", gj.grid.methods.countVisibleColumns(e)), o = $("<div />").html(t || r.notFoundText), i.append(o), a.append(i), gj.grid.events.beforeEmptyRowInsert(e, a), e.append(a);
  },
  autoGenerateColumns: function autoGenerateColumns(e, t) {
    var r,
      a,
      i,
      o,
      n = e.data();
    if (n.columns = [], t.length > 0) {
      for (r = Object.getOwnPropertyNames(t[0]), o = 0; o < r.length; o++) {
        i = "text", (a = t[0][r[o]]) && ("number" == typeof a ? i = "number" : a.indexOf("/Date(") > -1 && (i = "date")), n.columns.push({
          field: r[o],
          type: i
        });
      }
      gj.grid.methods.setDefaultColumnConfig(n.columns, n.defaultColumnSettings);
    }
    gj.grid.methods.renderHeader(e);
  },
  loadData: function loadData(e) {
    var t, r, a, i, o, n, d, s;
    for (t = e.data(), r = e.getAll(), gj.grid.events.dataBinding(e, r), i = r.length, gj.grid.methods.stopLoading(e), t.autoGenerateColumns && gj.grid.methods.autoGenerateColumns(e, r), n = e.children("tbody"), "checkbox" === t.selectionMethod && "multiple" === t.selectionType && e.find('thead input[data-role="selectAll"]').prop("checked", !1), n.children("tr").not('[data-role="row"]').remove(), 0 === i && (n.empty(), gj.grid.methods.appendEmptyRow(e)), o = (d = n.children("tr")).length, a = 0; a < o; a++) {
      if (!(a < i)) {
        n.find('tr[data-role="row"]:gt(' + (a - 1) + ")").remove();
        break;
      }
      s = d.eq(a), gj.grid.methods.renderRow(e, s, r[a], a);
    }
    for (a = o; a < i; a++) {
      gj.grid.methods.renderRow(e, null, r[a], a);
    }
    gj.grid.events.dataBound(e, r, t.totalRecords);
  },
  getId: function getId(e, t, r) {
    return t && e[t] ? e[t] : r;
  },
  renderRow: function renderRow(e, t, r, a) {
    var i, o, n, d, s;
    for (d = e.data(), t && 0 !== t.length ? (s = "update", t.removeClass(d.style.content.rowSelected).removeAttr("data-selected").off("click")) : (s = "create", t = $('<tr data-role="row"/>'), e.children("tbody").append(t)), i = gj.grid.methods.getId(r, d.primaryKey, a + 1), t.attr("data-position", a + 1), "checkbox" !== d.selectionMethod && t.on("click", gj.grid.methods.createRowClickHandler(e, i)), n = 0; n < d.columns.length; n++) {
      "update" === s ? (o = t.find("td:eq(" + n + ")"), gj.grid.methods.renderCell(e, o, d.columns[n], r, i)) : (o = gj.grid.methods.renderCell(e, null, d.columns[n], r, i), t.append(o));
    }
    gj.grid.events.rowDataBound(e, t, i, r);
  },
  renderCell: function renderCell(e, t, r, a, i, o) {
    var n, d;
    if (t && 0 !== t.length ? (n = t.find('div[data-role="display"]'), o = "update") : (t = $("<td/>"), n = $('<div data-role="display" />'), r.align && t.css("text-align", r.align), r.cssClass && t.addClass(r.cssClass), t.append(n), o = "create"), gj.grid.methods.renderDisplayElement(e, n, r, a, i, o), "update" === o && (t.off(), n.off()), r.events) for (d in r.events) {
      r.events.hasOwnProperty(d) && t.on(d, {
        id: i,
        field: r.field,
        record: a
      }, gj.grid.methods.createCellEventHandler(r, r.events[d]));
    }
    return r.hidden && t.hide(), gj.grid.events.cellDataBound(e, n, i, r, a), t;
  },
  createCellEventHandler: function createCellEventHandler(e, t) {
    return function (r) {
      e.stopPropagation && r.stopPropagation(), t.call(this, r);
    };
  },
  renderDisplayElement: function renderDisplayElement(e, t, r, a, i, o) {
    var n, d;
    "checkbox" === r.type && gj.checkbox ? "create" === o ? (d = $('<input type="checkbox" />').val(i).prop("checked", !!a[r.field]), r.role && d.attr("data-role", r.role), t.append(d), d.checkbox({
      uiLibrary: e.data("uiLibrary")
    }), "selectRow" === r.role ? d.on("click", function () {
      return !1;
    }) : d.prop("disabled", !0)) : t.find('input[type="checkbox"]').val(i).prop("checked", !!a[r.field]) : "icon" === r.type ? "create" === o && (t.append($("<span/>").addClass(r.icon).css({
      cursor: "pointer"
    })), "bootstrap" === e.data().uiLibrary && t.children("span").addClass("glyphicon"), r.stopPropagation = !0) : r.tmpl ? (n = r.tmpl, r.tmpl.replace(/\{(.+?)\}/g, function (e, t) {
      n = n.replace(e, gj.grid.methods.formatText(a[t], r));
    }), t.html(n)) : r.renderer && "function" == typeof r.renderer ? (n = r.renderer(a[r.field], a, t.parent(), t, i, e)) && t.html(n) : (a[r.field] = gj.grid.methods.formatText(a[r.field], r), !r.tooltip && a[r.field] && t.attr("title", a[r.field]), t.html(a[r.field])), r.tooltip && "create" === o && t.attr("title", r.tooltip);
  },
  formatText: function formatText(e, t) {
    return e = e && ["date", "time", "datetime"].indexOf(t.type) > -1 ? gj.core.formatDate(gj.core.parseDate(e, t.format), t.format) : null == e ? "" : e.toString(), t.decimalDigits && e && (e = parseFloat(e).toFixed(t.decimalDigits)), e;
  },
  setRecordsData: function setRecordsData(e, t) {
    var r = [],
      a = 0,
      i = e.data();
    return $.isArray(t) ? (r = t, a = t.length) : i && i.mapping && $.isArray(t[i.mapping.dataField]) && (r = t[i.mapping.dataField], (a = t[i.mapping.totalRecordsField]) && !isNaN(a) || (a = 0)), e.data("records", r), e.data("totalRecords", a), r;
  },
  createRowClickHandler: function createRowClickHandler(e, t) {
    return function () {
      gj.grid.methods.setSelected(e, t, $(this));
    };
  },
  selectRow: function selectRow(e, t, r, a) {
    var i;
    return r.addClass(t.style.content.rowSelected), r.attr("data-selected", "true"), "checkbox" === t.selectionMethod && ((i = r.find('input[type="checkbox"][data-role="selectRow"]')).length && !i.prop("checked") && i.prop("checked", !0), "multiple" === t.selectionType && e.getSelections().length === e.count(!1) && e.find('thead input[data-role="selectAll"]').prop("checked", !0)), gj.grid.events.rowSelect(e, r, a, e.getById(a));
  },
  unselectRow: function unselectRow(e, t, r, a) {
    var i;
    if ("true" === r.attr("data-selected")) return r.removeClass(t.style.content.rowSelected), "checkbox" === t.selectionMethod && ((i = r.find('td input[type="checkbox"][data-role="selectRow"]')).length && i.prop("checked") && i.prop("checked", !1), "multiple" === t.selectionType && e.find('thead input[data-role="selectAll"]').prop("checked", !1)), r.removeAttr("data-selected"), gj.grid.events.rowUnselect(e, r, a, e.getById(a));
  },
  setSelected: function setSelected(e, t, r) {
    var a = e.data();
    return r && r.length || (r = gj.grid.methods.getRowById(e, t)), r && ("true" === r.attr("data-selected") ? gj.grid.methods.unselectRow(e, a, r, t) : ("single" === a.selectionType && r.siblings('[data-selected="true"]').each(function () {
      var t = $(this),
        r = gj.grid.methods.getId(t, a.primaryKey, t.data("position"));
      gj.grid.methods.unselectRow(e, a, t, r);
    }), gj.grid.methods.selectRow(e, a, r, t))), e;
  },
  selectAll: function selectAll(e) {
    var t = e.data();
    return e.find('tbody tr[data-role="row"]').each(function () {
      var r = $(this),
        a = r.data("position"),
        i = e.get(a),
        o = gj.grid.methods.getId(i, t.primaryKey, a);
      gj.grid.methods.selectRow(e, t, r, o);
    }), e.find('thead input[data-role="selectAll"]').prop("checked", !0), e;
  },
  unSelectAll: function unSelectAll(e) {
    var t = e.data();
    return e.find("tbody tr").each(function () {
      var r = $(this),
        a = r.data("position"),
        i = e.get(a),
        o = gj.grid.methods.getId(i, t.primaryKey, a);
      gj.grid.methods.unselectRow(e, t, r, o), r.find('input[type="checkbox"][data-role="selectRow"]').prop("checked", !1);
    }), e.find('thead input[data-role="selectAll"]').prop("checked", !1), e;
  },
  getSelected: function getSelected(e) {
    var t,
      r,
      a,
      i = null;
    return (t = e.find('tbody>tr[data-selected="true"]')).length > 0 && (a = $(t[0]).data("position"), r = e.get(a), i = gj.grid.methods.getId(r, e.data().primaryKey, a)), i;
  },
  getSelectedRows: function getSelectedRows(e) {
    return e.data(), e.find('tbody>tr[data-selected="true"]');
  },
  getSelections: function getSelections(e) {
    var t,
      r,
      a = [],
      i = e.data(),
      o = gj.grid.methods.getSelectedRows(e);
    return 0 < o.length && o.each(function () {
      t = $(this).data("position"), r = e.get(t), a.push(gj.grid.methods.getId(r, i.primaryKey, t));
    }), a;
  },
  getById: function getById(e, t) {
    var r,
      a = null,
      i = e.data("primaryKey"),
      o = e.data("records");
    if (i) {
      for (r = 0; r < o.length; r++) {
        if (o[r][i] == t) {
          a = o[r];
          break;
        }
      }
    } else a = e.get(t);
    return a;
  },
  getRecVPosById: function getRecVPosById(e, t) {
    var r,
      a = t,
      i = e.data();
    if (i.primaryKey) for (r = 0; r < i.dataSource.length; r++) {
      if (i.dataSource[r][i.primaryKey] == t) {
        a = r;
        break;
      }
    }
    return a;
  },
  getRowById: function getRowById(e, t) {
    var r,
      a,
      i = e.getAll(!1),
      o = e.data("primaryKey"),
      n = void 0;
    if (o) {
      for (a = 0; a < i.length; a++) {
        if (i[a][o] == t) {
          r = a + 1;
          break;
        }
      }
    } else r = t;
    return r && (n = e.children("tbody").children('tr[data-position="' + r + '"]')), n;
  },
  getByPosition: function getByPosition(e, t) {
    return e.getAll(!1)[t - 1];
  },
  getColumnPosition: function getColumnPosition(e, t) {
    var r,
      a = -1;
    for (r = 0; r < e.length; r++) {
      if (e[r].field === t) {
        a = r;
        break;
      }
    }
    return a;
  },
  getColumnInfo: function getColumnInfo(e, t) {
    var r,
      a = {},
      i = e.data();
    for (r = 0; r < i.columns.length; r += 1) {
      if (i.columns[r].field === t) {
        a = i.columns[r];
        break;
      }
    }
    return a;
  },
  getCell: function getCell(e, t, r) {
    var a,
      i = null;
    return (a = gj.grid.methods.getColumnPosition(e.data("columns"), r)) > -1 && (i = gj.grid.methods.getRowById(e, t).find("td:eq(" + a + ') div[data-role="display"]')), i;
  },
  setCellContent: function setCellContent(e, t, r, a) {
    var i,
      o = gj.grid.methods.getCell(e, t, r);
    o && (o.empty(), "object" == _typeof(a) ? o.append(a) : (i = gj.grid.methods.getColumnInfo(e, r), gj.grid.methods.renderDisplayElement(e, o, i, e.getById(t), t, "update")));
  },
  clone: function clone(e) {
    var t = [];
    return $.each(e, function () {
      t.push(this.clone());
    }), t;
  },
  getAll: function getAll(e) {
    return e.data("records");
  },
  countVisibleColumns: function countVisibleColumns(e) {
    var t, r, a;
    for (t = e.data().columns, r = 0, a = 0; a < t.length; a++) {
      !0 !== t[a].hidden && r++;
    }
    return r;
  },
  clear: function clear(e, t) {
    var r = e.data();
    return e.xhr && e.xhr.abort(), e.children("tbody").empty(), r.records = [], gj.grid.methods.stopLoading(e), gj.grid.methods.appendEmptyRow(e, t ? r.notFoundText : "&nbsp;"), gj.grid.events.dataBound(e, [], 0), e;
  },
  render: function render(e, t) {
    return t && (gj.grid.methods.setRecordsData(e, t), gj.grid.methods.updateHeader(e), gj.grid.methods.loadData(e)), e;
  },
  filter: function filter(e) {
    var t,
      r,
      a = e.data(),
      i = a.dataSource.slice();
    for (t in a.params[a.paramNames.sortBy] && (r = gj.grid.methods.getColumnInfo(e, a.params[a.paramNames.sortBy]), i.sort(r.sortable.sorter ? r.sortable.sorter(r.direction, r) : gj.grid.methods.createDefaultSorter(r.direction, r.field))), a.params) {
      a.params[t] && !a.paramNames[t] && (r = gj.grid.methods.getColumnInfo(e, t), i = $.grep(i, function (e) {
        var i = e[t] || "",
          o = a.params[t] || "";
        return r && "function" == typeof r.filter ? r.filter(i, o) : i.toUpperCase().indexOf(o.toUpperCase()) > -1;
      }));
    }
    return gj.grid.events.dataFiltered(e, i), i;
  },
  createDefaultSorter: function createDefaultSorter(e, t) {
    return function (r, a) {
      var i = (r[t] || "").toString(),
        o = (a[t] || "").toString();
      return "asc" === e ? i.localeCompare(o) : o.localeCompare(i);
    };
  },
  destroy: function destroy(e, t, r) {
    return e.data() && (gj.grid.events.destroying(e), gj.grid.methods.stopLoading(e), e.xhr && e.xhr.abort(), e.off(), !1 === r && e.parent('div[data-role="wrapper"]').length > 0 && e.unwrap(), e.removeData(), !1 === t ? e.remove() : e.removeClass().empty(), e.removeAttr("data-type")), e;
  },
  showColumn: function showColumn(e, t) {
    var r,
      a = e.data(),
      i = gj.grid.methods.getColumnPosition(a.columns, t);
    return i > -1 && (e.find("thead>tr").each(function () {
      $(this).children("th").eq(i).show();
    }), $.each(e.find("tbody>tr"), function () {
      $(this).children("td").eq(i).show();
    }), a.columns[i].hidden = !1, (r = e.find('tbody > tr[data-role="empty"] > td')) && r.length && r.attr("colspan", gj.grid.methods.countVisibleColumns(e)), gj.grid.events.columnShow(e, a.columns[i])), e;
  },
  hideColumn: function hideColumn(e, t) {
    var r,
      a = e.data(),
      i = gj.grid.methods.getColumnPosition(a.columns, t);
    return i > -1 && (e.find("thead>tr").each(function () {
      $(this).children("th").eq(i).hide();
    }), $.each(e.find("tbody>tr"), function () {
      $(this).children("td").eq(i).hide();
    }), a.columns[i].hidden = !0, (r = e.find('tbody > tr[data-role="empty"] > td')) && r.length && r.attr("colspan", gj.grid.methods.countVisibleColumns(e)), gj.grid.events.columnHide(e, a.columns[i])), e;
  },
  isLastRecordVisible: function isLastRecordVisible() {
    return !0;
  },
  addRow: function addRow(e, t) {
    var r = e.data();
    return r.totalRecords = e.data("totalRecords") + 1, gj.grid.events.dataBinding(e, [t]), r.records.push(t), $.isArray(r.dataSource) && r.dataSource.push(t), 1 === r.totalRecords && e.children("tbody").empty(), gj.grid.methods.isLastRecordVisible(e) && gj.grid.methods.renderRow(e, null, t, e.count() - 1), gj.grid.events.dataBound(e, [t], r.totalRecords), e;
  },
  updateRow: function updateRow(e, t, r) {
    var a,
      i = gj.grid.methods.getRowById(e, t),
      o = e.data();
    return o.records[i.data("position") - 1] = r, $.isArray(o.dataSource) && (a = gj.grid.methods.getRecVPosById(e, t), o.dataSource[a] = r), gj.grid.methods.renderRow(e, i, r, i.index()), e;
  },
  removeRow: function removeRow(e, t) {
    var r,
      a = e.data(),
      i = gj.grid.methods.getRowById(e, t);
    return gj.grid.events.rowRemoving(e, i, t, e.getById(t)), $.isArray(a.dataSource) && (r = gj.grid.methods.getRecVPosById(e, t), a.dataSource.splice(r, 1)), e.reload(), e;
  },
  count: function count(e, t) {
    return t ? e.data().totalRecords : e.getAll().length;
  },
  getColumnPositionByRole: function getColumnPositionByRole(e, t) {
    var r,
      a,
      i = e.data("columns");
    for (r = 0; r < i.length; r++) {
      if (i[r].role === t) {
        a = r;
        break;
      }
    }
    return a;
  },
  getColumnPositionNotInRole: function getColumnPositionNotInRole(e) {
    var t,
      r = 0,
      a = e.data("columns");
    for (t = 0; t < a.length; t++) {
      if (!a[t].role) {
        r = t;
        break;
      }
    }
    return r;
  }
}, gj.grid.widget = function (e, t) {
  var r = this,
    a = gj.grid.methods;
  return r.reload = function (e) {
    return a.startLoading(this), gj.widget.prototype.reload.call(this, e);
  }, r.clear = function (e) {
    return a.clear(this, e);
  }, r.count = function (e) {
    return a.count(this, e);
  }, r.render = function (t) {
    return a.render(e, t);
  }, r.destroy = function (e, t) {
    return a.destroy(this, e, t);
  }, r.setSelected = function (e) {
    return a.setSelected(this, e);
  }, r.getSelected = function () {
    return a.getSelected(this);
  }, r.getSelections = function () {
    return a.getSelections(this);
  }, r.selectAll = function () {
    return a.selectAll(this);
  }, r.unSelectAll = function () {
    return a.unSelectAll(this);
  }, r.getById = function (e) {
    return a.getById(this, e);
  }, r.get = function (e) {
    return a.getByPosition(this, e);
  }, r.getAll = function (e) {
    return a.getAll(this, e);
  }, r.showColumn = function (e) {
    return a.showColumn(this, e);
  }, r.hideColumn = function (e) {
    return a.hideColumn(this, e);
  }, r.addRow = function (e) {
    return a.addRow(this, e);
  }, r.updateRow = function (e, t) {
    return a.updateRow(this, e, t);
  }, r.setCellContent = function (e, t, r) {
    a.setCellContent(this, e, t, r);
  }, r.removeRow = function (e) {
    return a.removeRow(this, e);
  }, $.extend(e, r), "grid" !== e.attr("data-type") && a.init.call(e, t), e;
}, gj.grid.widget.prototype = new gj.widget(), gj.grid.widget.constructor = gj.grid.widget, gj.grid.widget.prototype.getConfig = gj.grid.methods.getConfig, gj.grid.widget.prototype.getHTMLConfig = gj.grid.methods.getHTMLConfig, jQuery.fn.grid = function (e) {
  var t;
  if (this && this.length) {
    if ("object" != _typeof(e) && e) {
      if ((t = new gj.grid.widget(this, null))[e]) return t[e].apply(this, Array.prototype.slice.call(arguments, 1));
      throw "Method " + e + " does not exist.";
    }
    return new gj.grid.widget(this, e);
  }
}, gj.grid.plugins.fixedHeader = {
  config: {
    base: {
      fixedHeader: !1,
      height: 300
    }
  },
  "private": {
    init: function init(e) {
      var t = e.data(),
        r = e.children("tbody"),
        a = e.children("thead"),
        i = t.height - a.outerHeight() - (e.children("tfoot").outerHeight() || 0);
      e.addClass("gj-grid-scrollable"), r.css("width", a.outerWidth()), r.height(i);
    },
    refresh: function refresh(e) {
      var t,
        r,
        a = (e.data(), e.children("tbody")),
        i = e.children("thead"),
        o = e.find('tbody tr[data-role="row"] td'),
        n = e.find('thead tr[data-role="caption"] th');
      for (e.children("tbody").height() < gj.grid.plugins.fixedHeader["private"].getRowsHeight(e) ? a.css("width", i.outerWidth() + gj.grid.plugins.fixedHeader["private"].getScrollBarWidth() + (navigator.userAgent.toLowerCase().indexOf("firefox") > -1 ? 1 : 0)) : a.css("width", i.outerWidth()), t = 0; t < n.length; t++) {
        r = $(n[t]).outerWidth(), 0 === t && gj.core.isIE() && (r -= 1), $(o[t]).attr("width", r);
      }
    },
    getRowsHeight: function getRowsHeight(e) {
      var t = 0;
      return e.find("tbody tr").each(function () {
        t += $(this).height();
      }), t;
    },
    getScrollBarWidth: function getScrollBarWidth() {
      var e = document.createElement("p");
      e.style.width = "100%", e.style.height = "200px";
      var t = document.createElement("div");
      t.style.position = "absolute", t.style.top = "0px", t.style.left = "0px", t.style.visibility = "hidden", t.style.width = "200px", t.style.height = "150px", t.style.overflow = "hidden", t.appendChild(e), document.body.appendChild(t);
      var r = e.offsetWidth;
      t.style.overflow = "scroll";
      var a = e.offsetWidth;
      return r == a && (a = t.clientWidth), document.body.removeChild(t), r - a;
    }
  },
  "public": {},
  events: {},
  configure: function configure(e, t, r) {
    $.extend(!0, e, gj.grid.plugins.fixedHeader["public"]), e.data(), r.fixedHeader && (e.on("initialized", function () {
      gj.grid.plugins.fixedHeader["private"].init(e);
    }), e.on("dataBound", function () {
      gj.grid.plugins.fixedHeader["private"].refresh(e);
    }), e.on("resize", function () {
      gj.grid.plugins.fixedHeader["private"].refresh(e);
    }));
  }
}, gj.grid.plugins.expandCollapseRows = {
  config: {
    base: {
      detailTemplate: void 0,
      keepExpandedRows: !0,
      expandedRows: [],
      icons: {
        expandRow: '<i class="gj-icon chevron-right" />',
        collapseRow: '<i class="gj-icon chevron-down" />'
      }
    },
    fontawesome: {
      icons: {
        expandRow: '<i class="fa fa-angle-right" aria-hidden="true"></i>',
        collapseRow: '<i class="fa fa-angle-down" aria-hidden="true"></i>'
      }
    },
    glyphicons: {
      icons: {
        expandRow: '<span class="glyphicon glyphicon-chevron-right" />',
        collapseRow: '<span class="glyphicon glyphicon-chevron-down" />'
      }
    }
  },
  "private": {
    expandDetail: function expandDetail(e, t, r) {
      var a = t.closest("tr"),
        i = $('<tr data-role="details" />'),
        o = $('<td colspan="' + gj.grid.methods.countVisibleColumns(e) + '" />'),
        n = $('<div data-role="display" />'),
        d = e.data(),
        s = a.data("position"),
        l = e.get(s),
        c = gj.grid.plugins.expandCollapseRows;
      void 0 === _typeof(r) && (r = gj.grid.methods.getId(l, d.primaryKey, l)), i.append(o.append(n.append(a.data("details")))), i.insertAfter(a), t.children('div[data-role="display"]').empty().append(d.icons.collapseRow), e.updateDetails(a), c["private"].keepSelection(e, r), c.events.detailExpand(e, i.find("td>div"), r);
    },
    collapseDetail: function collapseDetail(e, t, r) {
      var a = t.closest("tr").next('tr[data-role="details"]'),
        i = e.data(),
        o = gj.grid.plugins.expandCollapseRows;
      void 0 === _typeof(r) && (r = gj.grid.methods.getId(record, i.primaryKey, record)), a.remove(), t.children('div[data-role="display"]').empty().append(i.icons.expandRow), o["private"].removeSelection(e, r), o.events.detailCollapse(e, a.find("td>div"), r);
    },
    keepSelection: function keepSelection(e, t) {
      var r = e.data();
      r.keepExpandedRows && ($.isArray(r.expandedRows) ? -1 == r.expandedRows.indexOf(t) && r.expandedRows.push(t) : r.expandedRows = [t]);
    },
    removeSelection: function removeSelection(e, t) {
      var r = e.data();
      r.keepExpandedRows && $.isArray(r.expandedRows) && r.expandedRows.indexOf(t) > -1 && r.expandedRows.splice(r.expandedRows.indexOf(t), 1);
    },
    updateDetailsColSpan: function updateDetailsColSpan(e) {
      var t = e.find('tbody > tr[data-role="details"] > td');
      t && t.length && t.attr("colspan", gj.grid.methods.countVisibleColumns(e));
    }
  },
  "public": {
    collapseAll: function collapseAll() {
      var e,
        t = this,
        r = t.data();
      return void 0 !== r.detailTemplate && (e = gj.grid.methods.getColumnPositionByRole(t, "expander"), t.find('tbody tr[data-role="row"]').each(function () {
        gj.grid.plugins.expandCollapseRows["private"].collapseDetail(t, $(this).find("td:eq(" + e + ")"));
      })), void 0 !== r.grouping && t.find('tbody tr[role="group"]').each(function () {
        gj.grid.plugins.grouping["private"].collapseGroup(r, $(this).find("td:eq(0)"));
      }), t;
    },
    expandAll: function expandAll() {
      var e,
        t = this,
        r = t.data();
      return void 0 !== r.detailTemplate && (e = gj.grid.methods.getColumnPositionByRole(t, "expander"), t.find('tbody tr[data-role="row"]').each(function () {
        gj.grid.plugins.expandCollapseRows["private"].expandDetail(t, $(this).find("td:eq(" + e + ")"));
      })), void 0 !== r.grouping && t.find('tbody tr[role="group"]').each(function () {
        gj.grid.plugins.grouping["private"].expandGroup(r, $(this).find("td:eq(0)"));
      }), t;
    },
    updateDetails: function updateDetails(e) {
      var t = this,
        r = e.data("details"),
        a = r.html(),
        i = t.get(e.data("position"));
      return i && a && (r.html().replace(/\{(.+?)\}/g, function (e, r) {
        var o = gj.grid.methods.getColumnInfo(t, r);
        a = a.replace(e, gj.grid.methods.formatText(i[r], o));
      }), r.html(a)), t;
    }
  },
  events: {
    detailExpand: function detailExpand(e, t, r) {
      e.triggerHandler("detailExpand", [t, r]);
    },
    detailCollapse: function detailCollapse(e, t, r) {
      e.triggerHandler("detailCollapse", [t, r]);
    }
  },
  configure: function configure(e) {
    var t,
      r = e.data();
    $.extend(!0, e, gj.grid.plugins.expandCollapseRows["public"]), void 0 !== r.detailTemplate && (t = {
      title: "",
      width: r.defaultIconColumnWidth,
      align: "center",
      stopPropagation: !0,
      cssClass: "gj-cursor-pointer gj-unselectable",
      tmpl: r.icons.expandRow,
      role: "expander",
      events: {
        click: function click(t) {
          var r = $(this),
            a = gj.grid.plugins.expandCollapseRows["private"];
          "details" === r.closest("tr").next().attr("data-role") ? a.collapseDetail(e, r, t.data.id) : a.expandDetail(e, $(this), t.data.id);
        }
      }
    }, r.columns = [t].concat(r.columns), e.on("rowDataBound", function (e, t, a, i) {
      t.data("details", $(r.detailTemplate));
    }), e.on("columnShow", function (t, r) {
      gj.grid.plugins.expandCollapseRows["private"].updateDetailsColSpan(e);
    }), e.on("columnHide", function (t, r) {
      gj.grid.plugins.expandCollapseRows["private"].updateDetailsColSpan(e);
    }), e.on("rowRemoving", function (t, r, a, i) {
      gj.grid.plugins.expandCollapseRows["private"].collapseDetail(e, r.children("td").first(), a);
    }), e.on("dataBinding", function () {
      e.collapseAll();
    }), e.on("pageChanging", function () {
      e.collapseAll();
    }), e.on("dataBound", function () {
      var t,
        r,
        a,
        i,
        o = e.data();
      if (o.keepExpandedRows && $.isArray(o.expandedRows)) for (t = 0; t < o.expandedRows.length; t++) {
        (a = gj.grid.methods.getRowById(e, o.expandedRows[t])) && a.length && (i = gj.grid.methods.getColumnPositionByRole(e, "expander"), (r = a.children("td:eq(" + i + ")")) && r.length && gj.grid.plugins.expandCollapseRows["private"].expandDetail(e, r));
      }
    }));
  }
}, gj.grid.plugins.inlineEditing = {
  renderers: {
    editManager: function editManager(e, t, r, a, i, o) {
      var n = o.data(),
        d = $(n.inlineEditing.editButton).attr("key", i),
        s = $(n.inlineEditing.deleteButton).attr("key", i),
        l = $(n.inlineEditing.updateButton).attr("key", i).hide(),
        c = $(n.inlineEditing.cancelButton).attr("key", i).hide();
      d.on("click", function (e) {
        o.edit($(this).attr("key"));
      }), s.on("click", function (e) {
        o.removeRow($(this).attr("key"));
      }), l.on("click", function (e) {
        o.update($(this).attr("key"));
      }), c.on("click", function (e) {
        o.cancel($(this).attr("key"));
      }), a.empty().append(d).append(s).append(l).append(c);
    }
  }
}, gj.grid.plugins.inlineEditing.config = {
  base: {
    defaultColumnSettings: {
      editor: void 0,
      editField: void 0,
      mode: "readEdit"
    },
    inlineEditing: {
      mode: "click",
      managementColumn: !0,
      managementColumnConfig: {
        width: 300,
        role: "managementColumn",
        align: "center",
        renderer: gj.grid.plugins.inlineEditing.renderers.editManager,
        cssClass: "gj-grid-management-column"
      }
    }
  },
  bootstrap: {
    inlineEditing: {
      managementColumnConfig: {
        width: 200,
        role: "managementColumn",
        align: "center",
        renderer: gj.grid.plugins.inlineEditing.renderers.editManager,
        cssClass: "gj-grid-management-column"
      }
    }
  },
  bootstrap4: {
    inlineEditing: {
      managementColumnConfig: {
        width: 280,
        role: "managementColumn",
        align: "center",
        renderer: gj.grid.plugins.inlineEditing.renderers.editManager,
        cssClass: "gj-grid-management-column"
      }
    }
  }
}, gj.grid.plugins.inlineEditing["private"] = {
  localization: function localization(e) {
    "bootstrap" === e.uiLibrary ? (e.inlineEditing.editButton = '<button role="edit" class="btn btn-default btn-sm"><span class="glyphicon glyphicon-pencil" aria-hidden="true"></span> ' + gj.grid.messages[e.locale].Edit + "</button>", e.inlineEditing.deleteButton = '<button role="delete" class="btn btn-default btn-sm gj-margin-left-10"><span class="glyphicon glyphicon-remove" aria-hidden="true"></span> ' + gj.grid.messages[e.locale].Delete + "</button>", e.inlineEditing.updateButton = '<button role="update" class="btn btn-default btn-sm"><span class="glyphicon glyphicon-ok" aria-hidden="true"></span> ' + gj.grid.messages[e.locale].Update + "</button>", e.inlineEditing.cancelButton = '<button role="cancel" class="btn btn-default btn-sm gj-margin-left-10"><span class="glyphicon glyphicon-ban-circle" aria-hidden="true"></span> ' + gj.grid.messages[e.locale].Cancel + "</button>") : (e.inlineEditing.editButton = '<button role="edit" class="gj-button-md"><i class="gj-icon pencil" /> ' + gj.grid.messages[e.locale].Edit.toUpperCase() + "</button>", e.inlineEditing.deleteButton = '<button role="delete" class="gj-button-md"><i class="gj-icon delete" /> ' + gj.grid.messages[e.locale].Delete.toUpperCase() + "</button>", e.inlineEditing.updateButton = '<button role="update" class="gj-button-md"><i class="gj-icon check-circle" /> ' + gj.grid.messages[e.locale].Update.toUpperCase() + "</button>", e.inlineEditing.cancelButton = '<button role="cancel" class="gj-button-md"><i class="gj-icon cancel" /> ' + gj.grid.messages[e.locale].Cancel.toUpperCase() + "</button>");
  },
  editMode: function editMode(e, t, r, a) {
    var i,
      o,
      n,
      d,
      s,
      l = e.data();
    if ("edit" !== t.attr("data-mode")) if (r.editor) {
      if (gj.grid.plugins.inlineEditing["private"].updateOtherCells(e, r.mode), i = t.find('div[data-role="display"]').hide(), 0 === (o = t.find('div[data-role="edit"]').show()).length && (o = $('<div data-role="edit" />'), t.append(o)), d = a[r.editField || r.field], (n = o.find("input, select, textarea").first()).length) switch (r.type) {
        case "checkbox":
          n.prop("checked", d);
          break;
        case "dropdown":
          n = n.dropdown("value", d);
          break;
        default:
          n.val(d);
      } else {
        if ("function" == typeof r.editor) r.editor(o, d, a), n = o.find("input, select, textarea").first();else if ((s = "object" == _typeof(r.editor) ? r.editor : {}).uiLibrary = l.uiLibrary, s.iconsLibrary = l.iconsLibrary, s.fontSize = e.css("font-size"), s.showOnFocus = !1, "checkbox" === r.type && gj.checkbox) n = $('<input type="checkbox" />').prop("checked", d), o.append(n), n.checkbox(s);else if ("date" === r.type && gj.datepicker || "time" === r.type && gj.timepicker || "datetime" === r.type && gj.datetimepicker) {
          switch (n = $('<input type="text" width="100%"/>'), o.append(n), r.format && (s.format = r.format), r.type) {
            case "date":
              n = n.datepicker(s);
              break;
            case "time":
              n = n.timepicker(s);
              break;
            case "datetime":
              n = n.datetimepicker(s);
          }
          n.value && n.value(i.html());
        } else "dropdown" === r.type && gj.dropdown ? (n = $('<select type="text" width="100%"/>'), o.append(n), s.dataBound = function (e) {
          var t = $(this).dropdown();
          r.editField ? t.value(a[r.editField]) : t.value(a[r.field]);
        }, n = n.dropdown(s)) : (n = $('<input type="text" value="' + d + '" class="gj-width-full"/>'), "materialdesign" === l.uiLibrary && n.addClass("gj-textbox-md").css("font-size", e.css("font-size")), o.append(n));
        "command" !== l.inlineEditing.mode && "editOnly" !== r.mode && (n = o.find("input, select, textarea").first()).on("keyup", function (a) {
          13 !== a.keyCode && 27 !== a.keyCode || gj.grid.plugins.inlineEditing["private"].displayMode(e, t, r);
        });
      }
      "INPUT" === n.prop("tagName").toUpperCase() && "TEXT" === n.prop("type").toUpperCase() ? gj.core.setCaretAtEnd(n[0]) : n.focus(), t.attr("data-mode", "edit");
    } else "managementColumn" === r.role && (t.find('[role="edit"]').hide(), t.find('[role="delete"]').hide(), t.find('[role="update"]').show(), t.find('[role="cancel"]').show());
  },
  displayMode: function displayMode(e, t, r, a) {
    var i, o, n, d, s, l, c;
    "editOnly" !== r.mode && ("edit" === t.attr("data-mode") && (i = t.find('div[data-role="edit"]'), o = t.find('div[data-role="display"]'), "SELECT" === (n = i.find("input, select, textarea").first())[0].tagName.toUpperCase() && n[0].selectedIndex > -1 ? (d = n[0].options[n[0].selectedIndex].innerHTML, s = n[0].value) : d = "INPUT" === n[0].tagName.toUpperCase() && "CHECKBOX" === n[0].type.toUpperCase() ? n[0].checked : n.val(), c = t.parent().data("position"), l = e.get(c), !0 !== a && d !== l[r.field] && (l[r.field] = "date" === r.type ? gj.core.parseDate(d, r.format) : d, r.editField && (l[r.editField] = s || d), "editOnly" !== r.mode && (gj.grid.methods.renderDisplayElement(e, o, r, l, gj.grid.methods.getId(l, e.data("primaryKey"), c), "update"), 0 === t.find("span.gj-dirty").length && t.prepend($('<span class="gj-dirty" />'))), gj.grid.plugins.inlineEditing.events.cellDataChanged(e, t, r, l, d), gj.grid.plugins.inlineEditing["private"].updateChanges(e, r, l, d)), i.hide(), o.show(), t.attr("data-mode", "display")), "managementColumn" === r.role && (t.find('[role="update"]').hide(), t.find('[role="cancel"]').hide(), t.find('[role="edit"]').show(), t.find('[role="delete"]').show()));
  },
  updateOtherCells: function updateOtherCells(e, t) {
    var r = e.data();
    "command" !== r.inlineEditing.mode && "editOnly" !== t && e.find('div[data-role="edit"]:visible').parent("td").each(function () {
      var t = $(this),
        a = r.columns[t.index()];
      gj.grid.plugins.inlineEditing["private"].displayMode(e, t, a);
    });
  },
  updateChanges: function updateChanges(e, t, r, a) {
    var i,
      o,
      n,
      d = e.data();
    d.guid || (d.guid = gj.grid.plugins.inlineEditing["private"].generateGUID()), d.primaryKey && ((i = JSON.parse(sessionStorage.getItem("gj.grid." + d.guid))) ? o = i.filter(function (e) {
      return e[d.primaryKey] === r[d.primaryKey];
    }) : i = [], o && 1 === o.length ? o[0][t.field] = a : ((n = {})[d.primaryKey] = r[d.primaryKey], d.primaryKey !== t.field && (n[t.field] = a), i.push(n)), sessionStorage.setItem("gj.grid." + d.guid, JSON.stringify(i)));
  },
  generateGUID: function generateGUID() {
    function e() {
      return Math.floor(65536 * (1 + Math.random())).toString(16).substring(1);
    }
    return e() + e() + "-" + e() + "-" + e() + "-" + e() + "-" + e() + e() + e();
  }
}, gj.grid.plugins.inlineEditing["public"] = {
  getChanges: function getChanges() {
    return JSON.parse(sessionStorage.getItem("gj.grid." + this.data().guid));
  },
  edit: function edit(e) {
    var t,
      r = this.getById(e),
      a = gj.grid.methods.getRowById(this, e).children("td"),
      i = this.data("columns");
    for (t = 0; t < a.length; t++) {
      gj.grid.plugins.inlineEditing["private"].editMode(this, $(a[t]), i[t], r);
    }
    return this;
  },
  update: function update(e) {
    var t,
      r = this.getById(e),
      a = gj.grid.methods.getRowById(this, e).children("td"),
      i = this.data("columns");
    for (t = 0; t < a.length; t++) {
      gj.grid.plugins.inlineEditing["private"].displayMode(this, $(a[t]), i[t], !1);
    }
    return gj.grid.plugins.inlineEditing.events.rowDataChanged(this, e, r), this;
  },
  cancel: function cancel(e) {
    var t,
      r = (this.getById(e), gj.grid.methods.getRowById(this, e).children("td")),
      a = this.data("columns");
    for (t = 0; t < r.length; t++) {
      gj.grid.plugins.inlineEditing["private"].displayMode(this, $(r[t]), a[t], !0);
    }
    return this;
  }
}, gj.grid.plugins.inlineEditing.events = {
  cellDataChanged: function cellDataChanged(e, t, r, a, i, o) {
    e.triggerHandler("cellDataChanged", [t, r, a, i, o]);
  },
  rowDataChanged: function rowDataChanged(e, t, r) {
    e.triggerHandler("rowDataChanged", [t, r]);
  }
}, gj.grid.plugins.inlineEditing.configure = function (e, t, r) {
  var a = e.data();
  $.extend(!0, e, gj.grid.plugins.inlineEditing["public"]), r.inlineEditing && (e.on("dataBound", function () {
    e.find("span.gj-dirty").remove();
  }), e.on("rowDataBound", function (t, r, a, i) {
    e.cancel(a);
  })), "command" === a.inlineEditing.mode ? (gj.grid.plugins.inlineEditing["private"].localization(a), t.inlineEditing.managementColumn && a.columns.push(t.inlineEditing.managementColumnConfig)) : e.on("cellDataBound", function (t, r, i, o, n) {
    o.editor && ("editOnly" === o.mode ? gj.grid.plugins.inlineEditing["private"].editMode(e, r.parent(), o, n) : r.parent("td").on("dblclick" === a.inlineEditing.mode ? "dblclick" : "click", function () {
      gj.grid.plugins.inlineEditing["private"].editMode(e, r.parent(), o, n);
    }));
  });
}, gj.grid.plugins.optimisticPersistence = {
  config: {
    base: {
      optimisticPersistence: {
        localStorage: void 0,
        sessionStorage: void 0
      }
    }
  },
  "private": {
    applyParams: function applyParams(e) {
      var t,
        r = e.data(),
        a = {};
      (t = JSON.parse(sessionStorage.getItem("gj.grid." + r.guid))) && t.optimisticPersistence && $.extend(a, t.optimisticPersistence), (t = JSON.parse(localStorage.getItem("gj.grid." + r.guid))) && t.optimisticPersistence && $.extend(a, t.optimisticPersistence), $.extend(r.params, a);
    },
    saveParams: function saveParams(e) {
      var t,
        r,
        a = e.data(),
        i = {
          optimisticPersistence: {}
        };
      if (a.optimisticPersistence.sessionStorage) {
        for (t = 0; t < a.optimisticPersistence.sessionStorage.length; t++) {
          r = a.optimisticPersistence.sessionStorage[t], i.optimisticPersistence[r] = a.params[r];
        }
        i = $.extend(!0, JSON.parse(sessionStorage.getItem("gj.grid." + a.guid)), i), sessionStorage.setItem("gj.grid." + a.guid, JSON.stringify(i));
      }
      if (a.optimisticPersistence.localStorage) {
        for (i = {
          optimisticPersistence: {}
        }, t = 0; t < a.optimisticPersistence.localStorage.length; t++) {
          r = a.optimisticPersistence.localStorage[t], i.optimisticPersistence[r] = a.params[r];
        }
        i = $.extend(!0, JSON.parse(localStorage.getItem("gj.grid." + a.guid)), i), localStorage.setItem("gj.grid." + a.guid, JSON.stringify(i));
      }
    }
  },
  configure: function configure(e, t, r) {
    t.guid && (t.optimisticPersistence.localStorage || t.optimisticPersistence.sessionStorage) && (gj.grid.plugins.optimisticPersistence["private"].applyParams(e), e.on("dataBound", function (t) {
      gj.grid.plugins.optimisticPersistence["private"].saveParams(e);
    }));
  }
}, gj.grid.plugins.pagination = {
  config: {
    base: {
      style: {
        pager: {
          panel: "",
          stateDisabled: "",
          activeButton: ""
        }
      },
      paramNames: {
        page: "page",
        limit: "limit"
      },
      pager: {
        limit: 10,
        sizes: [5, 10, 20, 100],
        leftControls: void 0,
        rightControls: void 0
      }
    },
    bootstrap: {
      style: {
        pager: {
          panel: "",
          stateDisabled: ""
        }
      }
    },
    bootstrap4: {
      style: {
        pager: {
          panel: "btn-toolbar",
          stateDisabled: ""
        }
      }
    },
    glyphicons: {
      icons: {
        first: '<span class="glyphicon glyphicon-step-backward"></span>',
        previous: '<span class="glyphicon glyphicon-backward"></span>',
        next: '<span class="glyphicon glyphicon-forward"></span>',
        last: '<span class="glyphicon glyphicon-step-forward"></span>',
        refresh: '<span class="glyphicon glyphicon-refresh"></span>'
      }
    },
    materialicons: {
      icons: {
        first: '<i class="gj-icon first-page" />',
        previous: '<i class="ti-angle-left" />',
        next: '<i class="ti-angle-right" />',
        last: '<i class="gj-icon last-page" />',
        refresh: '<i class="gj-icon refresh" />'
      }
    },
    fontawesome: {
      icons: {
        first: '<i class="fa fa-fast-backward" aria-hidden="true"></i>',
        previous: '<i class="fa fa-backward" aria-hidden="true"></i>',
        next: '<i class="fa fa-forward" aria-hidden="true"></i>',
        last: '<i class="fa fa-fast-forward" aria-hidden="true"></i>',
        refresh: '<i class="fa fa-refresh" aria-hidden="true"></i>'
      }
    }
  },
  "private": {
    init: function init(e) {
      var t, r, a, i, o, n, d, s, l, c;
      if ((a = e.data()).pager) for (a.params[a.paramNames.page] || (a.params[a.paramNames.page] = 1), a.params[a.paramNames.limit] || (a.params[a.paramNames.limit] = a.pager.limit), gj.grid.plugins.pagination["private"].localization(a), t = $('<tr data-role="pager"/>'), r = $("<th/>"), t.append(r), o = $('<div data-role="display" />').addClass(a.style.pager.panel).css({
        "float": "left"
      }), n = $('<div data-role="display" />').addClass(a.style.pager.panel).css({
        "float": "right"
      }), r.append(o).append(n), d = $("<tfoot />").append(t), e.append(d), gj.grid.plugins.pagination["private"].updatePagerColSpan(e), s = gj.grid.methods.clone(a.pager.leftControls), $.each(s, function () {
        o.append(this);
      }), l = gj.grid.methods.clone(a.pager.rightControls), $.each(l, function () {
        n.append(this);
      }), i = e.find("tfoot [data-role]"), c = 0; c < i.length; c++) {
        gj.grid.plugins.pagination["private"].initPagerControl($(i[c]), e);
      }
    },
    localization: function localization(e) {
      "bootstrap" === e.uiLibrary ? gj.grid.plugins.pagination["private"].localizationBootstrap(e) : "bootstrap4" === e.uiLibrary ? gj.grid.plugins.pagination["private"].localizationBootstrap4(e) : gj.grid.plugins.pagination["private"].localizationMaterialDesign(e);
    },
    localizationBootstrap: function localizationBootstrap(e) {
      var t = gj.grid.messages[e.locale];
      void 0 === e.pager.leftControls && (e.pager.leftControls = [$('<button type="button" class="btn btn-default btn-sm">' + (e.icons.first || t.First) + "</button>").attr("title", t.FirstPageTooltip).attr("data-role", "page-first"), $('<button type="button" class="btn btn-default btn-sm">' + (e.icons.previous || t.Previous) + "</button>").attr("title", t.PreviousPageTooltip).attr("data-role", "page-previous"), $("<div>" + t.Page + "</div>"), $('<input data-role="page-number" class="form-control input-sm" type="text" value="0">'), $("<div>" + t.Of + "</div>"), $('<div data-role="page-label-last">0</div>'), $('<button type="button" class="btn btn-default btn-sm">' + (e.icons.next || t.Next) + "</button>").attr("title", t.NextPageTooltip).attr("data-role", "page-next"), $('<button type="button" class="btn btn-default btn-sm">' + (e.icons.last || t.Last) + "</button>").attr("title", t.LastPageTooltip).attr("data-role", "page-last"), $('<button type="button" class="btn btn-default btn-sm">' + (e.icons.refresh || t.Refresh) + "</button>").attr("title", t.Refresh).attr("data-role", "page-refresh"), $('<select data-role="page-size" class="form-control input-sm" width="60"></select>')]), void 0 === e.pager.rightControls && (e.pager.rightControls = [$("<div>" + t.DisplayingRecords + "</div>"), $('<div data-role="record-first">0</div>'), $("<div>-</div>"), $('<div data-role="record-last">0</div>'), $("<div>" + t.Of + "</div>"), $('<div data-role="record-total">0</div>')]);
    },
    localizationBootstrap4: function localizationBootstrap4(e) {
      var t = gj.grid.messages[e.locale];
      void 0 === e.pager.leftControls && (e.pager.leftControls = [$('<button class="btn btn-default btn-sm gj-cursor-pointer">' + (e.icons.first || t.First) + "</button>").attr("title", t.FirstPageTooltip).attr("data-role", "page-first"), $('<button class="btn btn-default btn-sm gj-cursor-pointer">' + (e.icons.previous || t.Previous) + "</button>").attr("title", t.PreviousPageTooltip).attr("data-role", "page-previous"), $("<div>" + t.Page + "</div>"), $('<div class="input-group"><input data-role="page-number" class="form-control form-control-sm" type="text" value="0"></div>'), $("<div>" + t.Of + "</div>"), $('<div data-role="page-label-last">0</div>'), $('<button class="btn btn-default btn-sm gj-cursor-pointer">' + (e.icons.next || t.Next) + "</button>").attr("title", t.NextPageTooltip).attr("data-role", "page-next"), $('<button class="btn btn-default btn-sm gj-cursor-pointer">' + (e.icons.last || t.Last) + "</button>").attr("title", t.LastPageTooltip).attr("data-role", "page-last"), $('<button class="btn btn-default btn-sm gj-cursor-pointer">' + (e.icons.refresh || t.Refresh) + "</button>").attr("title", t.Refresh).attr("data-role", "page-refresh"), $('<select data-role="page-size" class="form-control input-sm" width="60"></select>')]), void 0 === e.pager.rightControls && (e.pager.rightControls = [$("<div>" + t.DisplayingRecords + "&nbsp;</div>"), $('<div data-role="record-first">0</div>'), $("<div>-</div>"), $('<div data-role="record-last">0</div>'), $("<div>" + t.Of + "</div>"), $('<div data-role="record-total">0</div>')]);
    },
    localizationMaterialDesign: function localizationMaterialDesign(e) {
      var t = gj.grid.messages[e.locale];
      void 0 === e.pager.leftControls && (e.pager.leftControls = []), void 0 === e.pager.rightControls && (e.pager.rightControls = [$('<span class="">' + t.RowsPerPage + "</span>"), $('<select data-role="page-size" class="gj-grid-md-limit-select" width="52"></select></div>'), $('<span class="gj-md-spacer-32">&nbsp;</span>'), $('<span data-role="record-first" class="">0</span>'), $('<span class="">-</span>'), $('<span data-role="record-last" class="">0</span>'), $('<span class="gj-grid-mdl-pager-label">' + t.Of + "</span>"), $('<span data-role="record-total" class="">0</span>'), $('<span class="gj-md-spacer-32">&nbsp;</span>'), $('<button class="gj-button-md">' + (e.icons.previous || t.Previous) + "</button>").attr("title", t.PreviousPageTooltip).attr("data-role", "page-previous").addClass(e.icons.first ? "gj-button-md-icon" : ""), $('<span class="gj-md-spacer-24">&nbsp;</span>'), $('<button class="gj-button-md">' + (e.icons.next || t.Next) + "</button>").attr("title", t.NextPageTooltip).attr("data-role", "page-next").addClass(e.icons.first ? "gj-button-md-icon" : "")]);
    },
    initPagerControl: function initPagerControl(e, t) {
      var r = t.data();
      switch (e.data("role")) {
        case "page-size":
          r.pager.sizes && 0 < r.pager.sizes.length ? (e.show(), $.each(r.pager.sizes, function () {
            e.append($("<option/>").attr("value", this.toString()).text(this.toString()));
          }), e.change(function () {
            var e = parseInt(this.value, 10);
            r.params[r.paramNames.limit] = e, gj.grid.plugins.pagination["private"].changePage(t, 1), gj.grid.plugins.pagination.events.pageSizeChange(t, e);
          }), e.val(r.params[r.paramNames.limit]), gj.dropdown && e.dropdown({
            uiLibrary: r.uiLibrary,
            iconsLibrary: r.iconsLibrary,
            fontSize: e.css("font-size"),
            style: {
              presenter: "btn btn-default btn-sm"
            }
          })) : e.hide();
          break;
        case "page-refresh":
          e.on("click", function () {
            t.reload();
          });
      }
    },
    reloadPager: function reloadPager(e, t) {
      var r, a, i, o, n, d, s, l;
      if ((d = e.data()).pager) {
        for (r = 0 === t ? 0 : parseInt(d.params[d.paramNames.page], 10), a = parseInt(d.params[d.paramNames.limit], 10), i = Math.ceil(t / a), n = (o = 0 === r ? 0 : a * (r - 1) + 1) + a > t ? t : o + a - 1, s = e.find("TFOOT [data-role]"), l = 0; l < s.length; l++) {
          gj.grid.plugins.pagination["private"].reloadPagerControl($(s[l]), e, r, i, o, n, t);
        }
        gj.grid.plugins.pagination["private"].updatePagerColSpan(e);
      }
    },
    reloadPagerControl: function reloadPagerControl(e, t, r, a, i, o, n) {
      var d;
      switch (e.data("role")) {
        case "page-first":
          gj.grid.plugins.pagination["private"].assignPageHandler(t, e, 1, r < 2);
          break;
        case "page-previous":
          gj.grid.plugins.pagination["private"].assignPageHandler(t, e, r - 1, r < 2);
          break;
        case "page-number":
          e.val(r).off("change").on("change", gj.grid.plugins.pagination["private"].createChangePageHandler(t, r));
          break;
        case "page-label-last":
          e.text(a);
          break;
        case "page-next":
          gj.grid.plugins.pagination["private"].assignPageHandler(t, e, r + 1, a === r);
          break;
        case "page-last":
          gj.grid.plugins.pagination["private"].assignPageHandler(t, e, a, a === r);
          break;
        case "page-button-one":
          d = 1 === r ? 1 : r == a ? r - 2 : r - 1, gj.grid.plugins.pagination["private"].assignButtonHandler(t, e, r, d, a);
          break;
        case "page-button-two":
          d = 1 === r ? 2 : r == a ? a - 1 : r, gj.grid.plugins.pagination["private"].assignButtonHandler(t, e, r, d, a);
          break;
        case "page-button-three":
          d = 1 === r ? r + 2 : r == a ? r : r + 1, gj.grid.plugins.pagination["private"].assignButtonHandler(t, e, r, d, a);
          break;
        case "record-first":
          e.text(i);
          break;
        case "record-last":
          e.text(o);
          break;
        case "record-total":
          e.text(n);
      }
    },
    assignPageHandler: function assignPageHandler(e, t, r, a) {
      var i = e.data().style.pager;
      a ? t.addClass(i.stateDisabled).prop("disabled", !0).off("click") : t.removeClass(i.stateDisabled).prop("disabled", !1).off("click").on("click", function () {
        gj.grid.plugins.pagination["private"].changePage(e, r);
      });
    },
    assignButtonHandler: function assignButtonHandler(e, t, r, a, i) {
      var o = e.data().style.pager;
      a < 1 || a > i ? t.hide() : (t.show().off("click").text(a), a === r ? t.addClass(o.activeButton) : t.removeClass(o.activeButton).on("click", function () {
        gj.grid.plugins.pagination["private"].changePage(e, a);
      }));
    },
    createChangePageHandler: function createChangePageHandler(e, t) {
      return function () {
        var t = (e.data(), parseInt(this.value, 10));
        gj.grid.plugins.pagination["private"].changePage(e, t);
      };
    },
    changePage: function changePage(e, t) {
      var r = e.data();
      !1 === gj.grid.plugins.pagination.events.pageChanging(e, t) || isNaN(t) || (e.find('TFOOT [data-role="page-number"]').val(t), r.params[r.paramNames.page] = t), e.reload();
    },
    updatePagerColSpan: function updatePagerColSpan(e) {
      var t = e.find('tfoot > tr[data-role="pager"] > th');
      t && t.length && t.attr("colspan", gj.grid.methods.countVisibleColumns(e));
    },
    isLastRecordVisible: function isLastRecordVisible(e) {
      var t = !0,
        r = e.data(),
        a = parseInt(r.params[r.paramNames.limit], 10),
        i = parseInt(r.params[r.paramNames.page], 10),
        o = e.count();
      return a && i && (t = (i - 1) * a + o === r.totalRecords), t;
    }
  },
  "public": {
    getAll: function getAll(e) {
      var t,
        r,
        a = this.data();
      return $.isArray(a.dataSource) ? e ? a.dataSource : a.params[a.paramNames.limit] && a.params[a.paramNames.page] ? (t = parseInt(a.params[a.paramNames.limit], 10), r = (parseInt(a.params[a.paramNames.page], 10) - 1) * t, a.records.slice(r, r + t)) : a.records : a.records;
    }
  },
  events: {
    pageSizeChange: function pageSizeChange(e, t) {
      e.triggerHandler("pageSizeChange", [t]);
    },
    pageChanging: function pageChanging(e, t) {
      e.triggerHandler("pageChanging", [t]);
    }
  },
  configure: function configure(e, t, r) {
    $.extend(!0, e, gj.grid.plugins.pagination["public"]), e.data(), r.pager && (gj.grid.methods.isLastRecordVisible = gj.grid.plugins.pagination["private"].isLastRecordVisible, e.on("initialized", function () {
      gj.grid.plugins.pagination["private"].init(e);
    }), e.on("dataBound", function (t, r, a) {
      gj.grid.plugins.pagination["private"].reloadPager(e, a);
    }), e.on("columnShow", function () {
      gj.grid.plugins.pagination["private"].updatePagerColSpan(e);
    }), e.on("columnHide", function () {
      gj.grid.plugins.pagination["private"].updatePagerColSpan(e);
    }));
  }
}, gj.grid.plugins.responsiveDesign = {
  config: {
    base: {
      resizeCheckInterval: 500,
      responsive: !1,
      showHiddenColumnsAsDetails: !1,
      defaultColumn: {
        priority: void 0,
        minWidth: 250
      },
      style: {
        rowDetailItem: ""
      }
    },
    bootstrap: {
      style: {
        rowDetailItem: "col-lg-4"
      }
    }
  },
  "private": {
    orderColumns: function orderColumns(e) {
      var t = [];
      if (e.columns && e.columns.length) {
        for (i = 0; i < e.columns.length; i++) {
          t.push({
            position: i,
            field: e.columns[i].field,
            minWidth: e.columns[i].width || e.columns[i].minWidth || e.defaultColumn.minWidth,
            priority: e.columns[i].priority || 0
          });
        }
        t.sort(function (e, t) {
          var r = 0;
          return e.priority < t.priority ? r = -1 : e.priority > t.priority && (r = 1), r;
        });
      }
      return t;
    },
    updateDetails: function updateDetails(e) {
      var t, r, a, i, o, n, d, s, l;
      for (t = e.find('tbody > tr[data-role="row"]'), r = e.data(), a = 0; a < t.length; a++) {
        for (n = (o = $(t[a])).data("details"), i = 0; i < r.columns.length; i++) {
          s = r.columns[i], d = n && n.find('div[data-id="' + s.field + '"]'), r.columns[i].hidden ? (l = "<b>" + (s.title || s.field) + "</b>: {" + s.field + "}", d && d.length ? d.empty().html(l) : ((d = $('<div data-id="' + s.field + '"/>').html(l)).addClass(r.style.rowDetailItem), n && n.length || (n = $('<div class="row"/>')), n.append(d))) : d && d.length && d.remove();
        }
        e.updateDetails(o);
      }
    }
  },
  "public": {
    oldWidth: void 0,
    resizeCheckIntervalId: void 0,
    makeResponsive: function makeResponsive() {
      var e,
        t,
        r = 0,
        a = this.data(),
        i = gj.grid.plugins.responsiveDesign["private"].orderColumns(a);
      for (e = 0; e < i.length; e++) {
        (t = this.find("thead>tr>th:eq(" + i[e].position + ")")).is(":visible") && i[e].minWidth < t.width() && (r += t.width() - i[e].minWidth);
      }
      if (r) for (e = 0; e < i.length; e++) {
        !(t = this.find("thead>tr>th:eq(" + i[e].position + ")")).is(":visible") && i[e].minWidth <= r && (this.showColumn(i[e].field), r -= t.width());
      }
      for (e = i.length - 1; e >= 0; e--) {
        (t = this.find("thead>tr>th:eq(" + i[e].position + ")")).is(":visible") && i[e].priority && i[e].minWidth > t.outerWidth() && this.hideColumn(i[e].field);
      }
      return this;
    }
  },
  events: {
    resize: function resize(e, t, r) {
      e.triggerHandler("resize", [t, r]);
    }
  },
  configure: function configure(e, t, r) {
    $.extend(!0, e, gj.grid.plugins.responsiveDesign["public"]), t.responsive && (e.on("initialized", function () {
      e.makeResponsive(), e.oldWidth = e.width(), e.resizeCheckIntervalId = setInterval(function () {
        var t = e.width();
        t !== e.oldWidth && gj.grid.plugins.responsiveDesign.events.resize(e, t, e.oldWidth), e.oldWidth = t;
      }, t.resizeCheckInterval);
    }), e.on("destroy", function () {
      e.resizeCheckIntervalId && clearInterval(e.resizeCheckIntervalId);
    }), e.on("resize", function () {
      e.makeResponsive();
    })), t.showHiddenColumnsAsDetails && gj.grid.plugins.expandCollapseRows && (e.on("dataBound", function () {
      gj.grid.plugins.responsiveDesign["private"].updateDetails(e);
    }), e.on("columnHide", function () {
      gj.grid.plugins.responsiveDesign["private"].updateDetails(e);
    }), e.on("columnShow", function () {
      gj.grid.plugins.responsiveDesign["private"].updateDetails(e);
    }), e.on("rowDataBound", function () {
      gj.grid.plugins.responsiveDesign["private"].updateDetails(e);
    }));
  }
}, gj.grid.plugins.toolbar = {
  config: {
    base: {
      toolbarTemplate: void 0,
      title: void 0,
      style: {
        toolbar: "gj-grid-md-toolbar"
      }
    },
    bootstrap: {
      style: {
        toolbar: "gj-grid-bootstrap-toolbar"
      }
    },
    bootstrap4: {
      style: {
        toolbar: "gj-grid-bootstrap-4-toolbar"
      }
    }
  },
  "private": {
    init: function init(e) {
      var t, r, a;
      t = e.data(), r = e.prev('div[data-role="toolbar"]'), (void 0 !== t.toolbarTemplate || void 0 !== t.title || r.length > 0) && (0 === r.length && (r = $('<div data-role="toolbar"></div>'), e.before(r)), r.addClass(t.style.toolbar), 0 === r.children().length && t.toolbarTemplate && r.append(t.toolbarTemplate), 0 === (a = r.find('[data-role="title"]')).length && (a = $('<div data-role="title"/>'), r.prepend(a)), t.title && a.text(t.title), t.minWidth && r.css("min-width", t.minWidth));
    }
  },
  "public": {
    title: function title(e) {
      var t = this.parent().find('div[data-role="toolbar"] [data-role="title"]');
      return void 0 !== e ? (t.text(e), this) : t.text();
    }
  },
  configure: function configure(e) {
    $.extend(!0, e, gj.grid.plugins.toolbar["public"]), e.on("initialized", function () {
      gj.grid.plugins.toolbar["private"].init(e);
    }), e.on("destroying", function () {
      e.prev('[data-role="toolbar"]').remove();
    });
  }
}, gj.grid.plugins.resizableColumns = {
  config: {
    base: {
      resizableColumns: !1
    }
  },
  "private": {
    init: function init(e, t) {
      var r, a, i, o, n, d;
      if ((r = e.find('thead tr[data-role="caption"] th')).length) {
        for (i = 0; i < r.length - 1; i++) {
          a = $(r[i]), o = $('<div class="gj-grid-column-resizer-wrapper" />'), d = parseInt(a.css("padding-right"), 10) + 3, (n = $('<span class="gj-grid-column-resizer" />').css("margin-right", "-" + d + "px")).draggable({
            start: function start() {
              e.addClass("gj-unselectable"), e.addClass("gj-grid-resize-cursor");
            },
            stop: function stop() {
              e.removeClass("gj-unselectable"), e.removeClass("gj-grid-resize-cursor"), this.style.removeProperty("top"), this.style.removeProperty("left"), this.style.removeProperty("position");
            },
            drag: gj.grid.plugins.resizableColumns["private"].createResizeHandle(e, a, t.columns[i])
          }), a.append(o.append(n));
        }
        for (i = 0; i < r.length; i++) {
          (a = $(r[i])).attr("width") || a.attr("width", a.outerWidth());
        }
      }
    },
    createResizeHandle: function createResizeHandle(e, t, r) {
      var a = e.data();
      return function (i, o) {
        var n,
          d,
          s,
          l,
          c,
          g,
          p = parseInt(t.attr("width"), 10),
          u = gj.core.position(this),
          h = (o.top, u.top, o.left - u.left);
        if (p || (p = t.outerWidth()), h && (c = p + h, r.width = c, t.attr("width", c), d = t[0].cellIndex, l = t[0].parentElement.children[d + 1], g = parseInt($(l).attr("width"), 10) - h, l.setAttribute("width", g), a.resizableColumns)) for (s = e[0].tBodies[0].children, n = 0; n < s.length; n++) {
          s[n].cells[d].setAttribute("width", c), (l = s[n].cells[d + 1]).setAttribute("width", g);
        }
      };
    }
  },
  "public": {},
  configure: function configure(e, t, r) {
    $.extend(!0, e, gj.grid.plugins.resizableColumns["public"]), t.resizableColumns && gj.draggable && e.on("initialized", function () {
      gj.grid.plugins.resizableColumns["private"].init(e, t);
    });
  }
}, gj.grid.plugins.rowReorder = {
  config: {
    base: {
      rowReorder: !1,
      rowReorderColumn: void 0,
      orderNumberField: void 0,
      style: {
        targetRowIndicatorTop: "gj-grid-row-reorder-indicator-top",
        targetRowIndicatorBottom: "gj-grid-row-reorder-indicator-bottom"
      }
    }
  },
  "private": {
    init: function init(e) {
      var t,
        r,
        a,
        i = e.find('tbody tr[data-role="row"]');
      for (e.data("rowReorderColumn") && (r = gj.grid.methods.getColumnPosition(e.data("columns"), e.data("rowReorderColumn"))), t = 0; t < i.length; t++) {
        a = $(i[t]), void 0 !== r ? a.find("td:eq(" + r + ")").on("mousedown", gj.grid.plugins.rowReorder["private"].createRowMouseDownHandler(e, a)) : a.on("mousedown", gj.grid.plugins.rowReorder["private"].createRowMouseDownHandler(e, a));
      }
    },
    createRowMouseDownHandler: function createRowMouseDownHandler(e, t) {
      return function (r) {
        var a,
          i,
          o = e.clone(),
          n = e.data("columns");
        for (e.addClass("gj-unselectable"), $("body").append(o), o.attr("data-role", "draggable-clone").css("cursor", "move"), o.children("thead").remove().children("tfoot").remove(), o.find('tbody tr:not([data-position="' + t.data("position") + '"])').remove(), i = o.find("tbody tr td"), a = 0; a < i.length; a++) {
          n[a].width && i[a].setAttribute("width", n[a].width);
        }
        o.draggable({
          stop: gj.grid.plugins.rowReorder["private"].createDragStopHandler(e, t)
        }), o.css({
          position: "absolute",
          top: t.offset().top,
          left: t.offset().left,
          width: t.width(),
          zIndex: 1
        }), "true" === t.attr("data-droppable") && t.droppable("destroy"), t.siblings('tr[data-role="row"]').each(function () {
          var e = $(this);
          "true" === e.attr("data-droppable") && e.droppable("destroy"), e.droppable({
            over: gj.grid.plugins.rowReorder["private"].createDroppableOverHandler(t),
            out: gj.grid.plugins.rowReorder["private"].droppableOut
          });
        }), o.trigger("mousedown");
      };
    },
    createDragStopHandler: function createDragStopHandler(e, t) {
      return function (r, a) {
        $('table[data-role="draggable-clone"]').draggable("destroy").remove(), e.removeClass("gj-unselectable"), t.siblings('tr[data-role="row"]').each(function () {
          var r,
            i,
            o,
            n,
            d,
            s = $(this),
            l = s.data("position"),
            c = t.data("position"),
            g = e.data();
          if (s.droppable("isOver", a)) {
            for (l < c ? s.before(t) : s.after(t), g.records.splice(l - 1, 0, g.records.splice(c - 1, 1)[0]), r = s.parent().find('tr[data-role="row"]'), o = 0; o < r.length; o++) {
              $(r[o]).attr("data-position", o + 1);
            }
            if (g.orderNumberField) {
              for (o = 0; o < g.records.length; o++) {
                g.records[o][g.orderNumberField] = o + 1;
              }
              for (o = 0; o < r.length; o++) {
                i = $(r[o]), d = gj.grid.methods.getId(i, g.primaryKey, i.attr("data-position")), n = gj.grid.methods.getByPosition(e, i.attr("data-position")), e.setCellContent(d, g.orderNumberField, n[g.orderNumberField]);
              }
            }
          }
          s.removeClass("gj-grid-top-border"), s.removeClass("gj-grid-bottom-border"), s.droppable("destroy");
        });
      };
    },
    createDroppableOverHandler: function createDroppableOverHandler(e) {
      return function (t) {
        var r = $(this);
        r.data("position") < e.data("position") ? r.addClass("gj-grid-top-border") : r.addClass("gj-grid-bottom-border");
      };
    },
    droppableOut: function droppableOut() {
      $(this).removeClass("gj-grid-top-border"), $(this).removeClass("gj-grid-bottom-border");
    }
  },
  "public": {},
  configure: function configure(e, t, r) {
    $.extend(!0, e, gj.grid.plugins.rowReorder["public"]), t.rowReorder && gj.draggable && gj.droppable && e.on("dataBound", function () {
      gj.grid.plugins.rowReorder["private"].init(e);
    });
  }
}, gj.grid.plugins["export"] = {
  config: {
    base: {}
  },
  "public": {
    getCSV: function getCSV(e) {
      var t,
        r,
        a = "",
        i = "",
        o = this.data().columns,
        n = this.getAll(e);
      if (n.length) {
        for (t = 0; t < o.length; t++) {
          gj.grid.plugins["export"]["public"].isColumnApplicable(o[t]) && (a += '"' + (o[t].title || o[t].field).replace(/<[^>]+>/g, " ") + '",');
        }
        for (i += a.slice(0, a.length - 1) + "\r\n", t = 0; t < n.length; t++) {
          for (a = "", r = 0; r < o.length; r++) {
            gj.grid.plugins["export"]["public"].isColumnApplicable(o[r]) && (a += '"' + n[t][o[r].field] + '",');
          }
          i += a.slice(0, a.length - 1) + "\r\n";
        }
      }
      return i;
    },
    downloadCSV: function downloadCSV(e, t) {
      var r = document.createElement("a");
      return document.body.appendChild(r), r.download = e || "griddata.csv", window.navigator.userAgent.indexOf("Edge") > -1 ? r.href = URL.createObjectURL(new Blob([this.getCSV(t)], {
        type: "text/csv;charset=utf-8;"
      })) : r.href = "data:text/csv;charset=utf-8," + escape(this.getCSV(t)), r.click(), document.body.removeChild(r), this;
    },
    isColumnApplicable: function isColumnApplicable(e) {
      return !0 !== e.hidden && !e.role;
    }
  },
  configure: function configure(e) {
    $.extend(!0, e, gj.grid.plugins["export"]["public"]);
  }
}, gj.grid.plugins.columnReorder = {
  config: {
    base: {
      columnReorder: !1,
      dragReady: !1,
      style: {
        targetRowIndicatorTop: "gj-grid-row-reorder-indicator-top",
        targetRowIndicatorBottom: "gj-grid-row-reorder-indicator-bottom"
      }
    }
  },
  "private": {
    init: function init(e) {
      var t,
        r,
        a = e.find("thead tr th");
      for (t = 0; t < a.length; t++) {
        (r = $(a[t])).on("mousedown", gj.grid.plugins.columnReorder["private"].createMouseDownHandler(e, r)), r.on("mousemove", gj.grid.plugins.columnReorder["private"].createMouseMoveHandler(e, r)), r.on("mouseup", gj.grid.plugins.columnReorder["private"].createMouseUpHandler(e, r));
      }
    },
    createMouseDownHandler: function createMouseDownHandler(e) {
      return function (t) {
        e.timeout = setTimeout(function () {
          e.data("dragReady", !0);
        }, 100);
      };
    },
    createMouseUpHandler: function createMouseUpHandler(e) {
      return function (t) {
        clearTimeout(e.timeout), e.data("dragReady", !1);
      };
    },
    createMouseMoveHandler: function createMouseMoveHandler(e, t) {
      return function (r) {
        var a, i;
        e.data("dragReady") && (e.data("dragReady", !1), a = e.clone(), i = t.index(), e.addClass("gj-unselectable"), $("body").append(a), a.attr("data-role", "draggable-clone").css("cursor", "move"), a.find("thead tr th:eq(" + i + ")").siblings().remove(), a.find('tbody tr[data-role != "row"]').remove(), a.find("tbody tr td:nth-child(" + (i + 1) + ")").siblings().remove(), a.find("tfoot").remove(), a.draggable({
          stop: gj.grid.plugins.columnReorder["private"].createDragStopHandler(e, t)
        }), a.css({
          position: "absolute",
          top: t.offset().top,
          left: t.offset().left,
          width: t.width(),
          zIndex: 1
        }), "true" === t.attr("data-droppable") && t.droppable("destroy"), t.siblings("th").each(function () {
          var r = $(this);
          "true" === r.attr("data-droppable") && r.droppable("destroy"), r.droppable({
            over: gj.grid.plugins.columnReorder["private"].createDroppableOverHandler(e, t),
            out: gj.grid.plugins.columnReorder["private"].droppableOut
          });
        }), a.trigger("mousedown"));
      };
    },
    createDragStopHandler: function createDragStopHandler(e, t) {
      return function (r, a) {
        $('table[data-role="draggable-clone"]').draggable("destroy").remove(), e.removeClass("gj-unselectable"), t.siblings("th").each(function () {
          var r = $(this),
            i = e.data(),
            o = gj.grid.methods.getColumnPosition(i.columns, r.data("field")),
            n = gj.grid.methods.getColumnPosition(i.columns, t.data("field"));
          r.removeClass("gj-grid-left-border").removeClass("gj-grid-right-border"), r.closest("table").find('tbody tr[data-role="row"] td:nth-child(' + (r.index() + 1) + ")").removeClass("gj-grid-left-border").removeClass("gj-grid-right-border"), r.droppable("isOver", a) && (o < n ? r.before(t) : r.after(t), gj.grid.plugins.columnReorder["private"].moveRowCells(e, n, o), i.columns.splice(o, 0, i.columns.splice(n, 1)[0])), r.droppable("destroy");
        });
      };
    },
    moveRowCells: function moveRowCells(e, t, r) {
      var a,
        i,
        o = e.find('tbody tr[data-role="row"]');
      for (a = 0; a < o.length; a++) {
        i = $(o[a]), r < t ? i.find("td:eq(" + r + ")").before(i.find("td:eq(" + t + ")")) : i.find("td:eq(" + r + ")").after(i.find("td:eq(" + t + ")"));
      }
    },
    createDroppableOverHandler: function createDroppableOverHandler(e, t) {
      return function (r) {
        var a = $(this),
          i = e.data();
        gj.grid.methods.getColumnPosition(i.columns, a.data("field")) < gj.grid.methods.getColumnPosition(i.columns, t.data("field")) ? (a.addClass("gj-grid-left-border"), e.find('tbody tr[data-role="row"] td:nth-child(' + (a.index() + 1) + ")").addClass("gj-grid-left-border")) : (a.addClass("gj-grid-right-border"), e.find('tbody tr[data-role="row"] td:nth-child(' + (a.index() + 1) + ")").addClass("gj-grid-right-border"));
      };
    },
    droppableOut: function droppableOut() {
      var e = $(this);
      e.removeClass("gj-grid-left-border").removeClass("gj-grid-right-border"), e.closest("table").find('tbody tr[data-role="row"] td:nth-child(' + (e.index() + 1) + ")").removeClass("gj-grid-left-border").removeClass("gj-grid-right-border");
    }
  },
  "public": {},
  configure: function configure(e, t, r) {
    $.extend(!0, e, gj.grid.plugins.columnReorder["public"]), t.columnReorder && e.on("initialized", function () {
      gj.grid.plugins.columnReorder["private"].init(e);
    });
  }
}, gj.grid.plugins.headerFilter = {
  config: {
    base: {
      defaultColumnSettings: {
        filterable: !0
      },
      headerFilter: {
        type: "onenterkeypress"
      }
    }
  },
  "private": {
    init: function init(e) {
      var t,
        r,
        a,
        i = e.data(),
        o = $('<tr data-role="filter"/>');
      for (t = 0; t < i.columns.length; t++) {
        r = $("<th/>"), i.columns[t].filterable && (a = $('<input data-field="' + i.columns[t].field + '" class="gj-width-full" />'), "onchange" === i.headerFilter.type ? a.on("input propertychange", function (t) {
          gj.grid.plugins.headerFilter["private"].reload(e, $(this));
        }) : (a.on("keypress", function (t) {
          13 == t.which && gj.grid.plugins.headerFilter["private"].reload(e, $(this));
        }), a.on("blur", function (t) {
          gj.grid.plugins.headerFilter["private"].reload(e, $(this));
        })), r.append(a)), i.columns[t].hidden && r.hide(), o.append(r);
      }
      e.children("thead").append(o);
    },
    reload: function reload(e, t) {
      var r = {};
      r[t.data("field")] = t.val(), e.reload(r);
    }
  },
  "public": {},
  events: {},
  configure: function configure(e, t, r) {
    $.extend(!0, e, gj.grid.plugins.headerFilter["public"]), e.data(), r.headerFilter && e.on("initialized", function () {
      gj.grid.plugins.headerFilter["private"].init(e);
    });
  }
}, gj.grid.plugins.grouping = {
  config: {
    base: {
      paramNames: {
        groupBy: "groupBy",
        groupByDirection: "groupByDirection"
      },
      grouping: {
        groupBy: void 0,
        direction: "asc"
      },
      icons: {
        expandGroup: '<i class="gj-icon plus" />',
        collapseGroup: '<i class="gj-icon minus" />'
      }
    },
    fontawesome: {
      icons: {
        expandGroup: '<i class="fa fa-plus" aria-hidden="true"></i>',
        collapseGroup: '<i class="fa fa-minus" aria-hidden="true"></i>'
      }
    },
    glyphicons: {
      icons: {
        expandGroup: '<span class="glyphicon glyphicon-plus" />',
        collapseGroup: '<span class="glyphicon glyphicon-minus" />'
      }
    }
  },
  "private": {
    init: function init(e) {
      var t,
        r = e.data();
      t = void 0, e.on("rowDataBound", function (a, i, o, n) {
        if (t !== n[r.grouping.groupBy] || 1 === i[0].rowIndex) {
          var d = gj.grid.methods.countVisibleColumns(e) - 1,
            s = $('<tr role="group" />'),
            l = $('<td class="gj-text-align-center gj-unselectable gj-cursor-pointer" />');
          l.append('<div data-role="display">' + r.icons.collapseGroup + "</div>"), l.on("click", gj.grid.plugins.grouping["private"].createExpandCollapseHandler(r)), s.append(l), s.append('<td colspan="' + d + '"><div data-role="display">' + r.grouping.groupBy + ": " + n[r.grouping.groupBy] + "</div></td>"), s.insertBefore(i), t = n[r.grouping.groupBy];
        }
        i.show();
      }), r.params[r.paramNames.groupBy] = r.grouping.groupBy, r.params[r.paramNames.groupByDirection] = r.grouping.direction;
    },
    grouping: function grouping(e, t) {
      var r = e.data();
      t.sort(gj.grid.methods.createDefaultSorter(r.grouping.direction, r.grouping.groupBy));
    },
    createExpandCollapseHandler: function createExpandCollapseHandler(e) {
      return function (t) {
        var r = $(this),
          a = gj.grid.plugins.grouping["private"];
        "row" === r.closest("tr").next(":visible").data("role") ? a.collapseGroup(e, r) : a.expandGroup(e, r);
      };
    },
    collapseGroup: function collapseGroup(e, t) {
      var r = t.children('div[data-role="display"]');
      t.closest("tr").nextUntil('[role="group"]').hide(), r.empty().append(e.icons.expandGroup);
    },
    expandGroup: function expandGroup(e, t) {
      var r = t.children('div[data-role="display"]');
      t.closest("tr").nextUntil('[role="group"]').show(), r.empty().append(e.icons.collapseGroup);
    }
  },
  "public": {},
  configure: function configure(e) {
    var t,
      r = e.data();
    $.extend(!0, e, gj.grid.plugins.grouping["public"]), r.grouping && r.grouping.groupBy && (t = {
      title: "",
      width: r.defaultIconColumnWidth,
      align: "center",
      stopPropagation: !0,
      cssClass: "gj-cursor-pointer gj-unselectable"
    }, r.columns = [t].concat(r.columns), e.on("initialized", function () {
      gj.grid.plugins.grouping["private"].init(e);
    }), e.on("dataFiltered", function (t, r) {
      gj.grid.plugins.grouping["private"].grouping(e, r);
    }));
  }
}, gj.grid.messages["en-us"] = {
  First: "First",
  Previous: "Previous",
  Next: "Next",
  Last: "Last",
  Page: "Page",
  FirstPageTooltip: "First Page",
  PreviousPageTooltip: "Previous Page",
  NextPageTooltip: "Next Page",
  LastPageTooltip: "Last Page",
  Refresh: "Refresh",
  Of: "of",
  DisplayingRecords: "Displaying records",
  RowsPerPage: "Rows per page:",
  Edit: "Edit",
  Delete: "Delete",
  Update: "Update",
  Cancel: "Cancel",
  NoRecordsFound: "No records found.",
  Loading: "Loading..."
}, gj.tree = {
  plugins: {}
}, gj.tree.config = {
  base: {
    params: {},
    autoLoad: !0,
    selectionType: "single",
    cascadeSelection: !1,
    dataSource: void 0,
    primaryKey: void 0,
    textField: "text",
    childrenField: "children",
    hasChildrenField: "hasChildren",
    imageCssClassField: "imageCssClass",
    imageUrlField: "imageUrl",
    imageHtmlField: "imageHtml",
    disabledField: "disabled",
    width: void 0,
    border: !1,
    uiLibrary: "materialdesign",
    iconsLibrary: "materialicons",
    autoGenId: 1,
    autoGenFieldName: "autoId_b5497cc5-7ef3-49f5-a7dc-4a932e1aee4a",
    indentation: 24,
    style: {
      wrapper: "gj-unselectable",
      list: "gj-list gj-list-md",
      item: void 0,
      active: "gj-list-md-active",
      leafIcon: void 0,
      border: "gj-tree-md-border"
    },
    icons: {
      expand: '<i class="gj-icon chevron-right" />',
      collapse: '<i class="gj-icon chevron-down" />'
    }
  },
  bootstrap: {
    style: {
      wrapper: "gj-unselectable gj-tree-bootstrap-3",
      list: "gj-list gj-list-bootstrap list-group",
      item: "list-group-item",
      active: "active",
      border: "gj-tree-bootstrap-border"
    },
    iconsLibrary: "glyphicons"
  },
  bootstrap4: {
    style: {
      wrapper: "gj-unselectable gj-tree-bootstrap-4",
      list: "gj-list gj-list-bootstrap",
      item: "list-group-item",
      active: "active",
      border: "gj-tree-bootstrap-border"
    },
    icons: {
      expand: '<i class="gj-icon plus" />',
      collapse: '<i class="gj-icon minus" />'
    }
  },
  materialicons: {
    style: {
      expander: "gj-tree-material-icons-expander"
    }
  },
  fontawesome: {
    style: {
      expander: "gj-tree-font-awesome-expander"
    },
    icons: {
      expand: '<i class="fa fa-plus" aria-hidden="true"></i>',
      collapse: '<i class="fa fa-minus" aria-hidden="true"></i>'
    }
  },
  glyphicons: {
    style: {
      expander: "gj-tree-glyphicons-expander"
    },
    icons: {
      expand: '<span class="glyphicon glyphicon-plus" />',
      collapse: '<span class="glyphicon glyphicon-minus" />'
    }
  }
}, gj.tree.events = {
  initialized: function initialized(e) {
    e.triggerHandler("initialized");
  },
  dataBinding: function dataBinding(e) {
    e.triggerHandler("dataBinding");
  },
  dataBound: function dataBound(e) {
    e.triggerHandler("dataBound");
  },
  select: function select(e, t, r) {
    return e.triggerHandler("select", [t, r]);
  },
  unselect: function unselect(e, t, r) {
    return e.triggerHandler("unselect", [t, r]);
  },
  expand: function expand(e, t, r) {
    return e.triggerHandler("expand", [t, r]);
  },
  collapse: function collapse(e, t, r) {
    return e.triggerHandler("collapse", [t, r]);
  },
  enable: function enable(e, t) {
    return e.triggerHandler("enable", [t]);
  },
  disable: function disable(e, t) {
    return e.triggerHandler("disable", [t]);
  },
  destroying: function destroying(e) {
    return e.triggerHandler("destroying");
  },
  nodeDataBound: function nodeDataBound(e, t, r, a) {
    return e.triggerHandler("nodeDataBound", [t, r, a]);
  }
}, gj.tree.methods = {
  init: function init(e) {
    return gj.widget.prototype.init.call(this, e, "tree"), gj.tree.methods.initialize.call(this), this.data("autoLoad") && this.reload(), this;
  },
  initialize: function initialize() {
    var e = this.data(),
      t = $('<ul class="' + e.style.list + '"/>');
    this.empty().addClass(e.style.wrapper).append(t), e.width && this.width(e.width), e.border && this.addClass(e.style.border), gj.tree.events.initialized(this);
  },
  useHtmlDataSource: function useHtmlDataSource(e, t) {
    t.dataSource = [];
  },
  render: function render(e, t) {
    var r;
    return t && ("string" == typeof t && JSON && (t = JSON.parse(t)), (r = e.data()).records = t, r.primaryKey || gj.tree.methods.genAutoId(r, r.records), gj.tree.methods.loadData(e)), e;
  },
  filter: function filter(e) {
    return e.data().dataSource;
  },
  genAutoId: function genAutoId(e, t) {
    var r;
    for (r = 0; r < t.length; r++) {
      t[r][e.autoGenFieldName] = e.autoGenId++, t[r][e.childrenField] && t[r][e.childrenField].length && gj.tree.methods.genAutoId(e, t[r][e.childrenField]);
    }
  },
  loadData: function loadData(e) {
    var t,
      r = e.data("records"),
      a = e.children("ul");
    for (gj.tree.events.dataBinding(e), a.off().empty(), t = 0; t < r.length; t++) {
      gj.tree.methods.appendNode(e, a, r[t], 1);
    }
    gj.tree.events.dataBound(e);
  },
  appendNode: function appendNode(e, t, r, a, i) {
    var o,
      n,
      d,
      s,
      l,
      c = e.data(),
      g = c.primaryKey ? r[c.primaryKey] : r[c.autoGenFieldName];
    if (n = $('<li data-id="' + g + '" data-role="node" />').addClass(c.style.item), $wrapper = $('<div data-role="wrapper" />'), $expander = $('<span data-role="expander" data-mode="close"></span>').addClass(c.style.expander), $display = $('<span data-role="display">' + r[c.textField] + "</span>"), hasChildren = void 0 !== r[c.hasChildrenField] && "true" === r[c.hasChildrenField].toString().toLowerCase(), disabled = void 0 !== r[c.disabledField] && "true" === r[c.disabledField].toString().toLowerCase(), c.indentation && $wrapper.append('<span data-role="spacer" style="width: ' + c.indentation * (a - 1) + 'px;"></span>'), disabled ? gj.tree.methods.disableNode(e, n) : ($expander.on("click", gj.tree.methods.expanderClickHandler(e)), $display.on("click", gj.tree.methods.displayClickHandler(e))), $wrapper.append($expander), $wrapper.append($display), n.append($wrapper), i ? t.find("li:eq(" + (i - 1) + ")").before(n) : t.append(n), c.imageCssClassField && r[c.imageCssClassField] ? (s = $('<span data-role="image"><span class="' + r[c.imageCssClassField] + '"></span></span>')).insertBefore($display) : c.imageUrlField && r[c.imageUrlField] ? ((s = $('<span data-role="image"></span>')).insertBefore($display), (l = $('<img src="' + r[c.imageUrlField] + '"></img>')).attr("width", s.width()).attr("height", s.height()), s.append(l)) : c.imageHtmlField && r[c.imageHtmlField] && (s = $('<span data-role="image">' + r[c.imageHtmlField] + "</span>")).insertBefore($display), r[c.childrenField] && r[c.childrenField].length || hasChildren) {
      if ($expander.empty().append(c.icons.expand), d = $("<ul />").addClass(c.style.list).addClass("gj-hidden"), n.append(d), r[c.childrenField] && r[c.childrenField].length) for (o = 0; o < r[c.childrenField].length; o++) {
        gj.tree.methods.appendNode(e, d, r[c.childrenField][o], a + 1);
      }
    } else c.style.leafIcon ? $expander.addClass(c.style.leafIcon) : $expander.html("&nbsp;");
    gj.tree.events.nodeDataBound(e, n, r.id, r);
  },
  expanderClickHandler: function expanderClickHandler(e) {
    return function (t) {
      var r = $(this),
        a = r.closest("li");
      "close" === r.attr("data-mode") ? e.expand(a) : e.collapse(a);
    };
  },
  expand: function expand(e, t, r) {
    var a,
      i,
      o = t.find('>[data-role="wrapper"]>[data-role="expander"]'),
      n = e.data(),
      d = t.attr("data-id"),
      s = t.children("ul");
    if (!1 !== gj.tree.events.expand(e, t, d) && s && s.length && (s.show(), o.attr("data-mode", "open"), o.empty().append(n.icons.collapse), r)) for (a = t.find("ul>li"), i = 0; i < a.length; i++) {
      gj.tree.methods.expand(e, $(a[i]), r);
    }
    return e;
  },
  collapse: function collapse(e, t, r) {
    var a,
      i,
      o = t.find('>[data-role="wrapper"]>[data-role="expander"]'),
      n = e.data(),
      d = t.attr("data-id"),
      s = t.children("ul");
    if (!1 !== gj.tree.events.collapse(e, t, d) && s && s.length && (s.hide(), o.attr("data-mode", "close"), o.empty().append(n.icons.expand), r)) for (a = t.find("ul>li"), i = 0; i < a.length; i++) {
      gj.tree.methods.collapse(e, $(a[i]), r);
    }
    return e;
  },
  expandAll: function expandAll(e) {
    var t,
      r = e.find("ul>li");
    for (t = 0; t < r.length; t++) {
      gj.tree.methods.expand(e, $(r[t]), !0);
    }
    return e;
  },
  collapseAll: function collapseAll(e) {
    var t,
      r = e.find("ul>li");
    for (t = 0; t < r.length; t++) {
      gj.tree.methods.collapse(e, $(r[t]), !0);
    }
    return e;
  },
  displayClickHandler: function displayClickHandler(e) {
    return function (t) {
      var r = $(this).closest("li"),
        a = e.data().cascadeSelection;
      "true" === r.attr("data-selected") ? gj.tree.methods.unselect(e, r, a) : ("single" === e.data("selectionType") && gj.tree.methods.unselectAll(e), gj.tree.methods.select(e, r, a));
    };
  },
  selectAll: function selectAll(e) {
    var t,
      r = e.find("ul>li");
    for (t = 0; t < r.length; t++) {
      gj.tree.methods.select(e, $(r[t]), !0);
    }
    return e;
  },
  select: function select(e, t, r) {
    var a,
      i,
      o = e.data();
    if ("true" !== t.attr("data-selected") && !1 !== gj.tree.events.select(e, t, t.attr("data-id")) && (t.addClass(o.style.active).attr("data-selected", "true"), r)) for (i = t.find("ul>li"), a = 0; a < i.length; a++) {
      gj.tree.methods.select(e, $(i[a]), r);
    }
  },
  unselectAll: function unselectAll(e) {
    var t,
      r = e.find("ul>li");
    for (t = 0; t < r.length; t++) {
      gj.tree.methods.unselect(e, $(r[t]), !0);
    }
    return e;
  },
  unselect: function unselect(e, t, r) {
    var a, i;
    if (e.data(), "true" === t.attr("data-selected") && !1 !== gj.tree.events.unselect(e, t, t.attr("data-id")) && (t.removeClass(e.data().style.active).removeAttr("data-selected"), r)) for (i = t.find("ul>li"), a = 0; a < i.length; a++) {
      gj.tree.methods.unselect(e, $(i[a]), r);
    }
  },
  getSelections: function getSelections(e) {
    var t,
      r,
      a,
      i = [],
      o = e.children("li");
    if (o && o.length) for (t = 0; t < o.length; t++) {
      "true" === (r = $(o[t])).attr("data-selected") ? i.push(r.attr("data-id")) : r.has("ul") && (a = gj.tree.methods.getSelections(r.children("ul"))).length && (i = i.concat(a));
    }
    return i;
  },
  getDataById: function getDataById(e, t, r) {
    var a,
      i = e.data(),
      o = void 0;
    for (a = 0; a < r.length; a++) {
      if (i.primaryKey && r[a][i.primaryKey] == t) {
        o = r[a];
        break;
      }
      if (r[a][i.autoGenFieldName] == t) {
        o = r[a];
        break;
      }
      if (r[a][i.childrenField] && r[a][i.childrenField].length && (o = gj.tree.methods.getDataById(e, t, r[a][i.childrenField]))) break;
    }
    return o;
  },
  getDataByText: function getDataByText(e, t, r) {
    var a,
      i = void 0,
      o = e.data();
    for (a = 0; a < r.length; a++) {
      if (t === r[a][o.textField]) {
        i = r[a];
        break;
      }
      if (r[a][o.childrenField] && r[a][o.childrenField].length && (i = gj.tree.methods.getDataByText(e, t, r[a][o.childrenField]))) break;
    }
    return i;
  },
  getNodeById: function getNodeById(e, t) {
    var r,
      a,
      i = void 0,
      o = e.children("li");
    if (o && o.length) for (r = 0; r < o.length; r++) {
      if (t == (a = $(o[r])).attr("data-id")) {
        i = a;
        break;
      }
      if (a.has("ul") && (i = gj.tree.methods.getNodeById(a.children("ul"), t))) break;
    }
    return i;
  },
  getNodeByText: function getNodeByText(e, t) {
    var r,
      a,
      i = void 0,
      o = e.children("li");
    if (o && o.length) for (r = 0; r < o.length; r++) {
      if (t === (a = $(o[r])).find('>[data-role="wrapper"]>[data-role="display"]').text()) {
        i = a;
        break;
      }
      if (a.has("ul") && (i = gj.tree.methods.getNodeByText(a.children("ul"), t))) break;
    }
    return i;
  },
  addNode: function addNode(e, t, r, a) {
    var i,
      o,
      n = e.data();
    return r && r.length ? ("li" === r[0].tagName.toLowerCase() && (0 === r.children("ul").length && (r.find('[data-role="expander"]').empty().append(n.icons.collapse), r.append($("<ul />").addClass(n.style.list))), r = r.children("ul")), (o = e.getDataById(r.parent().data("id")))[n.childrenField] || (o[n.childrenField] = []), o[n.childrenField].push(t)) : (r = e.children("ul"), e.data("records").push(t)), i = r.parentsUntil('[data-type="tree"]', "ul").length + 1, n.primaryKey || gj.tree.methods.genAutoId(n, [t]), gj.tree.methods.appendNode(e, r, t, i, a), e;
  },
  remove: function remove(e, t) {
    return gj.tree.methods.removeDataById(e, t.attr("data-id"), e.data("records")), t.remove(), e;
  },
  removeDataById: function removeDataById(e, t, r) {
    var a,
      i = e.data();
    for (a = 0; a < r.length; a++) {
      if (i.primaryKey && r[a][i.primaryKey] == t) {
        r.splice(a, 1);
        break;
      }
      if (r[a][i.autoGenFieldName] == t) {
        r.splice(a, 1);
        break;
      }
      r[a][i.childrenField] && r[a][i.childrenField].length && gj.tree.methods.removeDataById(e, t, r[a][i.childrenField]);
    }
  },
  update: function update(e, t, r) {
    var a = e.data(),
      i = e.getNodeById(t);
    return e.getDataById(t), i.find('>[data-role="wrapper"]>[data-role="display"]').html(r[a.textField]), gj.tree.events.nodeDataBound(e, i, t, r), e;
  },
  getChildren: function getChildren(e, t, r) {
    var a,
      i,
      o = [];
    for (i = (r = void 0 === r || r) ? t.find("ul li") : t.find(">ul>li"), a = 0; a < i.length; a++) {
      o.push($(i[a]).data("id"));
    }
    return o;
  },
  enableAll: function enableAll(e) {
    var t,
      r = e.find("ul>li");
    for (t = 0; t < r.length; t++) {
      gj.tree.methods.enableNode(e, $(r[t]), !0);
    }
    return e;
  },
  enableNode: function enableNode(e, t, r) {
    var a,
      i,
      o = t.find('>[data-role="wrapper"]>[data-role="expander"]'),
      n = t.find('>[data-role="wrapper"]>[data-role="display"]');
    r = void 0 === r || r;
    if (t.removeClass("disabled"), o.on("click", gj.tree.methods.expanderClickHandler(e)), n.on("click", gj.tree.methods.displayClickHandler(e)), gj.tree.events.enable(e, t), r) for (i = t.find("ul>li"), a = 0; a < i.length; a++) {
      gj.tree.methods.enableNode(e, $(i[a]), r);
    }
  },
  disableAll: function disableAll(e) {
    var t,
      r = e.find("ul>li");
    for (t = 0; t < r.length; t++) {
      gj.tree.methods.disableNode(e, $(r[t]), !0);
    }
    return e;
  },
  disableNode: function disableNode(e, t, r) {
    var a,
      i,
      o = t.find('>[data-role="wrapper"]>[data-role="expander"]'),
      n = t.find('>[data-role="wrapper"]>[data-role="display"]');
    r = void 0 === r || r;
    if (t.addClass("disabled"), o.off("click"), n.off("click"), gj.tree.events.disable(e, t), r) for (i = t.find("ul>li"), a = 0; a < i.length; a++) {
      gj.tree.methods.disableNode(e, $(i[a]), r);
    }
  },
  destroy: function destroy(e) {
    return e.data() && (gj.tree.events.destroying(e), e.xhr && e.xhr.abort(), e.off(), e.removeData(), e.removeAttr("data-type"), e.removeClass().empty()), e;
  },
  pathFinder: function pathFinder(e, t, r, a) {
    var i,
      o = !1;
    for (i = 0; i < t.length; i++) {
      if (t[i].id == r) {
        o = !0;
        break;
      }
      if (gj.tree.methods.pathFinder(e, t[i][e.childrenField], r, a)) {
        a.push(t[i].data[e.textField]), o = !0;
        break;
      }
    }
    return o;
  }
}, gj.tree.widget = function (e, t) {
  var r = this,
    a = gj.tree.methods;
  return r.reload = function (e) {
    return gj.widget.prototype.reload.call(this, e);
  }, r.render = function (e) {
    return a.render(this, e);
  }, r.addNode = function (e, t, r) {
    return a.addNode(this, e, t, r);
  }, r.removeNode = function (e) {
    return a.remove(this, e);
  }, r.updateNode = function (e, t) {
    return a.update(this, e, t);
  }, r.destroy = function () {
    return a.destroy(this);
  }, r.expand = function (e, t) {
    return a.expand(this, e, t);
  }, r.collapse = function (e, t) {
    return a.collapse(this, e, t);
  }, r.expandAll = function () {
    return a.expandAll(this);
  }, r.collapseAll = function () {
    return a.collapseAll(this);
  }, r.getDataById = function (e) {
    return a.getDataById(this, e, this.data("records"));
  }, r.getDataByText = function (e) {
    return a.getDataByText(this, e, this.data("records"));
  }, r.getNodeById = function (e) {
    return a.getNodeById(this.children("ul"), e);
  }, r.getNodeByText = function (e) {
    return a.getNodeByText(this.children("ul"), e);
  }, r.getAll = function () {
    return this.data("records");
  }, r.select = function (e) {
    return a.select(this, e);
  }, r.unselect = function (e) {
    return a.unselect(this, e);
  }, r.selectAll = function () {
    return a.selectAll(this);
  }, r.unselectAll = function () {
    return a.unselectAll(this);
  }, r.getSelections = function () {
    return a.getSelections(this.children("ul"));
  }, r.getChildren = function (e, t) {
    return a.getChildren(this, e, t);
  }, r.parents = function (e) {
    var t = [],
      r = this.data();
    return a.pathFinder(r, r.records, e, t), t.reverse();
  }, r.enable = function (e, t) {
    return a.enableNode(this, e, t);
  }, r.enableAll = function () {
    return a.enableAll(this);
  }, r.disable = function (e, t) {
    return a.disableNode(this, e, t);
  }, r.disableAll = function () {
    return a.disableAll(this);
  }, $.extend(e, r), "tree" !== e.attr("data-type") && a.init.call(e, t), e;
}, gj.tree.widget.prototype = new gj.widget(), gj.tree.widget.constructor = gj.tree.widget, jQuery.fn.tree = function (e) {
  var t;
  if (this && this.length) {
    if ("object" != _typeof(e) && e) {
      if ((t = new gj.tree.widget(this, null))[e]) return t[e].apply(this, Array.prototype.slice.call(arguments, 1));
      throw "Method " + e + " does not exist.";
    }
    return new gj.tree.widget(this, e);
  }
}, gj.tree.plugins.checkboxes = {
  config: {
    base: {
      checkboxes: void 0,
      checkedField: "checked",
      cascadeCheck: !0
    }
  },
  "private": {
    dataBound: function dataBound(e) {
      var t;
      e.data("cascadeCheck") && (t = e.find('li[data-role="node"]'), $.each(t, function () {
        var e = $(this),
          t = e.find('[data-role="checkbox"] input[type="checkbox"]').checkbox("state");
        "checked" === t && (gj.tree.plugins.checkboxes["private"].updateChildrenState(e, t), gj.tree.plugins.checkboxes["private"].updateParentState(e, t));
      }));
    },
    nodeDataBound: function nodeDataBound(e, t, r, a) {
      var i, o, n, d, s;
      0 === t.find('> [data-role="wrapper"] > [data-role="checkbox"]').length && (i = e.data(), o = t.find('> [data-role="wrapper"] > [data-role="expander"]'), n = $('<input type="checkbox"/>'), d = $('<span data-role="checkbox"></span>').append(n), s = void 0 !== a[i.disabledField] && "true" === a[i.disabledField].toString().toLowerCase(), n = n.checkbox({
        uiLibrary: i.uiLibrary,
        iconsLibrary: i.iconsLibrary,
        change: function change(r, i) {
          gj.tree.plugins.checkboxes.events.checkboxChange(e, t, a, n.state());
        }
      }), s && n.prop("disabled", !0), a[i.checkedField] && n.state("checked"), n.on("click", function (e) {
        var t = n.closest("li"),
          r = n.state();
        i.cascadeCheck && (gj.tree.plugins.checkboxes["private"].updateChildrenState(t, r), gj.tree.plugins.checkboxes["private"].updateParentState(t, r));
      }), o.after(d));
    },
    updateParentState: function updateParentState(e, t) {
      var r, a, i, o, n, d;
      1 === (r = e.parent("ul").parent("li")).length && (a = e.parent("ul").parent("li").find('> [data-role="wrapper"] > [data-role="checkbox"] input[type="checkbox"]'), i = e.siblings().find('> [data-role="wrapper"] > span[data-role="checkbox"] input[type="checkbox"]'), o = "checked" === t, n = "unchecked" === t, d = "indeterminate", $.each(i, function () {
        var e = $(this).checkbox("state");
        o && "checked" !== e && (o = !1), n && "unchecked" !== e && (n = !1);
      }), o && !n && (d = "checked"), !o && n && (d = "unchecked"), a.checkbox("state", d), gj.tree.plugins.checkboxes["private"].updateParentState(r, a.checkbox("state")));
    },
    updateChildrenState: function updateChildrenState(e, t) {
      var r = e.find('ul li [data-role="wrapper"] [data-role="checkbox"] input[type="checkbox"]');
      r.length > 0 && $.each(r, function () {
        $(this).checkbox("state", t);
      });
    },
    update: function update(e, t, r) {
      var a = t.find('[data-role="checkbox"] input[type="checkbox"]').first();
      $(a).checkbox("state", r), e.data().cascadeCheck && (gj.tree.plugins.checkboxes["private"].updateChildrenState(t, r), gj.tree.plugins.checkboxes["private"].updateParentState(t, r));
    }
  },
  "public": {
    getCheckedNodes: function getCheckedNodes() {
      var e = [],
        t = this.find('li [data-role="checkbox"] input[type="checkbox"]');
      return $.each(t, function () {
        var t = $(this);
        "checked" === t.checkbox("state") && e.push(t.closest("li").data("id"));
      }), e;
    },
    checkAll: function checkAll() {
      var e = this.find('li [data-role="checkbox"] input[type="checkbox"]');
      return $.each(e, function () {
        $(this).checkbox("state", "checked");
      }), this;
    },
    uncheckAll: function uncheckAll() {
      var e = this.find('li [data-role="checkbox"] input[type="checkbox"]');
      return $.each(e, function () {
        $(this).checkbox("state", "unchecked");
      }), this;
    },
    check: function check(e) {
      return gj.tree.plugins.checkboxes["private"].update(this, e, "checked"), this;
    },
    uncheck: function uncheck(e) {
      return gj.tree.plugins.checkboxes["private"].update(this, e, "unchecked"), this;
    }
  },
  events: {
    checkboxChange: function checkboxChange(e, t, r, a) {
      return e.triggerHandler("checkboxChange", [t, r, a]);
    }
  },
  configure: function configure(e) {
    e.data("checkboxes") && gj.checkbox && ($.extend(!0, e, gj.tree.plugins.checkboxes["public"]), e.on("nodeDataBound", function (t, r, a, i) {
      gj.tree.plugins.checkboxes["private"].nodeDataBound(e, r, a, i);
    }), e.on("dataBound", function () {
      gj.tree.plugins.checkboxes["private"].dataBound(e);
    }), e.on("enable", function (e, t) {
      t.find('>[data-role="wrapper"]>[data-role="checkbox"] input[type="checkbox"]').prop("disabled", !1);
    }), e.on("disable", function (e, t) {
      t.find('>[data-role="wrapper"]>[data-role="checkbox"] input[type="checkbox"]').prop("disabled", !0);
    }));
  }
}, gj.tree.plugins.dragAndDrop = {
  config: {
    base: {
      dragAndDrop: void 0,
      style: {
        dragEl: "gj-tree-drag-el gj-tree-md-drag-el",
        dropAsChildIcon: "gj-cursor-pointer gj-icon plus",
        dropAbove: "gj-tree-drop-above",
        dropBelow: "gj-tree-drop-below"
      }
    },
    bootstrap: {
      style: {
        dragEl: "gj-tree-drag-el gj-tree-bootstrap-drag-el",
        dropAsChildIcon: "glyphicon glyphicon-plus",
        dropAbove: "drop-above",
        dropBelow: "drop-below"
      }
    },
    bootstrap4: {
      style: {
        dragEl: "gj-tree-drag-el gj-tree-bootstrap-drag-el",
        dropAsChildIcon: "gj-cursor-pointer gj-icon plus",
        dropAbove: "drop-above",
        dropBelow: "drop-below"
      }
    }
  },
  "private": {
    nodeDataBound: function nodeDataBound(e, t) {
      var r = t.children('[data-role="wrapper"]'),
        a = t.find('>[data-role="wrapper"]>[data-role="display"]');
      r.length && a.length && (a.on("mousedown", gj.tree.plugins.dragAndDrop["private"].createNodeMouseDownHandler(e)), a.on("mousemove", gj.tree.plugins.dragAndDrop["private"].createNodeMouseMoveHandler(e, t, a)), a.on("mouseup", gj.tree.plugins.dragAndDrop["private"].createNodeMouseUpHandler(e)));
    },
    createNodeMouseDownHandler: function createNodeMouseDownHandler(e) {
      return function (t) {
        e.data("dragReady", !0);
      };
    },
    createNodeMouseUpHandler: function createNodeMouseUpHandler(e) {
      return function (t) {
        e.data("dragReady", !1);
      };
    },
    createNodeMouseMoveHandler: function createNodeMouseMoveHandler(e, t, r) {
      return function (a) {
        if (e.data("dragReady")) {
          var i,
            o,
            n,
            d,
            s = e.data();
          e.data("dragReady", !1), i = r.clone().wrap('<div data-role="wrapper"/>').closest("div").wrap('<li class="' + s.style.item + '" />').closest("li").wrap('<ul class="' + s.style.list + '" />').closest("ul"), $("body").append(i), i.attr("data-role", "draggable-clone").addClass("gj-unselectable").addClass(s.style.dragEl), i.find('[data-role="wrapper"]').prepend('<span data-role="indicator" />'), i.draggable({
            drag: gj.tree.plugins.dragAndDrop["private"].createDragHandler(e, t, r),
            stop: gj.tree.plugins.dragAndDrop["private"].createDragStopHandler(e, t, r)
          }), o = r.parent(), n = r.offset().top, n -= parseInt(o.css("border-top-width")) + parseInt(o.css("margin-top")) + parseInt(o.css("padding-top")), d = r.offset().left, d -= parseInt(o.css("border-left-width")) + parseInt(o.css("margin-left")) + parseInt(o.css("padding-left")), d -= i.find('[data-role="indicator"]').outerWidth(!0), i.css({
            position: "absolute",
            top: n,
            left: d,
            width: r.outerWidth(!0)
          }), "true" === r.attr("data-droppable") && r.droppable("destroy"), gj.tree.plugins.dragAndDrop["private"].getTargetDisplays(e, t, r).each(function () {
            var e = $(this);
            "true" === e.attr("data-droppable") && e.droppable("destroy"), e.droppable();
          }), gj.tree.plugins.dragAndDrop["private"].getTargetDisplays(e, t).each(function () {
            var e = $(this);
            "true" === e.attr("data-droppable") && e.droppable("destroy"), e.droppable();
          }), i.trigger("mousedown");
        }
      };
    },
    getTargetDisplays: function getTargetDisplays(e, t, r) {
      return e.find('[data-role="display"]').not(r).not(t.find('[data-role="display"]'));
    },
    getTargetWrappers: function getTargetWrappers(e, t) {
      return e.find('[data-role="wrapper"]').not(t.find('[data-role="wrapper"]'));
    },
    createDragHandler: function createDragHandler(e, t, r) {
      var a = gj.tree.plugins.dragAndDrop["private"].getTargetDisplays(e, t, r),
        i = gj.tree.plugins.dragAndDrop["private"].getTargetWrappers(e, t),
        o = e.data();
      return function (e, t, r) {
        var n = $(this),
          d = !1;
        a.each(function () {
          var e;
          if ($(this).droppable("isOver", r)) return e = n.find('[data-role="indicator"]'), o.style.dropAsChildIcon ? e.addClass(o.style.dropAsChildIcon) : e.text("+"), d = !0, !1;
          n.find('[data-role="indicator"]').removeClass(o.style.dropAsChildIcon).empty();
        }), i.each(function () {
          var e,
            t = $(this);
          !d && t.droppable("isOver", r) ? (e = t.position().top + t.outerHeight() / 2, r.y < e ? t.addClass(o.style.dropAbove).removeClass(o.style.dropBelow) : t.addClass(o.style.dropBelow).removeClass(o.style.dropAbove)) : t.removeClass(o.style.dropAbove).removeClass(o.style.dropBelow);
        });
      };
    },
    createDragStopHandler: function createDragStopHandler(e, t, r) {
      var a = gj.tree.plugins.dragAndDrop["private"].getTargetDisplays(e, t, r),
        i = gj.tree.plugins.dragAndDrop["private"].getTargetWrappers(e, t),
        o = e.data();
      return function (r, n) {
        var d,
          s,
          l,
          c,
          g = !1;
        $(this).draggable("destroy").remove(), a.each(function () {
          var r,
            a = $(this);
          if (a.droppable("isOver", n)) return s = a.closest("li"), l = t.parent("ul").parent("li"), 0 === (r = s.children("ul")).length && (r = $("<ul />").addClass(o.style.list), s.append(r)), !1 !== gj.tree.plugins.dragAndDrop.events.nodeDrop(e, t.data("id"), s.data("id"), r.children("li").length + 1) && (r.append(t), d = e.getDataById(t.data("id")), gj.tree.methods.removeDataById(e, t.data("id"), o.records), void 0 === (c = e.getDataById(r.parent().data("id")))[o.childrenField] && (c[o.childrenField] = []), c[o.childrenField].push(d), gj.tree.plugins.dragAndDrop["private"].refresh(e, t, s, l)), g = !0, !1;
          a.droppable("destroy");
        }), g || i.each(function () {
          var r,
            a,
            i,
            c = $(this);
          if (c.droppable("isOver", n)) return s = c.closest("li"), l = t.parent("ul").parent("li"), r = n.y < c.position().top + c.outerHeight() / 2, i = t.data("id"), a = s.prevAll('li:not([data-id="' + i + '"])').length + (r ? 1 : 2), !1 !== gj.tree.plugins.dragAndDrop.events.nodeDrop(e, i, s.parent("ul").parent("li").data("id"), a) && (d = e.getDataById(t.data("id")), gj.tree.methods.removeDataById(e, t.data("id"), o.records), e.getDataById(s.parent().data("id"))[o.childrenField].splice(s.index() + (r ? 0 : 1), 0, d), r ? t.insertBefore(s) : t.insertAfter(s), gj.tree.plugins.dragAndDrop["private"].refresh(e, t, s, l)), !1;
          c.droppable("destroy");
        });
      };
    },
    refresh: function refresh(e, t, r, a) {
      var i = e.data();
      gj.tree.plugins.dragAndDrop["private"].refreshNode(e, r), gj.tree.plugins.dragAndDrop["private"].refreshNode(e, a), gj.tree.plugins.dragAndDrop["private"].refreshNode(e, t), t.find('li[data-role="node"]').each(function () {
        gj.tree.plugins.dragAndDrop["private"].refreshNode(e, $(this));
      }), r.children('[data-role="wrapper"]').removeClass(i.style.dropAbove).removeClass(i.style.dropBelow);
    },
    refreshNode: function refreshNode(e, t) {
      var r = t.children('[data-role="wrapper"]'),
        a = r.children('[data-role="expander"]'),
        i = r.children('[data-role="spacer"]'),
        o = t.children("ul"),
        n = e.data(),
        d = t.parentsUntil('[data-type="tree"]', "ul").length;
      o.length && o.children().length ? o.is(":visible") ? a.empty().append(n.icons.collapse) : a.empty().append(n.icons.expand) : a.empty(), r.removeClass(n.style.dropAbove).removeClass(n.style.dropBelow), i.css("width", n.indentation * (d - 1));
    }
  },
  "public": {},
  events: {
    nodeDrop: function nodeDrop(e, t, r, a) {
      return e.triggerHandler("nodeDrop", [t, r, a]);
    }
  },
  configure: function configure(e) {
    $.extend(!0, e, gj.tree.plugins.dragAndDrop["public"]), e.data("dragAndDrop") && gj.draggable && gj.droppable && e.on("nodeDataBound", function (t, r) {
      gj.tree.plugins.dragAndDrop["private"].nodeDataBound(e, r);
    });
  }
}, gj.tree.plugins.lazyLoading = {
  config: {
    base: {
      paramNames: {
        parentId: "parentId"
      },
      lazyLoading: !1
    }
  },
  "private": {
    nodeDataBound: function nodeDataBound(e, t, r, a) {
      var i = e.data(),
        o = t.find('> [data-role="wrapper"] > [data-role="expander"]');
      a.hasChildren && o.empty().append(i.icons.expand);
    },
    createDoneHandler: function createDoneHandler(e, t) {
      return function (r) {
        var a,
          i,
          o,
          n = e.data();
        if ("string" == typeof r && JSON && (r = JSON.parse(r)), r && r.length) {
          for (0 === (o = t.children("ul")).length && (o = $("<ul />").addClass(n.style.list), t.append(o)), a = 0; a < r.length; a++) {
            e.addNode(r[a], o);
          }
          (i = t.find('>[data-role="wrapper"]>[data-role="expander"]')).attr("data-mode", "open"), i.empty().append(n.icons.collapse), gj.tree.events.dataBound(e);
        }
      };
    },
    expand: function expand(e, t, r) {
      var a,
        i = e.data(),
        o = {},
        n = t.find(">ul>li");
      n && n.length || "string" == typeof i.dataSource && (o[i.paramNames.parentId] = r, a = {
        url: i.dataSource,
        data: o
      }, e.xhr && e.xhr.abort(), e.xhr = $.ajax(a).done(gj.tree.plugins.lazyLoading["private"].createDoneHandler(e, t)).fail(e.createErrorHandler()));
    }
  },
  "public": {},
  events: {},
  configure: function configure(e, t, r) {
    r.lazyLoading && (e.on("nodeDataBound", function (t, r, a, i) {
      gj.tree.plugins.lazyLoading["private"].nodeDataBound(e, r, a, i);
    }), e.on("expand", function (t, r, a) {
      gj.tree.plugins.lazyLoading["private"].expand(e, r, a);
    }));
  }
}, gj.checkbox = {
  plugins: {}
}, gj.checkbox.config = {
  base: {
    uiLibrary: "materialdesign",
    iconsLibrary: "materialicons",
    style: {
      wrapperCssClass: "gj-checkbox-md",
      spanCssClass: void 0
    }
  },
  bootstrap: {
    style: {
      wrapperCssClass: "gj-checkbox-bootstrap"
    },
    iconsLibrary: "glyphicons"
  },
  bootstrap4: {
    style: {
      wrapperCssClass: "gj-checkbox-bootstrap gj-checkbox-bootstrap-4"
    },
    iconsLibrary: "materialicons"
  },
  materialicons: {
    style: {
      iconsCssClass: "gj-checkbox-material-icons",
      spanCssClass: "gj-icon"
    }
  },
  glyphicons: {
    style: {
      iconsCssClass: "gj-checkbox-glyphicons",
      spanCssClass: ""
    }
  },
  fontawesome: {
    style: {
      iconsCssClass: "gj-checkbox-fontawesome",
      spanCssClass: "fa"
    }
  }
}, gj.checkbox.methods = {
  init: function init(e) {
    var t = this;
    return gj.widget.prototype.init.call(this, e, "checkbox"), t.attr("data-checkbox", "true"), gj.checkbox.methods.initialize(t), t;
  },
  initialize: function initialize(e) {
    var t,
      r,
      a = e.data();
    a.style.wrapperCssClass && (t = $('<label class="' + a.style.wrapperCssClass + " " + a.style.iconsCssClass + '"></label>'), e.attr("id") && t.attr("for", e.attr("id")), e.wrap(t), r = $("<span />"), a.style.spanCssClass && r.addClass(a.style.spanCssClass), e.parent().append(r));
  },
  state: function state(e, t) {
    return t ? ("checked" === t ? (e.prop("indeterminate", !1), e.prop("checked", !0)) : "unchecked" === t ? (e.prop("indeterminate", !1), e.prop("checked", !1)) : "indeterminate" === t && (e.prop("checked", !0), e.prop("indeterminate", !0)), gj.checkbox.events.change(e, t), e) : t = e.prop("indeterminate") ? "indeterminate" : e.prop("checked") ? "checked" : "unchecked";
  },
  toggle: function toggle(e) {
    return "checked" == e.state() ? e.state("unchecked") : e.state("checked"), e;
  },
  destroy: function destroy(e) {
    return "true" === e.attr("data-checkbox") && (e.removeData(), e.removeAttr("data-guid"), e.removeAttr("data-checkbox"), e.off(), e.next("span").remove(), e.unwrap()), e;
  }
}, gj.checkbox.events = {
  change: function change(e, t) {
    return e.triggerHandler("change", [t]);
  }
}, gj.checkbox.widget = function (e, t) {
  var r = this,
    a = gj.checkbox.methods;
  return r.toggle = function () {
    return a.toggle(this);
  }, r.state = function (e) {
    return a.state(this, e);
  }, r.destroy = function () {
    return a.destroy(this);
  }, $.extend(e, r), "true" !== e.attr("data-checkbox") && a.init.call(e, t), e;
}, gj.checkbox.widget.prototype = new gj.widget(), gj.checkbox.widget.constructor = gj.checkbox.widget, jQuery.fn.checkbox = function (e) {
  var t;
  if (this && this.length) {
    if ("object" != _typeof(e) && e) {
      if ((t = new gj.checkbox.widget(this, null))[e]) return t[e].apply(this, Array.prototype.slice.call(arguments, 1));
      throw "Method " + e + " does not exist.";
    }
    return new gj.checkbox.widget(this, e);
  }
}, gj.editor = {
  plugins: {},
  messages: {}
}, gj.editor.config = {
  base: {
    height: 300,
    width: void 0,
    uiLibrary: "materialdesign",
    iconsLibrary: "materialicons",
    locale: "en-us",
    buttons: void 0,
    style: {
      wrapper: "gj-editor gj-editor-md",
      buttonsGroup: "gj-button-md-group",
      button: "gj-button-md",
      buttonActive: "active"
    }
  },
  bootstrap: {
    style: {
      wrapper: "gj-editor gj-editor-bootstrap",
      buttonsGroup: "btn-group",
      button: "btn btn-default gj-cursor-pointer",
      buttonActive: "active"
    }
  },
  bootstrap4: {
    style: {
      wrapper: "gj-editor gj-editor-bootstrap",
      buttonsGroup: "btn-group",
      button: "btn btn-outline-secondary gj-cursor-pointer",
      buttonActive: "active"
    }
  },
  materialicons: {
    icons: {
      bold: '<i class="gj-icon bold" />',
      italic: '<i class="gj-icon italic" />',
      strikethrough: '<i class="gj-icon strikethrough" />',
      underline: '<i class="gj-icon underlined" />',
      listBulleted: '<i class="gj-icon list-bulleted" />',
      listNumbered: '<i class="gj-icon list-numbered" />',
      indentDecrease: '<i class="gj-icon indent-decrease" />',
      indentIncrease: '<i class="gj-icon indent-increase" />',
      alignLeft: '<i class="gj-icon align-left" />',
      alignCenter: '<i class="gj-icon align-center" />',
      alignRight: '<i class="gj-icon align-right" />',
      alignJustify: '<i class="gj-icon align-justify" />',
      undo: '<i class="gj-icon undo" />',
      redo: '<i class="gj-icon redo" />'
    }
  },
  fontawesome: {
    icons: {
      bold: '<i class="fa fa-bold" aria-hidden="true"></i>',
      italic: '<i class="fa fa-italic" aria-hidden="true"></i>',
      strikethrough: '<i class="fa fa-strikethrough" aria-hidden="true"></i>',
      underline: '<i class="fa fa-underline" aria-hidden="true"></i>',
      listBulleted: '<i class="fa fa-list-ul" aria-hidden="true"></i>',
      listNumbered: '<i class="fa fa-list-ol" aria-hidden="true"></i>',
      indentDecrease: '<i class="fa fa-indent" aria-hidden="true"></i>',
      indentIncrease: '<i class="fa fa-outdent" aria-hidden="true"></i>',
      alignLeft: '<i class="fa fa-align-left" aria-hidden="true"></i>',
      alignCenter: '<i class="fa fa-align-center" aria-hidden="true"></i>',
      alignRight: '<i class="fa fa-align-right" aria-hidden="true"></i>',
      alignJustify: '<i class="fa fa-align-justify" aria-hidden="true"></i>',
      undo: '<i class="fa fa-undo" aria-hidden="true"></i>',
      redo: '<i class="fa fa-repeat" aria-hidden="true"></i>'
    }
  }
}, gj.editor.methods = {
  init: function init(e) {
    return gj.widget.prototype.init.call(this, e, "editor"), this.attr("data-editor", "true"), gj.editor.methods.initialize(this), this;
  },
  initialize: function initialize(e) {
    var t,
      r,
      a,
      i,
      o,
      n = this,
      d = e.data();
    if (e.hide(), "wrapper" !== e[0].parentElement.attributes.role && ((a = document.createElement("div")).setAttribute("role", "wrapper"), e[0].parentNode.insertBefore(a, e[0]), a.appendChild(e[0])), gj.editor.methods.localization(d), $(a).addClass(d.style.wrapper), d.width && $(a).width(d.width), 0 === (i = $(a).children('div[role="body"]')).length && (i = $('<div role="body"></div>'), $(a).append(i), e[0].innerText && (i[0].innerHTML = e[0].innerText)), i.attr("contenteditable", !0), i.on("keydown", function (t) {
      var r = event.keyCode || event.charCode;
      !1 === gj.editor.events.changing(e) && 8 !== r && 46 !== r && t.preventDefault();
    }), i.on("mouseup keyup mouseout cut paste", function (t) {
      n.updateToolbar(e, o), gj.editor.events.changed(e), e.html(i.html());
    }), 0 === (o = $(a).children('div[role="toolbar"]')).length) for (var s in o = $('<div role="toolbar"></div>'), i.before(o), d.buttons) {
      for (var l in t = $("<div />").addClass(d.style.buttonsGroup), d.buttons[s]) {
        (r = $(d.buttons[s][l])).on("click", function () {
          gj.editor.methods.executeCmd(e, i, o, $(this));
        }), t.append(r);
      }
      o.append(t);
    }
    i.height(d.height - gj.core.height(o[0], !0));
  },
  localization: function localization(e) {
    var t = gj.editor.messages[e.locale];
    void 0 === e.buttons && (e.buttons = [['<button type="button" class="' + e.style.button + '" title="' + t.bold + '" role="bold">' + e.icons.bold + "</button>", '<button type="button" class="' + e.style.button + '" title="' + t.italic + '" role="italic">' + e.icons.italic + "</button>", '<button type="button" class="' + e.style.button + '" title="' + t.strikethrough + '" role="strikethrough">' + e.icons.strikethrough + "</button>", '<button type="button" class="' + e.style.button + '" title="' + t.underline + '" role="underline">' + e.icons.underline + "</button>"], ['<button type="button" class="' + e.style.button + '" title="' + t.listBulleted + '" role="insertunorderedlist">' + e.icons.listBulleted + "</button>", '<button type="button" class="' + e.style.button + '" title="' + t.listNumbered + '" role="insertorderedlist">' + e.icons.listNumbered + "</button>", '<button type="button" class="' + e.style.button + '" title="' + t.indentDecrease + '" role="outdent">' + e.icons.indentDecrease + "</button>", '<button type="button" class="' + e.style.button + '" title="' + t.indentIncrease + '" role="indent">' + e.icons.indentIncrease + "</button>"], ['<button type="button" class="' + e.style.button + '" title="' + t.alignLeft + '" role="justifyleft">' + e.icons.alignLeft + "</button>", '<button type="button" class="' + e.style.button + '" title="' + t.alignCenter + '" role="justifycenter">' + e.icons.alignCenter + "</button>", '<button type="button" class="' + e.style.button + '" title="' + t.alignRight + '" role="justifyright">' + e.icons.alignRight + "</button>", '<button type="button" class="' + e.style.button + '" title="' + t.alignJustify + '" role="justifyfull">' + e.icons.alignJustify + "</button>"], ['<button type="button" class="' + e.style.button + '" title="' + t.undo + '" role="undo">' + e.icons.undo + "</button>", '<button type="button" class="' + e.style.button + '" title="' + t.redo + '" role="redo">' + e.icons.redo + "</button>"]]);
  },
  updateToolbar: function updateToolbar(e, t) {
    var r = e.data();
    $buttons = t.find("[role]").each(function () {
      var e = $(this),
        t = e.attr("role");
      t && document.queryCommandEnabled(t) && "true" === document.queryCommandValue(t) ? e.addClass(r.style.buttonActive) : e.removeClass(r.style.buttonActive);
    });
  },
  executeCmd: function executeCmd(e, t, r, a) {
    t.focus(), document.execCommand(a.attr("role"), !1), gj.editor.methods.updateToolbar(e, r);
  },
  content: function content(e, t) {
    var r = e.parent().children('div[role="body"]');
    return void 0 === t ? r.html() : r.html(t);
  },
  destroy: function destroy(e) {
    var t;
    return "true" === e.attr("data-editor") && ((t = e.parent()).children('div[role="body"]').remove(), t.children('div[role="toolbar"]').remove(), e.unwrap(), e.removeData(), e.removeAttr("data-guid"), e.removeAttr("data-editor"), e.off(), e.show()), e;
  }
}, gj.editor.events = {
  changing: function changing(e) {
    return e.triggerHandler("changing");
  },
  changed: function changed(e) {
    return e.triggerHandler("changed");
  }
}, gj.editor.widget = function (e, t) {
  var r = this,
    a = gj.editor.methods;
  return r.content = function (e) {
    return a.content(this, e);
  }, r.destroy = function () {
    return a.destroy(this);
  }, $.extend(e, r), "true" !== e.attr("data-editor") && a.init.call(e, t), e;
}, gj.editor.widget.prototype = new gj.widget(), gj.editor.widget.constructor = gj.editor.widget, jQuery.fn.editor = function (e) {
  var t;
  if (this && this.length) {
    if ("object" != _typeof(e) && e) {
      if ((t = new gj.editor.widget(this, null))[e]) return t[e].apply(this, Array.prototype.slice.call(arguments, 1));
      throw "Method " + e + " does not exist.";
    }
    return new gj.editor.widget(this, e);
  }
}, gj.editor.messages["en-us"] = {
  bold: "Bold",
  italic: "Italic",
  strikethrough: "Strikethrough",
  underline: "Underline",
  listBulleted: "List Bulleted",
  listNumbered: "List Numbered",
  indentDecrease: "Indent Decrease",
  indentIncrease: "Indent Increase",
  alignLeft: "Align Left",
  alignCenter: "Align Center",
  alignRight: "Align Right",
  alignJustify: "Align Justify",
  undo: "Undo",
  redo: "Redo"
}, gj.dropdown = {
  plugins: {}
}, gj.dropdown.config = {
  base: {
    dataSource: void 0,
    textField: "text",
    valueField: "value",
    selectedField: "selected",
    width: void 0,
    maxHeight: "auto",
    placeholder: void 0,
    fontSize: void 0,
    uiLibrary: "materialdesign",
    iconsLibrary: "materialicons",
    icons: {
      dropdown: '<i class="gj-icon arrow-dropdown" />',
      dropup: '<i class="gj-icon arrow-dropup" />'
    },
    style: {
      wrapper: "gj-dropdown gj-dropdown-md gj-unselectable",
      list: "gj-list gj-list-md gj-dropdown-list-md",
      active: "gj-list-md-active"
    }
  },
  bootstrap: {
    style: {
      wrapper: "gj-dropdown gj-dropdown-bootstrap gj-dropdown-bootstrap-3 gj-unselectable",
      presenter: "btn btn-default",
      list: "gj-list gj-list-bootstrap gj-dropdown-list-bootstrap list-group",
      item: "list-group-item",
      active: "active"
    },
    iconsLibrary: "glyphicons"
  },
  bootstrap4: {
    style: {
      wrapper: "gj-dropdown gj-dropdown-bootstrap gj-dropdown-bootstrap-4 gj-unselectable",
      presenter: "btn btn-outline-secondary",
      list: "gj-list gj-list-bootstrap gj-dropdown-list-bootstrap list-group",
      item: "list-group-item",
      active: "active"
    }
  },
  materialicons: {
    style: {
      expander: "gj-dropdown-expander-mi"
    }
  },
  fontawesome: {
    icons: {
      dropdown: '<i class="fa fa-caret-down" aria-hidden="true"></i>',
      dropup: '<i class="fa fa-caret-up" aria-hidden="true"></i>'
    },
    style: {
      expander: "gj-dropdown-expander-fa"
    }
  },
  glyphicons: {
    icons: {
      dropdown: '<span class="caret"></span>',
      dropup: '<span class="dropup"><span class="caret" ></span></span>'
    },
    style: {
      expander: "gj-dropdown-expander-glyphicons"
    }
  }
}, gj.dropdown.methods = {
  init: function init(e) {
    return gj.widget.prototype.init.call(this, e, "dropdown"), this.attr("data-dropdown", "true"), gj.dropdown.methods.initialize(this), this;
  },
  getHTMLConfig: function getHTMLConfig() {
    var e = gj.widget.prototype.getHTMLConfig.call(this),
      t = this[0].attributes;
    return t.placeholder && (e.placeholder = t.placeholder.value), e;
  },
  initialize: function initialize(e) {
    var t = e.data(),
      r = e.parent('div[role="wrapper"]'),
      a = $('<span role="display"></span>'),
      i = $('<span role="expander">' + t.icons.dropdown + "</span>").addClass(t.style.expander),
      o = $('<button role="presenter" type="button"></button>').addClass(t.style.presenter),
      n = $('<ul role="list" class="' + t.style.list + '"></ul>').attr("guid", e.attr("data-guid"));
    0 === r.length ? (r = $('<div role="wrapper" />').addClass(t.style.wrapper), e.wrap(r)) : r.addClass(t.style.wrapper), t.fontSize && o.css("font-size", t.fontSize), o.on("click", function (t) {
      n.is(":visible") ? gj.dropdown.methods.close(e, n) : gj.dropdown.methods.open(e, n);
    }), o.on("blur", function (t) {
      setTimeout(function () {
        gj.dropdown.methods.close(e, n);
      }, 500);
    }), o.append(a).append(i), e.hide(), e.after(o), $("body").append(n), n.hide(), e.reload();
  },
  setListPosition: function setListPosition(e, t, r) {
    var a,
      i,
      o,
      n,
      d = e.getBoundingClientRect(),
      s = window.scrollY || window.pageYOffset || 0;
    window.scrollX || window.pageXOffset, t.style.overflow = "", t.style.overflowX = "", t.style.height = "", gj.core.setChildPosition(e, t), a = gj.core.height(t, !0), n = t.getBoundingClientRect(), i = gj.core.height(e, !0), "auto" === r.maxHeight ? d.top < n.top ? d.top + a + i > window.innerHeight && (o = window.innerHeight - d.top - i - 3) : d.top - a - 3 > 0 ? t.style.top = Math.round(d.top + s - a - 3) + "px" : (t.style.top = s + "px", o = d.top - 3) : !isNaN(r.maxHeight) && r.maxHeight < a && (o = r.maxHeight), o && (t.style.overflow = "scroll", t.style.overflowX = "hidden", t.style.height = o + "px");
  },
  useHtmlDataSource: function useHtmlDataSource(e, t) {
    var r,
      a,
      i = [],
      o = e.find("option");
    for (r = 0; r < o.length; r++) {
      (a = {})[t.valueField] = o[r].value, a[t.textField] = o[r].innerHTML, a[t.selectedField] = e[0].value === o[r].value, i.push(a);
    }
    t.dataSource = i;
  },
  filter: function filter(e) {
    var t,
      r,
      a = e.data();
    if (a.dataSource) {
      if ("string" == typeof a.dataSource[0]) for (t = 0; t < a.dataSource.length; t++) {
        (r = {})[a.valueField] = a.dataSource[t], r[a.textField] = a.dataSource[t], a.dataSource[t] = r;
      }
    } else a.dataSource = [];
    return a.dataSource;
  },
  render: function render(e, t) {
    var r = [],
      a = e.data(),
      o = e.parent(),
      n = $("body").children('[role="list"][guid="' + e.attr("data-guid") + '"]'),
      d = o.children('[role="presenter"]'),
      s = (d.children('[role="expander"]'), d.children('[role="display"]'));
    if (e.data("records", t), e.empty(), n.empty(), t && t.length) if ($.each(t, function () {
      var t,
        i = this[a.valueField],
        o = this[a.textField],
        d = this[a.selectedField] && "true" === this[a.selectedField].toString().toLowerCase();
      (t = $('<li value="' + i + '"><div data-role="wrapper"><span data-role="display">' + o + "</span></div></li>")).addClass(a.style.item), t.on("click", function (t) {
        gj.dropdown.methods.select(e, i);
      }), n.append(t), e.append('<option value="' + i + '">' + o + "</option>"), d && r.push(i);
    }), 0 === r.length) e.prepend('<option value=""></option>'), e[0].selectedIndex = 0, a.placeholder && (s[0].innerHTML = '<span class="placeholder">' + a.placeholder + "</span>");else for (i = 0; i < r.length; i++) {
      gj.dropdown.methods.select(e, r[i]);
    }
    return a.width && (o.css("width", a.width), d.css("width", a.width)), a.fontSize && n.children("li").css("font-size", a.fontSize), gj.dropdown.events.dataBound(e), e;
  },
  open: function open(e, t) {
    var r = e.data(),
      a = e.parent().find('[role="expander"]'),
      i = e.parent().find('[role="presenter"]'),
      o = gj.core.getScrollParent(e[0]);
    t.css("width", gj.core.width(i[0])), t.show(), gj.dropdown.methods.setListPosition(i[0], t[0], r), a.html(r.icons.dropup), o && (r.parentScrollHandler = function () {
      gj.dropdown.methods.setListPosition(i[0], t[0], r);
    }, gj.dropdown.methods.addParentsScrollListener(o, r.parentScrollHandler));
  },
  close: function close(e, t) {
    var r = e.data(),
      a = e.parent().find('[role="expander"]'),
      i = gj.core.getScrollParent(e[0]);
    a.html(r.icons.dropdown), i && r.parentScrollHandler && gj.dropdown.methods.removeParentsScrollListener(i, r.parentScrollHandler), t.hide();
  },
  addParentsScrollListener: function addParentsScrollListener(e, t) {
    var r = gj.core.getScrollParent(e.parentNode);
    e.addEventListener("scroll", t), r && gj.dropdown.methods.addParentsScrollListener(r, t);
  },
  removeParentsScrollListener: function removeParentsScrollListener(e, t) {
    var r = gj.core.getScrollParent(e.parentNode);
    e.removeEventListener("scroll", t), r && gj.dropdown.methods.removeParentsScrollListener(r, t);
  },
  select: function select(e, t) {
    var r = e.data(),
      a = $("body").children('[role="list"][guid="' + e.attr("data-guid") + '"]'),
      i = a.children('li[value="' + t + '"]'),
      o = e.next('[role="presenter"]').find('[role="display"]'),
      n = gj.dropdown.methods.getRecordByValue(e, t);
    return a.children("li").removeClass(r.style.active), n ? (i.addClass(r.style.active), e[0].value = t, o[0].innerHTML = n[r.textField]) : (r.placeholder && (o[0].innerHTML = '<span class="placeholder">' + r.placeholder + "</span>"), e[0].value = ""), gj.dropdown.events.change(e), gj.dropdown.methods.close(e, a), e;
  },
  getRecordByValue: function getRecordByValue(e, t) {
    var r,
      a = e.data(),
      i = void 0;
    for (r = 0; r < a.records.length; r++) {
      if (a.records[r][a.valueField] === t) {
        i = a.records[r];
        break;
      }
    }
    return i;
  },
  value: function value(e, t) {
    return void 0 === t ? e.val() : (gj.dropdown.methods.select(e, t), e);
  },
  destroy: function destroy(e) {
    var t = e.data(),
      r = e.parent('div[role="wrapper"]');
    return t && (e.xhr && e.xhr.abort(), e.off(), e.removeData(), e.removeAttr("data-type").removeAttr("data-guid").removeAttr("data-dropdown"), e.removeClass(), r.length > 0 && (r.children('[role="presenter"]').remove(), r.children('[role="list"]').remove(), e.unwrap()), e.show()), e;
  }
}, gj.dropdown.events = {
  change: function change(e) {
    return e.triggerHandler("change");
  },
  dataBound: function dataBound(e) {
    return e.triggerHandler("dataBound");
  }
}, gj.dropdown.widget = function (e, t) {
  var r = this,
    a = gj.dropdown.methods;
  return r.value = function (e) {
    return a.value(this, e);
  }, r.enable = function () {
    return a.enable(this);
  }, r.disable = function () {
    return a.disable(this);
  }, r.destroy = function () {
    return a.destroy(this);
  }, $.extend(e, r), "true" !== e.attr("data-dropdown") && a.init.call(e, t), e;
}, gj.dropdown.widget.prototype = new gj.widget(), gj.dropdown.widget.constructor = gj.dropdown.widget, gj.dropdown.widget.prototype.getHTMLConfig = gj.dropdown.methods.getHTMLConfig, jQuery.fn.dropdown = function (e) {
  var t;
  if (this && this.length) {
    if ("object" != _typeof(e) && e) {
      if ((t = new gj.dropdown.widget(this, null))[e]) return t[e].apply(this, Array.prototype.slice.call(arguments, 1));
      throw "Method " + e + " does not exist.";
    }
    return new gj.dropdown.widget(this, e);
  }
}, gj.datepicker = {
  plugins: {}
}, gj.datepicker.config = {
  base: {
    showOtherMonths: !1,
    selectOtherMonths: !0,
    width: void 0,
    minDate: void 0,
    maxDate: void 0,
    format: "mm/dd/yyyy",
    uiLibrary: "materialdesign",
    iconsLibrary: "materialicons",
    value: void 0,
    weekStartDay: 0,
    disableDates: void 0,
    disableDaysOfWeek: void 0,
    calendarWeeks: !1,
    keyboardNavigation: !0,
    locale: "en-us",
    icons: {
      rightIcon: '<i class="ti-calendar"></i>',
      previousMonth: '<i class="ti-angle-left"></i>',
      nextMonth: '<i class="ti-angle-right"></i>'
    },
    fontSize: void 0,
    size: "default",
    modal: !1,
    header: !1,
    footer: !1,
    showOnFocus: !0,
    showRightIcon: !0,
    style: {
      modal: "gj-modal",
      wrapper: "gj-datepicker gj-datepicker-md gj-unselectable",
      input: "gj-textbox-md",
      calendar: "gj-picker gj-picker-md datepicker gj-unselectable",
      footer: "",
      button: "gj-button-md"
    }
  },
  bootstrap: {
    style: {
      wrapper: "gj-datepicker gj-datepicker-bootstrap gj-unselectable input-group",
      input: "form-control",
      calendar: "gj-picker gj-picker-bootstrap datepicker gj-unselectable",
      footer: "modal-footer",
      button: "btn btn-default"
    },
    iconsLibrary: "glyphicons",
    showOtherMonths: !0
  },
  bootstrap4: {
    style: {
      wrapper: "gj-datepicker gj-datepicker-bootstrap gj-unselectable input-group",
      input: "form-control",
      calendar: "gj-picker gj-picker-bootstrap datepicker gj-unselectable",
      footer: "modal-footer",
      button: "btn btn-default"
    },
    showOtherMonths: !0
  },
  fontawesome: {
    icons: {
      rightIcon: '<i class="fa fa-calendar" aria-hidden="true"></i>',
      previousMonth: '<i class="fa fa-chevron-left" aria-hidden="true"></i>',
      nextMonth: '<i class="fa fa-chevron-right" aria-hidden="true"></i>'
    }
  },
  glyphicons: {
    icons: {
      rightIcon: '<span class="glyphicon glyphicon-calendar"></span>',
      previousMonth: '<span class="glyphicon glyphicon-chevron-left"></span>',
      nextMonth: '<span class="glyphicon glyphicon-chevron-right"></span>'
    }
  }
}, gj.datepicker.methods = {
  init: function init(e) {
    return gj.widget.prototype.init.call(this, e, "datepicker"), this.attr("data-datepicker", "true"), gj.datepicker.methods.initialize(this, this.data()), this;
  },
  initialize: function initialize(e, t) {
    var r,
      a,
      i = e.parent('div[role="wrapper"]');
    0 === i.length ? (i = $('<div role="wrapper" />').addClass(t.style.wrapper), e.wrap(i)) : i.addClass(t.style.wrapper), i = e.parent('div[role="wrapper"]'), t.width && i.css("width", t.width), e.val(t.value).addClass(t.style.input).attr("role", "input"), t.fontSize && e.css("font-size", t.fontSize), "bootstrap" === t.uiLibrary || "bootstrap4" === t.uiLibrary ? "small" === t.size ? (i.addClass("input-group-sm"), e.addClass("form-control-sm")) : "large" === t.size && (i.addClass("input-group-lg"), e.addClass("form-control-lg")) : "small" === t.size ? i.addClass("small") : "large" === t.size && i.addClass("large"), t.showRightIcon && ((a = "bootstrap" === t.uiLibrary ? $('<span class="input-group-addon">' + t.icons.rightIcon + "</span>") : "bootstrap4" === t.uiLibrary ? $('<span class="input-group-append"><button class="btn btn-outline-secondary border-left-0" type="button">' + t.icons.rightIcon + "</button></span>") : $(t.icons.rightIcon)).attr("role", "right-icon"), a.on("click", function (r) {
      $("body").find('[role="calendar"][guid="' + e.attr("data-guid") + '"]').is(":visible") ? gj.datepicker.methods.close(e) : gj.datepicker.methods.open(e, t);
    }), i.append(a)), t.showOnFocus && e.on("focus", function () {
      gj.datepicker.methods.open(e, t);
    }), r = gj.datepicker.methods.createCalendar(e, t), !0 !== t.footer && (e.on("blur", function () {
      e.timeout = setTimeout(function () {
        gj.datepicker.methods.close(e);
      }, 500);
    }), r.mousedown(function () {
      return clearTimeout(e.timeout), document.activeElement !== e[0] && e.focus(), !1;
    }), r.on("click", function () {
      clearTimeout(e.timeout), document.activeElement !== e[0] && e.focus();
    })), t.keyboardNavigation && $(document).on("keydown", gj.datepicker.methods.createKeyDownHandler(e, r, t));
  },
  createCalendar: function createCalendar(e, t) {
    var r,
      a,
      i,
      o,
      n,
      d = $('<div role="calendar" type="month"/>').addClass(t.style.calendar).attr("guid", e.attr("data-guid"));
    return t.fontSize && d.css("font-size", t.fontSize), !(r = gj.core.parseDate(t.value, t.format, t.locale)) || isNaN(r.getTime()) ? r = new Date() : e.attr("day", r.getFullYear() + "-" + r.getMonth() + "-" + r.getDate()), d.attr("month", r.getMonth()), d.attr("year", r.getFullYear()), gj.datepicker.methods.renderHeader(e, d, t, r), a = $('<div role="body" />'), d.append(a), t.footer && (i = $('<div role="footer" class="' + t.style.footer + '" />'), (o = $('<button class="' + t.style.button + '">' + gj.core.messages[t.locale].cancel + "</button>")).on("click", function () {
      e.close();
    }), i.append(o), (n = $('<button class="' + t.style.button + '">' + gj.core.messages[t.locale].ok + "</button>")).on("click", function () {
      var r,
        a,
        i = d.attr("selectedDay");
      i ? (a = i.split("-"), r = new Date(a[0], a[1], a[2], d.attr("hour") || 0, d.attr("minute") || 0), gj.datepicker.methods.change(e, d, t, r)) : e.close();
    }), i.append(n), d.append(i)), d.hide(), $("body").append(d), t.modal && (d.wrapAll('<div role="modal" class="' + t.style.modal + '"/>'), gj.core.center(d)), d;
  },
  renderHeader: function renderHeader(e, t, r, a) {
    var i, o, n;
    r.header && (i = $('<div role="header" />'), (n = $('<div role="year" />').on("click", function () {
      gj.datepicker.methods.renderDecade(e, t, r), n.addClass("selected"), o.removeClass("selected");
    })).html(gj.core.formatDate(a, "yyyy", r.locale)), i.append(n), (o = $('<div role="date" class="selected" />').on("click", function () {
      gj.datepicker.methods.renderMonth(e, t, r), o.addClass("selected"), n.removeClass("selected");
    })).html(gj.core.formatDate(a, "ddd, mmm dd", r.locale)), i.append(o), t.append(i));
  },
  updateHeader: function updateHeader(e, t, r) {
    e.find('[role="header"] [role="year"]').removeClass("selected").html(gj.core.formatDate(r, "yyyy", t.locale)), e.find('[role="header"] [role="date"]').addClass("selected").html(gj.core.formatDate(r, "ddd, mmm dd", t.locale)), e.find('[role="header"] [role="hour"]').removeClass("selected").html(gj.core.formatDate(r, "HH", t.locale)), e.find('[role="header"] [role="minute"]').removeClass("selected").html(gj.core.formatDate(r, "MM", t.locale));
  },
  createNavigation: function createNavigation(e, t, r, a) {
    var o,
      n,
      d = $("<thead/>");
    for ((n = $('<div role="navigator" />')).append($("<div>" + a.icons.previousMonth + "</div>").on("click", gj.datepicker.methods.prev(e, a))), n.append($('<div role="period"></div>').on("click", gj.datepicker.methods.changePeriod(e, a))), n.append($("<div>" + a.icons.nextMonth + "</div>").on("click", gj.datepicker.methods.next(e, a))), t.append(n), o = $('<tr role="week-days" />'), a.calendarWeeks && o.append("<th><div>&nbsp;</div></th>"), i = a.weekStartDay; i < gj.core.messages[a.locale].weekDaysMin.length; i++) {
      o.append("<th><div>" + gj.core.messages[a.locale].weekDaysMin[i] + "</div></th>");
    }
    for (i = 0; i < a.weekStartDay; i++) {
      o.append("<th><div>" + gj.core.messages[a.locale].weekDaysMin[i] + "</div></th>");
    }
    d.append(o), r.append(d);
  },
  renderMonth: function renderMonth(e, t, r) {
    var a,
      i,
      o,
      n,
      d,
      s,
      l,
      c,
      g,
      p,
      u,
      h,
      f,
      m,
      v,
      b = t.children('[role="body"]'),
      y = $("<table/>"),
      j = $("<tbody/>"),
      w = gj.core.messages[r.locale].titleFormat;
    for (b.off().empty(), gj.datepicker.methods.createNavigation(e, b, y, r), n = parseInt(t.attr("month"), 10), d = parseInt(t.attr("year"), 10), t.attr("type", "month"), w = w.replace("mmmm", gj.core.messages[r.locale].monthNames[n]).replace("yyyy", d), t.find('div[role="period"]').text(w), s = new Array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31), d % 4 == 0 && 1900 != d && (s[1] = 29), l = s[n], c = (new Date(d, n, 1).getDay() + 7 - r.weekStartDay) % 7, a = 0, $row = $("<tr />"), u = gj.datepicker.methods.getPrevMonth(n, d), g = 1; g <= c; g++) {
      o = s[u.month] - c + g, v = new Date(u.year, u.month, o), r.calendarWeeks && 1 === g && $row.append('<td class="calendar-week"><div>' + gj.datepicker.methods.getWeekNumber(v) + "</div></td>"), f = $('<td class="other-month" />'), r.showOtherMonths && (m = $("<div>" + o + "</div>"), f.append(m), r.selectOtherMonths && gj.datepicker.methods.isSelectable(r, v) ? (f.addClass("gj-cursor-pointer").attr("day", o).attr("month", u.month).attr("year", u.year), m.on("click", gj.datepicker.methods.dayClickHandler(e, t, r, v)), m.on("mousedown", function (e) {
        e.stopPropagation();
      })) : f.addClass("disabled")), $row.append(f), a++;
    }
    for (g > 1 && j.append($row), p = new Date(), g = 1; g <= l; g++) {
      v = new Date(d, n, g), 0 == a && ($row = $("<tr>"), r.calendarWeeks && $row.append('<td class="calendar-week"><div>' + gj.datepicker.methods.getWeekNumber(v) + "</div></td>")), f = $('<td day="' + g + '" month="' + n + '" year="' + d + '" />'), d === p.getFullYear() && n === p.getMonth() && g === p.getDate() ? f.addClass("today") : f.addClass("current-month"), m = $("<div>" + g + "</div>"), gj.datepicker.methods.isSelectable(r, v) ? (f.addClass("gj-cursor-pointer"), m.on("click", gj.datepicker.methods.dayClickHandler(e, t, r, v)), m.on("mousedown", function (e) {
        e.stopPropagation();
      })) : f.addClass("disabled"), f.append(m), $row.append(f), 7 == ++a && (j.append($row), a = 0);
    }
    for (h = gj.datepicker.methods.getNextMonth(n, d), g = 1; 0 != a; g++) {
      v = new Date(h.year, h.month, g), f = $('<td class="other-month" />'), r.showOtherMonths && (m = $("<div>" + g + "</div>"), r.selectOtherMonths && gj.datepicker.methods.isSelectable(r, v) ? (f.addClass("gj-cursor-pointer").attr("day", g).attr("month", h.month).attr("year", h.year), m.on("click", gj.datepicker.methods.dayClickHandler(e, t, r, v)), m.on("mousedown", function (e) {
        e.stopPropagation();
      })) : f.addClass("disabled"), f.append(m)), $row.append(f), 7 == ++a && (j.append($row), a = 0);
    }
    y.append(j), b.append(y), t.attr("selectedDay") && (i = t.attr("selectedDay").split("-"), v = new Date(i[0], i[1], i[2], t.attr("hour") || 0, t.attr("minute") || 0), t.find('tbody td[day="' + i[2] + '"][month="' + i[1] + '"]').addClass("selected"), gj.datepicker.methods.updateHeader(t, r, v));
  },
  renderYear: function renderYear(e, t, r) {
    var a,
      i,
      o,
      n,
      d = t.find('>[role="body"]>table'),
      s = d.children("tbody");
    for (d.children("thead").hide(), a = parseInt(t.attr("year"), 10), t.attr("type", "year"), t.find('div[role="period"]').text(a), s.empty(), i = 0; i < 3; i++) {
      for ($row = $("<tr />"), o = 4 * i; o <= 4 * i + 3; o++) {
        (n = $("<div>" + gj.core.messages[r.locale].monthShortNames[o] + "</div>")).on("click", gj.datepicker.methods.selectMonth(e, t, r, o)), $cell = $("<td></td>").append(n), $row.append($cell);
      }
      s.append($row);
    }
  },
  renderDecade: function renderDecade(e, t, r) {
    var a,
      i,
      o,
      n,
      d,
      s = t.find('>[role="body"]>table'),
      l = s.children("tbody");
    for (s.children("thead").hide(), i = (a = parseInt(t.attr("year"), 10)) - a % 10, t.attr("type", "decade"), t.find('div[role="period"]').text(i + " - " + (i + 9)), l.empty(), o = i - 1; o <= i + 10; o += 4) {
      for ($row = $("<tr />"), n = o; n <= o + 3; n++) {
        (d = $("<div>" + n + "</div>")).on("click", gj.datepicker.methods.selectYear(e, t, r, n)), $cell = $("<td></td>").append(d), $row.append($cell);
      }
      l.append($row);
    }
  },
  renderCentury: function renderCentury(e, t, r) {
    var a,
      i,
      o,
      n,
      d,
      s = t.find('>[role="body"]>table'),
      l = s.children("tbody");
    for (s.children("thead").hide(), i = (a = parseInt(t.attr("year"), 10)) - a % 100, t.attr("type", "century"), t.find('div[role="period"]').text(i + " - " + (i + 99)), l.empty(), o = i - 10; o < i + 100; o += 40) {
      for ($row = $("<tr />"), n = o; n <= o + 30; n += 10) {
        (d = $("<div>" + n + "</div>")).on("click", gj.datepicker.methods.selectDecade(e, t, r, n)), $cell = $("<td></td>").append(d), $row.append($cell);
      }
      l.append($row);
    }
  },
  getWeekNumber: function getWeekNumber(e) {
    var t = new Date(e.valueOf());
    t.setDate(t.getDate() + 6), (t = new Date(Date.UTC(t.getFullYear(), t.getMonth(), t.getDate()))).setUTCDate(t.getUTCDate() + 4 - (t.getUTCDay() || 7));
    var r = new Date(Date.UTC(t.getUTCFullYear(), 0, 1));
    return Math.ceil(((t - r) / 864e5 + 1) / 7);
  },
  getMinDate: function getMinDate(e) {
    var t;
    return e.minDate && ("string" == typeof e.minDate ? t = gj.core.parseDate(e.minDate, e.format, e.locale) : "function" == typeof e.minDate ? "string" == typeof (t = e.minDate()) && (t = gj.core.parseDate(t, e.format, e.locale)) : "function" == typeof e.minDate.getMonth && (t = e.minDate)), t;
  },
  getMaxDate: function getMaxDate(e) {
    var t;
    return e.maxDate && ("string" == typeof e.maxDate ? t = gj.core.parseDate(e.maxDate, e.format, e.locale) : "function" == typeof e.maxDate ? "string" == typeof (t = e.maxDate()) && (t = gj.core.parseDate(t, e.format, e.locale)) : "function" == typeof e.maxDate.getMonth && (t = e.maxDate)), t;
  },
  isSelectable: function isSelectable(e, t) {
    var r,
      a = !0,
      i = gj.datepicker.methods.getMinDate(e),
      o = gj.datepicker.methods.getMaxDate(e);
    if (i && t < i ? a = !1 : o && t > o && (a = !1), a) {
      if (e.disableDates) if ($.isArray(e.disableDates)) for (r = 0; r < e.disableDates.length; r++) {
        e.disableDates[r] instanceof Date && e.disableDates[r].getTime() === t.getTime() ? a = !1 : "string" == typeof e.disableDates[r] && gj.core.parseDate(e.disableDates[r], e.format, e.locale).getTime() === t.getTime() && (a = !1);
      } else e.disableDates instanceof Function && (a = e.disableDates(t));
      $.isArray(e.disableDaysOfWeek) && e.disableDaysOfWeek.indexOf(t.getDay()) > -1 && (a = !1);
    }
    return a;
  },
  getPrevMonth: function getPrevMonth(e, t) {
    return date = new Date(t, e, 1), date.setMonth(date.getMonth() - 1), {
      month: date.getMonth(),
      year: date.getFullYear()
    };
  },
  getNextMonth: function getNextMonth(e, t) {
    return date = new Date(t, e, 1), date.setMonth(date.getMonth() + 1), {
      month: date.getMonth(),
      year: date.getFullYear()
    };
  },
  prev: function prev(e, t) {
    return function () {
      var r,
        a,
        i,
        o,
        n,
        d = $("body").find('[role="calendar"][guid="' + e.attr("data-guid") + '"]');
      switch (i = parseInt(d.attr("year"), 10), d.attr("type")) {
        case "month":
          a = parseInt(d.attr("month"), 10), r = gj.datepicker.methods.getPrevMonth(a, i), d.attr("month", r.month), d.attr("year", r.year), gj.datepicker.methods.renderMonth(e, d, t);
          break;
        case "year":
          d.attr("year", i - 1), gj.datepicker.methods.renderYear(e, d, t);
          break;
        case "decade":
          o = i - i % 10, d.attr("year", o - 10), gj.datepicker.methods.renderDecade(e, d, t);
          break;
        case "century":
          n = i - i % 100, d.attr("year", n - 100), gj.datepicker.methods.renderCentury(e, d, t);
      }
    };
  },
  next: function next(e, t) {
    return function () {
      var r,
        a,
        i,
        o,
        n,
        d = $("body").find('[role="calendar"][guid="' + e.attr("data-guid") + '"]');
      switch (i = parseInt(d.attr("year"), 10), d.attr("type")) {
        case "month":
          a = parseInt(d.attr("month"), 10), r = gj.datepicker.methods.getNextMonth(a, i), d.attr("month", r.month), d.attr("year", r.year), gj.datepicker.methods.renderMonth(e, d, t);
          break;
        case "year":
          d.attr("year", i + 1), gj.datepicker.methods.renderYear(e, d, t);
          break;
        case "decade":
          o = i - i % 10, d.attr("year", o + 10), gj.datepicker.methods.renderDecade(e, d, t);
          break;
        case "century":
          n = i - i % 100, d.attr("year", n + 100), gj.datepicker.methods.renderCentury(e, d, t);
      }
    };
  },
  changePeriod: function changePeriod(e, t) {
    return function (r) {
      var a = $("body").find('[role="calendar"][guid="' + e.attr("data-guid") + '"]');
      switch (a.attr("type")) {
        case "month":
          gj.datepicker.methods.renderYear(e, a, t);
          break;
        case "year":
          gj.datepicker.methods.renderDecade(e, a, t);
          break;
        case "decade":
          gj.datepicker.methods.renderCentury(e, a, t);
      }
    };
  },
  dayClickHandler: function dayClickHandler(e, t, r, a) {
    return function (i) {
      return i && i.stopPropagation(), gj.datepicker.methods.selectDay(e, t, r, a), !0 !== r.footer && !1 !== r.autoClose && gj.datepicker.methods.change(e, t, r, a), e;
    };
  },
  change: function change(e, t, r, a) {
    var i = (a.getDate(), a.getMonth()),
      o = a.getFullYear(),
      n = gj.core.formatDate(a, r.format, r.locale);
    t.attr("month", i), t.attr("year", o), e.val(n), gj.datepicker.events.change(e), "none" !== window.getComputedStyle(t[0]).display && gj.datepicker.methods.close(e);
  },
  selectDay: function selectDay(e, t, r, a) {
    var i = a.getDate(),
      o = a.getMonth(),
      n = a.getFullYear();
    t.attr("selectedDay", n + "-" + o + "-" + i), t.find("tbody td").removeClass("selected"), t.find('tbody td[day="' + i + '"][month="' + o + '"]').addClass("selected"), gj.datepicker.methods.updateHeader(t, r, a), gj.datepicker.events.select(e, "day");
  },
  selectMonth: function selectMonth(e, t, r, a) {
    return function (i) {
      t.attr("month", a), gj.datepicker.methods.renderMonth(e, t, r), gj.datepicker.events.select(e, "month");
    };
  },
  selectYear: function selectYear(e, t, r, a) {
    return function (i) {
      t.attr("year", a), gj.datepicker.methods.renderYear(e, t, r), gj.datepicker.events.select(e, "year");
    };
  },
  selectDecade: function selectDecade(e, t, r, a) {
    return function (i) {
      t.attr("year", a), gj.datepicker.methods.renderDecade(e, t, r), gj.datepicker.events.select(e, "decade");
    };
  },
  open: function open(e, t) {
    var r,
      a = $("body").find('[role="calendar"][guid="' + e.attr("data-guid") + '"]');
    switch (e.val() ? e.value(e.val()) : (r = new Date(), a.attr("month", r.getMonth()), a.attr("year", r.getFullYear())), a.attr("type")) {
      case "month":
        gj.datepicker.methods.renderMonth(e, a, t);
        break;
      case "year":
        gj.datepicker.methods.renderYear(e, a, t);
        break;
      case "decade":
        gj.datepicker.methods.renderDecade(e, a, t);
        break;
      case "century":
        gj.datepicker.methods.renderCentury(e, a, t);
    }
    a.show(), a.closest('div[role="modal"]').show(), t.modal ? gj.core.center(a) : (gj.core.setChildPosition(e[0], a[0]), document.activeElement !== e[0] && e.focus()), clearTimeout(e.timeout), gj.datepicker.events.open(e);
  },
  close: function close(e) {
    var t = $("body").find('[role="calendar"][guid="' + e.attr("data-guid") + '"]');
    t.hide(), t.closest('div[role="modal"]').hide(), gj.datepicker.events.close(e);
  },
  createKeyDownHandler: function createKeyDownHandler(e, t, r) {
    return function (a) {
      var i, o, n, d, s, l;
      a = a || window.event;
      "none" !== window.getComputedStyle(t[0]).display && (l = gj.datepicker.methods.getActiveCell(t), "38" == a.keyCode ? (d = l.index(), (s = l.closest("tr").prev("tr").find("td:eq(" + d + ")")).is("[day]") || (gj.datepicker.methods.prev(e, r)(), (s = t.find("tbody tr").last().find("td:eq(" + d + ")")).is(":empty") && (s = t.find("tbody tr").last().prev().find("td:eq(" + d + ")"))), s.is("[day]") && (s.addClass("focused"), l.removeClass("focused"))) : "40" == a.keyCode ? (d = l.index(), (s = l.closest("tr").next("tr").find("td:eq(" + d + ")")).is("[day]") || (gj.datepicker.methods.next(e, r)(), (s = t.find("tbody tr").first().find("td:eq(" + d + ")")).is("[day]") || (s = t.find("tbody tr:eq(1)").find("td:eq(" + d + ")"))), s.is("[day]") && (s.addClass("focused"), l.removeClass("focused"))) : "37" == a.keyCode ? (0 === (s = l.prev("td[day]:not(.disabled)")).length && (s = l.closest("tr").prev("tr").find("td[day]").last()), 0 === s.length && (gj.datepicker.methods.prev(e, r)(), s = t.find("tbody tr").last().find("td[day]").last()), s.length > 0 && (s.addClass("focused"), l.removeClass("focused"))) : "39" == a.keyCode ? (0 === (s = l.next("[day]:not(.disabled)")).length && (s = l.closest("tr").next("tr").find("td[day]").first()), 0 === s.length && (gj.datepicker.methods.next(e, r)(), s = t.find("tbody tr").first().find("td[day]").first()), s.length > 0 && (s.addClass("focused"), l.removeClass("focused"))) : "13" == a.keyCode ? (n = parseInt(l.attr("day"), 10), i = parseInt(l.attr("month"), 10), o = parseInt(l.attr("year"), 10), gj.datepicker.methods.dayClickHandler(e, t, r, new Date(o, i, n))()) : "27" == a.keyCode && e.close());
    };
  },
  getActiveCell: function getActiveCell(e) {
    var t = e.find("td[day].focused");
    return 0 === t.length && 0 === (t = e.find("td[day].selected")).length && 0 === (t = e.find("td[day].today")).length && (t = e.find("td[day]:not(.disabled)").first()), t;
  },
  value: function value(e, t) {
    var r,
      a,
      i = e.data();
    return void 0 === t ? e.val() : ((a = gj.core.parseDate(t, i.format, i.locale)) && a.getTime() ? (r = $("body").find('[role="calendar"][guid="' + e.attr("data-guid") + '"]'), gj.datepicker.methods.dayClickHandler(e, r, i, a)()) : e.val(""), e);
  },
  destroy: function destroy(e) {
    var t = e.data(),
      r = e.parent(),
      a = $("body").find('[role="calendar"][guid="' + e.attr("data-guid") + '"]');
    return t && (e.off(), a.parent('[role="modal"]').length > 0 && a.unwrap(), a.remove(), e.removeData(), e.removeAttr("data-type").removeAttr("data-guid").removeAttr("data-datepicker"), e.removeClass(), r.children('[role="right-icon"]').remove(), e.unwrap()), e;
  }
}, gj.datepicker.events = {
  change: function change(e) {
    return e.triggerHandler("change");
  },
  select: function select(e, t) {
    return e.triggerHandler("select", [t]);
  },
  open: function open(e) {
    return e.triggerHandler("open");
  },
  close: function close(e) {
    return e.triggerHandler("close");
  }
}, gj.datepicker.widget = function (e, t) {
  var r = this,
    a = gj.datepicker.methods;
  return r.value = function (e) {
    return a.value(this, e);
  }, r.destroy = function () {
    return a.destroy(this);
  }, r.open = function () {
    return a.open(this, this.data());
  }, r.close = function () {
    return a.close(this);
  }, $.extend(e, r), "true" !== e.attr("data-datepicker") && a.init.call(e, t), e;
}, gj.datepicker.widget.prototype = new gj.widget(), gj.datepicker.widget.constructor = gj.datepicker.widget, jQuery.fn.datepicker = function (e) {
  var t;
  if (this && this.length) {
    if ("object" != _typeof(e) && e) {
      if ((t = new gj.datepicker.widget(this, null))[e]) return t[e].apply(this, Array.prototype.slice.call(arguments, 1));
      throw "Method " + e + " does not exist.";
    }
    return new gj.datepicker.widget(this, e);
  }
}, gj.timepicker = {
  plugins: {}
}, gj.timepicker.config = {
  base: {
    width: void 0,
    modal: !0,
    header: !0,
    footer: !0,
    format: "HH:MM",
    uiLibrary: "materialdesign",
    value: void 0,
    mode: "ampm",
    locale: "en-us",
    size: "default",
    icons: {
      rightIcon: '<i class="gj-icon clock" />'
    },
    style: {
      modal: "gj-modal",
      wrapper: "gj-timepicker gj-timepicker-md gj-unselectable",
      input: "gj-textbox-md",
      clock: "gj-picker gj-picker-md timepicker",
      footer: "",
      button: "gj-button-md"
    }
  },
  bootstrap: {
    style: {
      wrapper: "gj-timepicker gj-timepicker-bootstrap gj-unselectable input-group",
      input: "form-control",
      clock: "gj-picker gj-picker-bootstrap timepicker",
      footer: "modal-footer",
      button: "btn btn-default"
    },
    iconsLibrary: "glyphicons"
  },
  bootstrap4: {
    style: {
      wrapper: "gj-timepicker gj-timepicker-bootstrap gj-unselectable input-group",
      input: "form-control border",
      clock: "gj-picker gj-picker-bootstrap timepicker",
      footer: "modal-footer",
      button: "btn btn-default"
    }
  }
}, gj.timepicker.methods = {
  init: function init(e) {
    return gj.picker.widget.prototype.init.call(this, e, "timepicker"), this;
  },
  initialize: function initialize() {},
  initMouse: function initMouse(e, t, r, a) {
    e.off(), e.on("mousedown", gj.timepicker.methods.mouseDownHandler(t, r)), e.on("mousemove", gj.timepicker.methods.mouseMoveHandler(t, r, a)), e.on("mouseup", gj.timepicker.methods.mouseUpHandler(t, r, a));
  },
  createPicker: function createPicker(e) {
    var t,
      r = e.data(),
      a = $('<div role="picker" />').addClass(r.style.clock).attr("guid", e.attr("data-guid")),
      i = $('<div role="hour" />'),
      o = $('<div role="minute" />'),
      n = $('<div role="header" />'),
      d = $('<div role="mode" />'),
      s = $('<div role="body" />'),
      l = $('<button class="' + r.style.button + '">' + gj.core.messages[r.locale].ok + "</button>"),
      c = $('<button class="' + r.style.button + '">' + gj.core.messages[r.locale].cancel + "</button>"),
      g = $('<div role="footer" class="' + r.style.footer + '" />');
    return !(t = gj.core.parseDate(r.value, r.format, r.locale)) || isNaN(t.getTime()) ? t = new Date() : e.attr("hours", t.getHours()), gj.timepicker.methods.initMouse(s, e, a, r), r.header && (i.on("click", function () {
      gj.timepicker.methods.renderHours(e, a, r);
    }), o.on("click", function () {
      gj.timepicker.methods.renderMinutes(e, a, r);
    }), n.append(i).append(":").append(o), "ampm" === r.mode && (d.append($('<span role="am">' + gj.core.messages[r.locale].am + "</span>").on("click", function () {
      var t = gj.timepicker.methods.getHour(a);
      a.attr("mode", "am"), $(this).addClass("selected"), $(this).parent().children('[role="pm"]').removeClass("selected"), t >= 12 && a.attr("hour", t - 12), r.modal || (clearTimeout(e.timeout), e.focus());
    })), d.append("<br />"), d.append($('<span role="pm">' + gj.core.messages[r.locale].pm + "</span>").on("click", function () {
      var t = gj.timepicker.methods.getHour(a);
      a.attr("mode", "pm"), $(this).addClass("selected"), $(this).parent().children('[role="am"]').removeClass("selected"), t < 12 && a.attr("hour", t + 12), r.modal || (clearTimeout(e.timeout), e.focus());
    })), n.append(d)), a.append(n)), a.append(s), r.footer && (c.on("click", function () {
      e.close();
    }), g.append(c), l.on("click", gj.timepicker.methods.setTime(e, a)), g.append(l), a.append(g)), a.hide(), $("body").append(a), r.modal && (a.wrapAll('<div role="modal" class="' + r.style.modal + '"/>'), gj.core.center(a)), a;
  },
  getHour: function getHour(e) {
    return parseInt(e.attr("hour"), 10) || 0;
  },
  getMinute: function getMinute(e) {
    return parseInt(e.attr("minute"), 10) || 0;
  },
  setTime: function setTime(e, t) {
    return function () {
      var r = gj.timepicker.methods.getHour(t),
        a = gj.timepicker.methods.getMinute(t),
        i = t.attr("mode"),
        o = new Date(0, 0, 0, 12 === r && "am" === i ? 0 : r, a),
        n = e.data(),
        d = gj.core.formatDate(o, n.format, n.locale);
      e.value(d), e.close();
    };
  },
  getPointerValue: function getPointerValue(e, t, r) {
    var a,
      i,
      o = Math.atan2(128 - e, 128 - t) / Math.PI * 180;
    switch (o < 0 && (o = 360 + o), r) {
      case "ampm":
        return 0 === (a = 12 - Math.round(12 * o / 360)) ? 12 : a;
      case "24hr":
        return i = Math.sqrt(Math.pow(128 - e, 2) + Math.pow(128 - t, 2)), 0 === (a = 12 - Math.round(12 * o / 360)) && (a = 12), i < 96 && (a = 12 === a ? 0 : a + 12), a;
      case "minutes":
        return 60 === (a = Math.round(60 - 60 * o / 360)) ? 0 : a;
    }
  },
  updateArrow: function updateArrow(e, t, r, a) {
    var i,
      o,
      n = t.mouseX(e),
      d = t.mouseY(e),
      s = window.scrollY || window.pageYOffset || 0,
      l = window.scrollX || window.pageXOffset || 0;
    i = e.target.getBoundingClientRect(), "hours" == a.dialMode ? (o = gj.timepicker.methods.getPointerValue(n - l - i.left, d - s - i.top, a.mode), r.attr("hour", "ampm" === a.mode && "pm" === r.attr("mode") && o < 12 ? o + 12 : o)) : "minutes" == a.dialMode && (o = gj.timepicker.methods.getPointerValue(n - l - i.left, d - s - i.top, "minutes"), r.attr("minute", o)), gj.timepicker.methods.update(t, r, a);
  },
  update: function update(e, t, r) {
    var a, i, o, n, d, s;
    a = gj.timepicker.methods.getHour(t), i = gj.timepicker.methods.getMinute(t), o = t.find('[role="arrow"]'), "hours" == r.dialMode && (0 == a || a > 12) && "24hr" === r.mode ? o.css("width", "calc(50% - 52px)") : o.css("width", "calc(50% - 20px)"), "hours" == r.dialMode ? o.css("transform", "rotate(" + (30 * a - 90).toString() + "deg)") : o.css("transform", "rotate(" + (6 * i - 90).toString() + "deg)"), o.show(), n = "ampm" === r.mode && a > 12 ? a - 12 : 0 == a ? 12 : a, (s = t.find('[role="body"] span')).removeClass("selected"), s.filter(function (e) {
      return "hours" == r.dialMode ? parseInt($(this).text(), 10) == n : parseInt($(this).text(), 10) == i;
    }).addClass("selected"), r.header && ((d = t.find('[role="header"]')).find('[role="hour"]').text(n), d.find('[role="minute"]').text(gj.core.pad(i)), "ampm" === r.mode && (a >= 12 ? (d.find('[role="pm"]').addClass("selected"), d.find('[role="am"]').removeClass("selected")) : (d.find('[role="am"]').addClass("selected"), d.find('[role="pm"]').removeClass("selected"))));
  },
  mouseDownHandler: function mouseDownHandler(e, t) {
    return function (t) {
      e.mouseMove = !0;
    };
  },
  mouseMoveHandler: function mouseMoveHandler(e, t, r) {
    return function (a) {
      e.mouseMove && gj.timepicker.methods.updateArrow(a, e, t, r);
    };
  },
  mouseUpHandler: function mouseUpHandler(e, t, r) {
    return function (a) {
      gj.timepicker.methods.updateArrow(a, e, t, r), e.mouseMove = !1, r.modal || (clearTimeout(e.timeout), e.focus()), "hours" == r.dialMode ? setTimeout(function () {
        gj.timepicker.events.select(e, "hour"), gj.timepicker.methods.renderMinutes(e, t, r);
      }, 1e3) : "minutes" == r.dialMode && (!0 !== r.footer && !1 !== r.autoClose && gj.timepicker.methods.setTime(e, t)(), gj.timepicker.events.select(e, "minute"));
    };
  },
  renderHours: function renderHours(e, t, r) {
    var a,
      i = t.find('[role="body"]');
    clearTimeout(e.timeout), i.empty(), (a = $('<div role="dial"></div>')).append('<div role="arrow" style="transform: rotate(-90deg); display: none;"><div class="arrow-begin"></div><div class="arrow-end"></div></div>'), a.append('<span role="hour" style="transform: translate(54px, -93.5307px);">1</span>'), a.append('<span role="hour" style="transform: translate(93.5307px, -54px);">2</span>'), a.append('<span role="hour" style="transform: translate(108px, 0px);">3</span>'), a.append('<span role="hour" style="transform: translate(93.5307px, 54px);">4</span>'), a.append('<span role="hour" style="transform: translate(54px, 93.5307px);">5</span>'), a.append('<span role="hour" style="transform: translate(6.61309e-15px, 108px);">6</span>'), a.append('<span role="hour" style="transform: translate(-54px, 93.5307px);">7</span>'), a.append('<span role="hour" style="transform: translate(-93.5307px, 54px);">8</span>'), a.append('<span role="hour" style="transform: translate(-108px, 1.32262e-14px);">9</span>'), a.append('<span role="hour" style="transform: translate(-93.5307px, -54px);">10</span>'), a.append('<span role="hour" style="transform: translate(-54px, -93.5307px);">11</span>'), a.append('<span role="hour" style="transform: translate(-1.98393e-14px, -108px);">12</span>'), "24hr" === r.mode && (a.append('<span role="hour" style="transform: translate(38px, -65.8179px);">13</span>'), a.append('<span role="hour" style="transform: translate(65.8179px, -38px);">14</span>'), a.append('<span role="hour" style="transform: translate(76px, 0px);">15</span>'), a.append('<span role="hour" style="transform: translate(65.8179px, 38px);">16</span>'), a.append('<span role="hour" style="transform: translate(38px, 65.8179px);">17</span>'), a.append('<span role="hour" style="transform: translate(4.65366e-15px, 76px);">18</span>'), a.append('<span role="hour" style="transform: translate(-38px, 65.8179px);">19</span>'), a.append('<span role="hour" style="transform: translate(-65.8179px, 38px);">20</span>'), a.append('<span role="hour" style="transform: translate(-76px, 9.30732e-15px);">21</span>'), a.append('<span role="hour" style="transform: translate(-65.8179px, -38px);">22</span>'), a.append('<span role="hour" style="transform: translate(-38px, -65.8179px);">23</span>'), a.append('<span role="hour" style="transform: translate(-1.3961e-14px, -76px);">00</span>')), i.append(a), t.find('[role="header"] [role="hour"]').addClass("selected"), t.find('[role="header"] [role="minute"]').removeClass("selected"), r.dialMode = "hours", gj.timepicker.methods.update(e, t, r);
  },
  renderMinutes: function renderMinutes(e, t, r) {
    var a = t.find('[role="body"]');
    clearTimeout(e.timeout), a.empty(), $dial = $('<div role="dial"></div>'), $dial.append('<div role="arrow" style="transform: rotate(-90deg); display: none;"><div class="arrow-begin"></div><div class="arrow-end"></div></div>'), $dial.append('<span role="hour" style="transform: translate(54px, -93.5307px);">5</span>'), $dial.append('<span role="hour" style="transform: translate(93.5307px, -54px);">10</span>'), $dial.append('<span role="hour" style="transform: translate(108px, 0px);">15</span>'), $dial.append('<span role="hour" style="transform: translate(93.5307px, 54px);">20</span>'), $dial.append('<span role="hour" style="transform: translate(54px, 93.5307px);">25</span>'), $dial.append('<span role="hour" style="transform: translate(6.61309e-15px, 108px);">30</span>'), $dial.append('<span role="hour" style="transform: translate(-54px, 93.5307px);">35</span>'), $dial.append('<span role="hour" style="transform: translate(-93.5307px, 54px);">40</span>'), $dial.append('<span role="hour" style="transform: translate(-108px, 1.32262e-14px);">45</span>'), $dial.append('<span role="hour" style="transform: translate(-93.5307px, -54px);">50</span>'), $dial.append('<span role="hour" style="transform: translate(-54px, -93.5307px);">55</span>'), $dial.append('<span role="hour" style="transform: translate(-1.98393e-14px, -108px);">00</span>'), a.append($dial), t.find('[role="header"] [role="hour"]').removeClass("selected"), t.find('[role="header"] [role="minute"]').addClass("selected"), r.dialMode = "minutes", gj.timepicker.methods.update(e, t, r);
  },
  open: function open(e) {
    var t,
      r,
      a = e.data(),
      i = $("body").find('[role="picker"][guid="' + e.attr("data-guid") + '"]');
    return r = (t = e.value() ? gj.core.parseDate(e.value(), a.format, a.locale) : new Date()).getHours(), "ampm" === a.mode && i.attr("mode", r > 12 ? "pm" : "am"), i.attr("hour", r), i.attr("minute", t.getMinutes()), gj.timepicker.methods.renderHours(e, i, a), gj.picker.widget.prototype.open.call(e, "timepicker"), e;
  },
  value: function value(e, t) {
    return e.data(), void 0 === t ? e.val() : (e.val(t), gj.timepicker.events.change(e), e);
  }
}, gj.timepicker.events = {
  change: function change(e) {
    return e.triggerHandler("change");
  },
  select: function select(e, t) {
    return e.triggerHandler("select", [t]);
  },
  open: function open(e) {
    return e.triggerHandler("open");
  },
  close: function close(e) {
    return e.triggerHandler("close");
  }
}, gj.timepicker.widget = function (e, t) {
  var r = this,
    a = gj.timepicker.methods;
  return r.mouseMove = !1, r.value = function (e) {
    return a.value(this, e);
  }, r.destroy = function () {
    return gj.picker.widget.prototype.destroy.call(this, "timepicker");
  }, r.open = function () {
    return gj.timepicker.methods.open(this);
  }, r.close = function () {
    return gj.picker.widget.prototype.close.call(this, "timepicker");
  }, $.extend(e, r), "true" !== e.attr("data-timepicker") && a.init.call(e, t), e;
}, gj.timepicker.widget.prototype = new gj.picker.widget(), gj.timepicker.widget.constructor = gj.timepicker.widget, jQuery.fn.timepicker = function (e) {
  var t;
  if (this && this.length) {
    if ("object" != _typeof(e) && e) {
      if ((t = new gj.timepicker.widget(this, null))[e]) return t[e].apply(this, Array.prototype.slice.call(arguments, 1));
      throw "Method " + e + " does not exist.";
    }
    return new gj.timepicker.widget(this, e);
  }
}, gj.datetimepicker = {
  plugins: {},
  messages: {
    "en-us": {}
  }
}, gj.datetimepicker.config = {
  base: {
    datepicker: gj.datepicker.config.base,
    timepicker: gj.timepicker.config.base,
    uiLibrary: "materialdesign",
    value: void 0,
    format: "HH:MM mm/dd/yyyy",
    width: void 0,
    modal: !1,
    footer: !1,
    size: "default",
    locale: "en-us",
    icons: {},
    style: {
      calendar: "gj-picker gj-picker-md datetimepicker gj-unselectable"
    }
  },
  bootstrap: {
    style: {
      calendar: "gj-picker gj-picker-bootstrap datetimepicker gj-unselectable"
    },
    iconsLibrary: "glyphicons"
  },
  bootstrap4: {
    style: {
      calendar: "gj-picker gj-picker-bootstrap datetimepicker gj-unselectable"
    }
  }
}, gj.datetimepicker.methods = {
  init: function init(e) {
    return gj.widget.prototype.init.call(this, e, "datetimepicker"), this.attr("data-datetimepicker", "true"), gj.datetimepicker.methods.initialize(this), this;
  },
  getConfig: function getConfig(e, t) {
    var r = gj.widget.prototype.getConfig.call(this, e, t);
    return uiLibrary = e.hasOwnProperty("uiLibrary") ? e.uiLibrary : r.uiLibrary, gj.datepicker.config[uiLibrary] && $.extend(!0, r.datepicker, gj.datepicker.config[uiLibrary]), gj.timepicker.config[uiLibrary] && $.extend(!0, r.timepicker, gj.timepicker.config[uiLibrary]), iconsLibrary = e.hasOwnProperty("iconsLibrary") ? e.iconsLibrary : r.iconsLibrary, gj.datepicker.config[iconsLibrary] && $.extend(!0, r.datepicker, gj.datepicker.config[iconsLibrary]), gj.timepicker.config[iconsLibrary] && $.extend(!0, r.timepicker, gj.timepicker.config[iconsLibrary]), r;
  },
  initialize: function initialize(e) {
    var t,
      r,
      a,
      i,
      o,
      n,
      d,
      s,
      l = e.data();
    l.datepicker.uiLibrary = l.uiLibrary, l.datepicker.iconsLibrary = l.iconsLibrary, l.datepicker.width = l.width, l.datepicker.format = l.format, l.datepicker.locale = l.locale, l.datepicker.modal = l.modal, l.datepicker.footer = l.footer, l.datepicker.style.calendar = l.style.calendar, l.datepicker.value = l.value, l.datepicker.size = l.size, l.datepicker.autoClose = !1, gj.datepicker.methods.initialize(e, l.datepicker), e.on("select", function (r, a) {
      var i, o;
      "day" === a ? gj.datetimepicker.methods.createShowHourHandler(e, t, l)() : "minute" === a && t.attr("selectedDay") && !0 !== l.footer && (selectedDay = t.attr("selectedDay").split("-"), i = new Date(selectedDay[0], selectedDay[1], selectedDay[2], t.attr("hour") || 0, t.attr("minute") || 0), o = gj.core.formatDate(i, l.format, l.locale), e.val(o), gj.datetimepicker.events.change(e), gj.datetimepicker.methods.close(e));
    }), e.on("open", function () {
      var e = t.children('[role="header"]');
      e.find('[role="calendarMode"]').addClass("selected"), e.find('[role="clockMode"]').removeClass("selected");
    }), t = $("body").find('[role="calendar"][guid="' + e.attr("data-guid") + '"]'), o = l.value ? gj.core.parseDate(l.value, l.format, l.locale) : new Date(), t.attr("hour", o.getHours()), t.attr("minute", o.getMinutes()), l.timepicker.uiLibrary = l.uiLibrary, l.timepicker.iconsLibrary = l.iconsLibrary, l.timepicker.format = l.format, l.timepicker.locale = l.locale, l.timepicker.header = !0, l.timepicker.footer = l.footer, l.timepicker.size = l.size, l.timepicker.mode = "24hr", l.timepicker.autoClose = !1, r = $('<div role="header" />'), (a = $('<div role="date" class="selected" />')).on("click", gj.datetimepicker.methods.createShowDateHandler(e, t, l)), a.html(gj.core.formatDate(new Date(), "ddd, mmm dd", l.locale)), r.append(a), n = $('<div role="switch"></div>'), (d = $('<i class="gj-icon selected" role="calendarMode">event</i>')).on("click", gj.datetimepicker.methods.createShowDateHandler(e, t, l)), n.append(d), (i = $('<div role="time" />')).append($('<div role="hour" />').on("click", gj.datetimepicker.methods.createShowHourHandler(e, t, l)).html(gj.core.formatDate(new Date(), "HH", l.locale))), i.append(":"), i.append($('<div role="minute" />').on("click", gj.datetimepicker.methods.createShowMinuteHandler(e, t, l)).html(gj.core.formatDate(new Date(), "MM", l.locale))), n.append(i), (s = $('<i class="gj-icon" role="clockMode">clock</i>')).on("click", gj.datetimepicker.methods.createShowHourHandler(e, t, l)), n.append(s), r.append(n), t.prepend(r);
  },
  createShowDateHandler: function createShowDateHandler(e, t, r) {
    return function (a) {
      var i = t.children('[role="header"]');
      i.find('[role="calendarMode"]').addClass("selected"), i.find('[role="date"]').addClass("selected"), i.find('[role="clockMode"]').removeClass("selected"), i.find('[role="hour"]').removeClass("selected"), i.find('[role="minute"]').removeClass("selected"), gj.datepicker.methods.renderMonth(e, t, r.datepicker);
    };
  },
  createShowHourHandler: function createShowHourHandler(e, t, r) {
    return function () {
      var a = t.children('[role="header"]');
      a.find('[role="calendarMode"]').removeClass("selected"), a.find('[role="date"]').removeClass("selected"), a.find('[role="clockMode"]').addClass("selected"), a.find('[role="hour"]').addClass("selected"), a.find('[role="minute"]').removeClass("selected"), gj.timepicker.methods.initMouse(t.children('[role="body"]'), e, t, r.timepicker), gj.timepicker.methods.renderHours(e, t, r.timepicker);
    };
  },
  createShowMinuteHandler: function createShowMinuteHandler(e, t, r) {
    return function () {
      var a = t.children('[role="header"]');
      a.find('[role="calendarMode"]').removeClass("selected"), a.find('[role="date"]').removeClass("selected"), a.find('[role="clockMode"]').addClass("selected"), a.find('[role="hour"]').removeClass("selected"), a.find('[role="minute"]').addClass("selected"), gj.timepicker.methods.initMouse(t.children('[role="body"]'), e, t, r.timepicker), gj.timepicker.methods.renderMinutes(e, t, r.timepicker);
    };
  },
  close: function close(e) {
    var t = $("body").find('[role="calendar"][guid="' + e.attr("data-guid") + '"]');
    t.hide(), t.closest('div[role="modal"]').hide();
  },
  value: function value(e, t) {
    var r,
      a,
      i,
      o = e.data();
    return void 0 === t ? e.val() : ((a = gj.core.parseDate(t, o.format, o.locale)) ? (r = $("body").find('[role="calendar"][guid="' + e.attr("data-guid") + '"]'), gj.datepicker.methods.dayClickHandler(e, r, o, a)(), i = a.getHours(), "ampm" === o.mode && r.attr("mode", i > 12 ? "pm" : "am"), r.attr("hour", i), r.attr("minute", a.getMinutes()), e.val(t)) : e.val(""), e);
  },
  destroy: function destroy(e) {
    var t = e.data(),
      r = e.parent(),
      a = $("body").find('[role="calendar"][guid="' + e.attr("data-guid") + '"]');
    return t && (e.off(), a.parent('[role="modal"]').length > 0 && a.unwrap(), a.remove(), e.removeData(), e.removeAttr("data-type").removeAttr("data-guid").removeAttr("data-datetimepicker"), e.removeClass(), r.children('[role="right-icon"]').remove(), e.unwrap()), e;
  }
}, gj.datetimepicker.events = {
  change: function change(e) {
    return e.triggerHandler("change");
  }
}, gj.datetimepicker.widget = function (e, t) {
  var r = this,
    a = gj.datetimepicker.methods;
  return r.mouseMove = !1, r.value = function (e) {
    return a.value(this, e);
  }, r.open = function () {
    gj.datepicker.methods.open(this, this.data().datepicker);
  }, r.close = function () {
    gj.datepicker.methods.close(this);
  }, r.destroy = function () {
    return a.destroy(this);
  }, $.extend(e, r), "true" !== e.attr("data-datetimepicker") && a.init.call(e, t), e;
}, gj.datetimepicker.widget.prototype = new gj.widget(), gj.datetimepicker.widget.constructor = gj.datetimepicker.widget, gj.datetimepicker.widget.prototype.getConfig = gj.datetimepicker.methods.getConfig, jQuery.fn.datetimepicker = function (e) {
  var t;
  if (this && this.length) {
    if ("object" != _typeof(e) && e) {
      if ((t = new gj.datetimepicker.widget(this, null))[e]) return t[e].apply(this, Array.prototype.slice.call(arguments, 1));
      throw "Method " + e + " does not exist.";
    }
    return new gj.datetimepicker.widget(this, e);
  }
}, gj.slider = {
  plugins: {},
  messages: {
    "en-us": {}
  }
}, gj.slider.config = {
  base: {
    min: 0,
    max: 100,
    width: void 0,
    uiLibrary: "materialdesign",
    value: void 0,
    icons: {},
    style: {
      wrapper: "gj-slider gj-slider-md",
      progress: void 0,
      track: void 0
    }
  },
  bootstrap: {
    style: {
      wrapper: "gj-slider gj-slider-bootstrap gj-slider-bootstrap-3",
      progress: "progress-bar",
      track: "progress"
    }
  },
  bootstrap4: {
    style: {
      wrapper: "gj-slider gj-slider-bootstrap gj-slider-bootstrap-4",
      progress: "progress-bar",
      track: "progress"
    }
  }
}, gj.slider.methods = {
  init: function init(e) {
    return gj.widget.prototype.init.call(this, e, "slider"), this.attr("data-slider", "true"), gj.slider.methods.initialize(this, this.data()), this;
  },
  initialize: function initialize(e, t) {
    var r, a, i, o;
    e[0].style.display = "none", "wrapper" !== e[0].parentElement.attributes.role ? ((r = document.createElement("div")).setAttribute("role", "wrapper"), e[0].parentNode.insertBefore(r, e[0]), r.appendChild(e[0])) : r = e[0].parentElement, t.width && (r.style.width = t.width + "px"), gj.core.addClasses(r, t.style.wrapper), null == (a = e[0].querySelector('[role="track"]')) && ((a = document.createElement("div")).setAttribute("role", "track"), r.appendChild(a)), gj.core.addClasses(a, t.style.track), null == (i = e[0].querySelector('[role="handle"]')) && ((i = document.createElement("div")).setAttribute("role", "handle"), r.appendChild(i)), null == (o = e[0].querySelector('[role="progress"]')) && ((o = document.createElement("div")).setAttribute("role", "progress"), r.appendChild(o)), gj.core.addClasses(o, t.style.progress), t.value || (t.value = t.min), gj.slider.methods.value(e, t, t.value), gj.documentManager.subscribeForEvent("mouseup", e.data("guid"), gj.slider.methods.createMouseUpHandler(e, i, t)), i.addEventListener("mousedown", gj.slider.methods.createMouseDownHandler(i, t)), gj.documentManager.subscribeForEvent("mousemove", e.data("guid"), gj.slider.methods.createMouseMoveHandler(e, a, i, o, t)), i.addEventListener("click", function (e) {
      e.stopPropagation();
    }), r.addEventListener("click", gj.slider.methods.createClickHandler(e, a, i, t));
  },
  createClickHandler: function createClickHandler(e, t, r, a) {
    return function (i) {
      var o, n, d, s, l;
      "true" !== r.getAttribute("drag") && (o = gj.core.position(e[0].parentElement), n = new gj.widget().mouseX(i) - o.left, d = gj.core.width(r) / 2, s = gj.core.width(t) / (a.max - a.min), l = Math.round((n - d) / s) + a.min, gj.slider.methods.value(e, a, l));
    };
  },
  createMouseUpHandler: function createMouseUpHandler(e, t, r) {
    return function (r) {
      "true" === t.getAttribute("drag") && (t.setAttribute("drag", "false"), gj.slider.events.change(e));
    };
  },
  createMouseDownHandler: function createMouseDownHandler(e, t) {
    return function (t) {
      e.setAttribute("drag", "true");
    };
  },
  createMouseMoveHandler: function createMouseMoveHandler(e, t, r, a, i) {
    return function (a) {
      var o, n, d, s, l, c, g;
      "true" === r.getAttribute("drag") && (o = gj.core.position(e[0].parentElement), n = new gj.widget().mouseX(a) - o.left, d = gj.core.width(t), s = gj.core.width(r) / 2, l = d / (i.max - i.min), c = (i.value - i.min) * l, n >= s && n <= d + s && (n > c + l / 2 || n < c - l / 2) && (g = Math.round((n - s) / l) + i.min, gj.slider.methods.value(e, i, g)));
    };
  },
  value: function value(e, t, r) {
    var a, i;
    return void 0 === r ? e[0].value : (e[0].setAttribute("value", r), t.value = r, i = e.parent().children('[role="track"]')[0], a = gj.core.width(i) / (t.max - t.min), e.parent().children('[role="handle"]')[0].style.left = (r - t.min) * a + "px", e.parent().children('[role="progress"]')[0].style.width = (r - t.min) * a + "px", gj.slider.events.slide(e, r), e);
  },
  destroy: function destroy(e) {
    var t = e.data(),
      r = e.parent();
    return t && (r.children('[role="track"]').remove(), r.children('[role="handle"]').remove(), r.children('[role="progress"]').remove(), e.unwrap(), e.off(), e.removeData(), e.removeAttr("data-type").removeAttr("data-guid").removeAttr("data-slider"), e.removeClass(), e.show()), e;
  }
}, gj.slider.events = {
  change: function change(e) {
    return e.triggerHandler("change");
  },
  slide: function slide(e, t) {
    return e.triggerHandler("slide", [t]);
  }
}, gj.slider.widget = function (e, t) {
  var r = this,
    a = gj.slider.methods;
  return r.value = function (e) {
    return a.value(this, this.data(), e);
  }, r.destroy = function () {
    return a.destroy(this);
  }, $.extend(e, r), "true" !== e.attr("data-slider") && a.init.call(e, t), e;
}, gj.slider.widget.prototype = new gj.widget(), gj.slider.widget.constructor = gj.slider.widget, jQuery.fn.slider = function (e) {
  var t;
  if (this && this.length) {
    if ("object" != _typeof(e) && e) {
      if ((t = new gj.slider.widget(this, null))[e]) return t[e].apply(this, Array.prototype.slice.call(arguments, 1));
      throw "Method " + e + " does not exist.";
    }
    return new gj.slider.widget(this, e);
  }
}, gj.colorpicker = {
  plugins: {},
  messages: {
    "en-us": {}
  }
}, gj.colorpicker.config = {
  base: {
    uiLibrary: "materialdesign",
    value: void 0,
    icons: {
      rightIcon: '<i class="gj-icon">event</i>'
    },
    style: {
      modal: "gj-modal",
      wrapper: "gj-colorpicker gj-colorpicker-md gj-unselectable",
      input: "gj-textbox-md",
      picker: "gj-picker gj-picker-md colorpicker gj-unselectable",
      footer: "",
      button: "gj-button-md"
    }
  },
  bootstrap: {
    style: {}
  },
  bootstrap4: {
    style: {}
  }
}, gj.colorpicker.methods = {
  init: function init(e) {
    return gj.picker.widget.prototype.init.call(this, e, "colorpicker"), gj.colorpicker.methods.initialize(this), this;
  },
  initialize: function initialize(e) {},
  createPicker: function createPicker(e, t) {
    var r = $('<div role="picker" />').addClass(t.style.picker).attr("guid", e.attr("data-guid"));
    return r.html("test"), r.hide(), $("body").append(r), r;
  },
  open: function open(e) {
    return e.val() && e.value(e.val()), gj.picker.widget.prototype.open.call(e, "colorpicker");
  }
}, gj.colorpicker.events = {
  change: function change(e) {
    return e.triggerHandler("change");
  },
  select: function select(e) {
    return e.triggerHandler("select");
  },
  open: function open(e) {
    return e.triggerHandler("open");
  },
  close: function close(e) {
    return e.triggerHandler("close");
  }
}, gj.colorpicker.widget = function (e, t) {
  var r = this,
    a = gj.colorpicker.methods;
  return r.value = function (e) {
    return a.value(this, e);
  }, r.destroy = function () {
    return gj.picker.widget.prototype.destroy.call(this, "colorpicker");
  }, r.open = function () {
    return a.open(this);
  }, r.close = function () {
    return gj.picker.widget.prototype.close.call(this, "colorpicker");
  }, $.extend(e, r), "true" !== e.attr("data-colorpicker") && a.init.call(e, t), e;
}, gj.colorpicker.widget.prototype = new gj.picker.widget(), gj.colorpicker.widget.constructor = gj.colorpicker.widget, jQuery.fn.colorpicker = function (e) {
  var t;
  if (this && this.length) {
    if ("object" != _typeof(e) && e) {
      if ((t = new gj.colorpicker.widget(this, null))[e]) return t[e].apply(this, Array.prototype.slice.call(arguments, 1));
      throw "Method " + e + " does not exist.";
    }
    return new gj.colorpicker.widget(this, e);
  }
};

/***/ }),

/***/ "./public/frontend/default/vendors/owl_carousel/js/owl.carousel.min.js":
/*!*****************************************************************************!*\
  !*** ./public/frontend/default/vendors/owl_carousel/js/owl.carousel.min.js ***!
  \*****************************************************************************/
/***/ (() => {

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
/**
 * Owl Carousel v2.3.4
 * Copyright 2013-2018 David Deutsch
 * Licensed under: SEE LICENSE IN https://github.com/OwlCarousel2/OwlCarousel2/blob/master/LICENSE
 */
!function (a, b, c, d) {
  function e(b, c) {
    this.settings = null, this.options = a.extend({}, e.Defaults, c), this.$element = a(b), this._handlers = {}, this._plugins = {}, this._supress = {}, this._current = null, this._speed = null, this._coordinates = [], this._breakpoint = null, this._width = null, this._items = [], this._clones = [], this._mergers = [], this._widths = [], this._invalidated = {}, this._pipe = [], this._drag = {
      time: null,
      target: null,
      pointer: null,
      stage: {
        start: null,
        current: null
      },
      direction: null
    }, this._states = {
      current: {},
      tags: {
        initializing: ["busy"],
        animating: ["busy"],
        dragging: ["interacting"]
      }
    }, a.each(["onResize", "onThrottledResize"], a.proxy(function (b, c) {
      this._handlers[c] = a.proxy(this[c], this);
    }, this)), a.each(e.Plugins, a.proxy(function (a, b) {
      this._plugins[a.charAt(0).toLowerCase() + a.slice(1)] = new b(this);
    }, this)), a.each(e.Workers, a.proxy(function (b, c) {
      this._pipe.push({
        filter: c.filter,
        run: a.proxy(c.run, this)
      });
    }, this)), this.setup(), this.initialize();
  }
  e.Defaults = {
    items: 3,
    loop: !1,
    center: !1,
    rewind: !1,
    checkVisibility: !0,
    mouseDrag: !0,
    touchDrag: !0,
    pullDrag: !0,
    freeDrag: !1,
    margin: 0,
    stagePadding: 0,
    merge: !1,
    mergeFit: !0,
    autoWidth: !1,
    startPosition: 0,
    rtl: !1,
    smartSpeed: 250,
    fluidSpeed: !1,
    dragEndSpeed: !1,
    responsive: {},
    responsiveRefreshRate: 200,
    responsiveBaseElement: b,
    fallbackEasing: "swing",
    slideTransition: "",
    info: !1,
    nestedItemSelector: !1,
    itemElement: "div",
    stageElement: "div",
    refreshClass: "owl-refresh",
    loadedClass: "owl-loaded",
    loadingClass: "owl-loading",
    rtlClass: "owl-rtl",
    responsiveClass: "owl-responsive",
    dragClass: "owl-drag",
    itemClass: "owl-item",
    stageClass: "owl-stage",
    stageOuterClass: "owl-stage-outer",
    grabClass: "owl-grab"
  }, e.Width = {
    Default: "default",
    Inner: "inner",
    Outer: "outer"
  }, e.Type = {
    Event: "event",
    State: "state"
  }, e.Plugins = {}, e.Workers = [{
    filter: ["width", "settings"],
    run: function run() {
      this._width = this.$element.width();
    }
  }, {
    filter: ["width", "items", "settings"],
    run: function run(a) {
      a.current = this._items && this._items[this.relative(this._current)];
    }
  }, {
    filter: ["items", "settings"],
    run: function run() {
      this.$stage.children(".cloned").remove();
    }
  }, {
    filter: ["width", "items", "settings"],
    run: function run(a) {
      var b = this.settings.margin || "",
        c = !this.settings.autoWidth,
        d = this.settings.rtl,
        e = {
          width: "auto",
          "margin-left": d ? b : "",
          "margin-right": d ? "" : b
        };
      !c && this.$stage.children().css(e), a.css = e;
    }
  }, {
    filter: ["width", "items", "settings"],
    run: function run(a) {
      var b = (this.width() / this.settings.items).toFixed(3) - this.settings.margin,
        c = null,
        d = this._items.length,
        e = !this.settings.autoWidth,
        f = [];
      for (a.items = {
        merge: !1,
        width: b
      }; d--;) {
        c = this._mergers[d], c = this.settings.mergeFit && Math.min(c, this.settings.items) || c, a.items.merge = c > 1 || a.items.merge, f[d] = e ? b * c : this._items[d].width();
      }
      this._widths = f;
    }
  }, {
    filter: ["items", "settings"],
    run: function run() {
      var b = [],
        c = this._items,
        d = this.settings,
        e = Math.max(2 * d.items, 4),
        f = 2 * Math.ceil(c.length / 2),
        g = d.loop && c.length ? d.rewind ? e : Math.max(e, f) : 0,
        h = "",
        i = "";
      for (g /= 2; g > 0;) {
        b.push(this.normalize(b.length / 2, !0)), h += c[b[b.length - 1]][0].outerHTML, b.push(this.normalize(c.length - 1 - (b.length - 1) / 2, !0)), i = c[b[b.length - 1]][0].outerHTML + i, g -= 1;
      }
      this._clones = b, a(h).addClass("cloned").appendTo(this.$stage), a(i).addClass("cloned").prependTo(this.$stage);
    }
  }, {
    filter: ["width", "items", "settings"],
    run: function run() {
      for (var a = this.settings.rtl ? 1 : -1, b = this._clones.length + this._items.length, c = -1, d = 0, e = 0, f = []; ++c < b;) {
        d = f[c - 1] || 0, e = this._widths[this.relative(c)] + this.settings.margin, f.push(d + e * a);
      }
      this._coordinates = f;
    }
  }, {
    filter: ["width", "items", "settings"],
    run: function run() {
      var a = this.settings.stagePadding,
        b = this._coordinates,
        c = {
          width: Math.ceil(Math.abs(b[b.length - 1])) + 2 * a,
          "padding-left": a || "",
          "padding-right": a || ""
        };
      this.$stage.css(c);
    }
  }, {
    filter: ["width", "items", "settings"],
    run: function run(a) {
      var b = this._coordinates.length,
        c = !this.settings.autoWidth,
        d = this.$stage.children();
      if (c && a.items.merge) for (; b--;) {
        a.css.width = this._widths[this.relative(b)], d.eq(b).css(a.css);
      } else c && (a.css.width = a.items.width, d.css(a.css));
    }
  }, {
    filter: ["items"],
    run: function run() {
      this._coordinates.length < 1 && this.$stage.removeAttr("style");
    }
  }, {
    filter: ["width", "items", "settings"],
    run: function run(a) {
      a.current = a.current ? this.$stage.children().index(a.current) : 0, a.current = Math.max(this.minimum(), Math.min(this.maximum(), a.current)), this.reset(a.current);
    }
  }, {
    filter: ["position"],
    run: function run() {
      this.animate(this.coordinates(this._current));
    }
  }, {
    filter: ["width", "position", "items", "settings"],
    run: function run() {
      var a,
        b,
        c,
        d,
        e = this.settings.rtl ? 1 : -1,
        f = 2 * this.settings.stagePadding,
        g = this.coordinates(this.current()) + f,
        h = g + this.width() * e,
        i = [];
      for (c = 0, d = this._coordinates.length; c < d; c++) {
        a = this._coordinates[c - 1] || 0, b = Math.abs(this._coordinates[c]) + f * e, (this.op(a, "<=", g) && this.op(a, ">", h) || this.op(b, "<", g) && this.op(b, ">", h)) && i.push(c);
      }
      this.$stage.children(".active").removeClass("active"), this.$stage.children(":eq(" + i.join("), :eq(") + ")").addClass("active"), this.$stage.children(".center").removeClass("center"), this.settings.center && this.$stage.children().eq(this.current()).addClass("center");
    }
  }], e.prototype.initializeStage = function () {
    this.$stage = this.$element.find("." + this.settings.stageClass), this.$stage.length || (this.$element.addClass(this.options.loadingClass), this.$stage = a("<" + this.settings.stageElement + ">", {
      "class": this.settings.stageClass
    }).wrap(a("<div/>", {
      "class": this.settings.stageOuterClass
    })), this.$element.append(this.$stage.parent()));
  }, e.prototype.initializeItems = function () {
    var b = this.$element.find(".owl-item");
    if (b.length) return this._items = b.get().map(function (b) {
      return a(b);
    }), this._mergers = this._items.map(function () {
      return 1;
    }), void this.refresh();
    this.replace(this.$element.children().not(this.$stage.parent())), this.isVisible() ? this.refresh() : this.invalidate("width"), this.$element.removeClass(this.options.loadingClass).addClass(this.options.loadedClass);
  }, e.prototype.initialize = function () {
    if (this.enter("initializing"), this.trigger("initialize"), this.$element.toggleClass(this.settings.rtlClass, this.settings.rtl), this.settings.autoWidth && !this.is("pre-loading")) {
      var a, b, c;
      a = this.$element.find("img"), b = this.settings.nestedItemSelector ? "." + this.settings.nestedItemSelector : d, c = this.$element.children(b).width(), a.length && c <= 0 && this.preloadAutoWidthImages(a);
    }
    this.initializeStage(), this.initializeItems(), this.registerEventHandlers(), this.leave("initializing"), this.trigger("initialized");
  }, e.prototype.isVisible = function () {
    return !this.settings.checkVisibility || this.$element.is(":visible");
  }, e.prototype.setup = function () {
    var b = this.viewport(),
      c = this.options.responsive,
      d = -1,
      e = null;
    c ? (a.each(c, function (a) {
      a <= b && a > d && (d = Number(a));
    }), e = a.extend({}, this.options, c[d]), "function" == typeof e.stagePadding && (e.stagePadding = e.stagePadding()), delete e.responsive, e.responsiveClass && this.$element.attr("class", this.$element.attr("class").replace(new RegExp("(" + this.options.responsiveClass + "-)\\S+\\s", "g"), "$1" + d))) : e = a.extend({}, this.options), this.trigger("change", {
      property: {
        name: "settings",
        value: e
      }
    }), this._breakpoint = d, this.settings = e, this.invalidate("settings"), this.trigger("changed", {
      property: {
        name: "settings",
        value: this.settings
      }
    });
  }, e.prototype.optionsLogic = function () {
    this.settings.autoWidth && (this.settings.stagePadding = !1, this.settings.merge = !1);
  }, e.prototype.prepare = function (b) {
    var c = this.trigger("prepare", {
      content: b
    });
    return c.data || (c.data = a("<" + this.settings.itemElement + "/>").addClass(this.options.itemClass).append(b)), this.trigger("prepared", {
      content: c.data
    }), c.data;
  }, e.prototype.update = function () {
    for (var b = 0, c = this._pipe.length, d = a.proxy(function (a) {
        return this[a];
      }, this._invalidated), e = {}; b < c;) {
      (this._invalidated.all || a.grep(this._pipe[b].filter, d).length > 0) && this._pipe[b].run(e), b++;
    }
    this._invalidated = {}, !this.is("valid") && this.enter("valid");
  }, e.prototype.width = function (a) {
    switch (a = a || e.Width.Default) {
      case e.Width.Inner:
      case e.Width.Outer:
        return this._width;
      default:
        return this._width - 2 * this.settings.stagePadding + this.settings.margin;
    }
  }, e.prototype.refresh = function () {
    this.enter("refreshing"), this.trigger("refresh"), this.setup(), this.optionsLogic(), this.$element.addClass(this.options.refreshClass), this.update(), this.$element.removeClass(this.options.refreshClass), this.leave("refreshing"), this.trigger("refreshed");
  }, e.prototype.onThrottledResize = function () {
    b.clearTimeout(this.resizeTimer), this.resizeTimer = b.setTimeout(this._handlers.onResize, this.settings.responsiveRefreshRate);
  }, e.prototype.onResize = function () {
    return !!this._items.length && this._width !== this.$element.width() && !!this.isVisible() && (this.enter("resizing"), this.trigger("resize").isDefaultPrevented() ? (this.leave("resizing"), !1) : (this.invalidate("width"), this.refresh(), this.leave("resizing"), void this.trigger("resized")));
  }, e.prototype.registerEventHandlers = function () {
    a.support.transition && this.$stage.on(a.support.transition.end + ".owl.core", a.proxy(this.onTransitionEnd, this)), !1 !== this.settings.responsive && this.on(b, "resize", this._handlers.onThrottledResize), this.settings.mouseDrag && (this.$element.addClass(this.options.dragClass), this.$stage.on("mousedown.owl.core", a.proxy(this.onDragStart, this)), this.$stage.on("dragstart.owl.core selectstart.owl.core", function () {
      return !1;
    })), this.settings.touchDrag && (this.$stage.on("touchstart.owl.core", a.proxy(this.onDragStart, this)), this.$stage.on("touchcancel.owl.core", a.proxy(this.onDragEnd, this)));
  }, e.prototype.onDragStart = function (b) {
    var d = null;
    3 !== b.which && (a.support.transform ? (d = this.$stage.css("transform").replace(/.*\(|\)| /g, "").split(","), d = {
      x: d[16 === d.length ? 12 : 4],
      y: d[16 === d.length ? 13 : 5]
    }) : (d = this.$stage.position(), d = {
      x: this.settings.rtl ? d.left + this.$stage.width() - this.width() + this.settings.margin : d.left,
      y: d.top
    }), this.is("animating") && (a.support.transform ? this.animate(d.x) : this.$stage.stop(), this.invalidate("position")), this.$element.toggleClass(this.options.grabClass, "mousedown" === b.type), this.speed(0), this._drag.time = new Date().getTime(), this._drag.target = a(b.target), this._drag.stage.start = d, this._drag.stage.current = d, this._drag.pointer = this.pointer(b), a(c).on("mouseup.owl.core touchend.owl.core", a.proxy(this.onDragEnd, this)), a(c).one("mousemove.owl.core touchmove.owl.core", a.proxy(function (b) {
      var d = this.difference(this._drag.pointer, this.pointer(b));
      a(c).on("mousemove.owl.core touchmove.owl.core", a.proxy(this.onDragMove, this)), Math.abs(d.x) < Math.abs(d.y) && this.is("valid") || (b.preventDefault(), this.enter("dragging"), this.trigger("drag"));
    }, this)));
  }, e.prototype.onDragMove = function (a) {
    var b = null,
      c = null,
      d = null,
      e = this.difference(this._drag.pointer, this.pointer(a)),
      f = this.difference(this._drag.stage.start, e);
    this.is("dragging") && (a.preventDefault(), this.settings.loop ? (b = this.coordinates(this.minimum()), c = this.coordinates(this.maximum() + 1) - b, f.x = ((f.x - b) % c + c) % c + b) : (b = this.settings.rtl ? this.coordinates(this.maximum()) : this.coordinates(this.minimum()), c = this.settings.rtl ? this.coordinates(this.minimum()) : this.coordinates(this.maximum()), d = this.settings.pullDrag ? -1 * e.x / 5 : 0, f.x = Math.max(Math.min(f.x, b + d), c + d)), this._drag.stage.current = f, this.animate(f.x));
  }, e.prototype.onDragEnd = function (b) {
    var d = this.difference(this._drag.pointer, this.pointer(b)),
      e = this._drag.stage.current,
      f = d.x > 0 ^ this.settings.rtl ? "left" : "right";
    a(c).off(".owl.core"), this.$element.removeClass(this.options.grabClass), (0 !== d.x && this.is("dragging") || !this.is("valid")) && (this.speed(this.settings.dragEndSpeed || this.settings.smartSpeed), this.current(this.closest(e.x, 0 !== d.x ? f : this._drag.direction)), this.invalidate("position"), this.update(), this._drag.direction = f, (Math.abs(d.x) > 3 || new Date().getTime() - this._drag.time > 300) && this._drag.target.one("click.owl.core", function () {
      return !1;
    })), this.is("dragging") && (this.leave("dragging"), this.trigger("dragged"));
  }, e.prototype.closest = function (b, c) {
    var e = -1,
      f = 30,
      g = this.width(),
      h = this.coordinates();
    return this.settings.freeDrag || a.each(h, a.proxy(function (a, i) {
      return "left" === c && b > i - f && b < i + f ? e = a : "right" === c && b > i - g - f && b < i - g + f ? e = a + 1 : this.op(b, "<", i) && this.op(b, ">", h[a + 1] !== d ? h[a + 1] : i - g) && (e = "left" === c ? a + 1 : a), -1 === e;
    }, this)), this.settings.loop || (this.op(b, ">", h[this.minimum()]) ? e = b = this.minimum() : this.op(b, "<", h[this.maximum()]) && (e = b = this.maximum())), e;
  }, e.prototype.animate = function (b) {
    var c = this.speed() > 0;
    this.is("animating") && this.onTransitionEnd(), c && (this.enter("animating"), this.trigger("translate")), a.support.transform3d && a.support.transition ? this.$stage.css({
      transform: "translate3d(" + b + "px,0px,0px)",
      transition: this.speed() / 1e3 + "s" + (this.settings.slideTransition ? " " + this.settings.slideTransition : "")
    }) : c ? this.$stage.animate({
      left: b + "px"
    }, this.speed(), this.settings.fallbackEasing, a.proxy(this.onTransitionEnd, this)) : this.$stage.css({
      left: b + "px"
    });
  }, e.prototype.is = function (a) {
    return this._states.current[a] && this._states.current[a] > 0;
  }, e.prototype.current = function (a) {
    if (a === d) return this._current;
    if (0 === this._items.length) return d;
    if (a = this.normalize(a), this._current !== a) {
      var b = this.trigger("change", {
        property: {
          name: "position",
          value: a
        }
      });
      b.data !== d && (a = this.normalize(b.data)), this._current = a, this.invalidate("position"), this.trigger("changed", {
        property: {
          name: "position",
          value: this._current
        }
      });
    }
    return this._current;
  }, e.prototype.invalidate = function (b) {
    return "string" === a.type(b) && (this._invalidated[b] = !0, this.is("valid") && this.leave("valid")), a.map(this._invalidated, function (a, b) {
      return b;
    });
  }, e.prototype.reset = function (a) {
    (a = this.normalize(a)) !== d && (this._speed = 0, this._current = a, this.suppress(["translate", "translated"]), this.animate(this.coordinates(a)), this.release(["translate", "translated"]));
  }, e.prototype.normalize = function (a, b) {
    var c = this._items.length,
      e = b ? 0 : this._clones.length;
    return !this.isNumeric(a) || c < 1 ? a = d : (a < 0 || a >= c + e) && (a = ((a - e / 2) % c + c) % c + e / 2), a;
  }, e.prototype.relative = function (a) {
    return a -= this._clones.length / 2, this.normalize(a, !0);
  }, e.prototype.maximum = function (a) {
    var b,
      c,
      d,
      e = this.settings,
      f = this._coordinates.length;
    if (e.loop) f = this._clones.length / 2 + this._items.length - 1;else if (e.autoWidth || e.merge) {
      if (b = this._items.length) for (c = this._items[--b].width(), d = this.$element.width(); b-- && !((c += this._items[b].width() + this.settings.margin) > d);) {
        ;
      }
      f = b + 1;
    } else f = e.center ? this._items.length - 1 : this._items.length - e.items;
    return a && (f -= this._clones.length / 2), Math.max(f, 0);
  }, e.prototype.minimum = function (a) {
    return a ? 0 : this._clones.length / 2;
  }, e.prototype.items = function (a) {
    return a === d ? this._items.slice() : (a = this.normalize(a, !0), this._items[a]);
  }, e.prototype.mergers = function (a) {
    return a === d ? this._mergers.slice() : (a = this.normalize(a, !0), this._mergers[a]);
  }, e.prototype.clones = function (b) {
    var c = this._clones.length / 2,
      e = c + this._items.length,
      f = function f(a) {
        return a % 2 == 0 ? e + a / 2 : c - (a + 1) / 2;
      };
    return b === d ? a.map(this._clones, function (a, b) {
      return f(b);
    }) : a.map(this._clones, function (a, c) {
      return a === b ? f(c) : null;
    });
  }, e.prototype.speed = function (a) {
    return a !== d && (this._speed = a), this._speed;
  }, e.prototype.coordinates = function (b) {
    var c,
      e = 1,
      f = b - 1;
    return b === d ? a.map(this._coordinates, a.proxy(function (a, b) {
      return this.coordinates(b);
    }, this)) : (this.settings.center ? (this.settings.rtl && (e = -1, f = b + 1), c = this._coordinates[b], c += (this.width() - c + (this._coordinates[f] || 0)) / 2 * e) : c = this._coordinates[f] || 0, c = Math.ceil(c));
  }, e.prototype.duration = function (a, b, c) {
    return 0 === c ? 0 : Math.min(Math.max(Math.abs(b - a), 1), 6) * Math.abs(c || this.settings.smartSpeed);
  }, e.prototype.to = function (a, b) {
    var c = this.current(),
      d = null,
      e = a - this.relative(c),
      f = (e > 0) - (e < 0),
      g = this._items.length,
      h = this.minimum(),
      i = this.maximum();
    this.settings.loop ? (!this.settings.rewind && Math.abs(e) > g / 2 && (e += -1 * f * g), a = c + e, (d = ((a - h) % g + g) % g + h) !== a && d - e <= i && d - e > 0 && (c = d - e, a = d, this.reset(c))) : this.settings.rewind ? (i += 1, a = (a % i + i) % i) : a = Math.max(h, Math.min(i, a)), this.speed(this.duration(c, a, b)), this.current(a), this.isVisible() && this.update();
  }, e.prototype.next = function (a) {
    a = a || !1, this.to(this.relative(this.current()) + 1, a);
  }, e.prototype.prev = function (a) {
    a = a || !1, this.to(this.relative(this.current()) - 1, a);
  }, e.prototype.onTransitionEnd = function (a) {
    if (a !== d && (a.stopPropagation(), (a.target || a.srcElement || a.originalTarget) !== this.$stage.get(0))) return !1;
    this.leave("animating"), this.trigger("translated");
  }, e.prototype.viewport = function () {
    var d;
    return this.options.responsiveBaseElement !== b ? d = a(this.options.responsiveBaseElement).width() : b.innerWidth ? d = b.innerWidth : c.documentElement && c.documentElement.clientWidth ? d = c.documentElement.clientWidth : console.warn("Can not detect viewport width."), d;
  }, e.prototype.replace = function (b) {
    this.$stage.empty(), this._items = [], b && (b = b instanceof jQuery ? b : a(b)), this.settings.nestedItemSelector && (b = b.find("." + this.settings.nestedItemSelector)), b.filter(function () {
      return 1 === this.nodeType;
    }).each(a.proxy(function (a, b) {
      b = this.prepare(b), this.$stage.append(b), this._items.push(b), this._mergers.push(1 * b.find("[data-merge]").addBack("[data-merge]").attr("data-merge") || 1);
    }, this)), this.reset(this.isNumeric(this.settings.startPosition) ? this.settings.startPosition : 0), this.invalidate("items");
  }, e.prototype.add = function (b, c) {
    var e = this.relative(this._current);
    c = c === d ? this._items.length : this.normalize(c, !0), b = b instanceof jQuery ? b : a(b), this.trigger("add", {
      content: b,
      position: c
    }), b = this.prepare(b), 0 === this._items.length || c === this._items.length ? (0 === this._items.length && this.$stage.append(b), 0 !== this._items.length && this._items[c - 1].after(b), this._items.push(b), this._mergers.push(1 * b.find("[data-merge]").addBack("[data-merge]").attr("data-merge") || 1)) : (this._items[c].before(b), this._items.splice(c, 0, b), this._mergers.splice(c, 0, 1 * b.find("[data-merge]").addBack("[data-merge]").attr("data-merge") || 1)), this._items[e] && this.reset(this._items[e].index()), this.invalidate("items"), this.trigger("added", {
      content: b,
      position: c
    });
  }, e.prototype.remove = function (a) {
    (a = this.normalize(a, !0)) !== d && (this.trigger("remove", {
      content: this._items[a],
      position: a
    }), this._items[a].remove(), this._items.splice(a, 1), this._mergers.splice(a, 1), this.invalidate("items"), this.trigger("removed", {
      content: null,
      position: a
    }));
  }, e.prototype.preloadAutoWidthImages = function (b) {
    b.each(a.proxy(function (b, c) {
      this.enter("pre-loading"), c = a(c), a(new Image()).one("load", a.proxy(function (a) {
        c.attr("src", a.target.src), c.css("opacity", 1), this.leave("pre-loading"), !this.is("pre-loading") && !this.is("initializing") && this.refresh();
      }, this)).attr("src", c.attr("src") || c.attr("data-src") || c.attr("data-src-retina"));
    }, this));
  }, e.prototype.destroy = function () {
    this.$element.off(".owl.core"), this.$stage.off(".owl.core"), a(c).off(".owl.core"), !1 !== this.settings.responsive && (b.clearTimeout(this.resizeTimer), this.off(b, "resize", this._handlers.onThrottledResize));
    for (var d in this._plugins) {
      this._plugins[d].destroy();
    }
    this.$stage.children(".cloned").remove(), this.$stage.unwrap(), this.$stage.children().contents().unwrap(), this.$stage.children().unwrap(), this.$stage.remove(), this.$element.removeClass(this.options.refreshClass).removeClass(this.options.loadingClass).removeClass(this.options.loadedClass).removeClass(this.options.rtlClass).removeClass(this.options.dragClass).removeClass(this.options.grabClass).attr("class", this.$element.attr("class").replace(new RegExp(this.options.responsiveClass + "-\\S+\\s", "g"), "")).removeData("owl.carousel");
  }, e.prototype.op = function (a, b, c) {
    var d = this.settings.rtl;
    switch (b) {
      case "<":
        return d ? a > c : a < c;
      case ">":
        return d ? a < c : a > c;
      case ">=":
        return d ? a <= c : a >= c;
      case "<=":
        return d ? a >= c : a <= c;
    }
  }, e.prototype.on = function (a, b, c, d) {
    a.addEventListener ? a.addEventListener(b, c, d) : a.attachEvent && a.attachEvent("on" + b, c);
  }, e.prototype.off = function (a, b, c, d) {
    a.removeEventListener ? a.removeEventListener(b, c, d) : a.detachEvent && a.detachEvent("on" + b, c);
  }, e.prototype.trigger = function (b, c, d, f, g) {
    var h = {
        item: {
          count: this._items.length,
          index: this.current()
        }
      },
      i = a.camelCase(a.grep(["on", b, d], function (a) {
        return a;
      }).join("-").toLowerCase()),
      j = a.Event([b, "owl", d || "carousel"].join(".").toLowerCase(), a.extend({
        relatedTarget: this
      }, h, c));
    return this._supress[b] || (a.each(this._plugins, function (a, b) {
      b.onTrigger && b.onTrigger(j);
    }), this.register({
      type: e.Type.Event,
      name: b
    }), this.$element.trigger(j), this.settings && "function" == typeof this.settings[i] && this.settings[i].call(this, j)), j;
  }, e.prototype.enter = function (b) {
    a.each([b].concat(this._states.tags[b] || []), a.proxy(function (a, b) {
      this._states.current[b] === d && (this._states.current[b] = 0), this._states.current[b]++;
    }, this));
  }, e.prototype.leave = function (b) {
    a.each([b].concat(this._states.tags[b] || []), a.proxy(function (a, b) {
      this._states.current[b]--;
    }, this));
  }, e.prototype.register = function (b) {
    if (b.type === e.Type.Event) {
      if (a.event.special[b.name] || (a.event.special[b.name] = {}), !a.event.special[b.name].owl) {
        var c = a.event.special[b.name]._default;
        a.event.special[b.name]._default = function (a) {
          return !c || !c.apply || a.namespace && -1 !== a.namespace.indexOf("owl") ? a.namespace && a.namespace.indexOf("owl") > -1 : c.apply(this, arguments);
        }, a.event.special[b.name].owl = !0;
      }
    } else b.type === e.Type.State && (this._states.tags[b.name] ? this._states.tags[b.name] = this._states.tags[b.name].concat(b.tags) : this._states.tags[b.name] = b.tags, this._states.tags[b.name] = a.grep(this._states.tags[b.name], a.proxy(function (c, d) {
      return a.inArray(c, this._states.tags[b.name]) === d;
    }, this)));
  }, e.prototype.suppress = function (b) {
    a.each(b, a.proxy(function (a, b) {
      this._supress[b] = !0;
    }, this));
  }, e.prototype.release = function (b) {
    a.each(b, a.proxy(function (a, b) {
      delete this._supress[b];
    }, this));
  }, e.prototype.pointer = function (a) {
    var c = {
      x: null,
      y: null
    };
    return a = a.originalEvent || a || b.event, a = a.touches && a.touches.length ? a.touches[0] : a.changedTouches && a.changedTouches.length ? a.changedTouches[0] : a, a.pageX ? (c.x = a.pageX, c.y = a.pageY) : (c.x = a.clientX, c.y = a.clientY), c;
  }, e.prototype.isNumeric = function (a) {
    return !isNaN(parseFloat(a));
  }, e.prototype.difference = function (a, b) {
    return {
      x: a.x - b.x,
      y: a.y - b.y
    };
  }, a.fn.owlCarousel = function (b) {
    var c = Array.prototype.slice.call(arguments, 1);
    return this.each(function () {
      var d = a(this),
        f = d.data("owl.carousel");
      f || (f = new e(this, "object" == _typeof(b) && b), d.data("owl.carousel", f), a.each(["next", "prev", "to", "destroy", "refresh", "replace", "add", "remove"], function (b, c) {
        f.register({
          type: e.Type.Event,
          name: c
        }), f.$element.on(c + ".owl.carousel.core", a.proxy(function (a) {
          a.namespace && a.relatedTarget !== this && (this.suppress([c]), f[c].apply(this, [].slice.call(arguments, 1)), this.release([c]));
        }, f));
      })), "string" == typeof b && "_" !== b.charAt(0) && f[b].apply(f, c);
    });
  }, a.fn.owlCarousel.Constructor = e;
}(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
  var e = function e(b) {
    this._core = b, this._interval = null, this._visible = null, this._handlers = {
      "initialized.owl.carousel": a.proxy(function (a) {
        a.namespace && this._core.settings.autoRefresh && this.watch();
      }, this)
    }, this._core.options = a.extend({}, e.Defaults, this._core.options), this._core.$element.on(this._handlers);
  };
  e.Defaults = {
    autoRefresh: !0,
    autoRefreshInterval: 500
  }, e.prototype.watch = function () {
    this._interval || (this._visible = this._core.isVisible(), this._interval = b.setInterval(a.proxy(this.refresh, this), this._core.settings.autoRefreshInterval));
  }, e.prototype.refresh = function () {
    this._core.isVisible() !== this._visible && (this._visible = !this._visible, this._core.$element.toggleClass("owl-hidden", !this._visible), this._visible && this._core.invalidate("width") && this._core.refresh());
  }, e.prototype.destroy = function () {
    var a, c;
    b.clearInterval(this._interval);
    for (a in this._handlers) {
      this._core.$element.off(a, this._handlers[a]);
    }
    for (c in Object.getOwnPropertyNames(this)) {
      "function" != typeof this[c] && (this[c] = null);
    }
  }, a.fn.owlCarousel.Constructor.Plugins.AutoRefresh = e;
}(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
  var e = function e(b) {
    this._core = b, this._loaded = [], this._handlers = {
      "initialized.owl.carousel change.owl.carousel resized.owl.carousel": a.proxy(function (b) {
        if (b.namespace && this._core.settings && this._core.settings.lazyLoad && (b.property && "position" == b.property.name || "initialized" == b.type)) {
          var c = this._core.settings,
            e = c.center && Math.ceil(c.items / 2) || c.items,
            f = c.center && -1 * e || 0,
            g = (b.property && b.property.value !== d ? b.property.value : this._core.current()) + f,
            h = this._core.clones().length,
            i = a.proxy(function (a, b) {
              this.load(b);
            }, this);
          for (c.lazyLoadEager > 0 && (e += c.lazyLoadEager, c.loop && (g -= c.lazyLoadEager, e++)); f++ < e;) {
            this.load(h / 2 + this._core.relative(g)), h && a.each(this._core.clones(this._core.relative(g)), i), g++;
          }
        }
      }, this)
    }, this._core.options = a.extend({}, e.Defaults, this._core.options), this._core.$element.on(this._handlers);
  };
  e.Defaults = {
    lazyLoad: !1,
    lazyLoadEager: 0
  }, e.prototype.load = function (c) {
    var d = this._core.$stage.children().eq(c),
      e = d && d.find(".owl-lazy");
    !e || a.inArray(d.get(0), this._loaded) > -1 || (e.each(a.proxy(function (c, d) {
      var e,
        f = a(d),
        g = b.devicePixelRatio > 1 && f.attr("data-src-retina") || f.attr("data-src") || f.attr("data-srcset");
      this._core.trigger("load", {
        element: f,
        url: g
      }, "lazy"), f.is("img") ? f.one("load.owl.lazy", a.proxy(function () {
        f.css("opacity", 1), this._core.trigger("loaded", {
          element: f,
          url: g
        }, "lazy");
      }, this)).attr("src", g) : f.is("source") ? f.one("load.owl.lazy", a.proxy(function () {
        this._core.trigger("loaded", {
          element: f,
          url: g
        }, "lazy");
      }, this)).attr("srcset", g) : (e = new Image(), e.onload = a.proxy(function () {
        f.css({
          "background-image": 'url("' + g + '")',
          opacity: "1"
        }), this._core.trigger("loaded", {
          element: f,
          url: g
        }, "lazy");
      }, this), e.src = g);
    }, this)), this._loaded.push(d.get(0)));
  }, e.prototype.destroy = function () {
    var a, b;
    for (a in this.handlers) {
      this._core.$element.off(a, this.handlers[a]);
    }
    for (b in Object.getOwnPropertyNames(this)) {
      "function" != typeof this[b] && (this[b] = null);
    }
  }, a.fn.owlCarousel.Constructor.Plugins.Lazy = e;
}(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
  var e = function e(c) {
    this._core = c, this._previousHeight = null, this._handlers = {
      "initialized.owl.carousel refreshed.owl.carousel": a.proxy(function (a) {
        a.namespace && this._core.settings.autoHeight && this.update();
      }, this),
      "changed.owl.carousel": a.proxy(function (a) {
        a.namespace && this._core.settings.autoHeight && "position" === a.property.name && this.update();
      }, this),
      "loaded.owl.lazy": a.proxy(function (a) {
        a.namespace && this._core.settings.autoHeight && a.element.closest("." + this._core.settings.itemClass).index() === this._core.current() && this.update();
      }, this)
    }, this._core.options = a.extend({}, e.Defaults, this._core.options), this._core.$element.on(this._handlers), this._intervalId = null;
    var d = this;
    a(b).on("load", function () {
      d._core.settings.autoHeight && d.update();
    }), a(b).resize(function () {
      d._core.settings.autoHeight && (null != d._intervalId && clearTimeout(d._intervalId), d._intervalId = setTimeout(function () {
        d.update();
      }, 250));
    });
  };
  e.Defaults = {
    autoHeight: !1,
    autoHeightClass: "owl-height"
  }, e.prototype.update = function () {
    var b = this._core._current,
      c = b + this._core.settings.items,
      d = this._core.settings.lazyLoad,
      e = this._core.$stage.children().toArray().slice(b, c),
      f = [],
      g = 0;
    a.each(e, function (b, c) {
      f.push(a(c).height());
    }), g = Math.max.apply(null, f), g <= 1 && d && this._previousHeight && (g = this._previousHeight), this._previousHeight = g, this._core.$stage.parent().height(g).addClass(this._core.settings.autoHeightClass);
  }, e.prototype.destroy = function () {
    var a, b;
    for (a in this._handlers) {
      this._core.$element.off(a, this._handlers[a]);
    }
    for (b in Object.getOwnPropertyNames(this)) {
      "function" != typeof this[b] && (this[b] = null);
    }
  }, a.fn.owlCarousel.Constructor.Plugins.AutoHeight = e;
}(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
  var e = function e(b) {
    this._core = b, this._videos = {}, this._playing = null, this._handlers = {
      "initialized.owl.carousel": a.proxy(function (a) {
        a.namespace && this._core.register({
          type: "state",
          name: "playing",
          tags: ["interacting"]
        });
      }, this),
      "resize.owl.carousel": a.proxy(function (a) {
        a.namespace && this._core.settings.video && this.isInFullScreen() && a.preventDefault();
      }, this),
      "refreshed.owl.carousel": a.proxy(function (a) {
        a.namespace && this._core.is("resizing") && this._core.$stage.find(".cloned .owl-video-frame").remove();
      }, this),
      "changed.owl.carousel": a.proxy(function (a) {
        a.namespace && "position" === a.property.name && this._playing && this.stop();
      }, this),
      "prepared.owl.carousel": a.proxy(function (b) {
        if (b.namespace) {
          var c = a(b.content).find(".owl-video");
          c.length && (c.css("display", "none"), this.fetch(c, a(b.content)));
        }
      }, this)
    }, this._core.options = a.extend({}, e.Defaults, this._core.options), this._core.$element.on(this._handlers), this._core.$element.on("click.owl.video", ".owl-video-play-icon", a.proxy(function (a) {
      this.play(a);
    }, this));
  };
  e.Defaults = {
    video: !1,
    videoHeight: !1,
    videoWidth: !1
  }, e.prototype.fetch = function (a, b) {
    var c = function () {
        return a.attr("data-vimeo-id") ? "vimeo" : a.attr("data-vzaar-id") ? "vzaar" : "youtube";
      }(),
      d = a.attr("data-vimeo-id") || a.attr("data-youtube-id") || a.attr("data-vzaar-id"),
      e = a.attr("data-width") || this._core.settings.videoWidth,
      f = a.attr("data-height") || this._core.settings.videoHeight,
      g = a.attr("href");
    if (!g) throw new Error("Missing video URL.");
    if (d = g.match(/(http:|https:|)\/\/(player.|www.|app.)?(vimeo\.com|youtu(be\.com|\.be|be\.googleapis\.com|be\-nocookie\.com)|vzaar\.com)\/(video\/|videos\/|embed\/|channels\/.+\/|groups\/.+\/|watch\?v=|v\/)?([A-Za-z0-9._%-]*)(\&\S+)?/), d[3].indexOf("youtu") > -1) c = "youtube";else if (d[3].indexOf("vimeo") > -1) c = "vimeo";else {
      if (!(d[3].indexOf("vzaar") > -1)) throw new Error("Video URL not supported.");
      c = "vzaar";
    }
    d = d[6], this._videos[g] = {
      type: c,
      id: d,
      width: e,
      height: f
    }, b.attr("data-video", g), this.thumbnail(a, this._videos[g]);
  }, e.prototype.thumbnail = function (b, c) {
    var d,
      e,
      f,
      g = c.width && c.height ? "width:" + c.width + "px;height:" + c.height + "px;" : "",
      h = b.find("img"),
      i = "src",
      j = "",
      k = this._core.settings,
      l = function l(c) {
        e = '<div class="owl-video-play-icon"></div>', d = k.lazyLoad ? a("<div/>", {
          "class": "owl-video-tn " + j,
          srcType: c
        }) : a("<div/>", {
          "class": "owl-video-tn",
          style: "opacity:1;background-image:url(" + c + ")"
        }), b.after(d), b.after(e);
      };
    if (b.wrap(a("<div/>", {
      "class": "owl-video-wrapper",
      style: g
    })), this._core.settings.lazyLoad && (i = "data-src", j = "owl-lazy"), h.length) return l(h.attr(i)), h.remove(), !1;
    "youtube" === c.type ? (f = "//img.youtube.com/vi/" + c.id + "/hqdefault.jpg", l(f)) : "vimeo" === c.type ? a.ajax({
      type: "GET",
      url: "//vimeo.com/api/v2/video/" + c.id + ".json",
      jsonp: "callback",
      dataType: "jsonp",
      success: function success(a) {
        f = a[0].thumbnail_large, l(f);
      }
    }) : "vzaar" === c.type && a.ajax({
      type: "GET",
      url: "//vzaar.com/api/videos/" + c.id + ".json",
      jsonp: "callback",
      dataType: "jsonp",
      success: function success(a) {
        f = a.framegrab_url, l(f);
      }
    });
  }, e.prototype.stop = function () {
    this._core.trigger("stop", null, "video"), this._playing.find(".owl-video-frame").remove(), this._playing.removeClass("owl-video-playing"), this._playing = null, this._core.leave("playing"), this._core.trigger("stopped", null, "video");
  }, e.prototype.play = function (b) {
    var c,
      d = a(b.target),
      e = d.closest("." + this._core.settings.itemClass),
      f = this._videos[e.attr("data-video")],
      g = f.width || "100%",
      h = f.height || this._core.$stage.height();
    this._playing || (this._core.enter("playing"), this._core.trigger("play", null, "video"), e = this._core.items(this._core.relative(e.index())), this._core.reset(e.index()), c = a('<iframe frameborder="0" allowfullscreen mozallowfullscreen webkitAllowFullScreen ></iframe>'), c.attr("height", h), c.attr("width", g), "youtube" === f.type ? c.attr("src", "//www.youtube.com/embed/" + f.id + "?autoplay=1&rel=0&v=" + f.id) : "vimeo" === f.type ? c.attr("src", "//player.vimeo.com/video/" + f.id + "?autoplay=1") : "vzaar" === f.type && c.attr("src", "//view.vzaar.com/" + f.id + "/player?autoplay=true"), a(c).wrap('<div class="owl-video-frame" />').insertAfter(e.find(".owl-video")), this._playing = e.addClass("owl-video-playing"));
  }, e.prototype.isInFullScreen = function () {
    var b = c.fullscreenElement || c.mozFullScreenElement || c.webkitFullscreenElement;
    return b && a(b).parent().hasClass("owl-video-frame");
  }, e.prototype.destroy = function () {
    var a, b;
    this._core.$element.off("click.owl.video");
    for (a in this._handlers) {
      this._core.$element.off(a, this._handlers[a]);
    }
    for (b in Object.getOwnPropertyNames(this)) {
      "function" != typeof this[b] && (this[b] = null);
    }
  }, a.fn.owlCarousel.Constructor.Plugins.Video = e;
}(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
  var e = function e(b) {
    this.core = b, this.core.options = a.extend({}, e.Defaults, this.core.options), this.swapping = !0, this.previous = d, this.next = d, this.handlers = {
      "change.owl.carousel": a.proxy(function (a) {
        a.namespace && "position" == a.property.name && (this.previous = this.core.current(), this.next = a.property.value);
      }, this),
      "drag.owl.carousel dragged.owl.carousel translated.owl.carousel": a.proxy(function (a) {
        a.namespace && (this.swapping = "translated" == a.type);
      }, this),
      "translate.owl.carousel": a.proxy(function (a) {
        a.namespace && this.swapping && (this.core.options.animateOut || this.core.options.animateIn) && this.swap();
      }, this)
    }, this.core.$element.on(this.handlers);
  };
  e.Defaults = {
    animateOut: !1,
    animateIn: !1
  }, e.prototype.swap = function () {
    if (1 === this.core.settings.items && a.support.animation && a.support.transition) {
      this.core.speed(0);
      var b,
        c = a.proxy(this.clear, this),
        d = this.core.$stage.children().eq(this.previous),
        e = this.core.$stage.children().eq(this.next),
        f = this.core.settings.animateIn,
        g = this.core.settings.animateOut;
      this.core.current() !== this.previous && (g && (b = this.core.coordinates(this.previous) - this.core.coordinates(this.next), d.one(a.support.animation.end, c).css({
        left: b + "px"
      }).addClass("animated owl-animated-out").addClass(g)), f && e.one(a.support.animation.end, c).addClass("animated owl-animated-in").addClass(f));
    }
  }, e.prototype.clear = function (b) {
    a(b.target).css({
      left: ""
    }).removeClass("animated owl-animated-out owl-animated-in").removeClass(this.core.settings.animateIn).removeClass(this.core.settings.animateOut), this.core.onTransitionEnd();
  }, e.prototype.destroy = function () {
    var a, b;
    for (a in this.handlers) {
      this.core.$element.off(a, this.handlers[a]);
    }
    for (b in Object.getOwnPropertyNames(this)) {
      "function" != typeof this[b] && (this[b] = null);
    }
  }, a.fn.owlCarousel.Constructor.Plugins.Animate = e;
}(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
  var e = function e(b) {
    this._core = b, this._call = null, this._time = 0, this._timeout = 0, this._paused = !0, this._handlers = {
      "changed.owl.carousel": a.proxy(function (a) {
        a.namespace && "settings" === a.property.name ? this._core.settings.autoplay ? this.play() : this.stop() : a.namespace && "position" === a.property.name && this._paused && (this._time = 0);
      }, this),
      "initialized.owl.carousel": a.proxy(function (a) {
        a.namespace && this._core.settings.autoplay && this.play();
      }, this),
      "play.owl.autoplay": a.proxy(function (a, b, c) {
        a.namespace && this.play(b, c);
      }, this),
      "stop.owl.autoplay": a.proxy(function (a) {
        a.namespace && this.stop();
      }, this),
      "mouseover.owl.autoplay": a.proxy(function () {
        this._core.settings.autoplayHoverPause && this._core.is("rotating") && this.pause();
      }, this),
      "mouseleave.owl.autoplay": a.proxy(function () {
        this._core.settings.autoplayHoverPause && this._core.is("rotating") && this.play();
      }, this),
      "touchstart.owl.core": a.proxy(function () {
        this._core.settings.autoplayHoverPause && this._core.is("rotating") && this.pause();
      }, this),
      "touchend.owl.core": a.proxy(function () {
        this._core.settings.autoplayHoverPause && this.play();
      }, this)
    }, this._core.$element.on(this._handlers), this._core.options = a.extend({}, e.Defaults, this._core.options);
  };
  e.Defaults = {
    autoplay: !1,
    autoplayTimeout: 5e3,
    autoplayHoverPause: !1,
    autoplaySpeed: !1
  }, e.prototype._next = function (d) {
    this._call = b.setTimeout(a.proxy(this._next, this, d), this._timeout * (Math.round(this.read() / this._timeout) + 1) - this.read()), this._core.is("interacting") || c.hidden || this._core.next(d || this._core.settings.autoplaySpeed);
  }, e.prototype.read = function () {
    return new Date().getTime() - this._time;
  }, e.prototype.play = function (c, d) {
    var e;
    this._core.is("rotating") || this._core.enter("rotating"), c = c || this._core.settings.autoplayTimeout, e = Math.min(this._time % (this._timeout || c), c), this._paused ? (this._time = this.read(), this._paused = !1) : b.clearTimeout(this._call), this._time += this.read() % c - e, this._timeout = c, this._call = b.setTimeout(a.proxy(this._next, this, d), c - e);
  }, e.prototype.stop = function () {
    this._core.is("rotating") && (this._time = 0, this._paused = !0, b.clearTimeout(this._call), this._core.leave("rotating"));
  }, e.prototype.pause = function () {
    this._core.is("rotating") && !this._paused && (this._time = this.read(), this._paused = !0, b.clearTimeout(this._call));
  }, e.prototype.destroy = function () {
    var a, b;
    this.stop();
    for (a in this._handlers) {
      this._core.$element.off(a, this._handlers[a]);
    }
    for (b in Object.getOwnPropertyNames(this)) {
      "function" != typeof this[b] && (this[b] = null);
    }
  }, a.fn.owlCarousel.Constructor.Plugins.autoplay = e;
}(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
  "use strict";

  var e = function e(b) {
    this._core = b, this._initialized = !1, this._pages = [], this._controls = {}, this._templates = [], this.$element = this._core.$element, this._overrides = {
      next: this._core.next,
      prev: this._core.prev,
      to: this._core.to
    }, this._handlers = {
      "prepared.owl.carousel": a.proxy(function (b) {
        b.namespace && this._core.settings.dotsData && this._templates.push('<div class="' + this._core.settings.dotClass + '">' + a(b.content).find("[data-dot]").addBack("[data-dot]").attr("data-dot") + "</div>");
      }, this),
      "added.owl.carousel": a.proxy(function (a) {
        a.namespace && this._core.settings.dotsData && this._templates.splice(a.position, 0, this._templates.pop());
      }, this),
      "remove.owl.carousel": a.proxy(function (a) {
        a.namespace && this._core.settings.dotsData && this._templates.splice(a.position, 1);
      }, this),
      "changed.owl.carousel": a.proxy(function (a) {
        a.namespace && "position" == a.property.name && this.draw();
      }, this),
      "initialized.owl.carousel": a.proxy(function (a) {
        a.namespace && !this._initialized && (this._core.trigger("initialize", null, "navigation"), this.initialize(), this.update(), this.draw(), this._initialized = !0, this._core.trigger("initialized", null, "navigation"));
      }, this),
      "refreshed.owl.carousel": a.proxy(function (a) {
        a.namespace && this._initialized && (this._core.trigger("refresh", null, "navigation"), this.update(), this.draw(), this._core.trigger("refreshed", null, "navigation"));
      }, this)
    }, this._core.options = a.extend({}, e.Defaults, this._core.options), this.$element.on(this._handlers);
  };
  e.Defaults = {
    nav: !1,
    navText: ['<span aria-label="Previous">&#x2039;</span>', '<span aria-label="Next">&#x203a;</span>'],
    navSpeed: !1,
    navElement: 'button type="button" role="presentation"',
    navContainer: !1,
    navContainerClass: "owl-nav",
    navClass: ["owl-prev", "owl-next"],
    slideBy: 1,
    dotClass: "owl-dot",
    dotsClass: "owl-dots",
    dots: !0,
    dotsEach: !1,
    dotsData: !1,
    dotsSpeed: !1,
    dotsContainer: !1
  }, e.prototype.initialize = function () {
    var b,
      c = this._core.settings;
    this._controls.$relative = (c.navContainer ? a(c.navContainer) : a("<div>").addClass(c.navContainerClass).appendTo(this.$element)).addClass("disabled"), this._controls.$previous = a("<" + c.navElement + ">").addClass(c.navClass[0]).html(c.navText[0]).prependTo(this._controls.$relative).on("click", a.proxy(function (a) {
      this.prev(c.navSpeed);
    }, this)), this._controls.$next = a("<" + c.navElement + ">").addClass(c.navClass[1]).html(c.navText[1]).appendTo(this._controls.$relative).on("click", a.proxy(function (a) {
      this.next(c.navSpeed);
    }, this)), c.dotsData || (this._templates = [a('<button role="button">').addClass(c.dotClass).append(a("<span>")).prop("outerHTML")]), this._controls.$absolute = (c.dotsContainer ? a(c.dotsContainer) : a("<div>").addClass(c.dotsClass).appendTo(this.$element)).addClass("disabled"), this._controls.$absolute.on("click", "button", a.proxy(function (b) {
      var d = a(b.target).parent().is(this._controls.$absolute) ? a(b.target).index() : a(b.target).parent().index();
      b.preventDefault(), this.to(d, c.dotsSpeed);
    }, this));
    for (b in this._overrides) {
      this._core[b] = a.proxy(this[b], this);
    }
  }, e.prototype.destroy = function () {
    var a, b, c, d, e;
    e = this._core.settings;
    for (a in this._handlers) {
      this.$element.off(a, this._handlers[a]);
    }
    for (b in this._controls) {
      "$relative" === b && e.navContainer ? this._controls[b].html("") : this._controls[b].remove();
    }
    for (d in this.overides) {
      this._core[d] = this._overrides[d];
    }
    for (c in Object.getOwnPropertyNames(this)) {
      "function" != typeof this[c] && (this[c] = null);
    }
  }, e.prototype.update = function () {
    var a,
      b,
      c,
      d = this._core.clones().length / 2,
      e = d + this._core.items().length,
      f = this._core.maximum(!0),
      g = this._core.settings,
      h = g.center || g.autoWidth || g.dotsData ? 1 : g.dotsEach || g.items;
    if ("page" !== g.slideBy && (g.slideBy = Math.min(g.slideBy, g.items)), g.dots || "page" == g.slideBy) for (this._pages = [], a = d, b = 0, c = 0; a < e; a++) {
      if (b >= h || 0 === b) {
        if (this._pages.push({
          start: Math.min(f, a - d),
          end: a - d + h - 1
        }), Math.min(f, a - d) === f) break;
        b = 0, ++c;
      }
      b += this._core.mergers(this._core.relative(a));
    }
  }, e.prototype.draw = function () {
    var b,
      c = this._core.settings,
      d = this._core.items().length <= c.items,
      e = this._core.relative(this._core.current()),
      f = c.loop || c.rewind;
    this._controls.$relative.toggleClass("disabled", !c.nav || d), c.nav && (this._controls.$previous.toggleClass("disabled", !f && e <= this._core.minimum(!0)), this._controls.$next.toggleClass("disabled", !f && e >= this._core.maximum(!0))), this._controls.$absolute.toggleClass("disabled", !c.dots || d), c.dots && (b = this._pages.length - this._controls.$absolute.children().length, c.dotsData && 0 !== b ? this._controls.$absolute.html(this._templates.join("")) : b > 0 ? this._controls.$absolute.append(new Array(b + 1).join(this._templates[0])) : b < 0 && this._controls.$absolute.children().slice(b).remove(), this._controls.$absolute.find(".active").removeClass("active"), this._controls.$absolute.children().eq(a.inArray(this.current(), this._pages)).addClass("active"));
  }, e.prototype.onTrigger = function (b) {
    var c = this._core.settings;
    b.page = {
      index: a.inArray(this.current(), this._pages),
      count: this._pages.length,
      size: c && (c.center || c.autoWidth || c.dotsData ? 1 : c.dotsEach || c.items)
    };
  }, e.prototype.current = function () {
    var b = this._core.relative(this._core.current());
    return a.grep(this._pages, a.proxy(function (a, c) {
      return a.start <= b && a.end >= b;
    }, this)).pop();
  }, e.prototype.getPosition = function (b) {
    var c,
      d,
      e = this._core.settings;
    return "page" == e.slideBy ? (c = a.inArray(this.current(), this._pages), d = this._pages.length, b ? ++c : --c, c = this._pages[(c % d + d) % d].start) : (c = this._core.relative(this._core.current()), d = this._core.items().length, b ? c += e.slideBy : c -= e.slideBy), c;
  }, e.prototype.next = function (b) {
    a.proxy(this._overrides.to, this._core)(this.getPosition(!0), b);
  }, e.prototype.prev = function (b) {
    a.proxy(this._overrides.to, this._core)(this.getPosition(!1), b);
  }, e.prototype.to = function (b, c, d) {
    var e;
    !d && this._pages.length ? (e = this._pages.length, a.proxy(this._overrides.to, this._core)(this._pages[(b % e + e) % e].start, c)) : a.proxy(this._overrides.to, this._core)(b, c);
  }, a.fn.owlCarousel.Constructor.Plugins.Navigation = e;
}(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
  "use strict";

  var e = function e(c) {
    this._core = c, this._hashes = {}, this.$element = this._core.$element, this._handlers = {
      "initialized.owl.carousel": a.proxy(function (c) {
        c.namespace && "URLHash" === this._core.settings.startPosition && a(b).trigger("hashchange.owl.navigation");
      }, this),
      "prepared.owl.carousel": a.proxy(function (b) {
        if (b.namespace) {
          var c = a(b.content).find("[data-hash]").addBack("[data-hash]").attr("data-hash");
          if (!c) return;
          this._hashes[c] = b.content;
        }
      }, this),
      "changed.owl.carousel": a.proxy(function (c) {
        if (c.namespace && "position" === c.property.name) {
          var d = this._core.items(this._core.relative(this._core.current())),
            e = a.map(this._hashes, function (a, b) {
              return a === d ? b : null;
            }).join();
          if (!e || b.location.hash.slice(1) === e) return;
          b.location.hash = e;
        }
      }, this)
    }, this._core.options = a.extend({}, e.Defaults, this._core.options), this.$element.on(this._handlers), a(b).on("hashchange.owl.navigation", a.proxy(function (a) {
      var c = b.location.hash.substring(1),
        e = this._core.$stage.children(),
        f = this._hashes[c] && e.index(this._hashes[c]);
      f !== d && f !== this._core.current() && this._core.to(this._core.relative(f), !1, !0);
    }, this));
  };
  e.Defaults = {
    URLhashListener: !1
  }, e.prototype.destroy = function () {
    var c, d;
    a(b).off("hashchange.owl.navigation");
    for (c in this._handlers) {
      this._core.$element.off(c, this._handlers[c]);
    }
    for (d in Object.getOwnPropertyNames(this)) {
      "function" != typeof this[d] && (this[d] = null);
    }
  }, a.fn.owlCarousel.Constructor.Plugins.Hash = e;
}(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
  function e(b, c) {
    var e = !1,
      f = b.charAt(0).toUpperCase() + b.slice(1);
    return a.each((b + " " + h.join(f + " ") + f).split(" "), function (a, b) {
      if (g[b] !== d) return e = !c || b, !1;
    }), e;
  }
  function f(a) {
    return e(a, !0);
  }
  var g = a("<support>").get(0).style,
    h = "Webkit Moz O ms".split(" "),
    i = {
      transition: {
        end: {
          WebkitTransition: "webkitTransitionEnd",
          MozTransition: "transitionend",
          OTransition: "oTransitionEnd",
          transition: "transitionend"
        }
      },
      animation: {
        end: {
          WebkitAnimation: "webkitAnimationEnd",
          MozAnimation: "animationend",
          OAnimation: "oAnimationEnd",
          animation: "animationend"
        }
      }
    },
    j = {
      csstransforms: function csstransforms() {
        return !!e("transform");
      },
      csstransforms3d: function csstransforms3d() {
        return !!e("perspective");
      },
      csstransitions: function csstransitions() {
        return !!e("transition");
      },
      cssanimations: function cssanimations() {
        return !!e("animation");
      }
    };
  j.csstransitions() && (a.support.transition = new String(f("transition")), a.support.transition.end = i.transition.end[a.support.transition]), j.cssanimations() && (a.support.animation = new String(f("animation")), a.support.animation.end = i.animation.end[a.support.animation]), j.csstransforms() && (a.support.transform = new String(f("transform")), a.support.transform3d = j.csstransforms3d());
}(window.Zepto || window.jQuery, window, document);

/***/ }),

/***/ "./public/frontend/default/vendors/responsive_table/js/tablesaw.stackonly.js":
/*!***********************************************************************************!*\
  !*** ./public/frontend/default/vendors/responsive_table/js/tablesaw.stackonly.js ***!
  \***********************************************************************************/
/***/ (() => {

!function (t) {
  var e = document.createElement("div"),
    a = e.getElementsByTagName("i"),
    i = t(document.documentElement);
  e.innerHTML = "\x3c!--[if lte IE 8]><i></i><![endif]--\x3e", a[0] && i.addClass("ie-lte8"), "querySelector" in document && (!window.blackberry || window.WebKitPoint) && !window.operamini && (i.addClass("tablesaw-enhanced"), t(function () {
    t(document).trigger("enhance.tablesaw");
  }));
}(jQuery), "undefined" == typeof Tablesaw && (Tablesaw = {
  i18n: {
    modes: ["Stack", "Swipe", "Toggle"],
    columns: 'Col<span class="a11y-sm">umn</span>s',
    columnBtnText: "Columns",
    columnsDialogError: "No eligible columns.",
    sort: "Sort"
  }
}), Tablesaw.config || (Tablesaw.config = {}), function (t) {
  var e = "tablesaw-bar",
    a = "tablesawcreate",
    i = "tablesawdestroy",
    s = "tablesawrefresh",
    l = function l(e) {
      if (!e) throw new Error("Tablesaw requires an element.");
      this.table = e, this.$table = t(e), this.mode = this.$table.attr("data-tablesaw-mode") || "stack", this.init();
    };
  l.prototype.init = function () {
    this.$table.attr("id") || this.$table.attr("id", "table-" + Math.round(1e4 * Math.random())), this.createToolbar();
    var t = this._initCells();
    this.$table.trigger(a, [this, t]);
  }, l.prototype._initCells = function () {
    var e,
      a = this.table.querySelectorAll("thead tr"),
      i = this;
    return t(a).each(function () {
      var s = 0;
      t(this).children().each(function () {
        var l = parseInt(this.getAttribute("colspan"), 10),
          n = ":nth-child(" + (s + 1) + ")";
        if (e = s + 1, l) for (var o = 0; o < l - 1; o++) {
          n += ", :nth-child(" + (++s + 1) + ")";
        }
        this.cells = i.$table.find("tr").not(t(a).eq(0)).not(this).children(n), s++;
      });
    }), e;
  }, l.prototype.refresh = function () {
    this._initCells(), this.$table.trigger(s);
  }, l.prototype.createToolbar = function () {
    var a = this.$table.prev("." + e);
    a.length || (a = t("<div>").addClass(e).insertBefore(this.$table)), this.$toolbar = a, this.mode && this.$toolbar.addClass("mode-" + this.mode);
  }, l.prototype.destroy = function () {
    this.$table.prev("." + e).each(function () {
      this.className = this.className.replace(/\bmode\-\w*\b/gi, "");
    });
    var a = this.$table.attr("id");
    t(document).unbind("." + a), t(window).unbind("." + a), this.$table.trigger(i, [this]), this.$table.removeAttr("data-tablesaw-mode"), this.$table.removeData("table");
  }, t.fn.table = function () {
    return this.each(function () {
      var e = t(this);
      if (!e.data("table")) {
        var a = new l(this);
        e.data("table", a);
      }
    });
  }, t(document).on("enhance.tablesaw", function (e) {
    t(e.target).find("table[data-tablesaw-mode],table[data-tablesaw-sortable]").table();
  });
}(jQuery), function (t, e, a) {
  var i = "tablesaw-stack",
    s = "tablesaw-cell-label",
    l = "tablesaw-cell-content",
    n = "tablesaw-stack",
    o = "data-tablesaw-no-labels",
    r = "data-tablesaw-hide-empty",
    h = function h(t) {
      this.$table = e(t), this.labelless = this.$table.is("[" + o + "]"), this.hideempty = this.$table.is("[" + r + "]"), this.labelless || (this.allHeaders = this.$table.find("th")), this.$table.data(n, this);
    };
  h.prototype.init = function (t) {
    if (this.$table.addClass(i), !this.labelless) {
      var a = e(this.allHeaders),
        n = this.hideempty;
      a.each(function () {
        var a = e(this),
          i = e(this.cells).filter(function () {
            return !(e(this).parent().is("[" + o + "]") || n && e(this).is(":empty"));
          }),
          r = i.not(this).filter("thead th").length && " tablesaw-cell-label-top",
          h = a.find(".tablesaw-sortable-btn"),
          b = h.length ? h.html() : a.html();
        if ("" !== b) if (r) {
          var c = parseInt(e(this).attr("colspan"), 10),
            d = "";
          c && (d = "td:nth-child(" + c + "n + " + t + ")"), i.filter(d).prepend("<b class='" + s + r + "'>" + b + "</b>");
        } else i.wrapInner("<span class='" + l + "'></span>"), i.prepend("<b class='" + s + "'>" + b + "</b>");
      });
    }
  }, h.prototype.destroy = function () {
    this.$table.removeClass(i), this.$table.find("." + s).remove(), this.$table.find("." + l).each(function () {
      e(this).replaceWith(this.childNodes);
    });
  }, e(document).on("tablesawcreate", function (t, e, a) {
    "stack" === e.mode && new h(e.table).init(a);
  }), e(document).on("tablesawdestroy", function (t, a) {
    "stack" === a.mode && e(a.table).data(n).destroy();
  });
}(0, jQuery);

/***/ }),

/***/ "./resources/js/frontend/default/app.js":
/*!**********************************************!*\
  !*** ./resources/js/frontend/default/app.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ./bootstrap */ "./resources/js/frontend/default/bootstrap.js");

/***/ }),

/***/ "./resources/js/frontend/default/bootstrap.js":
/*!****************************************************!*\
  !*** ./resources/js/frontend/default/bootstrap.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

window._ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
try {
  window.Popper = (__webpack_require__(/*! popper.js */ "./node_modules/popper.js/dist/esm/popper.js")["default"]);
  window.$ = window.jQuery = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js");
  var dir = $('html').attr('dir');
  if (dir == 'rtl') {
    __webpack_require__(/*! bootstrap-v4-rtl */ "./node_modules/bootstrap-v4-rtl/dist/js/bootstrap.js");
  } else {
    __webpack_require__(/*! bootstrap */ "./node_modules/bootstrap/dist/js/bootstrap.esm.js");
  }
} catch (e) {}
window.toastr = __webpack_require__(/*! toastr */ "./node_modules/toastr/toastr.js");
// require('jquery-ui/ui/widgets/sortable') ;

/***/ }),

/***/ "./node_modules/bootstrap-v4-rtl/dist/js/bootstrap.js":
/*!************************************************************!*\
  !*** ./node_modules/bootstrap-v4-rtl/dist/js/bootstrap.js ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/*!
  * Bootstrap v4.6.0-2 (https://github.com/MahdiMajidzadeh/bootstrap-v4-rtl)
  * Copyright 2011-2021 Mahdi Majidzadeh
  * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
  */
(function (global, factory) {
   true ? factory(exports, __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js"), __webpack_require__(/*! popper.js */ "./node_modules/popper.js/dist/esm/popper.js")) :
  0;
}(this, (function (exports, $, Popper) { 'use strict';

  function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

  var $__default = /*#__PURE__*/_interopDefaultLegacy($);
  var Popper__default = /*#__PURE__*/_interopDefaultLegacy(Popper);

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _inheritsLoose(subClass, superClass) {
    subClass.prototype = Object.create(superClass.prototype);
    subClass.prototype.constructor = subClass;
    subClass.__proto__ = superClass;
  }

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v4.6.0): util.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  /**
   * ------------------------------------------------------------------------
   * Private TransitionEnd Helpers
   * ------------------------------------------------------------------------
   */

  var TRANSITION_END = 'transitionend';
  var MAX_UID = 1000000;
  var MILLISECONDS_MULTIPLIER = 1000; // Shoutout AngusCroll (https://goo.gl/pxwQGp)

  function toType(obj) {
    if (obj === null || typeof obj === 'undefined') {
      return "" + obj;
    }

    return {}.toString.call(obj).match(/\s([a-z]+)/i)[1].toLowerCase();
  }

  function getSpecialTransitionEndEvent() {
    return {
      bindType: TRANSITION_END,
      delegateType: TRANSITION_END,
      handle: function handle(event) {
        if ($__default['default'](event.target).is(this)) {
          return event.handleObj.handler.apply(this, arguments); // eslint-disable-line prefer-rest-params
        }

        return undefined;
      }
    };
  }

  function transitionEndEmulator(duration) {
    var _this = this;

    var called = false;
    $__default['default'](this).one(Util.TRANSITION_END, function () {
      called = true;
    });
    setTimeout(function () {
      if (!called) {
        Util.triggerTransitionEnd(_this);
      }
    }, duration);
    return this;
  }

  function setTransitionEndSupport() {
    $__default['default'].fn.emulateTransitionEnd = transitionEndEmulator;
    $__default['default'].event.special[Util.TRANSITION_END] = getSpecialTransitionEndEvent();
  }
  /**
   * --------------------------------------------------------------------------
   * Public Util Api
   * --------------------------------------------------------------------------
   */


  var Util = {
    TRANSITION_END: 'bsTransitionEnd',
    getUID: function getUID(prefix) {
      do {
        prefix += ~~(Math.random() * MAX_UID); // "~~" acts like a faster Math.floor() here
      } while (document.getElementById(prefix));

      return prefix;
    },
    getSelectorFromElement: function getSelectorFromElement(element) {
      var selector = element.getAttribute('data-target');

      if (!selector || selector === '#') {
        var hrefAttr = element.getAttribute('href');
        selector = hrefAttr && hrefAttr !== '#' ? hrefAttr.trim() : '';
      }

      try {
        return document.querySelector(selector) ? selector : null;
      } catch (_) {
        return null;
      }
    },
    getTransitionDurationFromElement: function getTransitionDurationFromElement(element) {
      if (!element) {
        return 0;
      } // Get transition-duration of the element


      var transitionDuration = $__default['default'](element).css('transition-duration');
      var transitionDelay = $__default['default'](element).css('transition-delay');
      var floatTransitionDuration = parseFloat(transitionDuration);
      var floatTransitionDelay = parseFloat(transitionDelay); // Return 0 if element or transition duration is not found

      if (!floatTransitionDuration && !floatTransitionDelay) {
        return 0;
      } // If multiple durations are defined, take the first


      transitionDuration = transitionDuration.split(',')[0];
      transitionDelay = transitionDelay.split(',')[0];
      return (parseFloat(transitionDuration) + parseFloat(transitionDelay)) * MILLISECONDS_MULTIPLIER;
    },
    reflow: function reflow(element) {
      return element.offsetHeight;
    },
    triggerTransitionEnd: function triggerTransitionEnd(element) {
      $__default['default'](element).trigger(TRANSITION_END);
    },
    supportsTransitionEnd: function supportsTransitionEnd() {
      return Boolean(TRANSITION_END);
    },
    isElement: function isElement(obj) {
      return (obj[0] || obj).nodeType;
    },
    typeCheckConfig: function typeCheckConfig(componentName, config, configTypes) {
      for (var property in configTypes) {
        if (Object.prototype.hasOwnProperty.call(configTypes, property)) {
          var expectedTypes = configTypes[property];
          var value = config[property];
          var valueType = value && Util.isElement(value) ? 'element' : toType(value);

          if (!new RegExp(expectedTypes).test(valueType)) {
            throw new Error(componentName.toUpperCase() + ": " + ("Option \"" + property + "\" provided type \"" + valueType + "\" ") + ("but expected type \"" + expectedTypes + "\"."));
          }
        }
      }
    },
    findShadowRoot: function findShadowRoot(element) {
      if (!document.documentElement.attachShadow) {
        return null;
      } // Can find the shadow root otherwise it'll return the document


      if (typeof element.getRootNode === 'function') {
        var root = element.getRootNode();
        return root instanceof ShadowRoot ? root : null;
      }

      if (element instanceof ShadowRoot) {
        return element;
      } // when we don't find a shadow root


      if (!element.parentNode) {
        return null;
      }

      return Util.findShadowRoot(element.parentNode);
    },
    jQueryDetection: function jQueryDetection() {
      if (typeof $__default['default'] === 'undefined') {
        throw new TypeError('Bootstrap\'s JavaScript requires jQuery. jQuery must be included before Bootstrap\'s JavaScript.');
      }

      var version = $__default['default'].fn.jquery.split(' ')[0].split('.');
      var minMajor = 1;
      var ltMajor = 2;
      var minMinor = 9;
      var minPatch = 1;
      var maxMajor = 4;

      if (version[0] < ltMajor && version[1] < minMinor || version[0] === minMajor && version[1] === minMinor && version[2] < minPatch || version[0] >= maxMajor) {
        throw new Error('Bootstrap\'s JavaScript requires at least jQuery v1.9.1 but less than v4.0.0');
      }
    }
  };
  Util.jQueryDetection();
  setTransitionEndSupport();

  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  var NAME = 'alert';
  var VERSION = '4.6.0';
  var DATA_KEY = 'bs.alert';
  var EVENT_KEY = "." + DATA_KEY;
  var DATA_API_KEY = '.data-api';
  var JQUERY_NO_CONFLICT = $__default['default'].fn[NAME];
  var SELECTOR_DISMISS = '[data-dismiss="alert"]';
  var EVENT_CLOSE = "close" + EVENT_KEY;
  var EVENT_CLOSED = "closed" + EVENT_KEY;
  var EVENT_CLICK_DATA_API = "click" + EVENT_KEY + DATA_API_KEY;
  var CLASS_NAME_ALERT = 'alert';
  var CLASS_NAME_FADE = 'fade';
  var CLASS_NAME_SHOW = 'show';
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  var Alert = /*#__PURE__*/function () {
    function Alert(element) {
      this._element = element;
    } // Getters


    var _proto = Alert.prototype;

    // Public
    _proto.close = function close(element) {
      var rootElement = this._element;

      if (element) {
        rootElement = this._getRootElement(element);
      }

      var customEvent = this._triggerCloseEvent(rootElement);

      if (customEvent.isDefaultPrevented()) {
        return;
      }

      this._removeElement(rootElement);
    };

    _proto.dispose = function dispose() {
      $__default['default'].removeData(this._element, DATA_KEY);
      this._element = null;
    } // Private
    ;

    _proto._getRootElement = function _getRootElement(element) {
      var selector = Util.getSelectorFromElement(element);
      var parent = false;

      if (selector) {
        parent = document.querySelector(selector);
      }

      if (!parent) {
        parent = $__default['default'](element).closest("." + CLASS_NAME_ALERT)[0];
      }

      return parent;
    };

    _proto._triggerCloseEvent = function _triggerCloseEvent(element) {
      var closeEvent = $__default['default'].Event(EVENT_CLOSE);
      $__default['default'](element).trigger(closeEvent);
      return closeEvent;
    };

    _proto._removeElement = function _removeElement(element) {
      var _this = this;

      $__default['default'](element).removeClass(CLASS_NAME_SHOW);

      if (!$__default['default'](element).hasClass(CLASS_NAME_FADE)) {
        this._destroyElement(element);

        return;
      }

      var transitionDuration = Util.getTransitionDurationFromElement(element);
      $__default['default'](element).one(Util.TRANSITION_END, function (event) {
        return _this._destroyElement(element, event);
      }).emulateTransitionEnd(transitionDuration);
    };

    _proto._destroyElement = function _destroyElement(element) {
      $__default['default'](element).detach().trigger(EVENT_CLOSED).remove();
    } // Static
    ;

    Alert._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var $element = $__default['default'](this);
        var data = $element.data(DATA_KEY);

        if (!data) {
          data = new Alert(this);
          $element.data(DATA_KEY, data);
        }

        if (config === 'close') {
          data[config](this);
        }
      });
    };

    Alert._handleDismiss = function _handleDismiss(alertInstance) {
      return function (event) {
        if (event) {
          event.preventDefault();
        }

        alertInstance.close(this);
      };
    };

    _createClass(Alert, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION;
      }
    }]);

    return Alert;
  }();
  /**
   * ------------------------------------------------------------------------
   * Data Api implementation
   * ------------------------------------------------------------------------
   */


  $__default['default'](document).on(EVENT_CLICK_DATA_API, SELECTOR_DISMISS, Alert._handleDismiss(new Alert()));
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   */

  $__default['default'].fn[NAME] = Alert._jQueryInterface;
  $__default['default'].fn[NAME].Constructor = Alert;

  $__default['default'].fn[NAME].noConflict = function () {
    $__default['default'].fn[NAME] = JQUERY_NO_CONFLICT;
    return Alert._jQueryInterface;
  };

  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  var NAME$1 = 'button';
  var VERSION$1 = '4.6.0';
  var DATA_KEY$1 = 'bs.button';
  var EVENT_KEY$1 = "." + DATA_KEY$1;
  var DATA_API_KEY$1 = '.data-api';
  var JQUERY_NO_CONFLICT$1 = $__default['default'].fn[NAME$1];
  var CLASS_NAME_ACTIVE = 'active';
  var CLASS_NAME_BUTTON = 'btn';
  var CLASS_NAME_FOCUS = 'focus';
  var SELECTOR_DATA_TOGGLE_CARROT = '[data-toggle^="button"]';
  var SELECTOR_DATA_TOGGLES = '[data-toggle="buttons"]';
  var SELECTOR_DATA_TOGGLE = '[data-toggle="button"]';
  var SELECTOR_DATA_TOGGLES_BUTTONS = '[data-toggle="buttons"] .btn';
  var SELECTOR_INPUT = 'input:not([type="hidden"])';
  var SELECTOR_ACTIVE = '.active';
  var SELECTOR_BUTTON = '.btn';
  var EVENT_CLICK_DATA_API$1 = "click" + EVENT_KEY$1 + DATA_API_KEY$1;
  var EVENT_FOCUS_BLUR_DATA_API = "focus" + EVENT_KEY$1 + DATA_API_KEY$1 + " " + ("blur" + EVENT_KEY$1 + DATA_API_KEY$1);
  var EVENT_LOAD_DATA_API = "load" + EVENT_KEY$1 + DATA_API_KEY$1;
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  var Button = /*#__PURE__*/function () {
    function Button(element) {
      this._element = element;
      this.shouldAvoidTriggerChange = false;
    } // Getters


    var _proto = Button.prototype;

    // Public
    _proto.toggle = function toggle() {
      var triggerChangeEvent = true;
      var addAriaPressed = true;
      var rootElement = $__default['default'](this._element).closest(SELECTOR_DATA_TOGGLES)[0];

      if (rootElement) {
        var input = this._element.querySelector(SELECTOR_INPUT);

        if (input) {
          if (input.type === 'radio') {
            if (input.checked && this._element.classList.contains(CLASS_NAME_ACTIVE)) {
              triggerChangeEvent = false;
            } else {
              var activeElement = rootElement.querySelector(SELECTOR_ACTIVE);

              if (activeElement) {
                $__default['default'](activeElement).removeClass(CLASS_NAME_ACTIVE);
              }
            }
          }

          if (triggerChangeEvent) {
            // if it's not a radio button or checkbox don't add a pointless/invalid checked property to the input
            if (input.type === 'checkbox' || input.type === 'radio') {
              input.checked = !this._element.classList.contains(CLASS_NAME_ACTIVE);
            }

            if (!this.shouldAvoidTriggerChange) {
              $__default['default'](input).trigger('change');
            }
          }

          input.focus();
          addAriaPressed = false;
        }
      }

      if (!(this._element.hasAttribute('disabled') || this._element.classList.contains('disabled'))) {
        if (addAriaPressed) {
          this._element.setAttribute('aria-pressed', !this._element.classList.contains(CLASS_NAME_ACTIVE));
        }

        if (triggerChangeEvent) {
          $__default['default'](this._element).toggleClass(CLASS_NAME_ACTIVE);
        }
      }
    };

    _proto.dispose = function dispose() {
      $__default['default'].removeData(this._element, DATA_KEY$1);
      this._element = null;
    } // Static
    ;

    Button._jQueryInterface = function _jQueryInterface(config, avoidTriggerChange) {
      return this.each(function () {
        var $element = $__default['default'](this);
        var data = $element.data(DATA_KEY$1);

        if (!data) {
          data = new Button(this);
          $element.data(DATA_KEY$1, data);
        }

        data.shouldAvoidTriggerChange = avoidTriggerChange;

        if (config === 'toggle') {
          data[config]();
        }
      });
    };

    _createClass(Button, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$1;
      }
    }]);

    return Button;
  }();
  /**
   * ------------------------------------------------------------------------
   * Data Api implementation
   * ------------------------------------------------------------------------
   */


  $__default['default'](document).on(EVENT_CLICK_DATA_API$1, SELECTOR_DATA_TOGGLE_CARROT, function (event) {
    var button = event.target;
    var initialButton = button;

    if (!$__default['default'](button).hasClass(CLASS_NAME_BUTTON)) {
      button = $__default['default'](button).closest(SELECTOR_BUTTON)[0];
    }

    if (!button || button.hasAttribute('disabled') || button.classList.contains('disabled')) {
      event.preventDefault(); // work around Firefox bug #1540995
    } else {
      var inputBtn = button.querySelector(SELECTOR_INPUT);

      if (inputBtn && (inputBtn.hasAttribute('disabled') || inputBtn.classList.contains('disabled'))) {
        event.preventDefault(); // work around Firefox bug #1540995

        return;
      }

      if (initialButton.tagName === 'INPUT' || button.tagName !== 'LABEL') {
        Button._jQueryInterface.call($__default['default'](button), 'toggle', initialButton.tagName === 'INPUT');
      }
    }
  }).on(EVENT_FOCUS_BLUR_DATA_API, SELECTOR_DATA_TOGGLE_CARROT, function (event) {
    var button = $__default['default'](event.target).closest(SELECTOR_BUTTON)[0];
    $__default['default'](button).toggleClass(CLASS_NAME_FOCUS, /^focus(in)?$/.test(event.type));
  });
  $__default['default'](window).on(EVENT_LOAD_DATA_API, function () {
    // ensure correct active class is set to match the controls' actual values/states
    // find all checkboxes/readio buttons inside data-toggle groups
    var buttons = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLES_BUTTONS));

    for (var i = 0, len = buttons.length; i < len; i++) {
      var button = buttons[i];
      var input = button.querySelector(SELECTOR_INPUT);

      if (input.checked || input.hasAttribute('checked')) {
        button.classList.add(CLASS_NAME_ACTIVE);
      } else {
        button.classList.remove(CLASS_NAME_ACTIVE);
      }
    } // find all button toggles


    buttons = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLE));

    for (var _i = 0, _len = buttons.length; _i < _len; _i++) {
      var _button = buttons[_i];

      if (_button.getAttribute('aria-pressed') === 'true') {
        _button.classList.add(CLASS_NAME_ACTIVE);
      } else {
        _button.classList.remove(CLASS_NAME_ACTIVE);
      }
    }
  });
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   */

  $__default['default'].fn[NAME$1] = Button._jQueryInterface;
  $__default['default'].fn[NAME$1].Constructor = Button;

  $__default['default'].fn[NAME$1].noConflict = function () {
    $__default['default'].fn[NAME$1] = JQUERY_NO_CONFLICT$1;
    return Button._jQueryInterface;
  };

  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  var NAME$2 = 'carousel';
  var VERSION$2 = '4.6.0';
  var DATA_KEY$2 = 'bs.carousel';
  var EVENT_KEY$2 = "." + DATA_KEY$2;
  var DATA_API_KEY$2 = '.data-api';
  var JQUERY_NO_CONFLICT$2 = $__default['default'].fn[NAME$2];
  var ARROW_LEFT_KEYCODE = 37; // KeyboardEvent.which value for left arrow key

  var ARROW_RIGHT_KEYCODE = 39; // KeyboardEvent.which value for right arrow key

  var TOUCHEVENT_COMPAT_WAIT = 500; // Time for mouse compat events to fire after touch

  var SWIPE_THRESHOLD = 40;
  var Default = {
    interval: 5000,
    keyboard: true,
    slide: false,
    pause: 'hover',
    wrap: true,
    touch: true
  };
  var DefaultType = {
    interval: '(number|boolean)',
    keyboard: 'boolean',
    slide: '(boolean|string)',
    pause: '(string|boolean)',
    wrap: 'boolean',
    touch: 'boolean'
  };
  var DIRECTION_NEXT = 'next';
  var DIRECTION_PREV = 'prev';
  var DIRECTION_LEFT = 'left';
  var DIRECTION_RIGHT = 'right';
  var EVENT_SLIDE = "slide" + EVENT_KEY$2;
  var EVENT_SLID = "slid" + EVENT_KEY$2;
  var EVENT_KEYDOWN = "keydown" + EVENT_KEY$2;
  var EVENT_MOUSEENTER = "mouseenter" + EVENT_KEY$2;
  var EVENT_MOUSELEAVE = "mouseleave" + EVENT_KEY$2;
  var EVENT_TOUCHSTART = "touchstart" + EVENT_KEY$2;
  var EVENT_TOUCHMOVE = "touchmove" + EVENT_KEY$2;
  var EVENT_TOUCHEND = "touchend" + EVENT_KEY$2;
  var EVENT_POINTERDOWN = "pointerdown" + EVENT_KEY$2;
  var EVENT_POINTERUP = "pointerup" + EVENT_KEY$2;
  var EVENT_DRAG_START = "dragstart" + EVENT_KEY$2;
  var EVENT_LOAD_DATA_API$1 = "load" + EVENT_KEY$2 + DATA_API_KEY$2;
  var EVENT_CLICK_DATA_API$2 = "click" + EVENT_KEY$2 + DATA_API_KEY$2;
  var CLASS_NAME_CAROUSEL = 'carousel';
  var CLASS_NAME_ACTIVE$1 = 'active';
  var CLASS_NAME_SLIDE = 'slide';
  var CLASS_NAME_RIGHT = 'carousel-item-right';
  var CLASS_NAME_LEFT = 'carousel-item-left';
  var CLASS_NAME_NEXT = 'carousel-item-next';
  var CLASS_NAME_PREV = 'carousel-item-prev';
  var CLASS_NAME_POINTER_EVENT = 'pointer-event';
  var SELECTOR_ACTIVE$1 = '.active';
  var SELECTOR_ACTIVE_ITEM = '.active.carousel-item';
  var SELECTOR_ITEM = '.carousel-item';
  var SELECTOR_ITEM_IMG = '.carousel-item img';
  var SELECTOR_NEXT_PREV = '.carousel-item-next, .carousel-item-prev';
  var SELECTOR_INDICATORS = '.carousel-indicators';
  var SELECTOR_DATA_SLIDE = '[data-slide], [data-slide-to]';
  var SELECTOR_DATA_RIDE = '[data-ride="carousel"]';
  var PointerType = {
    TOUCH: 'touch',
    PEN: 'pen'
  };
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  var Carousel = /*#__PURE__*/function () {
    function Carousel(element, config) {
      this._items = null;
      this._interval = null;
      this._activeElement = null;
      this._isPaused = false;
      this._isSliding = false;
      this.touchTimeout = null;
      this.touchStartX = 0;
      this.touchDeltaX = 0;
      this._config = this._getConfig(config);
      this._element = element;
      this._indicatorsElement = this._element.querySelector(SELECTOR_INDICATORS);
      this._touchSupported = 'ontouchstart' in document.documentElement || navigator.maxTouchPoints > 0;
      this._pointerEvent = Boolean(window.PointerEvent || window.MSPointerEvent);

      this._addEventListeners();
    } // Getters


    var _proto = Carousel.prototype;

    // Public
    _proto.next = function next() {
      if (!this._isSliding) {
        this._slide(DIRECTION_NEXT);
      }
    };

    _proto.nextWhenVisible = function nextWhenVisible() {
      var $element = $__default['default'](this._element); // Don't call next when the page isn't visible
      // or the carousel or its parent isn't visible

      if (!document.hidden && $element.is(':visible') && $element.css('visibility') !== 'hidden') {
        this.next();
      }
    };

    _proto.prev = function prev() {
      if (!this._isSliding) {
        this._slide(DIRECTION_PREV);
      }
    };

    _proto.pause = function pause(event) {
      if (!event) {
        this._isPaused = true;
      }

      if (this._element.querySelector(SELECTOR_NEXT_PREV)) {
        Util.triggerTransitionEnd(this._element);
        this.cycle(true);
      }

      clearInterval(this._interval);
      this._interval = null;
    };

    _proto.cycle = function cycle(event) {
      if (!event) {
        this._isPaused = false;
      }

      if (this._interval) {
        clearInterval(this._interval);
        this._interval = null;
      }

      if (this._config.interval && !this._isPaused) {
        this._updateInterval();

        this._interval = setInterval((document.visibilityState ? this.nextWhenVisible : this.next).bind(this), this._config.interval);
      }
    };

    _proto.to = function to(index) {
      var _this = this;

      this._activeElement = this._element.querySelector(SELECTOR_ACTIVE_ITEM);

      var activeIndex = this._getItemIndex(this._activeElement);

      if (index > this._items.length - 1 || index < 0) {
        return;
      }

      if (this._isSliding) {
        $__default['default'](this._element).one(EVENT_SLID, function () {
          return _this.to(index);
        });
        return;
      }

      if (activeIndex === index) {
        this.pause();
        this.cycle();
        return;
      }

      var direction = index > activeIndex ? DIRECTION_NEXT : DIRECTION_PREV;

      this._slide(direction, this._items[index]);
    };

    _proto.dispose = function dispose() {
      $__default['default'](this._element).off(EVENT_KEY$2);
      $__default['default'].removeData(this._element, DATA_KEY$2);
      this._items = null;
      this._config = null;
      this._element = null;
      this._interval = null;
      this._isPaused = null;
      this._isSliding = null;
      this._activeElement = null;
      this._indicatorsElement = null;
    } // Private
    ;

    _proto._getConfig = function _getConfig(config) {
      config = _extends({}, Default, config);
      Util.typeCheckConfig(NAME$2, config, DefaultType);
      return config;
    };

    _proto._handleSwipe = function _handleSwipe() {
      var absDeltax = Math.abs(this.touchDeltaX);

      if (absDeltax <= SWIPE_THRESHOLD) {
        return;
      }

      var direction = absDeltax / this.touchDeltaX;
      this.touchDeltaX = 0; // swipe left

      if (direction > 0) {
        this.prev();
      } // swipe right


      if (direction < 0) {
        this.next();
      }
    };

    _proto._addEventListeners = function _addEventListeners() {
      var _this2 = this;

      if (this._config.keyboard) {
        $__default['default'](this._element).on(EVENT_KEYDOWN, function (event) {
          return _this2._keydown(event);
        });
      }

      if (this._config.pause === 'hover') {
        $__default['default'](this._element).on(EVENT_MOUSEENTER, function (event) {
          return _this2.pause(event);
        }).on(EVENT_MOUSELEAVE, function (event) {
          return _this2.cycle(event);
        });
      }

      if (this._config.touch) {
        this._addTouchEventListeners();
      }
    };

    _proto._addTouchEventListeners = function _addTouchEventListeners() {
      var _this3 = this;

      if (!this._touchSupported) {
        return;
      }

      var start = function start(event) {
        if (_this3._pointerEvent && PointerType[event.originalEvent.pointerType.toUpperCase()]) {
          _this3.touchStartX = event.originalEvent.clientX;
        } else if (!_this3._pointerEvent) {
          _this3.touchStartX = event.originalEvent.touches[0].clientX;
        }
      };

      var move = function move(event) {
        // ensure swiping with one touch and not pinching
        if (event.originalEvent.touches && event.originalEvent.touches.length > 1) {
          _this3.touchDeltaX = 0;
        } else {
          _this3.touchDeltaX = event.originalEvent.touches[0].clientX - _this3.touchStartX;
        }
      };

      var end = function end(event) {
        if (_this3._pointerEvent && PointerType[event.originalEvent.pointerType.toUpperCase()]) {
          _this3.touchDeltaX = event.originalEvent.clientX - _this3.touchStartX;
        }

        _this3._handleSwipe();

        if (_this3._config.pause === 'hover') {
          // If it's a touch-enabled device, mouseenter/leave are fired as
          // part of the mouse compatibility events on first tap - the carousel
          // would stop cycling until user tapped out of it;
          // here, we listen for touchend, explicitly pause the carousel
          // (as if it's the second time we tap on it, mouseenter compat event
          // is NOT fired) and after a timeout (to allow for mouse compatibility
          // events to fire) we explicitly restart cycling
          _this3.pause();

          if (_this3.touchTimeout) {
            clearTimeout(_this3.touchTimeout);
          }

          _this3.touchTimeout = setTimeout(function (event) {
            return _this3.cycle(event);
          }, TOUCHEVENT_COMPAT_WAIT + _this3._config.interval);
        }
      };

      $__default['default'](this._element.querySelectorAll(SELECTOR_ITEM_IMG)).on(EVENT_DRAG_START, function (e) {
        return e.preventDefault();
      });

      if (this._pointerEvent) {
        $__default['default'](this._element).on(EVENT_POINTERDOWN, function (event) {
          return start(event);
        });
        $__default['default'](this._element).on(EVENT_POINTERUP, function (event) {
          return end(event);
        });

        this._element.classList.add(CLASS_NAME_POINTER_EVENT);
      } else {
        $__default['default'](this._element).on(EVENT_TOUCHSTART, function (event) {
          return start(event);
        });
        $__default['default'](this._element).on(EVENT_TOUCHMOVE, function (event) {
          return move(event);
        });
        $__default['default'](this._element).on(EVENT_TOUCHEND, function (event) {
          return end(event);
        });
      }
    };

    _proto._keydown = function _keydown(event) {
      if (/input|textarea/i.test(event.target.tagName)) {
        return;
      }

      switch (event.which) {
        case ARROW_LEFT_KEYCODE:
          event.preventDefault();
          this.prev();
          break;

        case ARROW_RIGHT_KEYCODE:
          event.preventDefault();
          this.next();
          break;
      }
    };

    _proto._getItemIndex = function _getItemIndex(element) {
      this._items = element && element.parentNode ? [].slice.call(element.parentNode.querySelectorAll(SELECTOR_ITEM)) : [];
      return this._items.indexOf(element);
    };

    _proto._getItemByDirection = function _getItemByDirection(direction, activeElement) {
      var isNextDirection = direction === DIRECTION_NEXT;
      var isPrevDirection = direction === DIRECTION_PREV;

      var activeIndex = this._getItemIndex(activeElement);

      var lastItemIndex = this._items.length - 1;
      var isGoingToWrap = isPrevDirection && activeIndex === 0 || isNextDirection && activeIndex === lastItemIndex;

      if (isGoingToWrap && !this._config.wrap) {
        return activeElement;
      }

      var delta = direction === DIRECTION_PREV ? -1 : 1;
      var itemIndex = (activeIndex + delta) % this._items.length;
      return itemIndex === -1 ? this._items[this._items.length - 1] : this._items[itemIndex];
    };

    _proto._triggerSlideEvent = function _triggerSlideEvent(relatedTarget, eventDirectionName) {
      var targetIndex = this._getItemIndex(relatedTarget);

      var fromIndex = this._getItemIndex(this._element.querySelector(SELECTOR_ACTIVE_ITEM));

      var slideEvent = $__default['default'].Event(EVENT_SLIDE, {
        relatedTarget: relatedTarget,
        direction: eventDirectionName,
        from: fromIndex,
        to: targetIndex
      });
      $__default['default'](this._element).trigger(slideEvent);
      return slideEvent;
    };

    _proto._setActiveIndicatorElement = function _setActiveIndicatorElement(element) {
      if (this._indicatorsElement) {
        var indicators = [].slice.call(this._indicatorsElement.querySelectorAll(SELECTOR_ACTIVE$1));
        $__default['default'](indicators).removeClass(CLASS_NAME_ACTIVE$1);

        var nextIndicator = this._indicatorsElement.children[this._getItemIndex(element)];

        if (nextIndicator) {
          $__default['default'](nextIndicator).addClass(CLASS_NAME_ACTIVE$1);
        }
      }
    };

    _proto._updateInterval = function _updateInterval() {
      var element = this._activeElement || this._element.querySelector(SELECTOR_ACTIVE_ITEM);

      if (!element) {
        return;
      }

      var elementInterval = parseInt(element.getAttribute('data-interval'), 10);

      if (elementInterval) {
        this._config.defaultInterval = this._config.defaultInterval || this._config.interval;
        this._config.interval = elementInterval;
      } else {
        this._config.interval = this._config.defaultInterval || this._config.interval;
      }
    };

    _proto._slide = function _slide(direction, element) {
      var _this4 = this;

      var activeElement = this._element.querySelector(SELECTOR_ACTIVE_ITEM);

      var activeElementIndex = this._getItemIndex(activeElement);

      var nextElement = element || activeElement && this._getItemByDirection(direction, activeElement);

      var nextElementIndex = this._getItemIndex(nextElement);

      var isCycling = Boolean(this._interval);
      var directionalClassName;
      var orderClassName;
      var eventDirectionName;

      if (direction === DIRECTION_NEXT) {
        directionalClassName = CLASS_NAME_LEFT;
        orderClassName = CLASS_NAME_NEXT;
        eventDirectionName = DIRECTION_LEFT;
      } else {
        directionalClassName = CLASS_NAME_RIGHT;
        orderClassName = CLASS_NAME_PREV;
        eventDirectionName = DIRECTION_RIGHT;
      }

      if (nextElement && $__default['default'](nextElement).hasClass(CLASS_NAME_ACTIVE$1)) {
        this._isSliding = false;
        return;
      }

      var slideEvent = this._triggerSlideEvent(nextElement, eventDirectionName);

      if (slideEvent.isDefaultPrevented()) {
        return;
      }

      if (!activeElement || !nextElement) {
        // Some weirdness is happening, so we bail
        return;
      }

      this._isSliding = true;

      if (isCycling) {
        this.pause();
      }

      this._setActiveIndicatorElement(nextElement);

      this._activeElement = nextElement;
      var slidEvent = $__default['default'].Event(EVENT_SLID, {
        relatedTarget: nextElement,
        direction: eventDirectionName,
        from: activeElementIndex,
        to: nextElementIndex
      });

      if ($__default['default'](this._element).hasClass(CLASS_NAME_SLIDE)) {
        $__default['default'](nextElement).addClass(orderClassName);
        Util.reflow(nextElement);
        $__default['default'](activeElement).addClass(directionalClassName);
        $__default['default'](nextElement).addClass(directionalClassName);
        var transitionDuration = Util.getTransitionDurationFromElement(activeElement);
        $__default['default'](activeElement).one(Util.TRANSITION_END, function () {
          $__default['default'](nextElement).removeClass(directionalClassName + " " + orderClassName).addClass(CLASS_NAME_ACTIVE$1);
          $__default['default'](activeElement).removeClass(CLASS_NAME_ACTIVE$1 + " " + orderClassName + " " + directionalClassName);
          _this4._isSliding = false;
          setTimeout(function () {
            return $__default['default'](_this4._element).trigger(slidEvent);
          }, 0);
        }).emulateTransitionEnd(transitionDuration);
      } else {
        $__default['default'](activeElement).removeClass(CLASS_NAME_ACTIVE$1);
        $__default['default'](nextElement).addClass(CLASS_NAME_ACTIVE$1);
        this._isSliding = false;
        $__default['default'](this._element).trigger(slidEvent);
      }

      if (isCycling) {
        this.cycle();
      }
    } // Static
    ;

    Carousel._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var data = $__default['default'](this).data(DATA_KEY$2);

        var _config = _extends({}, Default, $__default['default'](this).data());

        if (typeof config === 'object') {
          _config = _extends({}, _config, config);
        }

        var action = typeof config === 'string' ? config : _config.slide;

        if (!data) {
          data = new Carousel(this, _config);
          $__default['default'](this).data(DATA_KEY$2, data);
        }

        if (typeof config === 'number') {
          data.to(config);
        } else if (typeof action === 'string') {
          if (typeof data[action] === 'undefined') {
            throw new TypeError("No method named \"" + action + "\"");
          }

          data[action]();
        } else if (_config.interval && _config.ride) {
          data.pause();
          data.cycle();
        }
      });
    };

    Carousel._dataApiClickHandler = function _dataApiClickHandler(event) {
      var selector = Util.getSelectorFromElement(this);

      if (!selector) {
        return;
      }

      var target = $__default['default'](selector)[0];

      if (!target || !$__default['default'](target).hasClass(CLASS_NAME_CAROUSEL)) {
        return;
      }

      var config = _extends({}, $__default['default'](target).data(), $__default['default'](this).data());

      var slideIndex = this.getAttribute('data-slide-to');

      if (slideIndex) {
        config.interval = false;
      }

      Carousel._jQueryInterface.call($__default['default'](target), config);

      if (slideIndex) {
        $__default['default'](target).data(DATA_KEY$2).to(slideIndex);
      }

      event.preventDefault();
    };

    _createClass(Carousel, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$2;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default;
      }
    }]);

    return Carousel;
  }();
  /**
   * ------------------------------------------------------------------------
   * Data Api implementation
   * ------------------------------------------------------------------------
   */


  $__default['default'](document).on(EVENT_CLICK_DATA_API$2, SELECTOR_DATA_SLIDE, Carousel._dataApiClickHandler);
  $__default['default'](window).on(EVENT_LOAD_DATA_API$1, function () {
    var carousels = [].slice.call(document.querySelectorAll(SELECTOR_DATA_RIDE));

    for (var i = 0, len = carousels.length; i < len; i++) {
      var $carousel = $__default['default'](carousels[i]);

      Carousel._jQueryInterface.call($carousel, $carousel.data());
    }
  });
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   */

  $__default['default'].fn[NAME$2] = Carousel._jQueryInterface;
  $__default['default'].fn[NAME$2].Constructor = Carousel;

  $__default['default'].fn[NAME$2].noConflict = function () {
    $__default['default'].fn[NAME$2] = JQUERY_NO_CONFLICT$2;
    return Carousel._jQueryInterface;
  };

  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  var NAME$3 = 'collapse';
  var VERSION$3 = '4.6.0';
  var DATA_KEY$3 = 'bs.collapse';
  var EVENT_KEY$3 = "." + DATA_KEY$3;
  var DATA_API_KEY$3 = '.data-api';
  var JQUERY_NO_CONFLICT$3 = $__default['default'].fn[NAME$3];
  var Default$1 = {
    toggle: true,
    parent: ''
  };
  var DefaultType$1 = {
    toggle: 'boolean',
    parent: '(string|element)'
  };
  var EVENT_SHOW = "show" + EVENT_KEY$3;
  var EVENT_SHOWN = "shown" + EVENT_KEY$3;
  var EVENT_HIDE = "hide" + EVENT_KEY$3;
  var EVENT_HIDDEN = "hidden" + EVENT_KEY$3;
  var EVENT_CLICK_DATA_API$3 = "click" + EVENT_KEY$3 + DATA_API_KEY$3;
  var CLASS_NAME_SHOW$1 = 'show';
  var CLASS_NAME_COLLAPSE = 'collapse';
  var CLASS_NAME_COLLAPSING = 'collapsing';
  var CLASS_NAME_COLLAPSED = 'collapsed';
  var DIMENSION_WIDTH = 'width';
  var DIMENSION_HEIGHT = 'height';
  var SELECTOR_ACTIVES = '.show, .collapsing';
  var SELECTOR_DATA_TOGGLE$1 = '[data-toggle="collapse"]';
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  var Collapse = /*#__PURE__*/function () {
    function Collapse(element, config) {
      this._isTransitioning = false;
      this._element = element;
      this._config = this._getConfig(config);
      this._triggerArray = [].slice.call(document.querySelectorAll("[data-toggle=\"collapse\"][href=\"#" + element.id + "\"]," + ("[data-toggle=\"collapse\"][data-target=\"#" + element.id + "\"]")));
      var toggleList = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLE$1));

      for (var i = 0, len = toggleList.length; i < len; i++) {
        var elem = toggleList[i];
        var selector = Util.getSelectorFromElement(elem);
        var filterElement = [].slice.call(document.querySelectorAll(selector)).filter(function (foundElem) {
          return foundElem === element;
        });

        if (selector !== null && filterElement.length > 0) {
          this._selector = selector;

          this._triggerArray.push(elem);
        }
      }

      this._parent = this._config.parent ? this._getParent() : null;

      if (!this._config.parent) {
        this._addAriaAndCollapsedClass(this._element, this._triggerArray);
      }

      if (this._config.toggle) {
        this.toggle();
      }
    } // Getters


    var _proto = Collapse.prototype;

    // Public
    _proto.toggle = function toggle() {
      if ($__default['default'](this._element).hasClass(CLASS_NAME_SHOW$1)) {
        this.hide();
      } else {
        this.show();
      }
    };

    _proto.show = function show() {
      var _this = this;

      if (this._isTransitioning || $__default['default'](this._element).hasClass(CLASS_NAME_SHOW$1)) {
        return;
      }

      var actives;
      var activesData;

      if (this._parent) {
        actives = [].slice.call(this._parent.querySelectorAll(SELECTOR_ACTIVES)).filter(function (elem) {
          if (typeof _this._config.parent === 'string') {
            return elem.getAttribute('data-parent') === _this._config.parent;
          }

          return elem.classList.contains(CLASS_NAME_COLLAPSE);
        });

        if (actives.length === 0) {
          actives = null;
        }
      }

      if (actives) {
        activesData = $__default['default'](actives).not(this._selector).data(DATA_KEY$3);

        if (activesData && activesData._isTransitioning) {
          return;
        }
      }

      var startEvent = $__default['default'].Event(EVENT_SHOW);
      $__default['default'](this._element).trigger(startEvent);

      if (startEvent.isDefaultPrevented()) {
        return;
      }

      if (actives) {
        Collapse._jQueryInterface.call($__default['default'](actives).not(this._selector), 'hide');

        if (!activesData) {
          $__default['default'](actives).data(DATA_KEY$3, null);
        }
      }

      var dimension = this._getDimension();

      $__default['default'](this._element).removeClass(CLASS_NAME_COLLAPSE).addClass(CLASS_NAME_COLLAPSING);
      this._element.style[dimension] = 0;

      if (this._triggerArray.length) {
        $__default['default'](this._triggerArray).removeClass(CLASS_NAME_COLLAPSED).attr('aria-expanded', true);
      }

      this.setTransitioning(true);

      var complete = function complete() {
        $__default['default'](_this._element).removeClass(CLASS_NAME_COLLAPSING).addClass(CLASS_NAME_COLLAPSE + " " + CLASS_NAME_SHOW$1);
        _this._element.style[dimension] = '';

        _this.setTransitioning(false);

        $__default['default'](_this._element).trigger(EVENT_SHOWN);
      };

      var capitalizedDimension = dimension[0].toUpperCase() + dimension.slice(1);
      var scrollSize = "scroll" + capitalizedDimension;
      var transitionDuration = Util.getTransitionDurationFromElement(this._element);
      $__default['default'](this._element).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);
      this._element.style[dimension] = this._element[scrollSize] + "px";
    };

    _proto.hide = function hide() {
      var _this2 = this;

      if (this._isTransitioning || !$__default['default'](this._element).hasClass(CLASS_NAME_SHOW$1)) {
        return;
      }

      var startEvent = $__default['default'].Event(EVENT_HIDE);
      $__default['default'](this._element).trigger(startEvent);

      if (startEvent.isDefaultPrevented()) {
        return;
      }

      var dimension = this._getDimension();

      this._element.style[dimension] = this._element.getBoundingClientRect()[dimension] + "px";
      Util.reflow(this._element);
      $__default['default'](this._element).addClass(CLASS_NAME_COLLAPSING).removeClass(CLASS_NAME_COLLAPSE + " " + CLASS_NAME_SHOW$1);
      var triggerArrayLength = this._triggerArray.length;

      if (triggerArrayLength > 0) {
        for (var i = 0; i < triggerArrayLength; i++) {
          var trigger = this._triggerArray[i];
          var selector = Util.getSelectorFromElement(trigger);

          if (selector !== null) {
            var $elem = $__default['default']([].slice.call(document.querySelectorAll(selector)));

            if (!$elem.hasClass(CLASS_NAME_SHOW$1)) {
              $__default['default'](trigger).addClass(CLASS_NAME_COLLAPSED).attr('aria-expanded', false);
            }
          }
        }
      }

      this.setTransitioning(true);

      var complete = function complete() {
        _this2.setTransitioning(false);

        $__default['default'](_this2._element).removeClass(CLASS_NAME_COLLAPSING).addClass(CLASS_NAME_COLLAPSE).trigger(EVENT_HIDDEN);
      };

      this._element.style[dimension] = '';
      var transitionDuration = Util.getTransitionDurationFromElement(this._element);
      $__default['default'](this._element).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);
    };

    _proto.setTransitioning = function setTransitioning(isTransitioning) {
      this._isTransitioning = isTransitioning;
    };

    _proto.dispose = function dispose() {
      $__default['default'].removeData(this._element, DATA_KEY$3);
      this._config = null;
      this._parent = null;
      this._element = null;
      this._triggerArray = null;
      this._isTransitioning = null;
    } // Private
    ;

    _proto._getConfig = function _getConfig(config) {
      config = _extends({}, Default$1, config);
      config.toggle = Boolean(config.toggle); // Coerce string values

      Util.typeCheckConfig(NAME$3, config, DefaultType$1);
      return config;
    };

    _proto._getDimension = function _getDimension() {
      var hasWidth = $__default['default'](this._element).hasClass(DIMENSION_WIDTH);
      return hasWidth ? DIMENSION_WIDTH : DIMENSION_HEIGHT;
    };

    _proto._getParent = function _getParent() {
      var _this3 = this;

      var parent;

      if (Util.isElement(this._config.parent)) {
        parent = this._config.parent; // It's a jQuery object

        if (typeof this._config.parent.jquery !== 'undefined') {
          parent = this._config.parent[0];
        }
      } else {
        parent = document.querySelector(this._config.parent);
      }

      var selector = "[data-toggle=\"collapse\"][data-parent=\"" + this._config.parent + "\"]";
      var children = [].slice.call(parent.querySelectorAll(selector));
      $__default['default'](children).each(function (i, element) {
        _this3._addAriaAndCollapsedClass(Collapse._getTargetFromElement(element), [element]);
      });
      return parent;
    };

    _proto._addAriaAndCollapsedClass = function _addAriaAndCollapsedClass(element, triggerArray) {
      var isOpen = $__default['default'](element).hasClass(CLASS_NAME_SHOW$1);

      if (triggerArray.length) {
        $__default['default'](triggerArray).toggleClass(CLASS_NAME_COLLAPSED, !isOpen).attr('aria-expanded', isOpen);
      }
    } // Static
    ;

    Collapse._getTargetFromElement = function _getTargetFromElement(element) {
      var selector = Util.getSelectorFromElement(element);
      return selector ? document.querySelector(selector) : null;
    };

    Collapse._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var $element = $__default['default'](this);
        var data = $element.data(DATA_KEY$3);

        var _config = _extends({}, Default$1, $element.data(), typeof config === 'object' && config ? config : {});

        if (!data && _config.toggle && typeof config === 'string' && /show|hide/.test(config)) {
          _config.toggle = false;
        }

        if (!data) {
          data = new Collapse(this, _config);
          $element.data(DATA_KEY$3, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config]();
        }
      });
    };

    _createClass(Collapse, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$3;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$1;
      }
    }]);

    return Collapse;
  }();
  /**
   * ------------------------------------------------------------------------
   * Data Api implementation
   * ------------------------------------------------------------------------
   */


  $__default['default'](document).on(EVENT_CLICK_DATA_API$3, SELECTOR_DATA_TOGGLE$1, function (event) {
    // preventDefault only for <a> elements (which change the URL) not inside the collapsible element
    if (event.currentTarget.tagName === 'A') {
      event.preventDefault();
    }

    var $trigger = $__default['default'](this);
    var selector = Util.getSelectorFromElement(this);
    var selectors = [].slice.call(document.querySelectorAll(selector));
    $__default['default'](selectors).each(function () {
      var $target = $__default['default'](this);
      var data = $target.data(DATA_KEY$3);
      var config = data ? 'toggle' : $trigger.data();

      Collapse._jQueryInterface.call($target, config);
    });
  });
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   */

  $__default['default'].fn[NAME$3] = Collapse._jQueryInterface;
  $__default['default'].fn[NAME$3].Constructor = Collapse;

  $__default['default'].fn[NAME$3].noConflict = function () {
    $__default['default'].fn[NAME$3] = JQUERY_NO_CONFLICT$3;
    return Collapse._jQueryInterface;
  };

  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  var NAME$4 = 'dropdown';
  var VERSION$4 = '4.6.0';
  var DATA_KEY$4 = 'bs.dropdown';
  var EVENT_KEY$4 = "." + DATA_KEY$4;
  var DATA_API_KEY$4 = '.data-api';
  var JQUERY_NO_CONFLICT$4 = $__default['default'].fn[NAME$4];
  var ESCAPE_KEYCODE = 27; // KeyboardEvent.which value for Escape (Esc) key

  var SPACE_KEYCODE = 32; // KeyboardEvent.which value for space key

  var TAB_KEYCODE = 9; // KeyboardEvent.which value for tab key

  var ARROW_UP_KEYCODE = 38; // KeyboardEvent.which value for up arrow key

  var ARROW_DOWN_KEYCODE = 40; // KeyboardEvent.which value for down arrow key

  var RIGHT_MOUSE_BUTTON_WHICH = 3; // MouseEvent.which value for the right button (assuming a right-handed mouse)

  var REGEXP_KEYDOWN = new RegExp(ARROW_UP_KEYCODE + "|" + ARROW_DOWN_KEYCODE + "|" + ESCAPE_KEYCODE);
  var EVENT_HIDE$1 = "hide" + EVENT_KEY$4;
  var EVENT_HIDDEN$1 = "hidden" + EVENT_KEY$4;
  var EVENT_SHOW$1 = "show" + EVENT_KEY$4;
  var EVENT_SHOWN$1 = "shown" + EVENT_KEY$4;
  var EVENT_CLICK = "click" + EVENT_KEY$4;
  var EVENT_CLICK_DATA_API$4 = "click" + EVENT_KEY$4 + DATA_API_KEY$4;
  var EVENT_KEYDOWN_DATA_API = "keydown" + EVENT_KEY$4 + DATA_API_KEY$4;
  var EVENT_KEYUP_DATA_API = "keyup" + EVENT_KEY$4 + DATA_API_KEY$4;
  var CLASS_NAME_DISABLED = 'disabled';
  var CLASS_NAME_SHOW$2 = 'show';
  var CLASS_NAME_DROPUP = 'dropup';
  var CLASS_NAME_DROPRIGHT = 'dropright';
  var CLASS_NAME_DROPLEFT = 'dropleft';
  var CLASS_NAME_MENURIGHT = 'dropdown-menu-right';
  var CLASS_NAME_POSITION_STATIC = 'position-static';
  var SELECTOR_DATA_TOGGLE$2 = '[data-toggle="dropdown"]';
  var SELECTOR_FORM_CHILD = '.dropdown form';
  var SELECTOR_MENU = '.dropdown-menu';
  var SELECTOR_NAVBAR_NAV = '.navbar-nav';
  var SELECTOR_VISIBLE_ITEMS = '.dropdown-menu .dropdown-item:not(.disabled):not(:disabled)';
  var PLACEMENT_TOP = 'top-start';
  var PLACEMENT_TOPEND = 'top-end';
  var PLACEMENT_BOTTOM = 'bottom-start';
  var PLACEMENT_BOTTOMEND = 'bottom-end';
  var PLACEMENT_RIGHT = 'right-start';
  var PLACEMENT_LEFT = 'left-start';
  var Default$2 = {
    offset: 0,
    flip: true,
    boundary: 'scrollParent',
    reference: 'toggle',
    display: 'dynamic',
    popperConfig: null
  };
  var DefaultType$2 = {
    offset: '(number|string|function)',
    flip: 'boolean',
    boundary: '(string|element)',
    reference: '(string|element)',
    display: 'string',
    popperConfig: '(null|object)'
  };
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  var Dropdown = /*#__PURE__*/function () {
    function Dropdown(element, config) {
      this._element = element;
      this._popper = null;
      this._config = this._getConfig(config);
      this._menu = this._getMenuElement();
      this._inNavbar = this._detectNavbar();

      this._addEventListeners();
    } // Getters


    var _proto = Dropdown.prototype;

    // Public
    _proto.toggle = function toggle() {
      if (this._element.disabled || $__default['default'](this._element).hasClass(CLASS_NAME_DISABLED)) {
        return;
      }

      var isActive = $__default['default'](this._menu).hasClass(CLASS_NAME_SHOW$2);

      Dropdown._clearMenus();

      if (isActive) {
        return;
      }

      this.show(true);
    };

    _proto.show = function show(usePopper) {
      if (usePopper === void 0) {
        usePopper = false;
      }

      if (this._element.disabled || $__default['default'](this._element).hasClass(CLASS_NAME_DISABLED) || $__default['default'](this._menu).hasClass(CLASS_NAME_SHOW$2)) {
        return;
      }

      var relatedTarget = {
        relatedTarget: this._element
      };
      var showEvent = $__default['default'].Event(EVENT_SHOW$1, relatedTarget);

      var parent = Dropdown._getParentFromElement(this._element);

      $__default['default'](parent).trigger(showEvent);

      if (showEvent.isDefaultPrevented()) {
        return;
      } // Totally disable Popper for Dropdowns in Navbar


      if (!this._inNavbar && usePopper) {
        /**
         * Check for Popper dependency
         * Popper - https://popper.js.org
         */
        if (typeof Popper__default['default'] === 'undefined') {
          throw new TypeError('Bootstrap\'s dropdowns require Popper (https://popper.js.org)');
        }

        var referenceElement = this._element;

        if (this._config.reference === 'parent') {
          referenceElement = parent;
        } else if (Util.isElement(this._config.reference)) {
          referenceElement = this._config.reference; // Check if it's jQuery element

          if (typeof this._config.reference.jquery !== 'undefined') {
            referenceElement = this._config.reference[0];
          }
        } // If boundary is not `scrollParent`, then set position to `static`
        // to allow the menu to "escape" the scroll parent's boundaries
        // https://github.com/twbs/bootstrap/issues/24251


        if (this._config.boundary !== 'scrollParent') {
          $__default['default'](parent).addClass(CLASS_NAME_POSITION_STATIC);
        }

        this._popper = new Popper__default['default'](referenceElement, this._menu, this._getPopperConfig());
      } // If this is a touch-enabled device we add extra
      // empty mouseover listeners to the body's immediate children;
      // only needed because of broken event delegation on iOS
      // https://www.quirksmode.org/blog/archives/2014/02/mouse_event_bub.html


      if ('ontouchstart' in document.documentElement && $__default['default'](parent).closest(SELECTOR_NAVBAR_NAV).length === 0) {
        $__default['default'](document.body).children().on('mouseover', null, $__default['default'].noop);
      }

      this._element.focus();

      this._element.setAttribute('aria-expanded', true);

      $__default['default'](this._menu).toggleClass(CLASS_NAME_SHOW$2);
      $__default['default'](parent).toggleClass(CLASS_NAME_SHOW$2).trigger($__default['default'].Event(EVENT_SHOWN$1, relatedTarget));
    };

    _proto.hide = function hide() {
      if (this._element.disabled || $__default['default'](this._element).hasClass(CLASS_NAME_DISABLED) || !$__default['default'](this._menu).hasClass(CLASS_NAME_SHOW$2)) {
        return;
      }

      var relatedTarget = {
        relatedTarget: this._element
      };
      var hideEvent = $__default['default'].Event(EVENT_HIDE$1, relatedTarget);

      var parent = Dropdown._getParentFromElement(this._element);

      $__default['default'](parent).trigger(hideEvent);

      if (hideEvent.isDefaultPrevented()) {
        return;
      }

      if (this._popper) {
        this._popper.destroy();
      }

      $__default['default'](this._menu).toggleClass(CLASS_NAME_SHOW$2);
      $__default['default'](parent).toggleClass(CLASS_NAME_SHOW$2).trigger($__default['default'].Event(EVENT_HIDDEN$1, relatedTarget));
    };

    _proto.dispose = function dispose() {
      $__default['default'].removeData(this._element, DATA_KEY$4);
      $__default['default'](this._element).off(EVENT_KEY$4);
      this._element = null;
      this._menu = null;

      if (this._popper !== null) {
        this._popper.destroy();

        this._popper = null;
      }
    };

    _proto.update = function update() {
      this._inNavbar = this._detectNavbar();

      if (this._popper !== null) {
        this._popper.scheduleUpdate();
      }
    } // Private
    ;

    _proto._addEventListeners = function _addEventListeners() {
      var _this = this;

      $__default['default'](this._element).on(EVENT_CLICK, function (event) {
        event.preventDefault();
        event.stopPropagation();

        _this.toggle();
      });
    };

    _proto._getConfig = function _getConfig(config) {
      config = _extends({}, this.constructor.Default, $__default['default'](this._element).data(), config);
      Util.typeCheckConfig(NAME$4, config, this.constructor.DefaultType);
      return config;
    };

    _proto._getMenuElement = function _getMenuElement() {
      if (!this._menu) {
        var parent = Dropdown._getParentFromElement(this._element);

        if (parent) {
          this._menu = parent.querySelector(SELECTOR_MENU);
        }
      }

      return this._menu;
    };

    _proto._getPlacement = function _getPlacement() {
      var $parentDropdown = $__default['default'](this._element.parentNode);
      var placement = PLACEMENT_BOTTOM; // Handle dropup

      if ($parentDropdown.hasClass(CLASS_NAME_DROPUP)) {
        placement = $__default['default'](this._menu).hasClass(CLASS_NAME_MENURIGHT) ? PLACEMENT_TOPEND : PLACEMENT_TOP;
      } else if ($parentDropdown.hasClass(CLASS_NAME_DROPRIGHT)) {
        placement = PLACEMENT_RIGHT;
      } else if ($parentDropdown.hasClass(CLASS_NAME_DROPLEFT)) {
        placement = PLACEMENT_LEFT;
      } else if ($__default['default'](this._menu).hasClass(CLASS_NAME_MENURIGHT)) {
        placement = PLACEMENT_BOTTOMEND;
      }

      return placement;
    };

    _proto._detectNavbar = function _detectNavbar() {
      return $__default['default'](this._element).closest('.navbar').length > 0;
    };

    _proto._getOffset = function _getOffset() {
      var _this2 = this;

      var offset = {};

      if (typeof this._config.offset === 'function') {
        offset.fn = function (data) {
          data.offsets = _extends({}, data.offsets, _this2._config.offset(data.offsets, _this2._element) || {});
          return data;
        };
      } else {
        offset.offset = this._config.offset;
      }

      return offset;
    };

    _proto._getPopperConfig = function _getPopperConfig() {
      var popperConfig = {
        placement: this._getPlacement(),
        modifiers: {
          offset: this._getOffset(),
          flip: {
            enabled: this._config.flip
          },
          preventOverflow: {
            boundariesElement: this._config.boundary
          }
        }
      }; // Disable Popper if we have a static display

      if (this._config.display === 'static') {
        popperConfig.modifiers.applyStyle = {
          enabled: false
        };
      }

      return _extends({}, popperConfig, this._config.popperConfig);
    } // Static
    ;

    Dropdown._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var data = $__default['default'](this).data(DATA_KEY$4);

        var _config = typeof config === 'object' ? config : null;

        if (!data) {
          data = new Dropdown(this, _config);
          $__default['default'](this).data(DATA_KEY$4, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config]();
        }
      });
    };

    Dropdown._clearMenus = function _clearMenus(event) {
      if (event && (event.which === RIGHT_MOUSE_BUTTON_WHICH || event.type === 'keyup' && event.which !== TAB_KEYCODE)) {
        return;
      }

      var toggles = [].slice.call(document.querySelectorAll(SELECTOR_DATA_TOGGLE$2));

      for (var i = 0, len = toggles.length; i < len; i++) {
        var parent = Dropdown._getParentFromElement(toggles[i]);

        var context = $__default['default'](toggles[i]).data(DATA_KEY$4);
        var relatedTarget = {
          relatedTarget: toggles[i]
        };

        if (event && event.type === 'click') {
          relatedTarget.clickEvent = event;
        }

        if (!context) {
          continue;
        }

        var dropdownMenu = context._menu;

        if (!$__default['default'](parent).hasClass(CLASS_NAME_SHOW$2)) {
          continue;
        }

        if (event && (event.type === 'click' && /input|textarea/i.test(event.target.tagName) || event.type === 'keyup' && event.which === TAB_KEYCODE) && $__default['default'].contains(parent, event.target)) {
          continue;
        }

        var hideEvent = $__default['default'].Event(EVENT_HIDE$1, relatedTarget);
        $__default['default'](parent).trigger(hideEvent);

        if (hideEvent.isDefaultPrevented()) {
          continue;
        } // If this is a touch-enabled device we remove the extra
        // empty mouseover listeners we added for iOS support


        if ('ontouchstart' in document.documentElement) {
          $__default['default'](document.body).children().off('mouseover', null, $__default['default'].noop);
        }

        toggles[i].setAttribute('aria-expanded', 'false');

        if (context._popper) {
          context._popper.destroy();
        }

        $__default['default'](dropdownMenu).removeClass(CLASS_NAME_SHOW$2);
        $__default['default'](parent).removeClass(CLASS_NAME_SHOW$2).trigger($__default['default'].Event(EVENT_HIDDEN$1, relatedTarget));
      }
    };

    Dropdown._getParentFromElement = function _getParentFromElement(element) {
      var parent;
      var selector = Util.getSelectorFromElement(element);

      if (selector) {
        parent = document.querySelector(selector);
      }

      return parent || element.parentNode;
    } // eslint-disable-next-line complexity
    ;

    Dropdown._dataApiKeydownHandler = function _dataApiKeydownHandler(event) {
      // If not input/textarea:
      //  - And not a key in REGEXP_KEYDOWN => not a dropdown command
      // If input/textarea:
      //  - If space key => not a dropdown command
      //  - If key is other than escape
      //    - If key is not up or down => not a dropdown command
      //    - If trigger inside the menu => not a dropdown command
      if (/input|textarea/i.test(event.target.tagName) ? event.which === SPACE_KEYCODE || event.which !== ESCAPE_KEYCODE && (event.which !== ARROW_DOWN_KEYCODE && event.which !== ARROW_UP_KEYCODE || $__default['default'](event.target).closest(SELECTOR_MENU).length) : !REGEXP_KEYDOWN.test(event.which)) {
        return;
      }

      if (this.disabled || $__default['default'](this).hasClass(CLASS_NAME_DISABLED)) {
        return;
      }

      var parent = Dropdown._getParentFromElement(this);

      var isActive = $__default['default'](parent).hasClass(CLASS_NAME_SHOW$2);

      if (!isActive && event.which === ESCAPE_KEYCODE) {
        return;
      }

      event.preventDefault();
      event.stopPropagation();

      if (!isActive || event.which === ESCAPE_KEYCODE || event.which === SPACE_KEYCODE) {
        if (event.which === ESCAPE_KEYCODE) {
          $__default['default'](parent.querySelector(SELECTOR_DATA_TOGGLE$2)).trigger('focus');
        }

        $__default['default'](this).trigger('click');
        return;
      }

      var items = [].slice.call(parent.querySelectorAll(SELECTOR_VISIBLE_ITEMS)).filter(function (item) {
        return $__default['default'](item).is(':visible');
      });

      if (items.length === 0) {
        return;
      }

      var index = items.indexOf(event.target);

      if (event.which === ARROW_UP_KEYCODE && index > 0) {
        // Up
        index--;
      }

      if (event.which === ARROW_DOWN_KEYCODE && index < items.length - 1) {
        // Down
        index++;
      }

      if (index < 0) {
        index = 0;
      }

      items[index].focus();
    };

    _createClass(Dropdown, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$4;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$2;
      }
    }, {
      key: "DefaultType",
      get: function get() {
        return DefaultType$2;
      }
    }]);

    return Dropdown;
  }();
  /**
   * ------------------------------------------------------------------------
   * Data Api implementation
   * ------------------------------------------------------------------------
   */


  $__default['default'](document).on(EVENT_KEYDOWN_DATA_API, SELECTOR_DATA_TOGGLE$2, Dropdown._dataApiKeydownHandler).on(EVENT_KEYDOWN_DATA_API, SELECTOR_MENU, Dropdown._dataApiKeydownHandler).on(EVENT_CLICK_DATA_API$4 + " " + EVENT_KEYUP_DATA_API, Dropdown._clearMenus).on(EVENT_CLICK_DATA_API$4, SELECTOR_DATA_TOGGLE$2, function (event) {
    event.preventDefault();
    event.stopPropagation();

    Dropdown._jQueryInterface.call($__default['default'](this), 'toggle');
  }).on(EVENT_CLICK_DATA_API$4, SELECTOR_FORM_CHILD, function (e) {
    e.stopPropagation();
  });
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   */

  $__default['default'].fn[NAME$4] = Dropdown._jQueryInterface;
  $__default['default'].fn[NAME$4].Constructor = Dropdown;

  $__default['default'].fn[NAME$4].noConflict = function () {
    $__default['default'].fn[NAME$4] = JQUERY_NO_CONFLICT$4;
    return Dropdown._jQueryInterface;
  };

  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  var NAME$5 = 'modal';
  var VERSION$5 = '4.6.0';
  var DATA_KEY$5 = 'bs.modal';
  var EVENT_KEY$5 = "." + DATA_KEY$5;
  var DATA_API_KEY$5 = '.data-api';
  var JQUERY_NO_CONFLICT$5 = $__default['default'].fn[NAME$5];
  var ESCAPE_KEYCODE$1 = 27; // KeyboardEvent.which value for Escape (Esc) key

  var Default$3 = {
    backdrop: true,
    keyboard: true,
    focus: true,
    show: true
  };
  var DefaultType$3 = {
    backdrop: '(boolean|string)',
    keyboard: 'boolean',
    focus: 'boolean',
    show: 'boolean'
  };
  var EVENT_HIDE$2 = "hide" + EVENT_KEY$5;
  var EVENT_HIDE_PREVENTED = "hidePrevented" + EVENT_KEY$5;
  var EVENT_HIDDEN$2 = "hidden" + EVENT_KEY$5;
  var EVENT_SHOW$2 = "show" + EVENT_KEY$5;
  var EVENT_SHOWN$2 = "shown" + EVENT_KEY$5;
  var EVENT_FOCUSIN = "focusin" + EVENT_KEY$5;
  var EVENT_RESIZE = "resize" + EVENT_KEY$5;
  var EVENT_CLICK_DISMISS = "click.dismiss" + EVENT_KEY$5;
  var EVENT_KEYDOWN_DISMISS = "keydown.dismiss" + EVENT_KEY$5;
  var EVENT_MOUSEUP_DISMISS = "mouseup.dismiss" + EVENT_KEY$5;
  var EVENT_MOUSEDOWN_DISMISS = "mousedown.dismiss" + EVENT_KEY$5;
  var EVENT_CLICK_DATA_API$5 = "click" + EVENT_KEY$5 + DATA_API_KEY$5;
  var CLASS_NAME_SCROLLABLE = 'modal-dialog-scrollable';
  var CLASS_NAME_SCROLLBAR_MEASURER = 'modal-scrollbar-measure';
  var CLASS_NAME_BACKDROP = 'modal-backdrop';
  var CLASS_NAME_OPEN = 'modal-open';
  var CLASS_NAME_FADE$1 = 'fade';
  var CLASS_NAME_SHOW$3 = 'show';
  var CLASS_NAME_STATIC = 'modal-static';
  var SELECTOR_DIALOG = '.modal-dialog';
  var SELECTOR_MODAL_BODY = '.modal-body';
  var SELECTOR_DATA_TOGGLE$3 = '[data-toggle="modal"]';
  var SELECTOR_DATA_DISMISS = '[data-dismiss="modal"]';
  var SELECTOR_FIXED_CONTENT = '.fixed-top, .fixed-bottom, .is-fixed, .sticky-top';
  var SELECTOR_STICKY_CONTENT = '.sticky-top';
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  var Modal = /*#__PURE__*/function () {
    function Modal(element, config) {
      this._config = this._getConfig(config);
      this._element = element;
      this._dialog = element.querySelector(SELECTOR_DIALOG);
      this._backdrop = null;
      this._isShown = false;
      this._isBodyOverflowing = false;
      this._ignoreBackdropClick = false;
      this._isTransitioning = false;
      this._scrollbarWidth = 0;
    } // Getters


    var _proto = Modal.prototype;

    // Public
    _proto.toggle = function toggle(relatedTarget) {
      return this._isShown ? this.hide() : this.show(relatedTarget);
    };

    _proto.show = function show(relatedTarget) {
      var _this = this;

      if (this._isShown || this._isTransitioning) {
        return;
      }

      if ($__default['default'](this._element).hasClass(CLASS_NAME_FADE$1)) {
        this._isTransitioning = true;
      }

      var showEvent = $__default['default'].Event(EVENT_SHOW$2, {
        relatedTarget: relatedTarget
      });
      $__default['default'](this._element).trigger(showEvent);

      if (this._isShown || showEvent.isDefaultPrevented()) {
        return;
      }

      this._isShown = true;

      this._checkScrollbar();

      this._setScrollbar();

      this._adjustDialog();

      this._setEscapeEvent();

      this._setResizeEvent();

      $__default['default'](this._element).on(EVENT_CLICK_DISMISS, SELECTOR_DATA_DISMISS, function (event) {
        return _this.hide(event);
      });
      $__default['default'](this._dialog).on(EVENT_MOUSEDOWN_DISMISS, function () {
        $__default['default'](_this._element).one(EVENT_MOUSEUP_DISMISS, function (event) {
          if ($__default['default'](event.target).is(_this._element)) {
            _this._ignoreBackdropClick = true;
          }
        });
      });

      this._showBackdrop(function () {
        return _this._showElement(relatedTarget);
      });
    };

    _proto.hide = function hide(event) {
      var _this2 = this;

      if (event) {
        event.preventDefault();
      }

      if (!this._isShown || this._isTransitioning) {
        return;
      }

      var hideEvent = $__default['default'].Event(EVENT_HIDE$2);
      $__default['default'](this._element).trigger(hideEvent);

      if (!this._isShown || hideEvent.isDefaultPrevented()) {
        return;
      }

      this._isShown = false;
      var transition = $__default['default'](this._element).hasClass(CLASS_NAME_FADE$1);

      if (transition) {
        this._isTransitioning = true;
      }

      this._setEscapeEvent();

      this._setResizeEvent();

      $__default['default'](document).off(EVENT_FOCUSIN);
      $__default['default'](this._element).removeClass(CLASS_NAME_SHOW$3);
      $__default['default'](this._element).off(EVENT_CLICK_DISMISS);
      $__default['default'](this._dialog).off(EVENT_MOUSEDOWN_DISMISS);

      if (transition) {
        var transitionDuration = Util.getTransitionDurationFromElement(this._element);
        $__default['default'](this._element).one(Util.TRANSITION_END, function (event) {
          return _this2._hideModal(event);
        }).emulateTransitionEnd(transitionDuration);
      } else {
        this._hideModal();
      }
    };

    _proto.dispose = function dispose() {
      [window, this._element, this._dialog].forEach(function (htmlElement) {
        return $__default['default'](htmlElement).off(EVENT_KEY$5);
      });
      /**
       * `document` has 2 events `EVENT_FOCUSIN` and `EVENT_CLICK_DATA_API`
       * Do not move `document` in `htmlElements` array
       * It will remove `EVENT_CLICK_DATA_API` event that should remain
       */

      $__default['default'](document).off(EVENT_FOCUSIN);
      $__default['default'].removeData(this._element, DATA_KEY$5);
      this._config = null;
      this._element = null;
      this._dialog = null;
      this._backdrop = null;
      this._isShown = null;
      this._isBodyOverflowing = null;
      this._ignoreBackdropClick = null;
      this._isTransitioning = null;
      this._scrollbarWidth = null;
    };

    _proto.handleUpdate = function handleUpdate() {
      this._adjustDialog();
    } // Private
    ;

    _proto._getConfig = function _getConfig(config) {
      config = _extends({}, Default$3, config);
      Util.typeCheckConfig(NAME$5, config, DefaultType$3);
      return config;
    };

    _proto._triggerBackdropTransition = function _triggerBackdropTransition() {
      var _this3 = this;

      var hideEventPrevented = $__default['default'].Event(EVENT_HIDE_PREVENTED);
      $__default['default'](this._element).trigger(hideEventPrevented);

      if (hideEventPrevented.isDefaultPrevented()) {
        return;
      }

      var isModalOverflowing = this._element.scrollHeight > document.documentElement.clientHeight;

      if (!isModalOverflowing) {
        this._element.style.overflowY = 'hidden';
      }

      this._element.classList.add(CLASS_NAME_STATIC);

      var modalTransitionDuration = Util.getTransitionDurationFromElement(this._dialog);
      $__default['default'](this._element).off(Util.TRANSITION_END);
      $__default['default'](this._element).one(Util.TRANSITION_END, function () {
        _this3._element.classList.remove(CLASS_NAME_STATIC);

        if (!isModalOverflowing) {
          $__default['default'](_this3._element).one(Util.TRANSITION_END, function () {
            _this3._element.style.overflowY = '';
          }).emulateTransitionEnd(_this3._element, modalTransitionDuration);
        }
      }).emulateTransitionEnd(modalTransitionDuration);

      this._element.focus();
    };

    _proto._showElement = function _showElement(relatedTarget) {
      var _this4 = this;

      var transition = $__default['default'](this._element).hasClass(CLASS_NAME_FADE$1);
      var modalBody = this._dialog ? this._dialog.querySelector(SELECTOR_MODAL_BODY) : null;

      if (!this._element.parentNode || this._element.parentNode.nodeType !== Node.ELEMENT_NODE) {
        // Don't move modal's DOM position
        document.body.appendChild(this._element);
      }

      this._element.style.display = 'block';

      this._element.removeAttribute('aria-hidden');

      this._element.setAttribute('aria-modal', true);

      this._element.setAttribute('role', 'dialog');

      if ($__default['default'](this._dialog).hasClass(CLASS_NAME_SCROLLABLE) && modalBody) {
        modalBody.scrollTop = 0;
      } else {
        this._element.scrollTop = 0;
      }

      if (transition) {
        Util.reflow(this._element);
      }

      $__default['default'](this._element).addClass(CLASS_NAME_SHOW$3);

      if (this._config.focus) {
        this._enforceFocus();
      }

      var shownEvent = $__default['default'].Event(EVENT_SHOWN$2, {
        relatedTarget: relatedTarget
      });

      var transitionComplete = function transitionComplete() {
        if (_this4._config.focus) {
          _this4._element.focus();
        }

        _this4._isTransitioning = false;
        $__default['default'](_this4._element).trigger(shownEvent);
      };

      if (transition) {
        var transitionDuration = Util.getTransitionDurationFromElement(this._dialog);
        $__default['default'](this._dialog).one(Util.TRANSITION_END, transitionComplete).emulateTransitionEnd(transitionDuration);
      } else {
        transitionComplete();
      }
    };

    _proto._enforceFocus = function _enforceFocus() {
      var _this5 = this;

      $__default['default'](document).off(EVENT_FOCUSIN) // Guard against infinite focus loop
      .on(EVENT_FOCUSIN, function (event) {
        if (document !== event.target && _this5._element !== event.target && $__default['default'](_this5._element).has(event.target).length === 0) {
          _this5._element.focus();
        }
      });
    };

    _proto._setEscapeEvent = function _setEscapeEvent() {
      var _this6 = this;

      if (this._isShown) {
        $__default['default'](this._element).on(EVENT_KEYDOWN_DISMISS, function (event) {
          if (_this6._config.keyboard && event.which === ESCAPE_KEYCODE$1) {
            event.preventDefault();

            _this6.hide();
          } else if (!_this6._config.keyboard && event.which === ESCAPE_KEYCODE$1) {
            _this6._triggerBackdropTransition();
          }
        });
      } else if (!this._isShown) {
        $__default['default'](this._element).off(EVENT_KEYDOWN_DISMISS);
      }
    };

    _proto._setResizeEvent = function _setResizeEvent() {
      var _this7 = this;

      if (this._isShown) {
        $__default['default'](window).on(EVENT_RESIZE, function (event) {
          return _this7.handleUpdate(event);
        });
      } else {
        $__default['default'](window).off(EVENT_RESIZE);
      }
    };

    _proto._hideModal = function _hideModal() {
      var _this8 = this;

      this._element.style.display = 'none';

      this._element.setAttribute('aria-hidden', true);

      this._element.removeAttribute('aria-modal');

      this._element.removeAttribute('role');

      this._isTransitioning = false;

      this._showBackdrop(function () {
        $__default['default'](document.body).removeClass(CLASS_NAME_OPEN);

        _this8._resetAdjustments();

        _this8._resetScrollbar();

        $__default['default'](_this8._element).trigger(EVENT_HIDDEN$2);
      });
    };

    _proto._removeBackdrop = function _removeBackdrop() {
      if (this._backdrop) {
        $__default['default'](this._backdrop).remove();
        this._backdrop = null;
      }
    };

    _proto._showBackdrop = function _showBackdrop(callback) {
      var _this9 = this;

      var animate = $__default['default'](this._element).hasClass(CLASS_NAME_FADE$1) ? CLASS_NAME_FADE$1 : '';

      if (this._isShown && this._config.backdrop) {
        this._backdrop = document.createElement('div');
        this._backdrop.className = CLASS_NAME_BACKDROP;

        if (animate) {
          this._backdrop.classList.add(animate);
        }

        $__default['default'](this._backdrop).appendTo(document.body);
        $__default['default'](this._element).on(EVENT_CLICK_DISMISS, function (event) {
          if (_this9._ignoreBackdropClick) {
            _this9._ignoreBackdropClick = false;
            return;
          }

          if (event.target !== event.currentTarget) {
            return;
          }

          if (_this9._config.backdrop === 'static') {
            _this9._triggerBackdropTransition();
          } else {
            _this9.hide();
          }
        });

        if (animate) {
          Util.reflow(this._backdrop);
        }

        $__default['default'](this._backdrop).addClass(CLASS_NAME_SHOW$3);

        if (!callback) {
          return;
        }

        if (!animate) {
          callback();
          return;
        }

        var backdropTransitionDuration = Util.getTransitionDurationFromElement(this._backdrop);
        $__default['default'](this._backdrop).one(Util.TRANSITION_END, callback).emulateTransitionEnd(backdropTransitionDuration);
      } else if (!this._isShown && this._backdrop) {
        $__default['default'](this._backdrop).removeClass(CLASS_NAME_SHOW$3);

        var callbackRemove = function callbackRemove() {
          _this9._removeBackdrop();

          if (callback) {
            callback();
          }
        };

        if ($__default['default'](this._element).hasClass(CLASS_NAME_FADE$1)) {
          var _backdropTransitionDuration = Util.getTransitionDurationFromElement(this._backdrop);

          $__default['default'](this._backdrop).one(Util.TRANSITION_END, callbackRemove).emulateTransitionEnd(_backdropTransitionDuration);
        } else {
          callbackRemove();
        }
      } else if (callback) {
        callback();
      }
    } // ----------------------------------------------------------------------
    // the following methods are used to handle overflowing modals
    // todo (fat): these should probably be refactored out of modal.js
    // ----------------------------------------------------------------------
    ;

    _proto._adjustDialog = function _adjustDialog() {
      var isModalOverflowing = this._element.scrollHeight > document.documentElement.clientHeight;

      if (!this._isBodyOverflowing && isModalOverflowing) {
        this._element.style.paddingLeft = this._scrollbarWidth + "px";
      }

      if (this._isBodyOverflowing && !isModalOverflowing) {
        this._element.style.paddingRight = this._scrollbarWidth + "px";
      }
    };

    _proto._resetAdjustments = function _resetAdjustments() {
      this._element.style.paddingLeft = '';
      this._element.style.paddingRight = '';
    };

    _proto._checkScrollbar = function _checkScrollbar() {
      var rect = document.body.getBoundingClientRect();
      this._isBodyOverflowing = Math.round(rect.left + rect.right) < window.innerWidth;
      this._scrollbarWidth = this._getScrollbarWidth();
    };

    _proto._setScrollbar = function _setScrollbar() {
      var _this10 = this;

      if (this._isBodyOverflowing) {
        // Note: DOMNode.style.paddingRight returns the actual value or '' if not set
        //   while $(DOMNode).css('padding-right') returns the calculated value or 0 if not set
        var fixedContent = [].slice.call(document.querySelectorAll(SELECTOR_FIXED_CONTENT));
        var stickyContent = [].slice.call(document.querySelectorAll(SELECTOR_STICKY_CONTENT)); // Adjust fixed content padding

        $__default['default'](fixedContent).each(function (index, element) {
          var actualPadding = element.style.paddingRight;
          var calculatedPadding = $__default['default'](element).css('padding-right');
          $__default['default'](element).data('padding-right', actualPadding).css('padding-right', parseFloat(calculatedPadding) + _this10._scrollbarWidth + "px");
        }); // Adjust sticky content margin

        $__default['default'](stickyContent).each(function (index, element) {
          var actualMargin = element.style.marginRight;
          var calculatedMargin = $__default['default'](element).css('margin-right');
          $__default['default'](element).data('margin-right', actualMargin).css('margin-right', parseFloat(calculatedMargin) - _this10._scrollbarWidth + "px");
        }); // Adjust body padding

        var actualPadding = document.body.style.paddingRight;
        var calculatedPadding = $__default['default'](document.body).css('padding-right');
        $__default['default'](document.body).data('padding-right', actualPadding).css('padding-right', parseFloat(calculatedPadding) + this._scrollbarWidth + "px");
      }

      $__default['default'](document.body).addClass(CLASS_NAME_OPEN);
    };

    _proto._resetScrollbar = function _resetScrollbar() {
      // Restore fixed content padding
      var fixedContent = [].slice.call(document.querySelectorAll(SELECTOR_FIXED_CONTENT));
      $__default['default'](fixedContent).each(function (index, element) {
        var padding = $__default['default'](element).data('padding-right');
        $__default['default'](element).removeData('padding-right');
        element.style.paddingRight = padding ? padding : '';
      }); // Restore sticky content

      var elements = [].slice.call(document.querySelectorAll("" + SELECTOR_STICKY_CONTENT));
      $__default['default'](elements).each(function (index, element) {
        var margin = $__default['default'](element).data('margin-right');

        if (typeof margin !== 'undefined') {
          $__default['default'](element).css('margin-right', margin).removeData('margin-right');
        }
      }); // Restore body padding

      var padding = $__default['default'](document.body).data('padding-right');
      $__default['default'](document.body).removeData('padding-right');
      document.body.style.paddingRight = padding ? padding : '';
    };

    _proto._getScrollbarWidth = function _getScrollbarWidth() {
      // thx d.walsh
      var scrollDiv = document.createElement('div');
      scrollDiv.className = CLASS_NAME_SCROLLBAR_MEASURER;
      document.body.appendChild(scrollDiv);
      var scrollbarWidth = scrollDiv.getBoundingClientRect().width - scrollDiv.clientWidth;
      document.body.removeChild(scrollDiv);
      return scrollbarWidth;
    } // Static
    ;

    Modal._jQueryInterface = function _jQueryInterface(config, relatedTarget) {
      return this.each(function () {
        var data = $__default['default'](this).data(DATA_KEY$5);

        var _config = _extends({}, Default$3, $__default['default'](this).data(), typeof config === 'object' && config ? config : {});

        if (!data) {
          data = new Modal(this, _config);
          $__default['default'](this).data(DATA_KEY$5, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config](relatedTarget);
        } else if (_config.show) {
          data.show(relatedTarget);
        }
      });
    };

    _createClass(Modal, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$5;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$3;
      }
    }]);

    return Modal;
  }();
  /**
   * ------------------------------------------------------------------------
   * Data Api implementation
   * ------------------------------------------------------------------------
   */


  $__default['default'](document).on(EVENT_CLICK_DATA_API$5, SELECTOR_DATA_TOGGLE$3, function (event) {
    var _this11 = this;

    var target;
    var selector = Util.getSelectorFromElement(this);

    if (selector) {
      target = document.querySelector(selector);
    }

    var config = $__default['default'](target).data(DATA_KEY$5) ? 'toggle' : _extends({}, $__default['default'](target).data(), $__default['default'](this).data());

    if (this.tagName === 'A' || this.tagName === 'AREA') {
      event.preventDefault();
    }

    var $target = $__default['default'](target).one(EVENT_SHOW$2, function (showEvent) {
      if (showEvent.isDefaultPrevented()) {
        // Only register focus restorer if modal will actually get shown
        return;
      }

      $target.one(EVENT_HIDDEN$2, function () {
        if ($__default['default'](_this11).is(':visible')) {
          _this11.focus();
        }
      });
    });

    Modal._jQueryInterface.call($__default['default'](target), config, this);
  });
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   */

  $__default['default'].fn[NAME$5] = Modal._jQueryInterface;
  $__default['default'].fn[NAME$5].Constructor = Modal;

  $__default['default'].fn[NAME$5].noConflict = function () {
    $__default['default'].fn[NAME$5] = JQUERY_NO_CONFLICT$5;
    return Modal._jQueryInterface;
  };

  /**
   * --------------------------------------------------------------------------
   * Bootstrap (v4.6.0): tools/sanitizer.js
   * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
   * --------------------------------------------------------------------------
   */
  var uriAttrs = ['background', 'cite', 'href', 'itemtype', 'longdesc', 'poster', 'src', 'xlink:href'];
  var ARIA_ATTRIBUTE_PATTERN = /^aria-[\w-]*$/i;
  var DefaultWhitelist = {
    // Global attributes allowed on any supplied element below.
    '*': ['class', 'dir', 'id', 'lang', 'role', ARIA_ATTRIBUTE_PATTERN],
    a: ['target', 'href', 'title', 'rel'],
    area: [],
    b: [],
    br: [],
    col: [],
    code: [],
    div: [],
    em: [],
    hr: [],
    h1: [],
    h2: [],
    h3: [],
    h4: [],
    h5: [],
    h6: [],
    i: [],
    img: ['src', 'srcset', 'alt', 'title', 'width', 'height'],
    li: [],
    ol: [],
    p: [],
    pre: [],
    s: [],
    small: [],
    span: [],
    sub: [],
    sup: [],
    strong: [],
    u: [],
    ul: []
  };
  /**
   * A pattern that recognizes a commonly useful subset of URLs that are safe.
   *
   * Shoutout to Angular 7 https://github.com/angular/angular/blob/7.2.4/packages/core/src/sanitization/url_sanitizer.ts
   */

  var SAFE_URL_PATTERN = /^(?:(?:https?|mailto|ftp|tel|file):|[^#&/:?]*(?:[#/?]|$))/gi;
  /**
   * A pattern that matches safe data URLs. Only matches image, video and audio types.
   *
   * Shoutout to Angular 7 https://github.com/angular/angular/blob/7.2.4/packages/core/src/sanitization/url_sanitizer.ts
   */

  var DATA_URL_PATTERN = /^data:(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm)|audio\/(?:mp3|oga|ogg|opus));base64,[\d+/a-z]+=*$/i;

  function allowedAttribute(attr, allowedAttributeList) {
    var attrName = attr.nodeName.toLowerCase();

    if (allowedAttributeList.indexOf(attrName) !== -1) {
      if (uriAttrs.indexOf(attrName) !== -1) {
        return Boolean(attr.nodeValue.match(SAFE_URL_PATTERN) || attr.nodeValue.match(DATA_URL_PATTERN));
      }

      return true;
    }

    var regExp = allowedAttributeList.filter(function (attrRegex) {
      return attrRegex instanceof RegExp;
    }); // Check if a regular expression validates the attribute.

    for (var i = 0, len = regExp.length; i < len; i++) {
      if (attrName.match(regExp[i])) {
        return true;
      }
    }

    return false;
  }

  function sanitizeHtml(unsafeHtml, whiteList, sanitizeFn) {
    if (unsafeHtml.length === 0) {
      return unsafeHtml;
    }

    if (sanitizeFn && typeof sanitizeFn === 'function') {
      return sanitizeFn(unsafeHtml);
    }

    var domParser = new window.DOMParser();
    var createdDocument = domParser.parseFromString(unsafeHtml, 'text/html');
    var whitelistKeys = Object.keys(whiteList);
    var elements = [].slice.call(createdDocument.body.querySelectorAll('*'));

    var _loop = function _loop(i, len) {
      var el = elements[i];
      var elName = el.nodeName.toLowerCase();

      if (whitelistKeys.indexOf(el.nodeName.toLowerCase()) === -1) {
        el.parentNode.removeChild(el);
        return "continue";
      }

      var attributeList = [].slice.call(el.attributes);
      var whitelistedAttributes = [].concat(whiteList['*'] || [], whiteList[elName] || []);
      attributeList.forEach(function (attr) {
        if (!allowedAttribute(attr, whitelistedAttributes)) {
          el.removeAttribute(attr.nodeName);
        }
      });
    };

    for (var i = 0, len = elements.length; i < len; i++) {
      var _ret = _loop(i);

      if (_ret === "continue") continue;
    }

    return createdDocument.body.innerHTML;
  }

  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  var NAME$6 = 'tooltip';
  var VERSION$6 = '4.6.0';
  var DATA_KEY$6 = 'bs.tooltip';
  var EVENT_KEY$6 = "." + DATA_KEY$6;
  var JQUERY_NO_CONFLICT$6 = $__default['default'].fn[NAME$6];
  var CLASS_PREFIX = 'bs-tooltip';
  var BSCLS_PREFIX_REGEX = new RegExp("(^|\\s)" + CLASS_PREFIX + "\\S+", 'g');
  var DISALLOWED_ATTRIBUTES = ['sanitize', 'whiteList', 'sanitizeFn'];
  var DefaultType$4 = {
    animation: 'boolean',
    template: 'string',
    title: '(string|element|function)',
    trigger: 'string',
    delay: '(number|object)',
    html: 'boolean',
    selector: '(string|boolean)',
    placement: '(string|function)',
    offset: '(number|string|function)',
    container: '(string|element|boolean)',
    fallbackPlacement: '(string|array)',
    boundary: '(string|element)',
    customClass: '(string|function)',
    sanitize: 'boolean',
    sanitizeFn: '(null|function)',
    whiteList: 'object',
    popperConfig: '(null|object)'
  };
  var AttachmentMap = {
    AUTO: 'auto',
    TOP: 'top',
    RIGHT: 'right',
    BOTTOM: 'bottom',
    LEFT: 'left'
  };
  var Default$4 = {
    animation: true,
    template: '<div class="tooltip" role="tooltip">' + '<div class="arrow"></div>' + '<div class="tooltip-inner"></div></div>',
    trigger: 'hover focus',
    title: '',
    delay: 0,
    html: false,
    selector: false,
    placement: 'top',
    offset: 0,
    container: false,
    fallbackPlacement: 'flip',
    boundary: 'scrollParent',
    customClass: '',
    sanitize: true,
    sanitizeFn: null,
    whiteList: DefaultWhitelist,
    popperConfig: null
  };
  var HOVER_STATE_SHOW = 'show';
  var HOVER_STATE_OUT = 'out';
  var Event = {
    HIDE: "hide" + EVENT_KEY$6,
    HIDDEN: "hidden" + EVENT_KEY$6,
    SHOW: "show" + EVENT_KEY$6,
    SHOWN: "shown" + EVENT_KEY$6,
    INSERTED: "inserted" + EVENT_KEY$6,
    CLICK: "click" + EVENT_KEY$6,
    FOCUSIN: "focusin" + EVENT_KEY$6,
    FOCUSOUT: "focusout" + EVENT_KEY$6,
    MOUSEENTER: "mouseenter" + EVENT_KEY$6,
    MOUSELEAVE: "mouseleave" + EVENT_KEY$6
  };
  var CLASS_NAME_FADE$2 = 'fade';
  var CLASS_NAME_SHOW$4 = 'show';
  var SELECTOR_TOOLTIP_INNER = '.tooltip-inner';
  var SELECTOR_ARROW = '.arrow';
  var TRIGGER_HOVER = 'hover';
  var TRIGGER_FOCUS = 'focus';
  var TRIGGER_CLICK = 'click';
  var TRIGGER_MANUAL = 'manual';
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  var Tooltip = /*#__PURE__*/function () {
    function Tooltip(element, config) {
      if (typeof Popper__default['default'] === 'undefined') {
        throw new TypeError('Bootstrap\'s tooltips require Popper (https://popper.js.org)');
      } // private


      this._isEnabled = true;
      this._timeout = 0;
      this._hoverState = '';
      this._activeTrigger = {};
      this._popper = null; // Protected

      this.element = element;
      this.config = this._getConfig(config);
      this.tip = null;

      this._setListeners();
    } // Getters


    var _proto = Tooltip.prototype;

    // Public
    _proto.enable = function enable() {
      this._isEnabled = true;
    };

    _proto.disable = function disable() {
      this._isEnabled = false;
    };

    _proto.toggleEnabled = function toggleEnabled() {
      this._isEnabled = !this._isEnabled;
    };

    _proto.toggle = function toggle(event) {
      if (!this._isEnabled) {
        return;
      }

      if (event) {
        var dataKey = this.constructor.DATA_KEY;
        var context = $__default['default'](event.currentTarget).data(dataKey);

        if (!context) {
          context = new this.constructor(event.currentTarget, this._getDelegateConfig());
          $__default['default'](event.currentTarget).data(dataKey, context);
        }

        context._activeTrigger.click = !context._activeTrigger.click;

        if (context._isWithActiveTrigger()) {
          context._enter(null, context);
        } else {
          context._leave(null, context);
        }
      } else {
        if ($__default['default'](this.getTipElement()).hasClass(CLASS_NAME_SHOW$4)) {
          this._leave(null, this);

          return;
        }

        this._enter(null, this);
      }
    };

    _proto.dispose = function dispose() {
      clearTimeout(this._timeout);
      $__default['default'].removeData(this.element, this.constructor.DATA_KEY);
      $__default['default'](this.element).off(this.constructor.EVENT_KEY);
      $__default['default'](this.element).closest('.modal').off('hide.bs.modal', this._hideModalHandler);

      if (this.tip) {
        $__default['default'](this.tip).remove();
      }

      this._isEnabled = null;
      this._timeout = null;
      this._hoverState = null;
      this._activeTrigger = null;

      if (this._popper) {
        this._popper.destroy();
      }

      this._popper = null;
      this.element = null;
      this.config = null;
      this.tip = null;
    };

    _proto.show = function show() {
      var _this = this;

      if ($__default['default'](this.element).css('display') === 'none') {
        throw new Error('Please use show on visible elements');
      }

      var showEvent = $__default['default'].Event(this.constructor.Event.SHOW);

      if (this.isWithContent() && this._isEnabled) {
        $__default['default'](this.element).trigger(showEvent);
        var shadowRoot = Util.findShadowRoot(this.element);
        var isInTheDom = $__default['default'].contains(shadowRoot !== null ? shadowRoot : this.element.ownerDocument.documentElement, this.element);

        if (showEvent.isDefaultPrevented() || !isInTheDom) {
          return;
        }

        var tip = this.getTipElement();
        var tipId = Util.getUID(this.constructor.NAME);
        tip.setAttribute('id', tipId);
        this.element.setAttribute('aria-describedby', tipId);
        this.setContent();

        if (this.config.animation) {
          $__default['default'](tip).addClass(CLASS_NAME_FADE$2);
        }

        var placement = typeof this.config.placement === 'function' ? this.config.placement.call(this, tip, this.element) : this.config.placement;

        var attachment = this._getAttachment(placement);

        this.addAttachmentClass(attachment);

        var container = this._getContainer();

        $__default['default'](tip).data(this.constructor.DATA_KEY, this);

        if (!$__default['default'].contains(this.element.ownerDocument.documentElement, this.tip)) {
          $__default['default'](tip).appendTo(container);
        }

        $__default['default'](this.element).trigger(this.constructor.Event.INSERTED);
        this._popper = new Popper__default['default'](this.element, tip, this._getPopperConfig(attachment));
        $__default['default'](tip).addClass(CLASS_NAME_SHOW$4);
        $__default['default'](tip).addClass(this.config.customClass); // If this is a touch-enabled device we add extra
        // empty mouseover listeners to the body's immediate children;
        // only needed because of broken event delegation on iOS
        // https://www.quirksmode.org/blog/archives/2014/02/mouse_event_bub.html

        if ('ontouchstart' in document.documentElement) {
          $__default['default'](document.body).children().on('mouseover', null, $__default['default'].noop);
        }

        var complete = function complete() {
          if (_this.config.animation) {
            _this._fixTransition();
          }

          var prevHoverState = _this._hoverState;
          _this._hoverState = null;
          $__default['default'](_this.element).trigger(_this.constructor.Event.SHOWN);

          if (prevHoverState === HOVER_STATE_OUT) {
            _this._leave(null, _this);
          }
        };

        if ($__default['default'](this.tip).hasClass(CLASS_NAME_FADE$2)) {
          var transitionDuration = Util.getTransitionDurationFromElement(this.tip);
          $__default['default'](this.tip).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);
        } else {
          complete();
        }
      }
    };

    _proto.hide = function hide(callback) {
      var _this2 = this;

      var tip = this.getTipElement();
      var hideEvent = $__default['default'].Event(this.constructor.Event.HIDE);

      var complete = function complete() {
        if (_this2._hoverState !== HOVER_STATE_SHOW && tip.parentNode) {
          tip.parentNode.removeChild(tip);
        }

        _this2._cleanTipClass();

        _this2.element.removeAttribute('aria-describedby');

        $__default['default'](_this2.element).trigger(_this2.constructor.Event.HIDDEN);

        if (_this2._popper !== null) {
          _this2._popper.destroy();
        }

        if (callback) {
          callback();
        }
      };

      $__default['default'](this.element).trigger(hideEvent);

      if (hideEvent.isDefaultPrevented()) {
        return;
      }

      $__default['default'](tip).removeClass(CLASS_NAME_SHOW$4); // If this is a touch-enabled device we remove the extra
      // empty mouseover listeners we added for iOS support

      if ('ontouchstart' in document.documentElement) {
        $__default['default'](document.body).children().off('mouseover', null, $__default['default'].noop);
      }

      this._activeTrigger[TRIGGER_CLICK] = false;
      this._activeTrigger[TRIGGER_FOCUS] = false;
      this._activeTrigger[TRIGGER_HOVER] = false;

      if ($__default['default'](this.tip).hasClass(CLASS_NAME_FADE$2)) {
        var transitionDuration = Util.getTransitionDurationFromElement(tip);
        $__default['default'](tip).one(Util.TRANSITION_END, complete).emulateTransitionEnd(transitionDuration);
      } else {
        complete();
      }

      this._hoverState = '';
    };

    _proto.update = function update() {
      if (this._popper !== null) {
        this._popper.scheduleUpdate();
      }
    } // Protected
    ;

    _proto.isWithContent = function isWithContent() {
      return Boolean(this.getTitle());
    };

    _proto.addAttachmentClass = function addAttachmentClass(attachment) {
      $__default['default'](this.getTipElement()).addClass(CLASS_PREFIX + "-" + attachment);
    };

    _proto.getTipElement = function getTipElement() {
      this.tip = this.tip || $__default['default'](this.config.template)[0];
      return this.tip;
    };

    _proto.setContent = function setContent() {
      var tip = this.getTipElement();
      this.setElementContent($__default['default'](tip.querySelectorAll(SELECTOR_TOOLTIP_INNER)), this.getTitle());
      $__default['default'](tip).removeClass(CLASS_NAME_FADE$2 + " " + CLASS_NAME_SHOW$4);
    };

    _proto.setElementContent = function setElementContent($element, content) {
      if (typeof content === 'object' && (content.nodeType || content.jquery)) {
        // Content is a DOM node or a jQuery
        if (this.config.html) {
          if (!$__default['default'](content).parent().is($element)) {
            $element.empty().append(content);
          }
        } else {
          $element.text($__default['default'](content).text());
        }

        return;
      }

      if (this.config.html) {
        if (this.config.sanitize) {
          content = sanitizeHtml(content, this.config.whiteList, this.config.sanitizeFn);
        }

        $element.html(content);
      } else {
        $element.text(content);
      }
    };

    _proto.getTitle = function getTitle() {
      var title = this.element.getAttribute('data-original-title');

      if (!title) {
        title = typeof this.config.title === 'function' ? this.config.title.call(this.element) : this.config.title;
      }

      return title;
    } // Private
    ;

    _proto._getPopperConfig = function _getPopperConfig(attachment) {
      var _this3 = this;

      var defaultBsConfig = {
        placement: attachment,
        modifiers: {
          offset: this._getOffset(),
          flip: {
            behavior: this.config.fallbackPlacement
          },
          arrow: {
            element: SELECTOR_ARROW
          },
          preventOverflow: {
            boundariesElement: this.config.boundary
          }
        },
        onCreate: function onCreate(data) {
          if (data.originalPlacement !== data.placement) {
            _this3._handlePopperPlacementChange(data);
          }
        },
        onUpdate: function onUpdate(data) {
          return _this3._handlePopperPlacementChange(data);
        }
      };
      return _extends({}, defaultBsConfig, this.config.popperConfig);
    };

    _proto._getOffset = function _getOffset() {
      var _this4 = this;

      var offset = {};

      if (typeof this.config.offset === 'function') {
        offset.fn = function (data) {
          data.offsets = _extends({}, data.offsets, _this4.config.offset(data.offsets, _this4.element) || {});
          return data;
        };
      } else {
        offset.offset = this.config.offset;
      }

      return offset;
    };

    _proto._getContainer = function _getContainer() {
      if (this.config.container === false) {
        return document.body;
      }

      if (Util.isElement(this.config.container)) {
        return $__default['default'](this.config.container);
      }

      return $__default['default'](document).find(this.config.container);
    };

    _proto._getAttachment = function _getAttachment(placement) {
      return AttachmentMap[placement.toUpperCase()];
    };

    _proto._setListeners = function _setListeners() {
      var _this5 = this;

      var triggers = this.config.trigger.split(' ');
      triggers.forEach(function (trigger) {
        if (trigger === 'click') {
          $__default['default'](_this5.element).on(_this5.constructor.Event.CLICK, _this5.config.selector, function (event) {
            return _this5.toggle(event);
          });
        } else if (trigger !== TRIGGER_MANUAL) {
          var eventIn = trigger === TRIGGER_HOVER ? _this5.constructor.Event.MOUSEENTER : _this5.constructor.Event.FOCUSIN;
          var eventOut = trigger === TRIGGER_HOVER ? _this5.constructor.Event.MOUSELEAVE : _this5.constructor.Event.FOCUSOUT;
          $__default['default'](_this5.element).on(eventIn, _this5.config.selector, function (event) {
            return _this5._enter(event);
          }).on(eventOut, _this5.config.selector, function (event) {
            return _this5._leave(event);
          });
        }
      });

      this._hideModalHandler = function () {
        if (_this5.element) {
          _this5.hide();
        }
      };

      $__default['default'](this.element).closest('.modal').on('hide.bs.modal', this._hideModalHandler);

      if (this.config.selector) {
        this.config = _extends({}, this.config, {
          trigger: 'manual',
          selector: ''
        });
      } else {
        this._fixTitle();
      }
    };

    _proto._fixTitle = function _fixTitle() {
      var titleType = typeof this.element.getAttribute('data-original-title');

      if (this.element.getAttribute('title') || titleType !== 'string') {
        this.element.setAttribute('data-original-title', this.element.getAttribute('title') || '');
        this.element.setAttribute('title', '');
      }
    };

    _proto._enter = function _enter(event, context) {
      var dataKey = this.constructor.DATA_KEY;
      context = context || $__default['default'](event.currentTarget).data(dataKey);

      if (!context) {
        context = new this.constructor(event.currentTarget, this._getDelegateConfig());
        $__default['default'](event.currentTarget).data(dataKey, context);
      }

      if (event) {
        context._activeTrigger[event.type === 'focusin' ? TRIGGER_FOCUS : TRIGGER_HOVER] = true;
      }

      if ($__default['default'](context.getTipElement()).hasClass(CLASS_NAME_SHOW$4) || context._hoverState === HOVER_STATE_SHOW) {
        context._hoverState = HOVER_STATE_SHOW;
        return;
      }

      clearTimeout(context._timeout);
      context._hoverState = HOVER_STATE_SHOW;

      if (!context.config.delay || !context.config.delay.show) {
        context.show();
        return;
      }

      context._timeout = setTimeout(function () {
        if (context._hoverState === HOVER_STATE_SHOW) {
          context.show();
        }
      }, context.config.delay.show);
    };

    _proto._leave = function _leave(event, context) {
      var dataKey = this.constructor.DATA_KEY;
      context = context || $__default['default'](event.currentTarget).data(dataKey);

      if (!context) {
        context = new this.constructor(event.currentTarget, this._getDelegateConfig());
        $__default['default'](event.currentTarget).data(dataKey, context);
      }

      if (event) {
        context._activeTrigger[event.type === 'focusout' ? TRIGGER_FOCUS : TRIGGER_HOVER] = false;
      }

      if (context._isWithActiveTrigger()) {
        return;
      }

      clearTimeout(context._timeout);
      context._hoverState = HOVER_STATE_OUT;

      if (!context.config.delay || !context.config.delay.hide) {
        context.hide();
        return;
      }

      context._timeout = setTimeout(function () {
        if (context._hoverState === HOVER_STATE_OUT) {
          context.hide();
        }
      }, context.config.delay.hide);
    };

    _proto._isWithActiveTrigger = function _isWithActiveTrigger() {
      for (var trigger in this._activeTrigger) {
        if (this._activeTrigger[trigger]) {
          return true;
        }
      }

      return false;
    };

    _proto._getConfig = function _getConfig(config) {
      var dataAttributes = $__default['default'](this.element).data();
      Object.keys(dataAttributes).forEach(function (dataAttr) {
        if (DISALLOWED_ATTRIBUTES.indexOf(dataAttr) !== -1) {
          delete dataAttributes[dataAttr];
        }
      });
      config = _extends({}, this.constructor.Default, dataAttributes, typeof config === 'object' && config ? config : {});

      if (typeof config.delay === 'number') {
        config.delay = {
          show: config.delay,
          hide: config.delay
        };
      }

      if (typeof config.title === 'number') {
        config.title = config.title.toString();
      }

      if (typeof config.content === 'number') {
        config.content = config.content.toString();
      }

      Util.typeCheckConfig(NAME$6, config, this.constructor.DefaultType);

      if (config.sanitize) {
        config.template = sanitizeHtml(config.template, config.whiteList, config.sanitizeFn);
      }

      return config;
    };

    _proto._getDelegateConfig = function _getDelegateConfig() {
      var config = {};

      if (this.config) {
        for (var key in this.config) {
          if (this.constructor.Default[key] !== this.config[key]) {
            config[key] = this.config[key];
          }
        }
      }

      return config;
    };

    _proto._cleanTipClass = function _cleanTipClass() {
      var $tip = $__default['default'](this.getTipElement());
      var tabClass = $tip.attr('class').match(BSCLS_PREFIX_REGEX);

      if (tabClass !== null && tabClass.length) {
        $tip.removeClass(tabClass.join(''));
      }
    };

    _proto._handlePopperPlacementChange = function _handlePopperPlacementChange(popperData) {
      this.tip = popperData.instance.popper;

      this._cleanTipClass();

      this.addAttachmentClass(this._getAttachment(popperData.placement));
    };

    _proto._fixTransition = function _fixTransition() {
      var tip = this.getTipElement();
      var initConfigAnimation = this.config.animation;

      if (tip.getAttribute('x-placement') !== null) {
        return;
      }

      $__default['default'](tip).removeClass(CLASS_NAME_FADE$2);
      this.config.animation = false;
      this.hide();
      this.show();
      this.config.animation = initConfigAnimation;
    } // Static
    ;

    Tooltip._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var $element = $__default['default'](this);
        var data = $element.data(DATA_KEY$6);

        var _config = typeof config === 'object' && config;

        if (!data && /dispose|hide/.test(config)) {
          return;
        }

        if (!data) {
          data = new Tooltip(this, _config);
          $element.data(DATA_KEY$6, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config]();
        }
      });
    };

    _createClass(Tooltip, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$6;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$4;
      }
    }, {
      key: "NAME",
      get: function get() {
        return NAME$6;
      }
    }, {
      key: "DATA_KEY",
      get: function get() {
        return DATA_KEY$6;
      }
    }, {
      key: "Event",
      get: function get() {
        return Event;
      }
    }, {
      key: "EVENT_KEY",
      get: function get() {
        return EVENT_KEY$6;
      }
    }, {
      key: "DefaultType",
      get: function get() {
        return DefaultType$4;
      }
    }]);

    return Tooltip;
  }();
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   */


  $__default['default'].fn[NAME$6] = Tooltip._jQueryInterface;
  $__default['default'].fn[NAME$6].Constructor = Tooltip;

  $__default['default'].fn[NAME$6].noConflict = function () {
    $__default['default'].fn[NAME$6] = JQUERY_NO_CONFLICT$6;
    return Tooltip._jQueryInterface;
  };

  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  var NAME$7 = 'popover';
  var VERSION$7 = '4.6.0';
  var DATA_KEY$7 = 'bs.popover';
  var EVENT_KEY$7 = "." + DATA_KEY$7;
  var JQUERY_NO_CONFLICT$7 = $__default['default'].fn[NAME$7];
  var CLASS_PREFIX$1 = 'bs-popover';
  var BSCLS_PREFIX_REGEX$1 = new RegExp("(^|\\s)" + CLASS_PREFIX$1 + "\\S+", 'g');

  var Default$5 = _extends({}, Tooltip.Default, {
    placement: 'right',
    trigger: 'click',
    content: '',
    template: '<div class="popover" role="tooltip">' + '<div class="arrow"></div>' + '<h3 class="popover-header"></h3>' + '<div class="popover-body"></div></div>'
  });

  var DefaultType$5 = _extends({}, Tooltip.DefaultType, {
    content: '(string|element|function)'
  });

  var CLASS_NAME_FADE$3 = 'fade';
  var CLASS_NAME_SHOW$5 = 'show';
  var SELECTOR_TITLE = '.popover-header';
  var SELECTOR_CONTENT = '.popover-body';
  var Event$1 = {
    HIDE: "hide" + EVENT_KEY$7,
    HIDDEN: "hidden" + EVENT_KEY$7,
    SHOW: "show" + EVENT_KEY$7,
    SHOWN: "shown" + EVENT_KEY$7,
    INSERTED: "inserted" + EVENT_KEY$7,
    CLICK: "click" + EVENT_KEY$7,
    FOCUSIN: "focusin" + EVENT_KEY$7,
    FOCUSOUT: "focusout" + EVENT_KEY$7,
    MOUSEENTER: "mouseenter" + EVENT_KEY$7,
    MOUSELEAVE: "mouseleave" + EVENT_KEY$7
  };
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  var Popover = /*#__PURE__*/function (_Tooltip) {
    _inheritsLoose(Popover, _Tooltip);

    function Popover() {
      return _Tooltip.apply(this, arguments) || this;
    }

    var _proto = Popover.prototype;

    // Overrides
    _proto.isWithContent = function isWithContent() {
      return this.getTitle() || this._getContent();
    };

    _proto.addAttachmentClass = function addAttachmentClass(attachment) {
      $__default['default'](this.getTipElement()).addClass(CLASS_PREFIX$1 + "-" + attachment);
    };

    _proto.getTipElement = function getTipElement() {
      this.tip = this.tip || $__default['default'](this.config.template)[0];
      return this.tip;
    };

    _proto.setContent = function setContent() {
      var $tip = $__default['default'](this.getTipElement()); // We use append for html objects to maintain js events

      this.setElementContent($tip.find(SELECTOR_TITLE), this.getTitle());

      var content = this._getContent();

      if (typeof content === 'function') {
        content = content.call(this.element);
      }

      this.setElementContent($tip.find(SELECTOR_CONTENT), content);
      $tip.removeClass(CLASS_NAME_FADE$3 + " " + CLASS_NAME_SHOW$5);
    } // Private
    ;

    _proto._getContent = function _getContent() {
      return this.element.getAttribute('data-content') || this.config.content;
    };

    _proto._cleanTipClass = function _cleanTipClass() {
      var $tip = $__default['default'](this.getTipElement());
      var tabClass = $tip.attr('class').match(BSCLS_PREFIX_REGEX$1);

      if (tabClass !== null && tabClass.length > 0) {
        $tip.removeClass(tabClass.join(''));
      }
    } // Static
    ;

    Popover._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var data = $__default['default'](this).data(DATA_KEY$7);

        var _config = typeof config === 'object' ? config : null;

        if (!data && /dispose|hide/.test(config)) {
          return;
        }

        if (!data) {
          data = new Popover(this, _config);
          $__default['default'](this).data(DATA_KEY$7, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config]();
        }
      });
    };

    _createClass(Popover, null, [{
      key: "VERSION",
      // Getters
      get: function get() {
        return VERSION$7;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$5;
      }
    }, {
      key: "NAME",
      get: function get() {
        return NAME$7;
      }
    }, {
      key: "DATA_KEY",
      get: function get() {
        return DATA_KEY$7;
      }
    }, {
      key: "Event",
      get: function get() {
        return Event$1;
      }
    }, {
      key: "EVENT_KEY",
      get: function get() {
        return EVENT_KEY$7;
      }
    }, {
      key: "DefaultType",
      get: function get() {
        return DefaultType$5;
      }
    }]);

    return Popover;
  }(Tooltip);
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * ------------------------------------------------------------------------
   */


  $__default['default'].fn[NAME$7] = Popover._jQueryInterface;
  $__default['default'].fn[NAME$7].Constructor = Popover;

  $__default['default'].fn[NAME$7].noConflict = function () {
    $__default['default'].fn[NAME$7] = JQUERY_NO_CONFLICT$7;
    return Popover._jQueryInterface;
  };

  /**
   * ------------------------------------------------------------------------
   * Constants
   * ------------------------------------------------------------------------
   */

  var NAME$8 = 'scrollspy';
  var VERSION$8 = '4.6.0';
  var DATA_KEY$8 = 'bs.scrollspy';
  var EVENT_KEY$8 = "." + DATA_KEY$8;
  var DATA_API_KEY$6 = '.data-api';
  var JQUERY_NO_CONFLICT$8 = $__default['default'].fn[NAME$8];
  var Default$6 = {
    offset: 10,
    method: 'auto',
    target: ''
  };
  var DefaultType$6 = {
    offset: 'number',
    method: 'string',
    target: '(string|element)'
  };
  var EVENT_ACTIVATE = "activate" + EVENT_KEY$8;
  var EVENT_SCROLL = "scroll" + EVENT_KEY$8;
  var EVENT_LOAD_DATA_API$2 = "load" + EVENT_KEY$8 + DATA_API_KEY$6;
  var CLASS_NAME_DROPDOWN_ITEM = 'dropdown-item';
  var CLASS_NAME_ACTIVE$2 = 'active';
  var SELECTOR_DATA_SPY = '[data-spy="scroll"]';
  var SELECTOR_NAV_LIST_GROUP = '.nav, .list-group';
  var SELECTOR_NAV_LINKS = '.nav-link';
  var SELECTOR_NAV_ITEMS = '.nav-item';
  var SELECTOR_LIST_ITEMS = '.list-group-item';
  var SELECTOR_DROPDOWN = '.dropdown';
  var SELECTOR_DROPDOWN_ITEMS = '.dropdown-item';
  var SELECTOR_DROPDOWN_TOGGLE = '.dropdown-toggle';
  var METHOD_OFFSET = 'offset';
  var METHOD_POSITION = 'position';
  /**
   * ------------------------------------------------------------------------
   * Class Definition
   * ------------------------------------------------------------------------
   */

  var ScrollSpy = /*#__PURE__*/function () {
    function ScrollSpy(element, config) {
      var _this = this;

      this._element = element;
      this._scrollElement = element.tagName === 'BODY' ? window : element;
      this._config = this._getConfig(config);
      this._selector = this._config.target + " " + SELECTOR_NAV_LINKS + "," + (this._config.target + " " + SELECTOR_LIST_ITEMS + ",") + (this._config.target + " " + SELECTOR_DROPDOWN_ITEMS);
      this._offsets = [];
      this._targets = [];
      this._activeTarget = null;
      this._scrollHeight = 0;
      $__default['default'](this._scrollElement).on(EVENT_SCROLL, function (event) {
        return _this._process(event);
      });
      this.refresh();

      this._process();
    } // Getters


    var _proto = ScrollSpy.prototype;

    // Public
    _proto.refresh = function refresh() {
      var _this2 = this;

      var autoMethod = this._scrollElement === this._scrollElement.window ? METHOD_OFFSET : METHOD_POSITION;
      var offsetMethod = this._config.method === 'auto' ? autoMethod : this._config.method;
      var offsetBase = offsetMethod === METHOD_POSITION ? this._getScrollTop() : 0;
      this._offsets = [];
      this._targets = [];
      this._scrollHeight = this._getScrollHeight();
      var targets = [].slice.call(document.querySelectorAll(this._selector));
      targets.map(function (element) {
        var target;
        var targetSelector = Util.getSelectorFromElement(element);

        if (targetSelector) {
          target = document.querySelector(targetSelector);
        }

        if (target) {
          var targetBCR = target.getBoundingClientRect();

          if (targetBCR.width || targetBCR.height) {
            // TODO (fat): remove sketch reliance on jQuery position/offset
            return [$__default['default'](target)[offsetMethod]().top + offsetBase, targetSelector];
          }
        }

        return null;
      }).filter(function (item) {
        return item;
      }).sort(function (a, b) {
        return a[0] - b[0];
      }).forEach(function (item) {
        _this2._offsets.push(item[0]);

        _this2._targets.push(item[1]);
      });
    };

    _proto.dispose = function dispose() {
      $__default['default'].removeData(this._element, DATA_KEY$8);
      $__default['default'](this._scrollElement).off(EVENT_KEY$8);
      this._element = null;
      this._scrollElement = null;
      this._config = null;
      this._selector = null;
      this._offsets = null;
      this._targets = null;
      this._activeTarget = null;
      this._scrollHeight = null;
    } // Private
    ;

    _proto._getConfig = function _getConfig(config) {
      config = _extends({}, Default$6, typeof config === 'object' && config ? config : {});

      if (typeof config.target !== 'string' && Util.isElement(config.target)) {
        var id = $__default['default'](config.target).attr('id');

        if (!id) {
          id = Util.getUID(NAME$8);
          $__default['default'](config.target).attr('id', id);
        }

        config.target = "#" + id;
      }

      Util.typeCheckConfig(NAME$8, config, DefaultType$6);
      return config;
    };

    _proto._getScrollTop = function _getScrollTop() {
      return this._scrollElement === window ? this._scrollElement.pageYOffset : this._scrollElement.scrollTop;
    };

    _proto._getScrollHeight = function _getScrollHeight() {
      return this._scrollElement.scrollHeight || Math.max(document.body.scrollHeight, document.documentElement.scrollHeight);
    };

    _proto._getOffsetHeight = function _getOffsetHeight() {
      return this._scrollElement === window ? window.innerHeight : this._scrollElement.getBoundingClientRect().height;
    };

    _proto._process = function _process() {
      var scrollTop = this._getScrollTop() + this._config.offset;

      var scrollHeight = this._getScrollHeight();

      var maxScroll = this._config.offset + scrollHeight - this._getOffsetHeight();

      if (this._scrollHeight !== scrollHeight) {
        this.refresh();
      }

      if (scrollTop >= maxScroll) {
        var target = this._targets[this._targets.length - 1];

        if (this._activeTarget !== target) {
          this._activate(target);
        }

        return;
      }

      if (this._activeTarget && scrollTop < this._offsets[0] && this._offsets[0] > 0) {
        this._activeTarget = null;

        this._clear();

        return;
      }

      for (var i = this._offsets.length; i--;) {
        var isActiveTarget = this._activeTarget !== this._targets[i] && scrollTop >= this._offsets[i] && (typeof this._offsets[i + 1] === 'undefined' || scrollTop < this._offsets[i + 1]);

        if (isActiveTarget) {
          this._activate(this._targets[i]);
        }
      }
    };

    _proto._activate = function _activate(target) {
      this._activeTarget = target;

      this._clear();

      var queries = this._selector.split(',').map(function (selector) {
        return selector + "[data-target=\"" + target + "\"]," + selector + "[href=\"" + target + "\"]";
      });

      var $link = $__default['default']([].slice.call(document.querySelectorAll(queries.join(','))));

      if ($link.hasClass(CLASS_NAME_DROPDOWN_ITEM)) {
        $link.closest(SELECTOR_DROPDOWN).find(SELECTOR_DROPDOWN_TOGGLE).addClass(CLASS_NAME_ACTIVE$2);
        $link.addClass(CLASS_NAME_ACTIVE$2);
      } else {
        // Set triggered link as active
        $link.addClass(CLASS_NAME_ACTIVE$2); // Set triggered links parents as active
        // With both <ul> and <nav> markup a parent is the previous sibling of any nav ancestor

        $link.parents(SELECTOR_NAV_LIST_GROUP).prev(SELECTOR_NAV_LINKS + ", " + SELECTOR_LIST_ITEMS).addClass(CLASS_NAME_ACTIVE$2); // Handle special case when .nav-link is inside .nav-item

        $link.parents(SELECTOR_NAV_LIST_GROUP).prev(SELECTOR_NAV_ITEMS).children(SELECTOR_NAV_LINKS).addClass(CLASS_NAME_ACTIVE$2);
      }

      $__default['default'](this._scrollElement).trigger(EVENT_ACTIVATE, {
        relatedTarget: target
      });
    };

    _proto._clear = function _clear() {
      [].slice.call(document.querySelectorAll(this._selector)).filter(function (node) {
        return node.classList.contains(CLASS_NAME_ACTIVE$2);
      }).forEach(function (node) {
        return node.classList.remove(CLASS_NAME_ACTIVE$2);
      });
    } // Static
    ;

    ScrollSpy._jQueryInterface = function _jQueryInterface(config) {
      return this.each(function () {
        var data = $__default['default'](this).data(DATA_KEY$8);

        var _config = typeof config === 'object' && config;

        if (!data) {
          data = new ScrollSpy(this, _config);
          $__default['default'](this).data(DATA_KEY$8, data);
        }

        if (typeof config === 'string') {
          if (typeof data[config] === 'undefined') {
            throw new TypeError("No method named \"" + config + "\"");
          }

          data[config]();
        }
      });
    };

    _createClass(ScrollSpy, null, [{
      key: "VERSION",
      get: function get() {
        return VERSION$8;
      }
    }, {
      key: "Default",
      get: function get() {
        return Default$6;
      }
    }]);

    return ScrollSpy;
  }();
  /**
   * ------------------------------------------------------------------------
   * Data Api implementation
   * ------------------------------------------------------------------------
   */


  $__default['default'](window).on(EVENT_LOAD_DATA_API$2, function () {
    var scrollSpys = [].slice.call(document.querySelectorAll(SELECTOR_DATA_SPY));
    var scrollSpysLength = scrollSpys.length;

    for (var i = scrollSpysLength; i--;) {
      var $spy = $__default['default'](scrollSpys[i]);

      ScrollSpy._jQueryInterface.call($spy, $spy.data());
    }
  });
  /**
   * ------------------------------------------------------------------------
   * jQuery
   * 