<?php

namespace Tests\Browser\Modules\Blog;

use App\Models\User;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Laravel\Dusk\Browser;
use Modules\Blog\Entities\BlogPost;
use Tests\DuskTestCase;
use Carbon\Carbon;
use Illuminate\Foundation\Testing\WithFaker;
use Modules\Blog\Entities\BlogCategory;
use Modules\Blog\Entities\BlogTag;

class PostTest extends DuskTestCase
{
    use WithFaker;

    protected $categories = [];

    public function setUp(): void
    {
        parent::setUp();


        for ($i = 0; $i < 3; $i++) {
            $this->categories[] = BlogCategory::create([
                'name' => $this->faker->name,
                'slug' => $this->faker->slug,
                'level' => 1,
                'parent_id' => 0
            ]);
        }

    }

    public function tearDown(): void
    {
        $posts = BlogPost::pluck('id');
        BlogPost::destroy($posts);

        $tags = BlogTag::pluck('id');
        BlogTag::destroy($tags);

        foreach($this->categories as $category){
            $category->delete();
        }

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                    ->visit('/blog/posts')
                    ->assertSee('Blog List');
        });


    }

    public function test_for_create_blog_post(){
        $this->test_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#add_new_btn')
                ->assertPathIs('/blog/posts/create')
                ->assertSee('Add New Post')
                ->type('#title', $this->faker->title)
                ->pause(1000)
                ->click('#laraberg__editor > div > div > div.components-navigate-regions > div > div.interface-interface-skeleton__body > div.interface-interface-skeleton__content > div.edit-post-visual-editor.editor-styles-wrapper > div.block-editor__typewriter > div > div')
                ->type('#laraberg__editor > div > div > div.components-navigate-regions > div > div.interface-interface-skeleton__body > div.interface-interface-skeleton__content > div.edit-post-visual-editor.editor-styles-wrapper > div.block-editor__typewriter > div > div > div:nth-child(2) > div:nth-child(2) > div:nth-child(2) > div > p', $this->faker->paragraph)
                ->pause(1000)
                ->click('#main-content > section > div > form > div > div.col-lg-3.upload_item_area > div > div > div:nth-child(2) > div > div')
                ->click('#main-content > section > div > form > div > div.col-lg-3.upload_item_area > div > div > div:nth-child(2) > div > div > ul > li:nth-child(1)')
                ->click('#main-content > section > div > form > div > div.col-lg-3.upload_item_area > div > div > div:nth-child(2) > div > div')
                ->click('#main-content > section > div > form > div > div.col-lg-3.upload_item_area > div > div > div:nth-child(2) > div > div > ul > li:nth-child(2)')
                ->type('#main-content > section > div > form > div > div.col-lg-3.upload_item_area > div > div > div:nth-child(3) > div.tagInput_field.mb_26 > div > input[type=text]', 'tag 1')
                ->attach('#document_file_1', public_path('/frontend/default/img/blog/single_blog_1.png'))
                ->click('#publish')
                ->click('#main-content > section > div > form > div > div.col-lg-3.upload_item_area > div > div > div.col-12 > button')
                ->pause(1000)
                ->acceptDialog()
                ->assertPathIs('/blog/posts')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Operation done successfully.');
        });
    }

    public function test_for_edit_blog_post(){
        $this->test_for_create_blog_post();
        $this->browse(function (Browser $browser) {
            $post = BlogPost::latest()->first();
            $browser->waitFor('#postTable > tbody > tr > td:nth-child(7) > div > button', 25)
                ->click('#postTable > tbody > tr > td:nth-child(7) > div > button')
                ->click('#postTable > tbody > tr > td:nth-child(7) > div > div > a:nth-child(2)')
                ->assertPathIs('/blog/posts/'.$post->id.'/edit')
                ->assertSee('Edit Post')
                ->type('#title', $this->faker->title)
                ->pause(1000)
                ->click('#laraberg__editor > div > div > div.components-navigate-regions > div > div.interface-interface-skeleton__body > div.interface-interface-skeleton__content > div.edit-post-visual-editor.editor-styles-wrapper > div.block-editor__typewriter > div > div > div:nth-child(2) > div:nth-child(2) > div:nth-child(2) > div')
                ->type('#laraberg__editor > div > div > div.components-navigate-regions > div > div.interface-interface-skeleton__body > div.interface-interface-skeleton__content > div.edit-post-visual-editor.editor-styles-wrapper > div.block-editor__typewriter > div > div > div:nth-child(2) > div:nth-child(2) > div:nth-child(2) > div > p', $this->faker->paragraph)
                ->pause(1000)
                ->click('#main-content > section > div.container-fluid.p-0 > form > div > div.col-lg-3.upload_item_area > div > div > div:nth-child(2) > div > div')
                ->click('#main-content > section > div.container-fluid.p-0 > form > div > div.col-lg-3.upload_item_area > div > div > div:nth-child(2) > div > div > ul > li:nth-child(2)')
                ->click('#main-content > section > div.container-fluid.p-0 > form > div > div.col-lg-3.upload_item_area > div > div > div:nth-child(2) > div > div')
                ->click('#main-content > section > div > form > div > div.col-lg-3.upload_item_area > div > div > div:nth-child(2) > div > div > ul > li:nth-child(3)')
                ->type('#main-content > section > div.container-fluid.p-0 > form > div > div.col-lg-3.upload_item_area > div > div > div:nth-child(3) > div.tagInput_field.mb_26 > div > input[type=text]', 'tag 2')
                ->attach('#document_file_1', public_path('/frontend/default/img/blog/single_blog_2.png'))
                ->click('#main-content > section > div.container-fluid.p-0 > form > div > div.col-lg-3.upload_item_area > div > div > div:nth-child(7) > div:nth-child(2) > input')
                ->click('#update_btn')
                ->pause(1000)
                ->acceptDialog()
                ->assertPathIs('/blog/posts')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Operation done successfully.');
        });
    }

    public function test_for_delete_edit_img(){
        $this->test_for_create_blog_post();
        $this->browse(function (Browser $browser) {
            $post = BlogPost::latest()->first();
            $browser->waitFor('#postTable > tbody > tr > td:nth-child(7) > div > button', 25)
                ->click('#postTable > tbody > tr > td:nth-child(7) > div > button')
                ->click('#postTable > tbody > tr > td:nth-child(7) > div > div > a:nth-child(2)')
                ->assertPathIs('/blog/posts/'.$post->id.'/edit')
                ->assertSee('Edit Post')
                ->click('#documentCrossPost')
                ->whenAvailable('#imgForm', function($modal){
                    $modal->click('#document_delete_btn');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');
        });
    }

    public function test_for_show_blog(){
        $this->test_for_create_blog_post();
        $this->browse(function (Browser $browser) {
            $post = BlogPost::latest()->first();
            $browser->waitFor('#postTable > tbody > tr > td:nth-child(7) > div > button', 25)
                ->click('#postTable > tbody > tr > td:nth-child(7) > div > button')
                ->click('#postTable > tbody > tr > td:nth-child(7) > div > div > a:nth-child(1)')
                ->assertPathIs('/blog/posts/'.$post->id)
                ->assertSee($post->title);
        });
    }

    public function test_for_delete_post(){
        $this->test_for_create_blog_post();
        $this->browse(function (Browser $browser) {
            $browser->waitFor('#postTable > tbody > tr > td:nth-child(7) > div > button', 25)
                ->click('#postTable > tbody > tr > td:nth-child(7) > div > button')
                ->click('#postTable > tbody > tr > td:nth-child(7) > div > div > a.dropdown-item.delete_post')
                ->whenAvailable('#delete_form', function($modal){
                    $modal->click('input.primary-btn.fix-gr-bg')
                    ->assertPathIs('/blog/posts');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Operation done successfully.');
        });
    }

}
