<?php

namespace Tests\Browser\Modules\Language;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Laravel\Dusk\Browser;
use Tests\DuskTestCase;
use App\Models\User;
use Illuminate\Foundation\Testing\WithFaker;
use Modules\Language\Entities\Language;

class LanguageTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $languages = Language::where('id', '>', 114)->pluck('id');
        if(count($languages) > 0){
            Language::destroy($languages);
        }


        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                    ->visit('/setup/language')
                    ->assertSee('Language List');
        });
    }

    public function test_for_create_language(){
        $this->test_for_visit_index_page();

        $this->browse(function (Browser $browser) {
            $browser->click('#add_new_btn')
                ->whenAvailable('#language_addForm', function($modal){
                    $modal->type('div > div:nth-child(1) > div > input', 'test-language')
                        ->type('div > div:nth-child(2) > div > input', '+'.rand(111,999))
                        ->type('div > div:nth-child(3) > div > input', substr($this->faker->slug, 0,5))
                        ->click('div > div.col-lg-12.text-center > div > button')
                        ->assertPathIs('/setup/language');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Added successfully!');
        });
    }

    public function test_for_update_language(){
        $this->test_for_create_language();
        $this->browse(function (Browser $browser) {
            $browser->type('#DataTables_Table_0_filter > label > input[type=search]', 'test-language')
                ->pause(2000)
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > div > a.dropdown-item.edit_language')
                ->whenAvailable('#languageEditForm', function($modal){
                    $modal->type('div > div:nth-child(1) > div > input', 'test-language-edit')
                        ->type('div > div:nth-child(2) > div > input', '+'.rand(111,999))
                        ->type('div > div:nth-child(3) > div > input', substr($this->faker->slug, 0,5))
                        ->click('div > div.col-lg-12.text-center > div > button')
                        ->assertPathIs('/setup/language');
                }, 25)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_delete_language(){
        $this->test_for_create_language();
        $this->browse(function (Browser $browser) {
            $browser->type('#DataTables_Table_0_filter > label > input[type=search]', 'test-language')
                ->pause(2000)
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > div > a.dropdown-item.delete_language')
                ->whenAvailable('#confirm-delete > div > div > div.modal-body > div.mt-40.d-flex.justify-content-between', function($modal){
                    $modal->click('#delete_link')
                        ->assertPathIs('/setup/language');
                })
                ->pause(5000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');
        });
    }

    public function test_for_rtl_status_update(){
        $this->test_for_create_language();
        $this->browse(function (Browser $browser) {
            $browser->type('#DataTables_Table_0_filter > label > input[type=search]', 'test-language')
                ->pause(2000)
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(4) > label > div')
                ->pause(5000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_active_status_update(){
        $this->test_for_create_language();
        $this->browse(function (Browser $browser) {
            $browser->type('#DataTables_Table_0_filter > label > input[type=search]', 'test-language')
                ->pause(2000)
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(5) > label > div')
                ->pause(7000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }


    public function test_for_translate_language(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->type('#DataTables_Table_0_filter > label > input[type=search]', 'English')
                ->pause(2000)
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > div > a.dropdown-item.edit_brand')
                ->assertPathIs('/setup/language/translate-view/19')
                ->assertSee('English Translation')
                ->click('#main-content > section > div > div > div.col-lg-4.mb_30.col-md-4 > div.white-box > div > div > div > div')
                ->click('#main-content > section > div > div > div.col-lg-4.mb_30.col-md-4 > div.white-box > div > div > div > div > ul > li:nth-child(2)')
                ->pause(15000)
                ->assertSeeIn('#translate_modal > form > div.common_QA_section.QA_section_heading_custom.th_padding_l0 > div > div > table > tbody > tr:nth-child(1) > td:nth-child(2)','themes')
                ->type('#translate_modal > form > div.common_QA_section.QA_section_heading_custom.th_padding_l0 > div > div > table > tbody > tr:nth-child(1) > td:nth-child(3) > div > input', 'Themes')
                ->type('#translate_modal > form > div.common_QA_section.QA_section_heading_custom.th_padding_l0 > div > div > table > tbody > tr:nth-child(2) > td:nth-child(3) > div > input', 'Live Preview')
                ->click('#translate_modal > form > div:nth-child(2) > div > div > button')
                ->assertPathIs('/setup/language/translate-view/19')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }
    





}
