@extends('layouts.app')

@section('page-title', __('Dashboard'))

@section('action-button')
@section('breadcrumb')
@endsection

@section('content')
    @php

        $total_user_icon =  '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-building-store text-blue-500 h-6 w-6"><path d="M3 21V7.5a2.5 2.5 0 0 1 2.5-2.5h13A2.5 2.5 0 0 1 21 7.5V21"/><path d="M3 10h18"/><path d="M8 21v-7h8v7"/></svg>';
        $total_order_icon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-shopping-cart text-blue-500 h-6 w-6"><circle cx="8" cy="21" r="1"/><circle cx="19" cy="21" r="1"/><path d="M2.05 2.05h2l2.66 12.42a2 2 0 0 0 2 1.58h9.78a2 2 0 0 0 1.95-1.57l1.65-7.43H5.12"/></svg>';
        $total_plan_icon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-layers text-blue-500 h-6 w-6"><polygon points="12 2 2 7 12 12 22 7 12 2"/><polyline points="2 17 12 22 22 17"/><polyline points="2 12 12 17 22 12"/></svg>';
        $coupon_icon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-ticket text-blue-500 h-6 w-6"><path d="M3 9V7a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2v2a2 2 0 0 0 0 6v2a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-2a2 2 0 0 0 0-6"/><path d="M13 5v2"/><path d="M13 17v2"/><path d="M7 5v2"/><path d="M7 17v2"/></svg>';
        $plan_order_icon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-star text-blue-500 h-6 w-6"><polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"/></svg>';
        $plan_requests_icon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-clipboard-list text-blue-500 h-6 w-6"><rect x="9" y="2" width="6" height="4" rx="1"/><path d="M4 7a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v13a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2Z"/><path d="M9 12h6"/><path d="M9 16h6"/><path d="M9 8h.01"/><path d="M15 8h.01"/></svg>';

    @endphp
    <div class="row">
        <div class="col-sm-12 superadmin-wrp">
            <div class="row g-4 mb-4">
                <x-dashboard-card :count="$user->total_user" :label="__('Total Store')" :icon="$total_user_icon"
                    :url="route('stores.index')" columnClass="col-xl-4 col-md-6 col-12" />
                <x-dashboard-card :count="$user->total_orders" :label="__('Total Orders')" :icon="$total_order_icon"
                    :url="route('plan.index')" columnClass="col-xl-4 col-md-6 col-12" />
                <x-dashboard-card :count="$user->total_plan" :label="__('Total Plans')" :icon="$total_plan_icon"
                    :url="route('plan.index')" columnClass="col-xl-4 col-md-6 col-12" />
                <x-dashboard-card :count="$couponName" :label="__('Total Coupon')" :icon="$coupon_icon"
                    :url="route('plan-coupon.index')" columnClass="col-xl-4 col-md-6 col-12" />
                <x-dashboard-card :count="$plan_order" :label="__('Popular Plan')" :icon="$plan_order_icon"
                    :url="route('plan.index')" columnClass="col-xl-4 col-md-6 col-12" />
                <x-dashboard-card :count="$plan_requests" :label="__('Total Plan Request')" :icon="$plan_requests_icon"
                    :url="route('plan-request.index')" columnClass="col-xl-4 col-md-6 col-12" />
            </div>
            <div class="row g-4 mb-4">
                <div class="col-xl-4 col-12">
                    {{-- orders chart --}}
                    <div class="dashboard-card">
                       
                            <h4>{{ __('Orders') }}</h5>
                     
                        <div class="card-body">
                            <div id="traffic-chart"></div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-12">
                    <div class="dashboard-card">
                            <h4>{{__('Most Popular Store')}}</h5>
                        <div class="card-body">
                            <div class="">
                                @if (count($visitors) > 0)
                                    @foreach ($visitors as $key => $visit)
                                        @php
                                            $stores = \App\Models\Store::find($key);
                                            if (!$stores) {
                                                continue;
                                            }
                                        @endphp
                                        <div class="popular-store d-flex align-items-center justify-content-between gap-2">
                                            <span class="store-name">{{ $stores->name }}</span>
                                            <div class="store-like d-flex align-items-center gap-2">
                                                <span class="f-w-600 f-14">
                                                    {{ $visit }}</span>
                                                <svg width="23" height="19" viewBox="0 0 23 19" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M11.5 19C7.62459 16.7896 0.099763 11.4409 0.00129405 6.10398C-0.106294 0.277333 6.51722 -2.36518 11.5 2.64458C16.4821 -2.36447 23.1053 0.276311 22.9987 6.10296C22.9012 11.4402 15.3756 16.7895 11.5 19Z"
                                                        fill="#F9595F" />
                                                </svg>
                                            </div>
                                        </div>
                                    @endforeach
                                @else
                                    <div class="popular-store d-flex align-items-center justify-content-center">
                                        <span>{{ __('No Data Found') }}</span>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>

                </div>
                <div class="col-xl-4 col-12">
                    <div class="dashboard-card">
                            <h4>{{__('Top Selling Store')}}</h5>
                        <div class="card-body">
                            <div class="">
                                @if (count($allStores) > 0)
                                    @foreach ($allStores as $store)
                                        @php
                                            $store_name = \App\Models\Store::find($store->store_id);
                                            if (!$store_name) {
                                                continue;
                                            }
                                        @endphp
                                        <div class="popular-store d-flex align-items-center justify-content-between">
                                            <span>{{ $store_name->name }}</span>
                                            <div>
                                                <span
                                                    class="badge rounded p-0 pe-2 f-w-600 text-dark f-14">{{  currency_format_with_sym($store->total_amount, getCurrentStore()) ?? SetNumberFormat($store->total_amount) }}</span>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="17" height="15" viewBox="0 0 17 15"
                                                    fill="none">
                                                    <mask id="path-1-outside-1_835_1300" maskUnits="userSpaceOnUse" x="0"
                                                        y="-0.547607" width="17" height="15" fill="black">
                                                        <rect fill="white" y="-0.547607" width="17" height="15" />
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M15.8955 2.69982C15.9647 2.76909 15.9994 2.85978 15.9999 2.95054C16 2.9511 16.0001 4.02373 15.9998 4.02381C15.9998 5.20541 15.0385 6.16664 13.8569 6.16664C13.1124 6.16664 12.4555 5.78466 12.0713 5.20659C11.6872 5.78466 11.0302 6.16664 10.2856 6.16664C9.54101 6.16664 8.88411 5.78466 8.49992 5.20659C8.11572 5.78466 7.45883 6.16664 6.71424 6.16664C5.96966 6.16664 5.31276 5.78466 4.92857 5.20659C4.54446 5.78466 3.88756 6.16664 3.1429 6.16664C1.96131 6.16664 1 5.20533 1 4.02381C1 4.02381 1.00127 2.97245 1.00198 2.97253C0.996447 2.87448 1.02981 2.77478 1.10469 2.69982L3.2476 0.556921C3.31456 0.490034 3.40541 0.452393 3.50013 0.452393H13.4999C13.5947 0.452393 13.6855 0.489957 13.7525 0.556921L15.8955 2.69982ZM13.352 1.16663H3.64807L2.21947 2.59524H14.7807L13.352 1.16663ZM1.71446 4.02383C1.71446 4.81149 2.35531 5.45234 3.14298 5.45234C3.93074 5.45234 4.57158 4.81142 4.57158 4.02383V3.30953H1.71446V4.02383ZM5.28588 4.02383C5.28588 4.81149 5.92673 5.45234 6.71441 5.45234C7.50216 5.45234 8.14293 4.81142 8.14293 4.02383V3.30953H5.28588V4.02383ZM8.85731 4.02383C8.85731 4.81149 9.49816 5.45234 10.2858 5.45234C11.0735 5.45234 11.7144 4.81142 11.7144 4.02383V3.30953H8.85731V4.02383ZM13.8573 5.45225C14.6449 5.45225 15.2858 4.8114 15.2858 4.02373H15.2859V3.30944H12.4287V4.02373C12.4287 4.8114 13.0696 5.45225 13.8573 5.45225ZM14.5711 7.36438C14.5711 7.1671 14.731 7.00723 14.9283 7.00723C15.1255 7.00723 15.2854 7.1671 15.2855 7.36438V12.2381C15.2855 13.2227 14.4844 14.0237 13.4998 14.0237H10.6426C10.4454 14.0237 10.2855 13.8638 10.2855 13.6666V10.0952C10.2855 9.89818 10.1253 9.73799 9.92834 9.73799H7.07122C6.87426 9.73799 6.71407 9.89827 6.71407 10.0952V13.6666C6.71407 13.8639 6.55419 14.0237 6.35691 14.0237H3.49978C2.51515 14.0237 1.71411 13.2227 1.71411 12.2381V7.36438C1.71411 7.1671 1.87399 7.00723 2.07127 7.00723C2.26855 7.00723 2.42842 7.1672 2.42842 7.36438V12.2381C2.42842 12.8288 2.909 13.3095 3.49979 13.3095H5.99976V10.0952C5.99976 9.50442 6.48042 9.02385 7.07121 9.02385H9.92834C10.5191 9.02385 10.9998 9.50444 10.9998 10.0952V13.3095H13.4998C14.0905 13.3095 14.5711 12.8288 14.5711 12.2381V7.36438Z" />
                                                    </mask>
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M15.8955 2.69982C15.9647 2.76909 15.9994 2.85978 15.9999 2.95054C16 2.9511 16.0001 4.02373 15.9998 4.02381C15.9998 5.20541 15.0385 6.16664 13.8569 6.16664C13.1124 6.16664 12.4555 5.78466 12.0713 5.20659C11.6872 5.78466 11.0302 6.16664 10.2856 6.16664C9.54101 6.16664 8.88411 5.78466 8.49992 5.20659C8.11572 5.78466 7.45883 6.16664 6.71424 6.16664C5.96966 6.16664 5.31276 5.78466 4.92857 5.20659C4.54446 5.78466 3.88756 6.16664 3.1429 6.16664C1.96131 6.16664 1 5.20533 1 4.02381C1 4.02381 1.00127 2.97245 1.00198 2.97253C0.996447 2.87448 1.02981 2.77478 1.10469 2.69982L3.2476 0.556921C3.31456 0.490034 3.40541 0.452393 3.50013 0.452393H13.4999C13.5947 0.452393 13.6855 0.489957 13.7525 0.556921L15.8955 2.69982ZM13.352 1.16663H3.64807L2.21947 2.59524H14.7807L13.352 1.16663ZM1.71446 4.02383C1.71446 4.81149 2.35531 5.45234 3.14298 5.45234C3.93074 5.45234 4.57158 4.81142 4.57158 4.02383V3.30953H1.71446V4.02383ZM5.28588 4.02383C5.28588 4.81149 5.92673 5.45234 6.71441 5.45234C7.50216 5.45234 8.14293 4.81142 8.14293 4.02383V3.30953H5.28588V4.02383ZM8.85731 4.02383C8.85731 4.81149 9.49816 5.45234 10.2858 5.45234C11.0735 5.45234 11.7144 4.81142 11.7144 4.02383V3.30953H8.85731V4.02383ZM13.8573 5.45225C14.6449 5.45225 15.2858 4.8114 15.2858 4.02373H15.2859V3.30944H12.4287V4.02373C12.4287 4.8114 13.0696 5.45225 13.8573 5.45225ZM14.5711 7.36438C14.5711 7.1671 14.731 7.00723 14.9283 7.00723C15.1255 7.00723 15.2854 7.1671 15.2855 7.36438V12.2381C15.2855 13.2227 14.4844 14.0237 13.4998 14.0237H10.6426C10.4454 14.0237 10.2855 13.8638 10.2855 13.6666V10.0952C10.2855 9.89818 10.1253 9.73799 9.92834 9.73799H7.07122C6.87426 9.73799 6.71407 9.89827 6.71407 10.0952V13.6666C6.71407 13.8639 6.55419 14.0237 6.35691 14.0237H3.49978C2.51515 14.0237 1.71411 13.2227 1.71411 12.2381V7.36438C1.71411 7.1671 1.87399 7.00723 2.07127 7.00723C2.26855 7.00723 2.42842 7.1672 2.42842 7.36438V12.2381C2.42842 12.8288 2.909 13.3095 3.49979 13.3095H5.99976V10.0952C5.99976 9.50442 6.48042 9.02385 7.07121 9.02385H9.92834C10.5191 9.02385 10.9998 9.50444 10.9998 10.0952V13.3095H13.4998C14.0905 13.3095 14.5711 12.8288 14.5711 12.2381V7.36438Z"
                                                        fill="black" />
                                                    <path
                                                        d="M15.9999 2.95054L15.9494 2.95081L15.9505 2.95816L15.9999 2.95054ZM15.8955 2.69982L15.8601 2.73518V2.73518L15.8955 2.69982ZM15.9998 4.02381L15.9848 3.97614L15.9498 3.98719V4.02381H15.9998ZM12.0713 5.20659L12.1129 5.17891L12.0713 5.11625L12.0296 5.17892L12.0713 5.20659ZM8.49992 5.20659L8.54156 5.17891L8.49992 5.11626L8.45827 5.17891L8.49992 5.20659ZM4.92857 5.20659L4.97021 5.17891L4.92857 5.11625L4.88693 5.17892L4.92857 5.20659ZM1 4.02381L0.95 4.02375V4.02381H1ZM1.00198 2.97253L0.996583 3.02224L1.05522 3.0286L1.0519 2.96971L1.00198 2.97253ZM1.10469 2.69982L1.06934 2.66447L1.06932 2.66449L1.10469 2.69982ZM3.2476 0.556921L3.21226 0.521544L3.21224 0.521566L3.2476 0.556921ZM13.7525 0.556921L13.7878 0.521565L13.7878 0.521565L13.7525 0.556921ZM3.64807 1.16663V1.11663H3.62736L3.61271 1.13127L3.64807 1.16663ZM13.352 1.16663L13.3874 1.13127L13.3727 1.11663H13.352V1.16663ZM2.21947 2.59524L2.18411 2.55988L2.09876 2.64524H2.21947V2.59524ZM14.7807 2.59524V2.64524H14.9014L14.816 2.55988L14.7807 2.59524ZM4.57158 4.02383H4.52158V4.02383L4.57158 4.02383ZM4.57158 3.30953H4.62158V3.25953H4.57158V3.30953ZM1.71446 3.30953V3.25953H1.66446V3.30953H1.71446ZM8.14293 4.02383H8.09293V4.02383L8.14293 4.02383ZM8.14293 3.30953H8.19293V3.25953H8.14293V3.30953ZM5.28588 3.30953V3.25953H5.23588V3.30953H5.28588ZM11.7144 4.02383L11.7644 4.02383V4.02383H11.7144ZM11.7144 3.30953H11.7644V3.25953H11.7144V3.30953ZM8.85731 3.30953V3.25953H8.80731V3.30953H8.85731ZM15.2858 4.02373V3.97373H15.2358V4.02373H15.2858ZM15.2859 4.02373V4.07373H15.3359V4.02373H15.2859ZM15.2859 3.30944H15.3359V3.25944H15.2859V3.30944ZM12.4287 3.30944V3.25944H12.3787V3.30944H12.4287ZM15.2855 7.36438H15.3355V7.36436L15.2855 7.36438ZM5.99976 13.3095V13.3595H6.04976V13.3095H5.99976ZM10.9998 13.3095H10.9498V13.3595H10.9998V13.3095ZM16.0499 2.95028C16.0494 2.84695 16.0098 2.74346 15.9308 2.66447L15.8601 2.73518C15.9196 2.79472 15.9495 2.87261 15.9499 2.9508L16.0499 2.95028ZM16.0149 4.07148C16.0385 4.05556 16.0497 4.02802 16.0498 4.02664C16.0498 4.02617 16.0498 4.02545 16.0498 4.02519C16.0498 4.02479 16.0498 4.02445 16.0498 4.02433C16.0498 4.02401 16.0498 4.02367 16.0498 4.02338C16.0499 4.02277 16.0499 4.02193 16.0499 4.0209C16.0499 4.01882 16.0499 4.01577 16.0499 4.01183C16.0499 4.00395 16.0499 3.9924 16.0499 3.97773C16.0499 3.94838 16.05 3.90646 16.05 3.85617C16.05 3.75559 16.05 3.62148 16.05 3.48736C16.05 3.35324 16.05 3.2191 16.05 3.11846C16.05 3.06814 16.05 3.02619 16.0499 2.9968C16.0499 2.98211 16.0499 2.97055 16.0499 2.96265C16.0499 2.95871 16.0499 2.95567 16.0499 2.95361C16.0499 2.95258 16.0499 2.95178 16.0499 2.95122C16.0499 2.95095 16.0499 2.9507 16.0499 2.9505C16.0499 2.95041 16.0499 2.95027 16.0499 2.95012C16.0499 2.95003 16.0499 2.9498 16.0499 2.94965C16.0499 2.94929 16.0497 2.94592 16.0493 2.94293L15.9505 2.95816C15.9501 2.95517 15.9499 2.95181 15.9499 2.95146C15.9499 2.95134 15.9499 2.95114 15.9499 2.95108C15.9499 2.951 15.9499 2.95095 15.9499 2.951C15.9499 2.95107 15.9499 2.95122 15.9499 2.95147C15.9499 2.95197 15.9499 2.95272 15.9499 2.95374C15.9499 2.95577 15.9499 2.95878 15.9499 2.96272C15.9499 2.9706 15.9499 2.98214 15.9499 2.99683C15.95 3.02621 15.95 3.06815 15.95 3.11847C15.95 3.21911 15.95 3.35324 15.95 3.48736C15.95 3.62147 15.95 3.75557 15.95 3.85615C15.95 3.90643 15.9499 3.94833 15.9499 3.97766C15.9499 3.99232 15.9499 4.00383 15.9499 4.01167C15.9499 4.01559 15.9499 4.01857 15.9499 4.02055C15.9499 4.02156 15.9499 4.02225 15.9498 4.02268C15.9498 4.02291 15.9498 4.02295 15.9498 4.0229C15.9498 4.02288 15.9498 4.02279 15.9499 4.02274C15.9499 4.02267 15.9499 4.02245 15.9499 4.02233C15.9499 4.02211 15.9499 4.02141 15.9499 4.02095C15.95 4.0196 15.9612 3.99206 15.9848 3.97614L16.0149 4.07148ZM13.8569 6.21664C15.0661 6.21664 16.0498 5.23303 16.0498 4.02381H15.9498C15.9498 5.17779 15.0109 6.11664 13.8569 6.11664V6.21664ZM12.0296 5.23427C12.4226 5.82562 13.0948 6.21664 13.8569 6.21664V6.11664C13.1299 6.11664 12.4883 5.7437 12.1129 5.17891L12.0296 5.23427ZM10.2856 6.21664C11.0477 6.21664 11.72 5.82563 12.1129 5.23426L12.0296 5.17892C11.6543 5.74369 11.0127 6.11664 10.2856 6.11664V6.21664ZM8.45827 5.23427C8.8513 5.82562 9.52349 6.21664 10.2856 6.21664V6.11664C9.55852 6.11664 8.91692 5.7437 8.54156 5.17891L8.45827 5.23427ZM6.71424 6.21664C7.47634 6.21664 8.14853 5.82562 8.54156 5.23427L8.45827 5.17891C8.08291 5.7437 7.44131 6.11664 6.71424 6.11664V6.21664ZM4.88693 5.23427C5.27995 5.82562 5.95215 6.21664 6.71424 6.21664V6.11664C5.98718 6.11664 5.34557 5.7437 4.97021 5.17891L4.88693 5.23427ZM3.1429 6.21664C3.90508 6.21664 4.57727 5.82563 4.97022 5.23426L4.88693 5.17892C4.51165 5.74369 3.87005 6.11664 3.1429 6.11664V6.21664ZM0.95 4.02381C0.95 5.23295 1.9337 6.21664 3.1429 6.21664V6.11664C1.98892 6.11664 1.05 5.17772 1.05 4.02381H0.95ZM1.00738 2.92282C0.975491 2.93012 0.953668 2.95964 0.952745 2.96381C0.95251 2.96525 0.952236 2.96744 0.952165 2.96818C0.952063 2.96934 0.952022 2.97028 0.952012 2.9705C0.951982 2.97119 0.951967 2.97183 0.951959 2.97216C0.951941 2.97294 0.951927 2.97392 0.951915 2.97495C0.95189 2.97708 0.951866 2.98014 0.951842 2.98401C0.951793 2.99177 0.951742 3.00312 0.951691 3.0175C0.951588 3.04628 0.95148 3.08737 0.951371 3.13665C0.951152 3.23522 0.950926 3.36665 0.950723 3.49806C0.95052 3.62948 0.950339 3.76091 0.950209 3.85947C0.950144 3.90875 0.950092 3.94982 0.950056 3.97857C0.950038 3.99295 0.950024 4.00424 0.950014 4.01194C0.95001 4.01579 0.950006 4.01874 0.950004 4.02073C0.950002 4.02173 0.950002 4.02248 0.950001 4.02299C0.950001 4.02324 0.95 4.02343 0.95 4.02356C0.95 4.02362 0.95 4.02367 0.95 4.0237C0.95 4.02372 0.95 4.02373 0.95 4.02374C0.95 4.02375 0.95 4.02375 1 4.02381C1.05 4.02387 1.05 4.02387 1.05 4.02386C1.05 4.02385 1.05 4.02384 1.05 4.02382C1.05 4.02379 1.05 4.02374 1.05 4.02368C1.05 4.02355 1.05 4.02336 1.05 4.02311C1.05 4.0226 1.05 4.02185 1.05 4.02086C1.05001 4.01887 1.05001 4.01591 1.05001 4.01206C1.05002 4.00436 1.05004 3.99307 1.05006 3.9787C1.05009 3.94995 1.05014 3.90888 1.05021 3.8596C1.05034 3.76104 1.05052 3.62963 1.05072 3.49822C1.05093 3.36681 1.05115 3.23541 1.05137 3.13687C1.05148 3.0876 1.05159 3.04656 1.05169 3.01786C1.05174 3.0035 1.05179 2.99226 1.05184 2.98464C1.05186 2.98081 1.05189 2.97797 1.05191 2.97612C1.05192 2.97517 1.05193 2.97464 1.05193 2.97442C1.05194 2.97424 1.05193 2.9745 1.05191 2.97494C1.05191 2.97503 1.05187 2.97588 1.05178 2.97697C1.05171 2.97768 1.05144 2.97984 1.05121 2.98128C1.05029 2.98543 1.02847 3.01494 0.996583 3.02224L1.00738 2.92282ZM1.06932 2.66449C0.983672 2.75022 0.945783 2.86412 0.952059 2.97535L1.0519 2.96971C1.04711 2.88484 1.07595 2.79934 1.14006 2.73516L1.06932 2.66449ZM3.21224 0.521566L1.06934 2.66447L1.14005 2.73518L3.28295 0.592277L3.21224 0.521566ZM3.50013 0.402393C3.39215 0.402393 3.2886 0.445301 3.21226 0.521544L3.28293 0.592298C3.34053 0.534767 3.41867 0.502393 3.50013 0.502393V0.402393ZM13.4999 0.402393H3.50013V0.502393H13.4999V0.402393ZM13.7878 0.521565C13.7115 0.445207 13.6079 0.402393 13.4999 0.402393V0.502393C13.5814 0.502393 13.6595 0.534707 13.7171 0.592278L13.7878 0.521565ZM15.9308 2.66447L13.7878 0.521565L13.7171 0.592277L15.8601 2.73518L15.9308 2.66447ZM3.64807 1.21663H13.352V1.11663H3.64807V1.21663ZM2.25483 2.63059L3.68342 1.20198L3.61271 1.13127L2.18411 2.55988L2.25483 2.63059ZM14.7807 2.54524H2.21947V2.64524H14.7807V2.54524ZM13.3167 1.20198L14.7453 2.63059L14.816 2.55988L13.3874 1.13127L13.3167 1.20198ZM3.14298 5.40234C2.38292 5.40234 1.76446 4.78388 1.76446 4.02383H1.66446C1.66446 4.83911 2.32769 5.50234 3.14298 5.50234V5.40234ZM4.52158 4.02383C4.52158 4.78381 3.90312 5.40234 3.14298 5.40234V5.50234C3.95835 5.50234 4.62159 4.83904 4.62158 4.02383L4.52158 4.02383ZM4.52158 3.30953V4.02383H4.62158V3.30953H4.52158ZM1.71446 3.35953H4.57158V3.25953H1.71446V3.35953ZM1.76446 4.02383V3.30953H1.66446V4.02383H1.76446ZM6.71441 5.40234C5.95435 5.40234 5.33588 4.78388 5.33588 4.02383H5.23588C5.23588 4.83911 5.89912 5.50234 6.71441 5.50234V5.40234ZM8.09293 4.02383C8.09293 4.78381 7.47455 5.40234 6.71441 5.40234V5.50234C7.52978 5.50234 8.19293 4.83903 8.19293 4.02383L8.09293 4.02383ZM8.09293 3.30953V4.02383H8.19293V3.30953H8.09293ZM5.28588 3.35953H8.14293V3.25953H5.28588V3.35953ZM5.33588 4.02383V3.30953H5.23588V4.02383H5.33588ZM10.2858 5.40234C9.52577 5.40234 8.90731 4.78388 8.90731 4.02383H8.80731C8.80731 4.83911 9.47054 5.50234 10.2858 5.50234V5.40234ZM11.6644 4.02382C11.6644 4.78381 11.0459 5.40234 10.2858 5.40234V5.50234C11.1011 5.50234 11.7644 4.83904 11.7644 4.02383L11.6644 4.02382ZM11.6644 3.30953V4.02383H11.7644V3.30953H11.6644ZM8.85731 3.35953H11.7144V3.25953H8.85731V3.35953ZM8.90731 4.02383V3.30953H8.80731V4.02383H8.90731ZM15.2358 4.02373C15.2358 4.78379 14.6173 5.40225 13.8573 5.40225V5.50225C14.6725 5.50225 15.3358 4.83902 15.3358 4.02373H15.2358ZM15.2859 3.97373H15.2858V4.07373H15.2859V3.97373ZM15.2359 3.30944V4.02373H15.3359V3.30944H15.2359ZM12.4287 3.35944H15.2859V3.25944H12.4287V3.35944ZM12.4787 4.02373V3.30944H12.3787V4.02373H12.4787ZM13.8573 5.40225C13.0972 5.40225 12.4787 4.78379 12.4787 4.02373H12.3787C12.3787 4.83901 13.042 5.50225 13.8573 5.50225V5.40225ZM14.9283 6.95723C14.7034 6.95723 14.5211 7.13949 14.5211 7.36438H14.6211C14.6211 7.19471 14.7586 7.05723 14.9283 7.05723V6.95723ZM15.3355 7.36436C15.3354 7.13948 15.1531 6.95723 14.9283 6.95723V7.05723C15.0979 7.05723 15.2354 7.19472 15.2355 7.36441L15.3355 7.36436ZM15.3355 12.2381V7.36438H15.2355V12.2381H15.3355ZM13.4998 14.0737C14.512 14.0737 15.3355 13.2503 15.3355 12.2381H15.2355C15.2355 13.1951 14.4568 13.9737 13.4998 13.9737V14.0737ZM10.6426 14.0737H13.4998V13.9737H10.6426V14.0737ZM10.2355 13.6666C10.2355 13.8914 10.4177 14.0737 10.6426 14.0737V13.9737C10.473 13.9737 10.3355 13.8362 10.3355 13.6666H10.2355ZM10.2355 10.0952V13.6666H10.3355V10.0952H10.2355ZM9.92834 9.78799C10.0977 9.78799 10.2355 9.92579 10.2355 10.0952H10.3355C10.3355 9.87056 10.1529 9.68799 9.92834 9.68799V9.78799ZM7.07122 9.78799H9.92834V9.68799H7.07122V9.78799ZM6.76407 10.0952C6.76407 9.92588 6.90188 9.78799 7.07122 9.78799V9.68799C6.84663 9.68799 6.66406 9.87067 6.66406 10.0952H6.76407ZM6.76407 13.6666V10.0952H6.66406V13.6666H6.76407ZM6.35691 14.0737C6.5818 14.0737 6.76407 13.8915 6.76407 13.6666H6.66406C6.66406 13.8362 6.52657 13.9737 6.35691 13.9737V14.0737ZM3.49978 14.0737H6.35691V13.9737H3.49978V14.0737ZM1.66411 12.2381C1.66411 13.2503 2.48754 14.0737 3.49978 14.0737V13.9737C2.54276 13.9737 1.76411 13.1951 1.76411 12.2381H1.66411ZM1.66411 7.36438V12.2381H1.76411V7.36438H1.66411ZM2.07127 6.95723C1.84637 6.95723 1.66411 7.13949 1.66411 7.36438H1.76411C1.76411 7.19471 1.9016 7.05723 2.07127 7.05723V6.95723ZM2.47842 7.36438C2.47842 7.13959 2.29617 6.95723 2.07127 6.95723V7.05723C2.24092 7.05723 2.37842 7.1948 2.37842 7.36438H2.47842ZM2.47842 12.2381V7.36438H2.37842V12.2381H2.47842ZM3.49979 13.2595C2.93662 13.2595 2.47842 12.8012 2.47842 12.2381H2.37842C2.37842 12.8565 2.88138 13.3595 3.49979 13.3595V13.2595ZM5.99976 13.2595H3.49979V13.3595H5.99976V13.2595ZM5.94976 10.0952V13.3095H6.04976V10.0952H5.94976ZM7.07121 8.97385C6.45281 8.97385 5.94976 9.4768 5.94976 10.0952H6.04976C6.04976 9.53204 6.50803 9.07385 7.07121 9.07385V8.97385ZM9.92834 8.97385H7.07121V9.07385H9.92834V8.97385ZM11.0498 10.0952C11.0498 9.47682 10.5468 8.97385 9.92834 8.97385V9.07385C10.4915 9.07385 10.9498 9.53206 10.9498 10.0952H11.0498ZM11.0498 13.3095V10.0952H10.9498V13.3095H11.0498ZM13.4998 13.2595H10.9998V13.3595H13.4998V13.2595ZM14.5211 12.2381C14.5211 12.8012 14.0629 13.2595 13.4998 13.2595V13.3595C14.1181 13.3595 14.6211 12.8565 14.6211 12.2381H14.5211ZM14.5211 7.36438V12.2381H14.6211V7.36438H14.5211Z"
                                                        fill="black" mask="url(#path-1-outside-1_835_1300)" />
                                                </svg>
                                            </div>
                                        </div>
                                    @endforeach
                                @else
                                    <div class="popular-store d-flex align-items-center justify-content-center">
                                        <span>{{ __('No Data Found') }}</span>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
            <div class="col-12">
                <div class="dashboard-card">
                        <h4 class="mb-3">{{__('Top Customers')}}</h5>
                    <div class="card-body">
                        <div class="customers-wrp row">
                            @foreach ($topAdmins as $user)
                                <div class="col-xxl-3 col-md-6 col-12">
                                    <div class="dashboard-card d-flex gap-3">
                                        <img src="{{ !empty($user->profile_image) ? asset($user->profile_image) : asset('storage/uploads/profile/avatar.png') }}"
                                            class=" " width="60px" height="60px">
                                        <div>
                                            <h5 class="f-16 f-w-600 mb-2">{{ $user->name }}</h5>
                                            <p class="f-12 user-mail">{{ $user->email }}</p>
                                            <span class="badge  py-2 px-3 f-w-600 rounded-1 bg-primary">{{ __('Total Store') }} :
                                                {{ $user->stores_count ?? 0 }}</span>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </div>
    </div>
@endsection

@push('custom-script')
    <script>
        (function () {
            var options = {
                chart: {
                    height: 200,
                    type: 'area',
                    toolbar: {
                        show: false,
                    },
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    width: 2,
                    curve: 'smooth'
                },
                series: [{
                    name: 'order',
                    data: {!! json_encode($chartData['data']) !!}
                }],
                xaxis: {
                    categories: {!! json_encode($chartData['label']) !!},
                    title: {
                        text: '{{ __("Days") }}'
                    }
                },
                colors: ['var(--theme-color)', 'var(--third-color)'],

                grid: {
                    strokeDashArray: 4,
                },
                legend: {
                    show: false,
                },
                yaxis: {
                    tickAmount: 3,
                    title: {
                        text: '{{ __("Amount") }}'
                    },
                }
            };
            var chart = new ApexCharts(document.querySelector("#traffic-chart"), options);
            chart.render();
        })();

    </script>
@endpush