<?php

defined('BASEPATH') or exit('No direct script access allowed');
class Slider_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->library(['ion_auth', 'form_validation']);
        $this->load->helper(['url', 'language', 'function_helper']);
    }

    function add_slider($data)
    {
        $data = escape_array($data);

        $slider_data = [
            'type' => $data['slider_type'],
            'image' => $data['image'],
        ];
        $slider_data['link'] = '';
        if (isset($data['slider_type']) && $data['slider_type'] == 'categories' && isset($data['category_id']) && !empty($data['category_id'])) {
            $slider_data['type_id'] = $data['category_id'];
            $slider_data['link'] = '';
        }
        if (isset($data['slider_type']) && $data['slider_type'] == 'slider_url' && isset($data['link']) && !empty($data['link'])) {
            $slider_data['link'] = $data['link'];
            $slider_data['type_id'] = 0;
        }

        if (isset($data['slider_type']) && $data['slider_type'] == 'products' && isset($data['product_id']) && !empty($data['product_id'])) {
            // $product_ids = implode(',', $data['product_id']);

            // $slider_data['type_id'] = $product_ids;
            $slider_data['type_id'] = $data['product_id'];
            $slider_data['link'] = '';
        }
        // else{
        //     $product_ids = null;
        // }


        if (isset($data['edit_slider']) && !empty($data['edit_slider'])) {
            if (empty($data['image'])) {
                unset($slider_data['image']);
            }

            $this->db->set($slider_data)->where('id', $data['edit_slider'])->update('sliders');
        } else {
            $this->db->insert('sliders', $slider_data);
        }
    }

    function get_slider_list()
    {
        $offset = 0;
        $limit = 10;
        $sort = 'id';
        $order = 'DESC';
        $multipleWhere = '';

        if (isset($_GET['offset']))
            $offset = $_GET['offset'];
        if (isset($_GET['limit']))
            $limit = $_GET['limit'];

        if (isset($_GET['sort']))
            if ($_GET['sort'] == 'id') {
                $sort = "id";
            } else {
                $sort = $_GET['sort'];
            }
        if (isset($_GET['order']))
            $order = $_GET['order'];

        if (isset($_GET['search']) and $_GET['search'] != '') {
            $search = $_GET['search'];
            $multipleWhere = ['`id`' => $search, '`type`' => $search, '`type_id`' => $search];
        }

        $count_res = $this->db->select(' COUNT(id) as `total` ');

        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $count_res->or_where($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $count_res->where($where);
        }

        $slider_count = $count_res->get('sliders')->result_array();

        foreach ($slider_count as $row) {
            $total = $row['total'];
        }

        $search_res = $this->db->select(' * ');
        if (isset($multipleWhere) && !empty($multipleWhere)) {
            $search_res->or_like($multipleWhere);
        }
        if (isset($where) && !empty($where)) {
            $search_res->where($where);
        }

        $slider_search_res = $search_res->order_by($sort, "asc")->limit($limit, $offset)->get('sliders')->result_array();

        $bulkData = array();
        $bulkData['total'] = $total;
        $rows = array();
        $tempRow = array();

        foreach ($slider_search_res as $row) {
            $row = output_escaping($row);

            if (isset($row['type_id']) && !empty($row['type_id']) && $row['type'] == 'products') {
                $product = fetch_details('products', ['id' => $row['type_id']], 'name');
                $tempRow['name'] = $product[0]['name'];
            } elseif (isset($row['type_id']) && !empty($row['type_id']) && $row['type'] == 'categories') {
                $categories = fetch_details('categories', ['id' => $row['type_id']], 'name');
                $tempRow['name'] = $categories[0]['name'];
            }else{
               $tempRow['name'] = ''; 
            }

            // $operate = ' <a href="' . base_url('admin/slider/manage-slider?edit_id=' . $row['id']) . '" class="btn btn-success edit_slider action-btn btn-xs ml-1 mr-1 mb-1"  title="Edit" data-id="' . $row['id'] . '" data-url="admin/slider/"><i class="fa fa-pen"></i></a>';
            $operate = ' <a href="' . base_url('admin/slider/manage-slider?edit_id=' . $row['id']) . '" class="btn btn-success edit_slider action-btn btn-xs ml-1 mr-1 mb-1"  title="Edit" data-id="' . $row['id'] . '" data-target="#add_slider" data-toggle="modal"><i class="fa fa-pen"></i></a>';
            $operate .= ' <a  href="javascript:void(0)" class="btn btn-danger btn-xs action-btn mr-1 mb-1 ml-1"  title="Delete" id="delete-slider" data-id="' . $row['id'] . '"  ><i class="fa fa-trash"></i></a>';

            $tempRow['id'] = $row['id'];
            $tempRow['type'] = $row['type'];
            $tempRow['type_id'] = $row['type_id'];
            $tempRow['link'] = $row['link'];

            if (empty($row['image']) || file_exists(FCPATH . $row['image']) == FALSE) {
                $row['image'] = base_url() . NO_IMAGE;
                $row['image_main'] = base_url() . NO_IMAGE;
            } else {
                $row['image_main'] = base_url($row['image']);
                $row['image'] = get_image_url($row['image'], 'thumb', 'sm');
            }
            $tempRow['image'] = "<div class='image-box-100'><a href='" . $row['image_main'] . "' data-toggle='lightbox' data-gallery='gallery'> <img src='" . $row['image'] . "' class='rounded' ></a></div>";
            $tempRow['operate'] = $operate;
            $rows[] = $tempRow;
        }
        $bulkData['rows'] = $rows;
        print_r(json_encode($bulkData));
    }
}
