<?php

namespace Modules\POS\Http\Controllers;
use App\Repositories\UserRepository;
use App\Traits\GeneratePdf;
use Brian2694\Toastr\Facades\Toastr;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\AdminReport\Services\AdminReportService;
use Modules\Customer\Services\CustomerService;
use Modules\GeneralSetting\Entities\GeneralSetting;
use Modules\InhouseOrder\Services\InhouseOrderService;
use Modules\POS\Entities\Payment;
use Modules\POS\Services\PosService;
use Modules\Product\Entities\Category;
use Modules\Product\Http\Requests\CreateProductRequest;
use Modules\Product\Repositories\AttributeRepository;
use Modules\Product\Repositories\CategoryRepository;
use Modules\Product\Repositories\ProductRepository;
use Modules\Product\Services\AttributeService;
use Modules\Product\Services\BrandService;
use Modules\Product\Services\CategoryService;
use Modules\Product\Services\ProductService;
use Modules\Product\Services\UnitTypeService;
use Modules\Seller\Entities\SellerProductSKU;
use Modules\Shipping\Services\ShippingService;
use Modules\UserActivityLog\Traits\LogActivity;
use Modules\GST\Repositories\GstConfigureRepository;
use Modules\GoldPrice\Repositories\GoldPriceRepository;
use Modules\POS\Entities\PosConfiguration;
use Modules\POS\Entities\ProductItemDetail;
use Modules\POS\Http\Requests\PosCustomerRequest;
use Yajra\DataTables\Facades\DataTables;

class POSController extends Controller
{
    use GeneratePdf;
    protected $categoryService , $brandService, $attributeService, $productService, $posService, $customerService, $inhouseOrderService, $unitTypeService, $shippingService, $productRepository, $adminReportService, $sellerProductService, $userRepository, $attributeRepository;
    public function __construct(CategoryService $categoryService, BrandService $brandService, AttributeService $attributeService, ProductService $productService, PosService $posService, CustomerService $customerService, InhouseOrderService $inhouseOrderService, UnitTypeService $unitTypeService, ShippingService $shippingService, ProductRepository $productRepository, AdminReportService $adminReportService, \Modules\Seller\Services\ProductService $sellerProductService, UserRepository $userRepository, AttributeRepository $attributeRepository)
    {
        $this->middleware('maintenance_mode');
        $this->middleware('prohibited_demo_mode')->only('store');
        $this->categoryService = $categoryService;
        $this->brandService = $brandService;
        $this->attributeService = $attributeService;
        $this->productService = $productService;
        $this->posService = $posService;
        $this->customerService = $customerService;
        $this->inhouseOrderService = $inhouseOrderService;
        $this->unitTypeService = $unitTypeService;
        $this->shippingService = $shippingService;
        $this->productRepository = $productRepository;
        $this->adminReportService = $adminReportService;
        $this->sellerProductService = $sellerProductService;
        $this->userRepository = $userRepository;
        $this->attributeRepository = $attributeRepository;
    }
    public function index()
    {
        return view('pos::index');
    }
    public function posList()
    {
        try {
            $pos_name = app('general_setting')->pos_view;
            $gstGroup_repo = new GstConfigureRepository();
            $catRepo = new CategoryRepository(new Category());
            $data = [
                'categories'        => $this->categoryService->getAll(),
                'brands'            => $this->brandService->getAll(),
                'attributes'        => $this->attributeService->getActiveAll(),
                'pos_view'          => $pos_name,
                'customers'         => $this->customerService->posCustomer(),
                'units'             => $this->unitTypeService->getActiveAll(),
                'shippings'         => $this->shippingService->getActiveAll()->where('id', '!=', 1),
                'gst_groups'        => $gstGroup_repo->getGroup(),
                'CategoryList'      => $catRepo->activeCategory(),
                'products'          => $this->posService->allbyPaginate()
            ];
            if(isModuleActive('GoldPrice')){
                $goldPriceRepo = new GoldPriceRepository();
                $data['gold_prices'] = $goldPriceRepo->getAll();
            }
            // session()->forget('carts');
            // session()->forget('sku');
            // session()->forget('customer');
            return view('pos::pos_order.pos')->with($data);
        } catch (Exception $e) {
            LogActivity::errorLog($e->getMessage());
            Toastr::error(__('common.operation_failed'));
            return back();
        }
    }
    public function get_change_pos_view(Request $request)
    {
        try {
            $data = GeneralSetting::first();
            $data->pos_view = $request->pos_view;
            $data->save();
            return 1;
        } catch (\Exception $e) {
            LogActivity::errorLog($e->getMessage());
            return 0;
        }
    }
    public function loadProduct(Request $request)
    {
        try {
           $products = $this->posService->loadProduct($request->except("_token"));
           if (app('general_setting')->pos_view == 1){
                return view('pos::pos_order.components.product_pos_grid_view',compact('products'));
            } else {
               return view('pos::pos_order.components.product_pos_list_view',compact('products'));
           }
        } catch (\Exception $e) {
            LogActivity::errorLog($e->getMessage());
            return $e->getMessage();
        }
    }
    public function product_modal_for_select(Request $request)
    {
        try {
            $type = explode('-', $request->id);
            $customer = explode('-', $request->customer);
            if ($type[1] == "Single") {
                $data['product_id'] =$this->posService->storeSkuProduct($type[0], $type[2],$customer[1]);
                $data['product_type'] = $type[1];
            } else {
                $data['product_type'] = $type[1];
                $data['product'] = $this->posService->findSellerProduct($type[0]);
                $data['html'] = (string)view('pos::pos_order.product_details', $data);
            }
            return $data;
        } catch (\Exception $e) {
            LogActivity::errorLog($e->getMessage());
            return false;
        }
    }
    public function contactStore(PosCustomerRequest $request)
    {
        try{
            $request->merge(['status' => 1]);
           $user = $this->customerService->store($request->except("_token"));
            Toastr::success(__('common.created_successfully'), __('common.success'));
            LogActivity::successLog('Customer Created Successfully.');
            return $user;
        }catch(Exception $e){
            LogActivity::errorLog($e->getMessage());
            Toastr::error(__('common.error_message'), __('common.error'));
            return back();
        }
    }
    public function addProduct(Request $request)
    {
        DB::beginTransaction();
        try {
            $this->productService->create($request->except("_token"));
            DB::commit();
            Toastr::success(__('common.added_successfully'), __('common.success'));
            LogActivity::successLog('product upload successful.');
            if ($request->request_from == 'main_product_form') {
                return redirect()->back();
            } elseif ($request->request_from == 'seller_product_form') {
                return redirect()->route('seller.product.index');
            } elseif ($request->request_from == 'inhouse_product_form') {
                return redirect()->route('admin.my-product.index');
            }
        } catch (\Exception $e) {
            DB::rollBack();
            LogActivity::errorLog($e->getMessage());
            Toastr::error(__('common.error_message'));
            return back();
        }
    }
    public function multiple_payment_modal(Request $request)
    {
        $user_type = explode('-', $request->customer_id);
        $user = $user_type[0];
        $user_id = $user_type[1];
        $total_amount = $request->total_amount;
        $paying_amount = $request->paying_amount;
        $total_qty = $request->total_qty;
        $paid_amount = $request->paid_amount ?? 0;
        $bank_accounts = $this->posService->allBankAccounts();
        $branch_acc = [];
        return view('pos::pos_order.payment_modal', compact('total_amount', 'bank_accounts','paying_amount', 'total_qty','paid_amount', 'user', 'user_id', 'branch_acc'));
    }
    public function checkQuantity(Request $request)
    {
        $stock='';
        $ProductStockList = SellerProductSKU::where('product_sku_id',$request->id)->first();
        if (@$ProductStockList->product_stock == 0){
            $stock = 'In Stock';
        }elseif(@$ProductStockList->stock_manage == 1){
            $stock = @$ProductStockList->product_stock;
        }
        return response()->json(['stock' => $stock]);
    }
    public function itemSessionDelete(Request $request)
    {
        $productSku = $this->productRepository->findSkus($request->id);
        $skus = session()->get('sku');
        $carts = session()->get('carts');
            unset($skus[$productSku->id]);
            unset($carts['sku-' . $productSku->id]);
        session()->put('sku', $skus);
        session()->put('carts', $carts);
        return response()->json(['success' => trans("pos.successfully_deleted")]);
    }
    public function storeProduct(Request $request)
    {
        try {
            $lp = 0;
            $productSku = $this->productRepository->findSkus($request->id);
            $posConfig = PosConfiguration::first();

            $skus = session()->get('sku');
            $carts = session()->get('carts');
            $sku[$productSku->id] = $productSku->id;
            // if (!empty($skus) || !empty($carts)) {
            //     if ((is_array($skus) && array_key_exists($productSku->id, $skus)) || (is_array($carts) && array_key_exists('sku-' . $productSku->id, $carts))) {
            //         return 1;
            //     }
            //     if (is_array($skus))
            //         session()->put('sku', $sku + $skus);
            // } else
                session()->put('sku', $sku);
            $type = $productSku->product_id . ",'sku'";
            if ($productSku->mainProduct->tax_type == null) {
                $price = $productSku->selling_price;
                $igstProduct = ($productSku->min_sell_price * $productSku->mainProduct->gst_tax_group->igst) / 100;
                $cgstProduct = ($productSku->min_sell_price * $productSku->mainProduct->gst_tax_group->cgst) / 100;
                $sgstProduct = ($productSku->min_sell_price * $productSku->mainProduct->gst_tax_group->sgst) / 100;
                $cessProduct = ($productSku->min_sell_price * $productSku->mainProduct->gst_tax_group->cess) / 100;
                $taxrow = '<input type="hidden" name="product_igst[]" net-sub-total="'.$igstProduct.'" value="' . $productSku->mainProduct->gst_tax_group->igst . '"class="primary_input_field igst igst_sku' . $productSku->id . '">
                        <input type="hidden" name="product_cgst[]" net-sub-total="'.$cgstProduct.'" value="' . $productSku->mainProduct->gst_tax_group->cgst . '" class="primary_input_field cgst cgst_sku' . $productSku->id . '">
                        <input type="hidden" name="product_sgst[]" net-sub-total="'.$sgstProduct.'" value="' . $productSku->mainProduct->gst_tax_group->sgst . '" class="primary_input_field sgst sgst_sku' . $productSku->id . '">
                        <input type="hidden" name="product_cess[]" net-sub-total="'.$cessProduct.'" value="' . $productSku->mainProduct->gst_tax_group->cess . '" class="primary_input_field cess cess_sku' . $productSku->id . '">';
            }else{
                $price = $productSku->selling_price;
                $taxProduct = ($productSku->selling_price * $productSku->mainProduct->tax) / 100;
                $taxrow = '<input type="hidden" name="product_tax[]" net-sub-total="'.$taxProduct.'" value="' . $productSku->mainProduct->tax . '" onkeyup="addTax(' . $type . ')" class="primary_input_field2 tax tax_sku' . $productSku->id . '">';
            }
            $name = substr($productSku->products->product_name, 0, 40);

            $output = '';
            $output .= '<tr>
                        <input class="product_min_price product_min_price_sku'.$productSku->id.'" type="hidden" value="' . $productSku->selling_price . '">
                        <th class="nowrap" data-toggle="tooltip" data-placement="top" title="'.$lp.'"><input type="hidden" name="product_id[]" value="' . $productSku->id . '" class="primary_input_field sku_id' . $productSku->id . '">' . $name . '</th>';

            if($posConfig->sku==1){
                $output .= '<td>'.$productSku->id.'</td>';
            }

            $output .= '<td><input class="min_sell_qty_sku'.$productSku->id.'" type="hidden" value="0" name="min_sell_qty[]">
                            <input type="number" name="quantity[]" value="1" placeholder="-" onkeyup="addQuantity(' . $type . ')" class="primary_input_field2 quantity quantity_sku' . $productSku->id . '">
                        </td>
                        <td><input name="product_price[]" step="0.01" data-type="sku" data-sku-id="'.$productSku->id.'" data-product-price="' . $productSku->selling_price . '" min="' . $productSku->selling_price . '" onkeyup="priceCalc(' . $type . ')" class="primary_input_field2 product_price product_price_sku' . $productSku->id . '" type="number"
                        value="' . $price . '"></td>';

            if($posConfig->gst==1){
                $output .= '<td><input name="product_tax_amount[]" step="0.001" data-type="sku" data-sku-id="'.$productSku->id.'" class="primary_input_field2 product_tax_amount product_tax_amount_sku' . $productSku->id . '" type="number" readonly value="0"></td>';
            }

            $output .= '<td>
                            <input type="number" name="product_discount[]" value="0" onkeyup="addDiscount(' . $type . ')" class="primary_input_field2 discount discount_sku' . $productSku->id . '">
                        </td>
                        '.$taxrow.'
                        <td class="product_subtotal product_subtotal_sku' . $productSku->id . '">' . str_replace(',','',number_format($price ,2)) . '</td>
                        <td>
                            <a data-id="' . $productSku->id . '" class="delete_product primary-btn" href="javascript:void(0)">
                                <i class="fas fa-trash-alt required_mark2 f_s_13"></i>
                            </a>
                        </td>
                    </tr>';

            return response()->json($output);
        } catch (\Exception $e) {
            LogActivity::errorLog($e->getMessage());
            return response()->json(['error' => trans("pos.something_went_wrong!")]);
        }
    }
    public function posOrderStore(Request $request)
    {
        if ($request->customer_id == "customer-1" && $request->final_over_sure_amount < 0) {
            Toastr::error(trans("pos.partial_type_payment_is_not_allowed_for_walk_in_customer"));
            return back();
        }
        DB::beginTransaction();
        try {
            $sale = $this->posService->create($request->except('_token'));
            if (is_numeric($sale)){
                DB::rollBack();
                Toastr::error(trans("pos.your_stock_is_out!"));
                return back();
            }
            if ($request->draft){
                DB::commit();
                Toastr::success(trans('pos.successfully_saved'));
                return back();
            }
            DB::commit();
            $payments = Payment::where('payable_id', $sale->id)->get();
            $due = $sale->payable_amount - $payments->sum('amount');

            if ($sale->payable_amount - $payments->sum('amount') == 0 || $sale->payable_amount<$payments->sum('amount')){
                $payment_status = 1;
            }
            if ($sale->payable_amount > $payments->sum('amount')){
                $payment_status = 2;
            }
            if ($sale->payable_amount == $due){
                $payment_status = 0;
            }
            $sale->update([
                'due_amount' => $due,
                'status' => $payment_status,
            ]);
            session()->forget('carts');
            session()->forget('sku');
            session()->put('sale', $sale);
            session()->put('payments', $payments);
            return redirect()->back();
        } catch (\Exception $e) {
            LogActivity::errorLog($e->getMessage());
            DB::rollBack();
            Toastr::error(trans("pos.something_went_wrong!"));
            return back();
        }
    }
    public function draftList()
    {
        try{
            $orders = $this->posService->all()->where('is_draft',1);
            return view('pos::pos_order.draft_list', compact('orders'));
        }catch (\Exception $e) {
            return 0;
        }
    }
    public function draftListProductInfo(Request $request)
    {
        $pos = $this->posService->find($request->order_id);
        $output = '<tr class="d-none">
                    <td><input type="hidden" name="pos_id" value="'.$pos->id.'"></td>
                   </tr>';
        $output = '';
        foreach ($pos->items as $item) {
            $productSku = $this->productRepository->findSkus($item->product_sku_id);
            $lp = 0;
            $type = $productSku->product_id . ",'sku'";

            if ($productSku->mainProduct->tax_type == null) {
                $price = $productSku->selling_price;
                $igstProduct = ($productSku->min_sell_price * $productSku->mainProduct->gst_tax_group->igst) / 100;
                $cgstProduct = ($productSku->min_sell_price * $productSku->mainProduct->gst_tax_group->cgst) / 100;
                $sgstProduct = ($productSku->min_sell_price * $productSku->mainProduct->gst_tax_group->sgst) / 100;
                $cessProduct = ($productSku->min_sell_price * $productSku->mainProduct->gst_tax_group->cess) / 100;
                $taxrow = '<input type="hidden" name="product_igst[]" net-sub-total="'.$igstProduct.'" value="' . $productSku->mainProduct->gst_tax_group->igst . '"class="primary_input_field igst igst_sku' . $productSku->id . '">
                        <input type="hidden" name="product_cgst[]" net-sub-total="'.$cgstProduct.'" value="' . $productSku->mainProduct->gst_tax_group->cgst . '" class="primary_input_field cgst cgst_sku' . $productSku->id . '">
                        <input type="hidden" name="product_sgst[]" net-sub-total="'.$sgstProduct.'" value="' . $productSku->mainProduct->gst_tax_group->sgst . '" class="primary_input_field sgst sgst_sku' . $productSku->id . '">
                        <input type="hidden" name="product_cess[]" net-sub-total="'.$cessProduct.'" value="' . $productSku->mainProduct->gst_tax_group->cess . '" class="primary_input_field cess cess_sku' . $productSku->id . '">';
            }else{
                $price = $productSku->selling_price;
                $taxProduct = ($productSku->selling_price * $productSku->mainProduct->tax) / 100;
                $taxrow = '<input type="hidden" name="product_tax[]" net-sub-total="'.$taxProduct.'" value="' . $productSku->mainProduct->tax . '" onkeyup="addTax(' . $type . ')" class="primary_input_field2 tax tax_sku' . $productSku->id . '">';
            }
            $name = substr($productSku->products->product_name, 0, 40);
            $output .= '<tr>
                <input class="product_min_price product_min_price_sku'.$productSku->id.'" type="hidden" value="' . $productSku->selling_price . '">
                <th class="nowrap" data-toggle="tooltip" data-placement="top" title="'.$lp.'"><input type="hidden" name="product_id[]" value="' . $productSku->id . '" class="primary_input_field sku_id' . $productSku->id . '">' . $name . '</th>
                <td>'.$productSku->id.'</td>
                <td><input class="min_sell_qty_sku'.$productSku->id.'" type="hidden" value="0" name="min_sell_qty[]">
                    <input type="number" name="quantity[]" value="' .$item->quantity. '" placeholder="-" onkeyup="addQuantity(' . $type . ')" class="primary_input_field2 quantity quantity_sku' . $productSku->id . '">
                </td>
                <td><input name="product_price[]" step="0.01" data-type="sku" data-sku-id="'.$productSku->id.'" data-product-price="' . $productSku->selling_price . '" min="' . $productSku->selling_price . '" onkeyup="priceCalc(' . $type . ')" class="primary_input_field2 product_price product_price_sku' . $productSku->id . '" type="number"
                value="' . $price . '"></td>
                <td><input name="product_tax_amount[]" step="0.001" data-type="sku" data-sku-id="'.$productSku->id.'" class="primary_input_field2 product_tax_amount product_tax_amount_sku' . $productSku->id . '" type="number" readonly value="0"></td>
                <td>
                    <input type="number" name="product_discount[]" value="0" onkeyup="addDiscount(' . $type . ')" class="primary_input_field2 discount discount_sku' . $productSku->id . '">
                </td>
                '.$taxrow.'
                <td class="product_subtotal product_subtotal_sku' . $productSku->id . '">' . str_replace(',','',number_format($price ,2)) . '</td>
                <td>
                    <a data-id="' . $productSku->id . '" class="delete_product primary-btn" href="javascript:void(0)">
                        <i class="fas fa-trash-alt required_mark2 f_s_13"></i>
                    </a>
                </td>
            </tr>';
        }
        return response()->json($output);
    }
    public function customerDetails(Request $request)
    {
        $due = $url = $invoice = '';
        try {
            if ($request->pos) {
                $customer_info = explode('-', $request->customer_id);
                $id = $customer_info[1];
                session()->put('customer', $request->customer_id);
                if ($customer_info[0] == 'customer') {
                    $customer = $this->userRepository->findUser($id);
                }
                $sale = $customer->lastPosInvoice;
            } else {
                $type = explode('-', $request->customer_id);
                session()->put('customer', $request->customer_id);
                $id = $type[1];
                if ($type[0] == 'customer') {
                    $customer = $this->userRepository->findUser($id);
                }
                $sale = $customer->lastInvoice;
            }
            $due = 0;
            if ($sale) {
                $url = route('pos.show', $sale->id);
                $invoice = $sale->invoice_no;
            }
            return response()->json([
                'due' => $due,
                'url' => $url,
                'invoice' => $invoice,
                'credit_limit' => $customer->credit_limit,
            ]);
        } catch (\Exception $e) {
            return response()->json(trans("pos.something_went_wrong!"));
        }
    }
    public function orderDetails(Request $request)
    {
        try {
            $due = 0;
            $pos = 0;
            if ($request->pos) {
                $customer_info = explode('-', $request->customer_id);
                $id = $customer_info[1];
                session()->put('customer', $request->customer_id);
                if ($customer_info[0] == 'customer') {
                    $customer = $this->userRepository->findUser($id);
                }
                $sale = $customer->lastPosInvoice;
            } elseif (!$request->pos && $request->customer_id) {
                $type = explode('-', $request->customer_id);
                if ($type[0] == 'customer') {
                    $customer = $this->userRepository->findUser($type[1]);
                }
                $sale = $customer->lastInvoice;
            } else
                $sale = $this->posService->find($request->id);
            if ($sale) {
                $payments = $this->posService->customerDues($sale->customer_id, $request->id);
            }
            if ($request->type)
                $pos = 1;
            $data = [
                'sale' => $sale,
                'due' => $due,
                'pos' => $pos,
            ];
            return view('pos::pos_order.get_details')->with($data);
        } catch (\Exception $e) {
            LogActivity::errorLog($e->getMessage());
            return response()->json(['error' => $e->getMessage()]);
        }
    }

    public function getAttributesByAjax(Request $request){
        return $this->attributeRepository->getAttributesByAjax($request->search);
    }

    public function getCustomersByAjax(Request $request){
        return $this->customerService->getCustomersByAjax($request->search);
    }

    public function get_more_products_for_pos_list(Request $request)
    {
     try {
        if ($request->ajax()) {
            $products = $this->posService->allbyPaginate();
            if (app('general_setting')->pos_view == 1){
                return view('pos::pos_order.components.pos_loadmore_products_grid_view',compact('products'));
            } else {
               return view('pos::pos_order.components.pos_loadmore_products_list_view',compact('products'));
           }
        }
    } catch (\Exception $e) {
        LogActivity::errorLog($e->getMessage());
        return response()->json(['error' => $e->getMessage()]);
    }
    }

    public function posSales()
    {
        return view('pos::pos.pos_sales');
    }

    public function total_sales_get_data()
    {
        if (isset($_GET['table'])) {
            $table = $_GET['table'];
            if ($table == 'pending') {
                $order = $this->posService->totalSalesList()->where('is_draft', 0);
            } else {
                $order = $this->posService->totalSalesList()->where('is_draft', 1);
            }
            return DataTables::of($order)
                ->addIndexColumn()
                ->addColumn('date', function ($order) {
                    return dateConvert($order->created_at);
                })
                ->addColumn('order_number', function ($order) {
                    return getNumberTranslate($order->invoice_no);
                })
                ->addColumn('customer_name', function ($order) {
                    return @$order->customer->first_name.' '.@$order->customer->last_name;
                })

                ->addColumn('total_qty', function ($order) {
                    return getNumberTranslate($order->total_quantity);
                })
                ->addColumn('total_tax', function ($order) {
                    return single_price($order->total_tax);
                })
                ->addColumn('total_amount', function ($order) {
                    return single_price($order->payable_amount);
                })
                ->addColumn('paid_amount', function ($order) {
                    return single_price($order->payments->sum('amount'));
                })
                ->addColumn('due_amount', function ($order) {
                    $due_amount = $order->payable_amount - $order->payments->sum('amount');
                    if (($due_amount) <= 0){
                      return single_price(0);
                    }else{
                      return single_price($due_amount);
                    }
                })
                ->addColumn('action', function ($order) use($table) {
                    return view('pos::pos.components._action_td', compact('order', 'table'));
                })
                ->rawColumns(['order_confirm','order_status', 'is_paid', 'action'])
                ->make(true);
        } else {
            return [];
        }
    }

    public function destroyPosSales($id)
    {
        try{
            $result = $this->posService->destroyPosSales($id);
            if($result === true){
                Toastr::success(__('common.deleted_successfully'), __('common.success'));
            }else{
                Toastr::warning(__('pos.deleted_not_possible_for_this_sale'), __('common.warning'));
            }
            return redirect()->route('pos.pos_sales');


        }catch(Exception $e){
            LogActivity::errorLog($e->getMessage());
            Toastr::error(__('common.error_message'), __('common.error'));
            return back();
        }
    }

    public function showPosSaleDetails($id)
    {
        try{
            $sale = $this->posService->find($id);
            $due = $sale->payable_amount - $sale->payments->sum('amount');
            $data = [
                'sale' => $sale,
                'due' => $due
            ];
            return view('pos::pos.pos_order_details')->with($data);
        }catch (\Exception $e) {
            Toastr::error(trans("pos.something_went_wrong!"));
            return back();
        }
    }

    public function print_view($id)
    {
        try {
            $data['data'] = $this->posService->find($id);
            return view('pos::sale.print_view',$data);
        } catch (\Exception $e) {
            LogActivity::errorLog($e->getMessage());
            Toastr::error('Operation Failed', 'Error!');
            return back();
        }
    }

    public function challan_print_view($id)
    {
        try {
            $data['data'] = $this->posService->find($id);
            return view('pos::sale.challan_print_view',$data);
        } catch (\Exception $e) {
            LogActivity::errorLog($e->getMessage());
            Toastr::error(trans("pos.something_went_wrong!"));
            return back();
        }
    }

    public function getChallanPdf($id)
    {
        try {
            $data = $this->posService->find($id);
            return $this->getChallan('pos::sale.challan_pdf', $data);
        } catch (\Exception $e) {
            LogActivity::errorLog($e->getMessage());
            Toastr::error(trans("pos.something_went_wrong!"));
            return back();
        }
    }

    public function getPdf($id)
    {
        try {
            $data = $this->posService->find($id);
            return $this->getInvoice('pos::sale.pdf', $data);
        } catch (\Exception $e) {
            LogActivity::errorLog($e->getMessage());
            Toastr::error(trans("pos.something_went_wrong!"));
            return back();
        }
    }

    public function conditionalSaleEdit($id)
    {
        session()->forget('sku');
        $sale = $this->posService->find($id);
        try {
            $data = [
                'sale' => $sale,
                'bank_lists'       => $this->posService->allBankAccounts(),
            ];
            return view('pos::sale.edit')->with($data);
        } catch (\Exception $e) {
            LogActivity::errorLog($e->getMessage());
            Toastr::error(trans("pos.something_went_wrong!"));
            return back();
        }
    }

    public function getProductByAjax(Request $request){
        $products = $this->posService->getByAjax($request->search);
        return response()->json($products);
    }

    public function sale_product_modal_for_select(Request $request)
    {
        try {
            $type = explode('-', $request->id);
            $data['product_id'] = $this->posService->storeSkuSale($type[0]);
            return $data;
        } catch (\Exception $e) {
            LogActivity::errorLog($e->getMessage());
            return response()->json(['error' => trans("pos.something_went_wrong!")]);
        }
    }

    public function itemDestroy(Request $request)
    {
        DB::beginTransaction();
        try {
            if ($request->type) {
                ProductItemDetail::destroy($request->id);
            } else
                $this->posService->itemDelete($request->id);

            DB::commit();
            return response()->json(trans("pos.successfully_deleted"));

        } catch (\Exception $e) {
            LogActivity::errorLog($e->getMessage());
            DB::rollBack();
            return trans("pos.something_went_wrong!");
        }
    }

    public function updateSales(Request $request, $id)
    {
        DB::beginTransaction();
        try {
             $this->posService->update($request->except("_token"), $id);
            DB::commit();
            LogActivity::successLog(trans("pos.successfully_updated"));
            Toastr::success(trans("pos.successfully_updated"));
            return redirect()->route('pos.pos_sales');
        } catch (\Exception $e) {
            LogActivity::errorLog($e->getMessage());
            DB::rollBack();
            Toastr::error(trans("pos.something_went_wrong!"));
            return back();
        }
    }

    public function store(CreateProductRequest $request)
    {
        DB::beginTransaction();
        try {
            $this->productService->create($request->except("_token"));
            DB::commit();
            Toastr::success(__('common.added_successfully'), __('common.success'));
            LogActivity::successLog('product upload successful.');
            return redirect()->back();
        } catch (\Exception $e) {
            DB::rollBack();
            LogActivity::errorLog($e->getMessage());
            Toastr::error(__('common.error_message'));
            return back();
        }
    }

    public function clearCart(){
            session()->forget('carts');
            session()->forget('sku');
            session()->forget('sale');
            session()->forget('payments');
            session()->forget('customer');
        return redirect()->back();
    }

    public function posConfig()
    {
        $userId = auth()->user()->id;
        $posConfig = PosConfiguration::first();
        return view('pos::pos_setting.pos_config', compact('posConfig'));
    }

    public function updatePosSkuConfig(Request $request)
    {
        $status = $request->status;
        $config = PosConfiguration::first();
        $config->sku = $status;
        $config->save();

        return response()->json([
            'success' => true,
        ]);
    }
    public function updatePosGstConfig(Request $request)
    {
        $status = $request->status;
        $config = PosConfiguration::first();
        $config->gst = $status;
        $config->save();

        return response()->json([
            'success' => true,
        ]);
    }
    public function updatePosDiscountConfig(Request $request)
    {
        $status = $request->status;
        $config = PosConfiguration::first();
        $config->discount = $status;
        $config->save();

        return response()->json([
            'success' => true,
        ]);
    }

}
