<!DOCTYPE html>
<html>
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="_token" content="{!! csrf_token() !!}" />
    <!-- Bootstrap CSS -->
    @php
        $adminColor = Modules\Appearance\Entities\AdminColor::where('is_active', 1)->first();
        if (Auth::user()->role->type == 'superadmin') {
            $notifications = Modules\OrderManage\Entities\CustomerNotification::where('read_status', 0)
                ->where(function ($query) {
                    $query->whereNotNull('seller_id')->orWhere('customer_id', Auth::id());
                })
                ->latest()
                ->get();
        } else {
            $notifications = Modules\OrderManage\Entities\CustomerNotification::where('read_status', 0)
                ->where(function ($query) {
                    $query->where('seller_id', Auth::id())->orWhere('customer_id', Auth::id());
                })
                ->latest()
                ->get();
        }
        if ($adminColor->background_type == 'image') {
            $background = 'url(' . showImage($adminColor->background_image) . ') no-repeat center';
        } else {
            $background = $adminColor->background_color;
        }
        if ($adminColor->color_mode == 'solid') {
            $gradient1 = $adminColor->solid_color;
            $gradient2 = $adminColor->solid_color;
            $gradient3 = $adminColor->solid_color;
        } else {
            $gradient1 = $adminColor->gradient_color_one;
            $gradient2 = $adminColor->gradient_color_two;
            $gradient3 = $adminColor->gradient_color_three;
        }
    @endphp
    <style>
        :root {
            --background: {{ $background }};
            --base_color: {{ $adminColor->base_color }};
            --gradient_1: {{ $gradient1 }};
            --gradient_2: {{ $gradient2 }};
            --gradient_3: {{ $gradient3 }};
            --text-color: {{ $adminColor->text_color }};
            --border_color: {{ $adminColor->border_color }};
            --scroll_color: {{ $adminColor->scroll_color }};
            --bg_white: {{ $adminColor->background_white }};
            --bg_black: {{ $adminColor->background_black }};
            --input__bg: {{ $adminColor->input_background }};
            --text_white: {{ $adminColor->text_white }};
            --text_black: {{ $adminColor->text_black }};
            --success: {{ $adminColor->success_color }};
            --danger: {{ $adminColor->danger_color }};
            --warning: {{ $adminColor->warning_color }};
        }
        .anchore_color {
            color: #415094;
        }
    </style>
    @include('backEnd.partials._header')
    <style>
        #category_id {
            border-radius: 30px !important;
        }
        span.offer_badge {
            position: absolute;
            right: 0;
            top: 0px;
            background: #efeeee;
            font-size: 10px;
            font-weight: 500;
            padding: 5px 4px 2px 4px;
            line-height: 1;
            display: inline-block;
            border-radius: 3px;
        }
        label.primary-btn.small.fix-gr-bg {
            top: 8px;
            right: 5px;
        }
        .nice-select.has-multiple {
            white-space: inherit;
            height: auto;
            padding: 7px 12px;
            min-height: 40px;
            line-height: 22px;
            width: 120px;
            border-radius: 4px;
            line-height: 40px;
        }
        .primary_select.nice-select.has-multiple:after {
            top: 25% !important;
            transform: translateY(-95%) rotate(0deg) !important;
        }
        .width_pos_130 {
            width: 132px !important;
        }
        .pb_15 {
            padding-bottom: 13px;
        }
        .pointer {
            cursor: pointer;
        }
        .mini_main_content {
            margin-left: 0 !important;
            width: calc(100% - 0px) !important;
        }
        @media (min-width: 1200px) {
            #main-content {
                padding: 0 0 0px 0 !important;
            }
        }
        .header_iner {
            margin: 0 0 0px 0;
            padding: 5px;
        }
        .invoice_table {
            border-collapse: collapse;
        }
        .nice-select.open .list {
            overflow-y: auto;
            /* max-height: 200px; */
            overflow: auto !important;
        }
        h1,
        h2,
        h3,
        h4,
        h5,
        h6 {
            margin: 0;
        }
        .hide_element {
            display: none !important;
        }
        .dashed-underline {
            display: block;
            border-bottom: 1px dashed #000;
            margin: 5px 0;
        }
        .invoice_wrapper {
            max-width: 435px;
            margin: auto;
        }
        .invoice_table {
            width: 100%;
            margin-bottom: 1rem;
            color: #212529;
        }
        .border_none {
            border: 0px solid transparent;
            border-top: 0px solid transparent !important;
        }
        .invoice_part_iner {
            background-color: #fff;
            padding: 20px;
        }
        .invoice_part_iner h4 {
            font-size: 30px;
            font-weight: 500;
            margin-bottom: 40px;
        }
        .invoice_part_iner h3 {
            font-size: 25px;
            font-weight: 500;
            margin-bottom: 5px;
        }
        .table_border thead {
            background-color: #F6F8FA;
        }
        .red_border {
            color: red !important;
            border: 1px solid red !important;
        }
        .invoice_table td,
        .table th {
            padding: 5px 0;
            vertical-align: top;
            border-top: 0 solid transparent;
            color: #79838b;
        }
        .invoice_table td,
        .table th {
            padding: 5px 0;
            vertical-align: top;
            border-top: 0 solid transparent;
            color: #79838b;
        }
        .table_border tr {
            border-bottom: 1px solid #000 !important;
        }
        th p span,
        td p span {
            color: #212E40;
        }
        .invoice_table th {
            color: #00273d;
            font-weight: 300;
            border-bottom: 1px solid #f1f2f3 !important;
            background-color: #fafafa;
        }
        h5 {
            font-size: 12px;
            font-width: 500;
        }
        h6 {
            font-size: 10px;
            font-weight: 300;
        }
        .mt_40 {
            margin-top: 40px;
        }
        .table_style th,
        .table_style td {
            padding: 20px;
        }
        .invoice_info_table td {
            font-size: 10px;
            padding: 0px;
        }
        .invoice_info_table td h6 {
            color: #6D6D6D;
            font-weight: 400;
        }
        p {
            font-size: 10px;
            color: #454545;
        }
        .invoice_info_table2 tbody th {
            background: transparent;
            padding: 0px;
            text-align: right;
            border-bottom: 1px dotted #000 !important;
        }
        .invoice_info_table2 tbody td {
            padding: 0px;
        }
        .table_border2 thead {
            border-bottom: 1px solid #000 !important;
        }
        .table_border2 thead th {
            background: transparent;
            border-bottom: 1px solid #000 !important;
            font-size: 10px;
        }
        .table_border2 tbody td {
            padding: 0px;
            font-size: 10px;
        }
        .w_70 {
            width: 70%;
        }
        .pdf_table_1 th {
            font-size: 10px;
            padding: 3px;
            background: transparent;
            border-bottom: 1px solid #000 !important;
            border-top: 1px solid #000 !important;
            text-align: left;
        }
        .pdf_table_2 th {
            font-size: 10px;
            padding: 3px;
            background: transparent;
            border-bottom: 1px solid #000 !important;
            border-top: 1px solid #000 !important;
            text-align: left;
        }
        .pdf_table_2 td {
            padding: 0;
        }
        .pdf_table_2 tfoot td {
            background: #D2D6DE;
            color: #000 !important;
        }
        .dashed_table th {
            background: transparent;
            border-bottom: 0 !important;
            text-align: right;
            padding: 0 !important;
            font-size: 10px;
        }
        .dashed_table td {
            padding: 0 !important;
        }
        .dashed_table td span {
            border-bottom: 1px dotted #000;
            padding: 0;
            display: block;
            margin-left: 5px;
            font-size: 10px;
        }
        .balance_text strong {
            font-style: italic;
        }
        hr {
            margin: 0 !important;
        }
        .invoice_wrapper h3,
        .invoice_wrapper h5,
        .invoice_wrapper h6,
        .invoice_wrapper h4 {
            color: #000000;
        }
        .invoice_wrapper table td,
        .invoice_wrapper table th {
            font-size: 10px !important;
        }
        @media print {
            @page {
                size: landscape
            }
        }
        /* Custom */
        .responsive_unset {
            overflow-x: unset !important;
        }
        .overflow-unset2 {
            overflow: unset !important;
            max-height: inherit;
        }
        .right-scroll {
            /* overflow: auto; */
        }
        .mar-top {
            margin-top: 6px;
        }
        .all_padd {
            padding: 9px;
        }
        .clear-button {
            margin-top: 5px;
            margin-right: 15px;
        }
        .dark_select .primary_select {
            height: 50px;
            border: 0;
            border-radius: 0;
            background: #3C4777 !important;
            line-height: 50px;
            color: #fff;
        }
        .pos_serch_field input {
            background: #3C4777 !important;
            border: 0;
            border-radius: 0;
            color: #fff;
            height: 50px;
        }
        select#pos_customer_id ~ .nice-select {
            display: none;
        }
        .posRightSectionClearFix .select2 {
            flex: 0 0 auto;
            width: calc(100% - 50px) !important;
        }
        .posRightSectionClearFix .select2-container--default .select2-selection--single .select2-selection__rendered, .select2-container--default .select2-selection--multiple {
            background: transparent !important;
            border: none !important;
            color: #fff !important;
            font-size: 14px !important;
        }
        .posRightSectionClearFix .select2-container--default .select2-selection--single{
            background-color: transparent !important;
        }
    </style>
    @yield('css')
    <link rel="stylesheet" href="{{ asset(asset_path('modules/pos/frontend/css/style.css')) }}" />
</head>
<body class="pos_admin">
    <div id="pre-loader">
        @include('backEnd.partials.preloader')
    </div>
    <div class="main-wrapper">
        <div class="w-100 m-0" id="main-content">
            @php
                $price = $quantity = 0;
                $productTaxTotal = 0;
            @endphp
            <section class="up_st_admin_visitor d-flex flex-row-fluid flex-column">
                <!-- menu  -->
                @include('pos::pos_order.components.header_menu')
                <!--/ menu  -->
                <div class="pos__page__wrapper pos_grid_box flex-column-fluid">
                    @include('pos::pos_order.components.left_section')
                    @include('pos::pos_order.components.right_section')
                </div>
                <!-- pos_fullBtn_grid  -->
                <div class="pos_fullBtn_grid">
                    <div class="pos_full_btn d-flex justify-content-between align-items-center">
                        <span>{{ __('common.total') }}:</span>
                        <span class="total_amount_display">{{ single_price(0) }}</span>
                    </div>
                    <button class="primary_color_btn pay_now_grn_btn green_btn" type="button"
                        onclick="multiplePaymentModal()">{{ __('pos.pay_now') }}</button>
                </div>
            </section>
            <div id="draftList_modal">
            </div>
            <div class="view_modal">
            </div>
            <div class="add-product-modal">
                @include('pos::pos_order.components.add_product_modal')
                @include('pos::pos_order.components.add_product_modal_multivendor')
            </div>
            @include('pos::pos_order.components.add_customer')
            <div class="invoice_details w-100">
            </div>
            @if (session()->has('sale'))
                @php
                    $sale = session()->get('sale');
                @endphp
                <input type="hidden" name="invoice" value="{{ $sale->id }}" class="invoice">
                @include('pos::pos_order.components.pos_print_view')
            @endif
            @include('pos::pos_order.approve_modal')
            <!-- footer  -->
        </div>
    </div>
    @include('backEnd.partials._modal')
    <div id="mediaManagerDiv">
    </div>
    @include('backEnd.partials._scripts')
    <script>
        $(document).on('click', '[data-toggle="amazUploaderAddSelected"]', function(e){
            $('.pos_admin').addClass('modal-scroll');
        })
        $(".language_toggle_btn").on("click", function() {
            $(this).siblings(".language_toggle_box").toggleClass("active");
        });
        $(document).on('submit', '#contact_add_form',  function(event) {
            event.preventDefault();
            $("#pre-loader").removeClass('d-none');
            var formElement = $(this).serializeArray()
            var formData = new FormData();
            formElement.forEach(element => {
                formData.append(element.name, element.value);
            });
            formData.append('_token', "{{ csrf_token() }}");
            resetValidationErrors();
            $.ajax({
                url: "{{ route('add_contact.store') }}",
                type: "POST",
                cache: false,
                contentType: false,
                processData: false,
                data: formData,
                success: function(response) {
                    toastr.success("{{__('common.created_successfully')}}", "{{__('common.success')}}");
                    $('#add_customer').modal('hide');
                    dynamicSelect2WithAjax("#pos_customer_id", "{{ route('get-customers-by-ajax') }}", "GET");
                    $("#pre-loader").addClass('d-none');
                },
                error: function(response) {
                    if(response.responseJSON.error){
                        toastr.error(response.responseJSON.error ,"{{__('common.error')}}");
                        $('#pre-loader').addClass('d-none');
                        return false;
                    }
                    showValidationErrors('#contact_add_form', response.responseJSON.errors);
                    $("#pre-loader").addClass('d-none');
                }
            });
        });
        function showValidationErrors(formType, errors) {
            $(formType +' #error_first_name').text(errors.first_name);
            $(formType +' #error_email').text(errors.email);
            $(formType +' #error_password').text(errors.password);
        }
        function resetValidationErrors(){
            $('#error_first_name').text('');
            $('#error_email').text('');
            $('#error_password').text('');
        }
        $(document).click(function(event) {
            if (!$(event.target).closest(".language_toggle_btn ,.language_toggle_box")
                .length
            ) {
                $("body").find(".language_toggle_box").removeClass("active");
            }
        });
        $(document).ready(function() {
            dynamicSelect2WithAjax3(".brand_id", "{{ route('product.brands.get-by-ajax') }}", "GET");
            dynamicSelect2WithAjax3(".category_id", "{{ url('/products/get-category-data') }}", "GET");
            function dynamicSelect2WithAjax3(selector, url, urlType) {
                $(selector).select2({
                    dropdownParent: $("#add_product_multivendor #category_id_for_mv"),
                    ajax: {
                        url: url,
                        type: urlType,
                        dataType: 'json',
                        delay: 250,
                        data: function(params) {
                            return {
                                search: params.term, // search term
                                page: params.page || 1
                            };
                        },
                        processResults: function(response, params) {
                            params.page = params.page || 1;
                            return {
                                results: response,
                                pagination: {
                                    more: false
                                }
                            };
                        },
                        cache: false,

                    }
                });
            }
            dynamicSelect2WithAjaxProduct(".main_product_for_select", "{{ url('/products/get-by-ajax') }}", "GET");
            function dynamicSelect2WithAjaxProduct(selector, url, urlType) {
                $(selector).select2({
                    dropdownParent: $("#add_product_multivendor #product_div"),
                    ajax: {
                        url: url,
                        type: urlType,
                        dataType: 'json',
                        delay: 250,
                        data: function(params) {
                            return {
                                search: params.term, // search term
                                page: params.page || 1
                            };
                        },
                        processResults: function(response, params) {
                            params.page = params.page || 1;
                            return {
                                results: response,
                                pagination: {
                                    more: false
                                }
                            };
                        },
                        cache: false,

                    }
                });
            }
            dynamicSelect2WithAjax(".category_select_id", "{{ url('/products/get-category-data') }}", "GET");
            dynamicSelect2WithAjax(".brand_select_id", "{{ route('product.brands.get-by-ajax') }}", "GET");
            dynamicSelect2WithAjax(".model_select_id", "{{ route('get-attributes-by-ajax') }}", "GET");
            dynamicSelect2WithAjax("#pos_customer_id", "{{ route('get-customers-by-ajax') }}", "GET");
            dynamicSelect2WithAjaxSV(".sv_category_id", "{{ url('/products/get-category-data') }}", "GET");
            dynamicSelect2WithAjaxSV(".sv_brand_id", "{{ route('product.brands.get-by-ajax') }}", "GET");
            function dynamicSelect2WithAjaxSV(selector, url, urlType) {
                $(selector).select2({
                    dropdownParent: $("#add_product #category_id_for_mv"),
                    ajax: {
                        url: url,
                        type: urlType,
                        dataType: 'json',
                        delay: 250,
                        data: function(params) {
                            return {
                                search: params.term, // search term
                                page: params.page || 1
                            };
                        },
                        processResults: function(response, params) {
                            params.page = params.page || 1;
                            return {
                                results: response,
                                pagination: {
                                    more: true
                                }
                            };
                        },
                        cache: true,
                    }
                });
            }
            // load more homepage
            var ENDPOINT = "{{ url('/') }}";
            var Cpage = 1;
            $(document).on('click', '.load_more_btn_homepage', function(event) {
                $('#pre-loader').removeClass('d-none');
                event.preventDefault();
                Cpage++;
                var new_url = '/get-more-products-for-pos-list?page=';
                if ($('#pos_view_config').val() == 1) {
                    var tbl_name = ".all_products";
                } else {
                    var tbl_name = ".all_products_tbl";
                }
                infinteLoadMore(Cpage, new_url, tbl_name);
            });
            function infinteLoadMore(page, new_url, tbl_name) {
                $.ajax({
                        url: ENDPOINT + new_url + page,
                        datatype: "html",
                        type: "GET",
                        beforeSend: function() {
                            $('#pre-loader').show();
                        }
                    })
                    .done(function(response) {
                        if (response.length == 0) {
                            $(".load_more_btn_homepage").addClass('d-none');
                            toastr.warning("{{ __('defaultTheme.no_more_data_to_show') }}");
                            $('#pre-loader').hide();
                            return;
                        }
                        $('#pre-loader').addClass('d-none');
                        $(tbl_name).append(response);
                    })
                    .fail(function(jqXHR, ajaxOptions, thrownError) {
                        toastr.error("{{ __('common.error_message') }}", "{{ __('common.error') }}");
                        $('#pre-loader').hide();
                    });
            }
            $('.bell_notification_clicker2').on('click', function() {
                $('.Menu_NOtification_Wrap2').toggleClass('active');
            });
            //Change product type
            $(document).on('change', '.prod_type', function() {
                var checkWholeSaleM = '{{ isModuleActive('WholeSale') ? 1 : null }}';
                if ($('#single_prod').is(":checked")) {
                    if (checkWholeSaleM == 1) {
                        $('.whole_sale_info_add').css('display', 'block');
                        $('.whole_sale_price_list_child').remove();
                        $('.whole_sale_info_add tbody').append(`<tr class="whole_sale_price_list">
                            <td class="pl-0 pb-0 border-0">
                                <input type="text" class="form-control primary_input_field" placeholder="Min QTY" name="wholesale_min_qty_0[]">
                            </td>
                            <td class="pl-0 pb-0 border-0">
                                <input type="text" class="form-control primary_input_field" placeholder="Max QTY" name="wholesale_max_qty_0[]">
                            </td>
                            <td class="pl-0 pb-0 border-0">
                                <input type="text" class="form-control primary_input_field" placeholder="Price per piece" name="wholesale_price_0[]">
                            </td>
                        </tr>`);
                    }
                } else {
                    $('.whole_sale_info_add').css('display', 'none');
                    $('.whole_sale_price_list').remove();
                    $('.whole_sale_price_list_child').remove();
                }
            });
            // add product
            let base_url = $('#url').val();
            $(document).on('change', '#shipping_country', function(event) {
                let country = $('#shipping_country').val();
                $('#pre-loader').removeClass('d-none');
                if (country) {
                    let url = base_url + '/seller/profile/get-state?country_id=' + country;
                    $('#shipping_state').empty();
                    $('#shipping_state').append(
                        `<option value="" disabled selected>{{ __('common.select_one') }}</option>`
                    );
                    $('#shipping_state').niceSelect('update');
                    $('#shipping_city').empty();
                    $('#shipping_city').append(
                        `<option value="" disabled selected>{{ __('common.select_one') }}</option>`
                    );
                    $('#shipping_city').niceSelect('update');
                    $.get(url, function(data) {
                        $.each(data, function(index, stateObj) {
                            $('#shipping_state').append('<option value="' + stateObj.id +
                                '">' + stateObj.name + '</option>');
                        });
                        $('#shipping_state').niceSelect('update');
                        $('#pre-loader').addClass('d-none');
                    });
                }
            });
            $(document).on('change', '#shipping_state', function(event) {
                let state = $('#shipping_state').val();
                $('#pre-loader').removeClass('d-none');
                if (state) {
                    let url = base_url + '/seller/profile/get-city?state_id=' + state;
                    $('#shipping_city').empty();
                    $('#shipping_city').append(
                        `<option value="" disabled selected>{{ __('common.select_one') }}</option>`
                    );
                    $('#shipping_city').niceSelect('update');
                    $.get(url, function(data) {
                        $.each(data, function(index, cityObj) {
                            $('#shipping_city').append('<option value="' + cityObj.id +
                                '">' + cityObj.name + '</option>');
                        });
                        $('#shipping_city').niceSelect('update');
                        $('#pre-loader').addClass('d-none');
                    });
                }
            });
        });
        $('.close_modal').on('click', function() {
            $('.custom_notification').removeClass('open_notification');
        });
        $('.notification_icon').on('click', function() {
            $('.custom_notification').addClass('open_notification');
        });
        $(document).click(function(event) {
            if (!$(event.target).closest(".custom_notification").length) {
                $("body").find(".custom_notification").removeClass("open_notification");
            }
        });
        $(document).ready(function() {
            $('#languageChange').on('change', function() {
                var str = $('#languageChange').val();
                var url = $('#url').val();
                var formData = {
                    id: $(this).val()
                };
                // get section for student
                $.ajax({
                    type: "POST",
                    data: formData,
                    dataType: 'json',
                    url: url + '/' + 'language-change',
                    success: function(data) {
                        url = url + '/' + 'locale' + '/' + data[0].language_universal;
                        window.location.href = url;
                    },
                    error: function(data) {
                        
                    }
                });
            });
            $(document).on('click', '.add-product', function() {
                $.get('#', function(data) {
                    $(".add-product-modal").html(data);
                    $("#add_product").modal('show');
                    $('select').niceSelect();
                    $('.summernote3').summernote({
                        height: 200,
                        tooltip: false
                    });
                });
            });
        });
    </script>
    @yield('script')
    <script type="text/javascript">
        var baseUrl = $('#app_base_url').val();
        let credit_limit = 0;
        let url = 0;
        $(document).on('change', '.gst_group', function() {
            setPricewithTax();
        })
        $(window).on('load', function() {
            var modal = $('.invoice').val();
            if (modal > 0) {
                $('#invoice').modal('show');
            }
        });
        $(document).ready(function() {
            saleDetails()
            $(document).on('click', '.due_btn', function(e) {
                e.preventDefault()
                var a = $("input[name='min_sell_qty[]']").map(function() {
                    return $(this).val();
                }).get();
                if ($.inArray('1', a) == -1) {
                    $('.due_btn').prop('disabled', true);
                    $('#due').val(1);
                    $("#post_form_submit").submit();
                } else {
                    toastr.warning('Opps!! You cannot sale below min price !');
                }
            });
            $(document).on('click', '#save_button_note', function(e) {
                $('#noteModal').modal('hide');
            });
            $(document).on('click', '.product_info', function() {
                let id = $(this).data('id');
                let product_id = $(this).data('value');
                let sku_quantity = parseInt($('.quantity_sku' + product_id).val());
                let combo_quantity = parseInt($('.quantity_combo' + product_id).val());
                let customer = $('#pos_customer_id').val();
                if (customer === '' || customer == 'undefined') {
                    toastr.error('Please select customer first');
                    return false;
                }
                let gst = $('.gst_group').find(":selected").val();
                $('#pre-loader').removeClass('d-none');
                $.post('{{ route('pos.product_modal_for_select') }}', {
                    _token: '{{ csrf_token() }}',
                    id: id,
                    customer: customer,
                }, function(data) {
                    if (data.product_type == "Variant") {
                        $('.view_modal').html(data.html);
                        $('#Item_Details').modal('show');
                    } else {
                        if (data.product_id == 1) {
                            if (data.product_type == "Single") {
                                let totalQTY = sku_quantity + 1;
                                let productPrice = parseFloat($(".product_price_sku" + product_id)
                                    .val());
                                $('.quantity_sku' + product_id).val(totalQTY);
                                let totalBillAmount = totalQTY * productPrice;
                                $('.product_subtotal_sku' + product_id).text(parseFloat(
                                    totalBillAmount).toFixed(
                                    2));
                                let tr = $('.quantity_sku' + product_id).parent().parent();
                                calcutionTaxDiscount(tr)
                                productTax();
                                addTotalDiscount();
                                addQuantity(product_id, "sku");
                            } else {
                                $('.quantity_combo' + product_id).val(combo_quantity + 1);
                                addQuantity(product_id, "combo");
                            }
                            setPricewithTax()
                            totalCalcuationAfterChange()

                        } else {
                            $('#product_details').prepend(data.product_id);
                            setPricewithTax()
                            totalCalcuationAfterChange()
                            addTotalDiscount();
                        }
                    }
                    $('#pre-loader').addClass('d-none');
                });
            });
            $(document).on('click', '.delete_product', function() {
                var whichtr = $(this).closest("tr");
                var id = $(this).data('id');
                whichtr.remove();
                let total_quantity = 0;
                let total_amount = 0;
                $.each($('.quantity'), function(index, value) {
                    let amount = $(this).val();
                    total_quantity += parseFloat(amount);
                });
                $.each($('.product_subtotal'), function(index, value) {
                    let amount = $(this).text();
                    total_amount += parseFloat(amount);
                });
                $('.total_price').text(total_amount);
                $('.total_amount').val(total_amount);
                let discount = parseFloat($('.total_discount').val());
                let tax = parseFloat($('.total_tax').val());
                let shipping_charge = parseFloat($('.shipping_charge').val());
                let other_charge = parseFloat($('.other_charge').val());
                let ProductTaxTotal = parseFloat($('.product_tax_input').val());

                let vat = parseFloat($('.total_vat').val());
                let calculated_discount = 0;
                let calculated_vat = 0;
                if (vat > 0) {
                    calculated_vat = ((total_amount - discount) / 100) * vat;
                }
                if (discount > 0) {
                    calculated_discount = discount;
                }
                let final_amount = (total_amount + calculated_vat) - calculated_discount;
                $('.total_amount_tr').text((final_amount).toFixed(2));
                $('.total_amount_display').text((final_amount).toFixed(2));
                if (total_quantity > 0 || !isNaN(total_quantity)) {
                    $('.total_quantity').text(total_quantity);
                    $('.total_quantity').val(total_quantity);
                } else {
                    $('.total_quantity').text(0);
                    $('.total_quantity').val(0);
                }
                productTax();
                $('#pre-loader').removeClass('d-none');
                $.ajax({
                    url: "{{ route('item.session.delete') }}",
                    method: "POST",
                    data: {
                        "id": id,
                        "_token": "{{ csrf_token() }}",
                    },
                    success: function(result) {
                        toastr.success(result.success);
                        $('#pre-loader').addClass('d-none');
                    }
                })
            });
            var timer = '';
            $(document).on('click', '.reset-product-list', function() {
                window.location.reload();
            });
            $(document).on('input', '#search_keyword_id', function() {
                clearTimeout(timer);
                timer = setTimeout(function() {
                    loadProductBySearch();
                }, 1000);
            });
            $(document).on('change', '#category_select_id', function() {
                clearTimeout(timer);
                timer = setTimeout(function() {
                    loadProductBySearch();
                }, 1000);
            });
            $(document).on('change', '#brand_select_id', function() {
                clearTimeout(timer);
                timer = setTimeout(function() {
                    loadProductBySearch();
                }, 1000);
            });
            $(document).on('change', '#model_select_id', function() {
                clearTimeout(timer);
                timer = setTimeout(function() {
                    loadProductBySearch();
                }, 1000);
            });
            $(document).on('click', '.loadmore_btn', function() {
                var totalCurrentResult = $('.all_products div.product_thumb').length;
                let category_id = $('.product_category').val();
                let brand_id = $('.product_brand').val();
                let model_id = $('.product_model').val();
                let value = $('.product_info').val();
                let pos_view = 1;
                $.ajax({
                    url: "#",
                    method: "POST",
                    data: {
                        skip: totalCurrentResult,
                        category_id: category_id,
                        brand_id: brand_id,
                        model_id: model_id,
                        value: value,
                        pos_view: pos_view,
                        _token: "{{ csrf_token() }}",
                    },
                    beforeSend: function() {
                        $(".demo_wait").show();
                    },
                    success: function(response) {
                        $(".demo_wait").hide()
                        if (response.loadBtn == 0)
                            $(".loadmore_btn").hide();
                        else
                            $(".loadmore_btn").show();
                        $(".all_products").append(response.products);
                    }
                })
            })
        });
        function modal_close() {
            $('#invoice').remove();
            $('.modal-backdrop').remove();
        }
        function loadProductBySearch() {
            $('#pre-loader').removeClass('d-none');
            let category_id = $('#category_select_id').val();
            if (category_id == "[]" || category_id == '') {
                category_id = 0;
            }
            let brand_id = $('.product_brand').val();
            let attribute_id = $('.product_model').val();
            let search_keyword = $('.search_product').val();
            $.ajax({
                method: "POST",
                url: "{{ route('pos-order.find.Product') }}",
                data: {
                    search_keyword: search_keyword,
                    brand_id: brand_id,
                    category_id: category_id,
                    attribute_id: attribute_id,
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    $('.search_filter_product').html(response);
                    $('#pre-loader').addClass('d-none');
                }
            })
        }
        function multiplePaymentModal() {
            $('.pay_now_grn_btn').prop('disabled', true);
            var a = $("input[name='min_sell_qty[]']").map(function() {
                return $(this).val();
            }).get();
            downPaymentAmount();
            if ($.inArray('1', a) == -1) {
                var customer_id = $('#pos_customer_id').val();
                if (customer_id === '' || customer_id == 'undefined') {
                    toastr.error('Please select customer first');
                    $('.pay_now_grn_btn').prop('disabled', false);
                    return false;
                }
                if ($('#installment_status').is(':checked') == true) {
                    var paying_amount = parseFloat($('.down_payment_money').val());
                } else {
                    var paying_amount = parseFloat($('.total_amount').val());
                }
                var total_amount = parseFloat($('.total_amount').val());
                var total_qty = $('.total_quantity').val();
                $('#due_btn').val(0);
                if (total_amount > 0) {
                    $('#pre-loader').removeClass('d-none');
                    $.post('{{ route('pos_multiple_payment') }}', {
                        _token: '{{ csrf_token() }}',
                        customer_id: customer_id,
                        total_amount: total_amount,
                        paying_amount: paying_amount,
                        total_qty: total_qty
                    }, function(data) {
                        $('#pre-loader').addClass('d-none');
                        $('.pay_now_grn_btn').prop('disabled', false);
                        $('#multiple_payment_form').html(data);
                        $('#Pos_Payment_Multiple').modal('show');
                        $('.quick_cash_number').hide();
                        $('select').niceSelect();
                    });
                } else {
                    $('.pay_now_grn_btn').prop('disabled', false);
                    toastr.warning('At least select one Item first !');
                }
            } else {
                $('.pay_now_grn_btn').prop('disabled', false);
                toastr.warning('Opps!! You cannot sale below min price !');
            }
        }
        $(document).on('keyup', '.down_payment', function(e) {
            downPaymentAmount();
        });
        function downPaymentAmount() {
            var total_amount = parseFloat($('.total_amount').val());
            var down_payment_percentage = parseFloat($('.down_payment').val());
            var down_payment_money = ((total_amount * down_payment_percentage) / 100);
            if (!isNaN(down_payment_money)) {
                $('.down_payment_money').val((down_payment_money).toFixed(2));
            } else {
                $('.down_payment_money').val(0);
            }
        }
        $(document).on('click', '#installment_status', function(e) {
            if ($('#installment_status').is(':checked') == true) {
                $('.installment_rld_div').removeClass('d-none');
                $('.down_payment_div').removeClass('d-none');
                downPaymentAmount();
            } else {
                $('.installment_rld_div').addClass('d-none');
                $('.down_payment_div').addClass('d-none');
            }
        });
        function cashPaymentModal() {
            var customer_id = $('#pos_customer_id').val();
            var total_amount = $('.total_amount').val();
            var total_qty = $('.total_quantity').val();
            if (total_amount > 0) {
                $('#pre-loader').removeClass('d-none');
                $.post('#', {
                    _token: '{{ csrf_token() }}',
                    customer_id: customer_id,
                    total_amount: total_amount,
                    total_qty: total_qty
                }, function(data) {
                    $('#pre-loader').addClass('d-none');
                    $('#multiple_payment_form').html(data);
                    $('#Pos_Payment_Multiple').modal('show');
                    $('select').niceSelect();
                });
            } else {
                toastr.warning('At least select one Item first !');
            }
        }
        function makeitDraft() {
            event.preventDefault();
            var a = $("input[name='min_sell_qty[]']").map(function() {
                return $(this).val();
            }).get();
            if ($.inArray('1', a) == -1) {
                var customer_id = $('#pos_customer_id').val();
                if (customer_id === '' || customer_id == 'undefined') {
                    toastr.error('Please select customer first');
                    return false;
                }
                $('#draft').val('draft');
                var total_amount = $('.total_amount').val();
                if (total_amount > 0) {
                    $('.pos_form').submit();
                }
            } else {
                toastr.warning('Opps!! You cannot make it draft below min selling price !');
            }
        }
        function draftListModal() {
            event.preventDefault();
            $('#pre-loader').removeClass('d-none');
            $.get('{{ route('get_draft_list') }}', function(data) {
                $('#pre-loader').addClass('d-none');
                $('#draftList_modal').html(data);
                $('#draft_list').modal('show');
                $('select').niceSelect();
            });
        }
        function disableAll() {
            $('.draft_btn').prop('disabled', true);
            $('.draft_list_btn').prop('disabled', true);
            $('.cash_btn').prop('disabled', true);
            $('.multyPay_btn').prop('disabled', true);
            $('.due_btn').prop('disabled', true);
        }
        function enableAll() {
            $('.draft_btn').prop('disabled', false);
            $('.draft_list_btn').prop('disabled', false);
            $('.cash_btn').prop('disabled', false);
            $('.multyPay_btn').prop('disabled', false);
            $('.due_btn').prop('disabled', false);
        }
        function demo(el) {
            $('#product_details tr').remove();
            $('#pre-loader').removeClass('d-none');
            $.post('{{ route('get_draft_list_product_info') }}', {
                _token: '{{ csrf_token() }}',
                order_id: el
            }, function(data) {
                $('#pre-loader').addClass('d-none');
                $('#draft_list').modal('hide');
                $('#product_details').append(data);
                setPricewithTax();
            });
        }
        $(document).on('input', '.pay_term_in_days', function() {
            var payterm_in_days = $('.pay_term_in_days').val();
            var date = new Date();
            if (payterm_in_days > 0) {
                date.setDate(date.getDate() + parseInt(payterm_in_days));
                moment(date).format('MM/DD/YYYY')
                var due_date_number = date.getDate();
                $('.due_date').val(moment(date).format('MM/DD/YYYY'));
            } else {
                moment(date).format('MM/DD/YYYY')
                var due_date_number = date.getDate();
                $('.due_date').val(moment(date).format('MM/DD/YYYY'));
            }
        });
        function saleDetails() {
            let customer_id = $('#pos_customer_id').val();
            if (customer_id != '') {
                $('#pre-loader').removeClass('d-none');
                $('.due_btn').show();
                $('.condition_div').removeClass('hide_element');
                $('.installment_mod_div').removeClass('hide_element');
                $.ajax({
                    method: 'POST',
                    url: "{{ route('customer.details') }}",
                    data: {
                        customer_id: customer_id,
                        pos: 'pos',
                        _token: "{{ csrf_token() }}",
                    },
                    success: function(result) {
                        if(result!='pos.something_went_wrong!'){
                            $('#pre-loader').addClass('d-none');
                            $('.due_row').show();
                            if (result.credit_limit)
                                credit_limit = parseFloat(result.credit_limit);
                            if (result.due > credit_limit) {
                                toastr.warning('Your due is greater than your credit limit');
                            }
                            $('.customer_due').show();
                            $('.balance_due').text(' ' + result.due);
                            $('.pay_term_in_days').val(result.payterm_in_days);
                            var date = new Date();
                            if (result.payterm_in_days > 0) {
                                date.setDate(date.getDate() + parseInt(result.payterm_in_days));
                                moment(date).format('MM/DD/YYYY')
                                var due_date_number = date.getDate();
                                $('.due_date').val(moment(date).format('MM/DD/YYYY'));
                            } else {
                                moment(date).format('MM/DD/YYYY')
                                var due_date_number = date.getDate();
                                $('.due_date').val(moment(date).format('MM/DD/YYYY'));
                            }
                            if (result.url) {
                                $('.customer_invoice').show();
                                url = 1;
                                $('.invoice_link').text(' ' + result.invoice);
                            } else {
                                $('.customer_invoice').hide();
                                url = 0;
                                let tfoot = $('.pos_tfoot tr th').length;
                                if (tfoot == 7) {
                                    $('.pos_tfoot tr th:last').remove();
                                }
                            }
                        }else{
                            $('#pre-loader').addClass('d-none');
                        }
                    }
                })
            }
            setPricewithTax()
        }
        function invoiceDetail() {
            let customer_id = $('#pos_customer_id').val();
            if (url == 1) {
                $.ajax({
                    method: 'POST',
                    url: "{{ route('get_sale_details') }}",
                    data: {
                        customer_id: customer_id,
                        pos: 'pos',
                        _token: "{{ csrf_token() }}",
                    },
                    success: function(result) {
                        $('.invoice_details').html(result);
                        $('#sale_info_modal').modal('show');
                    }
                })
            }
        }
        function specificInvoiceDetail(el) {
            let customer_id = $('.contact_type').val();
            let id = el;
            $.ajax({
                method: 'POST',
                url: "#",
                data: {
                    customer_id: customer_id,
                    id: id,
                    _token: "{{ csrf_token() }}",
                },

                success: function(result) {
                    $('.invoice_details').html(result);
                    $('#sale_info_modal').modal('show');
                }
            })
        }
        function setPricewithTax() {
            let amount = 0;
            $.each($('.product_price'), function(index, value) {
                var whichtr = $(this).closest("tr");
                var qty = parseFloat(whichtr.find('.quantity').val());
                var discount_percent = parseFloat(whichtr.find('.discount').val());
                var min_price = parseFloat(whichtr.find('.product_min_price').val());
                var a = parseFloat(whichtr.find('.product_price').attr("data-product-price"));
                if (typeof whichtr.find('.tax').val() !== "undefined") {
                    var b = parseFloat(whichtr.find('.tax').val()) / 100;
                } else if (typeof whichtr.find('.igst').val() !== "undefined") {
                    var b = parseFloat(whichtr.find('.igst').val()) / 100;
                } else if (typeof whichtr.find('.cgst').val() !== "undefined") {
                    var b = parseFloat(whichtr.find('.cgst').val()) / 100;
                } else if (typeof whichtr.find('.sgst').val() !== "undefined") {
                    var b = parseFloat(whichtr.find('.sgst').val()) / 100;
                } else if (typeof whichtr.find('.cess').val() !== "undefined") {
                    var b = parseFloat(whichtr.find('.cess').val()) / 100;
                }
                if (discount_percent > 0) {
                    var discount = parseFloat(discount_percent / 100 * a);
                } else {
                    var discount = 0;
                }
                var subtotalamount = parseFloat(a * qty);
                var only_subtotal = parseFloat(((a * qty) - discount) * qty);
                var only_min = parseFloat(min_price * qty);
                if (only_subtotal < only_min) {
                    var max_discount = 100 * parseFloat((subtotalamount - only_min)) / subtotalamount;
                    whichtr.find('.discount').val(max_discount.toFixed(2));
                    discount = (max_discount > 0) ? parseFloat(discount_percent / 100 * a) : 0;
                }
                amount = (a + (b * (a - discount)) - discount) * qty;
                whichtr.find('.product_price').val(a.toFixed(2));
                whichtr.find('.product_subtotal').text(amount.toFixed(2));
                priceCalc(whichtr.find('.product_price').attr('data-sku-id'), whichtr.find('.product_price').attr(
                    'data-type'));
            });
        }
        function totalCalcuationAfterChange() {
            let total_quantity = 0;
            let total_amount = 0;
            $.each($('.quantity'), function(index, value) {
                let amount = $(this).val();
                total_quantity += parseFloat(amount);
            });
            $.each($('.product_subtotal'), function(index, value) {
                let amount = $(this).text();
                total_amount += parseFloat(amount);
            });
            $('.total_price').text(total_amount);
            $('.payable_price').text(total_amount);
            $('.total_amount').val(total_amount);
            let vat = parseFloat($('.total_vat').val());
            let discount = parseFloat($('.total_discount').val());
            let ProductTaxTotal = parseFloat($('.product_tax_input').val());
            let calculated_discount = 0;
            let calculated_vat = 0;
            if (vat > 0) {
                calculated_vat = (total_amount * vat) / 100;
            }
            if (discount > 0) {
                calculated_discount = (total_amount * discount) / 100;
            }
            let final_amount = (total_amount + calculated_vat) - calculated_discount;
            $('.total_amount_tr').text((final_amount).toFixed(2));
            $('.total_amount_display').text((final_amount).toFixed(2));
            $('.amount').val(total_amount);
            let total_tax = 0;
            $.each($('.tax'), function(index, value) {
                let amount = $(this).val();
                if (amount)
                    total_tax += parseInt(amount);
            });
            if (total_tax > 0 || !isNaN(total_tax)) {
                $('.total_tax').text(total_tax);
            } else {
                total_tax = $('.total_tax').text();
                $('.total_tax').text(total_tax);
            }
            if (total_quantity > 0 || !isNaN(total_quantity)) {
                $('.total_quantity').text(total_quantity);
                $('.total_quantity').val(total_quantity);
            } else {
                $('.total_quantity').text(0);
                $('.total_quantity').val(0);
            }
            productTax();
        }
        function addTotalDiscount() {
            disableAll();
            addTotalVat();
            enableAll();
        }
        function addShippingCharge() {
            disableAll();
            addTotalVat();
            enableAll();
        }
        function getPosViewUpdate(el, value) {
            $('#pre-loader').removeClass('d-none');
            $.post('{{ route('get_change_pos_view') }}', {
                _token: '{{ csrf_token() }}',
                pos_view: value
            }, function(data) {
                $('#pre-loader').addClass('d-none');
                if (data == 1) {
                    location.reload();
                    toastr.success("Pos view has been changed successfully");
                } else {
                    toastr.error("Pos view has been failed to change");
                }
            });
        }
        function printPostInvoice(divName) {
            var preview = window.open("", "MsgWindow", "width=400,height=800");
            preview.document.getElementsByTagName('body')[0].innerHTML = '';
            var printContents = document.getElementById(divName).innerHTML;
            preview.document.write(printContents);
        }
        // POS CALCULATION
        function productTax() {
            let product_tax = 0;
            let product_dis = 0;
            if (parseInt($('#enable_gst').val()) == 0) {
                $.each($('.tax'), function(index, value) {
                    let amount = $(this).attr('net-sub-total');
                    product_tax += parseFloat(amount);
                });
            } else {
                if ($('.gst_group').find(":selected").val() == "igst") {
                    $.each($('.igst'), function(index, value) {
                        let amount = $(this).attr('net-sub-total');
                        product_tax += parseFloat(amount);
                    });
                } else if ($('.gst_group').find(":selected").val() == "cgst") {
                    $.each($('.cgst'), function(index, value) {
                        let amount = $(this).attr('net-sub-total');
                        product_tax += parseFloat(amount);
                    });
                } else if ($('.gst_group').find(":selected").val() == "sgst") {
                    $.each($('.sgst'), function(index, value) {
                        let amount = $(this).attr('net-sub-total');
                        product_tax += parseFloat(amount);
                    });
                } else {
                    $.each($('.cess'), function(index, value) {
                        let amount = $(this).attr('net-sub-total');
                        product_tax += parseFloat(amount);
                    });
                }
            }
            if (product_tax >= 0) {
                $('.product_tax_input').val(product_tax.toFixed(2));
            } else {
                $('.product_tax_input').val(0);
            }
            $.each($('.discount'), function(index, value) {
                let Disamount = $(this).attr('net-sub-total');
                product_dis += parseFloat(Disamount);
            });
            if (product_dis >= 0) {
                $('.product_discount').val(product_dis.toFixed(2));
            } else {
                $('.product_discount').val(0);
            }
        }
        function calcutionTaxDiscount(tr) {
            if (parseInt($('#enable_gst').val()) == 0) {
                let taxParcentage = parseFloat(tr.find('.tax').val());
                let productPrice = parseFloat(tr.find('.product_price').attr("data-product-price"));
                let discount = parseFloat(tr.find('.discount ').val());
                let qty = parseInt(tr.find('.quantity').val());
                let discount_price = (productPrice * discount) / 100;
                let productTax = (productPrice - discount_price) * taxParcentage / 100;
                let netSubTotal = ((productPrice - discount_price) * qty) * taxParcentage / 100;
                tr.find('.tax').attr('net-sub-total', netSubTotal)
                tr.find('.product_tax_amount').val(productTax.toFixed(2))
                if (discount > 0) {
                    let netDisTotal = discount_price * qty;
                    tr.find('.discount').attr('net-sub-total', netDisTotal)
                } else {
                    tr.find('.discount').attr('net-sub-total', 0);
                }
            } else {
                if ($('.gst_group').find(":selected").val() == "igst") {
                    let taxParcentage = parseFloat(tr.find('.igst').val());
                    let productPrice = parseFloat(tr.find('.product_price').attr("data-product-price"));
                    let discount = parseFloat(tr.find('.discount ').val());
                    let qty = parseInt(tr.find('.quantity').val());
                    let productTax = productPrice * taxParcentage / 100;
                    let discount_price = (productPrice * discount) / 100;
                    let netSubTotal = ((productPrice - discount_price) * qty) * taxParcentage / 100;
                    tr.find('.igst').attr('net-sub-total', netSubTotal)
                    tr.find('.product_tax_amount').val(productTax.toFixed(2))
                    if (discount > 0) {
                        let netDisTotal = discount_price * qty;
                        tr.find('.discount').attr('net-sub-total', netDisTotal)
                    } else {
                        tr.find('.discount').attr('net-sub-total', 0);
                    }
                }
                if ($('.gst_group').find(":selected").val() == "cgst") {
                    let taxParcentage = parseFloat(tr.find('.cgst').val());
                    let productPrice = parseFloat(tr.find('.product_price').attr("data-product-price"));
                    let discount = parseFloat(tr.find('.discount ').val());
                    let qty = parseInt(tr.find('.quantity').val());
                    let productTax = productPrice * taxParcentage / 100;
                    let discount_price = (productPrice * discount) / 100;
                    let netSubTotal = ((productPrice - discount_price) * qty) * taxParcentage / 100;
                    tr.find('.cgst').attr('net-sub-total', netSubTotal)
                    tr.find('.product_tax_amount').val(productTax.toFixed(2))
                    if (discount > 0) {
                        let netDisTotal = discount_price * qty;
                        tr.find('.discount').attr('net-sub-total', netDisTotal)
                    } else {
                        tr.find('.discount').attr('net-sub-total', 0);
                    }
                }
                if ($('.gst_group').find(":selected").val() == "sgst") {
                    let taxParcentage = parseFloat(tr.find('.sgst').val());
                    let productPrice = parseFloat(tr.find('.product_price').attr("data-product-price"));
                    let discount = parseFloat(tr.find('.discount ').val());
                    let qty = parseInt(tr.find('.quantity').val());
                    let productTax = productPrice * taxParcentage / 100;
                    let discount_price = (productPrice * discount) / 100;
                    let netSubTotal = ((productPrice - discount_price) * qty) * taxParcentage / 100;
                    tr.find('.sgst').attr('net-sub-total', netSubTotal)
                    tr.find('.product_tax_amount').val(productTax.toFixed(2))
                    if (discount > 0) {
                        let netDisTotal = discount_price * qty;
                        tr.find('.discount').attr('net-sub-total', netDisTotal)
                    } else {
                        tr.find('.discount').attr('net-sub-total', 0);
                    }
                }
                if ($('.gst_group').find(":selected").val() == "cess") {
                    let taxParcentage = parseFloat(tr.find('.cess').val());
                    let productPrice = parseFloat(tr.find('.product_price').attr("data-product-price"));
                    let discount = parseFloat(tr.find('.discount ').val());
                    let qty = parseInt(tr.find('.quantity').val());
                    let productTax = productPrice * taxParcentage / 100;
                    let discount_price = (productPrice * discount) / 100;
                    let netSubTotal = ((productPrice - discount_price) * qty) * taxParcentage / 100;
                    tr.find('.cess').attr('net-sub-total', netSubTotal)
                    tr.find('.product_tax_amount').val(productTax.toFixed(2))
                    if (discount > 0) {
                        let netDisTotal = discount_price * qty;
                        tr.find('.discount').attr('net-sub-total', netDisTotal)
                    } else {
                        tr.find('.discount').attr('net-sub-total', 0);
                    }
                }
            }
        }
        function addDiscount(id, type) {
            setPricewithTax();
        }
        function productDiscount() {
            let product_discounts = 0;
            $.each($('.discount'), function(index, value) {
                let discountPercentage = $(this).val();
                let tr = $(this).parent().parent();
                let qty = parseInt(tr.find('.quantity').val());
                let product_price = parseFloat(tr.find('.product_price').attr("data-product-price"));
                let discount_amount = product_price * discountPercentage / 100;
                let totalDiscount = discount_amount * qty;
                product_discounts += parseInt(totalDiscount);
                calcutionTaxDiscount(tr);
                productTax(1, 2)
            });
        }
        //for total price calculation
        function priceCalc(id, type) {
            disableAll();
            let price = $(".product_price_" + type + id).val();
            let min_sell_qty = parseInt($("#min_sell_qty").val());
            let taxRate = 0;
            let quantity = $('.quantity_' + type + id).val();
            let totalAmountProduct = (price / (100 + taxRate)) * taxRate
            let productTaxValue = 0;
            let min_price = $(".product_min_price_" + type + id).val();
            let discountProduct = $('.discount_' + type + id).val();

            if (parseInt($('#enable_gst').val()) == 0) {
                taxRate = parseFloat($('.tax_' + type + id).val());
            } else {
                if ($('.gst_group').find(":selected").val() == "igst") {
                    taxRate = parseFloat($('.igst_' + type + id).val());
                }
                if ($('.gst_group').find(":selected").val() == "cgst") {
                    taxRate = parseFloat($('.cgst_' + type + id).val());
                }
                if ($('.gst_group').find(":selected").val() == "sgst") {
                    taxRate = parseFloat($('.sgst_' + type + id).val());
                }
                if ($('.gst_group').find(":selected").val() == "cess") {
                    taxRate = parseFloat($('.cess_' + type + id).val());
                }
            }
            if (taxRate > 0) {
                let totalAmountProduct = (price / (100 + taxRate)) * taxRate;
                if (parseInt($('#enable_gst').val()) == 0) {
                    $('.tax_' + type + id).attr('net-sub-total', totalAmountProduct);
                    productTaxValue = $('.tax_' + type + id).attr('net-sub-total');
                } else {
                    if ($('.gst_group').find(":selected").val() == "igst") {
                        $('.igst_' + type + id).attr('net-sub-total', totalAmountProduct);
                        productTaxValue = $('.igst_' + type + id).attr('net-sub-total');
                    }
                    if ($('.gst_group').find(":selected").val() == "cgst") {
                        $('.cgst_' + type + id).attr('net-sub-total', totalAmountProduct);
                        productTaxValue = $('.cgst_' + type + id).attr('net-sub-total');
                    }
                    if ($('.gst_group').find(":selected").val() == "sgst") {
                        $('.sgst_' + type + id).attr('net-sub-total', totalAmountProduct);
                        productTaxValue = $('.sgst_' + type + id).attr('net-sub-total');
                    }
                    if ($('.gst_group').find(":selected").val() == "cess") {
                        $('.cess_' + type + id).attr('net-sub-total', totalAmountProduct);
                        productTaxValue = $('.cess_' + type + id).attr('net-sub-total');
                    }
                }
            }
            let sub_total = 0;
            let productDiscountAmount = 0;
            if (parseFloat(price) < parseFloat(min_price)) {
                $(".product_price_" + type + id).addClass('red_border');
                $(".min_sell_qty_" + type + id).val(1);
            } else {
                $(".product_price_" + type + id).removeClass('red_border');
                $(".min_sell_qty_" + type + id).val(2);
            }
            if (discountProduct > 0) {
                let basePrice = price;
                let discountAmountCal = (basePrice / 100) * discountProduct;
                if (taxRate > 0) {
                    let productNewTax = (basePrice - discountAmountCal) * taxRate / 100;
                    let pricseAfterDiscount = basePrice - discountAmountCal + productNewTax;
                    sub_total = pricseAfterDiscount * quantity;
                } else {
                    sub_total = (basePrice - discountAmountCal) * quantity;
                }
            } else {
                sub_total = (price + productTaxValue) * quantity;
            }
            $('.product_subtotal_sku'+id).text(sub_total);
            let total_quantity = 0;
            $.each($('.quantity'), function(index, value) {
                let amount = $(this).val();
                total_quantity += parseInt(amount);
            });
            if (total_quantity > 0 || !isNaN(total_quantity)) {
                $('.total_quantity').text(total_quantity);
                $('.total_quantity').val(total_quantity);
            } else {
                total_quantity = $('.total_quantity').text();
                $('.total_quantity').text(total_quantity);
                $('.total_quantity').val(total_quantity);
            }
            let total_amount = 0;
            let discount = parseFloat($('.total_discount').val());
            let vat = parseFloat($('.total_vat').val());
            let ProductTaxTotal = parseFloat($('.product_tax_input').val());
            $.each($('.product_subtotal'), function(index, value) {
                let amount = $(this).text();
                total_amount += parseFloat(amount);
            });
            $('.amount').val(total_amount);
            let calculated_discount = 0;
            let calculated_vat = 0;
            if (vat > 0) {
                calculated_vat = ((total_amount - discount) / 100) * vat;
            }
            if (discount > 0) {
                calculated_discount = discount;
            }
            let final_amount = (total_amount + calculated_vat) - calculated_discount;
            $('.payable_price').text((final_amount).toFixed(2));
            $('.total_amount').val((final_amount).toFixed(2));
            $('.total_amount_tr').text((final_amount).toFixed(2));
            $('.total_amount_display').text((final_amount).toFixed(2));
            let tr = $('.quantity_' + type + id).parent().parent();
            calcutionTaxDiscount(tr);
            productTax()
            enableAll();
        }
        //quantity increase and decrease after add
        function addQuantity(id, type) {
            let datatype = $('.quantity_' + type + id).data('type');
            let price = $(".product_price_" + type + id).val();
            let producttax = 0;
            let quantity = $('.quantity_' + type + id).val();
            if (quantity === 'undefined' || quantity === '') {
                return false;
            }
            let house = $('.house').val();
            let discountProduct = $('.discount_' + type + id).val();
            let sub_total = 0;
            let taxRate = 0;
            var whichtr = $(this).closest("tr");
            if (typeof whichtr.find('.tax').val() !== "undefined") {
                taxRate = parseFloat($('.tax_' + type + id).val());
                producttax = $('.tax_' + type + id).val();
            } else if (typeof whichtr.find('.igst').val() !== "undefined") {
                taxRate = parseFloat($('.igst_' + type + id).val());
                producttax = $('.igst_' + type + id).val();
            } else if (typeof whichtr.find('.cgst').val() !== "undefined") {
                taxRate = parseFloat($('.cgst_' + type + id).val());
                producttax = $('.cgst_' + type + id).val();
            } else if (typeof whichtr.find('.sgst').val() !== "undefined") {
                taxRate = parseFloat($('.sgst_' + type + id).val());
                producttax = $('.sgst_' + type + id).val();
            } else if (typeof whichtr.find('.cess').val() !== "undefined") {
                taxRate = parseFloat($('.cess_' + type + id).val());
                producttax = $('.cess_' + type + id).val();
            }
            $('#pre-loader').removeClass('d-none');
            $.ajax({
                method: 'POST',
                url: "{{ route('check.quantity') }}",
                data: {
                    id: id,
                    type: datatype,
                    house: house,
                    quantity: quantity,
                    _token: '{{ csrf_token() }}',
                },
                beforeSend: function() {
                    disableAll();
                },
                success: function(result) {
                    setPricewithTax()
                    $('#pre-loader').addClass('d-none');
                }
            })
        }
        //for tax amount calucation
        function addTotalVat() {
            disableAll();
            let vat = parseFloat($('.total_vat').val());
            let product_tax_total = parseFloat($('.product_tax_input').val());
            let discount = parseFloat($('.total_discount').val());
            let total_amount = 0;
            $.each($('.product_subtotal'), function(index, value) {
                var whichtr = $(this).closest("tr");
                let amount = parseFloat(whichtr.find('.product_subtotal').text());
                total_amount += amount;
            });
            $('.amount').val(total_amount);
            let calculated_discount = 0;
            let calculated_vat = 0;
            if (vat > 0) {
                if (vat > 0) {
                    calculated_vat = ((total_amount - discount) * vat) / 100;
                }
            }
            if (discount > 0) {
                calculated_discount = discount;
            }
            let shipping_charge = parseFloat($('.shipping_charge').val());
            let final_amount = (total_amount + calculated_vat + shipping_charge) - calculated_discount;
            $('.payable_price').text((final_amount).toFixed(2));
            $('.other_product_tax_input').val((calculated_vat).toFixed(2));
            $('.total_amount').val((final_amount).toFixed(2));
            $('.total_amount_tr').text((final_amount).toFixed(2));
            $('.total_amount_display').text((final_amount).toFixed(2));
            enableAll();
        }
        // for change branch or showroom with clear session product data
        $(document).on('change', '.select_showroom', function() {
            window.location = '#';
            let id = $(this).val();
            $.ajax({
                method: "POST",
                url: "#",
                data: {
                    id: id,
                    _token: "{{ csrf_token() }}",
                },
                success: function(result) {
                    window.location.reload();
                }
            })
        });
    @if (session()->has('sale'))
        $(document).ready(function() {
            printPostInvoice('printablePos');
        });
        {{ session()->forget('sale') }}
    @endif
</script>
</body>
</html>
