<?php
namespace Modules\POS\Services;

use App\Models\User;
use Brian2694\Toastr\Facades\Toastr;
use Modules\POS\Entities\Payment;
use Modules\POS\Entities\ProductHistory;
use Modules\POS\Entities\ProductItemDetail;
use Modules\POS\Entities\Sale;
use Modules\POS\Repositories\PosRepository;
use Modules\Product\Repositories\ProductRepository;
use Modules\Seller\Entities\SellerProduct;
use Modules\Seller\Entities\SellerProductSKU;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\POS\Entities\PosConfiguration;
use App\Traits\PickupLocation;
// use Modules\Shipping\Entities\PickupLocation;

class PosService{
    
    protected $posRepository,$productRepository;
    public function __construct(PosRepository $posRepository, ProductRepository $productRepository){
        $this->posRepository = $posRepository;
        $this->productRepository = $productRepository;
    }
    public function allbyPaginate()
    {
        return $this->posRepository->allbyPaginate();
    }
    public function loadProduct($data)
    {
        return $this->posRepository->loadProduct($data);
    }
    public function storeSkuProduct($id, $seller_id, $customer)
    {
        $lp = 0;
        $productSku = $this->productRepository->findSku($id, $seller_id);
        $posConfig = PosConfiguration::first();
        $user = User::find($customer);
        $seller = $productSku->product->seller;
        $address = $user->customerShippingAddress;
        $tax = 0;
        if ($productSku) {
            $price = $productSku->selling_price;
            $skus = session()->get('sku');
            $carts = session()->get('carts');
            $sku[$productSku->id] = $productSku->id;
                session()->put('sku', $sku);
            $type = $productSku->id . ",'sku'";
            if ($productSku->mainProduct->gst_group_id != null ) {
                if(file_exists(base_path().'/Modules/GST/') && $productSku->mainProduct->is_physical == 1){
                    if($address != null && app('gst_config')['enable_gst'] == "gst"){
                        if($seller->role->type == 'superadmin'){
                            $state_id = PickupLocation::pickupPointAddress($seller->id)->state_id;
                        }else{
                            $state_id = $seller->SellerBusinessInformation->business_state;
                        }
                        if($state_id == $address->state){
                            if($productSku->mainProduct->gstGroup){
                                $sameStateTaxesGroup = json_decode($productSku->mainProduct->gstGroup->same_state_gst);
                                $sameStateTaxesGroup = (array) $sameStateTaxesGroup;

                                foreach($sameStateTaxesGroup as $key => $sameStateTax){
                                    $gstAmount = ($productSku->selling_price * $sameStateTax) / 100;
                                    $tax += $gstAmount;
                                }
                            }else{
                                $sameStateTaxes = \Modules\GST\Entities\GstTax::whereIn('id', app('gst_config')['within_a_single_state'])->get();
                                foreach($sameStateTaxes as $key => $sameStateTax){
                                    $gstAmount = ($productSku->selling_price * $sameStateTax->tax_percentage) / 100;
                                    $tax += $gstAmount;
                                }
                            }
                        }
                        else{
                            if($productSku->mainProduct->gstGroup){
                                $diffStateTaxesGroup = json_decode($productSku->mainProduct->gstGroup->outsite_state_gst);
                                $diffStateTaxesGroup = (array) $diffStateTaxesGroup;
                                foreach ($diffStateTaxesGroup as $key => $diffStateTax){
                                    $gstAmount = ($productSku->selling_price * $diffStateTax) / 100;
                                    $tax += $gstAmount;
                                }
                            }else{
                                $diffStateTaxes = \Modules\GST\Entities\GstTax::whereIn('id', app('gst_config')['between_two_different_states_or_a_state_and_a_Union_Territory'])->get();
                                foreach ($diffStateTaxes as $key => $diffStateTax){
                                    $gstAmount = ($productSku->selling_price * $diffStateTax->tax_percentage) / 100;
                                    $tax += $gstAmount;
                                }
                            }
                        }
                    }elseif(app('gst_config')['enable_gst'] == "flat_tax"){
                        if($productSku->mainProduct->gstGroup){
                            $flatTaxGroup = json_decode($productSku->mainProduct->gstGroup->same_state_gst);
                            $flatTaxGroup = (array) $flatTaxGroup;
                            foreach($flatTaxGroup as $sameStateTax){
                                $gstAmount = $productSku->selling_price * $sameStateTax / 100;
                                $tax += $gstAmount;
                            }
                        }else{
                            $flatTax = \Modules\GST\Entities\GstTax::where('id', app('gst_config')['flat_tax_id'])->first();
                            $gstAmount = ($productSku->selling_price * $flatTax->tax_percentage) / 100;
                            $tax += $gstAmount;
                        } 
                    }elseif(app('gst_config')['enable_gst'] == "only_tax"){
                        if($productSku->mainProduct->gsttax){
                            $gstAmount = $productSku->selling_price * $productSku->mainProduct->gsttax->tax_percentage / 100;
                            $tax += $gstAmount;
                        }
                    }
                }else{
                    if($productSku->mainProduct->gstGroup){
                        $sameStateTaxesGroup = json_decode($productSku->mainProduct->gstGroup->same_state_gst);
                        $sameStateTaxesGroup = (array) $sameStateTaxesGroup;
                        foreach ($sameStateTaxesGroup as $key => $sameStateTax){
                            $gstAmount = ($productSku->selling_price * $sameStateTax) / 100;
                            $tax += $gstAmount;
                        }
                    }else{
                        $sameStateTaxes = \Modules\GST\Entities\GstTax::whereIn('id', app('gst_config')['within_a_single_state'])->get();
                        foreach ($sameStateTaxes as $key => $sameStateTax){
                            $gstAmount = ($productSku->selling_price * $sameStateTax->tax_percentage) / 100;
                            $tax += $gstAmount;
                        }
                    }
                }
                // $igstVal = $productSku->mainProduct->gst_tax_group->igst;
                // $cgstVal = $productSku->mainProduct->gst_tax_group->cgst;
                // $sgstVal = $productSku->mainProduct->gst_tax_group->sgst;
                // $cessVal = $productSku->mainProduct->gst_tax_group->cess;
                // $igstProduct = ($productSku->min_sell_price * $productSku->mainProduct->gst_tax_group->igst) / 100;
                // $cgstProduct = ($productSku->min_sell_price * $productSku->mainProduct->gst_tax_group->cgst) / 100;
                // $sgstProduct = ($productSku->min_sell_price * $productSku->mainProduct->gst_tax_group->sgst) / 100;
                // $cessProduct = ($productSku->min_sell_price * $productSku->mainProduct->gst_tax_group->cess) / 100;
                // $taxrow = '<input type="hidden" name="product_igst[]" net-sub-total="'.$igstProduct.'" value="' . $productSku->mainProduct->gst_tax_group->igst . '"class="primary_input_field igst igst_sku' . $productSku->id . '">
                //             <input type="hidden" name="product_cgst[]" net-sub-total="'.$cgstProduct.'" value="' . $productSku->mainProduct->gst_tax_group->cgst . '" class="primary_input_field cgst cgst_sku' . $productSku->id . '">
                //             <input type="hidden" name="product_sgst[]" net-sub-total="'.$sgstProduct.'" value="' . $productSku->mainProduct->gst_tax_group->sgst . '" class="primary_input_field sgst sgst_sku' . $productSku->id . '">
                //             <input type="hidden" name="product_cess[]" net-sub-total="'.$cessProduct.'" value="' . $productSku->mainProduct->gst_tax_group->cess . '" class="primary_input_field cess cess_sku' . $productSku->id . '">';
            }else{
                $tax = ($productSku->selling_price * $productSku->mainProduct->tax) / 100;
                // $taxrow = '<input type="hidden" name="product_tax[]" net-sub-total="'.$taxProduct.'" value="' . $productSku->mainProduct->tax . '" onkeyup="addTax(' . $type . ')" class="primary_input_field2 tax tax_sku' . $productSku->id . '">';
            }
            // dd($tax);
            $name = substr($productSku->product->product_name, 0, 40);
            $output = '';
            $output .= '<tr>
                            <input class="product_min_price product_min_price_sku'.$productSku->id.'" type="hidden" value="' . $productSku->selling_price . '">
                            <th class="nowrap" data-toggle="tooltip" data-placement="top" title="'.$lp.'"><input type="hidden" name="product_id[]" value="' . $productSku->id . '" class="primary_input_field sku_id' . $productSku->id . '">' . $name . '</th>';
                
                if($posConfig->sku==1){
                    $output .= '<td>'.$productSku->id.'</td>';
                }
                $output .= '<td><input class="min_sell_qty_sku'.$productSku->id.'" type="hidden" value="0" name="min_sell_qty[]">
                                <input type="number" name="quantity[]" value="1" placeholder="-" onkeyup="addQuantity(' . $type . ')" class="primary_input_field2 quantity quantity_sku' . $productSku->id . '">
                            </td>
                            <td><input name="product_price[]" step="0.01" data-type="sku" data-sku-id="'.$productSku->id.'" data-product-price="' . $productSku->selling_price . '" min="' . $productSku->selling_price . '" onkeyup="priceCalc(' . $type . ')" class="primary_input_field2 product_price product_price_sku' . $productSku->id . '" type="number"
                            value="' . $price . '"></td>';
                
                if($posConfig->gst==1){
                    $output .= '<td><input name="product_tax_amount[]" step="0.001" data-type="sku" data-sku-id="'.$productSku->id.'" class="primary_input_field2 product_tax_amount product_tax_amount_sku' . $productSku->id . '" type="number" readonly value="0"></td>';
                }   

                $output .= '<td>
                                <input type="number" name="product_discount[]" value="0" onkeyup="addDiscount(' . $type . ')" class="primary_input_field2 discount discount_sku' . $productSku->id . '">
                            </td>
                            '.$tax.'
                            <td class="product_subtotal product_subtotal_sku' . $productSku->id . '">' . str_replace(',','',number_format($price ,2)) . '</td>
                            <td>
                                <a data-id="' . $productSku->id . '" class="delete_product primary-btn" href="javascript:void(0)">
                                    <i class="fas fa-trash-alt required_mark2 f_s_13"></i>
                                </a>
                            </td>
                        </tr>';
            if ($productSku->mainProduct->tax_type != null) {
                $cart['sku-' . $productSku->id] = [
                    'product' => $name,
                    'sku' => $productSku->id,
                    'sub_total' => str_replace(',','',number_format($price,2)),
                    'price' => str_replace(',','',number_format($price,2)),
                    'only_price' => str_replace(',','',number_format($productSku->selling_price,2)),
                    'selling_price' => str_replace(',','',number_format($price,2)),
                    'min_selling_price' => $productSku->selling_price,
                    'type' => 'sku',
                    'product_sku_id' => $productSku->id,
                    'quantity' => 1,
                    'taxProduct' => str_replace(',','',number_format($tax,2)),
                    'taxSku' => $productSku->tax,
                ];
            }else{
                $cart['sku-' . $productSku->id] = [
                    'product' => $name,
                    'sku' => $productSku->id,
                    'sub_total' => str_replace(',','',number_format($price,2)),
                    'price' => str_replace(',','',number_format($price,2)),
                    'only_price' => str_replace(',','',number_format($productSku->selling_price,2)),
                    'selling_price' => str_replace(',','',number_format($price,2)),
                    'min_selling_price' => $productSku->selling_price,
                    'type' => 'sku',
                    'product_sku_id' => $productSku->id,
                    'quantity' => 1,
                    'taxSku' => $productSku->tax,
                ];
            }
            if (!empty($carts)) {
                session()->put('carts', $carts + $cart);
            } else
                session()->put('carts', $cart);
            return $output;
        }
        return false;
    }
    public function findSellerProduct($id)
    {
        return SellerProduct::with('skus.sku')->find($id);
    }

    public function create(array $data)
    {
        $error =1;
        if (!empty($data['totall_bill']) && $data['draft'] == null) {
            $payable_amount = $data['totall_bill'];
            $t_amount = $data['total_amount'];
        }
        elseif (!empty($data['totall_bill']) && $data['draft'] != null) {
            $payable_amount = $data['total_amount'];
            $t_amount = $data['amounts'];
        }
        else{
            $payable_amount = $data['total_amount'];
            $t_amount = $data['amounts'];
        }
        $tax = explode('-', $data['vat']);
        $user_type = explode('-', $data['customer_id']);
        $last_id = Sale::orderBy('id', 'DESC')->first();
        if (!empty($last_id)){
            $last_invoice_no = $last_id->id + 1;
            $invoice_no = 'INV-'.date('ym').$last_invoice_no;
        }else{
            $invoice_no = 'INV-'.date('ym').'1';
        }
        $pos = Sale::create([
            'company_name' => app('general_setting')->company_name,
            'customer_id' => $user_type[0] == "customer" ? $user_type[1] : null,
            'date' => Carbon::now(),
            'user_id' => Auth::id(),
            'total_quantity' => $data['total_quantity'],
            'total_tax' => $tax[0],
            'tax_id' => $tax[1],
            'total_discount' => $data['total_discount'],
            'payable_amount' => $payable_amount,
            'amount' => $t_amount,
            'notes' => $data['note'],
            'shipping_charge' => $data['shipping_charge'],
            'is_draft' => $data['draft'] != null ? 1 : 0,
            'invoice_no' => $invoice_no,
        ]);

        if (!empty($data['gst_group'])) {
            $gst_group = $data['gst_group'];
        }else{
            $gst_group = null;
        }
        if (!empty($data['product_id'])) {
            $total_amount = 0;
            foreach ($data['product_id'] as $key => $id) {
                $stock = SellerProductSKU::where('id', $id)->first();
                if ($stock){
                    $stock_availability = $stock->product_stock == 0 ? 'In stock' : $stock->product_stock;
                    if ($stock_availability >= $data['quantity'][$key] || $stock_availability == 'In Stock')
                    {
                        $sub_total = ( $data['product_price'][$key] - ($data['product_price'][$key] * $data['product_discount'][$key]/100)) * $data['quantity'][$key];
                        $price = $data['product_price'][$key];
                        $sub_total = (($price * $data['quantity'][$key]));
                        $total_amount +=$sub_total;
                        $product = new ProductItemDetail([
                            'product_sku_id' => $data['product_id'][$key],
                            'price' => $price,
                            'tax' => 0,
                            'gst_group' => $gst_group,
                            'igst' => ($gst_group != null) ? $data['product_igst'][$key] : 0,
                            'cgst' => ($gst_group != null) ? $data['product_cgst'][$key] : 0,
                            'sgst' => ($gst_group != null) ? $data['product_sgst'][$key] : 0,
                            'cess' => ($gst_group != null) ? $data['product_cess'][$key] : 0,
                            'cogs' => $stock->selling_price,
                            'discount' => $data['product_discount'][$key],
                            'quantity' => $data['quantity'][$key],
                            'sub_total' => $sub_total,
                            'productable_id' => $stock->product_id,
                            'productable_type' => SellerProductSKU::class,
                            'itemable_id' => $pos->id,
                            'itemable_type' => SellerProduct::class,
                        ]);
                        $product->save();
                        if ($data['draft'] == null) {
                            $productHistory = new ProductHistory([
                                'company_name' => app('general_setting')->company_name,
                                'type' => 'pos',
                                'date' => Carbon::now()->toDateString(),
                                'in_out' => $data['quantity'][$key],
                                'product_sku_id' => $data['product_id'][$key],
                                'itemable_id' => $stock->product_id,
                                'itemable_type' => SellerProductSKU::class,
                                'branchable_id' => $pos->saleable_id,
                                'branchable_type' => $pos->saleable_type,
                                'houseable_id' => $pos->id,
                                'houseable_type' => Sale::class,
                            ]);
                            $productHistory->save();
                            if ($stock->product_stock > 0){
                                $stock->update([
                                    'product_stock' => $stock->product_stock - $data['quantity'][$key]
                                ]);
                            }
                        }
                    }
                    else{
                        return $error;
                    }
                }
                else{
                    return $error;
                }
            }
            $pos->save();
        }
        $initial_payment = 0;
        if (!empty($data['payment_method'])) {
            foreach ($data['payment_method'] as $key => $payment_method) {
                $payment_methods = explode('-', $payment_method);
                $sale_payment = new Payment([
                    'payable_id' => $pos->id,
                    'payment_method' => $payment_methods[0],
                    'initial_payment' => ($initial_payment == 1) ? 1 : 0,
                    'has_discount_on_payment' => 0,
                    'payable_type' => Sale::class,
                    'amount' => $data['amount'][$key],
                    'amount_after_discount' => 0,
                    'date' => Carbon::now(),
                    'advance_amount' => 0,
                    'account_id' => 0,
                    'bank_name' => $data['bank_name'][$key],
                    'branch' => $data['branch'][$key],
                    'account_no' => $data['account_no'][$key],
                    'account_owner' => $data['account_owner'][$key],
                ]);
                $sale_payment->save();
            }
        }
        return $pos;
    }

    public function all()
    {
        return Sale::with('user', 'customer', 'agentuser', 'items')
            ->where('type', 2)
            ->where('company_name', app('general_setting')->company_name)
            ->latest()
            ->get();
    }

    public function find($id)
    {
        return Sale::with('items','items.product','customer','user','payments')->findOrFail($id);
    }

    public function customerDues($customer_id,$sale_id){
        return $this->posRepository->customerDues($customer_id,$sale_id);
    }

    public function totalSalesList()
    {
        return $this->posRepository->totalSalesList();
    }

    public function destroyPosSales($id){
        return $this->posRepository->destroyPosSales($id);
    }

    public function allBankAccounts()
    {
        return $this->posRepository->allBankAccounts();
    }

    public function getByAjax($search){
        return $this->posRepository->getByAjax($search);
    }

    public function storeSkuSale($id)
    {
        $productSku = $this->productRepository->findSkus($id);
        $type = $productSku->id . ",'sku'";
        $skus = session()->get('sku');
        $sku[$productSku->id] = $productSku->id;
        if (!empty($skus) && count($skus) > 0) {
            if (array_key_exists($productSku->id, $skus)) {
                return 1;
            }
            session()->put('sku', $sku + $skus);
        } else {
            session()->put('sku', $sku);
        }
        $sub_total = ($productSku->selling_price);
        if ($productSku->mainProduct->tax_type == null) {
            $igstProduct = ($productSku->min_sell_price * $productSku->mainProduct->gst_tax_group->igst) / 100;
            $cgstProduct = ($productSku->min_sell_price * $productSku->mainProduct->gst_tax_group->cgst) / 100;
            $sgstProduct = ($productSku->min_sell_price * $productSku->mainProduct->gst_tax_group->sgst) / 100;
            $cessProduct = ($productSku->min_sell_price * $productSku->mainProduct->gst_tax_group->cess) / 100;
            $taxrow = '<input type="hidden" name="product_igst[]" net-sub-total="'.$igstProduct.'" value="' . $productSku->mainProduct->gst_tax_group->igst . '"class="primary_input_field igst igst_sku' . $productSku->id . '">
                        <input type="hidden" name="product_cgst[]" net-sub-total="'.$cgstProduct.'" value="' . $productSku->mainProduct->gst_tax_group->cgst . '" class="primary_input_field cgst cgst_sku' . $productSku->id . '">
                        <input type="hidden" name="product_sgst[]" net-sub-total="'.$sgstProduct.'" value="' . $productSku->mainProduct->gst_tax_group->sgst . '" class="primary_input_field sgst sgst_sku' . $productSku->id . '">
                        <input type="hidden" name="product_cess[]" net-sub-total="'.$cessProduct.'" value="' . $productSku->mainProduct->gst_tax_group->cess . '" class="primary_input_field cess cess_sku' . $productSku->id . '">';
        }else{
            $taxProduct = ($productSku->selling_price * $productSku->mainProduct->tax) / 100;
            $taxrow = '<input type="text" name="product_tax[]" net-sub-total="'.$taxProduct.'" value="' . $productSku->mainProduct->tax . '" onkeyup="addTax(' . $type . ')" class="primary_input_field tax tax_sku' . $productSku->id . '">';
        }
        $name = substr($productSku->products->product_name, 0, 40);
        $output = '';
        $output .= '<tr>
            <input class="product_min_price_sku'.$productSku->id.'" type="hidden" value="' . $productSku->selling_price . '" >
            <td><input type="hidden" name="product_id[]" value="' . $productSku->id . '" class="primary_input_field sku_id' . $productSku->id . '">' . $name . '</td>
            <td class="product_sku' . $productSku->id . '">' . $productSku->id . '</td>
            <td>'.@$productSku->products->model->name.'</td>
            <td>'.@$productSku->products->brand->name.'</td>
            <input class="min_sell_qty_sku'.$productSku->id.'" type="hidden" value="0" name="min_sell_qty[]">
            <td><input name="product_price[]" min="' . $productSku->selling_price . '" onkeyup="priceCalc(' .$type . ')" class="primary_input_field product_price product_price_sku' . $productSku->id . '" type="number"
            value="' . $productSku->selling_price . '"></td>
            <td>
                <input type="number" name="product_quantity[]" value="1" onkeyup="addQuantity(' . $type . ')" class="primary_input_field quantity quantity_sku' . $productSku->id . '">
            </td>
            <td>'.$taxrow.'</td>
            <td>
                <input type="number" name="product_discount[]" value="0" onkeyup="addDiscount(' . $type . ')" class="primary_input_field discount discount_sku' . $productSku->id . '">
            </td>
            <td style="text-align:center" class="product_subtotal product_subtotal_sku' . $productSku->id . '">' . $sub_total . '</td>
            <td><a data-id="' . $productSku->id . '" data-product="' . $productSku->id . '-Normal" class="primary-btn primary-circle fix-gr-bg delete_product" href="javascript:void(0)"><i class="ti-trash"></i></a></td>
            </tr>
            ';
        return $output;
    }

    public function itemDelete($id)
    {
        $product = ProductItemDetail::find($id);
        if ($product) {
            $type = $product->itemable;
            ProductHistory::where('houseable_id', $product->itemable_id)
                ->where('houseable_type', $product->itemable_type)
                ->where('company_id', app('current_active_company')['id'])
                ->where('product_sku_id', $product->product_sku_id)
                ->delete();
            if ($type->getTable() == "quotations") {
                $product->forceDelete();
            } else {
                $product->delete();
            }
        }
        return true;
    }
    public function update(array $data, $id)
    {
        $error = 1;
        $tax = explode('-', $data['total_tax']);
        $user_type = explode('-', $data['customer_id']);
        $sale = Sale::find($id);
        $sale->update([
            'customer_id' => $user_type[0] == "customer" ? $user_type[1] : null,
            'ref_no' => $data['ref_no'],
            'date' => Carbon::parse($data['date'])->format('Y-m-d'),
            'month' => date("m",strtotime(date('Y-m-d H:i:s'))),
            'notes' => $data['notes'],
            'user_id' => Auth::id(),
            'amount' => $data['item_amount'],
            'total_quantity' => $data['total_quantity'],
            'total_discount' => $data['total_discount_amount'],
            'discount_type' => $data['discount_type'],
            'discount_amount' => $data['total_discount'],
            'payable_amount' => $data['total_amount'],
            'shipping_charge' => $data['shipping_charge'],
            'other_charge' => $data['other_charge'],
            'total_tax' => $tax[0],
            'tax_id' => $tax[1]
        ]);
        if (!empty($data['gst_group'])) {
            $gst_group = $data['gst_group'];
        }else{
            $gst_group = null;
        }
        if (!empty($data['items'])) {
            foreach ($data['items'] as $key => $cart) {
                $sku_item = SellerProductSKU::find($data['items'][$key]);
                $productsku = ProductItemDetail::where('itemable_id', $sale->id)->where('product_sku_id', $data['items'][$key])->first();
                $decreaseQuantity = $data['item_quantity'][$key] - $productsku->quantity; //req 55 - 50 = 5
                if ($sku_item->product_stock == 0) {
                    $stock_availability = 'In stock';
                }elseif ($sku_item->product_stock != 0) {
                    $stock_availability = $sku_item->product_stock >= $decreaseQuantity ? 'In stock' : 'Out of stock';
                }else {
                    $stock_availability = 'Out of stock';
                }
                if ($stock_availability == 'In stock' ) {
                    if ($productsku) {
                        if (app('general_setting')->enable_gst == 0) {
                            $calculated_tax = (($data['item_price'][$key] * $data['item_quantity'][$key]) * $data['item_tax'][$key]) / 100;
                        }else{
                            if ($gst_group != null && $gst_group == "igst") {
                                $calculated_tax = (($data['item_price'][$key] * $data['item_quantity'][$key]) * $data['item_igst'][$key]) / 100;
                            }
                            if ($gst_group != null && $gst_group == "cgst") {
                                $calculated_tax = (($data['item_price'][$key] * $data['item_quantity'][$key]) * $data['item_cgst'][$key]) / 100;
                            }
                            if ($gst_group != null && $gst_group == "sgst") {
                                $calculated_tax = (($data['item_price'][$key] * $data['item_quantity'][$key]) * $data['item_sgst'][$key]) / 100;
                            }
                            if ($gst_group != null && $gst_group == "cess") {
                                $calculated_tax = (($data['item_price'][$key] * $data['item_quantity'][$key]) * $data['item_cess'][$key]) / 100;
                            }
                        }
                        $sub_total = (($data['item_price'][$key] * $data['item_quantity'][$key] + $calculated_tax) - $data['item_discount'][$key]);
                        $productsku->update([
                            'cogs' => $sku_item->selling_price,
                            'price' => $data['item_price'][$key],
                            'quantity' => $data['item_quantity'][$key],
                            'tax' => (app('general_setting')->enable_gst == 0) ? $data['item_tax'][$key] : 0,
                            'gst_group' => $gst_group,
                            'igst' => ($gst_group != null) ? $data['item_igst'][$key] : 0,
                            'cgst' => ($gst_group != null) ? $data['item_cgst'][$key] : 0,
                            'sgst' => ($gst_group != null) ? $data['item_sgst'][$key] : 0,
                            'cess' => ($gst_group != null) ? $data['item_cess'][$key] : 0,
                            'discount' => $data['item_discount'][$key],
                            'sub_total' => $sub_total
                        ]);
                    }
                    $productHistory = new ProductHistory([
                        'company_name' => app('general_setting')->company_name,
                        'type' => 'sales',
                        'date' => Carbon::now()->toDateString(),
                        'in_out' => $data['item_quantity'][$key],
                        'product_sku_id' => $data['items'][$key],
                        'itemable_id' => $sale->id,
                        'itemable_type' => SellerProductSKU::class,
                        'branchable_id' => null,
                        'branchable_type' => $sale->saleable_type,
                    ]);
                    $productHistory->save();
                } else {
                    return $error;
                }
            }
        }
        if (!empty($data['product_id'])) {
            foreach ($data['product_id'] as $key => $id) {
                $stock = SellerProductSKU::find($data['product_id'][$key]);
                if ($stock) {
                    $decreaseQuantity = $data['product_quantity'][$key] - $productsku->quantity;
                    if ($stock->product_stock == 0) {
                        $stock_availability = 'In stock';
                    }elseif ($stock->product_stock != 0) {
                        $stock_availability = $stock->product_stock >= $decreaseQuantity ? 'In stock' : 'Out of stock';
                    }else {
                        $stock_availability = 'Out of stock';
                    }
                    if ($stock_availability == 'In Stock')
                        if (app('general_setting')->enable_gst == 0) {
                            $calculated_tax = (($data['product_price'][$key] * $data['product_quantity'][$key]) * $data['product_tax'][$key]) / 100;
                        }else{
                            if ($gst_group != null && $gst_group == "igst") {
                                $calculated_tax = (($data['product_price'][$key] * $data['product_quantity'][$key]) * $data['product_igst'][$key]) / 100;
                            }
                            if ($gst_group != null && $gst_group == "cgst") {
                                $calculated_tax = (($data['product_price'][$key] * $data['product_quantity'][$key]) * $data['product_cgst'][$key]) / 100;
                            }
                            if ($gst_group != null && $gst_group == "sgst") {
                                $calculated_tax = (($data['product_price'][$key] * $data['product_quantity'][$key]) * $data['product_sgst'][$key]) / 100;
                            }
                            if ($gst_group != null && $gst_group == "cess") {
                                $calculated_tax = (($data['product_price'][$key] * $data['product_quantity'][$key]) * $data['product_cess'][$key]) / 100;
                            }
                        }
                        $sub_total = (($data['product_price'][$key] * $data['product_quantity'][$key] + $calculated_tax) - $data['product_discount'][$key]);
                        $product = new ProductItemDetail([
                            'product_sku_id' => $data['product_id'][$key],
                            'cogs' => $stock->selling_price,
                            'price' => $data['product_price'][$key],
                            'quantity' => $data['product_quantity'][$key],
                            'tax' => (app('general_setting')->enable_gst == 0) ? $data['product_tax'][$key] : 0,
                            'gst_group' => $gst_group,
                            'igst' => ($gst_group != null) ? $data['product_igst'][$key] : 0,
                            'cgst' => ($gst_group != null) ? $data['product_cgst'][$key] : 0,
                            'sgst' => ($gst_group != null) ? $data['product_sgst'][$key] : 0,
                            'cess' => ($gst_group != null) ? $data['product_cess'][$key] : 0,
                            'discount' => $data['product_discount'][$key],
                            'sub_total' => $sub_total,
                            'productable_id' => $stock->product_id,
                            'productable_type' => SellerProductSKU::class,
                            'itemable_id' => $sale->id,
                            'itemable_type' => SellerProduct::class,
                        ]);
                        $product->save();
                        $productHistory = new ProductHistory([
                            'company_name' => app('general_setting')->company_name,
                            'type' => 'sales',
                            'date' => Carbon::now()->toDateString(),
                            'in_out' => $data['product_quantity'][$key],
                            'product_sku_id' => $data['product_id'][$key],
                            'itemable_id' => $data['product_id'][$key],
                            'itemable_type' => SellerProductSKU::class,
                            'branchable_id' => $sale->saleable_id,
                            'branchable_type' => $sale->saleable_type,
                            'houseable_id' => $sale->id,
                            'houseable_type' => Sale::class,
                        ]);
                        $productHistory->save();
                    } else {
                        return $error;
                    }
                }
        }
        $initial_payment = 0;
        if (!empty($data['payment_method'])) {
            foreach ($data['payment_method'] as $key => $payment_method) {
                $payment_methods = explode('-', $payment_method);
               Payment::create([
                    'payable_id' => $sale->id,
                    'payment_method' => $payment_methods[0],
                    'initial_payment' => ($initial_payment == 1) ? 1 : 0,
                    'has_discount_on_payment' => 0,
                    'payable_type' => Sale::class,
                    'amount' => $data['amount'][$key],
                    'amount_after_discount' => 0,
                    'date' => Carbon::now(),
                    'advance_amount' => 0,
                    'account_id' => 0,
                    'bank_name' => $data['bank_name'][$key],
                    'branch' => $data['branch'][$key],
                    'account_no' => $data['account_no'][$key],
                    'account_owner' => $data['account_owner'][$key],
                ]);
            }
        }
        return $sale;
    }
    public function savePaymentFirst(Request $request, $id)
    {
        DB::beginTransaction();
        if ($request->quick_amounts == null && count($request->payment_method) < 1) {
            Toastr::error(trans("sales::sale.select_a_payment_method"));
            return back();
        }
        try {
            $quick_payments = $bank_payments = $cash_payments = [];
            if ($request->quick_amounts) {
                $quick_payments['quick_cash'] = [
                    'payment_method' => 'quick cash',
                    'amount' => array_sum(explode(',', $request->quick_amounts)),
                ];
            }
            if ($request->payment_method) {
                for ($i = 0; $i < count($request->payment_method); $i++) {
                    $req_payment_method = explode('-', $request->payment_method[$i]);
                    if ($req_payment_method[0] == 'bank') {
                        $bank_methods[$i] = [
                            'payment_method' => $req_payment_method[0],
                            'account_id' => $req_payment_method[1],
                            'amount' => $request->amount[$i],
                            'discount_percent' => ($request->discount) ? $request->discount : 0,
                            'discount_amount' => ($request->discount_amount) ? $request->discount_amount : 0,
                        ];
                        $banks[] = $i;
                    } else {
                        $cash_payments[$i] = [
                            'payment_method' => $req_payment_method[0],
                            'amount' => $request->amount[$i],
                            'discount_percent' => ($request->discount) ? $request->discount : 0,
                            'discount_amount' => ($request->discount_amount) ? $request->discount_amount : 0,
                        ];
                    }
                }
            }
            if (isset($banks))
                foreach ($banks as $key => $bank) {
                    $bank_infos[$key] = [
                        'bank_name' => array_key_exists($key, $request->bank_name) ? $request->bank_name[$key] : '',
                        'branch' => array_key_exists($key, $request->branch) ? $request->branch[$key] : '',
                        'account_no' => array_key_exists($key, $request->account_no) ? $request->account_no[$key] : '',
                        'account_owner' => array_key_exists($key, $request->account_owner) ? $request->account_owner[$key] : '',
                    ];
                    $bank_payments[] = array_merge($bank_methods[$bank], $bank_infos[$key]);
                }

            $payments = array_merge($cash_payments, $bank_payments, $quick_payments);
            DB::commit();
            return 1;
        } catch (\Exception $e) {
            return 0;
        }
    }

}
