<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Media\V1\PlayerStreamer;

use Twilio\Options;
use Twilio\Values;

abstract class PlaybackGrantOptions {
    /**
     * @param int $ttl The time to live of the PlaybackGrant
     * @param string $accessControlAllowOrigin The full URL that is authorized to
     *                                         play back the livestream
     * @return CreatePlaybackGrantOptions Options builder
     */
    public static function create(int $ttl = Values::NONE, string $accessControlAllowOrigin = Values::NONE): CreatePlaybackGrantOptions {
        return new CreatePlaybackGrantOptions($ttl, $accessControlAllowOrigin);
    }
}

class CreatePlaybackGrantOptions extends Options {
    /**
     * @param int $ttl The time to live of the PlaybackGrant
     * @param string $accessControlAllowOrigin The full URL that is authorized to
     *                                         play back the livestream
     */
    public function __construct(int $ttl = Values::NONE, string $accessControlAllowOrigin = Values::NONE) {
        $this->options['ttl'] = $ttl;
        $this->options['accessControlAllowOrigin'] = $accessControlAllowOrigin;
    }

    /**
     * The time to live of the PlaybackGrant. Default value is 15 seconds. Maximum value is 60 seconds.
     *
     * @param int $ttl The time to live of the PlaybackGrant
     * @return $this Fluent Builder
     */
    public function setTtl(int $ttl): self {
        $this->options['ttl'] = $ttl;
        return $this;
    }

    /**
     * The full origin URL where the livestream can be streamed. If this is not provided, it can be streamed from any domain.
     *
     * @param string $accessControlAllowOrigin The full URL that is authorized to
     *                                         play back the livestream
     * @return $this Fluent Builder
     */
    public function setAccessControlAllowOrigin(string $accessControlAllowOrigin): self {
        $this->options['accessControlAllowOrigin'] = $accessControlAllowOrigin;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Media.V1.CreatePlaybackGrantOptions ' . $options . ']';
    }
}