<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if(!Schema::hasColumn('personal_access_tokens','expires_at')){
            Schema::table('personal_access_tokens',function($table){
                $table->timestamp('expires_at')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if(Schema::hasColumn('personal_access_tokens','expires_at')){
            Schema::table('personal_access_tokens',function($table){
                $table->dropColumn('expires_at');
            });
        }
    }
};
