<?php

namespace Tests\Browser\Modules\Account;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Dusk\Browser;
use Modules\Account\Entities\BankAccount;
use Tests\DuskTestCase;

class BankAccountTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $charts =  BankAccount::pluck('id');
        BankAccount::destroy($charts);

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('/account/bank-accounts')
                ->assertSee('Bank Accounts');
        });
    }

    public function test_for_add_new_account(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div > div > div.col-12 > div > div > ul > li > a')
                ->whenAvailable('#bank_account_form', function($modal){
                    $modal->pause(2000)
                        ->type('#bank_name', 'test-bank-account')
                        ->type('#branch_name', $this->faker->name)
                        ->type('#account_name', $this->faker->name)
                        ->type('#account_number', rand(111111111111, 9999999999999))
                        ->type('#opening_balance', '0')
                        ->type('#description', $this->faker->paragraph)
                        ->click('div > div > div:nth-child(7) > div > label > span')
                        ->click('div > div > div.col-lg-12.text-center > div > button.primary-btn.fix-gr-bg.submit');
                }, 25)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'The requested bank account created successful');
        });
    }

    public function test_for_validate_add_new_account(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div > div > div.col-12 > div > div > ul > li > a')
                ->whenAvailable('#bank_account_form', function($modal){
                    $modal->pause(2000)
                        ->type('#bank_name', '')
                        ->type('#branch_name', '')
                        ->type('#account_name', '')
                        ->type('#account_number', '')
                        ->type('#opening_balance', '')
                        ->type('#description', '')
                        ->click('div > div > div:nth-child(7) > div > label > span')
                        ->click('div > div > div.col-lg-12.text-center > div > button.primary-btn.fix-gr-bg.submit');
                }, 25)
                ->pause(2000)
                ->assertSee('This value is required.');
        });
    }


    public function test_for_edit_account(){
        $this->test_for_add_new_account();
        $this->browse(function (Browser $browser) {
            $browser->pause(5000)
                ->click('#bank-account-table > tbody > tr > td:nth-child(8) > div > button')
                ->click('#bank-account-table > tbody > tr > td:nth-child(8) > div > div > a.dropdown-item.btn-modal')
                ->whenAvailable('#bank_account_edit_form', function($modal){
                    $modal->pause(2000)
                        ->type('#bank_name', 'test-bank-account-edit')
                        ->type('#branch_name', $this->faker->name)
                        ->type('#account_name', $this->faker->name)
                        ->type('#account_number', rand(111111111111, 9999999999999))
                        ->type('#opening_balance', '10')
                        ->type('#description', $this->faker->paragraph)
                        ->click('div > div > div:nth-child(7) > div > label > span')
                        ->click('div > div > div.col-lg-12.text-center > div > button.primary-btn.fix-gr-bg.submit');
                }, 25)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'The requested bank account updated successful');
        });
    }

    public function test_for_validate_edit_account(){
        $this->test_for_add_new_account();
        $this->browse(function (Browser $browser) {
            $browser->pause(10000)
                ->click('#bank-account-table > tbody > tr > td:nth-child(8) > div > button')
                ->click('#bank-account-table > tbody > tr > td:nth-child(8) > div > div > a.dropdown-item.btn-modal')
                ->whenAvailable('#bank_account_edit_form', function($modal){
                    $modal->pause(2000)
                        ->type('#bank_name', '')
                        ->type('#branch_name', '')
                        ->type('#account_name', '')
                        ->type('#account_number', '')
                        ->type('#opening_balance', '')
                        ->type('#description', '')
                        ->click('div > div > div.col-lg-12.text-center > div > button.primary-btn.fix-gr-bg.submit');
                }, 25)
                ->pause(2000)
                ->assertSee('This value is required.');
        });
    }

    public function test_for_delete_account(){
        $this->test_for_add_new_account();
        $this->browse(function (Browser $browser) {
            $browser->pause(5000)
                ->click('#bank-account-table > tbody > tr > td:nth-child(8) > div > button')
                ->click('#bank-account-table > tbody > tr > td:nth-child(8) > div > div > a.dropdown-item.delete_item')
                ->whenAvailable('#delete_modal_form', function($modal){
                    $modal->click('div > div > div.col-lg-12.text-center > div > button.primary-btn.fix-gr-bg.submit');
                }, 10)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'The requested bank account deleted successful');
        });        
    }

    public function test_for_visit_account_transection_history(){
        $this->test_for_add_new_account();
        $this->browse(function (Browser $browser) {
            $account = BankAccount::latest()->first();
            $browser->pause(5000)
                ->click('#bank-account-table > tbody > tr > td:nth-child(8) > div > button')
                ->click('#bank-account-table > tbody > tr > td:nth-child(8) > div > div > a:nth-child(1)')
                ->assertPathIs('/account/bank-report/'.$account->id)
                ->assertSee('Bank Account Details');

        });        
    }



}
