<?php

namespace Tests\Browser\Modules\Attendance;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\File;
use Laravel\Dusk\Browser;
use Modules\Attendance\Entities\Event;
use Tests\DuskTestCase;

class EventTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $events = Event::all();
        foreach($events as $event){
            if(File::exists(public_path($event->image))){
                File::delete(public_path($event->image));
            }
            $event->delete();
        }

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('/events')
                ->assertSee('Event List');
        });
    }

    public function test_for_create_event(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->type('#title', $this->faker->title)
                ->click('#main-content > section > div > div > div.col-lg-3 > div > div > form > div > div > div > div:nth-child(2) > div > div')
                ->click('#main-content > section > div > div > div.col-lg-3 > div > div > form > div > div > div > div:nth-child(2) > div > div > ul > li:nth-child(4)')
                ->type('#current_address', 'test address')
                ->type('#start_date', date('m/d/Y'))
                ->click('#main-content > section > div > div > div.col-lg-9 > div:nth-child(1) > div > div > h3')
                ->pause(1000)
                ->type('#main-content > section > div > div > div.col-lg-3 > div > div > form > div > div > div > div:nth-child(5) > div > div > div > div > div > input', date('m/d/Y'))
                ->click('#main-content > section > div > div > div.col-lg-9 > div:nth-child(1) > div > div > h3')
                ->pause(1000)
                ->type('#description', 'test description')
                ->attach('#document_file_1', __DIR__.'/files/banner_image.png')
                ->click('#main-content > section > div > div > div.col-lg-3 > div > div > form > div > div > div > div.col-lg-12.text-center > button')
                ->assertPathIs('/events')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!');
        });
    }

    public function test_for_validate_create_form(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->type('#title', '')
                ->type('#current_address', '')
                ->type('#start_date', '')
                ->click('#main-content > section > div > div > div.col-lg-9 > div:nth-child(1) > div > div > h3')
                ->pause(1000)
                ->type('#main-content > section > div > div > div.col-lg-3 > div > div > form > div > div > div > div:nth-child(5) > div > div > div > div > div > input', '')
                ->click('#main-content > section > div > div > div.col-lg-9 > div:nth-child(1) > div > div > h3')
                ->pause(1000)
                ->type('#description', '')
                ->click('#main-content > section > div > div > div.col-lg-3 > div > div > form > div > div > div > div.col-lg-12.text-center > button')
                ->assertPathIs('/events')
                ->assertSeeIn('#main-content > section > div > div > div.col-lg-3 > div > div > form > div > div > div > div:nth-child(1) > div > span', 'The title field is required.')
                ->assertSeeIn('#main-content > section > div > div > div.col-lg-3 > div > div > form > div > div > div > div:nth-child(3) > div > span', 'The location field is required.')
                ->assertSeeIn('#main-content > section > div > div > div.col-lg-3 > div > div > form > div > div > div > div:nth-child(4) > div > span', 'The from date field is required.')
                ->assertSeeIn('#main-content > section > div > div > div.col-lg-3 > div > div > form > div > div > div > div:nth-child(5) > div > span', 'The to date field is required.');

        });
    }

    public function test_for_edit_event(){
        $this->test_for_create_event();
        $this->browse(function (Browser $browser) {
            $event = Event::first();
            $browser->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > div > a:nth-child(1)')
                ->assertPathIs('/events/'.$event->id.'/edit')
                ->assertSee('Edit Event')
                ->type('#title', $this->faker->title)
                ->click('#main-content > section > div > div:nth-child(2) > div.col-lg-3 > div > div > form > div > div > div > div:nth-child(2) > div > div')
                ->click('#main-content > section > div > div:nth-child(2) > div.col-lg-3 > div > div > form > div > div > div > div:nth-child(2) > div > div > ul > li:nth-child(2)')
                ->type('#current_address', 'test address edit')
                ->type('#start_date', date('m/d/Y', strtotime("+3 day", $event->start_date)))
                ->click('#main-content > section > div > div > div.col-lg-9 > div:nth-child(1) > div > div > h3')
                ->pause(1000)
                ->type('#main-content > section > div > div:nth-child(2) > div.col-lg-3 > div > div > form > div > div > div > div:nth-child(5) > div > div > div > div > div > input', date('m/d/Y', strtotime("+7 day", $event->start_date)))
                ->click('#main-content > section > div > div > div.col-lg-9 > div:nth-child(1) > div > div > h3')
                ->pause(1000)
                ->type('#description', 'test description edit')
                ->attach('#document_file_1', __DIR__.'/files/banner_image.png')
                ->click('#main-content > section > div > div:nth-child(2) > div.col-lg-3 > div > div > form > div > div > div > div.col-lg-12.text-center > button')
                ->assertPathIs('/events')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');

        });
    }

    public function test_for_validate_edit_form(){
        $this->test_for_create_event();
        $this->browse(function (Browser $browser) {
            $event = Event::first();
            $browser->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > div > a:nth-child(1)')
                ->assertPathIs('/events/'.$event->id.'/edit')
                ->assertSee('Edit Event')
                ->type('#title', '')
                ->type('#current_address', '')
                ->type('#start_date', '')
                ->click('#main-content > section > div > div > div.col-lg-9 > div:nth-child(1) > div > div > h3')
                ->pause(1000)
                ->type('#main-content > section > div > div:nth-child(2) > div.col-lg-3 > div > div > form > div > div > div > div:nth-child(5) > div > div > div > div > div > input', '')
                ->click('#main-content > section > div > div > div.col-lg-9 > div:nth-child(1) > div > div > h3')
                ->pause(1000)
                ->type('#description', '')
                ->click('#main-content > section > div > div:nth-child(2) > div.col-lg-3 > div > div > form > div > div > div > div.col-lg-12.text-center > button')
                ->assertPathIs('/events/'.$event->id.'/edit')
                ->assertSeeIn('#main-content > section > div > div > div.col-lg-3 > div > div > form > div > div > div > div:nth-child(1) > div > span', 'The title field is required.')
                ->assertSeeIn('#main-content > section > div > div > div.col-lg-3 > div > div > form > div > div > div > div:nth-child(3) > div > span', 'The location field is required.')
                ->assertSeeIn('#main-content > section > div > div > div.col-lg-3 > div > div > form > div > div > div > div:nth-child(4) > div > span', 'The from date field is required.')
                ->assertSeeIn('#main-content > section > div > div > div.col-lg-3 > div > div > form > div > div > div > div:nth-child(5) > div > span', 'The to date field is required.');
                

        });
    }

    public function test_for_delete_event(){
        $this->test_for_create_event();
        $this->browse(function (Browser $browser) {
            $browser->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > div > a.dropdown-item.delete_event')
                ->whenAvailable('#confirm-delete > div > div > div.modal-body > div.mt-40.d-flex.justify-content-between', function($modal){
                    $modal->click('#delete_link')
                        ->assertPathIs('/events');
                        
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');
        });        
    }
}
