<?php

namespace Tests\Browser\Modules\FrontendCMS;

use App\Models\User;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Dusk\Browser;
use Modules\FrontendCMS\Entities\Pricing;
use Tests\DuskTestCase;

class PricingPlanPageTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $pricing_list = Pricing::pluck('id');
        Pricing::destroy($pricing_list);

        parent::tearDown(); // TODO: Change the autogenerated stub
    }
    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_pricing_plan_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(User::find(1))
                ->visit('/frontendcms/pricing')
                ->assertSee('Pricing List');     
        });
    }

    public function test_for_create_pricing(){
        $this->browse(function (Browser $browser) {
            $browser->loginAs(User::find(1))
                ->visit('/frontendcms/pricing')
                ->type('#name', 'test pricing plan')
                ->type('#monthly_cost', 5)
                ->type('#yearly_cost', 40)
                ->type('#team_size', 20)
                ->type('#stock_limit', 100)
                ->type('#commission', 5)
                ->type('#transaction_fee', 2)
                ->type('#best_for', 'test best for')
                ->click('#theme_nav > li:nth-child(2) > label > span')
                ->click('#create_btn > span')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message','Created successfully!');    
        });
    }

    public function test_for_edit_pricing(){
        $this->test_for_create_pricing();
        $this->browse(function (Browser $browser) {
            $browser->visit('/frontendcms/pricing')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(7) > div')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(7) > div > div > a.dropdown-item.edit_pricing')
                ->waitForText('Edit Pricing Plan', 25)
                ->assertSee('Edit Pricing Plan')
                ->type('#name', 'test pricing plan edit')
                ->type('#monthly_cost', 12)
                ->type('#yearly_cost', 42)
                ->type('#team_size', 22)
                ->type('#stock_limit', 102)
                ->type('#commission', 7)
                ->type('#transaction_fee', 3)
                ->type('#best_for', 'test best for edit')
                ->click('#theme_nav > li:nth-child(2) > label > span')
                ->click('#edit_btn')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message','Updated successfully!'); 
        });
    }

    public function test_for_delete_pricing(){
        $this->test_for_create_pricing();
        $this->browse(function (Browser $browser) {
            $browser->visit('/frontendcms/pricing')
            ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(7) > div')
            ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(7) > div > div > a.dropdown-item.delete_pricing')
            ->whenAvailable('#dataDeleteBtn', function($modal){

                $modal->click('#dataDeleteBtn');
            })
            ->waitFor('.toast-message',25)
            ->assertSeeIn('.toast-message', 'Deleted successfully!');
        });
    }

    public function test_for_view_pricing(){
        $this->test_for_create_pricing();
        $this->browse(function (Browser $browser) {
            $browser->visit('/frontendcms/pricing')
            ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(7) > div')
            ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(7) > div > div > a.dropdown-item.show_pricing')
            ->whenAvailable('#item_show > div > div > div.modal-body.item_edit_form > h5:nth-child(1)', function($modal){
                $modal->assertSeeIn('#show_name','test pricing plan');
            });
        });
    }

    public function test_for_status_change(){
        $this->test_for_create_pricing();
        $this->browse(function (Browser $browser) {
            $browser->visit('/frontendcms/pricing')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > label > div')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }
}
