<?php

namespace Tests\Browser\Modules\PaymentGateway;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Dusk\Browser;
use Modules\PaymentGateway\Entities\PaymentMethod;
use Tests\DuskTestCase;

use function PHPSTORM_META\type;

class PaymentGatewayTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $stribe = PaymentMethod::where('method', 'Stripe')->first();

        $stribe->update([
            'active_status' =>0
        ]);

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('/paymentgateway')
                ->assertSee('Activation');
        });
    }

    public function test_for_enable_payment_gateway(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#DataTables_Table_0 > tbody > tr:nth-child(4) > td.text-right > label > div')
            ->waitFor('.toast-message',25)
            ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_paypal_update(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > div.row > div.col-md-8 > section > div > div > div.col-md-12.mb-20 > div > div > ul > li:nth-child(1) > a')
                ->pause(1)
                ->assertSee('Paypal Configuration')
                ->click('#paypalTab > form > div > div:nth-child(2) > div > div > div > label')
                ->type('#paypalTab > form > div > div:nth-child(3) > div > input.primary_input_field', 'Afth8tuZq5oNpy5VCaQlmuelnB5egFAKHrNwg5aka_tlRC9YpUec9I6IoRc3CNNNd5GsYgyR0JGpF-X6')
                ->type('#paypalTab > form > div > div:nth-child(5) > div > input.primary_input_field', 'EKXHVM_WbMqw5sMj1hI4kEe94_w5Ff_-WGHqE3zm-a5I4Dga-2ga7vLZbaA-iI12lWLhBgtMr9XLRXwc')
                ->attach('#paypal_logo', __DIR__.'/files/payment_gateway/paypal.png')
                ->click('#paypalTab > form > div > div.col-lg-12.text-center > button')
                ->assertPathIs('/paymentgateway')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_stribe_update(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > div.row > div.col-md-8 > section > div > div > div.col-md-12.mb-20 > div > div > ul > li:nth-child(2) > a')
                ->pause(1)
                ->assertSee('Stripe Configuration')
                ->type('#stripeTab > form > div > div:nth-child(1) > div > input.primary_input_field', 'pk_test_51HUWfSGRvmmDdlLV4SicdCgwHvugSZJIWnq3JAVRdJFwzkNS94SafaOSsg9qgUdQkO0yyWARKyWSXOjjBXFrvwDD00kYOLnaBQ')
                ->type('#stripeTab > form > div > div:nth-child(2) > div > input.primary_input_field', 'demo@strip.com')
                ->type('#stripeTab > form > div > div:nth-child(4) > div > input.primary_input_field', 'sk_test_51HUWfSGRvmmDdlLV87aRqJ8CVka2HtjB1SQvBzfbWzr7F9KaK5txg23eASkhitYJVz0IgovdnOOi7t6ab3xqGB4D00oAGvGCxq')
                ->attach('#logoStripe', __DIR__.'/files/payment_gateway/stripe.png')
                ->click('#stripeTab > form > div > div.col-lg-12.text-center > button')
                ->assertPathIs('/paymentgateway')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });        
    }

    public function test_for_paystack_update(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > div.row > div.col-md-8 > section > div > div > div.col-md-12.mb-20 > div > div > ul > li:nth-child(3) > a')
                ->pause(1)
                ->assertSee('Paystack Configuration')
                ->type('#paystackTab > form > div > div:nth-child(1) > div > input.primary_input_field', $this->faker->email)
                ->type('#paystackTab > form > div > div:nth-child(2) > div > input.primary_input_field', 'test-app-key')
                ->type('#paystackTab > form > div > div:nth-child(4) > div > input.primary_input_field', 'test-secret-key')
                ->type('#paystackTab > form > div > div:nth-child(5) > div > input.primary_input_field', 'test_payment_url')
                ->attach('#logoPaystack', __DIR__.'/files/payment_gateway/paystack.png')
                ->click('#paystackTab > form > div > div.col-lg-12.text-center > button')
                ->assertPathIs('/paymentgateway')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });        
    }

    public function test_for_razorpay_update(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > div.row > div.col-md-8 > section > div > div > div.col-md-12.mb-20 > div > div > ul > li:nth-child(4) > a')
                ->pause(1)
                ->assertSee('RazorPay Configuration')
                ->type('#razorpayTab > form > div > div:nth-child(1) > div > input.primary_input_field', 'test-razor-key')
                ->type('#razorpayTab > form > div > div:nth-child(3) > div > input.primary_input_field', 'test-secret-key')
                ->attach('#logoRazor', __DIR__.'/files/payment_gateway/razorpay.png')
                ->click('#razorpayTab > form > div > div.col-lg-12.text-center > button')
                ->assertPathIs('/paymentgateway')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });        
    }

    public function test_for_paytm_update(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > div.row > div.col-md-8 > section > div > div > div.col-md-12.mb-20 > div > div > ul > li:nth-child(4) > a')
                ->pause(1)
                ->assertSee('Paytm Configuration')
                ->type('#paytmTab > form > div > div:nth-child(1) > div > input.primary_input_field', 'test-payment-invironment')
                ->type('#paytmTab > form > div > div:nth-child(3) > div > input.primary_input_field', 'test-merchant-id')
                ->type('#paytmTab > form > div > div:nth-child(4) > div > input.primary_input_field', 'test-merhcant-website')
                ->type('#paytmTab > form > div > div:nth-child(5) > div > input.primary_input_field', 'test-merchant-key')
                ->type('#paytmTab > form > div > div:nth-child(6) > div > input.primary_input_field', 'test-paytm-channel')
                ->type('#paytmTab > form > div > div:nth-child(7) > div > input.primary_input_field', 'test-industry-type')
                ->attach('#logoPaytm', __DIR__.'/files/payment_gateway/paytm.jpg')
                ->click('#paytmTab > form > div > div.col-lg-12.text-center > button')
                ->assertPathIs('/paymentgateway')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });        
    }

    public function test_for_instamojo_update(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > div.row > div.col-md-8 > section > div > div > div.col-md-12.mb-20 > div > div > ul > li:nth-child(6) > a')
                ->pause(1)
                ->assertSee('Instamojo Configuration')
                ->type('#instamojoTab > form > div > div:nth-child(1) > div > input.primary_input_field', 'test-app-key')
                ->type('#instamojoTab > form > div > div:nth-child(3) > div > input.primary_input_field', 'test-auth-token')
                ->type('#instamojoTab > form > div > div:nth-child(4) > div > input.primary_input_field', 'test-instamojo-url')
                ->attach('#logoInstamojo', __DIR__.'/files/payment_gateway/intamojo.png')
                ->click('#instamojoTab > form > div > div.col-lg-12.text-center > button')
                ->assertPathIs('/paymentgateway')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');

        });        
    }

    public function test_for_mistrans_update(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > div.row > div.col-md-8 > section > div > div > div.col-md-12.mb-20 > div > div > ul > li:nth-child(7) > a')
                ->pause(1)
                ->assertSee('Midtrans Configuration')
                ->click('#midtransTab > form > div > div:nth-child(1) > div > div')
                ->click('#midtransTab > form > div > div:nth-child(1) > div > div > ul > li:nth-child(1)')
                ->type('#midtransTab > form > div > div:nth-child(3) > div > input.primary_input_field', 'test-server-key')
                ->type('#midtransTab > form > div > div:nth-child(4) > div > input.primary_input_field', 'test-client-key')
                ->attach('#logoMidtrans', __DIR__.'/files/payment_gateway/midtrans.jpg')
                ->click('#midtransTab > form > div > div.col-lg-12.text-center > button')
                ->assertPathIs('/paymentgateway')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });        
    }

    public function test_for_payumoney_update(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > div.row > div.col-md-8 > section > div > div > div.col-md-12.mb-20 > div > div > ul > li:nth-child(8) a')
                ->pause(1)
                ->assertSee('Payumoney Configuration')
                ->click('#payumoneyTab > form > div > div:nth-child(2) > div > div')
                ->click('#payumoneyTab > form > div > div:nth-child(2) > div > div > ul > li:nth-child(1)')
                ->type('#payumoneyTab > form > div > div:nth-child(3) > div > input.primary_input_field', 'test-payumoney-key')
                ->type('#payumoneyTab > form > div > div:nth-child(4) > div > input.primary_input_field', 'test-payumoney-salt')
                ->type('#payumoneyTab > form > div > div:nth-child(5) > div > input.primary_input_field', 'test-payumoney-auth')
                ->attach('#logoPayUmoney', __DIR__.'/files/payment_gateway/payumoney-logo.jpg')
                ->click('#payumoneyTab > form > div > div.col-lg-12.text-center > button')
                ->assertPathIs('/paymentgateway')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');

        });        
    }

    public function test_for_jazzcash_update(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > div.row > div.col-md-8 > section > div > div > div.col-md-12.mb-20 > div > div > ul > li:nth-child(9) a')
                ->pause(1)
                ->assertSee('JazzCash Configuration')
                ->click('#jazzcashTab > form > div > div:nth-child(1) > div > div > div > label')
                ->type('#jazzcashTab > form > div > div:nth-child(3) > div > input.primary_input_field', 'test-merchant-id')
                ->type('#jazzcashTab > form > div > div:nth-child(5) > div > input.primary_input_field', 'test-password')
                ->type('#jazzcashTab > form > div > div:nth-child(6) > div > input.primary_input_field', 'test-salt-id')
                ->type('#jazzcashTab > form > div > div:nth-child(7) > div > input.primary_input_field', 'test-salt-url')
                ->attach('#logoJazzCash', __DIR__.'/files/payment_gateway/JazzCash.jpg')
                ->click('#jazzcashTab > form > div > div.col-lg-12.text-center > button')
                ->assertPathIs('/paymentgateway')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });        

    }

    public function test_for_googlepay_update(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > div.row > div.col-md-8 > section > div > div > div.col-md-12.mb-20 > div > div > ul > li:nth-child(10) a')
                ->pause(1)
                ->assertSee('Google Pay Configuration')
                ->click('#google_payTab > form > div > div:nth-child(1) > div > div > div > label')
                ->type('#google_payTab > form > div > div:nth-child(3) > div > input.primary_input_field', 'test-gateway-name')
                ->type('#google_payTab > form > div > div:nth-child(5) > div > input.primary_input_field', 'test-merchant-id')
                ->type('#google_payTab > form > div > div:nth-child(6) > div > input.primary_input_field', 'test-merchant-name')
                ->attach('#logogooglePay', __DIR__.'/files/payment_gateway/GooglePay.png')
                ->click('#google_payTab > form > div > div.col-lg-12.text-center > button')
                ->assertPathIs('/paymentgateway')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });

    }

    public function test_for_flatter_wave_update(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > div.row > div.col-md-8 > section > div > div > div.col-md-12.mb-20 > div > div > ul > li:nth-child(11) a')
                ->pause(1)
                ->assertSee('Flutter Wave Payment Configuration')
                ->type('#flutterWaveTab > form > div > div:nth-child(2) > div > input.primary_input_field', 'test-public-key')
                ->type('#flutterWaveTab > form > div > div:nth-child(3) > div > input.primary_input_field', 'test-secret-key')
                ->type('#flutterWaveTab > form > div > div:nth-child(4) > div > input.primary_input_field', 'test-secret-hash')
                ->attach('#logoFlutterWave', __DIR__.'/files/payment_gateway/flutterWavePayment.png')
                ->click('#flutterWaveTab > form > div > div.col-lg-12.text-center > button')
                ->assertPathIs('/paymentgateway')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });        
    }

    public function test_for_bank_payment_update(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > div.row > div.col-md-8 > section > div > div > div.col-md-12.mb-20 > div > div > ul > li:nth-child(12) a')
                ->pause(1)
                ->assertSee('Bank Configuration')
                ->type('#bankTab > form > div > div:nth-child(1) > div > input.primary_input_field', 'test-bank-name')
                ->type('#bankTab > form > div > div:nth-child(2) > div > input.primary_input_field', 'test-branch-name')
                ->type('#bankTab > form > div > div:nth-child(4) > div > input.primary_input_field', '5172283742839482')
                ->type('#bankTab > form > div > div:nth-child(5) > div > input.primary_input_field', 'test-account-holder')
                ->attach('#logobank', __DIR__.'/files/payment_gateway/bank.png')
                ->click('#bankTab > form > div > div.col-lg-12.text-center > button')
                ->assertPathIs('/paymentgateway')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });        
    }

}
