<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\ResourceCollection;

class WalletCollection extends ResourceCollection
{
    public function toArray($request)
    {
        return [
            'data' => $this->collection->map(function($data) {
                return [
                    'id' => $data->id,
                    'date' => $data->created_at->toDateString(),
                    'amount' => $data->amount,
                    'payment_method' => $data->payment_method,
                    'type' => $data->type,
                    'details' => $data->details,
                    'receipt' => $data->reciept ? my_asset($data->reciept): null,
                ];
            })
        ];
    }

    public function with($request)
    {
        return [
            'success' => true,
            'status' => 200
        ];
    }
}
