<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Routes\V2;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;

class TrunkContext extends InstanceContext {
    /**
     * Initialize the TrunkContext
     *
     * @param Version $version Version that contains the resource
     * @param string $sipTrunkDomain The SIP Trunk
     */
    public function __construct(Version $version, $sipTrunkDomain) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['sipTrunkDomain' => $sipTrunkDomain, ];

        $this->uri = '/Trunks/' . \rawurlencode($sipTrunkDomain) . '';
    }

    /**
     * Update the TrunkInstance
     *
     * @param array|Options $options Optional Arguments
     * @return TrunkInstance Updated TrunkInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(array $options = []): TrunkInstance {
        $options = new Values($options);

        $data = Values::of([
            'VoiceRegion' => $options['voiceRegion'],
            'FriendlyName' => $options['friendlyName'],
        ]);

        $payload = $this->version->update('POST', $this->uri, [], $data);

        return new TrunkInstance($this->version, $payload, $this->solution['sipTrunkDomain']);
    }

    /**
     * Fetch the TrunkInstance
     *
     * @return TrunkInstance Fetched TrunkInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): TrunkInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new TrunkInstance($this->version, $payload, $this->solution['sipTrunkDomain']);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Routes.V2.TrunkContext ' . \implode(' ', $context) . ']';
    }
}