<?php

namespace Modules\GoogleMerchantCenter\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Routing\Controller;
use \Modules\GoogleMerchantCenter\Services\GoogleMerchantCenterService;
use Brian2694\Toastr\Facades\Toastr;
use Modules\UserActivityLog\Traits\LogActivity;

class GoogleMerchantCenterController extends Controller
{
    protected $googleMerchantCenterService;

    public function __construct(GoogleMerchantCenterService $googleMerchantCenterService)
    {
        $this->googleMerchantCenterService = $googleMerchantCenterService;
    }

    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $data['get_category'] = $this->googleMerchantCenterService->getCategory();
        return view('googlemerchantcenter::index', $data);
    }

    public function csv_googlemerchantcenterproduct_download(Request $request)
    {
        try {
            $this->googleMerchantCenterService->csvDownloadGoogleMerchantCenterProduct($request->except("_token"));
            $filePath = storage_path("app/googlemerchantcenterproducts_list.xlsx");
        	$headers = ['Content-Type: text/csv'];
        	$fileName = 'googlemerchantcenterproducts_list.xlsx';

        	return response()->download($filePath, $fileName, $headers);
            return back();
        } catch (\Exception $e) {
            LogActivity::errorLog($e->getMessage());
            Toastr::error(__('common.error_message'));
            return back();
        }
    }


}
