<?php

namespace Tests\Browser\Modules\Marketing;

use App\Models\User;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Laravel\Dusk\Browser;
use Modules\Marketing\Entities\ReferralCode;
use Tests\DuskTestCase;

class ReferralTest extends DuskTestCase
{

    public function setUp(): void
    {
        parent::setUp();

        ReferralCode::create([
            'user_id' => 1,
            'referral_code' => rand(111111111111, 999999999999),
            'status' => 0
        ]);

    }

    public function tearDown(): void
    {
        $codes = ReferralCode::pluck('id');
        ReferralCode::destroy($codes);

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                    ->visit('/marketing/referral-code')
                    ->assertSee('Referral Code List');
        });
    }

    public function update_benefit_amount(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->type('#amount', '')
                ->type('#maximum_limit', '')
                ->click('#submit_btn')
                ->waitForTextIn('#error_amount', 'The amount field is required.', 25)
                ->assertSeeIn('#error_amount', 'The amount field is required.')
                ->assertSeeIn('#error_maximum_limit', 'The maximum limit field is required.')
                ->type('#amount', '10')
                ->type('#maximum_limit', '20')
                ->click('#submit_btn')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_refer_status_change(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->pause(10000)
                ->click('#referralCodeTable > tbody > tr > td:nth-child(5) > label > div')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }
}
