<?php

namespace Tests\Browser\Modules\Marketing;

use App\Models\Subscription;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Dusk\Browser;
use Tests\DuskTestCase;

class SubscriberTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();

        Subscription::create([
            'email' => $this->faker->email,
            'status' => 0
        ]);

    }

    public function tearDown(): void
    {
        $subscriptions = Subscription::pluck('id');
        Subscription::destroy($subscriptions);

        parent::tearDown(); // TODO: Change the autogenerated stub
    }
    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                    ->visit('/marketing/subscribers')
                    ->assertSee('Subscriber List');
        });
    }

    public function test_for_status_change(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->pause(10000)
                ->click('#subscriberTable > tbody > tr > td:nth-child(4) > label > div')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_delete(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->pause(10000)
                ->click('#subscriberTable > tbody > tr > td:nth-child(5) > div > button')
                ->click('#subscriberTable > tbody > tr > td:nth-child(5) > div > div > a')
                ->whenAvailable('#item_delete_form', function($modal){
                    $modal->click('#dataDeleteBtn');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');

        });    
    }
}
