<?php

namespace Tests\Browser\Modules\Wallet;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Laravel\Dusk\Browser;
use Modules\PaymentGateway\Entities\PaymentMethod;
use Modules\Wallet\Entities\WalletBalance;
use Tests\DuskTestCase;

class SellerMyWalletTest extends DuskTestCase
{
    public function setUp(): void
    {
        parent::setUp();

        $stribe = PaymentMethod::where('method', 'Stripe')->first();

        $stribe->update([
            'active_status' => 1
        ]);

    }

    public function tearDown(): void
    {
        $balances = WalletBalance::all();
        foreach($balances as $balance){
            $balance->delete();
        }

        $stribe = PaymentMethod::where('method', 'Stripe')->first();

        $stribe->update([
            'active_status' =>0
        ]);

        parent::tearDown(); // TODO: Change the autogenerated stub
    }
    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(5)
                ->visit('/wallet/seller/my-wallet-index')
                ->assertSee('Transaction List');
        });
    }

    public function test_for_recharge_wallet(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section:nth-child(3) > div > div > div > div.box_header.common_table_header > div > ul > li:nth-child(1) > a')
                ->whenAvailable('#recharge_form', function($modal){
                    $modal->type('#recharge_amount', '500')
                        ->click('#save_button_parent')
                        ->assertPathIs('/wallet/my-wallet-create');

                })
                ->assertSee('Choose Payment Gateway')
                ->click('#main-content > section > div > div > div > div.row > div:nth-child(2) > div > div > form > button')
                ->pause(3000)
                ->whenAvailable('#container > section > span:nth-child(3) > div > div > main > form', function($modal){
                    $modal->type('div > div > div > div > div > div:nth-child(1) > div.StaggerGroup-child.is-head-0.is-tail-NaN > div > div > div > fieldset > span > div > div.Textbox-inputRow > input', 'test@test.com')
                        ->type('div > div > div > div > div > div:nth-child(1) > div.Section-child--padded > fieldset > div:nth-child(1) > div.StaggerGroup-child.is-head-1.is-tail-NaN > span > span:nth-child(1) > div > div.Textbox-inputRow > input', '4242424242424242')
                        ->pause(1000)
                        ->type('div > div > div > div > div > div:nth-child(1) > div.Section-child--padded > fieldset > div:nth-child(1) > div.StaggerGroup-child.is-head-2.is-tail-NaN > div.Fieldset-childLeft.u-size1of2.Fieldset-childBottom.Textbox.Textbox--iconLeft.can-setfocus > div.Textbox-inputRow > input', '0233')
                        ->pause(1000)
                        ->type('div > div > div > div > div > div:nth-child(1) > div.Section-child--padded > fieldset > div:nth-child(1) > div.StaggerGroup-child.is-head-2.is-tail-NaN > div.Fieldset-childRight.u-size1of2.Fieldset-childBottom.Textbox.Textbox--iconLeft.can-setfocus > div.Textbox-inputRow > input', '123')
                        ->click('nav > div > div > div > button');
                })
                ->assertPathIs('/wallet/seller/my-wallet-index');
        });

    }

    public function test_for_withdraw_from_my_wallet(){
        WalletBalance::create([
            'user_id' => 5,
            'type' => "Deposite",
            'amount' => 200,
            'payment_method' => 4,
            'txn_id' => 'ch_1J9Pk9GRvmmDdlLV1ogZNRr2',
            'status' => 1
        ]);

        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section:nth-child(3) > div > div > div > div.box_header.common_table_header > div > ul > li:nth-child(2) > a')
                ->whenAvailable('#withdraw_form', function($modal){
                    $modal->type('#withdraw_amount_add', '100')
                        ->click('#save_button_parent')
                        ->assertPathIs('/wallet/my-withdraw-requests');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Withdraw Request has been sent Successfully!');
        });
    }


    public function test_for_visit_withdraw_index(){
        $this->browse(function (Browser $browser) {
            $browser->loginAs(5)
                ->visit('/wallet/my-withdraw-requests')
                ->assertSee('Withdraw history');
        });
    }

    public function test_for_from_withpage_amount_withdraw(){
        WalletBalance::create([
            'user_id' => 5,
            'type' => "Deposite",
            'amount' => 200,
            'payment_method' => 4,
            'txn_id' => 'ch_1J9Pk9GRvmmDdlLV1ogZNRr2',
            'status' => 1
        ]);

        $this->test_for_visit_withdraw_index();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section:nth-child(3) > div > div > div > div.box_header.common_table_header > div > ul > li > a')
                ->whenAvailable('#withdraw_form', function($modal){
                    $modal->type('#withdraw_amount_add', '100')
                        ->click('#save_button_parent')
                        ->assertPathIs('/wallet/my-withdraw-requests');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Withdraw Request has been sent Successfully!');
        });

    }

    public function test_for_update_withdraw_request(){
        $this->test_for_from_withpage_amount_withdraw();
        $this->browse(function (Browser $browser) {
            $browser->click('#myWithdrawTable > tbody > tr:nth-child(1) > td:nth-child(8) > a')
                ->whenAvailable('#withdraw_update_form', function($modal){
                    $modal->pause(5000)
                        ->type('div > div:nth-child(4) > div > input', '200')
                        ->click('#save_button_parent')
                        ->assertPathIs('/wallet/my-withdraw-requests');

                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Withdraw Request has been modified Successfully!');
        });
    }


}
