@extends('front_end.layouts.app')
@section('page-title')
    {{ ucfirst($page->page_name ?? __('Home Page')) }}
@endsection
<style>
    .padding-top {
        padding-top: 185px !important;
    }
</style>
@section('content')
    @include('front_end.sections.partision.header_section')
    @php
        $theme_favicon = \App\Models\Utility::GetValueByName('theme_favicon', $store->id);
        $theme_favicons = get_file($theme_favicon);
        $theme_logo = \App\Models\Utility::GetValueByName('theme_logo', $store->id);
        $theme_logo = get_file($theme_logo);
        $currantLang = Cookie::get('LANGUAGE');
        if (!isset($currantLang)) {
            $currantLang = $store->default_language;
        }
    @endphp
    <div class="padding-top order-details">
        <div class="container">
            <div class="row">
                <div class="col-xl-12 col-12">
                    <div class="common-banner-content">
                        <div class="row">
                            <div class="col-xl-5">
                                <div class="section-title">
                                    <h2>{{ __('Your Order Details') }}</h2>
                                </div>
                            </div>
                            <div class="col-xl-7">
                                <div class="gap-1 d-flex all-button-box justify-content-md-end justify-content-end text-end">
                                    @if (module_is_active('AutomaticOrderPrinting'))
                                        @stack('invoice-button')
                                    @else
                                        <a href="{{ route('shippinglabel.pdf', \Illuminate\Support\Facades\Crypt::encrypt($order['id'])) }}"
                                            target="_blank" class="btn btn-sm btn-primary btn-icon align-items-center"
                                            data-bs-toggle="tooltip" data-bs-placement="top" title="Print"
                                            aria-label="Print">
                                            <i class="ti ti-printer" style="font-size:20px"></i>
                                        </a>
                                    @endif
                                    <span class="btn btn-sm btn-secondary" style="margin-left: 5px; pointer-events: none;">
                                        {{ $order['order_status_text'] }}
                                    </span>

                                    @if (
                                        $order['payment_status'] == 'Unpaid' &&
                                            $order['order_status_text'] != 'Cancel' &&
                                            $order_data['delivered_status'] == 0)
                                        <a class="delstatus btn btn-sm btn-primary me-2 " style="margin-left: 5px"
                                            data-id="{{ $order['id'] }}">
                                            <i class="ti ti-trash " style="font-size:20px"></i>
                                            <span class="btn-inner--text text-white">{{ __('Order Cencel') }}</span>
                                        </a>
                                    @endif
                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <section class="product-listing-section">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="row order-details-modal product-modal-detail" id="printableArea">
                            <div class="col-xxl-7 col-md-6 col-12">
                                <div class="card">
                                    <div class="card-header d-flex justify-content-between">
                                        <p class="mb-0"><b>{{ __('Items from Order') }} {{ $order['order_id'] }}</b>
                                        </p>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table">
                                                <thead>
                                                    <tr>
                                                        <th>{{ __('Item') }}</th>
                                                        <th>{{ __('Quantity') }}</th>
                                                        <th>{{ __('Total') }}</th>
                                                        @if ($order['order_status'] == 1 && $order['is_guest'] == 0)
                                                            <th>{{ __('Return') }}</th>
                                                        @endif
                                                        @if ($order['order_status'] == 1)
                                                            <th>{{ __('Downloadable Product') }}</th>
                                                        @endif
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($order['product'] as $item)
                                                        @php
                                                            $download_prod = \App\Models\ProductVariant::where(
                                                                'id',
                                                                $item['variant_id'],
                                                            )->first();
                                                            $download_product = \App\Models\Product::where(
                                                                'id',
                                                                $item['product_id'],
                                                            )->first();
                                                        @endphp
                                                        <tr>
                                                            <td class="total">
                                                                <span class="p text-sm"> <a
                                                                        href="#">{{ $item['name'] }}</a> </span>
                                                                <br>
                                                                <span class="text-sm"> {{ $item['variant_name'] }}
                                                                </span>
                                                            </td>
                                                            <td>
                                                                @if ($order['paymnet_type'] == 'POS')
                                                                    {{ $item['quantity'] }}
                                                                @else
                                                                    {{ $item['qty'] }}
                                                                @endif
                                                            </td>
                                                            <td>
                                                                @if ($order['paymnet_type'] == 'POS')
                                                                    {{ currency_format_with_sym($item['orignal_price'] ?? 0, $store->id) ?? SetNumberFormat($item['orignal_price']) }}
                                                                @else
                                                                    {!! \App\Models\Product::ManageProductPrice($item, $store) !!}
                                                                @endif
                                                            </td>
                                                            @if ($order['order_status'] == 1 && $order['is_guest'] == 0)
                                                                <td> - </td>
                                                            @endif
                                                            @if ($order['order_status_text'] == 'Delivered')
                                                                @if (!empty($download_prod->downloadable_product) || !empty($download_product->downloadable_product))
                                                                    <td>
                                                                        <div class="detail-bottom">
                                                                            @if (!empty($download_product->downloadable_product))
                                                                                <a class="download_prod_{{ $item['product_id'] }}"
                                                                                    href="{{ get_file($download_product->downloadable_product) }}"
                                                                                    download style="display: none;"></a>
                                                                            @endif
                                                                            @if (!empty($download_prod->downloadable_product))
                                                                                <a class="download_prod_{{ $item['product_id'] }}"
                                                                                    href="{{ get_file($download_prod->downloadable_product) }}"
                                                                                    download style="display: none;"></a>
                                                                            @endif
                                                                            <a class="btn cart-btn downloadable_product_variant"
                                                                                href="{{ get_file($download_product->downloadable_product) }}"
                                                                                data-product-id="{{ $item['product_id'] }}"
                                                                                download>{{ __('Download') }}
                                                                                <i class="fas fa-shopping-basket"></i></a>
                                                                        </div>
                                                                    </td>
                                                                @endif
                                                            @endif
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 col-sm-12 col-lg-6 ">
                                        <div class="card">
                                            <div class="card-header d-flex justify-content-between">
                                                <b class="">{{ __('Shipping Information') }}</b>
                                            </div>
                                            <div class="card-body pt-0" style="overflow: auto;">
                                                <address class="mb-0 text-sm">
                                                    <ul class="row mt-4 align-items-center">
                                                        <li class="col-sm-5 col-6 text-sm"><b>{{ __('Name') }}</b></li>
                                                        <li class="col-sm-7 col-6 text-sm">
                                                            {{ !empty($order['delivery_informations']['name']) ? $order['delivery_informations']['name'] : '' }}
                                                        </li>
                                                        <li class="col-sm-5 col-6 text-sm"><b>{{ __('Email') }}</b></li>
                                                        <li class="col-sm-7 col-6 text-sm">
                                                            {{ !empty($order['delivery_informations']['email']) ? $order['delivery_informations']['email'] : '' }}
                                                        </li>
                                                        <li class="col-sm-5 col-6 text-sm"><b>{{ __('City') }}</b></li>
                                                        <li class="col-sm-7 col-6 text-sm">
                                                            {{ !empty($order['delivery_informations']['city']) ? $order['delivery_informations']['city'] : '' }}
                                                        </li>
                                                        <li class="col-sm-5 col-6 text-sm"><b>{{ __('State') }}</b></li>
                                                        <li class="col-sm-7 col-6 text-sm">
                                                            {{ !empty($order['delivery_informations']['state']) ? $order['delivery_informations']['state'] : '' }}
                                                        </li>
                                                        <li class="col-sm-5 col-6 text-sm"><b>{{ __('Country') }}</b></li>
                                                        <li class="col-sm-7 col-6 text-sm">
                                                            {{ !empty($order['delivery_informations']['country']) ? $order['delivery_informations']['country'] : '' }}
                                                        </li>
                                                        <li class="col-sm-5 col-6 text-sm"><b>{{ __('Postal Code') }}</b>
                                                        </li>
                                                        <li class="col-sm-7 col-6 text-sm">
                                                            {{ !empty($order['delivery_informations']['post_code']) ? $order['delivery_informations']['post_code'] : '' }}
                                                        </li>
                                                        <li class="col-sm-5 col-6 text-sm"><b>{{ __('Phone') }} </b></li>
                                                        <li class="col-sm-7 col-6 text-sm">
                                                            <a href="https://api.whatsapp.com/send?phone={{ !empty($order['delivery_informations']['phone']) ? $order['delivery_informations']['phone'] : '' }}&amp;text=Hi"
                                                                target="_blank">
                                                                {{ !empty($order['delivery_informations']['phone']) ? $order['delivery_informations']['phone'] : '' }}
                                                            </a>
                                                        </li>

                                                    </ul>
                                                </address>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-sm-12 col-lg-6 ">
                                        <div class="card">
                                            <div class="card-header d-flex justify-content-between">
                                                <b class="">{{ __('Billing Information') }}</b>
                                            </div>
                                            <div class="card-body pt-0" style="overflow: auto;">
                                                <address class="mb-0 text-sm">
                                                    <ul class="row mt-4 align-items-center">
                                                        <li class="col-sm-5 col-6 text-sm"><b>{{ __('Name') }}</b></li>
                                                        <dd class="col-sm-7 col-6 text-sm pb-2">
                                                            {{ !empty($order['billing_informations']['name']) ? $order['billing_informations']['name'] : '' }}
                                                        </dd>
                                                        <li class="col-sm-5 col-6 text-sm"><b>{{ __('Email') }}</b></li>
                                                        <dd class="col-sm-7 col-6 text-sm">
                                                            {{ !empty($order['billing_informations']['email']) ? $order['billing_informations']['email'] : '' }}
                                                        </dd>
                                                        <li class="col-sm-5 col-6 text-sm"><b>{{ __('City') }}</b></li>
                                                        <dd class="col-sm-7 col-6 text-sm">
                                                            {{ !empty($order['billing_informations']['city']) ? $order['billing_informations']['city'] : '' }}
                                                        </dd>
                                                        <li class="col-sm-5 col-6 text-sm"><b>{{ __('State') }}</b></li>
                                                        <dd class="col-sm-7 col-6 text-sm">
                                                            {{ !empty($order['billing_informations']['state']) ? $order['billing_informations']['state'] : '' }}
                                                        </dd>
                                                        <li class="col-sm-5 col-6 text-sm"><b>{{ __('Country') }}</b></li>
                                                        <dd class="col-sm-7 col-6 text-sm">
                                                            {{ !empty($order['billing_informations']['country']) ? $order['billing_informations']['country'] : '' }}
                                                        </dd>
                                                        <li class="col-sm-5 col-6 text-sm"><b>{{ __('Postal Code') }}</b>
                                                        </li>
                                                        <dd class="col-sm-7 col-6 text-sm">
                                                            {{ !empty($order['billing_informations']['post_code']) ? $order['billing_informations']['post_code'] : '' }}
                                                        </dd>
                                                        <li class="col-sm-5 col-6 text-sm"><b>{{ __('Phone') }}</b></li>
                                                        <li class="col-sm-7 col-6 text-sm">
                                                            <a href="https://api.whatsapp.com/send?phone={{ !empty($order['billing_informations']['phone']) ? $order['billing_informations']['phone'] : '' }}&amp;text=Hi"
                                                                target="_blank">
                                                                {{ !empty($order['billing_informations']['phone']) ? $order['billing_informations']['phone'] : '' }}
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </address>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                    <span class="text-danger"><b>{{ __('Note') }} :</b></span>
                                    <span class="text-start ps-3"><p>{{ $order['additional_note'] ?? ($order['payment_comment'] ?? '-') }}</p></span>
                                    </div>
                                </div>
                                @stack('showdigitalproductattachment')
                                @stack('CheckoutAttachment')
                                @stack('ViewAdditionalFields')
                            </div>
                            <div class="col-xxl-5 col-md-6 col-12">
                                <div class="card  p-0">
                                    <div class="card-header d-flex justify-content-between pb-0">
                                        <b class="mb-4">{{ __('Extra Information') }}</b>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table">
                                                <tbody>
                                                    <tr>
                                                        <td>{{ __('Sub Total') }} :</td>
                                                        <td>{{ currency_format_with_sym($order['sub_total'] ?? 0, $store->id) ?? SetNumberFormat($order['sub_total']) }}
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>{{ __('Estimated Tax') }} :</td>
                                                        <td>
                                                            @if ($order['paymnet_type'] == 'POS')
                                                                {{ currency_format_with_sym($order['tax_price'] ?? 0, $store->id) ?? SetNumberFormat($order['tax_price']) }}
                                                            @else
                                                                {{-- {{ SetNumberFormat(array_sum(array_column($order['tax'], 'amountstring'))) }} --}}
                                                                {{ currency_format_with_sym($order['tax_price'] ?? 0, $store->id) ?? SetNumberFormat($order['tax_price']) }}
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    @if ($order['paymnet_type'] == 'POS')
                                                        <tr>
                                                            <td>{{ __('Discount') }} :</td>
                                                            <td>{{ !empty($order['coupon_price']) ? currency_format_with_sym($order['coupon_price'] ?? 0, $store->id) ?? SetNumberFormat($order['coupon_price']) : SetNumberFormat(0) }}
                                                            </td>
                                                        </tr>
                                                    @else
                                                        <tr>
                                                            <td>{{ __('Apply Coupon') }} :</td>
                                                            <td>{{ !empty($order['coupon_info']['discount_amount']) ? currency_format_with_sym($order['coupon_info']['discount_amount'] ?? 0, $store->id) ?? currency_format_with_sym($order['coupon_info']['discount_amount'] ?? 0, $store->id) : currency_format_with_sym(0, $store->id) }}
                                                            </td>
                                                        </tr>
                                                    @endif
                                                    @stack('savePriceShowOrderPage')
                                                    <tr>
                                                        <td>{{ __('Delivered Charges') }} :</td>
                                                        <td>{{ currency_format_with_sym($order['delivered_charge'] ?? 0, $store->id) ?? SetNumberFormat($order['delivered_charge']) }}
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>{{ __('Grand Total') }} :</td>
                                                        <td><b>{{ currency_format_with_sym($order['final_price'] ?? 0, $store->id) ?? SetNumberFormat($order['final_price']) }}</b>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>{{ __('Payment Type') }} :</td>
                                                        <td> {{ $order['paymnet_type'] }} </td>
                                                    </tr>
                                                    <tr>
                                                        <td>{{ __('Order Status') }} :</td>
                                                        <td>{{ $order['order_status_text'] }}</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                @if (!empty($order_note))
                                    <div class="card">
                                        <div class="card-header d-flex justify-content-between">
                                            <p class="mb-0"><b>{{ __('Order updates for') }}
                                                    {{ $order['order_id'] }}</b>
                                            </p>
                                        </div>
                                        <div class="card-body">
                                            @php
                                                $i = 1;
                                            @endphp
                                            @foreach ($order_note as $note)
                                                <div class="card">
                                                    <div class="card-header">
                                                        <span class="time">
                                                            {{ $i }} .
                                                            {{ $note->created_at->format('l jS \\of F Y, h:ia') }}
                                                        </span>
                                                        <span class="tl-btn licence-btn">
                                                            {{ $note->notes }}
                                                        </span>
                                                    </div>
                                                </div>
                                                @php
                                                    $i++;
                                                @endphp
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                                @stack('OrderPartialPaymentView')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <div class="social-media">
            @if (isset($section->footer->section->footer_link))
                <div class="container">
                    <ul class="social-links justify-content-end">
                        @for ($i = 0; $i < $section->footer->section->footer_link->loop_number ?? 1; $i++)
                            <li>
                                <a href="{{ $section->footer->section->footer_link->social_link->{$i} ?? '#' }}"
                                    target="_blank" id="social_link_{{ $i }}">
                                    <img src="{{ asset($section->footer->section->footer_link->social_icon->{$i}->image ?? 'themes/' . $currentTheme . '/assets/images/youtube.svg') }}"
                                        class="{{ 'social_icon_' . $i . '_preview' }}" alt="icon"
                                        id="social_icon_{{ $i }}">
                                </a>
                            </li>
                        @endfor
                    </ul>
                </div>
            @endif
        </div>
    </div>
    @include('front_end.sections.partision.footer_section')
@endsection
@push('scripts')
    <script>
        var filename = $('#filesname').val();

        function saveAsPDF() {
            var element = document.getElementById('printableArea');
            var opt = {
                margin: 0.3,
                filename: filename,
                image: {
                    type: 'jpeg',
                    quality: 1
                },
                html2canvas: {
                    scale: 4,
                    dpi: 72,
                    letterRendering: true
                },
                jsPDF: {
                    unit: 'in',
                    format: 'A2'
                }
            };
            html2pdf().set(opt).from(element).save();


        }
        $(document).on('click', '.delstatus', function() {

            var order_id = $(this).attr('data-id');
            var data = {
                order_id: order_id,
                order_status: 'cancel',
            }
            $.ajax({
                url: '{{ route('status.cancel', $store->slug) }}',
                data: data,
                type: 'post',
                success: function(data) {
                    $('#loader').fadeOut();
                    if (data.status == 'error') {
                        show_toastr('{{ __('Error') }}', data.message, 'error')
                    } else {
                        show_toastr('{{ __('Success') }}', data.message, 'success')
                        setTimeout(function() {
                            location.reload();
                        }, 2000);
                    }
                }
            });
        });

        document.querySelectorAll('.downloadable_product_variant').forEach(button => {
            button.addEventListener('click', function() {
                const productId = this.getAttribute('data-product-id');
                const downloadLink = document.querySelector('.download_prod_' + productId);
                if (downloadLink) {
                    downloadLink.click();
                } else {
                    console.error('Download link not found for product ID:', productId);
                }
            });
        });
    </script>
@endpush
