@extends('layouts.app')

@section('page-title', __('Theme Customize'))

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('theme.index') }}">{{ __('Themes') }}</a></li>
 <li class="breadcrumb-item">{{ __('Pages') }}</li>
@endsection


@section('content')
<div class="card customize-card">
    <div class="card-header p-3">
        <h2 class="h3">{{ $theme }}</h2>
        <span>{{ __('Organize and adjust all settings about') }} {{ $theme }}.</span>
    </div>
    <div class="card-body p-3">
        <div class="row row-gap-2">
            @foreach ($page_json as $page)
            <div class="col-xxl-4 col-sm-6 col-12">
                <div class="card mb-0 h-100 p-3">
                    <div class="card-header p-0 border-0 mb-4">
                        <h2 class="h4">{{ $page['title'] }}</h2>
                        <p class="fs-5 text-muted mb-0">{{ $page['detail'] }}</p>
                    </div>
                    <div class="card-body p-0 d-flex align-items-center justify-content-between">
                        <div class="card-icon-wrp flex-1 position-relative">
                            <div
                                class="card-icon bg-primary p-2 rounded-circle d-flex align-items-center justify-content-center">
                                <span><svg width="30" height="30" viewBox="0 0 30 30" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M3.28125 8.67197H5.19742C5.15179 8.75065 5.13006 8.84092 5.1349 8.93174C5.13975 9.02257 5.17094 9.11002 5.22469 9.1834C5.29892 9.28263 5.4091 9.3488 5.53158 9.36769C5.65405 9.38659 5.77906 9.35671 5.87974 9.28446L6.83945 8.58134C6.89889 8.53782 6.94723 8.48091 6.98056 8.41521C7.01388 8.34952 7.03125 8.27689 7.03125 8.20322C7.03125 8.12956 7.01388 8.05693 6.98056 7.99123C6.94723 7.92554 6.89889 7.86862 6.83945 7.82511L5.87974 7.12199C5.79302 7.05836 5.68704 7.02652 5.57961 7.03182C5.47218 7.03712 5.36984 7.07923 5.2898 7.15108C5.20976 7.22293 5.15689 7.32014 5.14007 7.42638C5.12325 7.53262 5.1435 7.64141 5.19743 7.73447H3.28125C3.15693 7.73447 3.0377 7.78386 2.94979 7.87177C2.86189 7.95967 2.8125 8.0789 2.8125 8.20322C2.8125 8.32754 2.86189 8.44677 2.94979 8.53468C3.0377 8.62259 3.15693 8.67197 3.28125 8.67197Z"
                                            fill="white" />
                                        <path
                                            d="M28.5703 2.57812H6.70546C5.88046 2.57812 5.15624 3.24375 5.15624 4.00312V6.16875C5.30053 6.12015 5.45164 6.09484 5.6039 6.09375C5.90248 6.09293 6.19339 6.18826 6.43358 6.36562L7.39452 7.06875C7.57271 7.19948 7.71756 7.37038 7.81733 7.56758C7.9171 7.76478 7.96897 7.98272 7.96875 8.20372C7.96852 8.42472 7.91619 8.64255 7.81602 8.83954C7.71584 9.03653 7.57063 9.20713 7.39218 9.3375L6.43358 10.0406C6.252 10.1734 6.04108 10.2604 5.81872 10.2942C5.59636 10.3281 5.36911 10.3078 5.15624 10.2352V14.7656H1.31249C0.952197 14.7787 0.61178 14.9341 0.365782 15.1977C0.119784 15.4612 -0.0117472 15.8115 -9.15996e-06 16.1719V24.3492C-9.15996e-06 26.0438 1.26093 27.4219 2.81249 27.4219H28.5703C28.9487 27.4218 29.3116 27.2718 29.5795 27.0047C29.8475 26.7376 29.9987 26.3752 30 25.9969V4.00312C29.9987 3.62478 29.8475 3.26236 29.5795 2.99527C29.3116 2.72817 28.9487 2.57817 28.5703 2.57812ZM5.15624 24.3492C5.15624 25.5258 4.31483 26.4844 3.28124 26.4844H2.81249C1.7789 26.4844 0.937491 25.5258 0.937491 24.3492V16.1719C0.928027 16.0606 0.961657 15.9499 1.03144 15.8627C1.10122 15.7754 1.20183 15.7183 1.31249 15.7031H5.15624V24.3492ZM8.43749 6.5625C8.43785 6.43829 8.48736 6.31927 8.57519 6.23144C8.66301 6.14362 8.78203 6.09411 8.90624 6.09375H26.25C26.3742 6.09411 26.4932 6.14362 26.581 6.23144C26.6689 6.31927 26.7184 6.43829 26.7187 6.5625V9.84375C26.7184 9.96796 26.6689 10.087 26.581 10.1748C26.4932 10.2626 26.3742 10.3121 26.25 10.3125H8.90624C8.78203 10.3121 8.66302 10.2626 8.57519 10.1748C8.48736 10.087 8.43786 9.96796 8.43749 9.84375V6.5625ZM8.43749 13.125C8.43785 13.0008 8.48736 12.8818 8.57519 12.7939C8.66301 12.7061 8.78203 12.6566 8.90624 12.6562H14.0625C14.1867 12.6566 14.3057 12.7061 14.3935 12.7939C14.4814 12.8818 14.5309 13.0008 14.5312 13.125V17.8125C14.5309 17.9367 14.4814 18.0557 14.3935 18.1436C14.3057 18.2314 14.1867 18.2809 14.0625 18.2812H8.90624C8.78203 18.2809 8.66302 18.2314 8.57519 18.1436C8.48736 18.0557 8.43786 17.9367 8.43749 17.8125V13.125ZM26.7187 24.375H8.43749C8.31317 24.375 8.19394 24.3256 8.10603 24.2377C8.01813 24.1498 7.96874 24.0306 7.96874 23.9062C7.96874 23.7819 8.01813 23.6627 8.10603 23.5748C8.19394 23.4869 8.31317 23.4375 8.43749 23.4375H26.7187C26.8431 23.4375 26.9623 23.4869 27.0502 23.5748C27.1381 23.6627 27.1875 23.7819 27.1875 23.9062C27.1875 24.0306 27.1381 24.1498 27.0502 24.2377C26.9623 24.3256 26.8431 24.375 26.7187 24.375ZM26.7187 22.5H8.43749C8.31317 22.5 8.19394 22.4506 8.10603 22.3627C8.01813 22.2748 7.96874 22.1556 7.96874 22.0312C7.96874 21.9069 8.01813 21.7877 8.10603 21.6998C8.19394 21.6119 8.31317 21.5625 8.43749 21.5625H26.7187C26.8431 21.5625 26.9623 21.6119 27.0502 21.6998C27.1381 21.7877 27.1875 21.9069 27.1875 22.0312C27.1875 22.1556 27.1381 22.2748 27.0502 22.3627C26.9623 22.4506 26.8431 22.5 26.7187 22.5ZM26.7187 18.75H16.875C16.7507 18.75 16.6314 18.7006 16.5435 18.6127C16.4556 18.5248 16.4062 18.4056 16.4062 18.2812C16.4062 18.1569 16.4556 18.0377 16.5435 17.9498C16.6314 17.8619 16.7507 17.8125 16.875 17.8125H26.7187C26.8431 17.8125 26.9623 17.8619 27.0502 17.9498C27.1381 18.0377 27.1875 18.1569 27.1875 18.2812C27.1875 18.4056 27.1381 18.5248 27.0502 18.6127C26.9623 18.7006 26.8431 18.75 26.7187 18.75ZM26.7187 16.875H16.875C16.7507 16.875 16.6314 16.8256 16.5435 16.7377C16.4556 16.6498 16.4062 16.5306 16.4062 16.4062C16.4062 16.2819 16.4556 16.1627 16.5435 16.0748C16.6314 15.9869 16.7507 15.9375 16.875 15.9375H26.7187C26.8431 15.9375 26.9623 15.9869 27.0502 16.0748C27.1381 16.1627 27.1875 16.2819 27.1875 16.4062C27.1875 16.5306 27.1381 16.6498 27.0502 16.7377C26.9623 16.8256 26.8431 16.875 26.7187 16.875ZM26.7187 15H16.875C16.7507 15 16.6314 14.9506 16.5435 14.8627C16.4556 14.7748 16.4062 14.6556 16.4062 14.5312C16.4062 14.4069 16.4556 14.2877 16.5435 14.1998C16.6314 14.1119 16.7507 14.0625 16.875 14.0625H26.7187C26.8431 14.0625 26.9623 14.1119 27.0502 14.1998C27.1381 14.2877 27.1875 14.4069 27.1875 14.5312C27.1875 14.6556 27.1381 14.7748 27.0502 14.8627C26.9623 14.9506 26.8431 15 26.7187 15ZM26.7187 13.125H16.875C16.7507 13.125 16.6314 13.0756 16.5435 12.9877C16.4556 12.8998 16.4062 12.7806 16.4062 12.6562C16.4062 12.5319 16.4556 12.4127 16.5435 12.3248C16.6314 12.2369 16.7507 12.1875 16.875 12.1875H26.7187C26.8431 12.1875 26.9623 12.2369 27.0502 12.3248C27.1381 12.4127 27.1875 12.5319 27.1875 12.6562C27.1875 12.7806 27.1381 12.8998 27.0502 12.9877C26.9623 13.0756 26.8431 13.125 26.7187 13.125Z"
                                            fill="white" />
                                        <defs>
                                            <clipPath id="clip0_5312_4647">
                                                <rect width="30" height="30" fill="white" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </span>
                            </div>
                        </div>
                        <div class="btn-group position-relative theme-customize-iteam">
                            <button type="button" class="btn dropdown-toggle d-flex align-items-center gap-2"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                {{ __('Change Setting') }}
                                <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" version="1.2" viewBox="0 0 10 5" width="10"
                                        height="5">
                                        <path class="a"
                                            d="m5.4 5.1q-0.3 0-0.5-0.2l-3.7-3.7c-0.3-0.3-0.3-0.7 0-1 0.2-0.3 0.7-0.3 0.9 0l3.3 3.2 3.2-3.2c0.2-0.3 0.7-0.3 0.9 0 0.3 0.3 0.3 0.7 0 1l-3.7 3.7q-0.2 0.2-0.4 0.2z">
                                        </path>
                                    </svg>
                                </span>
                            </button>
                            <div class="dropdown-menu dropdown-menu-end"
                                data-popper-placement="bottom-end"
                                >

                                <a href="{{ route('theme.customize', [$theme, $page['slug']]) }}" class="dropdown-item">
                                    <i class="ti ti-adjustments me-2"></i>
                                    <span>{{ __('Edit') }}</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>
@endsection

@push('scripts')
@endpush