import { defineConfig } from "vite";
import laravel from "laravel-vite-plugin";
import path from "path";



export default defineConfig({
    plugins: [
        laravel({
            input: [
                "themes/stylique/sass/app.scss",
                "themes/stylique/js/app.js"
            ],
            buildDirectory: "stylique",
        }),
        
        
        {
            name: "blade",
            handleHotUpdate({ file, server }) {
                if (file.endsWith(".blade.php")) {
                    server.ws.send({
                        type: "full-reload",
                        path: "*",
                    });
                }
            },
        },
    ],
    resolve: {
        alias: {
            '@': '/themes/stylique/js',
            '~bootstrap': path.resolve('node_modules/bootstrap'),
        }
    },
    
});
